#!/bin/bash
USERNAME='root'
INSTALLATION='---INTALLATION_NAME---'
ROOTDNSNAME='---ROOTDNS---'
HOSTNAME="${INSTALLATION}.${ROOTDNSNAME}"

#Some defines
RED='\033[0;31m'
GREEN='\033[0;32m'
BLUE='\033[0;34m'
YELLOW='\033[1;33m'
NC='\033[0m' 

tgl=$(date +'%Y-%m-%dT%H%M')

if [ "$EUID" -ne 0 ]; then
  echo "ERROR: Please run as root with sudo" >&2
  exit 1
fi

#Perform full backup
echo Perfrom archivce backup of $INSTALLATION
DIR1="/tmp/nValuate/${INSTALLATION}"
mkdir -p $DIR1 
BACKUPDIR="${DIR1}/backup${tgl}"

echo Performing Full Backup to $BACKUPDIR
mkdir -p $BACKUPDIR
mkdir -p ${BACKUPDIR}/sql
cp -rT /var/www/html/${INSTALLATION} $BACKUPDIR
sudo mysqldump ${INSTALLATION} > ${BACKUPDIR}/sql/fullDBbackup.sql
mkdir -p ${BACKUPDIR}/docstore
cp -rT /docstore/${INSTALLATION} ${BACKUPDIR}/doclist
tar -cvzf ${DIR1}/backup.tar $BACKUPDIR
echo Full backup is available: file ${DIR1}/backup.tar
rm -r $BACKUPDIR


echo Now Uninstall $INSTALLATION
#remove datatbase
echo "DROP DATABASE"
mysql -e "DROP DATABASE IF EXISTS ${INSTALLATION}"
echo "DROP DATABASE USER"
MYSQLUSERNAME=$(/etc/vault/getKey -s $INSTALLATION -k DATABASE_USER)
mysql -e "DROP USER IF EXISTS '${MYSQLUSERNAME}'"

#remove web files
echo "REMOVE WEB FILES"
rm -r /var/www/html/${INSTALLATION}

#disable apache web site
APACHESITNAME1=${HOSTNAME}
APACHESITNAME2=${HOSTNAME}-le-ssl 
a2dissite ${APACHESITNAME1}
a2dissite ${APACHESITNAME2}
if [ -e "/etc/apache2/sites-available/${APACHESITNAME1}.conf" ]; then
	rm /etc/apache2/sites-available/${APACHESITNAME1}.conf
	echo Removed /etc/apache2/sites-available/${APACHESITNAME1}.conf
fi
if [ -e "/etc/apache2/sites-available/${APACHESITNAME2}.conf" ]; then
	rm /etc/apache2/sites-available/${APACHESITNAME2}.conf
	echo Removed /etc/apache2/sites-available/${APACHESITNAME2}.conf
fi

systemctl reload apache2

#remove docstore
rm -r /docstore/${INSTALLATION}

#remove from /var/nValuate
rm -r /var/nvaluate/${INSTALLATION}

#remove keys
vault deleteshelf -s $INSTALLATION

#remove backup script
BACKUPFILE="/etc/nvaluate/bin/Backup.sh"
sed -i "s:\"${INSTALLATION}\" : :" ${BACKUPFILE}