<?php

define('OPT_FIELD_TRIM',1);
define('OPT_FIELD_REQUIRED',2);
define('OPT_FIELD_OUTPUT_HTML',4);

define ('WIZARD_PAGE_NEXT',1);
define ('WIZARD_PAGE_BACK',2);
define ('WIZARD_PAGE_FINISH',4);

class formField
{
    protected $_type;
    protected $_name;
    protected $_value;
    protected $_options;
    public $value;

    function __construct($type,$name=null,$value=null,$options=null)
    {
        $this->_type = $type;
        $this->_name = $name;
        $this->_value = $value;
        $this->_options = $options;
        $this->value = $value;
    }

    static function buildAttributesFromArray($a)
    {
        $attr = array();
        if ( isset($a['form']) )
        {
            $form = $a['form'];
            if (isset ($form['size']))
                $attr['size'] = $form['size'];
            if (isset ($form['maxlength']))
                $attr['maxlength'] = $form['maxlength'];
            return $attr;
        }
        return null;
    }

    static public function createFromArray($name,$a,$value=null)
    {
        if (! isset ($a['type']) )
            throw (new Exception("formField createFromArray:: No type sepcified in array"));

        $attributes = formField::buildAttributesFromArray($a);

        switch ($a['type'])
        {
            case "text":
                return new textField($a ['form'] ['formlabel'],$name,$value,$attributes);
            case "integer":
                return new integerField($a ['form'] ['formlabel'],$name,$value,$attributes);
            case "percent":
                return new percentField($a ['form'] ['formlabel'],$name,$value,$attributes);
        }
    }

    protected function isOptionSet($option)
    {
        if ($this->_options)
            return (intval($option) & $this->_options) ? true : false;
        return false;
    }

    protected function getValue()
    {
        if (isset($_POST[$this->_name]))
        {
            $v = $_POST[$this->_name];
            if ( $this->isOptionSet(OPT_FIELD_TRIM) )
                $v = trim($v);
            $v = stripslashes($v);
            $v = strip_tags(htmlspecialchars_decode($v));
            return $v;
        }
        return null;
    }

    public function getName()
    {
        return $this->_name;
    }
}

class textField extends formField
{
    private $_label;
    private $_attributes;

    function __construct($label,$name,$value=null,$attributes=null,$options=OPT_FIELD_TRIM | OPT_FIELD_OUTPUT_HTML)
    {
        parent::__construct("text",$name,$value,$options);
        $this->_label = $label;

        if ($attributes && gettype($attributes) != "array")
            throw (new Exception("parameter attributes not an array"));

        $this->_attributes = $attributes;

        if ($this->isOptionSet(OPT_FIELD_OUTPUT_HTML))
            $this->outputHTML();

    }

    public function outputHTML()
    {
        echo "<div class='textFieldDiv'>";
        if ($this->_label)
            echo "<p class='inputheading'>{$this->_label}</p>";

        echo "<input";
        echo " class='wz_text'";
        if ($this->_name)
            echo " name='{$this->_name}'";
        if ($this->_value !== null)
            echo " value='{$this->_value}'";
        if ($this->_attributes)
        {
            foreach ($this->_attributes as $key => $attribute)
            {
                echo " {$key}='{$attribute}'";
            }
        }
        echo " />";
        echo "</div>";
    }

    public function getValue()
    {
        $v = parent::getValue();
        if ($v)
        {
            $this->_value = $v;
            $this->value = $v;
            return $this->_value;
        }
        return null;
    }
}

class integerField extends formField
{
    private $_label;
    private $_attributes;

    function __construct($label,$name,$value=null,$attributes=null,$options=OPT_FIELD_TRIM | OPT_FIELD_OUTPUT_HTML)
    {
        parent::__construct("text",$name,$value,$options);
        $this->_label = $label;

        if ($attributes && gettype($attributes) != "array")
            throw (new Exception("parameter attributes not an array"));

        $this->_attributes = $attributes;

        if ($this->isOptionSet(OPT_FIELD_OUTPUT_HTML))
            $this->outputHTML();
    }

    public function outputHTML()
    {
        echo "<div class='integerFieldDiv'>";
        if ($this->_label)
            echo "<p class='inputheading'>{$this->_label}</p>";

        echo "<input";
        echo " class='wz_integer'";
        if ($this->_name)
            echo " name='{$this->_name}'";
        if ($this->_value !== null)
        {
            $v = intval($this->_value);
            echo " value='{$v}'";
        }

        if ($this->_attributes)
        {
            foreach ($this->_attributes as $key => $attribute)
            {
                echo " {$key}='{$attribute}'";
            }
        }
        echo " />";

        echo "</div>";
    }

    public function getValue()
    {
        $r = parent::getValue();
        if ($r)
        {
            $this->_value = intval($r);
            $this->value = intval($r);
            return $this->_value;
        }
        return 0;
    }
}

class percentField extends formField
{
    private $_label;
    private $_attributes;

    function __construct($label,$name,$value=null,$attributes=null,$options=OPT_FIELD_TRIM | OPT_FIELD_OUTPUT_HTML)
    {
        parent::__construct("text",$name,$value,$options);
        $this->_label = $label;

        if ($attributes && gettype($attributes) != "array")
            throw (new Exception("parameter attributes not an array"));

        $this->_attributes = $attributes;

        if ($this->isOptionSet(OPT_FIELD_OUTPUT_HTML))
            $this->outputHTML();
    }

    public function outputHTML()
    {
        echo "<div class='percentFieldDiv'>";
        if ($this->_label)
            echo "<p class='inputheading'>{$this->_label}</p>";

        echo "<input";
        echo " class='wz_percent'";
        if ($this->_name)
            echo " name='{$this->_name}'";
        if ($this->_value !== null)
        {
            $v = trim(sprintf("%5.1f%%",$this->_value * 100.0));
            echo " value='{$v}'";
        }

        if ($this->_attributes)
        {
            foreach ($this->_attributes as $key => $attribute)
            {
                echo " {$key}='{$attribute}'";
            }
        }
        echo " />";

        echo "</div>";
    }

    public function getValue()
    {
        $r = parent::getValue();
        if ($r)
        {
            if (strpos($r,"%") !== false)
            {
                $v = str_replace("%","",$r);
                $v = floatval($v) / 100.0;
                $this->_value = $v;
                $this->value = $v;
                return $v;
            }
            $this->_value = floatval($r);
            $this->value = floatval($r);
            return floatval($this->_value);
        }
        return null;
    }
}

class Wizard
{

    function __construct()
    {

    }

    public function helpDescription($description='')
    {
        echo "<div class='wizdesccontainer'>";
        echo "<div class='wizhelp' title='Select for additional help' onclick='wiz.help(this)'>?</div>";
        echo "<div class='wizdesc'>";
        echo $description;
        echo "</div>";
        echo "</div>";
    }

    public function startPage($heading)
    {
        echo "<div class='step'>";
        echo "<h1>{$heading}</h1>";
    }

    public function endPage()
    {
        echo "</div>";
    }

    public function startForm($selff,$sec)
    {
        echo "<form method='post' action='{$selff}?v={$sec}'>";
    }

    public function endForm($stage,$options=WIZARD_PAGE_NEXT | WIZARD_PAGE_BACK)
    {
        echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}'>";

        echo "</div>";

        echo "<div class='wizardstepper'>";

        if ($options & WIZARD_PAGE_BACK)
            echo "<button class='progress' name='backstep' value='{$stage}' ><img src='/images/Button-Prev.png'/></button>";
        if ($options & WIZARD_PAGE_NEXT)
            echo "<button class= 'progress' name='nextstep' value='{$stage}' ><img src='/images/Button-Next.png'/></button>";

        echo "</form>";
    }
    /**
     * Summary of buildList
     * @param array $fields
     * @param array $records
     * @return bool True if there are records to display
     */
    public function buildList($stage,$heading,$fields,$records,$options=null)
    {
        $selff =  trim(htmlspecialchars($_SERVER["PHP_SELF"]),"/");
        if (count($records) > 0)
        {
            echo "<div class='list'>";
            echo "<h2>{$heading}</h2>";
            echo "<table>";
            echo "<tr>";
            foreach ($fields as $f)
            {
                if ( isset($f['list']) )
                {
                    echo "<th>";
                    if ( isset($f['list'] ['heading'] ) )
                        echo htmlspecialchars($f['list'] ['heading']);
                    echo "</th>";
                }
            }

            if ($options && isset($options["DELETEITEM"]) && $options["DELETEITEM"])
                echo "<th>ACTIONS</th>";

            echo "</tr>";

            foreach ($records as $rec)
            {
                echo "<tr>";
                foreach($fields as $f)
                {
                    if ( isset($f['list']) )
                    {
                        echo "<td";
                        if (isset($f['list'] ['class']) )
                            echo " class='{$f['list'] ['class']}'";
                        echo ">";

                        if (isset($f['dbfield']))
                        {
                            if ( isset($f['list'] ['anchor']) )
                            {
                                $href = "{$selff}?v=" . ESecure::sec_encryptParam("stage={$stage}&action=edit&id={$rec[$f['list'] ['anchor']]}&listselect=1",$_SESSION['session_key']);
                                echo "<a href='{$href}'>";
                            }
                            if (isset($rec[$f['dbfield']]))
                                echo htmlspecialchars($rec[$f['dbfield']]);
                            if ( isset($f['list'] ['anchor']) )
                            {
                                echo "</a>";
                            }
                        }
                        echo "</td>";
                    }
                }

                if ($options && isset($options["DELETEITEM"]) && $options["DELETEITEM"])
                    echo "<td><img src = '/images/Delete.png'</td>";
                echo "</tr>";
            }

            echo "</table>";

            if ($options)
            {
                if (isset($options["ADD"]))
                {
                    $href = "{$selff}?v=" . ESecure::sec_encryptParam("stage={$stage}&action=new",$_SESSION['session_key']);
                    echo "<button type='button' href='{$href}' onclick='wiz.goto(this)'>{$options["ADD"]}</button>";
                }
            }

            echo "</div>";

            return true;
        }
        return false;
    }

    public function buildPage($stage,$formdata,$rec,$action=null)
    {
        echo "<div class='form'>";
        if (! isset($_SESSION['wizard_fields'] ) )
        {
            $_SESSION['wizard_fields'] = array();
            $_SESSION['wizard_fields'] [$stage] = array();
        }
        else
            $_SESSION['wizard_fields'] [$stage] = array();

        foreach($formdata as $key => $f)
        {
            $v = null;
            if ($rec  && isset($f['dbfield']) && isset($rec[$f['dbfield']]) )
                $v = $rec[$f['dbfield']];
            $f = formField::createFromArray($key,$f,$v);
            $sf = serialize($f);
            array_push($_SESSION['wizard_fields'] [$stage],$sf);
        }
        if ($action && $action == "edit")
            echo "<button>CHANGE</button>";
        if ($action && $action == "new")
            echo "<button>CREATE</button>";
        echo "</div>";

    }

    public function recreate($stage)
    {
        if ( isset($_SESSION['wizard_fields'] ) && isset($_SESSION['wizard_fields'] [$stage] ))
        {
            foreach($_SESSION['wizard_fields'] [$stage] as $f)
            {
                (unserialize($f))->outputHTML();
            }
            return true;
        }
        return false;
    }
}
?>