<?php
//devt.Version = 1.0
require_once dirname(__FILE__) . '/classSQLPlus2.php';

/**
 * Summary of test
 */
class global1 extends TableRow
{
    function __construct($tabledata=null)
    {
        if ($tabledata)
            parent::__construct($tabledata);
        else
            parent::__construct
            (
                [
                    "global_title" => ["type" => "varchar"],
                    "global_app_instance" => ["type" => "varchar"],
                    "global_two_factor" => ["type" => "boolean"],
                    "global_disallow_shared_comments" =>["type" => "int"],
                    "global_max_signin_attempts" =>["type" => "int"],
                    "global_mins_noactivity" =>["type" => "int"],
                    "global_pw_min_length" =>["type" => "int"],
                    "global_pw_num_upper" =>["type" => "int"],
                    "global_pw_num_lower" =>["type" => "int"],
                    "global_pw_num_numbers" =>["type" => "int"],
                    "global_pw_num_nonalphanum" =>["type" => "int"],
                    "global_pw_renew_days" =>["type" => "int"],
                    "global_pw_previous" =>["type" => "int"],
                    "global_min_time_from_last" =>["type" => "int"]
                ]
            );
    }
}

class score extends TableRow
{
    function __construct($tabledata=null)
    {
        if ($tabledata)
            parent::__construct($tabledata);
        else
            parent::__construct
            (
                [
                    "idscore" =>["type" => "int"],
                    "score_user" =>["type" => "int"],
                    "score_evaluation" =>["type" => "int"],
                    "score_phase" =>["type" => "int"],
                    "score_respondent" =>["type" => "int"],
                    "score_question" =>["type" => "int"],
                    "score_subattribute" =>["type" => "int"],
                    "score_score" =>["type" => "int"],
                    "score_comment" =>["type" => "varchar"],
                    "user_name" => ["type" => "varchar"],
               ]
            );
    }
}

class EvaluateDB extends SQLPlus
{

    function __construct($params)
    {
        parent::__construct($params);
    }

    private function var_error_log( $object=null, $text='')
    {
        ob_start();
        var_dump( $object );
        $contents = ob_get_contents();
        ob_end_clean();
        error_log( "{$text} {$contents}" );
    }

    //*********************************************************************
    // Global
    //*********************************************************************
    public function getGlobal()
    {
        return $this->p_singlequery("SELECT * from global",null,null);
    }

    public function o_getGlobal()
    {
        return $this->o_singlequery("global1","SELECT * from global",null,null);
    }

    public function updateGlobal($title,$twofactor,$retry)
    {
        $t = $this->displayText($title);
        return $this->p_update("update global set global_title = ?, global_two_factor = ?, global_max_signin_attempts = ?","sii",$t,$twofactor,$retry);
    }

    //*********************************************************************
    // Dataroom
    //*********************************************************************
    public function getDataroom()
    {
        return $this->p_singlequery("SELECT * from dataroom",null,null);
    }

    //*********************************************************************
    // User
    //*********************************************************************
    public function getUser($id)
    {
        return $this->p_singlequery("SELECT * from user where iduser = ?","i",$id);
    }

    public function getUserByKey($key)
    {
        return $this->p_singlequery("SELECT * from user where user_apikey = ?","s",$key);
    }

    public function getUserByUserName($uname)
    {
        return $this->p_singlequery("SELECT * from user where user_username = ?","s",$uname);
    }

    public function getUserByEmail($email)
    {
        return $this->p_singlequery("SELECT * from user where user_email = ?","s",$email);
    }

    public function getUserByRand($rand)
    {
        return $this->p_singlequery("SELECT * from user where user_rand = ?","i",$rand);
    }

    public function getFirstUser()
    {
        return $this->p_singlequery("SELECT * from user order by iduser limit 1",null,null);
    }

    public function getUserFailCounter($userid)
    {
        $user = $this->getUser($userid);
        if ($user)
            return intval($user['user_failed_login_count']);
        else
            return 0;
    }

    public function userhasRand($userid)
    {
        $u = $this->getUser($userid);
        if (!is_null($u['user_rand']) && $u['user_rand'] != 0)
            return true;
        return false;
    }

    public function setUserRand($userid,$rnd)
    {
        return $this->p_update("update user set user_rand = ? where iduser = ?","ii",$rnd,$userid);
    }

    public function updateUserApiKey($id,$api_key)
    {
        return $this->p_update("update user set user_apikey = ? where iduser = ?","si",$api_key,$id);
    }

    public function updateUserHeartBeat($id,$count,$apicount)
    {
        $dt = new DateTime('now');
        $strTime = $dt->format('Y-m-d H:i:s');
        $c = intval($count);
        $d = intval($apicount);
        $ipaddr = '';
        if (isset($_SERVER['REMOTE_ADDR']))
            $ipaddr = $_SERVER['REMOTE_ADDR'];
        return $this->p_update("update user set user_last_heartbeat_time = ?, user_last_hearbeat_count = ?, user_last_heartbeat_ipaddress = ?, user_api_call_counter = ? where iduser = " . intval($id),"sisi",$strTime,$c,$ipaddr,$d);
    }

    public function updateUserApiCallCount($id,$apicount)
    {
        $d = intval($apicount);
        return $this->p_update("update user set user_api_call_counter = ? where iduser = " . intval($id),"i",$d);
    }

    public function createUser($name,$username,$hash,$salt,$security,$tz)
    {
        return $this->p_create("insert into user (user_name,user_username,user_passwordhash,user_salt,user_security,user_timezone,user_forcereset) values (?,?,?,?,?,?,true)","ssssis",$name,$username,$hash,$salt,$security,$tz);
    }

    public function updateUserBasic($id,$name,$phone,$email,$email_not,$text_not)
    {
        $n = $this->real_escape_string($name);
        $p = $this->real_escape_string($phone);
        $e = $this->real_escape_string($email);
        $en = 0;
        $tn = 0;
        if ($email_not)
            $en = 1;
        if ($text_not)
            $tn = 1;
        return $this->p_update("update user set user_name = ?, user_mobilephone = ?, user_email = ?, user_allow_email_notification = ?, user_allow_text_notification = ? where iduser = ?","sssiii",$n,$p,$e,$en,$tn,$id);
    }

    public function updatePassword($id,$hash,$salt,$renewdays=0)
    {
        $dtNow = new DateTime();
        $strNow = $dtNow->format('Y-m-d H:i:s');
        $strRenew = '';

        $u = $this->getUser($id);
        if ($u)
        {
            $prevhash = '';
            $prevsalt = '';
            if ($u['user_prev_hash'] )
                $prevhash = $u['user_prev_hash'];
            if ($u['user_prev_salt'] )
                $prevsalt = $u['user_prev_salt'];
            $prevhash = substr($hash . $prevhash,0,640);
            $prevsalt = substr($salt . $prevsalt,0,640);

            if ($renewdays > 0)
            {
                $dtRenew = new DateTime();
                $dtRenew->setTimestamp($dtRenew->getTimestamp() + (3600*24*$renewdays));
                $strRenew = $dtRenew->format('Y-m-d H:i:s');
                return $this->p_update("update user set user_passwordhash = ?, user_salt = ?, user_forcereset = false, user_pw_change_date = ?, user_pw_renew_date = ?, user_prev_hash = ?, user_prev_salt = ? where iduser = ?","ssssssi",$hash,$salt,$strNow,$strRenew,$prevhash,$prevsalt,$id);
            }
            else
                return $this->p_update("update user set user_passwordhash = ?, user_salt = ?, user_forcereset = false, user_pw_change_date = ?, user_pw_renew_date = null, user_prev_hash = ?, user_prev_salt = ? where iduser = ?","sssssi",$hash,$salt,$strNow,$prevhash,$prevsalt,$id);
        }
        else
            return false;
    }

    public function updateUserSecondFactorHash($userid,$hash)
    {
        $dt = new DateTime('now');
        $dt->setTimestamp($dt->getTimestamp() + (60*5));  //Make available for 5 minutes only
        $strExpire = $dt->format('Y-m-d H:i:s');
        return $this->p_update("update user set user_second_factor_hash = ?,  user_second_factor_expire = ? where iduser = ?","ssi",$hash,$strExpire,$userid);
    }

    public function updateUserFailCounter($userid)
    {
        return $this->p_update("update user set user_failed_login_count = user_failed_login_count + 1 where iduser = ?","i",$userid);
    }

    public function resetUserFailCounter($userid)
    {
        return $this->p_update("update user set user_failed_login_count = 0 where iduser = ?","i",$userid);
    }


    public function allUsers($order='')
    {
        $q = "SELECT iduser, user_name, user_username, user_security, user_timezone from user where user_deleted = 0 {$order}";
        $r = $this->p_query($q,null,null);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function countUsersWithNoPhone()
    {
        $q = "select * from user where CHAR_LENGTH(user_mobilephone) < 5 or user_mobilephone is null";
        $r = $this->p_query($q,null,null);
        if (!$r) {$this->sqlError($q); return null;}
        return $r->num_rows;
    }

    public function allEvaluators($order='')
    {
        $sec = intval(SECURITY_EVALUATE);
        $q = "SELECT iduser, user_name, user_username, user_security, user_timezone from user where user_deleted = 0 and (user_security & {$sec}) {$order}";
        $r = $this->p_query($q,null,null);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function numOfEvaluators()
    {
        $r = $this->allEvaluators($order='');
        if ($r)
            return $r->num_rows;
        return 0;
    }

    public function allAdministrators($order='')
    {
        $sec1 = intval(SECURITY_ADMIN);
        $sec2 = intval(SECURITY_ADMIN_CONFIGURE);
        $q = "SELECT iduser, user_name, user_username, user_security, user_timezone from user where user_deleted = 0 and ((user_security & {$sec1}) or (user_security & {$sec2})) {$order}";
        $r = $this->p_query($q,null,null);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function countEvaluators()
    {
        $r = $this->allEvaluators();
        if ($r)
            return $r->num_rows;
        return null;
    }

    public function countAdministrators()
    {
        $r = $this->allAdministrators();
        if ($r)
            return $r->num_rows;
        return null;
    }

    public function allDeletedUsers($order='')
    {
        $q = "SELECT iduser, user_name, user_username, user_security, user_timezone from user where user_deleted = 1 {$order}";
        $r = $this->p_query($q,null,null);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allUsersForEval($evalid)
    {
        $q = "select iduser, user_name from team_has_user left join team a on a.idteam = team_idteam left join user b on b.iduser = user_iduser where a.team_evaluation = ? group by iduser, user_name order by user_name";
        $r = $this->p_query($q,"i",$evalid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function seUserPhase($id,$phaseid)
    {
        return $this->p_update("update user set user_current_phase = ? where iduser = ?","ii",$phaseid,$id);
    }

    public function unsetUserPhase($iduser)
    {
        return $this->p_update("update user set user_current_phase = null where iduser = ?","i",$iduser);
    }

    public function deleteUser($id)
    {
        return $this->p_update("update user set user_deleted = 1 where iduser = ?","i",$id);
    }

    public function undeleteUser($id)
    {
        return $this->p_update("update user set user_deleted = 0 where iduser = ?","i",$id);
    }

    public function updateUserLastSiginIn($userid)
    {
        $strTime = (new DateTime('now'))->format('Y-m-d H:i:s');
        return $this->p_update("update user set user_lastlogin = ? where iduser = ?","si",$strTime,$userid);
    }

    //*********************************************************************
    // Evaluation
    //*********************************************************************
    public function getEvaluation($id)
    {
        return $this->p_singlequery("SELECT * from evaluation where idevaluation = ?","i",$id);
    }

    public function getLastEvaluation()
    {
        return $this->p_singlequery("SELECT * from evaluation order by idevaluation desc limit 1",null,null);
    }

    public function getFirstEvaluation()
    {
        return $this->p_singlequery("SELECT * from evaluation order by idevaluation limit 1",null,null);
    }

    public function allEvaluations($order='')
    {
        $q = "SELECT * from evaluation {$order}";
        $r = $this->p_query($q,null,null);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allEvaluationsForAll($dummy,$order='')
    {
        $q = "SELECT * from evaluation {$order}";
        $r = $this->p_query($q,null,null);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allEvaluationsForUser($userid)
    {
        $q = "SELECT team_evaluation from team_has_user left join team a on a.idteam = team_idteam where user_iduser = ? group by team_evaluation";
        $r = $this->p_query($q,"i",$userid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function createEvaluation($name,$weightings)
    {
        $esc_name = $this->real_escape_string(str_replace("\x92", "'", $name));
        return $this->p_create("insert into evaluation (evaluation_name,evaluation_total_weightings) values (?,?)","sd",$esc_name,$weightings);
    }

    public function numOfEvaluations()
    {
        $r = $this->allEvaluations();
        if ($r)
            return $r->num_rows;
        else
            return 0;
    }

    public function deleteEvaluation($id)
    {
        //We need to delete score that belong to the evaluation
        $this->p_delete("delete from score where score_evaluation = ?","i",$id);
        //We need to delete score that belong to the evaluation
        $this->p_delete("delete from respondent where respondent_evaluation = ?","i",$id);
        $r = $this->allQuestionsForEval($id);
        while ($question = $r->fetch_array())
        {
            $this->p_delete("delete from subattribute where subattribute_question = ?","i",$question['idquestion']);
            $this->p_delete("delete from team_has_question where question_idquestion = ?","i",$question['idquestion']);
        }
        //We need to delete questions that belong to the evaluation
        $this->p_delete("delete from question where question_evaluation = ?","i",$id);

        $r = $this->allTeamsForEval($id);
        while ($team = $r->fetch_array())
        {
            $this->p_delete("delete from team_has_question where team_idteam = ?","i",$team['idteam']);
            $this->p_delete("delete from team_has_user where team_idteam = ?","i",$team['idteam']);
        }
        $this->p_delete("delete from team where team_evaluation = ?","i",$id);

        //We need to delete sections that belong to the evaluation
        $this->p_delete("delete from section where section_evaluation = ?","i",$id);

        //For each eval phase delete user_has_phase
        $r = $this->allPhasesForEval($id);
        while ($phase = $r->fetch_array())
        {
            $this->p_delete("delete from user_has_phase where phase_idphase = ?","i",$phase['idphase']);
        }

        //Delete the phases
        $this->p_delete("delete from phase where phase_evaluation = ?","i",$id);

        //Delete the rules
        $this->p_delete("delete from rule where rule_evaluation = ?","i",$id);

        return $this->p_delete("delete from evaluation where idevaluation =  ?","i",$id);
    }

    //*********************************************************************
    // Phase
    //*********************************************************************
    public function getPhase($id)
    {
        return $this->p_singlequery("SELECT * from phase where idphase = ?","i",$id);
    }

    public function getPhaseWithRule($id)
    {
        return $this->p_singlequery("SELECT * from phase left join rule a on a.idrule = phase_rule where idphase = ?","i",$id);
    }

    public function getFinalPhase($evalid)
    {
        return $this->p_singlequery("SELECT * from phase where phase_evaluation = ? order by phase_order desc limit 1","i",$evalid);
    }

    public function allPhases($order='')
    {
        $q = "SELECT * from phase {$order}";
        $r = $this->p_query($q,null,null);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allPhasesForEval($evalid,$order='')
    {
        $q = "SELECT * from phase where phase_evaluation = ? {$order}";
        $r = $this->p_query($q,"i",$evalid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allPhasesForEvalWithRule($evalid,$order='')
    {
        $q = "SELECT * from phase left join rule a on a.idrule = phase_rule where phase_evaluation = ? {$order}";
        $r = $this->p_query($q,"i",$evalid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allPhasesForEvalEnabled($evalid,$order='')
    {
        $q = "SELECT * from phase left join rule a on a.idrule = phase_rule where phase_evaluation = ? and phase_status = 'enabled' {$order}";
        $r = $this->p_query($q,"i",$evalid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allPhasesForEvalStarted($evalid,$order='')
    {
        $q = "SELECT * from phase left join rule a on a.idrule = phase_rule where phase_evaluation = ? and phase_status <> 'defined' {$order}";
        $r = $this->p_query($q,"i",$evalid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allPhasesForEvalCompleted($evalid,$order='')
    {
        $q = "SELECT * from phase left join rule a on a.idrule = phase_rule where phase_evaluation = ? and phase_status = 'complete' {$order}";
        $r = $this->p_query($q,"i",$evalid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allSingleScorePhasesForEval($evalid,$order='')
    {
        $q = "SELECT * from phase left join rule a on a.idrule = phase_rule where phase_evaluation = ? and phase_single_score = 1 {$order}";
        $r = $this->p_query($q,"i",$evalid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allMultiScorePhasesForEval($evalid,$order='')
    {
        $q = "SELECT * from phase left join rule a on a.idrule = phase_rule where phase_evaluation = ? and phase_single_score = 0 {$order}";
        $r = $this->p_query($q,"i",$evalid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function createPhase($evalid,$phasename,$bSingle,$ruleid)
    {
        $esc_name = str_replace("\x92", "'", $phasename);
        if ($bSingle)
            return $this->p_create("insert into phase (phase_evaluation,phase_name,phase_single_score,phase_rule) values (?,?,true,?)","isi",$evalid,$esc_name,$ruleid);
        else
            return $this->p_create("insert into phase (phase_evaluation,phase_name,phase_single_score,phase_rule) values (?,?,false,?)","isi",$evalid,$esc_name,$ruleid);
    }

    public function setPhaseStatus($id,$status)
    {
        $phase = $this->getPhase($id);
        $strTime = (new DateTime('now'))->format('Y-m-d H:i:s');
        if ($status == "enabled" && !$phase['phase_start_timestamp'])
            return $this->p_update("update phase set phase_status = ?,  phase_start_timestamp = ? where idphase = ?","ssi",$status,$strTime,$id);
        if ($status == "complete" && !$phase['phase_complete_timestamp'])
            return $this->p_update("update phase set phase_status = ?,  phase_complete_timestamp = ? where idphase = ?","ssi",$status,$strTime,$id);
        if ($status == "complete" && $phase['phase_status'] != "complete")
            return $this->p_update("update phase set phase_status = ?,  phase_complete_timestamp = ? where idphase = ?","ssi",$status,$strTime,$id);
        return $this->p_update("update phase set phase_status = ? where idphase = ?","si",$status,$id);
    }

    public function isPhaseEnabled($id)
    {
        $p = $this->getPhase($id);
        if ($p && $p['phase_status'] == 'enabled')
            return true;
        return false;
    }

    public function getPreviousPhaseMultiScore($phase)
    {
        if ($phase)
        {
            $prevPhase = $this->p_singlequery("select * from phase where phase_evaluation = ? and phase_order < ? order by phase_order desc limit 1","ii",$phase['phase_evaluation'],$phase['phase_order']);
            if ($prevPhase)
            {
                if (! $prevPhase['phase_single_score'])
                    return $prevPhase;
            }
        }
        return null;
    }

    public function isPreviousPhaseMultiScore($phase)
    {
        $prevPhase = $this->getPreviousPhaseMultiScore($phase);
        if ($prevPhase)
        {
            if (! $prevPhase['phase_single_score'])
                return true;
        }
        return false;
    }

    public function numPhasesForEval($evalid)
    {
        $q = "SELECT * from phase where phase_evaluation = ?";
        $r = $this->p_query($q,"i",$evalid);
        if (!$r) {$this->sqlError($q); return null;}
        return intval($r->num_rows);
    }

    public function updatePhasePopulate($idphase,$iduser)
    {
        $strDT = (new DateTime('now'))->format('Y-m-d H:i:s');
        $this->p_update("update phase set phase_populate_from_utility = 1, phase_last_populate = ?, phase_populate_user = ? where idphase = ?","sii",$strDT,$iduser,$idphase);
    }

    public function deletePhase($id)
    {
        $this->p_delete("delete from phase where idphase = ?","i",$id);
    }

    public function deletePhasesForEval($evalid)
    {
        $r = $this->allPhasesForEval($evalid);
        while ($phase = $r->fetch_array())
            $this->p_delete("delete from user_has_phase where phase_idphase = ?","i",$phase['idphase']);
        return $this->p_delete("delete from phase where phase_evaluation = ?","i",$evalid);
    }

    public function getLastPhaseForEval($evalid)
    {
        return $this->p_singlequery("select * from phase where phase_evaluation = ? order by phase_order desc limit 1","i",$evalid);
    }

    //*********************************************************************
    // user_has_phase
    //*********************************************************************
    public function createPhaseForUser($userid,$phaseid)
    {
        return $this->p_create("insert into user_has_phase (user_iduser,phase_idphase) values (?,?)","ii",$userid,$phaseid);
    }

    public function phasesForUser($userid)
    {
        $q = "select * from user_has_phase left join phase a on a.idphase = phase_idphase where user_iduser = ?";
        $r = $this->p_query($q,"i",$userid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function phasesForUserForEval($evalid,$userid,$order='')
    {
        $q = "select * from user_has_phase left join phase a on a.idphase = phase_idphase where user_iduser = ? and a.phase_evaluation = ? {$order}";
        $r = $this->p_query($q,"ii",$userid,$evalid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function phasesForUserForEvalEnabled($evalid,$userid)
    {
        $q = "select * from user_has_phase left join phase a on a.idphase = phase_idphase where user_iduser = ? and a.phase_evaluation = ? and a.phase_status = 'enabled'";
        $r = $this->p_query($q,"ii",$userid,$evalid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function phasesForUserForEvalAll($evalid,$userid)
    {
        $q = "select * from user_has_phase left join phase a on a.idphase = phase_idphase where user_iduser = ? and a.phase_evaluation = ?";
        $r = $this->p_query($q,"ii",$userid,$evalid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function numPhasesForUser($evalid,$userid)
    {
        $q = "select * from user_has_phase left join phase a on a.idphase = phase_idphase where user_iduser = ? and a.phase_evaluation = ?";
        $r = $this->p_query($q,"ii",$userid,$evalid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r->num_rows;
    }

    public function userHasPhase($userid,$phaseid)
    {
        $q = "select * from user_has_phase where user_iduser = ? and phase_idphase = ?";
        $r = $this->p_query($q,"ii",$userid,$phaseid);
        if (!$r) {$this->sqlError($q); return null;}
        if ($r->num_rows > 0)
            return true;
        else
            return false;
    }

    public function deletePhasesForUser($evalid,$userid)
    {
        $q = "select * from user_has_phase left join phase a on a.idphase = phase_idphase where a.phase_evaluation = ? and user_iduser = ?";
        $r = $this->p_query($q,"ii",$evalid,$userid);

        if (!$r) {$this->sqlError($q); return null;}
        while ($row = $r->fetch_array())
        {
            $this->p_delete("delete from user_has_phase where user_iduser = ? and phase_idphase = ?","ii",$row['user_iduser'],$row['phase_idphase']);
        }
    }

    public function deleteUsersForPhase($phaseid)
    {
        $this->p_delete("delete from user_has_phase where phase_idphase = ?","i",$phaseid);
    }

    public function allEvaluatorsForPhase($phaseid,$order='')
    {
        $q = "select * from user_has_phase left join user a on a.iduser = user_iduser where phase_idphase = ? and a.user_deleted = 0 " . $order;
        $r = $this->p_query($q,"i",$phaseid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function deleteUserFromAllPhases($userid)
    {
        $this->p_delete("delete from user_has_phase where user_iduser = ?","i",$userid);
    }

    //*********************************************************************
    // Rules
    //*********************************************************************
    public function getRule($id)
    {
        return $this->p_singlequery("SELECT * from rule where idrule = ?","i",$id);
    }

    public function allRules($order='')
    {
        $q = "SELECT * from rule {$order}";
        $r = $this->p_query($q,null,null);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allRulesForEval($evalid,$order='')
    {
        $q = "SELECT * from rule where rule_evaluation = ? {$order}";
        $r = $this->p_query($q,"i",$evalid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function deleteRule($id)
    {
        return $this->p_delete("delete from rule where idrule = ?","i",$id);
    }


    //*********************************************************************
    // Section
    //*********************************************************************
    public function getSection($id)
    {
        return $this->p_singlequery("SELECT * from section where idsection = ?","i",$id);
    }

    public function getSectionByName($evalid,$name)
    {
        $esc_name = $this->real_escape_string(str_replace("\x92", "'", $name));
        return $this->p_singlequery("SELECT * from section where section_evaluation = ? and section_name = ?","is",$evalid,$esc_name);
    }

    public function allSections($order='')
    {
        $q = "SELECT * from section {$order}";
        $r = $this->p_query($q,null,null);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allSectionsForEval($evalid,$order='')
    {
        $q = "SELECT * from section where section_evaluation = ? {$order}";
        $r = $this->p_query($q,"i",$evalid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function numOfSectionsForEval($evalid)
    {
        $q = "SELECT * from section where section_evaluation = ?";
        $r = $this->p_query($q,"i",$evalid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r->num_rows;
    }

    public function createSection($evalid,$sec_order,$name)
    {
        $esc_name = str_replace("\x92", "'", $name);
        return $this->p_create("insert into section (section_evaluation,section_order,section_name) values (?,?,?)","iis",$evalid,$sec_order,$esc_name);
    }

    public function deleteSection($id)
    {
        return $this->p_delete("delete from section where idsection = ?","i",$id);
    }

    //*********************************************************************
    // Question
    //*********************************************************************
    public function getQuestion($id)
    {
        return $this->p_singlequery("SELECT * from question where idquestion = ?","i",$id);
    }

    public function getQuestionByNum($evalid,$quetsion_identifier)
    {
        return $this->p_singlequery("SELECT * from question where question_evaluation = ? and question_identifier = ?","is",$evalid,$quetsion_identifier);
    }

    public function getLastQuestionOrder($evalid)
    {
        $o = $this->p_singlequery("SELECT * from question where question_evaluation = ? order by question_order DESC limit 1","i",$evalid);
        if ($o)
            return intval($o['question_order']);
        else
            return 0;
    }

    public function getQuestionType($id)
    {
        $question = $this->getQuestion(intval($id));
        if ($question)
            return $question['question_type'];
        return null;
    }

    public function allQuestions($order='')
    {
        $q = "SELECT * from question {$order}";
        $r = $this->p_query($q,null,null);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allQuestionsForEval($evalid, $order='')
    {
        $q = "SELECT * from question where question_evaluation = ? {$order}";
        $r = $this->p_query($q,"i",$evalid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allQuestionsForEvalWithSection($evalid, $order='')
    {
        $q = "SELECT * from question left join section a on a.idsection = question_section where question_evaluation = ? {$order}";
        $r = $this->p_query($q,"i",$evalid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }


    public function allQuestionsForSection($idSection,$order='')
    {
        $q = "SELECT * from question where question_section = ? {$order}";
        $r = $this->p_query($q,"i",$idSection);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function numOfQuestionsForEval($evalid)
    {
        $q = "SELECT * from question where question_evaluation = ?";
        $r = $this->p_query($q,"i",$evalid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r->num_rows;
    }

    public function createQuestion($evalid,$sectionid,$question_identifier,$txt,$weighting,$guide,$tag,$type='range',$question_oder=null)
    {
        if (!strstr($weighting,"%"))
            $w = floatval($weighting);
        else
            $w = floatval($weighting) / 100.0;

        $qorder = 0;
        if (!$question_oder)
            $qorder = $this->getLastQuestionOrder($evalid) + 10;
        else
            $qorder = $question_oder;

        return $this->p_create("insert into question (question_evaluation,question_order,question_identifier,question_section,question_text,question_weighting,question_guide,question_tag,question_type) values (?,?,?,?,?,?,?,?,?)","iisisdsss",$evalid,$qorder,$question_identifier,$sectionid,$txt,$w,$guide,$tag,$type);
    }

    public function updateQuestion($qid,$text,$guide)
    {
        $esc_txt = $this->real_escape_string(str_replace("\x92", "'", $text));
        $esc_guide = $this->real_escape_string(str_replace("\x92", "'", $guide));
        $id = intval($qid);
        return $this->p_update("update question set question_text = ?, question_guide = ? where idquestion = ?","ssi",$esc_txt,$esc_guide,$id);
    }

    public function deleteQuestion($id)
    {
        return $this->p_delete("delete from question where idquestion = ?","i",$id);
    }

    //*********************************************************************
    // SubAttributes
    //*********************************************************************
    public function getSubAttribute($id)
    {
        return $this->p_singlequery("SELECT * from subattribute where idsubattribute = ?","i",$id);
    }

    public function getSubByNum($questionid,$sub_num)
    {
        return $this->p_singlequery("SELECT * from subattribute where subattribute_question = ? and subattribute_number = ?","ii",$questionid,$sub_num);
    }

    public function getSubAttributeType($id)
    {
        $sub = $this->getSubAttribute(intval($id));
        if ($sub)
            return $sub['subattribute_type'];
        return null;
    }

    public function allSubAttributes($order='')
    {
        $q = "SELECT * from subattribute {$order}";
        $r = $this->p_query($q,null,null);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allSubAttributesForEval($evalid,$order='')
    {
        $q = "SELECT * from subattribute left join question a on a.idquestion = subattribute_question where a.question_evaluation = ? {$order}";
        $r = $this->p_query($q,"i",$evalid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allSubForQuestion($idq,$order='')
    {
        $q = "SELECT * from subattribute where subattribute_question = ? {$order}";
        $r = $this->p_query($q,"i",$idq);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function numOfSubsForQuestion($idq)
    {
        $q = "SELECT * from subattribute where subattribute_question = ?";
        $r = $this->p_query($q,"i",$idq);
        if (!$r) {$this->sqlError($q); return null;}
        return $r->num_rows;
    }

    public function createSubAttribute($questionid,$sub_number,$sub_txt,$sub_guide,$weighting,$type)
    {
        if (!strstr($weighting,"%"))
            $w = floatval($weighting);
        else
            $w = floatval($weighting) / 100.0;

        return $this->p_create("insert into subattribute (subattribute_question,subattribute_number,subattribute_txt,subattribute_guide,subattribute_weighting,subattribute_type) values (?,?,?,?,?,?)","iissds",$questionid,$sub_number,$sub_txt,$sub_guide,$w,$type);
    }

    public function updateSubAttribute($sid,$sub_txt,$sub_guide)
    {
        $esc_txt = $this->real_escape_string(str_replace("\x92", "'", $sub_txt));
        $esc_guide = $this->real_escape_string(str_replace("\x92", "'", $sub_guide));
        $id = intval($id);
        return $this->p_update("update subattribute set subattribute_txt = ?, subattribute_guide = ? where idsubattribute = ?","ssi",$esc_txt,$esc_guide,$id);
    }

    public function deleteSubAttribute($id)
    {
        return $this->p_delete("delete from subattribute where idsubattribute = ?","i",$id);
    }

    public function deleteSubAttributesForQuestion($id)
    {
        return $this->p_delete("delete from subattribute where subattribute_question = ?","i",$id);
    }


    //*********************************************************************
    // Team
    //*********************************************************************
    public function getTeam($id)
    {
        return $this->p_singlequery("SELECT * from team where idteam = ?","i",$id);
    }

    public function allTeams($order='')
    {
        $q = "SELECT * from team {$order}";
        $r = $this->p_query($q,null,null);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allTeamsForEval($evalid,$order='')
    {
        $q = "SELECT * from team where team_evaluation = ? {$order}";
        $r = $this->p_query($q,"i",$evalid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function numOfTeamsForEval($evalid)
    {
        $q = "SELECT * from team where team_evaluation = ?";
        $r = $this->p_query($q,"i",$evalid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r->num_rows;
    }

    public function isTeamUsedOnPhase($teamid,$phaseid)
    {
        $validuser = false;
        $r10 = $this->allUsersForTeam($teamid);
        if (!$r10) {$this->sqlError($q); return null;}
        while ($u1 = $r10->fetch_assoc())
        {
            if ($this->userHasPhase($u1['iduser'],$phaseid) )
                $validuser = true;
        }
        return $validuser;
    }

    public function numOfTeamsForEvalForPhase($evalid,$phaseid)
    {
        $cnt = 0;
        $q = "SELECT * from team where team_evaluation = ?";
        $r = $this->p_query($q,"i",$evalid);
        if (!$r) {$this->sqlError($q); return null;}
        while ($team = $r->fetch_assoc())
        {
            if ( $this->isTeamUsedOnPhase($team['idteam'],$phaseid) )
                $cnt++;
        }
        return $cnt;
    }


    public function allTeamsWithEval($order='')
    {
        $q = "SELECT * from team left join evaluation a on a.idevaluation = team_evaluation {$order}";
        $r = $this->p_query($q,null,null);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function createTeam($evalid,$teamname)
    {
        $esc_temaname = str_replace("\x92", "'", $teamname);
        return $this->p_create("insert into team (team_evaluation,team_name) values (?,?)","is",$evalid,$esc_temaname);
    }

    public function enableTeam($teamid)
    {
        return $this->p_update("update team set team_enabled = 1 where idteam = ?","i",$tid);
    }

    public function disableTeam($teamid)
    {
        return $this->p_update("update team set team_enabled = 0 where idteam = ?","i",$tid);
    }

    public function deleteTeam($id)
    {
        return $this->p_delete("delete from team where idteam = ?","i",$id);
    }

    //*********************************************************************
    // team_has_question
    //*********************************************************************
    public function createQuestionForTeam($teamid,$qid)
    {
        return $this->p_create("insert into team_has_question (team_idteam,question_idquestion) values (?,?)","ii",$teamid,$qid);
    }

    public function allQuestionsForTeam($teamid)
    {
        $q = "SELECT * from team_has_question left join question a on a.idquestion = question_idquestion left join section b on b.idsection = a.question_section where team_idteam = ? order by a.question_order";
        $r = $this->p_query($q,"i",$teamid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allTeamsForQuestion($qid)
    {
        $q = "SELECT * from team_has_question left join team a on a.idteam = team_idteam  where question_idquestion = ?";
        $r = $this->p_query($q,"i",$qid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function hasTeamQuestion($teamid,$questionid)
    {
        $q = "SELECT * from team_has_question where team_idteam = ? and question_idquestion = ?";
        $r = $this->p_query($q,"ii",$teamid,$questionid);
        if ($r->num_rows > 0)
            return true;
        else
            return false;
    }

    public function hasTeamAllQuestionsForSection($secid,$teamid)
    {
        $r = $this->allQuestionsForSection($secid);
        while ($qu = $r->fetch_array(MYSQLI_ASSOC))
        {
            if (!$this->hasTeamQuestion($teamid,$qu['idquestion']))
                return false;
        }
        return true;
    }

    public function deleteQuestionFromTeam($id)
    {
        return $this->p_delete("delete from team_has_question where team_idteam = ?","i",$id);
    }

    public function deleteQuestionFromTeamsForAllEval($evalid)
    {
        $q = "select * from team_has_question left join question a on a.idquestion = question_idquestion where a.question_evaluation = ?";
        $r = $this->p_query($q,"i",$evalid);
        while ($thq = $r->fetch_array())
        {
            $this->p_delete("delete from team_has_question where team_idteam = ? and question_idquestion = ?","ii",$thq['team_idteam'],$thq['question_idquestion']);
        }
    }

    public function numQuestionSubsForTeam($teamid)
    {
        $cnt = 0;
        $r = $this->allQuestionsForTeam($teamid);
        while ($q = $r->fetch_array(MYSQLI_ASSOC))
        {
            $sq = $this->numOfSubsForQuestion($q['idquestion']);
            if ($sq > 0)
                $cnt+= $sq;
            else
                $cnt++;
        }
        return intval($cnt);
    }

    //*********************************************************************
    // team_has_user
    //*********************************************************************
    public function createUserForTeam($teamid,$userid)
    {
        return $this->p_create("insert into team_has_user (team_idteam,user_iduser) values (?,?)","ii",$teamid,$userid);
    }

    public function hasTeamUser($teamid,$userid)
    {
        $q = "SELECT * from team_has_user where team_idteam = ? and user_iduser = ?";
        $r = $this->p_query($q,"ii",$teamid,$userid);
        if ($r->num_rows > 0)
            return true;
        else
            return false;

    }

    public function allTeamsForUser($userid)
    {
        $q = "SELECT * from team_has_user left join team a on a.idteam = team_idteam where user_iduser = ? order by a.team_name";
        $r = $this->p_query($q,"i",$userid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allTeamsForUserForEval($evalid,$userid)
    {
        $q = "SELECT * from team_has_user left join team a on a.idteam = team_idteam where user_iduser = ? and a.team_evaluation = ? order by a.team_name";
        $r = $this->p_query($q,"ii",$userid,$evalid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allUsersForTeam($teamid)
    {
        $q = "SELECT * from team_has_user left join user a on a.iduser = user_iduser where team_idteam = ? order by a.user_name";
        $r = $this->p_query($q,"i",$teamid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allTeamsForUserandEval($userid,$evalid)
    {
        $q = "SELECT * from team_has_user left join team a on a.idteam = team_idteam where user_iduser = ? and a.team_evaluation = ? order by a.team_name";
        $r = $this->p_query($q,"ii",$userid,$evalid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function numUsersForTeam($teamid)
    {
        $q = "SELECT * from team_has_user where team_idteam = ?";
        $r = $this->p_query($q,"i",$teamid);
        if (!$r) {$this->sqlError($q); return null;}
        return intval($r->num_rows);
    }

    public function numUsersForTeamForPhase($teamid,$phaseid)
    {
        $q = "SELECT * from team_has_user where team_idteam = ?";
        $r = $this->p_query($q,"i",$teamid);
        if (!$r) {$this->sqlError($q); return null;}
        $cnt = 0;
        while ($row = $r->fetch_array())
        {
            if ($this->userHasPhase($row['user_iduser'],$phaseid) )
                $cnt++;
        }
        return intval($cnt);
    }

    public function numUsersForPhase($phaseid)
    {
        $cnt = 0;
        $r = $this->allUsers();
        while ($evaluator = $r->fetch_assoc())
        {
            if ($this->userHasPhase($evaluator['iduser'],$phaseid) )
                $cnt++;
        }
        return $cnt;
    }

    public function numEvaluatorsForPhaseQuestion($phaseid,$questionid)
    {
        $r = $this->allTeamsForQuestion($questionid);
        $cnt = 0;
        while ($team = $r->fetch_assoc())
        {
            $cnt += $this->numUsersForTeamForPhase($team['idteam'],$phaseid);
        }
        return $cnt;
    }

    public function firstUserForTeamPhase($teamid,$phaseid)
    {
        $q = "SELECT * from team_has_user where team_idteam = ?";
        $r = $this->p_query($q,"i",$teamid);
        if (!$r) {$this->sqlError($q); return null;}
        while ($row = $r->fetch_array())
        {
            if ($this->userHasPhase($row['user_iduser'],$phaseid) )
            {
                return $this->getUser($row['user_iduser']);
            }
        }
        return null;
    }


    public function getSingleEvaluatorForPhaseQuestion($phaseid,$questionid)
    {
        $cnt = $this->numEvaluatorsForPhaseQuestion($phaseid,$questionid);
        if ($cnt == 1)
        {
            $r = $this->allTeamsForQuestion($questionid);
            while ($team = $r->fetch_assoc())
            {
                $u = $this->firstUserForTeamPhase($team['idteam'],$phaseid);
                if ($u)
                    return $u;
            }
        }
        return null;
    }


    public function getTeamForUserQuestion($userid,$questionid)
    {
        $q = "select * from team_has_user join team_has_question a on a.team_idteam = team_has_user.team_idteam  where user_iduser = ? and question_idquestion = ?";
        $r = $this->p_query($q,"ii",$userid,$questionid);
        if (!$r) {$this->sqlError($q); return null;}
        if ($r->num_rows > 1 || $r->num_rows == 0)
            return null;
        $thu = $r->fetch_array(MYSQLI_ASSOC);
        return $this->getTeam($thu['team_idteam']);
    }

    public function allTeamsForUserQuestion($userid,$questionid)
    {
        $q = "select * from team_has_user join team_has_question a on a.team_idteam = team_has_user.team_idteam  where user_iduser = ? and question_idquestion = ?";
        $r = $this->p_query($q,"ii",$userid,$questionid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function numTeamsForUserQuestion($userid,$questionid)
    {
        $q = "select * from team_has_user join team_has_question a on a.team_idteam = team_has_user.team_idteam  where user_iduser = ? and question_idquestion = ?";
        $r = $this->p_query($q,"ii",$userid,$questionid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r->num_rows;
    }

    public function deleteTeamHasUserForTeam($id)
    {
        return $this->p_delete("delete from team_has_user where team_idteam = ?","i",$id);
    }

    public function deleteTeamHasUserForAllEvalTeam($evalid)
    {
        $r = $this->allTeamsForEval($evalid);
        while ($team = $r->fetch_array())
        {
            $this->p_delete("delete from team_has_user where team_idteam = ?","i",$team['idteam']);
        }
    }

    public function deleteUserFromAllTeams($userid)
    {
        return $this->p_delete("delete from team_has_user where user_iduser = ?","i",$userid);
    }

    //*********************************************************************
    // Respondent
    //*********************************************************************
    public function getRespondent($id)
    {
        return $this->p_singlequery("SELECT * from respondent where idrespondent = ?","i",$id);
    }

    public function allRespondents($order='')
    {
        $q = "SELECT * from respondent {$order}";
        $r = $this->p_query($q,null,null);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allRespondentsForEval($evalid, $order='')
    {
        $q = "SELECT * from respondent where respondent_evaluation = ? {$order}";
        $r = $this->p_query($q,"i",$evalid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function numOfRespondents($evalid)
    {
        $q = "SELECT * from respondent where respondent_evaluation = ?";
        $r = $this->p_query($q,"i",$evalid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r->num_rows;
    }

    public function createRespondent($evalid,$fullname,$shortname,$colour)
    {
        $esc_fullname = str_replace("\x92", "'", $fullname);
        $esc_shortname = str_replace("\x92", "'", $shortname);

        return $this->p_create("insert into respondent (respondent_evaluation,respondent_name_full,respondent_name_short,respondent_colour) values (?,?,?,?)","isss",$evalid,$esc_fullname,$esc_shortname,$colour);
    }

    public function deleteRespondent($id)
    {
        return $this->p_delete("delete from respondent where idrespondent = ?","i",$id);
    }


    //*********************************************************************
    // Scores
    //*********************************************************************
    public function getScore($id)
    {
        return $this->p_singlequery("select * from score where idscore = ?","i",$id);
    }

    public function o_getScoreDetail($uid,$evaluationid,$phaseid,$respid,$questid,$subid)
    {
        if ($subid)
            return $this->o_singlequery("score","select * from score where score_user = ? and score_evaluation = ? and score_phase = ? and score_respondent = ? and score_question = ? and score_subattribute = ?","iiiiii",$uid,$evaluationid,$phaseid,$respid,$questid,$subid);
        else
            return $this->o_singlequery("score","select * from score where score_user = ? and score_evaluation = ? and score_phase = ? and score_respondent = ? and score_question = ? and (score_subattribute is null or score_subattribute = 0)","iiiii",$uid,$evaluationid,$phaseid,$respid,$questid);
    }

    public function getScoreDetail($uid,$evaluationid,$phaseid,$respid,$questid,$subid)
    {
        if ($subid)
            return $this->p_singlequery("select * from score where score_user = ? and score_evaluation = ? and score_phase = ? and score_respondent = ? and score_question = ? and score_subattribute = ?","iiiiii",$uid,$evaluationid,$phaseid,$respid,$questid,$subid);
        else
            return $this->p_singlequery("select * from score where score_user = ? and score_evaluation = ? and score_phase = ? and score_respondent = ? and score_question = ? and (score_subattribute is null or score_subattribute = 0)","iiiii",$uid,$evaluationid,$phaseid,$respid,$questid);
    }

    public function getScoreComment($evaluationid,$phaseid,$respid,$questid,$subid=null)
    {
        $ret = '';
        if ($subid)
        {
            $q = "select * from score where score_evaluation = ? and score_phase = ? and score_respondent = ? and score_question = ? and score_subattribute = ?";
            $r = $this->p_query($q,"iiiii",$evaluationid,$phaseid,$respid,$questid,$subid);
        }
        else
        {
            $q = "select * from score where score_evaluation = ? and score_phase = ? and score_respondent = ? and score_question = ? and (score_subattribute is null or score_subattribute = 0)";
            $r = $this->p_query($q,"iiii",$evaluationid,$phaseid,$respid,$questid);
        }
        if ($r->num_rows == 1)
        {
            $score = $r->fetch_array(MYSQLI_ASSOC);
            $ret = $score['score_comment'];
        }
        return $ret;
    }

    public function getScoreAndRange($evalid,$uid,$phaseid,$respid,$questid,$subid=null)
    {
        $bFirst = false;
        $sum = 0;
        $min = 0;
        $max = 0;
        $cnt = 0;
        $userscore = 0;
        $usertext = "";

        if ($subid)
        {
            $q = "select * from score where score_evaluation = ? and score_phase = ? and score_respondent = ? and score_question = ? and score_subattribute = ?";
            $r = $this->p_query($q,"iiiii",$evalid,$phaseid,$respid,$questid,$subid);
        }
        else
        {
            $q = "select * from score where score_evaluation = ? and score_phase = ? and score_respondent = ? and score_question = ? and (score_subattribute is null or score_subattribute = 0)";
            $r = $this->p_query($q,"iiii",$evalid,$phaseid,$respid,$questid);
        }
        while ($score = $r->fetch_array(MYSQLI_ASSOC))
        {
            if ($score['score_user'] == intval($uid))
            {
                $userscore = $score['score_score'];
                $usertext = $score['score_comment'];
            }
            if (!$bFirst)
            {
                $min = $score['score_score'];
                $max = $score['score_score'];
                $bFirst = true;
            }
            else
            {
                if ($score['score_score'] > $max)
                    $max = $score['score_score'];

                if ($score['score_score'] < $min)
                    $min = $score['score_score'];
            }
            $sum += $score['score_score'];
            $cnt++;
        }

        $resp = array();
        $resp["userscore"] = $userscore;
        $resp["usertext"] = $usertext;
        $resp["min"] = $min;
        $resp["max"] = $max;
        $resp["cnt"] = $cnt;
        $resp["sum"] = $sum;
        return $resp;
    }

    public function allotherComments($evalid,$uid,$phaseid,$respid,$questid,$subid=null)
    {
        if ($subid)
        {
            $q = "select * from score left join user on iduser = score_user where score_evaluation = ? and score_phase = ? and score_respondent = ? and score_question = ? and score_subattribute = ? and score_user != ? order by user_name";
            $r = $this->p_query($q,"iiiiii",$evalid,$phaseid,$respid,$questid,$subid,$uid);
        }
        else
        {
            $q = "select * from score left join user on iduser = score_user where score_evaluation = ? and score_phase = ? and score_respondent = ? and score_question = ? and (score_subattribute is null or score_subattribute = 0) and score_user != ? order by user_name";
            $r = $this->p_query($q,"iiiii",$evalid,$phaseid,$respid,$questid,$uid);
        }
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function numScoresFor($evalid,$phaseid,$userid,$questionid)
    {
        $q = "select * from score where score_user = ? and score_evaluation = ? and score_phase = ? and score_question = ? and score_score is not null";
        $r = $this->p_query($q,"iiii",$userid,$evalid,$phaseid,$questionid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r->num_rows;
    }

    public function numScoresForUser($evalid,$phaseid,$userid)
    {
        $q = "select * from score where score_user = ? and score_evaluation = ? and score_phase = ? and score_score is not null";
        $r = $this->p_query($q,"iii",$userid,$evalid,$phaseid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r->num_rows;
    }

    public function phaseProgress($evalid,$phaseid)
    {
        $totforphase = 0;
        $tot_answered = 0;
        $num_respondents = $this->numOfRespondents($evalid);
        $r = $this->allTeamsForEval($evalid);
        while ($team = $r->fetch_array())
        {
            $num_evalsforteam = $this->numUsersForTeamForPhase($team['idteam'],$phaseid);
            $tot = 0;
            $r2 = $this->allQuestionsForTeam($team['idteam']);
            while ($question = $r2->fetch_array())
            {
                $nSubs = $this->numOfSubsForQuestion($question['idquestion']);
                if ($nSubs == 0)
                   $nSubs = 1;
                $tot += $nSubs;
            }
            //$tot is number of questions required to be answered for this team
            $tot = $tot * $num_respondents * $num_evalsforteam;

            $totforphase += $tot;

            $r1 = $this->allUsersForTeam($team['idteam']);
            while ($user = $r1->fetch_array())
            {
                //Check that this user is assigned to evalutae this phase
                if ($this->userHasPhase($user['iduser'],$phaseid) )
                {
                    $answered = 0;
                    $r3 = $this->allQuestionsForTeam($team['idteam']);
                    while ($qeest = $r3->fetch_array())
                    {
                        $answered += $this->numScoresFor($evalid,$phaseid,$user['iduser'],$qeest['idquestion']);
                    }
                    $tot_answered += $answered;
               }
            }
        }
        $result = array();
        $result['answerd'] = $tot_answered;
        $result['required'] = $totforphase;
        $result['ratio'] = 0.0;
        if ($totforphase > 0)
            $result['ratio'] = floatVal($tot_answered / $totforphase);
        return $result;
    }

    public function minMaxAveTeam($evalid,$phaseid,$teamid)
    {
        $ret = array();
        $ret['min'] = 1000000000.0;
        $ret['max'] = 0.0;
        $ret['avg'] = 0.0;
        $ret['cnt'] = 0;
        $cnt = 0;
        $sum = 0.0;
        $r = $this->allQuestionsForTeam($teamid);
        while ($qu = $r->fetch_array(MYSQLI_ASSOC))
        {
            $a = $this->p_singlequery("select MIN(score_score) as MIN, MAX(score_score) as MAX, SUM(score_score) as SUM, count(*) as COUNT from score where score_evaluation = ? and score_phase = ? and score_question = ?","iii",$evalid,$phaseid,$qu['idquestion']);
            if ($a['MIN'] < $ret['min'])
                $ret['min'] = $a['MIN'];
            if ($a['MAX'] > $ret['max'])
                $ret['max'] = $a['MAX'];
            $cnt += $a['COUNT'];
            $sum += $a['SUM'];
        }
        if ($cnt > 0)
        {
            $ret['avg'] = $sum/$cnt;
            $ret['cnt'] = $cnt;
        }
        else
            $ret['min'] = 0.0;

        return $ret;
    }

    public function minMaxAveByUserInTeam($evalid,$phaseid,$teamid)
    {
        $teamdiff = 0;
        $teammin = 100000000000;
        $teamcnt = 0;
        $difftot = 0;
        $ret = array();
        $ret['max'] = 0;
        $ret['avgdiff'] = 0;

        $r = $this->allQuestionsForTeam($teamid);
        while ($qu = $r->fetch_array(MYSQLI_ASSOC))
        {
            $r3 = $this->allSubForQuestion($qu['idquestion']);
            if ($r3->num_rows > 0)
            {
                while ($sub = $r3->fetch_array(MYSQLI_ASSOC))
                {
                    $r4 = $this->allRespondentsForEval($evalid);
                    while ($respondent = $r4->fetch_array(MYSQLI_ASSOC))
                    {
                        $r2 = $this->allUsersForTeam($teamid);
                        $diff = 0;
                        $min = 100000000000;
                        $max = 0;
                        $cnt = 0;
                        while ($evaluator = $r2->fetch_array(MYSQLI_ASSOC))
                        {
                            $score = $this->p_singlequery("select * from score where score_evaluation = ? and score_phase = ? and score_respondent = ? and score_question = ? and score_subattribute = ? and score_user = ?","iiiiii",$evalid,$phaseid,$respondent['idrespondent'],$qu['idquestion'],$sub['idsubattribute'],$evaluator['iduser']);
                            if ($score)
                            {
                                if ($score['score_score'] < $min)
                                    $min = $score['score_score'];
                                if ($score['score_score'] > $max)
                                    $max = $score['score_score'];
                                $cnt++;
                            }
                        }
                        if ($cnt > 0)
                        {
                            if ($max > $ret['max'])
                                $ret['max'] = $max;
                            $diff = $max-$min;
                            $difftot += $diff;
                            $teamcnt++;

                            if ($diff > $teamdiff)
                                $teamdiff = $diff;
                        }
                    }
                }
            }
            else
            {
                $r4 = $this->allRespondentsForEval($evalid);
                while ($respondent = $r4->fetch_array(MYSQLI_ASSOC))
                {
                    $r2 = $this->allUsersForTeam($teamid);
                    $diff = 0;
                    $min = 100000000000;
                    $max = 0;
                    $cnt = 0;
                    while ($evaluator = $r2->fetch_array(MYSQLI_ASSOC))
                    {
                        $score = $this->p_singlequery("select * from score where score_evaluation = ? and score_phase = ? and score_respondent = ? and score_question = ? and (score_subattribute is null or score_subattribute = 0) and score_user = ?","iiiii",$evalid,$phaseid,$respondent['idrespondent'],$qu['idquestion'],$evaluator['iduser']);
                        if ($score)
                        {
                            if ($score['score_score'] < $min)
                                $min = $score['score_score'];
                            if ($score['score_score'] > $max)
                                $max = $score['score_score'];
                            $cnt++;
                        }
                    }
                    if ($cnt > 0)
                    {
                        if ($max > $ret['max'])
                            $ret['max'] = $max;
                        $diff = $max-$min;
                        $difftot += $diff;
                        $teamcnt++;
                        if ($diff > $teamdiff)
                            $teamdiff = $diff;
                    }
                }
            }
        }
        error_log("Team count {$teamcnt}");
        if ($teamcnt > 0)
        {
            $ret['avgdiff'] = $difftot/$teamcnt;
            $ret['count'] = $teamcnt;
        }
        return $ret;
    }

    public function createScore($uid,$evaluationid,$phaseid,$respid,$questid,$subid,$score)
    {
        if (!is_null($score))
        {
            if ($subid)
                return $this->p_create("insert into score (score_user,score_evaluation,score_phase,score_respondent,score_question,score_subattribute,score_score) value (?,?,?,?,?,?,?)","iiiiiii",$uid,$evaluationid,$phaseid,$respid,$questid,$subid,$score);
            else
                return $this->p_create("insert into score (score_user,score_evaluation,score_phase,score_respondent,score_question,score_score) value (?,?,?,?,?,?)","iiiiii",$uid,$evaluationid,$phaseid,$respid,$questid,$score);
        }
        else
        {
            if ($subid)
                return $this->p_create("insert into score (score_user,score_evaluation,score_phase,score_respondent,score_question,score_subattribute,score_score) value (?,?,?,?,?,?,null)","iiiiii",$uid,$evaluationid,$phaseid,$respid,$questid,$subid);
            else
                return $this->p_create("insert into score (score_user,score_evaluation,score_phase,score_respondent,score_question,score_score) value (?,?,?,?,?,null)","iiiii",$uid,$evaluationid,$phaseid,$respid,$questid);
        }
    }

    public function updateScore($uid,$evaluationid,$phaseid,$respid,$questid,$subid,$score)
    {
        if (!is_null($score))
        {
            if ($subid)
                return $this->p_update("update score set score_score = ? where score_user = ? and score_evaluation = ? and score_phase = ? and score_respondent = ? and score_question = ? and score_subattribute = ?","iiiiiii",$score,$uid,$evaluationid,$phaseid,$respid,$questid,$subid);
            else
                return $this->p_update("update score set score_score = ? where score_user = ? and score_evaluation = ? and score_phase = ? and score_respondent = ? and score_question = ? and (score_subattribute is null or score_subattribute = 0)","iiiiii",$score,$uid,$evaluationid,$phaseid,$respid,$questid);
        }
        else
        {
            if ($subid)
                return $this->p_update("update score set score_score = null where score_user = ? and score_evaluation = ? and score_phase = ? and score_respondent = ? and score_question = ? and score_subattribute = ?","iiiiii",$uid,$evaluationid,$phaseid,$respid,$questid,$subid);
            else
                return $this->p_update("update score set score_score = null where score_user = ? and score_evaluation = ? and score_phase = ? and score_respondent = ? and score_question = ? and (score_subattribute is null or score_subattribute = 0)","iiiii",$uid,$evaluationid,$phaseid,$respid,$questid);
        }
    }

    public function createComment($uid,$evaluationid,$phaseid,$respid,$questid,$subid,$comment)
    {
        if ($subid)
            return $this->p_create("insert into score (score_user,score_evaluation,score_phase,score_respondent,score_question,score_subattribute,score_comment) value (?,?,?,?,?,?,?)","iiiiiis",$uid,$evaluationid,$phaseid,$respid,$questid,$subid,$comment);
        else
            return $this->p_create("insert into score (score_user,score_evaluation,score_phase,score_respondent,score_question,score_subattribute,score_comment) value (?,?,?,?,?,null,?)","iiiiis",$uid,$evaluationid,$phaseid,$respid,$questid,$comment);
    }


    public function updateComment($uid,$evaluationid,$phaseid,$respid,$questid,$subid,$comment)
    {
        if ($subid)
            return $this->p_update("update score set score_comment = ? where score_user = ? and score_evaluation =  ? and score_phase =  ? and score_respondent = ? and score_question = ? and score_subattribute = ?","siiiiii",$comment,$uid,$evaluationid,$phaseid,$respid,$questid,$subid);
        else
            return $this->p_update("update score set score_comment = ? where score_user = ? and score_evaluation =  ? and score_phase =  ? and score_respondent = ? and score_question = ? and (score_subattribute is null or score_subattribute = 0)","siiiii",$comment,$uid,$evaluationid,$phaseid,$respid,$questid);
    }

    public function createOrUpdateScore($uid,$evaluationid,$phaseid,$respid,$questid,$subid,$iscore)
    {
        if (!$score = $this->getScoreDetail($uid,$evaluationid,$phaseid,$respid,$questid,$subid) )
        {
            return $this->createScore($uid,$evaluationid,$phaseid,$respid,$questid,$subid,$iscore);
        }
        else
        {
            return $this->updateScore($uid,$evaluationid,$phaseid,$respid,$questid,$subid,$iscore);
        }
    }

    public function createOrUpdateComment($uid,$evaluationid,$phaseid,$respid,$questid,$subid,$comment)
    {
        if (!$score = $this->getScoreDetail($uid,$evaluationid,$phaseid,$respid,$questid,$subid) )
        {
            return $this->createComment($uid,$evaluationid,$phaseid,$respid,$questid,$subid,$comment);
        }
        else
        {
            return $this->updateComment($uid,$evaluationid,$phaseid,$respid,$questid,$subid,$comment);
        }
    }

    public function sumScores($evalid,$phaseid,$respondentid,$questionid,$subid=null)
    {
        if (is_null($subid))
            return $this->p_singlequery("select sum(score_score) as 'SUM', count(*) as 'COUNT' from score where score_evaluation = ? and score_phase = ? and score_respondent = ? and score_question = ? and (score_subattribute is null or score_subattribute = 0) and score_score is not null","iiii",$evalid,$phaseid,$respondentid,$questionid);
        else
            return $this->p_singlequery("select sum(score_score) as 'SUM', count(*) as 'COUNT' from score where score_evaluation = ? and score_phase = ? and score_respondent = ? and score_question = ? and score_subattribute = ? and score_score is not null","iiiii",$evalid,$phaseid,$respondentid,$questionid,$subid);
    }

    public function sumScoresForPhaseUserTeam($evalid,$phaseid,$userid,$teamid,$respondentid)
    {
        $eid = intval($evalid);
        $pid = intval($phaseid);
        $rid = intval($respondentid);
        $tid = intval($teamid);
        $uid = intval($userid);

        $sum = 0;
        $count = 0;

        $r = $this->allQuestionsForTeam($teamid);
        while ($question = $r->fetch_array())
        {
            $rslt = $this->p_singlequery("select sum(score_score) as 'SUM', count(*) as 'COUNT' from score where score_evaluation = ? and score_user = ? and score_phase = ? and score_respondent = ? and score_question = ?","iiiii",$eid,$uid,$pid,$respondentid,$question['idquestion']);
            $sum += $rslt['SUM'];
            $count += $rslt['COUNT'];
        }
        $ret = array();
        $ret['SUM'] =  $sum;
        $ret['COUNT'] =  $count;
        return $ret;
    }

    public function allScoresForQuestion($evalid,$phaseid,$userid,$qustid)
    {
        if ($userid > 0)
        {
            $q = "select * from score where score_evaluation = ? and score_user = ? and score_phase = ? and score_question = ?";
            $r = $this->p_query($q,"iiii",$evalid,$userid,$phaseid,$qustid);
        }
        else
        {
            $q = "select * from score where score_evaluation = ? and score_phase = ? and score_question = ?";
            $r = $this->p_query($q,"iii",$evalid,$phaseid,$qustid);
        }
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allScoresForQuestionForRespondent($evalid,$phaseid,$userid,$qustid,$respondentid)
    {
        if ($userid > 0)
        {
            $q = "select * from score where score_evaluation = ? and score_user = ? and score_phase = ? and score_question = ? and score_respondent = ?";
            $r = $this->p_query($q,"iiiii",$evalid,$userid,$phaseid,$qustid,$respondentid);
        }
        else
        {
            $q = "select * from score where score_evaluation = ? and score_phase = ? and score_question = ? and score_respondent = ?";
            $r = $this->p_query($q,"iiii",$evalid,$phaseid,$qustid,$respondentid);
        }
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allScoresForQuestionSub($evalid,$phaseid,$userid,$qustid,$subid)
    {
        if ($userid > 0)
        {
            if ($subid == 0)
            {
                $q = "select * from score where score_evaluation = ? and score_user = ? and score_phase = ? and score_question = ? and score_subattribute = 0";
                $r = $this->p_query($q,"iiii",$evalid,$userid,$phaseid,$qustid);
            }
            else
            {
                $q = "select * from score where score_evaluation = ? and score_user = ? and score_phase = ? and score_question = ? and score_subattribute = ?";
                $r = $this->p_query($q,"iiiii",$evalid,$userid,$phaseid,$qustid,$subid);
            }
        }
        else
        {
            if ($subid == 0)
            {
                $q = "select * from score where score_evaluation = ? and score_phase = ? and score_question = ? and score_subattribute = 0";
                $r = $this->p_query($q,"iii",$evalid,$phaseid,$qustid);
            }
            else
            {
                $q = "select * from score where score_evaluation = ? and score_phase = ? and score_question = ? and score_subattribute = ?";
                $r = $this->p_query($q,"iiii",$evalid,$phaseid,$qustid,$subid);
            }
        }
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function getScoreForQuestionSinglePhase($evalid,$phaseid,$questid,$subid,$repondent)
    {
        $e = intval($evalid);
        $p = intval($phaseid);
        $sid = intval($subid);
        $qid = intval($questid);
        $rid = intval($repondent);

        if ($sid > 0)
            return $this->p_singlequery("select * from score where score_evaluation = ? and score_phase = ? and score_question = ? and score_subattribute = ? and score_respondent = ?","iiiii",$e,$p,$qid,$sid,$rid);
        else
            return $this->p_singlequery("select * from score where score_evaluation = ? and score_phase = ? and score_question = ? and score_respondent = ?","iiii",$e,$p,$qid,$rid);
    }

    public function o_getScoreForQuestionSinglePhase($evalid,$phaseid,$questid,$subid,$repondent)
    {
        $e = intval($evalid);
        $p = intval($phaseid);
        $sid = intval($subid);
        $qid = intval($questid);
        $rid = intval($repondent);

        if ($sid > 0)
            return $this->o_singlequery("score","select * from score where score_evaluation = ? and score_phase = ? and score_question = ? and score_subattribute = ? and score_respondent = ?","iiiii",$e,$p,$qid,$sid,$rid);
        else
            return $this->o_singlequery("score","select * from score where score_evaluation = ? and score_phase = ? and score_question = ? and score_respondent = ?","iiii",$e,$p,$qid,$rid);
    }

    public function rawSectionScoreForRespondent($evalid,$phaseid,$sectionid,$respondentid)
    {
        $sectionsum = 0.0;
        $cnt = 0;
        $min = null;
        $max = null;
        $less50 = 0;

        $rid = intval($respondentid);

        $r2 = $this->allQuestionsForSection($sectionid);
        while ($question = $r2->fetch_assoc())
        {
            $r3 = $this->allSubForQuestion($question['idquestion']);
            if ($r3->num_rows == 0)
            {
                $score = $this->getScoreForQuestionSinglePhase($evalid,$phaseid,$question['idquestion'],0,$rid);
                $sectionsum += $score['score_score'];
                $cnt++;
                if ($min === null)
                    $min = $score['score_score'];
                elseif ($score['score_score'] < $min)
                    $min = $score['score_score'];
                if ($max === null)
                    $max = $score['score_score'];
                elseif ($score['score_score'] > $max)
                    $max = $score['score_score'];
                if ($score['score_score'] < 50)
                    $less50++;
            }
            else
            {
                while ($sub = $r3->fetch_assoc())
                {
                    $score = $this->getScoreForQuestionSinglePhase($evalid,$phaseid,$question['idquestion'],$sub['idsubattribute'],$rid);
                    $sectionsum += $score['score_score'];
                    $cnt++;
                    if ($min === null)
                        $min = $score['score_score'];
                    elseif ($score['score_score'] < $min)
                        $min = $score['score_score'];
                    if ($max === null)
                        $max = $score['score_score'];
                    elseif ($score['score_score'] > $max)
                        $max = $score['score_score'];
                    if ($score['score_score'] < 50)
                        $less50++;
                }
            }
        }
        return ['sum' => $sectionsum,'min' => $min,'max' => $max, 'cnt' => $cnt, 'less50' => $less50];

    }

    public function rawSectionScoreForOtherRespondents($evalid,$phaseid,$sectionid,$respondentid)
    {
        $sum = 0;
        $cnt = 0;
        $r = $this->allRespondentsForEval($evalid);
        while ($respondent = $r->fetch_assoc())
        {
            if ($respondent['idrespondent'] != $respondentid)
            {
                $a = $this->rawSectionScoreForRespondent($evalid,$phaseid,$sectionid,$respondent['idrespondent']);
                $sum += $a['sum'];
                $cnt += $a['cnt'];
            }
        }
        return ["sum" => $sum,"cnt" => $cnt];
    }


    public function rawTotalScoreForRespondent($evalid,$phaseid,$respondentid)
    {
        $sum = 0.0;
        $cnt = 0;

        $rid = intval($respondentid);

        $r2 = $this->allQuestionsForEval($evalid);
        while ($question = $r2->fetch_assoc())
        {
            $r3 = $this->allSubForQuestion($question['idquestion']);
            if ($r3->num_rows == 0)
            {
                $score = $this->getScoreForQuestionSinglePhase($evalid,$phaseid,$question['idquestion'],0,$rid);
                $sum += $score['score_score'];
                $cnt++;
            }
            else
            {
                while ($sub = $r3->fetch_assoc())
                {
                    $score = $this->getScoreForQuestionSinglePhase($evalid,$phaseid,$question['idquestion'],$sub['idsubattribute'],$rid);
                    $sum += $score['score_score'];
                    $cnt++;
                }
            }
        }
        return ['sum' => $sum,'cnt' => $cnt];
    }

    public function rankSectionRawScores($evalid,$phaseid,$sectionid,$respondentid)
    {
        $rslt = array();
        $r = $this->allRespondentsForEval($evalid);
        while ($respondent = $r->fetch_assoc())
        {
            $a = $this->rawSectionScoreForRespondent($evalid,$phaseid,$sectionid,$respondent['idrespondent']);
            $rslt[$respondent['idrespondent']] = $a['sum'];
        }
        arsort($rslt);
        $cnt = 0;
        foreach ($rslt as $id => $v)
        {
            if ($id == $respondentid)
                return $cnt+1;
            $cnt++;
        }
        return 0;
    }

    public function rankTotalRawScores($evalid,$phaseid,$respondentid)
    {
        $rslt = array();
        $r = $this->allRespondentsForEval($evalid);
        while ($respondent = $r->fetch_assoc())
        {
            $a = $this->rawTotalScoreForRespondent($evalid,$phaseid,$respondent['idrespondent']);
            $rslt[$respondent['idrespondent']] = $a['sum'];
        }
        arsort($rslt);
        $cnt = 0;
        foreach ($rslt as $id => $v)
        {
            if ($id == $respondentid)
                return $cnt+1;
            $cnt++;
        }
        return 0;
    }

    public function weightedSectionScoreForRespondent($evalid,$phaseid,$sectionid,$respondentid)
    {
        $sumw = 0.0;
        $sectionsum = 0.0;

        $rid = intval($respondentid);

        $r2 = $this->allQuestionsForSection($sectionid);
        while ($question = $r2->fetch_assoc())
        {
            $sumw += $question['question_weighting'];
            $r3 = $this->allSubForQuestion($question['idquestion']);
            if ($r3->num_rows == 0)
            {
                $score = $this->getScoreForQuestionSinglePhase($evalid,$phaseid,$question['idquestion'],0,$rid);
                $sectionsum += ($score['score_score'] * $question['question_weighting']);
            }
            else
            {
                while ($sub = $r3->fetch_assoc())
                {
                    $score = $this->getScoreForQuestionSinglePhase($evalid,$phaseid,$question['idquestion'],$sub['idsubattribute'],$rid);
                    $sectionsum += ($score['score_score'] * $question['question_weighting']) * $sub['subattribute_weighting'];
                }
            }
        }
        return ['totalweightings' => $sumw,'weightedscore' => $sectionsum];
    }

    public function weightedTotalScoreForRespondent($evalid,$phaseid,$respondentid)
    {
        $sumw = 0.0;
        $sectionsum = 0.0;

        $rid = intval($respondentid);

        $r2 = $this->allQuestionsForEval($evalid);
        while ($question = $r2->fetch_assoc())
        {
            $sumw += $question['question_weighting'];
            $r3 = $this->allSubForQuestion($question['idquestion']);
            if ($r3->num_rows == 0)
            {
                $score = $this->getScoreForQuestionSinglePhase($evalid,$phaseid,$question['idquestion'],0,$rid);
                $sectionsum += ($score['score_score'] * $question['question_weighting']);
            }
            else
            {
                while ($sub = $r3->fetch_assoc())
                {
                    $score = $this->getScoreForQuestionSinglePhase($evalid,$phaseid,$question['idquestion'],$sub['idsubattribute'],$rid);

                    if ($score === null)
                    {
                        error_log("Debug: invalid score for evalid {$evalid} phaseid {$phaseid} question {$question['idquestion']} sub {$sub['idsubattribute']} and rid {$rid}");
                    }
                    else



                        $sectionsum += ($score['score_score'] * $question['question_weighting']) * $sub['subattribute_weighting'];
                }
            }
        }
        return ['totalweightings' => $sumw,'weightedscore' => $sectionsum];
    }

    public function weightedSectionScoresForAll($evalid,$phaseid)
    {
        $data = array();
        $r = $this->allRespondentsForEval($evalid);
        while ($respondent = $r->fetch_assoc())
        {
            $results = array();
            $tot = 0.0;
            $r2 = $this->allSectionsForEval($evalid);
            while ($section = $r2->fetch_assoc())
            {
                $sc = $this->weightedSectionScoreForRespondent($evalid,$phaseid,$section['idsection'],$respondent['idrespondent']);
                $results[$section['idsection']] = $sc['weightedscore'];
                $tot += $sc['weightedscore'];
            }
            $results["total"] = $tot;
            $data[$respondent['idrespondent']] = $results;
        }
        return $data;
    }

    public function rangeScoresForSection($evalid,$phaseid,$sectionid)
    {
        $min = 0;
        $max = 0;
        $done_first = false;

        $r4 = $this->allRespondentsForEval($evalid);
        while ($respondent = $r4->fetch_assoc())
        {
            $a = $this->weightedSectionScoreForRespondent($evalid,$phaseid,$sectionid,$respondent['idrespondent']);
            if (!$done_first)
            {
                $min = $a['weightedscore'];
                $max = $a['weightedscore'];
                $done_first = true;
            }
            else
            {
                $min = min($min,$a['weightedscore']);
                $max = max($max,$a['weightedscore']);
            }
        }
        return ['min' =>$min,'max' => $max];
    }

    public function rangeTotalScores($evalid,$phaseid)
    {
        $min = 0;
        $max = 0;
        $done_first = false;

        $r4 = $this->allRespondentsForEval($evalid);
        while ($respondent = $r4->fetch_assoc())
        {
            $a = $this->weightedTotalScoreForRespondent($evalid,$phaseid,$respondent['idrespondent']);
            if (!$done_first)
            {
                $min = $a['weightedscore'];
                $max = $a['weightedscore'];
                $done_first = true;
            }
            else
            {
                $min = min($min,$a['weightedscore']);
                $max = max($max,$a['weightedscore']);
            }
        }
        return ['min' =>$min,'max' => $max];
    }

    public function rankTotalWeightedScores($evalid,$phaseid,$respondentid)
    {
        $rslt = array();
        $r = $this->allRespondentsForEval($evalid);
        while ($respondent = $r->fetch_assoc())
        {
            $a = $this->weightedTotalScoreForRespondent($evalid,$phaseid,$respondent['idrespondent']);
            $rslt[$respondent['idrespondent']] = $a['weightedscore'];
        }
        arsort($rslt);

        $cnt = 0;
        foreach ($rslt as $id => $v)
        {
            if ($id == $respondentid)
                return $cnt+1;
            $cnt++;
        }
        return 0;
    }

    public function o_orderdedScoresCommentsFor($evalid,$phaseid,$questid,$subid,$repondent)
    {
        $ret = array();
        if ($subid > 0)
            $r =  $this->p_query("select score_score, score_comment, user_name from score left join user on iduser =  score_user where score_evaluation = ? and score_phase = ? and score_question = ? and score_subattribute = ? and score_respondent = ? order by score_score","iiiii",$evalid,$phaseid,$questid,$subid,$repondent);
        else
            $r =  $this->p_query("select score_score, score_comment, user_name from score left join user on iduser =  score_user where score_evaluation = ? and score_phase = ? and score_question = ? and score_respondent = ? order by score_score","iiii",$evalid,$phaseid,$questid,$repondent);

        if (!$r) {$this->sqlError($q); return null;}
        if ($r->num_rows > 0)
        {
            while ($o = $r->fetch_object("score"))
                array_push($ret,$o);
            return $ret;
        }
        return null;
    }

    public function orderdedScoresCommentsFor($evalid,$phaseid,$questid,$subid,$repondent)
    {
        if ($subid > 0)
            $r =  $this->p_query("select score_score, score_comment, user_name from score left join user on iduser =  score_user where score_evaluation = ? and score_phase = ? and score_question = ? and score_subattribute = ? and score_respondent = ? order by score_score","iiiii",$evalid,$phaseid,$questid,$subid,$repondent);
        else
            $r =  $this->p_query("select score_score, score_comment, user_name from score left join user on iduser =  score_user where score_evaluation = ? and score_phase = ? and score_question = ? and score_respondent = ? order by score_score","iiii",$evalid,$phaseid,$questid,$repondent);

        if (!$r) {$this->sqlError($q); return null;}
        if ($r->num_rows > 0)
            return $r->fetch_all(MYSQLI_ASSOC);
        return null;
    }

    public function maxScoreForEvaluation($evalid)
    {
        $a = $this->p_singlequery("select max(score_score) as MAX from score where score_evaluation = ?","i",$evalid);
        if ($a)
            return $a['MAX'];
        return null;
    }

    public function deleteScore($id)
    {
         return $this->p_delete("delete from score where idscore = ?","i",$id);
    }

    public function deleteIfExists($uid,$evaluationid,$phaseid,$respid,$quest,$sub)
    {
        if ($score = $this->getScoreDetail($uid,$evaluationid,$phaseid,$respid,$quest,$sub) )
        {
            $this->deleteScore($score['idscore']);
        }
    }

    public function deleteAllScoresForEval($evalid)
    {
        $this->p_delete("delete from score where score_evaluation = ?","i",$evalid);
    }

    //*********************************************************************
    // Audit
    //*********************************************************************
    public function getFirstScoreAudit($evalid,$userid,$phaseid,$questionid,$subid,$respondentid)
    {
        if ($subid)
        {
            return $this->p_singlequery("select * from audit where audit_type = 'Score' and audit_evaluation = ? and audit_user = ? and audit_phase = ? and audit_question = ? and audit_sub = ? and audit_respondent = ? order by audit_timestamp limit 1","iiiiii",$evalid,$userid,$phaseid,$questionid,$subid,$respondentid);
        }
        else
        {
            return $this->p_singlequery("select * from audit where audit_type = 'Score' and audit_evaluation = ? and audit_user = ? and audit_phase = ? and audit_question = ? and audit_sub is null and audit_respondent = ? order by audit_timestamp limit 1","iiiii",$evalid,$userid,$phaseid,$questionid,$respondentid);
        }
    }

    public function getFirstScoreAuditForUser($evalid,$userid)
    {
        return $this->p_singlequery("select * from audit where audit_type = 'Score' and audit_evaluation = ? and audit_user = ? order by audit_timestamp limit 1","ii",$evalid,$userid);
    }

    public function getLastScoreAuditForUser($evalid,$userid)
    {
        return $this->p_singlequery("select * from audit where audit_type = 'Score' and audit_evaluation = ? and audit_user = ? order by audit_timestamp desc limit 1","ii",$evalid,$userid);
    }

    public function FirstScoreAuditForUserForPhase($evalid,$userid,$phaseid)
    {
        return $this->p_singlequery("select * from audit where audit_type = 'Score' and audit_evaluation = ? and audit_user = ? and audit_phase =  ? order by audit_timestamp limit 1","iii",$evalid,$userid,$phaseid);
    }

    public function FirstScoreAuditForUserForPhaseForTeam($evalid,$userid,$phaseid,$teamid)
    {
        $tid = intval($teamid);
        $q = "select * from audit where audit_type = 'Score' and audit_evaluation = ? and audit_user = ? and audit_phase =  ? order by audit_timestamp";
        $r = $this->p_query($q,"iii",$evalid,$userid,$phaseid);
        if (!$r) {$this->sqlError($q); return null;}
        while ($audit = $r->fetch_array(MYSQLI_ASSOC))
        {
            if ($this->hasTeamQuestion($tid,$audit['audit_question']) )
                return $audit;
        }
        return null;
    }

    public function LastScoreAuditForUserForPhase($evalid,$userid,$phaseid)
    {
        return $this->p_singlequery("select * from audit where audit_type = 'Score' and audit_evaluation = ? and audit_user = ? and audit_phase = ? order by audit_timestamp desc limit 1","iii",$evalid,$userid,$phaseid);
    }

    public function LastScoreAuditForUserForPhaseForTeam($evalid,$userid,$phaseid,$teamid)
    {
        $tid = intval($teamid);
        $q = "select * from audit where audit_type = 'Score' and audit_evaluation = ? and audit_user = ? and audit_phase =  ? order by audit_timestamp desc";
        $r = $this->p_query($q,"iii",$evalid,$userid,$phaseid);
        if (!$r) {$this->sqlError($q); return null;}
        while ($audit = $r->fetch_array(MYSQLI_ASSOC))
        {
            if ($this->hasTeamQuestion($tid,$audit['audit_question']) )
                return $audit;
        }
        return null;
    }

    public function FirstScoreAuditForForPhase($evalid,$phaseid)
    {
        return $this->p_singlequery("select * from audit where audit_type = 'Score' and audit_evaluation = ? and audit_phase = ? order by audit_timestamp limit 1","ii",$evalid,$phaseid);
    }

    public function LastScoreAuditForForPhase($evalid,$phaseid)
    {
        return $this->p_singlequery("select * from audit where audit_type = 'Score' and audit_evaluation = ? and audit_phase = ? order by audit_timestamp desc limit 1","ii",$evalid,$phaseid);
    }

    public function FirstScoreAuditForForPhaseTeam($evalid,$phaseid,$teamid)
    {
        $tid = intval($teamid);
        $q = "select * from audit where audit_type = 'Score' and audit_evaluation = ? and audit_phase =  ? order by audit_timestamp";
        $r = $this->p_query($q,"ii",$evalid,$phaseid);
        if (!$r) {$this->sqlError($q); return null;}
        error_log("count audit records = {$r->num_rows}");
        while ($audit = $r->fetch_array(MYSQLI_ASSOC))
        {
            if ($this->hasTeamQuestion($tid,$audit['audit_question']) )
                return $audit;
        }
        return null;
    }

    public function LastScoreAuditForForPhaseTeam($evalid,$phaseid,$teamid)
    {
        $tid = intval($teamid);
        $q = "select * from audit where audit_type = 'Score' and audit_evaluation = ? and audit_phase =  ? order by audit_timestamp desc";
        $r = $this->p_query($q,"ii",$evalid,$phaseid);
        if (!$r) {$this->sqlError($q); return null;}
        while ($audit = $r->fetch_array(MYSQLI_ASSOC))
        {
            if ($this->hasTeamQuestion($tid,$audit['audit_question']) )
                return $audit;
        }
        return null;
    }

    public function numScoreAuditsForUserForPhase($evalid,$userid,$phaseid)
    {
        $q = "select * from audit where audit_type = 'Score' and audit_evaluation = ? and audit_user = ? and audit_phase = ? order by audit_timestamp";
        $r = $this->p_query($q,"iii",$evalid,$userid,$phaseid);
        if (!$r) {$this->sqlError($q); return null;}
        return intval($r->num_rows);
    }

    public function createAudit($type,$user,$desc,$tablename='',$tablekey=0)
    {
        $strTime = (new DateTime())->format('Y-m-d H:i:s');
        $ipaddr = '';

        if (isset($_SERVER['REMOTE_ADDR']))
            $ipaddr = $_SERVER['REMOTE_ADDR'];

        if ($user)
        {
            $iduser = $user['iduser'];
            return $this->p_create("insert into audit (audit_type,audit_table,audit_tablekey,audit_description,audit_user,audit_ipaddress,audit_timestamp) values (?,?,?,?,?,?,?)","ssssiss",$type,$tablename,$tablekey,$desc,$iduser,$ipaddr,$strTime);
        }
        else
            return $this->p_create("insert into audit (audit_type,audit_table,audit_tablekey,audit_description,audit_ipaddress,audit_timestamp) values (?,?,?,?,?,?)","ssssss",$type,$tablename,$tablekey,$desc,$ipaddr,$strTime);
    }

    public function createRollingAudit($entity,$rate)
    {
        $desc = "Rolling breach for {$entity} rate: {$rate}";
        $this->createSecurityAudit(null,$desc);
    }

    public function createSecurityAudit($user,$text)
    {
        $strTime = (new DateTime())->format('Y-m-d H:i:s');
        $ipaddr = '';
        $d = $this->real_escape_string($text);

        if (isset($_SERVER['REMOTE_ADDR']))
            $ipaddr = $_SERVER['REMOTE_ADDR'];
        if ($user)
        {
            $uid = intval($user['iduser']);
            return $this->p_create("insert into audit (audit_type,audit_user,audit_ipaddress,audit_timestamp,audit_description) values ('Security',?,?,?,?)","isss",$uid,$ipaddr,$strTime,$d);
        }
        else
            return $this->p_create("insert into audit (audit_type,audit_ipaddress,audit_timestamp,audit_description) values ('Security',?,?,?)","sss",$ipaddr,$strTime,$d);
    }

    public function createScoreAudit($user,$evalid,$phaseid,$respondentid,$questionid,$subid,$score)
    {
        $strTime = (new DateTime())->format('Y-m-d H:i:s');
        $ipaddr = '';
        $iduser = $user ? $user['iduser'] : null;
        if (isset($_SERVER['REMOTE_ADDR']))
            $ipaddr = $_SERVER['REMOTE_ADDR'];
        if ($score)
            return $this->p_create("insert into audit (audit_type,audit_user,audit_ipaddress,audit_timestamp,audit_evaluation,audit_phase,audit_respondent,audit_question,audit_sub,audit_score) values ('Score',?,?,?,?,?,?,?,?,?)","issiiiiii",$iduser,$ipaddr,$strTime,$evalid,$phaseid,$respondentid,$questionid,$subid,$score);
        else
            return $this->p_create("insert into audit (audit_type,audit_user,audit_ipaddress,audit_timestamp,audit_evaluation,audit_phase,audit_respondent,audit_question,audit_sub,audit_score) values ('Score',?,?,?,?,?,?,?,?,null)","issiiiii",$iduser,$ipaddr,$strTime,$evalid,$phaseid,$respondentid,$questionid,$subid);
    }

    public function createCommentAudit($user,$evalid,$phaseid,$respondentid,$questionid,$subid,$comment)
    {
        $strTime = (new DateTime())->format('Y-m-d H:i:s');
        $strcomment = $this->real_escape_string(str_replace("\x92", "'", $comment));
        $iduser = ($user) ? $user['iduser'] : null;
        $ipaddr = '';
        if (isset($_SERVER['REMOTE_ADDR']))
            $ipaddr = $_SERVER['REMOTE_ADDR'];
        return $this->p_create("insert into audit (audit_type,audit_user,audit_ipaddress,audit_timestamp,audit_evaluation,audit_phase,audit_respondent,audit_question,audit_sub,audit_comment) values ('Comment',?,?,?,?,?,?,?,?,?)","issiiiiis",$iduser,$ipaddr,$strTime,$evalid,$phaseid,$respondentid,$questionid,$subid,$strcomment);
    }

    public function createNewUserAudit($userid,$newuserid)
    {
        $strTime = (new DateTime())->format('Y-m-d H:i:s');
        $ipaddr = '';
        if (isset($_SERVER['REMOTE_ADDR']))
            $ipaddr = $_SERVER['REMOTE_ADDR'];
        return $this->p_create("insert into audit (audit_type,audit_user,audit_ipaddress,audit_timestamp,audit_newuserid) values ('newuser',?,?,?,?)","issi",$userid,$ipaddr,$strTime,$newuserid);
    }

    public function createDeleteUserAudit($userid,$newuserid)
    {
        $strTime = (new DateTime())->format('Y-m-d H:i:s');
        $ipaddr = '';
        if (isset($_SERVER['REMOTE_ADDR']))
            $ipaddr = $_SERVER['REMOTE_ADDR'];
        return $this->p_create("insert into audit (audit_type,audit_user,audit_ipaddress,audit_timestamp,audit_newuserid) values ('deluser',?,?,?,?)","issi",$userid,$ipaddr,$strTime,$newuserid);
    }

    public function createUnDeleteUserAudit($userid,$newuserid)
    {
        $strTime = (new DateTime())->format('Y-m-d H:i:s');
        $ipaddr = '';
        if (isset($_SERVER['REMOTE_ADDR']))
            $ipaddr = $_SERVER['REMOTE_ADDR'];
        return $this->p_create("insert into audit (audit_type,audit_user,audit_ipaddress,audit_timestamp,audit_newuserid) values ('undeluser',?,?,?,?)","issi",$userid,$ipaddr,$strTime,$newuserid);
    }

    public function createUserAccountLockedAudit($userid)
    {
        $strTime = (new DateTime('now'))->format('Y-m-d H:i:s');
        $ipaddr = (isset($_SERVER['REMOTE_ADDR'])) ? $_SERVER['REMOTE_ADDR'] : '';
        return $this->p_create("insert into audit (audit_type,audit_user,audit_ipaddress,audit_timestamp) values ('acctlocked',?,?,?)","iss",$userid,$ipaddr,$strTime);
    }

    public function createUserAccountUnLockedAudit($userid,$unlockuserid)
    {
        $strTime = (new DateTime('now'))->format('Y-m-d H:i:s');
        $ipaddr = (isset($_SERVER['REMOTE_ADDR'])) ? $_SERVER['REMOTE_ADDR'] : '';
        return $this->p_create("insert into audit (audit_type,audit_user,audit_ipaddress,audit_timestamp,audit_newuserid) values ('acctunlocked',?,?,?,?)","issi",$userid,$ipaddr,$strTime,$newuserid);
    }

    public function createTeamEnableAudit($userid,$evalid,$state)
    {
        $strTime = (new DateTime())->format('Y-m-d H:i:s');
        $ipaddr = '';
        if (isset($_SERVER['REMOTE_ADDR']))
            $ipaddr = $_SERVER['REMOTE_ADDR'];
        $uid = intval($userid);
        $evid = intval($evalid);
        return $this->p_create("insert into audit (audit_type,audit_user,audit_ipaddress,audit_timestamp,audit_evaluation,audit_comment) values ('teamstate',?,?,?,?,?)","issis",$uid,$ipaddr,$strTime,$evid,$state);
    }

    public function createPhaseStateChangeAudit($userid,$evalid,$phaseid,$state)
    {
        $strTime = (new DateTime())->format('Y-m-d H:i:s');
        $ipaddr = '';
        if (isset($_SERVER['REMOTE_ADDR']))
            $ipaddr = $_SERVER['REMOTE_ADDR'];
        $uid = intval($userid);
        $evid = intval($evalid);
        $pid = intval($phaseid);
        return $this->p_create("insert into audit (audit_type,audit_user,audit_ipaddress,audit_timestamp,audit_evaluation,audit_phase,audit_comment) values ('phasestate',?,?,?,?,?,?)","issiis",$uid,$ipaddr,$strTime,$evid,$pid,$state);
    }

    public function createEmailSendAudit($userid,$senttouserid,$emailaddr,$status)
    {
        $strTime = (new DateTime())->format('Y-m-d H:i:s');
        $ipaddr = '';
        if (isset($_SERVER['REMOTE_ADDR']))
            $ipaddr = $_SERVER['REMOTE_ADDR'];
        if ($status)
            return $this->p_create("insert into audit (audit_type,audit_user,audit_ipaddress,audit_timestamp,audit_newuserid,audit_email_address,audit_email_status) values ('emailsent',?,?,?,?,?,true)","issis",$userid,$ipaddr,$strTime,$senttouserid,$emailaddr);
        else
            return $this->p_create("insert into audit (audit_type,audit_user,audit_ipaddress,audit_timestamp,audit_newuserid,audit_email_address,audit_email_status) values ('emailsent',?,?,?,?,?,false)","issis",$userid,$ipaddr,$strTime,$senttouserid,$emailaddr);
    }

    public function createDocAccessAudit($userid,$docid)
    {
        $strTime = (new DateTime())->format('Y-m-d H:i:s');
        $ipaddr = '';
        if (isset($_SERVER['REMOTE_ADDR']))
            $ipaddr = $_SERVER['REMOTE_ADDR'];
        return $this->p_create("insert into audit (audit_type,audit_user,audit_ipaddress,audit_timestamp,audit_doclist) values ('doclistread',?,?,?,?)","issi",$userid,$ipaddr,$strTime,$docid);
    }

    public function createDocNewRoomAudit($userid,$docid)
    {
        $strTime = (new DateTime())->format('Y-m-d H:i:s');
        $ipaddr = '';
        if (isset($_SERVER['REMOTE_ADDR']))
            $ipaddr = $_SERVER['REMOTE_ADDR'];
        return $this->p_create("insert into audit (audit_type,audit_user,audit_ipaddress,audit_timestamp,audit_doclist) values ('doclistroom',?,?,?,?)","issi",$userid,$ipaddr,$strTime,$docid);
    }

    public function createDocNewFolderAudit($userid,$docid)
    {
        $strTime = (new DateTime())->format('Y-m-d H:i:s');
        $ipaddr = '';
        if (isset($_SERVER['REMOTE_ADDR']))
            $ipaddr = $_SERVER['REMOTE_ADDR'];
        return $this->p_create("insert into audit (audit_type,audit_user,audit_ipaddress,audit_timestamp,audit_doclist) values ('doclistfolder',?,?,?,?)","issi",$userid,$ipaddr,$strTime,$docid);
    }

    public function createDocUploadAudit($userid,$docid)
    {
        $strTime = (new DateTime())->format('Y-m-d H:i:s');
        $ipaddr = '';
        if (isset($_SERVER['REMOTE_ADDR']))
            $ipaddr = $_SERVER['REMOTE_ADDR'];
        return $this->p_create("insert into audit (audit_type,audit_user,audit_ipaddress,audit_timestamp,audit_doclist) values ('doclistupload',?,?,?,?)","issi",$userid,$ipaddr,$strTime,$docid);
    }

    public function createDocDeleteAudit($userid,$docid)
    {
        $strTime = (new DateTime())->format('Y-m-d H:i:s');
        $ipaddr = '';
        if (isset($_SERVER['REMOTE_ADDR']))
            $ipaddr = $_SERVER['REMOTE_ADDR'];
        return $this->p_create("insert into audit (audit_type,audit_user,audit_ipaddress,audit_timestamp,audit_doclist) values ('doclistdelete',?,?,?,?)","issi",$userid,$ipaddr,$strTime,$docid);
    }

    public function createDocUnDeleteAudit($userid,$docid)
    {
        $strTime = (new DateTime())->format('Y-m-d H:i:s');
        $ipaddr = '';
        if (isset($_SERVER['REMOTE_ADDR']))
            $ipaddr = $_SERVER['REMOTE_ADDR'];
        return $this->p_create("insert into audit (audit_type,audit_user,audit_ipaddress,audit_timestamp,audit_doclist) values ('doclistundelete',?,?,?,?)","issi",$userid,$ipaddr,$strTime,$docid);
    }

    public function allAudits()
    {
        $q = "SELECT * from audit left join user a on a.iduser = audit_user left join doclist b on b.iddoclist = audit_doclist order by audit_timestamp";
        $r = $this->query_useresult($q);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allAuditsDoclistForUser($userid)
    {
        $q = "SELECT * from audit left join doclist a on a.iddoclist = audit_doclist where audit_user = ? and (audit_type = 'newuser' or audit_type = 'doclistread' or audit_type = 'doclistfolder' or audit_type = 'doclistupload' or audit_type = 'doclistdelete' or audit_type = 'doclistundelete' or audit_type = 'login') order by audit_timestamp";
        $r = $this->p_query($q,"i",$userid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allAuditByDocUser()
    {
        $q = "select * from audit left join doclist a on a.iddoclist = audit_doclist left join user b on b.iduser = audit_user where audit_type = 'doclistread' or audit_type = 'doclistfolder' or audit_type = 'doclistupload' or audit_type = 'doclistdelete' or audit_type = 'doclistundelete' order by a.doclist_title , a.doclist_version, audit_timestamp";
        $r = $this->p_query($q,null,null);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allAuditsForUser($userid)
    {
        $q = "SELECT * from audit left join doclist a on a.iddoclist = audit_doclist where audit_user = ? order by audit_timestamp";
        $r = $this->p_query($q,"i",$userid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allAuditPhaseStatesForPhase($phaseid)
    {
        $q = "SELECT * from audit left join user a on a.iduser = audit_user where audit_type = 'phasestate' and audit_phase = ? order by audit_timestamp";
        $r = $this->p_query($q,"i",$phaseid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function allSecurityAudits()
    {
        $q = "SELECT * from audit left join user a on a.iduser = audit_user where audit_type = 'Security' or audit_type = 'nouser' or audit_type = 'acctlocked' or audit_type = 'invpassword' order by audit_timestamp";
        $r = $this->p_query($q,null,null);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function firstScoreForEval($evalid)
    {
        return $this->p_singlequery("select * from audit where audit_evaluation = ? and audit_type = 'Score' order by audit_timestamp limit 1","i",$evalid);
    }

    public function lastScoreForEval($evalid)
    {
        return $this->p_singlequery("select * from audit where audit_evaluation = ? and audit_type = 'Score' order by audit_timestamp desc limit 1","i",$evalid);
    }

    public function buildDocListFullNameStr($docid,$str='')
    {
        $newstr = $str;
        $d = $this->p_singlequery("SELECT * from doclist where iddoclist = ?","i",$docid);
        if (strlen($newstr) > 0)
            $newstr = $d['doclist_title'] . "/" . $newstr;
        else
            $newstr = $d['doclist_title'];
        if ($d['doclist_parent'])
            return $this->buildDocListFullNameStr($d['doclist_parent'],$newstr);
        else
            return $newstr;
    }

    //*********************************************************************
    // DocList
    //*********************************************************************
    public function getDoc($id)
    {
        return $this->p_singlequery("SELECT * from doclist where iddoclist = ?","i",$id);
    }

    public function getUserHasDoc($userid,$docid)
    {
        return $this->p_singlequery("SELECT * from user_has_doclist where user_iduser = ? and doclist_iddoclist = ?","ii",$userid,$docid);
    }

    public function getDocRoot($id)
    {
        $n = intval($id);
        while (!is_null($n))
        {
            $rec = $this->getDoc($n);
            if(is_null($rec['doclist_parent'] ))
                return $rec;
            $n = $rec['doclist_parent'];
        }
        return null;
    }

    public function userhasdocaccess($userid,$docid)
    {
        //User has permission as long as any parent back is OK.
        $n = $docid;
        while (!is_null($n))
        {
            if ($p = $this->getUserHasDoc($userid,$n)  )
            {
                return boolval($p['doclist_permission']);
            }
            else
            {
                $rec = $this->getDoc($n);
                if(is_null($rec['doclist_parent'] ))
                    return false;
                $n = $rec['doclist_parent'];
            }
        }
    }

    public function userhasdoc($userid,$docid)
    {
        if ($uhd = $this->p_singlequery("SELECT * from user_has_doclist where user_iduser = ? and doclist_iddoclist = ?","ii",$userid,$docid) )
        {
            return $uhd['doclist_permission'];
        }
        else
            return false;
    }

    public function userhasanydoc($userid)
    {
        $r = $this->p_query("SELECT * from user_has_doclist where user_iduser = ? and doclist_permission <> 0","i",$userid);
        if ($r->num_rows > 0)
            return true;
        return false;
    }

    public function getAllChildren($id)
    {
        if (is_null($id))
            $q = "SELECT * from doclist where doclist_parent is null and not doclist_deleted order by doclist_type,doclist_title";
        else
            $q = "SELECT * from doclist where doclist_parent = ? and not doclist_deleted order by doclist_type,doclist_title";
        $r = $this->p_query($q,"i",$id);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function getAllChildrenInclDeleted($id)
    {
        if (is_null($id))
        {
            $q = "SELECT * from doclist where doclist_parent is null order by doclist_type,doclist_title,doclist_version desc";
            $r = $this->p_query($q,null,null);
        }
        else
        {
            $q = "SELECT * from doclist where doclist_parent = ".intval($id)." order by doclist_type,doclist_title,doclist_version desc";
            $r = $this->p_query($q,"i",$id);
        }
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }


    public function getChildren($userid,$id)
    {
        if (is_null($id) )
        {
            $q = "SELECT * from user_has_doclist left join doclist a on a.iddoclist = doclist_iddoclist where user_iduser = ? and a.doclist_parent is null and not doclist_deleted order by a.doclist_title, a.doclist_version desc";
            $r = $this->p_query($q,"i",$userid);
        }
        else
        {
            $q = "SELECT * from doclist where doclist_parent = ? and not doclist_deleted order by doclist_type,doclist_title,doclist_version desc";
            $r = $this->p_query($q,"i",$id);
        }
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function newRoom($userid,$title)
    {
        $rslt = null;
        $u = 0;
        $did = null;
        $t = $this->displayText($title);
        if (!is_null($userid) )
            $u = intval($userid);
        $strTime = (new DateTime())->format('Y-m-d H:i:s');
        $rslt =  $this->p_create("insert into doclist (doclist_type,doclist_parent,doclist_title,doclist_user,doclist_timestamp) values ('0room',null,?,?,?)","sis",$t,$u,$strTime);
        if ($rslt)
        {
            $did = $this->insert_id;
            //Create the audit
            $this->createDocNewRoomAudit($userid,$did);
        }
        return $did;
    }

    public function newFolder($userid,$title,$parentid=null)
    {
        $rslt = null;
        $u = 0;
        $did = null;
        $t = $this->displayText($title);
        if (!is_null($userid) )
            $u = intval($userid);
        $strTime = (new DateTime())->format('Y-m-d H:i:s');
        if (is_null($parentid) )
            $rslt =  $this->p_create("insert into doclist (doclist_type,doclist_parent,doclist_title,doclist_user,doclist_timestamp) values ('1folder',null,'?,?,?)","sis",$t,$u,$strTime);
        else
        {
            $pid = intval($parentid);
            $rslt = $this->p_create("insert into doclist (doclist_type,doclist_parent,doclist_title,doclist_user,doclist_timestamp) values ('1folder',?,?,?,?')","isis",$pid,$t,$u,$strTime);
        }
        if ($rslt)
        {
            $did = $this->insert_id;
            //Create the audit
            $this->createDocNewFolderAudit($userid,$this->insert_id);
        }
        return $did;
    }

    public function newFile($userid,$title,$desc,$file,$mime,$size,$signature='',$parentid=null)
    {
        $t = $this->displayText($title);
        $d = $this->displayText($desc);
        if (!is_null($userid) )
            $u = intval($userid);
        $strTime = (new DateTime())->format('Y-m-d H:i:s');
        $sz = intval($size);
        $rslt = null;
        $version = 1;
        //Check that we do not already have this document.
        $olddoc = null;
        $q = '';
        if (is_null($parentid))
        {
            $olddoc = $this->p_singlequery("select * from doclist where doclist_parent is null and doclist_title = ? order by doclist_version desc limit 1","s",$t);
        }
        else
        {
            $olddoc = $this->p_singlequery("select * from doclist where doclist_parent = ? and doclist_title = ? order by doclist_version desc limit 1","is",$parentid,$t);
        }
        if ($olddoc)
        {
            $version = intval($olddoc['doclist_version']) + 1;
            error_log("Found a duplicate document, next version = {$version} prev version {$olddoc['doclist_version']}");
        }
        else
        {
            error_log("Did not fina a duplicate document, Q = {$q} next version = {$version}");
        }

        if (is_null($parentid) )
            $rslt =  $this->p_create("insert into doclist (doclist_type,doclist_parent,doclist_title,doclist_version,doclist_description,doclist_user,doclist_file,doclist_mime,doclist_size,doclist_timestamp,doclist_signature) values ('2doc',null,?,?,?,?,?,?,?,?,?)","sisississ",$t,$version,$d,$u,$file,$mime,$sz,$strTime,$signature);
        else
        {
            $pid = intval($parentid);
            $rslt =  $this->p_create("insert into doclist (doclist_type,doclist_parent,doclist_title,doclist_version,doclist_description,doclist_user,doclist_file,doclist_mime,doclist_size,doclist_timestamp,doclist_signature) values ('2doc',?,?,?,?,?,?,?,?,?,?)","isisississ",$pid,$t,$version,$d,$u,$file,$mime,$sz,$strTime,$signature);
        }
        if ($rslt)
            $this->createDocUploadAudit($userid,$this->insert_id);
        return $rslt;
    }

    public function deleteDoclist($docid,$userid)
    {
        $strTime = (new DateTime())->format('Y-m-d H:i:s');
        return $this->p_update("update doclist set doclist_deleted = 1, doclist_deleted_user = ?, doclist_deleted_timestamp = ? where iddoclist = ?","isi",$userid,$strTime,$docid);
    }

    public function undeleteDoclist($docid)
    {
        return $this->p_update("update doclist set doclist_deleted = 0, doclist_deleted_user = null, doclist_deleted_timestamp = null where iddoclist = ?","i",$docid);
    }

    public function updateDocName($docid,$newname)
    {
        return $this->p_update("update doclist set doclist_title = ? where iddoclist = ?","si",$t,$docid);
    }

    public Function createUserHasDoc($userid,$docid,$grant)
    {
        if ($grant)
            return $this->p_create("insert into user_has_doclist (user_iduser,doclist_iddoclist,doclist_permission) values (?,?,true)","ii",$userid,$docid);
        else
            return $this->p_create("insert into user_has_doclist (user_iduser,doclist_iddoclist,doclist_permission) values (?,?,false)","ii",$userid,$docid);
    }

    public function changeDoclistPermission($userid,$docid,$grant)
    {
        if ($uhd = $this->p_singlequery("SELECT * from user_has_doclist where user_iduser = ? and doclist_iddoclist = ?","ii",$userid,$docid ) )
        {
            if ($uhd['doclist_permission'] != $grant )
            {
                $uhd['doclist_permission'] = $grant;
                $this->update_from_array('user_has_doclist',$uhd,"where user_iduser = ".intval($userid)." and doclist_iddoclist = " . intval($docid));
            }
        }
        else
        {
            $this->createUserHasDoc($userid,$docid,$grant);
        }
    }

    //*********************************************************************
    // Message
    //*********************************************************************
    public function getMessage($id)
    {
        return $this->p_singlequery("SELECT * from message where idmessage = ?","i",$id);
    }

    public function getMessageBySmsId($idsms)
    {
        return $this->p_singlequery("SELECT * from message where message_sms_id = ?","i",$idsms);
    }

    public function createNewSmsMessage($userid,$text,$smsid,$to,$status)
    {
        $t1 = $this->displayText($text);
        $q = "insert into message (message_type,message_user,message_text,message_sms_id,message_to,message_status) values ('SMS',?,?,?,?,?)";
        $r = $this->p_create($q,"isiss",$userid,$t1,$smsid,$to,$status);
        if (!$r) {$this->sqlError($q); return null;}
        return true;
    }

    public function updateSmsStatus($smsid,$status)
    {
        $strTime = (new DateTime())->format('Y-m-d H:i:s');
        return $this->p_update("update message set message_status = ?, message_timestamp_sent = ? where message_sms_id = ?","ssi",$status,$strTime,$smsid);
    }

    public function allMessages($order='')
    {
        $q = "SELECT * from message left join user a on a.iduser = message_user {$order}";
        $r = $this->p_query($q,null,null);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }


    //*********************************************************************
    // flag
    //*********************************************************************
    public function flagUser($userid,$type)
    {
        $strTime = (new DateTime())->format('Y-m-d H:i:s');
        return $this->p_create("insert into flag (flag_user,flag_timestamp,flag_type) values (?,?,?)","iss",$userid,$strTime,$type);
    }

    public function deleteFlag($userid,$type)
    {
        return $this->p_delete("delete from flag where flag_user = ? and flag_type = ?","is",$userid,$type);
    }

    public function haveFlag($userid,$type)
    {
        $s = $this->p_singlequery("select * from flag where flag_user = ? and flag_type = ?","is",$userid,$type);
        if ($s)
            return true;
        return false;
    }

    //*********************************************************************
    // mime
    //*********************************************************************
    public function getMime($mimeid)
    {
        return $this->p_singlequery("SELECT * from mime where idmime = ?","i",$mimeid);
    }

    public function allMimes()
    {
        $q = "SELECT * from mime order by mime_name";
        $r = $this->p_query($q,null,null);
        if (!$r) {$this->sqlError($q); return null;}
        return $r;
    }

    public function getMimeByMime($mimename)
    {
        return $this->p_singlequery("SELECT * from mime where mime_mime = ?","s",$mimename);
    }

    public function enableMime($id)
    {
        $mimeid = intval($id);
        return $this->p_update("update mime set mime_enabled = 1 where idmime = ?","i",$mimeid);
    }

    public function disableAllMimes()
    {
        return $this->p_update("update mime set mime_enabled = 0",null,null);
    }

    //*********************************************************************
    // rolling
    //*********************************************************************
    public function getRollingByName($name)
    {
        return $this->p_singlequery("select * from rolling where rolling_entity = ?","s",$name);
    }

    public function createRolling($name,$modulus=10,$target=0.1)
    {
        return $this->p_create("insert into rolling (rolling_entity,rolling_modulus,rolling_target,rolling_idx,rolling_disable_seconds) values (?,?,?,0,3600)","sid",$name,$modulus,$target);
    }

    public function updateRolling($name,$count,$values)
    {
        return $this->p_update("update rolling set rolling_idx = ?, rolling_counters = ? where rolling_entity = ?","iss",$count,$values,$name);
    }

    public function resetRolling($name)
    {
        return $this->p_update("update rolling set rolling_entity_disabled = 0 where rolling_entity = ?","s",$name);
    }

    public function markRollingDisabled($name)
    {
        $dt = new DateTime('now');
        $strTime = $dt->format('Y-m-d H:i:s');
        return $this->p_update("update rolling set rolling_entity_disabled = 1, rolling_disable_timestamp = ? where rolling_entity = ?","ss",$strTime,$name);
    }

    //*********************************************************************
    // control
    //*********************************************************************
    public function getControl()
    {
        return $this->p_singlequery("select * from control",null,null);
    }

    public function suspendInstance()
    {
        $control = $this->getControl();
        $strTime = (new DateTime('Y-m-d H:i:s'))->format();
        $status = $control['control_status'];
        return $this->p_update("update control set control_enabled = 0,control_status = 'suspended' , control_prior_status = ?, control_change_timestamp = ?","ss",$status,$strTime);
    }

    public function reactivateInstance()
    {
        $control = $this->getControl();
        $strTime = (new DateTime('Y-m-d H:i:s'))->format();
        $status = $control['control_status'];
        return $this->p_update("update control set control_enabled = 1,control_status = 'active' , control_prior_status = ?, control_change_timestamp = ?","ss",$status,$strTime);
    }

    //*********************************************************************
    // Routines
    //*********************************************************************
    public function checkWeightings($evalid)
    {
        $v = $this->p_singlequery("SELECT sum(question_weighting) as SUM from question where question_evaluation = ?","i",$evalid);
        return floatval($v['SUM']);
    }

    public function purgeEvaluation($evalid)
    {
        $this->deleteAllScoresForEval($evalid);
        $r = $this->deleteQuestionFromTeamsForAllEval($evalid);
        $r = $this->allQuestionsForEval($evalid);
        while ($quest = $r->fetch_array())
        {
            $this->deleteSubAttributesForQuestion($quest['idquestion']);
        }
        $this->p_delete("delete from question where question_evaluation = ?","i",$evalid);
        $this->p_delete("delete from section where section_evaluation = ?","i",$evalid);
    }

    public function numAnswersForQuestion($evalid,$phaseid,$qid)
    {
        $q = "select * from score where score_evaluation = ? and score_phase = ? and score_question = ? and score_score is not null";
        $r = $this->p_query($q,"iii",$evalid,$phaseid,$qid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r->num_rows;
    }

    public function numAnswersForSub($evalid,$phaseid,$subid)
    {
        $q = "select * from score where score_evaluation = ? and score_phase = ? and score_subattribute = ? and score_score is not null";
        $r = $this->p_query($q,"iii",$evalid,$phaseid,$subid);
        if (!$r) {$this->sqlError($q); return null;}
        return $r->num_rows;
    }

    public function getProgress($evalid,$phaseid)
    {
        $data = array();
        $teams = array();
        $users = array();

        $num_respondents = $this->numOfRespondents($evalid);
        $r = $this->allTeamsForEval($evalid,'order by team_name');
        while ($team = $r->fetch_array())
        {
            $t = array();
            $t['id'] = $team['idteam'];
            $t['name'] = $team['team_name'];
            $t['enabled'] = $team['team_enabled'];
            $t['phaseid'] = $phaseid;

            $num_evalsforteam = $this->numUsersForTeamForPhase($team['idteam'],$phaseid);
            $t['evaluators'] = $num_evalsforteam;


            //Find out how many subattributes or questions there are for this team
            $tot = 0;
            $r2 = $this->allQuestionsForTeam($team['idteam']);
            while ($question = $r2->fetch_array())
            {
                $nSubs = $this->numOfSubsForQuestion($question['idquestion']);
                if ($nSubs == 0)
                    $nSubs = 1;
                $tot += $nSubs;
            }
            $totals = array();

            $totals['totscoresperevaluator'] = $tot * $num_respondents;
            $totals['totscores'] = $tot * $num_respondents * $num_evalsforteam;


            $users2 = array();
            $tot_answered = 0;

            $r1 = $this->allUsersForTeam($team['idteam']);
            while ($user = $r1->fetch_array())
            {
                //Check that this user is assigned to evalutae this phase
                if ($this->userHasPhase($user['iduser'],$phaseid) )
                {
                    $u = array();
                    $u['id'] = $user['iduser'];
                    $u['name'] = $user['user_name'];

                    //Nowfind out how many score for the question in this team.
                    $answered = 0;
                    $r3 = $this->allQuestionsForTeam($team['idteam']);
                    while ($qeest = $r3->fetch_array())
                    {
                        $answered += $this->numScoresFor($evalid,$phaseid,$user['iduser'],$qeest['idquestion']);
                    }
                    $u['scored'] = $answered;
                    $tot_answered += $answered;

                    array_push($users2,$u);
                }
            }

            $totals['totanswered'] = $tot_answered;

            $t['totals'] = $totals;

            $t['users'] = $users2;


            array_push($teams,$t);
        }


        $r = $this->allUsersForEval($evalid);
        while ($user = $r->fetch_array())
        {
            if ($this->userHasPhase($user['iduser'],$phaseid) )
            {
                $u = array();
                $u['id'] = $user['iduser'];
                $u['name'] = $user['user_name'];

                $tot = 0;
                $r1 = $this->allTeamsForUserForEval($evalid,$user['iduser']);
                while ($team = $r1->fetch_array())
                {
                    $r2 = $this->allQuestionsForTeam($team['idteam']);
                    while ($question = $r2->fetch_array())
                    {
                        $nSubs = $this->numOfSubsForQuestion($question['idquestion']);
                        if ($nSubs == 0)
                            $nSubs = 1;
                        $tot += $nSubs;
                    }
                }
                $u['totalscores'] = $tot * $num_respondents;

                $u['scored'] = $this->numScoresForUser($evalid,$phaseid,$user['iduser']);
                array_push($users,$u);
            }
        }

        $data['evaluation'] = $evalid;
        $data['phase'] = $phaseid;
        $data['teams'] = $teams;
        $data['users'] = $users;
        return $data;
    }

    public function preValidation($evalid)
    {
        $n = $this->numOfRespondents($evalid);
        $result = array();
        $weightings = array();
        $questweightings = array();
        $subweightings = array();
        $subweightingserrors = array();
        $respondents = array();
        $phases = array();
        $assigned_questions = array();
        $have_error = false;
        $phase_error = false;



        //Check weightings
        $questweightings['status'] = true;
        $subweightings['status'] = true;
        $evaluation = $this->getEvaluation($evalid);
        $weighting_sum = 0.0;
        $r = $this->allQuestionsForEval($evalid);
        while ($question = $r->fetch_array())
        {
            $weighting_sum += floatval($question['question_weighting']);

            //Now check and sub attribute weigtings
            $r1 = $this->allSubForQuestion($question['idquestion']);
            if ($r1->num_rows > 0)
            {
                $weighting_sum_sub = 0.0;
                while ($sub = $r1->fetch_array())
                {
                    $weighting_sum_sub += floatval($sub['subattribute_weighting']);
                }
                if (abs($weighting_sum_sub - 1.0) > 0.0001)
                {
                    $suberror = array();
                    $strWSum = number_format(floatval(intval(($weighting_sum_sub+0.00005) * 10000.0)) / 100.0,2) . "%";
                    $suberror = "Sum of weightings for subattributes to question {$question['question_identifier']} do not add to 100% - calculated: {$strWSum}";
                    array_push($subweightingserrors,$suberror);
                    $subweightings['status'] = false;
                    $weightings['status'] = false;
                    $have_error = true;
                }
            }
        }

        if (abs($weighting_sum - $evaluation['evaluation_total_weightings']) > 0.0001)
        {
            $questweightings['status'] = false;
            $weightings['status'] = false;
            $have_error = true;
            $strWSum = number_format(floatval(intval(($weighting_sum+0.00005) * 10000.0)) / 100.0,2) . "%";
            $strEval = number_format(floatval(intval($evaluation['evaluation_total_weightings'] * 1000.0)) / 10.0,1) . "%";
            $questweightings['error'] = "Sum of question weightings do not add up to that specified for evaluation {$strWSum} vs {$strEval}";
        }

        //Check assigned questions and that know pne has the same question assigned twice
        $assigned_questions['status'] = true;
        $assigned_questions['error'] = array();
        $aq_errors = array();
        $r1 = $this->allUsers("order by user_name");
        while ($quser = $r1->fetch_array(MYSQLI_ASSOC) )
        {
            $r2 = $this->allQuestionsForEval(1,"order by question_order");
            while ($qquestion = $r2->fetch_array(MYSQLI_ASSOC) )
            {
                $r3 = $this->allTeamsForUserQuestion($quser['iduser'],$qquestion['idquestion']);
                if ($r3->num_rows > 1)
                {
                    $have_error = true;
                    $assigned_questions['status'] = false;
                    $strUserName = stripslashes($quser['user_name']);
                    $strQID = stripslashes($qquestion['question_identifier']);
                    $err = "User {$strUserName} has been assigned question {$strQID} more than once in teams";
                    $bone = false;
                    while ($qteam = $r3->fetch_array(MYSQLI_ASSOC))
                    {
                        $team = $this->getTeam($qteam['team_idteam']);
                        $steTeam = stripslashes($team['team_name']);
                        if ($bone)
                            $err .= ",";
                        $err .= " {$steTeam}";
                        $bone = true;
                    }
                    array_push($assigned_questions['error'],$err);
                }
            }
        }


        //Check respondents
        $respondents['status'] = true;
        $respondents['count'] = $n;
        if ($n == 0)
        {
            $have_error = true;
            $respondents['status'] = false;
            $respondents['error'] = "No repsondents have been defined to evaluate.";
        }

        //Checks for each phase defines
        $r5 = $this->allPhasesForEval($evalid);
        while ($phase = $r5->fetch_array())
        {
            $resphase = array();
            $resphase['name'] = $phase['phase_name'];
            $errors = array();


            $r = $this->allQuestionsForEval($evalid);
            while ($question = $r->fetch_array())
            {
                //How many users assigned to this question
                $num_users_for_q = 0;
                $r2 = $this->allTeamsForQuestion($question['idquestion']);
                while ($team = $r2->fetch_array())
                {
                    $r3 = $this->allUsersForTeam($team['idteam']);
                    //Check that the user has this phase
                    while ($evaluator = $r3->fetch_array())
                    {
                        if ($this->userHasPhase($evaluator['iduser'],$phase['idphase']) )
                        {
                            $num_users_for_q++;
                        }
                    }
                }

                if ($num_users_for_q == 0)
                {
                    //We have an error
                    $errtext = "No evaluators have been assigned to question {$question['question_identifier']}";
                    array_push($errors,$errtext);
                }

                if ($phase['phase_single_score'] && $num_users_for_q > 1)
                {
                    $errtext = "More than one evaluator assigned to this question for phase marked single score: {$question['question_identifier']}";
                    array_push($errors,$errtext);
                }
            }


            if (count($errors) > 0)
            {
                $phase_error = true;
                $have_error = true;
            }
            $resphase['errors'] = $errors;
            $errors = array();
            array_push($phases,$resphase);

        }


        $result['status'] = !$have_error;
        $weightings['questions'] = $questweightings;
        $subweightings['errors'] = $subweightingserrors;
        $weightings['subattributes'] = $subweightings;
        $result['weightings'] = $weightings;
        $result['respondents'] = $respondents;
        $result['assigned_questions'] = $assigned_questions;
        $result['phases'] ['phaseerrors']= $phases;
        if ($phase_error)
            $result['phases'] ['status'] = false;
        else
            $result['phases'] ['status'] = true;
        $cnt_phases = count($result['phases']);
        return $result;

    }

    public function anyPhaseErrors($evalid,$phaseid)
    {
        $phase = $this->getPhase($phaseid);
        $n = $this->numOfRespondents($evalid);
        $result = array();
        $errors = array();
        //Loop here for each question and sub question tosee if we have a score
        $r = $this->allQuestionsForEval($evalid);
        while ($question = $r->fetch_array())
        {
            //How many users assigned to this question
            $num_users_for_q = 0;
            $r2 = $this->allTeamsForQuestion($question['idquestion']);
            while ($team = $r2->fetch_array())
            {
                $r3 = $this->allUsersForTeam($team['idteam']);
                //Check that the user has this phase
                while ($evaluator = $r3->fetch_array())
                {
                    if ($this->userHasPhase($evaluator['iduser'],$phaseid) )
                        $num_users_for_q++;
                }
            }

            if ($num_users_for_q == 0)
            {
                //We have an error
                $errtext = "No evaluators have been assigned to question {$question['question_identifier']}";
                array_push($errors,$errtext);
            }

            if ($phase['phase_single_score'] && $num_users_for_q > 1)
            {
                $errtext = "More than one evaluator assigned to this question for a phase that can only have one. Question: {$question['question_identifier']}";
                array_push($errors,$errtext);
            }

            $r1 = $this->allSubForQuestion($question['idquestion']);
            if ($r1->num_rows == 0)
            {
                //Check that the question has been answered directly
                $v = $this->numAnswersForQuestion($evalid,$phaseid,$question['idquestion']);
                $expected = $num_users_for_q * $n;
                if ($v != $expected)
                {
                    $errtext = "Number of answers to Question {$question['question_identifier']} are {$v} expected {$expected} number of evaluators for question are {$num_users_for_q}";
                    array_push($errors,$errtext);
                }
            }
            else
            {
                //Check each sub
                while ($sub = $r1->fetch_array())
                {
                    $v = $this->numAnswersForSub($evalid,$phaseid,$sub['idsubattribute']);

                    $expected = $num_users_for_q * $n;
                    if ($v != $expected)
                    {
                        $errtext = "Number of answers to Sub-Attribute {$question['question_identifier']}:{$sub['subattribute_number']} are {$v} expected {$expected}";
                        array_push($errors,$errtext);
                    }
                }
            }
        }

        if (count($errors) > 0)
            $result['status'] = false;
        else
            $result['status'] = true;
        $result['errors'] = $errors;
        return $result;
    }

    public function evaluatorBias($evalid,$phaseid,$teamid)
    {
        //Checks
        if (null == $this->getEvaluation($evalid))
            return ["status"=>false,"error"=>"Invalid evaluation"];
        $phase = $this->getPhase($phaseid);
        if (!$phase)
            return ["status"=>false,"error"=>"Invalid phase"];
        $team = $this->getTeam($teamid);
        if (!$team)
            return ["status"=>false,"error"=>"Invalid team"];
        //Check that the phase is multi score
        if ($phase['phase_single_score'])
            return ["status"=>false,"error"=>"Phasee not a multi score"];
        $r = $this->allUsersForTeam($team['idteam']);
        if ($r->num_rows < 3)
            return ["status"=>false,"error"=>"Less than three evaluators for team"];
        if ($phase['phase_status'] != 'complete')
            return ["status"=>false,"error"=>"Phase not complete"];

        $eavlutr = array();
        $r = $this->allUsersForTeam($teamid);
        while ($evaluator = $r->fetch_array(MYSQLI_ASSOC))
        {
            //Check that the evaluator is for this phase
            if ($this->userHasPhase($evaluator['iduser'],$phaseid))
            {
                $eavlutr[$evaluator['iduser']] = array();
                $eavlutr[$evaluator['iduser']] ['name'] = $evaluator['user_name'];
                $eavlutr[$evaluator['iduser']] ['id'] = $evaluator['iduser'];
                $eavlutr[$evaluator['iduser']] ['respondents'] = array();

                $sumeval = 0;
                $counteval = 0;
                $r2 = $this->allRespondentsForEval($evalid);
                while ($respondent = $r2->fetch_array(MYSQLI_ASSOC))
                {
                    $rslt = $this->sumScoresForPhaseUserTeam($evalid,$phaseid,$evaluator['iduser'],$teamid,$respondent['idrespondent']);
                    $resp = array();
                    $resp ['id'] = $respondent['idrespondent'];
                    $resp ['name'] = $respondent['respondent_name_full'];
                    $resp ['sum'] = $rslt['SUM'];
                    $resp ['count'] = $rslt['COUNT'];

                    array_push($eavlutr[$evaluator['iduser']] ['respondents'],$resp);

                    $sumeval += $rslt['SUM'];
                    $counteval += $rslt['COUNT'];
                }
                $eavlutr[$evaluator['iduser']] ['sum'] = $sumeval;
                $eavlutr[$evaluator['iduser']] ['count'] = $counteval;
            }
        }

        //Check that counts are all the same
        $count = 0;
        foreach($eavlutr as $e)
        {
            if ($count == 0)
                $count = $e['count'];
            if ($e['count'] != $count)
                return ["status"=>false,"error"=>"Score counts not the same for all evaluators"];

            //Check cound for each respondent
            $count2 = 0;
            foreach ($e['respondents'] as $resp)
            {
                if ($count2 == 0)
                    $count2 = $resp['count'];
                if ($resp['count'] != $count2)
                    return ["status"=>false,"error"=>"Score counts not the same for all respondents"];
            }
        }

        //Normalise
        $c1 = 0.0;
        $c2 = 0;
        foreach ($eavlutr as $eid => $e)
        {
            $ave = floatval($e['sum']) / floatval($e['count']);
            $eavlutr[$eid] ['ave'] = $ave;
            $c1 += $ave;
            $c2++;
        }
        $mid = $c1 / floatval($c2);
        //Now scale them all
        foreach ($eavlutr as $eid => $e)
        {
            $scale = $mid /$e['ave'] ;
            $eavlutr[$eid] ['scale'] = $scale;
        }


        foreach ($eavlutr as $eid => $e)
        {
            foreach ($e['respondents'] as $rid => $resp)
            {
                $eavlutr[$eid] ['respondents'] [$rid] ['rawsum'] = $eavlutr[$eid] ['respondents'] [$rid] ['sum'];
                $eavlutr[$eid] ['respondents'] [$rid] ['sum'] = floatval($eavlutr[$eid] ['respondents'] [$rid] ['sum'] ) * $e['scale'];
            }
        }

        //Calculate place
        foreach ($eavlutr as $eid => $e)
        {
            $srt1=array();
            $srt2=array();

            //Calcuate for this evaluator
            $cnt = 0;
            foreach ($e['respondents'] as $resp)
            {
                $srt1[$resp['id']] = $eavlutr[$eid] ['respondents'] [$cnt] ['rawsum'];
                $cnt++;
            }

            //Caluclate for all others
            foreach ($eavlutr as $eid2 => $e2)
            {
                if ($eid2 != $eid)
                {
                    $cnt = 0;
                    foreach ($e2['respondents'] as $resp2)
                    {
                        if (!isset($srt2[$resp2['id']]))
                            $srt2[$resp2['id']] = $eavlutr[$eid2] ['respondents'] [$cnt] ['rawsum'];
                        else
                            $srt2[$resp2['id']] = $srt2[$resp2['id']] + $eavlutr[$eid2] ['respondents'] [$cnt] ['rawsum'];
                        $cnt++;
                    }
                }
            }


            //Now we need to sort in order and compare to
            arsort($srt1);
            arsort($srt2);
            $eavlutr[$eid] ['placing'] = array();
            $eavlutr[$eid] ['placing'] ['own']= $srt1;
            $eavlutr[$eid] ['placing'] ['others']= $srt2;

        }

        //Now by respondent work out
        foreach ($eavlutr as $eid => $e)
        {

            $respave = array();
            $respaveme = array();
            foreach ($e['respondents'] as $rid => $resp)
            {
                $respave[$rid] ['sum'] = 0.0;
                $respave[$rid] ['count'] = 0;
                $respaveme[$rid] ['sum'] = 0.0;
                $respaveme[$rid] ['count'] = 0;
            }

            //If its not this get all the others
            foreach($eavlutr as $eid2 => $e2)
            {

                if ($eid2 != $eid)
                {
                    //Get the average for each respondent
                    foreach ($e2['respondents'] as $rid => $resp)
                    {
                        $respave[$rid] ['sum'] += $resp['sum'];
                        $respave[$rid] ['count'] += $resp['count'];
                    }
                }
                //else if em then my averages.
                else
                {
                    //Get the average for each respondent
                    foreach ($e2['respondents'] as $rid => $resp)
                    {
                        $respaveme[$rid] ['sum'] += $resp['sum'];
                        $respaveme[$rid] ['count'] += $resp['count'];
                    }

                }
            }
            //Now I can compare
            $eavlutr[$eid] ['bias'] = array();
            foreach ($e['respondents'] as $rid => $resp)
            {
                $m = ($respaveme[$rid] ['sum']) / floatval($respaveme[$rid] ['count']);
                $t = ($respave[$rid] ['sum']) / floatval($respave[$rid] ['count']);
                $b = ($m/$t)-1;
                $eavlutr[$eid] ['respondents'] [$rid] ['bias'] = $b;
            }

        }

        return ["status"=>true,"data"=>$eavlutr];

    }

    public function completeResults($evalid)
    {
        $ret = array();
        $aphases = array();
        $r1 = $this->allPhasesForEval($evalid,"order by phase_order");
        while ($phase = $r1->fetch_array(MYSQLI_ASSOC))
        {
            $aphase = array();
            $aphase['id'] =  $phase['idphase'];
            $aphase['name'] =  $phase['phase_name'];
            $aphase['order'] =  $phase['phase_order'];

            $responders = array();
            $r2 = $this->allRespondentsForEval($evalid,"order by respondent_name_short");
            while ($respondent = $r2->fetch_array(MYSQLI_ASSOC))
            {
                $responder = array();
                $responder['id'] = $respondent['idrespondent'];
                $responder['short_name'] = $respondent['respondent_name_short'];
                $responder['long_name'] = $respondent['respondent_name_full'];

                $asections = array();
                $r3 = $this->allSectionsForEval($evalid,"order by section_order");
                while ($section = $r3->fetch_array(MYSQLI_ASSOC))
                {
                    $asection = array();
                    $sectiontotal=0.0;
                    $asection['id'] = $section['idsection'];
                    $asection['name'] = $section['section_name'];

                    $aquestions = array();
                    $r4 = $this->allQuestionsForSection($section['idsection'],"order by question_order");
                    while ($question = $r4->fetch_array(MYSQLI_ASSOC))
                    {

                        $aquestion = array();
                        $aquestion['id'] = $question['idquestion'];
                        $aquestion['name'] = $question['question_identifier'];
                        $asubs = array();
                        $r5 = $this->allSubForQuestion($question['idquestion'],"order by subattribute_number");
                        if ($r5->num_rows > 0)
                        {
                            $asub = array();
                            while ($sub = $r5->fetch_array(MYSQLI_ASSOC))
                            {
                                $asub['num'] = $sub['subattribute_number'];
                                $scors = $this->sumScores($evalid,$phase['idphase'],$respondent['idrespondent'],$question['idquestion'],$sub['idsubattribute']);
                                $arawscore = 0.0;
                                if ($scors['COUNT'] > 0)
                                {
                                    $arawscore = $scors['SUM'] / $scors['COUNT'];
                                }
                                //Add weightings
                                $arawscore = $arawscore * $sub['subattribute_weighting'] * $question['question_weighting'];
                                $asub['score'] = $arawscore;
                                $sectiontotal += $arawscore;
                                array_push($asubs,$asub);

                            }
                        }
                        else
                        {
                            //This becomes sub 0
                            $asub = array();
                            $asub['num'] = 0;
                            $scors = $this->sumScores($evalid,$phase['idphase'],$respondent['idrespondent'],$question['idquestion']);
                            $arawscore = 0.0;
                            if ($scors['COUNT'] > 0)
                            {
                                $arawscore = $scors['SUM'] / $scors['COUNT'];
                            }
                            //Add weightings
                            $arawscore = $arawscore * $question['question_weighting'];
                            $asub['score'] = $arawscore;
                            $sectiontotal += $arawscore;
                            array_push($asubs,$asub);
                        }


                        $aquestion['subs'] = $asubs;
                        array_push($aquestions,$aquestion);
                    }
                    $asection['questions'] = $aquestions;
                    $asection['total'] = $sectiontotal;
                    array_push($asections,$asection);
                }
                $responder['sections'] = $asections;
                array_push($responders,$responder);
            }
            $aphase['respondents'] = $responders;
            array_push($aphases,$aphase);
        }
        $ret['phases'] = $aphases;
        return $ret;
    }


    public function deleteAllButFirstUser()
    {
        $r = $this->allEvaluations();
        while ($evaluation = $r->fetch_array())
        {
            $this->deleteEvaluation($evaluation['idevaluation']);
        }

        $this->p_delete("delete from audit",null,null);
        $this->p_delete("delete from message",null,null);

        $user = $this->getFirstUser();
        $this->p_delete("delete from user where iduser > ?","i",$user['iduser']);

        $this->alter("ALTER TABLE user AUTO_INCREMENT = " . (intval($user['iduser']) + 1) );
        $this->alter("ALTER TABLE audit AUTO_INCREMENT = 1");
        $this->alter("ALTER TABLE evaluation AUTO_INCREMENT = 1");
        $this->alter("ALTER TABLE phase AUTO_INCREMENT = 1");
        $this->alter("ALTER TABLE question AUTO_INCREMENT = 1");
        $this->alter("ALTER TABLE respondent AUTO_INCREMENT = 1");
        $this->alter("ALTER TABLE rule AUTO_INCREMENT = 1");
        $this->alter("ALTER TABLE score AUTO_INCREMENT = 1");
        $this->alter("ALTER TABLE section AUTO_INCREMENT = 1");
        $this->alter("ALTER TABLE subattribute AUTO_INCREMENT = 1");
        $this->alter("ALTER TABLE team AUTO_INCREMENT = 1");
        $this->alter("ALTER TABLE message AUTO_INCREMENT = 1");
    }

    public function Backup($user,$dir)
    {
        $ret =  $this->BackupToFile($dir);
        $auditmsg = '';
        if ($ret['status'] == 0)
            $auditmsg = "Backup to file: {$ret['file']} completed successfully";
        else
            $auditmsg = "Backup to file: {$ret['file']} failed";
        $this->CreateAudit('Backup',$user,$auditmsg);
        return $ret;  //$ret['status'] =  0 is good.
    }

    public function loadFromSQL($filename)
    {
        return parent::loadFromSQL($filename);
    }

    //*********************************************************************
    // Helpers
    //*********************************************************************
    public function displayText($v,$options='')
    {
        if (!is_null($v) && strlen($v) > 0)
        {
            $z = htmlspecialchars(htmlspecialchars_decode(str_replace("\x92", "'", $v)),ENT_QUOTES  | ENT_HTML401);
            if (strtoupper($options) == 'UPPER')
                return strtoupper($z);
            else
                return $z;
        }
        else
            return '';
    }

    public function dispPercentage($v)
    {
       if (!is_null($v))
            return htmlspecialchars(sprintf('%4.2f%%',(floatVal($v)*100.0)),ENT_QUOTES  | ENT_HTML401);
       else
            return '';
    }


}
?>