<?php
require_once dirname(__FILE__) . '/classSecure.php';
class ESecure extends Secure
{
    public static function IS_MODULE_SCORE()
    {
        global $devt_environment;
        if (intval($devt_environment->getkey('MODULES')) & intval(MODULE_SCORE))
            return true;
        return false;
    }

    public static function IS_MODULE_ROOM()
    {
        global $devt_environment;
        if (intval($devt_environment->getkey('MODULES')) & intval(MODULE_ROOM))
            return true;
        return false;
    }

    public static function CheckPage($seclevel,$error_page="SecurityError.php")
    {
        global $global;
        $mustsignin = false;
        if (isset($_SESSION['appid']))
        {
            $inst_name = '';
            if (gettype($global) == "array")
                $inst_name = $global['global_app_instance'];

            if (gettype($global) == "object")
                $inst_name = $global->global_app_instance->raw();

            if ($inst_name != $_SESSION['appid'])
            {
                error_log("Security: " . __FILE__ . " [" .__LINE__ . "] Incorrect application instance");
                $mustsignin =  true;
            }
        }
        else
            $mustsignin =  true;

        if ($mustsignin)
        {
            Secure::SigninAndRedirect();
            exit();
        }
        Secure::CheckPage($seclevel,"SecurityError.php");
    }

    public static function CheckUser($user)
    {
        if (!$user)
        {
            error_log("Security: " . __FILE__ . " [" .__LINE__ . "] No user recoed for session userid");
            $_SESSION['security_error'] = 'default';
            header("Location: SecurityError.php");
            exit();
        }

        //Check that the userid in seesion is same
        if ($_SESSION['userid'] != $user['iduser'])
        {
            error_log("Security: " . __FILE__ . " [" .__LINE__ . "] User id mismatch");
            $_SESSION['security_error'] = 'default';
            header("Location: SecurityError.php");
            exit();
        }

        if ($user['user_deleted'] || $user['user_forcereset'])
        {
            error_log("Security: " . __FILE__ . " [" .__LINE__ . "] Deleted or force reste user");
            header("Location: Signout.php");
            exit();
        }

        if ($user['user_security'] != $_SESSION['security'])
        {
            error_log("Security: " . __FILE__ . " [" .__LINE__ . "] Security settings mismatch");
            header("Location: Signout.php");
            exit();
        }
    }
}

$devt_audittypes = [
    'table' => ['type' => 'table','desc' => 'TABLE CHANGE'],
    'Load' => ['type' => 'user','desc' => 'EVALUATION LOAD'],
    'Score' => ['type' => 'eval','desc' => 'SCORE'],
    'Comment' => ['type' => 'eval','desc' => 'COMMENT'],
    'Security' => ['type' => 'user','desc' => 'SECUITY ERROR'],
    'login' => ['type' => 'user','desc' => 'SIGN IN'],
    'forcereset' => ['type' => 'user','desc' => 'FORCE RESET'],
    'invpassword' => ['type' => 'user','desc' => 'INVALID PASSWORD'],
    'newuser' => ['type' => 'user','desc' => 'NEW USER'],
    'deluser' => ['type' => 'user','desc' => 'DELETED USER'],
    'undeluser' => ['type' => 'user','desc' => 'UNDELETED USER'],
    'acctlocked' => ['type' => 'user','desc' => 'ACCOUNT LOCKED'],
    'acctunlocked' => ['type' => 'user','desc' => 'ACCOUNT UNLOCKED'],
    'doclistdelete' => ['type' => 'dataroom', 'desc' => 'DOCUMENT DELETED'],
    'doclistfolder' => ['type' => 'dataroom', 'desc' => 'CREATE FOLDER'],
    'doclistread' => ['type' => 'dataroom', 'desc' => 'DOWNLOAD'],
    'doclistroom' => ['type' => 'dataroom', 'desc' => 'CREATE ROOM'],
    'doclistundelete' => ['type' => 'dataroom', 'desc' => 'DOCUMENT UNDELETED'],
    'doclistupload' => ['type' => 'dataroom', 'desc' => 'FILE UPLOAD'],
    'emailsent' => ['type' => 'msg','desc' => 'EMAIL SENT'],
    'textsent' => ['type' => 'msg','desc' => 'TEXT MESSAGE SENT'],
    'Backup' => ['type' => 'maint','desc' => 'Database backup performed'],
];


?>