<?php
class helpers
{
    private function var_error_log( $object=null )
    {
        ob_start();                    // start buffer capture
        var_dump( $object );           // dump the values
        $contents = ob_get_contents(); // put the buffer into a variable
        ob_end_clean();                // end capture
        error_log( $contents );        // log contents of the result of var_dump( $object )
    }


    public function encryptQueryString($v)
    {
        if (isset($_SESSION['session_key']))
        {
            $flag = "FFFF";
            $data = $flag . (string) $v;
            $encryption_key = base64_decode($_SESSION['session_key']);
            // Generate an initialization vector
            $iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length('aes-256-cbc'));
            // Encrypt the data using AES 256 encryption in CBC mode using our encryption key and initialization vector.
            $encrypted = openssl_encrypt($data, 'aes-256-cbc', $encryption_key, 0, $iv);
            // The $iv is just as important as the key for decrypting, so save it with our encrypted data using a unique separator (::)
            $result = urlencode(base64_encode($encrypted . '::::' . $iv));
            return $result;
        }
        else
            return null;
    }

    private function decryptParamPart($data)
    {
        if (isset($_SESSION['session_key']))
        {
            // Remove the base64 encoding from our key
            $encryption_key = base64_decode($_SESSION['session_key']);
            // To decrypt, split the encrypted data from our IV - our unique separator used was "::"
            list($encrypted_data, $iv) = explode('::::', base64_decode($data), 2);
            return openssl_decrypt($encrypted_data, 'aes-256-cbc', $encryption_key, 0, $iv);
        }
        else
            return null;
    }

    public function decryptQueryString($data)
    {
        if (isset($_SESSION['session_key']))
        {
            $params = array();
            if ($d = $this->decryptParamPart($data))
            {
                if (strlen($d) >= 4)
                {
                    if (substr($d,0,4) == 'FFFF')
                    {
                        if (strlen($d) >= 4)
                        {
                            $param = substr($d,4,strlen($d)-4);
                            parse_str(strtr($param, ":,", "=&"), $params);
                        }
                    }
                }
            }
            return $params;
        }
    }

    public function buildList($config,$r)
    {
        global $DB;
        global $selff;

        $FL = $config['FL'];
        $config = $config['config'];


        //Heading
        $fields = $config['fields'];
        $keys = array_keys($fields);
        echo "<tr>";
        for ($idx = 0; $idx < count($keys); $idx++)
        {
            $item = $config['fields'] [$keys[$idx]];
            if (isset($item['list_display']) && $item['list_display'])
            {
                $hd = $DB->displayText($item['list_heading']);
                echo "<th>{$hd}</th>";
            }
        }
        echo "<th></th></tr>";
        while ($row2 = $r->fetch_array(MYSQLI_ASSOC))
        {
            echo "<tr>";
            $fields = $config['fields'];
            $keys = array_keys($fields);
            for ($idx = 0; $idx < count($keys); $idx++)
            {
                $item = $config['fields'] [$keys[$idx]];
                if (isset($item['list_display']) && $item['list_display'])
                {
                    if (strtoupper($item['type']) == 'PERCENTAGE')
                    {
                        $perc = $DB->dispPercentage($row2[$keys[$idx]]);
                        echo "<td>{$perc}</td>";
                    }
                    if (strtoupper($item['type']) == 'CHECKBOX')
                    {
                        if ($row2[$keys[$idx]])
                            echo "<td>YES</td>";
                        else
                            echo "<td>NO</td>";
                    }
                    if (strtoupper($item['type']) == 'FK')
                    {
                        $val = $DB->p_singlequery("select {$item['fkdisp']} from {$item['fktable']} where {$item['fkkey']} = ?","i",$row2[$keys[$idx]]);
                        $hd = $DB->displayText($val[$item['fkdisp']]);
                        echo "<td>{$hd}</td>";
                    }
                    if (strtoupper($item['type']) == 'NUMBER')
                    {
                        $hd = $DB->displayText($row2[$keys[$idx]]);
                        echo "<td";
                        if (isset($item['list_class']) && strlen($item['list_class']) > 0)
                            echo " class='".$item['list_class']."'";
                        echo ">";
                        if ($idx == 0)
                        {
                            $qs = $this->encryptQueryString("p={$_SESSION['progress']}&s=1&t={$config['database'] ['tablename']}&k={$config['database'] ['id']}&r={$row2[$config['database'] ['id']]}");
                            echo "<a href='". $selff . "?v=" . $qs. "'>";
                        }
                        echo $hd;
                        if ($idx == 0)
                            echo "</a>";
                        echo "</td>";

                    }
                    if (strtoupper($item['type']) == 'TEXT')
                    {
                        $hd = $DB->displayText($row2[$keys[$idx]]);
                        echo "<td";
                        if (isset($item['list_class']) && strlen($item['list_class']) > 0)
                            echo " class='".$item['list_class']."'";
                        echo ">";
                        if ($idx == 0)
                        {
                            $qs = $this->encryptQueryString("p={$_SESSION['progress']}&s=1&t={$config['database'] ['tablename']}&k={$config['database'] ['id']}&r={$row2[$config['database'] ['id']]}");
                            echo "<a href='". $selff . "?v=" . $qs. "'>";
                        }
                        echo $hd;
                        if ($idx == 0)
                            echo "</a>";
                        echo "</td>";
                    }
                }
            }

            $j = $this->encryptQueryString("t=".$config['database'] ['tablename'] . "&k=" . $config['database'] ['id'] ."&i=".$row2[$config['database'] ['id']]);
            echo "<td class='tddel'><a href='Delete.php?j={$j}'><img src='images/Delete.png' title='Delete'/></a></td>";
            echo "</tr>";
        }
    }

    public function handleFormPost($evalid,$config,$FL)
    {
        global $DB;
        global $selff;

        $result = array();
        $result['success'] = false;
        $lastid = 0;

        if ($_SERVER['REQUEST_METHOD'] == 'POST')
        {
            if (isset($_POST['create'])  || isset($_POST['change'])  )
            {
                $user = null;
                if(!$user = $DB->getUser($_SESSION['userid']))
                {
                    header('Location: SecurityError.php');
                    exit();
                }

                $bFieldsValid = true;
                $tablename = $config['database'] ['tablename'];
                $tablekey = $config['database'] ['id'];

                $FL->GetInputFields();
                $bFieldsValid = $FL->CheckRequired();

                if ($bFieldsValid)
                {
                    if (isset($_POST['create']) )
                    {
                        $row = $FL->BuildArrayRowFromForm();
                        if ($tablename == 'rule')
                            $row['rule_code'] = "v >= {$row['rule_min']} && v <= {$row['rule_max']} && (v % {$row['rule_mod']}) == 0";
                        if (isset($config['database'] ['evalid']))
                            $row[$config['database'] ['evalid']] = $evalid;
                        if ($DB->p_create_from_array($tablename,$row) )
                        {
                            $lastid = $DB->insert_id;
                            if ($tablename == 'evaluation')
                                $_SESSION['current_evaluation'] = $lastid;
                            $DB->createAudit('table',$user,'New table record',$tablename,intval($lastid));
                        }
                        if ($tablename == 'user')
                        {
                            if (isset($_POST['phase']) && $lastid > 0)
                            {
                                $phases = $_POST['phase'];
                                for ($i = 0;$i < count($phases);$i++)
                                {
                                    $DB->createPhaseForUser($lastid,$phases[$i]);
                                }
                            }
                        }

                        if (isset($_SESSION['returnto']))
                        {
                            header("Location: {$_SESSION['returnto']}");
                            $_SESSION['subprogress'] = 0;
                            $result['success'] = true;
                            return $result;
                         }
                     }

                     if (isset($_POST['change']) )
                     {
                        $id = 0;
                        if (isset($_POST['newid']))
                        {
                            $a = $FL->decryptParamRaw($_POST['newid']);
                            $id = intval($a['val']);
                        }
                        $lastid = $id;
                        if ($tablename == 'question')
                        {
                            $quest = $DB->getQuestion($lastid);
                            $val = $FL->DBValue('question_weighting');
                            if ($quest && $quest['question_weighting'] != $val)
                                $DB->createAudit('table',$user,"Weighting change from {$quest['question_weighting']} to {$val}",$tablename,$lastid);
                        }
                        if ($tablename == 'subattribute')
                        {
                            $sub = $DB->getQuestion($lastid);
                            $val = $FL->DBValue('subattribute_weighting');
                            if ($sub && $sub['subattribute_weighting'] != $val)
                                $DB->createAudit('table',$user,"Weighting change from {$sub['subattribute_weighting']} to {$val}",$tablename,$lastid);
                        }

                        $row = $FL->BuildArrayRowFromForm();
                        if ($tablename == 'rule')
                            $row['rule_code'] = "v >= {$row['rule_min']} && v <= {$row['rule_max']} && (v % {$row['rule_mod']}) == 0";
                        if( $DB->p_update_from_array($tablename,$row,'where ' .$tablekey. ' = '. intval($id)) )
                            $DB->createAudit('table',$user,'Updated table record',$tablename,intval($id));
                        if ($tablename == 'user')
                        {
                            $DB->deletePhasesForUser($evalid,$lastid);
                            if (isset($_POST['phase']) && $lastid > 0)
                            {
                                $phases = $_POST['phase'];
                                for ($i = 0;$i < count($phases);$i++)
                                {
                                    $DB->createPhaseForUser($lastid,$phases[$i]);
                                }
                            }
                        }

                        if (isset($_SESSION['returnto']))
                        {
                            header("Location: {$_SESSION['returnto']}");
                            $_SESSION['subprogress'] = 0;
                            $result['success'] = true;
                            if ($tablename == 'evaluation')
                                $_SESSION['progress'] = 0;
                            return $result;
                         }
                     }
                }
                else
                {
                    //Return errors
                    return $result;
                }
            }
        }
    }

    public function buildDefaultForm($configuration,$tablename,$progressNumber,$row)
    {
        global $DB;
        global $evaluation;
        global $selff;

        $tableconfig =  $configuration[$tablename] ['config'];
        echo "<div id='{$tablename}form' class='righty'>";
        echo "<h1>{$tableconfig ['formglobals'] ['title']}</h1>";
        echo "<div id='{$tablename}list' class='sub listwin'>";
        if ($_SESSION['progress'] == $progressNumber)
        {
            echo "<table>";
            $r = $DB->{$tableconfig ['database'] ['allrecs']}($evaluation['idevaluation'],"order by {$tableconfig ['database'] ['order']}");
            $this->buildList($configuration[$tablename],$r);
            echo "</table>";
            $prm = "p={$progressNumber}&s=1";
            $pr = $this->encryptQueryString($prm);
            $createname = "CREATE";
            if (isset($tableconfig['formglobals'] ['createbutton']))
                $createname = $tableconfig['formglobals'] ['createbutton'];
            echo "<button class='create' onclick='eval.gosomewhere(\"{$pr}\")'>{$createname}</button>";
        }
        echo "<p class='formError'>";
        if (isset($_SESSION['form_error']))
            echo $_SESSION['form_error'];
        echo "</p>";
        echo "</div>";
        echo "<div id='{$tablename}form1' class='sub formwin'>";
        if ($_SESSION['progress'] == $progressNumber)
        {
            echo "<form method='post' action='{$selff}'>";
            buildForm($configuration[$tablename],$row);
            echo "</form>";
            $pr = $this->encryptQueryString("p={$_SESSION['progress']}&s=0");
            echo "<p class='back' onclick='eval.gosomewhere(\"{$pr}\")'>&lt;&lt;BACK</p>";
        }
        echo "</div></div>";
    }

    public function phaseResults($evid,$phaseid)
    {
        global $DB;

        $question_results = array();
        $n = $DB->numOfRespondents($evid);
        $phase = $DB->getPhase($phaseid);
        $result = $DB->anyPhaseErrors($evid,$phase['idphase']);
        if(!$result['status'])
            return $result;

        $qidx = 0;

        $r2 = $DB->allQuestionsForEvalWithSection($evid,'order by question_order');
        while ($question = $r2->fetch_array(MYSQLI_ASSOC))
        {
            $question_result = array();
            $question_result ['name'] = $question['question_identifier'];
            $question_section ['section'] = $question['question_section'];
            $question_result ['respondent'] = array();

            $r3 = $DB->allSubForQuestion($question['idquestion']);
            if ($r3->num_rows == 0)
            {

                $resp_idx = 0;
                $r4 = $DB->allRespondentsForEval($evid,'order by respondent_name_short');
                while ($resp = $r4->fetch_array(MYSQLI_ASSOC))
                {
                    $respond_result = array();
                    $respond_result ['name'] = $resp['respondent_name_full'];
                    $respond_result ['id'] = $resp['idrespondent'];

                    $score = $DB->sumScores($evid,$phaseid,$resp['idrespondent'],$question['idquestion']);

                    if ($score['COUNT'] > 0)
                    {
                        $w = floatVal($score['SUM']) / floatVal($score['COUNT']);
                        $w = $question['question_weighting'] * $w;
                    }
                    else
                        $w = 0.0;

                    $respond_result['score'] = $w;
                    $question_result ['respondent'] [$resp_idx] = $respond_result;
                    $resp_idx++;
                 }

            }
            else
            {

                $resp_idx = 0;
                $r4 = $DB->allRespondentsForEval($evid,'order by respondent_name_short');
                while ($resp = $r4->fetch_array(MYSQLI_ASSOC))
                {
                    $respond_result = array();
                    $respond_result ['name'] = $resp['respondent_name_full'];
                    $respond_result ['id'] = $resp['idrespondent'];

                    $t = 0.0;
                    $r3 = $DB->allSubForQuestion($question['idquestion']);
                    while ($sub = $r3->fetch_array(MYSQLI_ASSOC))
                    {

                        $score = $DB->sumScores($evid,$phaseid,$resp['idrespondent'],$question['idquestion'],$sub['idsubattribute']);

                        if ($score['COUNT'] > 0)
                        {
                            $w = floatVal($score['SUM']) / floatVal($score['COUNT']);
                            $w = $question['question_weighting'] * $sub['subattribute_weighting'] * $w;
                        }
                        else
                            $w = 0.0;
                        $t += $w;
                    }
                    $respond_result['score'] = $t;
                    $question_result['respondent'] [$resp_idx] = $respond_result;
                    $resp_idx++;
                 }
           }
           $question_results[$qidx] = $question_result;
           $qidx++;
        }

        $result = array();
        $result['status'] = true;
        $result['questions'] = $question_results;
        return $result;

    }

    public function phaseResults2($evid,$phaseid)
    {
        global $DB;

        $question_results = array();
        $n = $DB->numOfRespondents($evid);
        $phase = $DB->getPhaseWithRule($phaseid);
        $result = $DB->anyPhaseErrors($evid,$phase['idphase']);
        if(!$result['status'])
            return $result;

        $qidx = 0;

        $maxraw = $phase['rule_max'];

        $r2 = $DB->allQuestionsForEvalWithSection($evid,'order by question_order');
        while ($question = $r2->fetch_array(MYSQLI_ASSOC))
        {
            $question_result = array();
            $question_result ['name'] = $question['question_identifier'];
            $question_result ['section'] = $question['question_section'];
            $question_result ['respondent'] = array();

            $r3 = $DB->allSubForQuestion($question['idquestion']);
            if ($r3->num_rows == 0)
            {

                $resp_idx = 0;
                $r4 = $DB->allRespondentsForEval($evid,'order by respondent_name_short');
                while ($resp = $r4->fetch_array(MYSQLI_ASSOC))
                {
                    $respond_result = array();
                    $respond_result ['name'] = $resp['respondent_name_full'];
                    $respond_result ['id'] = $resp['idrespondent'];

                    $score = $DB->sumScores($evid,$phaseid,$resp['idrespondent'],$question['idquestion']);

                    if ($score['COUNT'] > 0)
                    {
                        if ($score['COUNT'] > 1)
                            $w = intval(round(floatVal($score['SUM']) / floatVal($score['COUNT'])));
                        else
                            $w = $score['SUM'];
                        $w1 = $question['question_weighting'] * $w;
                    }
                    else
                    {
                        $w = 0;
                        $w1 = 0.0;
                    }

                    $respond_result['score'] = $w1;
                    $respond_result['raw'] = intval($w);
                    $respond_result['maxweighted'] = $maxraw * $question['question_weighting'];
                    $respond_result['maxraw'] = $maxraw;

                    $question_result ['respondent'] [$resp_idx] = $respond_result;
                    $resp_idx++;
                }

            }
            else
            {

                $resp_idx = 0;
                $r4 = $DB->allRespondentsForEval($evid,'order by respondent_name_short');
                while ($resp = $r4->fetch_array(MYSQLI_ASSOC))
                {
                    $respond_result = array();
                    $respond_result ['name'] = $resp['respondent_name_full'];
                    $respond_result ['id'] = $resp['idrespondent'];

                    $t1 = 0.0;
                    $traw=0;

                    $r3 = $DB->allSubForQuestion($question['idquestion']);
                    $numsubs = $r3->num_rows;
                    while ($sub = $r3->fetch_array(MYSQLI_ASSOC))
                    {

                        $score = $DB->sumScores($evid,$phaseid,$resp['idrespondent'],$question['idquestion'],$sub['idsubattribute']);

                        if ($score['COUNT'] > 0)
                        {
                            if ($score['COUNT'] > 1)
                                $w = intval(round(floatVal($score['SUM']) / floatVal($score['COUNT'])));
                            else
                                $w = $score['SUM'];
                            $w1 = $question['question_weighting'] * $sub['subattribute_weighting'] * $w;
                        }
                        else
                        {
                            $w1 = 0.0;
                            $w = 0;
                        }
                        $t1 += $w1;
                        $traw += $w;
                    }
                    if ($numsubs > 0)
                        $traw = intval(round(floatval($traw) / floatval($numsubs) ) );
                    else
                        $traw = 0;

                    $respond_result['score'] = $t1;
                    $respond_result['raw'] = intval($traw);
                    $respond_result['maxweighted'] = $maxraw * $question['question_weighting'];
                    $respond_result['maxraw'] = $maxraw;

                    $question_result['respondent'] [$resp_idx] = $respond_result;
                    $resp_idx++;
                }
            }
            $question_results[$question['idquestion']] = $question_result;
            $qidx++;
        }

        $result = array();
        $result['status'] = true;
        $result['questions'] = $question_results;
        return $result;

    }

}



?>