<?php
//devt.Version = 1.0
require_once './includes/classEnvironment.php';
define('SECURITY_DEFAULT','1');             //0000 0000 0001   Dec 1  = (2^x) -1
define('SECURITY_VIEW','2');                //0000 0000 0011   Dec 3
define('SECURITY_EVALUATE','4');            //0000 0000 0111   Dec 7
define('SECURITY_DATAROOM_VIEW','8');       //0000 0000 1111   Dec 15
define('SECURITY_DATAROOM_LOAD','16');      //0000 0001 1111   Dec 31
define('SECURITY_DATAROOM_DELETE','32');    //0000 0001 1111   Dec 63
define('SECURITY_ADMIN','64');              //0000 0011 1111   Dec 127
define('SECURITY_ADMIN_CONFIGURE','128');   //0000 0111 1111   Dec 255
define('SECURITY_COMMANDER','256');         //0001 1111 1111   Dec 511
define('SECURITY_MAX','4095');              //1111 1111 1111   Dec 4095

//Module defines
define('MODULE_SCORE','1');
define('MODULE_ROOM','2');

$pepper = $devt_environment->getkey("PEPPER");

$devt_audittypes = [
    'table' => ['type' => 'table','desc' => 'TABLE CHANGE'],
    'Score' => ['type' => 'eval','desc' => 'SCORE'],
    'Comment' => ['type' => 'eval','desc' => 'COMMENT'],
    'Security' => ['type' => 'user','desc' => 'SECUITY ERROR'],
    'login' => ['type' => 'user','desc' => 'SIGN IN'],
    'forcereset' => ['type' => 'user','desc' => 'FORCE RESET'],
    'invpassword' => ['type' => 'user','desc' => 'INVALID PASSWORD'],
    'newuser' => ['type' => 'user','desc' => 'NEW USER'],
    'deluser' => ['type' => 'user','desc' => 'DELETED USER'],
    'undeluser' => ['type' => 'user','desc' => 'UNDELETED USER'],
    'acctlocked' => ['type' => 'user','desc' => 'ACCOUNT LOCKED'],
    'acctunlocked' => ['type' => 'user','desc' => 'ACCOUNT UNLOCKED'],
    'doclistdelete' => ['type' => 'dataroom', 'desc' => 'DOCUMENT DELETED'],
    'doclistfolder' => ['type' => 'dataroom', 'desc' => 'CREATE FOLDER'],
    'doclistread' => ['type' => 'dataroom', 'desc' => 'DOWNLOAD'],
    'doclistroom' => ['type' => 'dataroom', 'desc' => 'CREATE ROOM'],
    'doclistundelete' => ['type' => 'dataroom', 'desc' => 'DOCUMENT UNDELETED'],
    'doclistupload' => ['type' => 'dataroom', 'desc' => 'FILE UPLOAD'],
    'emailsent' => ['type' => 'msg','desc' => 'EMAIL SENT'],
    'textsent' => ['type' => 'msg','desc' => 'TEXT MESSAGE SENT'],
    'Backup' => ['type' => 'maint','desc' => 'Database backup performed'],
];


function IS_MODULE_SCORE()
{
    global $devt_environment;
    if (intval($devt_environment->getkey('MODULES')) & intval(MODULE_SCORE))
        return true;
    return false;
}

function IS_MODULE_ROOM()
{
    global $devt_environment;
    if (intval($devt_environment->getkey('MODULES')) & intval(MODULE_ROOM))
        return true;
    return false;
}

function getSessionOrg()
{
  $o = 0;
  if(isset($_SESSION['org'])) $o=$_SESSION['org'];
  return $o;
}

function getSessionUser()
{
  $u = 0;
  if(isset($_SESSION['userid'])) $u=$_SESSION['userid'];
  return $u;
}

function CheckSecurity($seclevel)
{
 $ret = false;
 if (isset($_SESSION['security']))
 {
    if (intval($_SESSION['security']) & intval($seclevel))
    {
      $ret = true;
    }
 }
 return $ret;
}

function usingHTTPS()
{
  if (empty($_SERVER['HTTPS']))
    return false;
  else
    return true;
}

function isHTTPS()
{
  if (empty($_SERVER['HTTPS']))
  {
    header('Location: https://' . $_SERVER["SERVER_NAME"] . htmlspecialchars($_SERVER["PHP_SELF"]));
    return false;
  }
  return true;
}

function isApplication($str)
{
    if (isset($_SESSION['application']) )
    {
        if (strtoupper($str) == strtoupper($_SESSION['application']))
            return true;
    }
    return false;
}

function createRandomPW($length = 6)
{
    $p = '';
    $characters = '0123456789abcdefghjklmnprstuwxyzABCDEFGHJKLMNPQRSTUWXYZ';
    for($i = 0 ; $i < $length; $i++)
    {
        $p .= substr($characters, rand(0,54) , 1);
    }
    return $p;
}

function createRandomInt($length = 9)
{
   $val = '';
   for ($c=0;$c<($length/4);$c++)
       $val .= sprintf("%04d",rand(0,9999));
   $val = intval(substr($val,0,$length));
   return $val;
}

function passwordHash($pw,$salt)
{
    global $pepper;
    return hash('sha256',$pw . hash('sha256', $salt . $pepper));
}

function checkPassword($pw,$hash,$salt)
{
    if (passwordHash($pw,$salt) === $hash)
        return true;
    else
        return false;
}

function createSalt()
{
  return bin2hex(openssl_random_pseudo_bytes(32));
}


function createsecondfactor($length,$salt)
{
   $val = '';
   for ($c=0;$c<($length/4);$c++)
       $val .= sprintf("%04d",rand(0,9999));
   $val = substr($val,0,$length);
   $hash = passwordHash($val,$salt);
   $ret = array();
   $ret['p'] = $val;
   $ret['h'] = $hash;
   return $ret;
}

function createKey($length)
{
   $val = '';
   for ($c=0;$c<($length/4);$c++)
       $val .= sprintf("%04d",rand(0,9999));
   return substr($val,0,$length);
}

function isSignedIn()
{
    if (isset($_SESSION['userid']))
        return true;
    else
        return false;
}

function SigninAndRedirect()
{
    $_SESSION['SinginRedirect'] = basename($_SERVER["REQUEST_URI"]);
    header('Location: Signin.php');
    exit();
}

function createRandomKey($length)
{
   $val = '';
   for ($c=0;$c<($length/4);$c++)
       $val .= sprintf("%04d",rand(0,9999));
   return substr($val,0,$length);
}

function sec_encryptParam($v,$key)
{
    // Remove the base64 encoding from our key
    if ($key)
    {
        $flag = "FFFF";
        $data = $flag . (string) $v;
        $encryption_key = base64_decode($key);

        // Generate an initialization vector
        $iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length('aes-256-cbc'));
        // Encrypt the data using AES 256 encryption in CBC mode using our encryption key and initialization vector.
        $encrypted = openssl_encrypt($data, 'aes-256-cbc', $encryption_key, 0, $iv);
        // The $iv is just as important as the key for decrypting, so save it with our encrypted data using a unique separator (::)
        $result = urlencode(base64_encode($encrypted . '::' . $iv));
        return $result;
    }
    else
        return null;
}

function sec_decryptParamPart($data,$key)
{
    if ($key)
    {

        // Remove the base64 encoding from our key
        $encryption_key = base64_decode($key);
        // To decrypt, split the encrypted data from our IV - our unique separator used was "::"
        list($encrypted_data, $iv) = explode('::', base64_decode($data), 2);
        $de =  openssl_decrypt($encrypted_data, 'aes-256-cbc', $encryption_key, 0, $iv);
        if (substr($de,0,4) == 'FFFF')
        {
            return substr($de,4,strlen($de)-4);
        }
    }
    return null;
}


function encryptFile($filename,$key)
{
    //Returns the encryted data in the file
    $encryption_key = base64_decode($key);

    // Generate an initialization vector
    $iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length('aes-256-cbc'));

    // Encrypt the data using AES 256 encryption in CBC mode using our encryption key and initialization vector.
    $handle = fopen($filename, "r");

    $encrypted = openssl_encrypt(fread($handle, filesize($filename)), 'aes-256-cbc', $encryption_key, 0, $iv);

    // The $iv is just as important as the key for decrypting, so save it with our encrypted data using a unique separator (::::)
    $result = base64_encode($encrypted . '::::' . $iv);

    return $result;
}

function decryptFile($filename,$key)
{
    $encryption_key = base64_decode($key);

    $handle = fopen($filename, "r");

    // To decrypt, split the encrypted data from our IV - our unique separator used was "::"
    list($encrypted_data, $iv) = explode('::::', base64_decode(fread($handle, filesize($filename))), 2);
    $result = openssl_decrypt($encrypted_data, 'aes-256-cbc', $encryption_key, 0, $iv);
    return $result;

}

function encryptAttachment($strfileIn,$strfileOut,$key)
{
    $encryption_key = base64_decode($key);
    $iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length('aes-256-cbc'));
    if ($hread = fopen($strfileIn, "r") )
    {
        if ($hwrite = fopen($strfileOut,"w"))
        {
            fwrite($hwrite,$iv,16);
            $encrypt_data = openssl_encrypt(fread($hread, filesize($strfileIn)), 'aes-256-cbc', $encryption_key, OPENSSL_RAW_DATA, $iv);
            fwrite($hwrite,$encrypt_data,strlen($encrypt_data));
            fclose($hwrite);
            fclose($hread);
            return true;
        }
    }
    return false;
}

function decryptAttachment($strfileIn,$key)
{
    $encryption_key = base64_decode($key);
    if ($hread = fopen($strfileIn, "r") )
    {
        $l = filesize($strfileIn);
        $iv = fread($hread,16);
        $l -= 16;
        //$edata = fread($hread,$l);
        $rdata = openssl_decrypt(fread($hread,$l), 'aes-256-cbc', $encryption_key, OPENSSL_RAW_DATA, $iv);
        if ($rdata)
        {
            return $rdata;
        }
    }
    return false;
}
?>