<?php
//devt.version 1.0
require dirname(__FILE__) . '/includes/classVault.php';

function usage()
{
    echo "createVaultShelf Usage:\n";
    echo "  php createVaultShelf.php -i <installation name> -d <keys directory> -m <modules>\n";
    echo "  For help:\n";
    echo "  php createVaultShelf.php -h\n";
}

//Start
$options = getopt("hd:i:m:");
if (isset($options['h']))
{
    usage();
    exit;
}

//Check mandatory options
if (!isset($options['i']))
{
    echo "Error: No installation name specified\n";
    echo "Run with php createVaultShelf.php -i <installation name>  -d <keys directory> -m <modules>\n";
    exit(1);
}

if (!isset($options['d']))
{
    echo "Error: directory for keys location specified\n";
    echo "Run with php createVaultShelf.php -i <installation name> -d <keys directory> -m <modules>\n";
    exit(1);
}

if (!isset($options['m']))
{
    echo "Error: no modules specified\n";
    echo "Run with php createVaultShelf.php -i <installation name> -d <keys directory> -m <modules>\n";
    exit(1);
}

$modules = $options['m'];
$keysdir = $options['d'];
$keysdir = rtrim($keysdir,"/");
$strfilename = $keysdir. "/encrypted_keys";

echo "Running createVaultShelf\n";
echo " Installation name {$options['i']}\n";
echo " Keys driectory {$options['d']}\n";
echo " Modules {$options['m']}\n";


//Make backup of keys
if ($fhandel = fopen($strfilename,"r") )
{
    $dt = new DateTime();
    $strbackupname = $strfilename . "-backup-" . $dt->format('YmdHis');
    if ($fhande2 = fopen($strbackupname,"w") )
    {
        $oldkeys = fread($fhandel,filesize($strfilename));
        fwrite($fhande2,$oldkeys,strlen($oldkeys));
        fclose($fhandel);
        fclose($fhande2);
    }
    else
    {
        echo "Failed to backup old keys\n";
        exit(1);
    }
}


$vault = new devt\vault\vault(220759,'{"host":"https://loc.nz/api/hsm/v1","apikey":"4756988295320720","s":"98ac5d60f339f3d1725d98bc5ab5782c27e286d752f08bf21d8ea522932cb49e"}');
$shelves = $vault->listShelves();
if ($shelves)
{
    echo "List of vault current shelves\n";
    foreach($shelves as $shelf)
    {
        echo " {$shelf}\n";
    }
}
else
    echo "No shelves in vault\n";

$installtion_name = $options['i'];
$keys = array();
$keys['PEPPER'] = bin2hex(openssl_random_pseudo_bytes(32));
$keys['MODULES'] = $modules;
$keys['DATABASE_NAME'] = $installtion_name;
$keys['DATABASE_HOST'] = "127.0.0.1";
$keys['DATABASE_USER'] = bin2hex(openssl_random_pseudo_bytes(8));
$keys['DATABASE_PW'] = bin2hex(openssl_random_pseudo_bytes(8));
$keys['ATTACHKEY'] = base64_encode(openssl_random_pseudo_bytes(32));
$keys['BACKUPKEY'] = base64_encode(openssl_random_pseudo_bytes(32));
$keys['VERIFY_USER_KEY'] = base64_encode(openssl_random_pseudo_bytes(32));
$keys['DOC_STORE'] = "/docstore/{$installtion_name}/dataroom";
$keys['BACKUPDIR'] = "/docstore/{$installtion_name}/backups";
$keys['SMS_KEY'] = "d451d391856119ebaaae550d2f891d50";

if (!$encryptedkeys = $vault->addShelf($installtion_name,$keys) )
{
    echo "Failed to create new shelf\n";
    exit(1);
}

if ($fhandel = fopen($strfilename,"w") )
{
    fwrite($fhandel,$encryptedkeys,strlen($encryptedkeys));
    fclose($fhandel);
}
else
{
    echo "Error could not create key file {$strfilename}\n";
    exit(1);
}
 exit(0);
?>