<?php session_start(); ?>
<?php
//devt.Version = 1.0
header('Content-Type: application/json');
require './includes/classSecure.php';
require './includes/classEvaluateDB.php';
require './includes/classSiem.php';
require_once "./includes/classRolling.php";
require_once "./includes/classParseText.php";

$SIEM = new devt\siem\siem($devt_environment->getkey("SIEMHOST"));
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());

//Diagnostic
function var_error_log( $object=null )
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( $contents );        // log contents of the result of var_dump( $object )
}


/*
Repsonse format
meta:
    status: OK/ERROR
    request: <request made>
    time:   <timestamp>
    errorcode:  errorcode if error
    errormsg:   error message if error
data:
    <response data>
*/



//Globals
$key = '';
$req = '';
$reqValue1 = '';
$reqValue2 = '';
$reqValue3 = '';

//Functions
function newMetaResponseHdr($status,$req,$errorcode = null,$errormsg = null,$action='')
{
    $dt = new DateTime('now');
    $meta = array();
    $meta['status'] = $status;
    $meta['req'] = $req;
    $meta['time'] = $dt->format('Y-m-d') . "T" . $dt->format('H:i:s') . "Z";
    $meta['errorcode'] = $errorcode;
    $meta['errormsg'] = null;
    $meta['action'] = $action;
    return $meta;
}

function newErrorMetaHdr($req,$errorcode,$errormsg,$action)
{
    return newMetaResponseHdr(false,$req,$errorcode,$errormsg,$action);
}

function newOKMetaHdr($req)
{
    return newMetaResponseHdr(true,$req);
}

function returnError($req,$code,$desc,$action='')
{
   $rslt = array();
   $meta = newErrorMetaHdr($req,$code,$desc,$action);
   $_SESSION['new_error_message'] = $desc;
   $_SESSION['new_security_action'] = $action;
   $data = array();
   $rslt['meta'] = $meta;
   $rslt['data'] = array();
   echo json_encode($rslt);
   exit();
}

function encryptParam($v)
{
    // Remove the base64 encoding from our key
    if (isset($_SESSION['session_key']))
    {
        $flag = "FFFF";
        $data = $flag . (string) $v;
        $encryption_key = base64_decode($_SESSION['session_key']);

        // Generate an initialization vector
        $iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length('aes-256-cbc'));
        // Encrypt the data using AES 256 encryption in CBC mode using our encryption key and initialization vector.
        $encrypted = openssl_encrypt($data, 'aes-256-cbc', $encryption_key, 0, $iv);
        // The $iv is just as important as the key for decrypting, so save it with our encrypted data using a unique separator (::)
        $result = base64_encode($encrypted . '::' . $iv);
        return $result;
    }
    else
        return null;
}

function decryptParamPart($data)
{
    if (isset($_SESSION['session_key']))
    {

        // Remove the base64 encoding from our key
        $encryption_key = base64_decode($_SESSION['session_key']);
        // To decrypt, split the encrypted data from our IV - our unique separator used was "::"
        list($encrypted_data, $iv) = explode('::', base64_decode($data), 2);
        return openssl_decrypt($encrypted_data, 'aes-256-cbc', $encryption_key, 0, $iv);
    }
    else
        return null;
}

function checkCSRF($what)
{
    if (isset($_SESSION['csrf_key']) && $_SESSION['csrf_key'] == $what)
        return true;
    return false;
}

function scoreWithinRule($evalid,$phaseid,$score)
{
    global $DB;
    $sc = intval($score);
    $phase = $DB->getPhaseWithRule($phaseid);
    if ($phase)
    {
        if ($phase['phase_evaluation'] != $evalid || $phase['rule_evaluation'] != $evalid)
            return false;
        if ($sc < $phase['rule_min'] || $sc > $phase['rule_max'])
            return false;
        if ($sc % $phase['rule_mod'] != 0)
            return false;
        return true;
    }
    return false;
}

function CSRFCheck($token)
{
    global $DB;
    global $SIEM;
    if ( !checkCSRF($token) )
    {
        $SIEM->createSecurityEntry("api",SECUITY_INVALID_CSRF,"minor",getenv("VAULT_SHELF"),"Invalid CSRF in API");
        $DB->createSecurityAudit(null,"Security Error CSRF in API call");
        returnError($req,"1008","Security Error CSRF",'apisecurity');
    }

}

function userByKey($key)
{
    global $DB;
    global $SIEM;

    $user = null;
    if (!$user = $DB->getUserByKey($key))
    {
        $SIEM->createSecurityEntry("api",SECURITY_INVALID_API_KEY,"major",getenv("VAULT_SHELF"),"Invalid API Key used {$key}");
        $DB->createSecurityAudit(null,"Invalid key used in API call");
        returnError($req,"1001","Invalid key","apisecurity");
    }
    return $user;
}

function checkSessionUser($user)
{
    global $DB;
    global $SIEM;

    if ($_SESSION['userid'] != $user['iduser'])
    {
        $SIEM->createSecurityEntry("api",SECURITY_API_USER_MISMATCH,"major",getenv("VAULT_SHELF"),"Session and API user mismatch [{$user['iduser']}]");
        $DB->createSecurityAudit(null,"Invalid key used in API call");
        returnError($req,"1001","Invalid key","apisecurity");
    }
}

function checkUpdateSecurity($routineName,$key,$params)
{
    global $DB;
    global $SIEM;

    $user = null;
    $user2 = null;

    //Check csrf
    CSRFCheck($params['formtoken']);
    $user = userByKey($key);
    checkSessionUser($user);

    if (!$user2 = $DB->getUserByRand($params['evaluator']) )
    {
        $SIEM->createSecurityEntry("api",SECURITY_NO_USER_FOR_RANDOMID,"minor",getenv("VAULT_SHELF"),"No user for random id");
        $DB->createSecurityAudit($user,"Random ID do not match");
        returnError($req,"1001","Invalid keys","apisecurity");
    }

    if ($user['iduser'] != $user2['iduser'])
    {
        $SIEM->createSecurityEntry("api",SECURITY_USER_RANDOM_MISMATCH,"major",getenv("VAULT_SHELF"),"Random ID and User mismatch user [{$user['iduser']}]");
        $DB->createSecurityAudit($user,"User mismatch in API call");
        returnError($req,"1002","Eval not User");
    }

    if (! Secure::CheckSecurity(SECURITY_EVALUATE) )
    {
        $SIEM->createSecurityEntry("api",SECURITY_NO_PRIVILEGES,"major",getenv("VAULT_SHELF"),"Api updateScores for user with no evaluator priviledges user [{$user['iduser']}");
        $DB->createSecurityAudit($user,"api [".__LINE__."] API getProgress attempt without necessary privileges");
        returnError($req,"1016","Security Error",'privileges');
    }


    return $user;


}
/*
***********************************************************************
GET FUNCTIONS
***********************************************************************
*/
function getScores($key,$evalid,$phaseid)
{
    global $DB;
    global $req;
    global $SIEM;

    $user = null;
    $ret = array();

    $user = userByKey($key);

    //Do we have a random number for this user
    $rnd = 0;
    if (!$DB->userhasRand($user['iduser']))
    {
        $rnd = Secure::createRandomInt(9);
        while (!$DB->setUserRand($user['iduser'],$rnd))
            $rnd = Secure::createRandomInt(9);
        $user = $DB->getUserByKey($key);
    }

    //Security checks
    checkSessionUser($user);

    if (!Secure::CheckSecurity(SECURITY_EVALUATE))
    {
        $SIEM->createSecurityEntry("api",SECURITY_NO_PRIVILEGES,"major",getenv("VAULT_SHELF"),"Api getScores for user with no evaluator priviledges user [{$user['iduser']}");
        $DB->createSecurityAudit($user,"API [".__LINE__."] Attempt to get scores - User id does not have necessary privilidges.");
        returnError($req,"1016","Security Error",'privileges');
    }

    $data = array();
    $data['evaluator'] = $user['user_rand'];
    $data['evaluationid'] = $evalid;
    $data['phaseid'] = $phaseid;

    $allscores = array();
    $respondnts = array();
    $r1 = $DB->allRespondentsForEval($evalid,'order by respondent_name_short');
    while ($respondent = $r1->fetch_array(MYSQLI_ASSOC))
    {
        $aresp = array();
        $quests = array();

        $r2 = $DB->allTeamsForUserandEval($user['iduser'],$evalid);
        while ($team = $r2->fetch_array(MYSQLI_ASSOC))
        {
            $r3 = $DB->allQuestionsForTeam($team['idteam']);
            while ($question = $r3->fetch_array(MYSQLI_ASSOC))
            {
                $quest = array();
                $score = $DB->o_getScoreDetail($user['iduser'],$evalid,$phaseid,$respondent['idrespondent'],$question['idquestion'],null);
                if ($score)
                {
                    switch ($question['question_type'])
                    {
                        case "range":
                            $quest['score'] = $score->score_score;
                            break;
                        case "boolean":
                            if ($score->score_score !== null)
                            {
                                if ($score->score_score > 0)
                                    $quest['score'] = "YES";
                                else
                                    $quest['score'] = "NO";
                            }
                            else
                                $quest['score'] = null;
                            break;
                    }
                    $quest['comment'] = $score->score_comment->toHTML();
                }
                else
                {
                    $quest['score'] = null;
                    $quest['comment'] = '';
                }
                $subs = array();

                $r4 = $DB->allSubForQuestion($question['idquestion'],'order by subattribute_number');
                while ($subq = $r4->fetch_array(MYSQLI_ASSOC))
                {
                    $sub = array();
                    $score = $DB->o_getScoreDetail($user['iduser'],$evalid,$phaseid,$respondent['idrespondent'],$question['idquestion'],$subq['idsubattribute']);
                    if ($subq['subattribute_rule'] && strlen($subq['subattribute_rule'] ) > 0)
                        $sub['rule'] = $subq['subattribute_rule'];
                    else
                        $sub['rule'] = null;
                    if ($score)
                    {
                        switch ($subq['subattribute_type'])
                        {
                            case "range":
                                $sub['score'] = $score->score_score;
                                break;
                            case "boolean":
                                if ($score->score_score > 0)
                                    $sub['score'] = "YES";
                                else
                                    $sub['score'] = "NO";
                                break;
                        }

                        $sub['comment'] = $score->score_comment->toHTML();
                    }
                    else
                    {
                        $sub['score'] = null;
                        $sub['comment'] = '';
                    }


                    $subs[$subq['idsubattribute']] = $sub;
                }
                $quest['subs'] = $subs;
                $quests[$question['idquestion']] = $quest;
            }
        }

        $aresp['questions'] = $quests;
        $respondnts[$respondent['idrespondent']] = $aresp;
    }
    $allscores ['respondent'] = $respondnts;
    $data['allscores'] = $allscores;

    $ret['meta'] = newOKMetaHdr($req);
    $ret['data'] = $data;
    echo json_encode($ret);
    exit();

}

function getAllProgress($key)
{
    global $DB;
    global $req;
    global $SIEM;
    global $devt_environment;

    if ($key != $devt_environment->getkey("PORTAL_KEY") )
    {
        $SIEM->createSecurityEntry("api",SECURITY_NO_PRIVILEGES,"major",getenv("VAULT_SHELF"),"Api getAllProgress with no portal key");
        $DB->createSecurityAudit($user,"api [".__LINE__."] API getAllProgress attempt without poral key");
        returnError($req,"1016","Security Error",'privileges');
    }

    $rslt = array();

    $r = $DB->allEvaluations("order by idevaluation");
    while ($evaluation = $r->fetch_assoc())
    {
        $ev = array();
        $ev['phases'] = array();
        $ev['name'] = $evaluation['evaluation_name'];

        $r2 = $DB->allPhasesForEval($evaluation['idevaluation'],"order by phase_order");
        while ($phase = $r2->fetch_assoc())
        {
            $ph = array();
            $ph['name'] = $phase['phase_name'];
            $ph['status'] = $phase['phase_status'];
            $ph['progress'] = array();

            $prog = $DB->getProgress($evaluation['idevaluation'],$phase['idphase']);
            $ph['progress'] = $prog;
            $ev['phases'] [$phase['idphase']] = $ph;
        }

        $rslt[$evaluation['idevaluation']] = $ev;
    }

    $ret['meta'] = newOKMetaHdr($req);
    $ret['data'] = $rslt;

    echo json_encode($ret);
    exit();

}

function getProgress($key,$evalid,$phaseid)
{
    global $DB;
    global $req;
    global $SIEM;

    $ret = array();
    $data = array();
    $teams = array();
    $users = array();

    $user = userByKey($key);
    checkSessionUser($user);

    if (! Secure::CheckSecurity(SECURITY_ADMIN) )
    {
        $SIEM->createSecurityEntry("api",SECURITY_NO_PRIVILEGES,"major",getenv("VAULT_SHELF"),"Api getProgress for user with no evaluator priviledges user [{$user['iduser']}");
        $DB->createSecurityAudit($user,"api [".__LINE__."] API getProgress attempt without necessary privileges");
        returnError($req,"1016","Security Error",'privileges');
    }


    $num_respondents = $DB->numOfRespondents($evalid);
    $r = $DB->allTeamsForEval($evalid,'order by team_name');
    while ($team = $r->fetch_array())
    {
        $t = array();
        $t['id'] = $team['idteam'];
        $t['name'] = $team['team_name'];
        $t['phaseid'] = $phaseid;

        $num_evalsforteam = $DB->numUsersForTeamForPhase($team['idteam'],$phaseid);
        $t['evaluators'] = $num_evalsforteam;


        //Find out how many subattributes or questions there are for this team
        $tot = 0;
        $r2 = $DB->allQuestionsForTeam($team['idteam']);
        while ($question = $r2->fetch_array())
        {
            $nSubs = $DB->numOfSubsForQuestion($question['idquestion']);
            if ($nSubs == 0)
               $nSubs = 1;
            $tot += $nSubs;
        }
        $totals = array();

        $totals['totscoresperevaluator'] = $tot * $num_respondents;
        $totals['totscores'] = $tot * $num_respondents * $num_evalsforteam;


        $users2 = array();
        $tot_answered = 0;

        $r1 = $DB->allUsersForTeam($team['idteam']);
        while ($user = $r1->fetch_array())
        {
            //Check that this user is assigned to evalutae this phase
            if ($DB->userHasPhase($user['iduser'],$phaseid) )
            {
                $u = array();
                $u['id'] = $user['iduser'];
                $u['name'] = $user['user_name'];

                //Nowfind out how many score for the question in this team.
                $answered = 0;
                $r3 = $DB->allQuestionsForTeam($team['idteam']);
                while ($qeest = $r3->fetch_array())
                {
                    $answered += $DB->numScoresFor($evalid,$phaseid,$user['iduser'],$qeest['idquestion']);
                }
                $u['scored'] = $answered;
                $tot_answered += $answered;

                array_push($users2,$u);
            }
        }

        $totals['totanswered'] = $tot_answered;

        $t['totals'] = $totals;

        $t['users'] = $users2;


        array_push($teams,$t);
    }


    $r = $DB->allUsersForEval($evalid);
    while ($user = $r->fetch_array())
    {
        if ($DB->userHasPhase($user['iduser'],$phaseid) )
        {
            $u = array();
            $u['id'] = $user['iduser'];
            $u['name'] = $user['user_name'];

            $tot = 0;
            $r1 = $DB->allTeamsForUserForEval($evalid,$user['iduser']);
            while ($team = $r1->fetch_array())
            {
                $r2 = $DB->allQuestionsForTeam($team['idteam']);
                while ($question = $r2->fetch_array())
                {
                    $nSubs = $DB->numOfSubsForQuestion($question['idquestion']);
                    if ($nSubs == 0)
                       $nSubs = 1;
                    $tot += $nSubs;
                }
            }
            $u['totalscores'] = $tot * $num_respondents;

            $u['scored'] = $DB->numScoresForUser($evalid,$phaseid,$user['iduser']);
            array_push($users,$u);
        }
    }

    $data['evaluation'] = $evalid;
    $data['phase'] = $phaseid;
    $data['teams'] = $teams;
    $data['users'] = $users;

    $ret['meta'] = newOKMetaHdr($req);
    $ret['data'] = $data;
    echo json_encode($ret);
    exit();

}

function buildChild($uid,$rec,$pathback=null)
{
    global $DB;
    $docpath = $pathback;


    $e = array();
    if (!is_null($rec))
    {
        if ($DB->userhasdocaccess($uid,$rec['iddoclist']))
        {
            $createUser = $DB->getUser($rec['doclist_user']);
            $e['id'] = $rec['iddoclist'];
            $e['type'] = $rec['doclist_type'];
            $e['title'] = $rec['doclist_title'];
            if (is_null($docpath))
                $docpath = array();
            $path = array();
            $path['id'] = $rec['iddoclist'];
            $path['name'] = $rec['doclist_title'];
            array_push($docpath,$path);
            $e['docpath'] = $docpath;
            $e['version'] = intval($rec['doclist_version']);
            $e['desc'] = $rec['doclist_description'];
            $e['size'] = $rec['doclist_size'];
            $dt = new DateTime($rec['doclist_timestamp']);
            $e['ts'] = $dt->getTimestamp();
            $e['u'] = urlencode(encryptParam($e['id']));
            $e['p'] = $rec['doclist_parent'];
            $e['cr'] = $createUser['user_name'];
        }
        else
            return null;
    }
    $e['children'] = array();

    if (is_null($rec))
        $r = $DB->getChildren($uid,null);
    else
        $r = $DB->getChildren($uid,$rec['iddoclist']);
    while ($d = $r->fetch_array())
    {
        if ($b = buildChild($uid,$d,$docpath))
            array_push($e['children'],$b);
    }
    return $e;
}

function getAllDocs($key)
{
    global $DB;
    global $req;
    global $SIEM;

    $user = userByKey($key);
    checkSessionUser($user);

    if (! Secure::CheckSecurity(SECURITY_DATAROOM_VIEW) )
    {
        $SIEM->createSecurityEntry("api",SECURITY_NO_PRIVILEGES,"major",getenv("VAULT_SHELF"),"Api getAllDocs for user with no evaluator priviledges user [{$user['iduser']}");
        $DB->createSecurityAudit($user,"api [".__LINE__."] API getAllDocs attempt without necessary privileges");
        returnError($req,"1016","Security Error",'privileges');
    }

    $e = buildChild($user['iduser'],null);
    $data = array();
    $data['tree'] = $e;
    $ret = array();

    $ret['meta'] = newOKMetaHdr($req);
    $ret['data'] = $data;
    echo json_encode($ret);
    exit();
}

function checkSignal($key,$type)
{
    global $DB;
    global $req;
    global $SIEM;

    $user = userByKey($key);
    checkSessionUser($user);

    $data = array();
    $ret = array();
    if ($DB->haveFlag($user['iduser'],$type))
        $data['have'] = true;
    else
        $data['have'] = false;
    $ret['meta'] = newOKMetaHdr($req);
    $ret['data'] = $data;
    echo json_encode($ret);
    exit();

}

function deleteSignal($key,$type)
{
    global $DB;
    global $req;
    global $SIEM;

    $user = userByKey($key);
    checkSessionUser($user);

    $data = array();
    $ret = array();
    $data['have'] = false;

    if ($DB->deleteFlag($user['iduser'],$type))
        $data['deleted'] = true;
    $ret['meta'] = newOKMetaHdr($req);
    $ret['data'] = $data;
    echo json_encode($ret);
    exit();
}


function getScript($key,$instance,$name)
{
    global $DB;
    global $req;
    global $devt_environment;
    global $SIEM;

    $user = userByKey($key);
    checkSessionUser($user);
    if ($devt_environment->getkey("DATABASE_NAME") != $instance)
    {
        $SIEM->createSecurityEntry("api",SECURITY_WRONG_INSTANCE,"major",getenv("VAULT_SHELF"),"Attempt to load a script from wrong instance user [{$user['iduser']}]");
        $DB->createSecurityAudit($user,"api [".__LINE__."] API attempt to load JS from wrong instance");
        returnError($req,"1011","Security Error - Script load breach","breach");
    }

    $filename = "/var/nvaluate/{$instance}/scripts/{$name}.js";
    if (file_exists($filename))
    {
        header('Content-Type: application/javascript');
        echo file_get_contents($filename);
        exit();
    }
    else
        returnError($req,"3001","Script file missing","default");
}

/*
***********************************************************************
PUT AND POST FUNCTIONS
***********************************************************************
*/

function setSessionVariable($key,$params)
{
    global $req;

    $ret = array();

    $name = $params['name'];
    $value = $params['value'];

    $data = array();

    //We must check that it is a valid list for security reasons
    if ($name == 'current_evaluation' || $name == 'nextStep' || $name == 'ReportProgess')
    {
        $_SESSION[$name] = $value;
        $data['name'] = $name;
        $data['value'] = $value;
    }
    else
        returnError($req,1003,'Invalid session variable','dataerror');

    $ret['meta'] = newOKMetaHdr($req);
    $ret['data'] = $data;
    echo json_encode($ret);
    exit();
}

function updateScores($key,$evalid,$phaseid,$params)
{
    global $DB;
    global $req;

    $ret = array();

    $user = checkUpdateSecurity("updateScores",$key,$params);

    $respondents = $params['allscores'] ['respondent'];
    $resp_keys = array_keys($respondents);
    foreach ($resp_keys as $resp)
    {
        $questions = $respondents[$resp] ['questions'];
        $quest_keys = array_keys($questions);
        foreach ($quest_keys as $quest)
        {
            $subs = $questions[$quest] ['subs'];
            $sub_keys = array_keys($subs);
            foreach ($sub_keys as $sub)
            {
                if ($subs[$sub] ['score'])
                {
                    $DB->createOrUpdateScore($user['iduser'],$evalid,$phaseid,$resp,$quest,$sub,$subs[$sub]['score']);
                    $DB->createScoreAudit($user,$evalid,$resp,$quest,$sub,$subs[$sub]['score']);
                }
                else
                {
                    $DB->deleteIfExists($user['iduser'],$evalid,$phaseid,$resp,$quest,$sub);
                }
            }
        }

    }

    $ret['meta'] = newOKMetaHdr($req);
    $ret['data'] = array();
    echo json_encode($ret);
    exit();
}

function updateSingleScore($key,$evalid,$phaseid,$params)
{
    global $DB;
    global $req;
    global $SIEM;

    $ret = array();

    //Check rolling
    if (Rolling::checkRate($DB,"score"))
    {
        $roll = $DB->getRollingByName("score");

        $strTraget = sprintf("%3.0f",($roll['rolling_target'] * 60)) . " per minute";
        $SIEM->createSecurityEntry("rolling",SECURITY_ROLLING_SCORES,"minor",getenv("VAULT_SHELF"),"Scores being entered too quickly, rate above {$strTraget}");
        $DB->createSecurityAudit(null,"Security Error Scores being entered too quickly");
        returnError($req,"1008","Scores being entered too quickly ",'rolling');
    }

    $user = checkUpdateSecurity("updateSingleScore",$key,$params);

    if (intval($params['sub']) == 0)
        $params['sub'] = null;

    //Every 15 api calls we regenerate the session id
    if ($user['user_api_call_counter'] % 15 == 0)
        session_regenerate_id(false);
    $DB->updateUserApiCallCount($user['iduser'],$user['user_api_call_counter'] + 1);

    //Check that the phase number supplied in the api call is the current phase for this user
    if ($user['user_current_phase'] != $phaseid)
    {
        $SIEM->createSecurityEntry("api",SECURITY_INVALID_PHASE,"minor",getenv("VAULT_SHELF"),"updateSingleScore Invalid phase for score user [{$user['iduser']}]");
        $DB->createSecurityAudit($user,"Attempt to score on phase that was not set for this user");
        returnError($req,"1009","Attempt to score on phase not set for evaluator","security");
    }


    if (!$DB->isPhaseEnabled($phaseid) )
    {
        $SIEM->createSecurityEntry("api",SECURITY_INVALID_PHASE,"minor",getenv("VAULT_SHELF"),"updateSingleScore Phase not enabled [{$user['iduser']}]");
        $DB->createSecurityAudit($user,"Attempt to score on phase not yet enabled");
        returnError($req,"1009","Attempt to score on phase not yet enabled","dataerror");
    }

    $user_on_team = false;
    $r = $DB->allTeamsForQuestion($params['question']);
    while ($tm = $r->fetch_array(MYSQLI_ASSOC))
    {
        if ($DB->hasTeamUser($tm['idteam'],$user['iduser']) )
            $user_on_team = true;
    }

    if (!$user_on_team)
    {
        $SIEM->createSecurityEntry("api",SECURITY_INVALID_QUESTION,"minor",getenv("VAULT_SHELF"),"updateSingleScore Attempt to score on question not allocated [{$user['iduser']}]");
        $DB->createSecurityAudit($user,"Attempt to score on question in which user is not on a team for the question");
        returnError($req,"1010","Attempt to score on question in which user is not on a team for the question","dataerror");
    }

    //Is this team enabled
    $tm = $DB->getTeamForUserQuestion($user['iduser'],$params['question']);
    if (!$tm['team_enabled'])
    {
        $SIEM->createSecurityEntry("api",SECURITY_TEAM_NOT_ENABLED,"minor",getenv("VAULT_SHELF"),"updateSingleScore Attempt to score when team not enabled [{$user['iduser']}]");
        $DB->createSecurityAudit($user,"Attempt to score when team not enabled");
        returnError($req,"1010","The team or phase associated with the user and questions is not enabled to score","dataerror");
    }

    $score = $params['score'];
    //Check the type of score for the question

    if ($score !== null)
    {
        $type = 'range';
        if ($params['sub'])
            $type = $DB->getSubAttributeType($params['sub']);
        else
            $type = $DB->getQuestionType($params['question']);

        if ($type == 'boolean')
        {
            //We need to modify the score to the max for rule.
            $rule = $DB->getPhaseWithRule($phaseid);
            if (strtoupper(trim($params['score'])) == "YES")
                $score = intval($rule['rule_max']);
            else
                $score = 0;
        }
    }

    //Need to check score against rules
    if (! scoreWithinRule($evalid,$phaseid,$params['score']) )
        returnError($req,"1010","Score not within rule set","dataerror");

    $DB->createOrUpdateScore($user['iduser'],$evalid,$phaseid,$params['respondent'],$params['question'],$params['sub'],$score);
    $DB->createScoreAudit($user,$evalid,$phaseid,$params['respondent'],$params['question'],$params['sub'],$score);

    $ret['meta'] = newOKMetaHdr($req);
    $data = array();
    $data = $params;
    $ret['data'] = $data;
    echo json_encode($ret);
    exit();
}

function updateSingleComment($key,$evalid,$phaseid,$params)
{
    global $DB;
    global $req;
    global $SIEM;

    $ret = array();

    //Check rolling
    if (Rolling::checkRate($DB,"comment"))
    {
        $roll = $DB->getRollingByName("comment");
        $strTraget = sprintf("%f3.0",($roll['rolling_target'] * 60)) . " per minute";
        $SIEM->createSecurityEntry("rolling",SECURITY_ROLLING_SCORES,"minor",getenv("VAULT_SHELF"),"updateSingleComment comments being entered too quickly, rate above {$strTraget}");
        $DB->createSecurityAudit(null,"Security Error Score comments being entered too quickly");
        returnError($req,"1008","Score comments being entered too quickly ",'rolling');
    }

    $user = checkUpdateSecurity("updateSingleComment",$key,$params);

    if (intval($params['sub']) == 0)
        $params['sub'] = null;

    //Every 15 api calls we regenerate the session id
    if ($user['user_api_call_counter'] % 15 == 0)
        session_regenerate_id(false);

    $DB->updateUserApiCallCount($user['iduser'],$user['user_api_call_counter'] + 1);

    //Check that the phase number supplied in the api call is the current phase for this user
    if ($user['user_current_phase'] != $phaseid)
    {
        $SIEM->createSecurityEntry("api",SECURITY_INVALID_PHASE,"minor",getenv("VAULT_SHELF"),"updateSingleComment Invalid phase for score user [{$user['iduser']}]");
        $DB->createSecurityAudit($user,"Attempt to score on phase that was not set for this user");
        returnError($req,"1009","Attempt to score on phase not set for evaluator","security");
    }

    if (!$DB->isPhaseEnabled($phaseid) )
    {
        $SIEM->createSecurityEntry("api",SECURITY_INVALID_PHASE,"minor",getenv("VAULT_SHELF"),"updateSingleComment Phase not enabled [{$user['iduser']}]");
        $DB->createSecurityAudit($user,"Attempt to score on phase not yet enabled");
        returnError($req,"1009","Attempt to score on phase not yet enabled","dataerror");
    }

    $user_on_team = false;
    $r = $DB->allTeamsForQuestion($params['question']);
    while ($tm = $r->fetch_array(MYSQLI_ASSOC))
    {
        if ($DB->hasTeamUser($tm['idteam'],$user['iduser']) )
            $user_on_team = true;
    }

    if (!$user_on_team)
    {
        $SIEM->createSecurityEntry("api",SECURITY_INVALID_QUESTION,"minor",getenv("VAULT_SHELF"),"updateSingleComment Attempt to score on question not allocated [{$user['iduser']}]");
        $DB->createSecurityAudit($user,"Attempt to score on question in which user is not on a team for the question");
        returnError($req,"1010","Attempt to score on question in which user is not on a team for the question","dataerror");
    }

    //Is this team enabled
    $tm = $DB->getTeamForUserQuestion($user['iduser'],$params['question']);
    if (!$tm['team_enabled'])
    {
        $SIEM->createSecurityEntry("api",SECURITY_TEAM_NOT_ENABLED,"minor",getenv("VAULT_SHELF"),"updateSingleComment Attempt to score when team not enabled [{$user['iduser']}]");
        $DB->createSecurityAudit($user,"Attempt to comment when team not enabled");
        returnError($req,"1010","The team or phase associated with the user and questions is not enabled to score","dataerror");
    }

    //$comment = $params['comment'];
    //$comment = trim($comment);
    //$comment = stripslashes($comment);
    //$comment = strip_tags(htmlspecialchars_decode($comment));
    $comment = ParseText::parseFromHTMLInput($params['comment']);


    $DB->createOrUpdateComment($user['iduser'],$evalid,$phaseid,$params['respondent'],$params['question'],$params['sub'],$comment);
    $DB->createCommentAudit($user,$evalid,$phaseid,$params['respondent'],$params['question'],$params['sub'],$comment);

    $ret['meta'] = newOKMetaHdr($req);
    $data = array();
    $params['comment'] = "";
    $data = $params;
    $ret['data'] = $data;
    echo json_encode($ret);
    exit();
}

function changeFileName($key,$params)
{
    global $DB;
    global $req;
    global $SIEM;

    $user = userByKey($key);
    checkSessionUser($user);

    $id = $params['docid'];
    $newname = $params['newname'];

    //Can this user modify this doc
    if ($DB->userhasdocaccess($user['iduser'],$id) )
    {
        if (!$DB->updateDocName($id,$newname) )
            returnError($req,"1005","Update database error","dataerror");
    }
    else
        returnError($req,"1004","No Permission for file","privileges");

    $ret = array();
    $ret['meta'] = newOKMetaHdr($req);
    $ret['data'] = array();
    echo json_encode($ret);
    exit();
}

function deleteFile($key,$params)
{
    global $DB;
    global $req;
    global $SIEM;

    $data = array();
    $user = userByKey($key);
    checkSessionUser($user);

    if (!Secure::CheckSecurity(SECURITY_DATAROOM_DELETE) )
        returnError($req,"1016","Security Error",'privileges');

    $id = $params['docid'];
    if ($DB->deleteDoclist($id,$user['iduser']) )
    {
        $data['docid'] = $id;
        $DB->createDocDeleteAudit($user['iduser'],$id);
    }
    else
        returnError($req,"1006","Failed to delete file","dataerror");

    $ret = array();
    $ret['meta'] = newOKMetaHdr($req);
    $ret['data'] = $data;
    echo json_encode($ret);
    exit();
}

function undeleteFile($key,$params)
{
    global $DB;
    global $req;
    global $SIEM;

    $data = array();
    $user = userByKey($key);
    checkSessionUser($user);

    if (!Secure::CheckSecurity(SECURITY_DATAROOM_DELETE) )
        returnError($req,"1016","Security Error",'privileges');

    $id = $params['docid'];
    if ($DB->undeleteDoclist($id) )
    {
        $data['docid'] = $id;
        $DB->createDocUnDeleteAudit($user['iduser'],$id);
    }
    else
        returnError($req,"1006","Failed to delete file","dataerror");

    $ret = array();
    $ret['meta'] = newOKMetaHdr($req);
    $ret['data'] = $data;
    echo json_encode($ret);
    exit();
}

function heartbeat($key,$params)
{
    global $DB;
    global $req;
    global $SIEM;

    $glb = $DB->getGlobal();

    $data = array();
    $heartbeatcnt = intval($params['cnt']);
    $heartbeatusrcheck = $params['me'];

    if ($heartbeatcnt >= $glb['global_mins_noactivity'] )
    {
        returnError($req,"2001","Session length end","sessionend");
    }

    $thisid = 0;
    $a = Secure::decrypttoarray($heartbeatusrcheck,$_SESSION['session_key']);
    if ($a && isset($a['id']))
        $thisid = $a['id'];

    $user = userByKey($key);
    checkSessionUser($user);

    if ($user['iduser'] != $thisid)
    {
        $SIEM->createSecurityEntry("api",SECURITY_API_USER_MISMATCH,"major",getenv("VAULT_SHELF"),"Session and API user mismatch [{$user['iduser']}]");
        $DB->createSecurityAudit($user,"User Check and User error in heartbeat");
        returnError($req,"1011","Security Error - Session user not same as API user","breach");
    }

    //Check csrf
    CSRFCheck($params['formtoken']);

    //Every 15 api calls we regenerate the session id
    if ($user['user_api_call_counter'] % 15 == 0)
        session_regenerate_id(false);
    $DB->updateUserHeartBeat($user['iduser'],$heartbeatcnt,$user['user_api_call_counter'] + 1);

    $data['cnt'] = $heartbeatcnt;
    $ret = array();
    $ret['meta'] = newOKMetaHdr($req);
    $ret['data'] = $data;
    echo json_encode($ret);
    exit();
}

function chartData($key,$params)
{
    global $DB;
    global $req;
    global $devt_environment;

    //Check csrf
    CSRFCheck($params['formtoken']);
    $user = userByKey($key);
    checkSessionUser($user);

    if (!Secure::CheckSecurity(SECURITY_ADMIN))
    {
        $DB->createSecurityAudit($user,"API [".__LINE__."] Attempt to set chart data - User id does not have necessary privilidges.");
        returnError($req,"1016","Security Error",'privileges');
    }

    if ($params['chartname'] != 'userbar' )
    {
        $mime = $params['mime'];
        $encoding = $params['encoding'];
        $data = $params['data'];
        if ($encoding == 'base64')
            $data = base64_decode($data);
    }

    $outputdir = $devt_environment->getkey('GRAPHS_DIR');

    error_log("API Received chart for {$params['chartname']}");

    switch ($params['chartname'])
    {
        case 'debriefchart':
            $strname = sprintf("%05d",intval($params['respondentid']));
            $strFileName =  $outputdir . "/imgdebrief" . $strname . ".png";
            break;
        case 'userprogress':
            $strname = sprintf("%05d%05d",intval($params['userid']),intval($params['phaseid']));
            $strFileName =  $outputdir . "/imgeval" . $strname . ".png";
            break;
        case 'phaserslt':
            $strname = sprintf("%05d",intval($params['phaseid']));
            $strFileName =  $outputdir . "/imgphase" . $strname . ".png";
            break;
        case 'respphase':
            $strname = sprintf("%05d",intval($params['respid']));
            $strFileName =  $outputdir . "/imgresp" . $strname . ".png";
            break;
        case 'userbar':
            $bars = $params['bars'];
            foreach($bars as $bar)
            {
                $encoding = $bar['encoding'];
                $data = $bar['data'];
                if ($encoding == 'base64')
                    $data = base64_decode($data);
                $strFileName =  $outputdir . "/userbar" . $bar['title'] . ".png";
                if (!file_put_contents($strFileName,$data) )
                    returnError($req,2021,"Failed to store image");
            }
            break;
        case 'bias':
            $strname = sprintf("%05d%05d",intval($params['teamid']),intval($params['userid']));
            $strFileName =  $outputdir . "/imgbias" . $strname . ".png";
            break;
        default:
            $strFileName =  $outputdir . "/img" . $params['chartid'] . ".png";
            break;

    }

    if ($params['chartname'] != 'userbar')
    {
        if (!file_put_contents($strFileName,$data) )
            returnError($req,2021,"Failed to store image","dataerror");
    }

    $data = array();
    $data['id'] = $params['chartid'];

    $ret = array();
    $ret['meta'] = newOKMetaHdr($req);
    $ret['data'] = $data;
    echo json_encode($ret);
    exit();
}

//Start
if (!isset($_GET['r']))
    returnError(null,1000,"Invalid parameter");

$r = $_GET['r'];
$tok = strtok($r,"/");
if (strlen($tok) == 16)
{
    $key = $tok;
    $req = strtok("/");
}
else
    $req = $tok;
$reqValue1 =strtok("/");
$reqValue2 =strtok("/");
$reqValue3 =strtok("/");

//Do some basic security checks
//We ignore the follwing swicth select, otherwide the default is to check if use is signed in.
switch (strtolower($req))
{
    case 'allprogress':
        break;
    default:
        if (! Secure::isSignedIn() )
            returnError(null,1012,"Security Error Not signed in","apisecurity");
        if ($_SERVER['REQUEST_METHOD'] == 'GET')
        {
            if (! Secure::checkCSRF())
                returnError(null,1013,"Security Error CSRF","apisecurity");
        }
        break;
}

if ($_SERVER['REQUEST_METHOD'] == 'GET')
{
    $result = array();
    switch (strtolower($req))
    {
    case 'getscores':
        getScores($key,$reqValue1,$reqValue2);
        break;
    case 'getprogress':
        getProgress($key,$reqValue1,$reqValue2);
        break;
    case 'allprogress':
        getAllProgress($key);
        break;
    case 'alldocs':
        getAllDocs($key);
        break;
    case 'checksignal':
        checkSignal($key,$reqValue1);
        break;
    case 'deletesignal':
        deleteSignal($key,$reqValue1);
        break;
    case 'devtscript':
        getScript($key,$reqValue1,$reqValue2);
    default:
        returnError($req,1000,"Invalid parameter");
        break;
    }
}

if ($_SERVER['REQUEST_METHOD'] == 'PUT'  || $_SERVER['REQUEST_METHOD'] == 'POST')
{

    $contents = file_get_contents('php://input');
    $params = array();
    $params = json_decode($contents,true);

    switch (strtolower($req))
    {
    case 'setvariable':
        setSessionVariable($key,$params);
        break;
    case 'updsinglescore':
        updateSingleScore($key,$reqValue1,$reqValue2,$params);
        break;
    case 'updsinglecomment':
        updateSingleComment($key,$reqValue1,$reqValue2,$params);
        break;
    case 'changefilename':
        changeFileName($key,$params);
        break;
    case 'deletefile':
        deleteFile($key,$params);
        break;
    case 'undeletefile':
        undeleteFile($key,$params);
        break;
    case 'heartbeat':
        heartbeat($key,$params);
        break;
    case 'submitchart':
        chartData($key,$params);
        break;
    default:
        returnError($req,1000,"Invalid parameter");
        break;
    }
}
?>