<?php session_start(); ?>
<?php
require './includes/classEvalSecure.php';
require './includes/classFormList.php';
require_once "./includes/classRolling.php";
require './includes/classSiem.php';

require './includes/classEvaluateDB.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
$selff = htmlspecialchars($_SERVER["PHP_SELF"]);
$SEC = new Secure();
$SIEM = new devt\siem\siem($devt_environment->getkey("SIEMHOST"));
$instance = getenv("VAULT_SHELF");

$global = $DB->getGlobal();
$signinerror_message = "";

function var_error_log( $object=null ,$text='')
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( "{$text} {$contents}" );        // log contents of the result of var_dump( $object )
}

function securityError($t = '')
{
    global $DB;
    $DB->createSecurityAudit(null,$t);
    header("Location: SecurityError.php");
    exit();
}


//Check that we are over a secure connection
if (!Secure::isHTTPS()) exit();

//This codes blocks those that have tried more than MAX_USERNAME_ATTEMPS with a wrong username
$dt = new DateTime();
if (isset($_COOKIE['_eval22']))
{
    //Check the timestamp
    if ($dt->getTimestamp() > (intval($_COOKIE['_eval22']) + 3600) )
    {
        //The cookie should have expired.
        setcookie("_eval22",0, time() - 3600,"","",true,true);
    }
    else
    {
        header("Location: SecurityError.php");
        exit();
    }
}

if (isset($_SESSION['signin_attempt']) && intval($_SESSION['signin_attempt']) > intval(MAX_USERNAME_ATTEMPS))
{
    //User has attempted at least MAX_USERNAME_ATTEMPS times to sign in with an invalid username.
    //Set a cookie for an hour stopping them from coming back in.
    $dt = new DateTime();
    setcookie("_eval22", $dt->getTimestamp(), time()+ (3600),"","",true,true);
    header("Location: SecurityError.php");

    $securityMsg = "Attempt to signin with invalid username more than " . MAX_USERNAME_ATTEMPS;
    $SIEM->createSecurityEntry("signin",SECURITY_ATTEMPTS_USERNAME,"major",$instance,$securityMsg);

    exit();
}

//Set the csrf_key_signin
if (!isset($_SESSION['csrf_key_signin']))
{
    $_SESSION['csrf_key_signin']=base64_encode(openssl_random_pseudo_bytes(32));
}

//Validate username password
if ($_SERVER["REQUEST_METHOD"] == "POST")
{
    unset($_SESSION['progress']);
    unset($_SESSION['subprogress']);
    unset($_SESSION['userid']);


    if (Rolling::checkRate($DB,"verifyuser"))
    {
        $SIEM->createSecurityEntry("signin",SECURITY_RATE_SIGNIN,"severe",$instance,"Excess signin rate detected from {$_SERVER['REMOTE_ADDR']}");

        header("Location: SecurityError.php");
        $_SESSION['security_error'] = 'rolling';
        session_regenerate_id(true);
        exit();
    }

    $dtNow = new DateTime('now');
    if (isset($_COOKIE['_eval22']))
    {
        //Check the timestamp
        if ($dtNow->getTimestamp() > (intval($_COOKIE['_eval22']) + 3600) )
        {
            //The cookie should have expired.
            setcookie("_eval22",0, time() - 3600,"","",true,true);
        }
        else
        {
            securityError("Cookie set from previous attempts to signin in");
        }
    }

    if (! isset($_SESSION['csrf_key_signin']) || ! isset($_POST['formtoken']) || $_SESSION['csrf_key_signin'] != $_POST['formtoken'])
        securityError("SECURITY VerifyUser.php: Missing session variables signin, csrf and formtoken");
    if (isset($_SESSION['signin_attempt']) && intval($_SESSION['signin_attempt']) > intval(MAX_USERNAME_ATTEMPS))

    $u = "";
    $p = "";
    $bValid = false;
    $dtNow = new DateTime('now');
    $api_key = '';

    $u = FormList::getField('username');
    $p = FormList::getField('hash');

    $_SESSION['tz'] = '';
    $_SESSION['org']=0;
    $_SESSION['team']=0;
    $_SESSION['userid']=0;
    $_SESSION['username']='';
    $_SESSION['security']=0;
    $_SESSION['name']='';
    $_SESSION['application']='';

    $user = null;

    if (!$user = $DB->getUserByUserName($u) )
    {
        $user = $DB->getUserByEmail($u);
    }

    if ($user)
    {
        if ($DB->getUserFailCounter($user['iduser']) >= $global['global_max_signin_attempts'])
        {
            $DB->createUserAccountLockedAudit($user['iduser']);
            $signinerror_message = 'ACCOUNT LOCKED - TOO MANY FAILED ATTEMPTS';
        }
        else
        {
            if ($SEC->checkPassword($p,$user['user_passwordhash'],$user['user_salt']))
            {

                if ($user['user_forcereset'])
                {

                    $DB->createAudit('forcereset',$user,'Login requires forced password reset');
                    //Change this so seesion information contian not URL
                    $_SESSION['userid']=$user['iduser'];
                    $_SESSION['csrf_key']=base64_encode(openssl_random_pseudo_bytes(32));
                    header('Location: ChangePW.php');
                    exit();
                }
                //Check if we need to renew password
                //Check the need to force a change, no need to check if the organistaion has been set to 0 for renew days

                if ($global['global_pw_renew_days'] > 0)
                {
                    $dtRenew = new DateTime($user['user_pw_renew_date']);
                    if ($dtNow->getTimestamp() > $dtRenew->getTimestamp())
                    {
                        $DB->createAudit('forcereset',$user,'Login requires forced change as renew days expired');
                        //Change this so session information contian not URL
                        $_SESSION["pwchangereason1"] = "Your password needs to be changed";
                        $_SESSION["pwchangereason2"] = "You are required to change your password every {$global['global_pw_renew_days']} days";
                        $_SESSION['userid']=$user['iduser'];
                        $_SESSION['csrf_key']=base64_encode(openssl_random_pseudo_bytes(32));
                        header('Location: ChangePW.php');
                        exit();
                    }
                }

                $bValid = true;
                //Create a new api key each signin
                $bDoneKey = false;
                while (!$bDoneKey)
                {
                    $api_key = Secure::createKey(16);
                    if (!$bDoneKey = $DB->updateUserApiKey($user['iduser'],$api_key) )
                    {
                        $api_key = '';
                        if ($DB->errno != 1062)
                            $bDoneKey = true;  // exit loop
                    }
                }
                if (strlen($api_key) == 0)
                {
                    securityError("SECURITY VerifyUser.php: Unable to create api_key");
                }

            }
            else
            {
                $SIEM->createSecurityEntry("signin",SECURITY_INVALID_PASSWORD,"minor",$instance,"Invalid password for userid [{$user['iduser']}]");

                $DB->createAudit('invpassword',$user,'Login failed Invalid Password');
                $DB->updateUserFailCounter($user['iduser']);
                $signinerror_message = 'INVALID USERNAME AND OR PASSWORD';
            }
        }
    }
    else
    {
        if (isset($_SESSION['signin_attempt']))
            $_SESSION['signin_attempt'] = intval($_SESSION['signin_attempt']) + 1;
        else
            $_SESSION['signin_attempt'] = 1;
        if (intval($_SESSION['signin_attempt']) > intval(MAX_USERNAME_ATTEMPS))
            setcookie("_eval22", $dtNow->getTimestamp(), time()+ (3600),"","",true,true);

        $SIEM->createSecurityEntry("signin",SECURITY_INVALID_USERNAME,"minor",$instance,"Invalid username");

        $DB->createAudit('nouser',null,'Login Failed no user '. $u);
        $signinerror_message = 'INVALID USERNAME AND OR PASSWORD';
    }

    if ($bValid)
    {
        //Start a complete new session and delete previous
        session_regenerate_id(true);

        if ($user['user_timezone'] != null)
            $_SESSION['tz'] = $user['user_timezone'];
        else
            $_SESSION['tz'] = 'UTC';

        $_SESSION['application']='Evaluate';

        $_SESSION['username']=$user['user_username'];
        $_SESSION['security']=$user['user_security'];
        $_SESSION['name']= $user['user_name'];
        $_SESSION['api_key']=$api_key;
        $_SESSION['session_key']=base64_encode(openssl_random_pseudo_bytes(32));
        $_SESSION['csrf_key']=base64_encode(openssl_random_pseudo_bytes(32));
        if (isset($_SESSION['nextStep']) ) unset($_SESSION['nextStep']);
        $_SESSION['current_evaluation'] = 0;

        //Check to see if we need second factor
        if ($global['global_two_factor'])
        {
            //Check that the use has a valid phone number
            if ($user['user_mobilephone'] && strlen($user['user_mobilephone']) > 5)
            {
                require_once './includes/classTextMsg.php';
                unset($_SESSION['userid']);
                $_SESSION['securitycheckuser'] = $user['iduser'];
                $_SESSION['appid'] = $global['global_app_instance'];

                //Create random 6 digits
                $v = $SEC->createsecondfactor(6,$user['user_salt']);

                //Updaet database with security check hash
                $DB->updateUserSecondFactorHash($user['iduser'],$v['h']);

                //Send text
                $msg = "nValuate: Security check, please enter the following 6 digit code: {$v['p']}";
                $tm = new devt\TextMsg\TextMessage();
                $tm->send($user['iduser'],$user['user_mobilephone'],$msg);

                //redirect to enter text
                header('Location: SecurityCheck.php');
                exit();
            }
            else
            {
                $signinerror_message = "The system administrator has set 2 factor authentication which requires your mobile phone number; contact you administrator.";
                $bValid = false;
            }
        }

        if ($bValid)
        {
            $DB->updateUserLastSiginIn($user['iduser']);
            $DB->resetUserFailCounter($user['iduser']);
            $_SESSION['userid']=$user['iduser'];
            $_SESSION['appid'] = $global['global_app_instance'];

            $SIEM->createSecurityEntry("signin",SECURITY_SIGNIN,"information",$instance,"Valid signin for user [{$user['iduser']}]");

            $DB->createAudit('login',$user,'Login');
            if (isset($_SESSION['SinginRedirect']))
            {
                header('Location: ' . $_SESSION['SinginRedirect']);
                unset($_SESSION['SinginRedirect']);
            }
            else
            {
                if (Secure::CheckSecurity(SECURITY_ADMIN) )
                    header('Location: /');
                else
                    header('Location: /');
            }
        }
    }
}

?>
<!DOCTYPE HTML>
<html>
<head>
<meta name="viewport" content="width=device-width" />
<meta name="viewport" content="initial-scale=1.0" />
<title>nValuate - Sign In</title>
    <link href="css/Base.css" rel="stylesheet">
<style>
#main {margin: auto;width: 500px;margin-top: 20px;}
#form {margin-top: 60px; margin-left: auto; margin-right: auto; width: 375px;}
input {height: 30px;padding-left: 10px;font-size: 14pt;}
td.td1 {text-align: center; }
td.red {color: red;}
td.td2 {font-size: 14pt;color: #a0a0a0;}
</style>
</head>
<body>
    <div id='container'>
    <div id='heading'>
        <table>
            <tr><td></td><td class='ht'>nVALUATE</td><td></td></tr>
        </table>
    </div>
        <div id='main'>
            <div id='form'>
                <form method = "POST" autocomplete="off" action = "<?php echo $selff;?>">
                    <table>
                    <tr><td class='td2'>USERNAME</td><td><input name="username" placeholder='Username or email' autofocus /></td></tr>
                    <tr><td class='td2'>PASSWORD</td><td><input name="hash" type="password" autocomplete="off"></td></tr>
                    <tr><td><input type="submit" value = "Sign In"></td><td></td></tr>
                    <tr><td></td><td></td><td></td></tr>
                    <tr><td class = "td1 red" colspan='2'><?php echo $signinerror_message;?></td><td></td></tr>
                    </table>
                    <?php echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key_signin']}'>"; ?>
                </form>
            </div>
        </div>
    </div>
</body>
</html>
