<?php session_start(); ?>
<?php
require './includes/classEvalSecure.php';
require './includes/classEvalHelpers.php';
require './includes/classFormList.php';
require './includes/classSiem.php';
require './includes/classEvaluateDB.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
$SIEM = new devt\siem\siem($devt_environment->getkey("SIEMHOST"));

$selff = htmlspecialchars($_SERVER["PHP_SELF"]);
$_SESSION['returnto'] = $selff;
$helpers = new helpers();

$global = $DB->o_getGlobal();
ESecure::CheckPage(SECURITY_ADMIN);
$user = $DB->getUser($_SESSION['userid']);
ESecure::CheckUser($user);

//Do we have users that dpo not have a phone number.
$users_no_phone = $DB->countUsersWithNoPhone();

function var_error_log( $object=null )
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( $contents );        // log contents of the result of var_dump( $object )
}

if ($_SERVER['REQUEST_METHOD'] == 'POST')
{

    if (! Secure::checkCSRF())
    {
        $SIEM->createSecurityEntry("csrf",SECUITY_INVALID_CSRF,"minor",getenv("VAULT_SHELF"),"Invalid CSRF in Settings");
        $DB->createSecurityAudit($user,"Settings.php [".__LINE__."] Failed CSRF check");
        header("Location: SecurityError.php");
        exit();
    }

    $title = '';
    $twofactor = 0;
    $retry = 3;

    $global = array();
    $global['global_title'] = ParseText::parsePostField('sitetitle');

    if (isset($_POST['noshare']) && strtoupper($_POST['noshare']) == "ON")
        $global['global_disallow_shared_comments'] = 1;
    else
        $global['global_disallow_shared_comments'] = 0;
    if (isset($_POST['twofactor']) && strtoupper($_POST['twofactor']) == "ON")
    {
        $global['global_two_factor'] = 1;
    }
    else
        $global['global_two_factor'] = 0;
    $global['global_max_signin_attempts'] = FormList::getField('retry');
    $global['global_mins_noactivity'] = FormList::getField('noactivity');
    $global['global_pw_min_length'] = intval(FormList::getField('min_length'));
    $global['global_pw_num_upper'] = intval(FormList::getField('min_upper'));
    $global['global_pw_num_lower'] = intval(FormList::getField('min_lower'));
    $global['global_pw_num_numbers'] = intval(FormList::getField('min_numbers'));
    $global['global_pw_num_nonalphanum'] = intval(FormList::getField('min_nonalphanum'));
    $global['global_pw_renew_days'] = intval(FormList::getField('renew_days'));
    $global['global_min_time_from_last'] = intval(FormList::getField('min_hours_last'));
    $global['global_pw_previous'] = intval(FormList::getField('repeat_limit'));

    $DB->p_update_from_array('global',$global,'');
    $global = $DB->o_getGlobal();
}

?>
<!DOCTYPE HTML>
<html>
<head>
<meta name="viewport" content="width=device-width">
<meta name="viewport" content="initial-scale=1.0">
<title>nValuate Settings</title>
<link href="css/Base.css" rel="stylesheet">
<style>
#main {}
#main h1 {font-size: 14pt; font-family: 'Robot Slab'; color: #555;}
#form {margin-left: 18px;}
#form p {font-size: 8pt; margin-bottom: 0;}
#form input[type='text'] {font-size: 14pt;}
#form input[type='checkbox'] {width: 16px; height: 16px;}
#form input[type='submit'] {margin-top: 40px;}
#form span {top: -3px; position: relative;}
div.divsec {margin-top: 20px; padding: 8px;border: solid 1px #888; border-radius: 6px;}
#form span.divtitle {font-size: 10pt;position: relative;top: -16px;display: inline-block;background-color: #f8f8f8;z-index: 10;}
.l {text-align: left;}
.c {text-align: center;}
.r {text-align: right;}
</style>
<script>
    function checkNoPhone(n,cnt) {
        if (n.checked && parseInt(cnt) > 0) {
            var answer = window.confirm("There are users who have no phone number set, press OK to confirm setting the two factor authentication option.");
            if (!answer)
                n.checked = false;
        } 
    }
</script>
</head>
<body>
    <div id='container'>
        <div id='heading'>
            <table>
                <tr><td></td><td class='ht'>nVALUATE Settings</td><td></td></tr>
            </table>
        </div>
        <div id='menu'>
            <div class='d1'><a href='Admin.php'>ADMIN</a></div>
            <div class='d1 sel'>SETTINGS</div>
            <?php
            if (ESecure::IS_MODULE_SCORE() && Secure::CheckSecurity(SECURITY_EVALUATE))
                    echo "<div class='d1'><a href='Score'>SCORE</a></div>";
            ?>
            <?php 
                if (ESecure::IS_MODULE_ROOM())
                    echo "<div class='d1'><a href='DataRoom.php'>DATAROOM</a></div>";
            ?>
            <div class='d2'><?php if ($user) echo $user['user_name'];?></div>
            <div style='clear: left;'></div>
        </div>
        <div id='main'>
            <h1>SETTINGS</h1>
                <div id='form'>
                    <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>">
                        <p>SITE TITLE</p>
                        <input type='text' name='sitetitle' value='<?php echo $global->global_title->toHTML();?>' size='80' />
                        <div class="divsec" id="globaloptions">
                            <span class='divtitle'>EVALUATION SETTINGS</span>
                            <p></p>
                            <input type='checkbox' name='noshare' <?php if ($global->global_disallow_shared_comments) echo "checked";?> />
                            <span>DO NOT ALLOW SHARED COMMENTS AND EVALUATOR IDENTITY FOR SCORES</span>
                        </div>
                        <div class="divsec" id='secsettings'>
                            <span class='divtitle'>SECURITY SETTINGS</span>
                            <p></p>
                            <input type='checkbox' name='twofactor' <?php if ($global->global_two_factor) echo "checked";?> onchange="checkNoPhone(this,<?php echo $users_no_phone;?>)" />
                            <span>USE TWO FACTOR AUTHENTICATION VIA TEXT MESSAGE</span>
                            <p>MAX SIGN-IN ATTEMPTS</p>
                            <input type='text' name='retry' value=' <?php echo $global->global_max_signin_attempts;?>' size='2' />
                            <br />
                            <p>NO ACTIVITY MINUTES BEFORE FORCE SIGN-IN</p>
                            <input type='text' name='noactivity' value=' <?php echo $global->global_mins_noactivity;?>' size='2' />
                            <br />
                        </div>
                        <div class="divsec" id="passwrdpolicy">
                            <span class='divtitle'>PASSWORD POLICY</span>
                            <p></p>
                            <p>MINIMUM LENGTH</p>
                            <input type='text' name='min_length' value=' <?php echo $global->global_pw_min_length;?>' size='2' />
                            <p>MINIMUM NUMBER OF UPPER CASE CHARACTERS</p>
                            <input type='text' name='min_upper' value=' <?php echo $global->global_pw_num_upper;?>' size='2' />
                            <p>MINIMUM NUMBER OF LOWER CASE CHARACTERS</p>
                            <input type='text' name='min_lower' value=' <?php echo $global->global_pw_num_lower;?>' size='2' />
                            <p>MINIMUM NUMBER OF NUMERIC CHARACTERS</p>
                            <input type='text' name='min_numbers' value=' <?php echo $global->global_pw_num_numbers;?>' size='2' />
                            <p>MINIMUM NUMBER OF NON ALPHANUMERIC CHARACTERS</p>
                            <input type='text' name='min_nonalphanum' value=' <?php echo $global->global_pw_num_nonalphanum;?>' size='2' />
                            <p>FORCE RENEW PASSWORD EVERY n DAYS</p>
                            <input type='text' name='renew_days' value=' <?php echo $global->global_pw_renew_days;?>' size='2' />
                            <p>MINIMUM NUMBER OF HOURS SINCE LAST CHANGE</p>
                            <input type='text' name='min_hours_last' value=' <?php echo $global->global_min_time_from_last;?>' size='2' />
                            <p>CANNOT REPEAT LAST n PASSWORDS (MAX 25)</p>
                            <input type='text' name='repeat_limit' value=' <?php echo $global->global_pw_previous;?>' size='2' />
                            <br />
                        </div>
                        <?php  echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}'>";?>
                        <input type='submit' name='change' value='CHANGE'/>
                    </form>
                </div>
        </div>
    </div>
</body>
</html>