<?php session_start(); ?>
<?php
require './includes/classEvalSecure.php';
require './includes/classFormList.php';
require './includes/classSiem.php';
$SEC = new ESecure();

//Database
require './includes/classEvaluateDB.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
$SIEM = new devt\siem\siem($devt_environment->getkey("SIEMHOST"));

$error_msg = "";
$resigninmsg = false;
$user = null;
$valid = true;



if ($_SERVER['REQUEST_METHOD'] == 'POST')
{
    if (!Secure::checkCSRF())
    {
        $SIEM->createSecurityEntry("csrf",SECUITY_INVALID_CSRF,"minor",getenv("VAULT_SHELF"),"Invalid CSRF in Security Check (2 Factor)");
        $DB->createSecurityAudit($user,__FILE__ ." [".__LINE__."] Failed CSRF check");
        header("Location: SecurityError.php");
        exit();
    }

    if (isset($_POST['seccode']) && strlen($_POST['seccode']) > 0)
    {
        $v = FormList::getField('seccode');
        $user = $DB->getUser($_SESSION['securitycheckuser']);

        //Chec that the second factor has not expired.
        $dtExpire = new DateTime($user['user_second_factor_expire']);
        $dtNow = new DateTime('now');
        if ($dtNow->getTimestamp() > $dtExpire->getTimestamp())
        {
            $error_msg = "Too much time has elapsed to enter your second factor code";
            $resigninmsg = true;
            $SIEM->createSecurityEntry("signin",SECURITY_2FACTOR_TIMEOUT,"minor",getenv("VAULT_SHELF"),"Timeout entering 2nd Factor");
            $DB->createAudit('login',$user,'2 Factor Fail, too much time has passed entering code');
            $valid = false;
        }

        if (!$SEC->checkPassword($v,$user['user_second_factor_hash'],$user['user_salt']))
        {
            $error_msg = "Security check has failed";
            error_log("2 Factor Fail, user has enetered incorrect code");
            $SIEM->createSecurityEntry("signin",SECURITY_2FACTOR_FAIL,"minor",getenv("VAULT_SHELF"),"Failed 2nd factor, incorrect code");
            $DB->createAudit('login',$user,'2 Factor Fail, user has enetered incorrect code');
            $valid = false;
        }

        if ($valid)
        {
            $DB->updateUserLastSiginIn($user['iduser']);
            $DB->resetUserFailCounter($user['iduser']);
            $_SESSION['userid']=$user['iduser'];
            $SIEM->createSecurityEntry("signin",SECURITY_SIGNIN,"information",getenv("VAULT_SHELF"),"Valid signin for user [{$user['iduser']}]");
            $DB->createAudit('login',$user,'Login');


            if (isset($_SESSION['SinginRedirect']))
            {
                error_log("Signin and redirect is {$_SESSION['SinginRedirect']}");
                header('Location: ' . $_SESSION['SinginRedirect']);
                unset($_SESSION['SinginRedirect']);
            }
            else
            {
                if (Secure::CheckSecurity(SECURITY_ADMIN) )
                    header('Location: /');
                else
                    header('Location: /');
                exit();
            }
        }
    }
}

?>
<!DOCTYPE HTML>
<html>
<head>
<title>nValuate - Security Check</title>
<meta name="viewport" content="width=device-width" />
<meta name="viewport" content="initial-scale=1.0" />
<link href="css/Base.css" rel="stylesheet">
<style>
#main {margin: auto;width: 500px;margin-top: 20px;}
#form {margin-top: 60px; margin-left: auto; margin-right: auto; width: 410px;}
input {height: 30px;padding-left: 10px;font-size: 14pt;}
input[type='submit'] {margin-top: 30px;}
td.td1 {text-align: center; }
td.red {color: red;}
td.td2 {font-size: 14pt;color: #a0a0a0;}
.err {color: red;}
</style>
</head>
<body>
    <div id='container'>
    <div id='heading'>
        <table>
            <tr><td></td><td class='ht'>nVALUATE Security</td><td></td></tr>
        </table>
    </div>
        <div id='main'>
            <div id='form'>
                <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>">
                    <table>
                    <tr><td class='td2'>CODE</td><td><input name="seccode" placeholder='Enter Security Code'autofocus></td></tr>
                    <tr><td><input type="submit" value = "ENTER"></td><td></td></tr>
                    <tr><td></td><td></td><td></td></tr>
                    </table>
                    <?php echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}' />"; ?>
                    <?php if (strlen($error_msg) > 0 ) echo "<p class='err'>{$error_msg}</p>";?>
                    <?php if ($resigninmsg) echo "<p>Please <a href='Signin.php'>Sign in</a> again</p>";?>
                </form>
            </div>
        </div>
    </div>
</body>
</html>
