<?php session_start(); ?>
<?php
require './includes/classEvalSecure.php';
require './includes/classEvaluateDB.php';
require './includes/classFormList.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
$global = $DB->getGlobal();
ESecure::CheckPage(SECURITY_VIEW);
$user = $DB->getUser($_SESSION['userid']);
ESecure::CheckUser($user);
$FL = new FormList(null);

if ($_SERVER["REQUEST_METHOD"] == "GET"  && isset($_GET['v']))
{
    $val = $FL->decryptParamRaw($_GET['v']);
    $fullpathname = $val['v'];
    $filename = basename($fullpathname);

    $dt = new DateTime();
    $nm = md5($dt->getTimestamp());
    $dest = "/tmp/{$nm}.zip";

    $zip = new ZipArchive();
    $zip->open($dest, ZipArchive::CREATE | ZipArchive::OVERWRITE);
    if (!$zip->addFile($fullpathname,$filename) )
        error_log("nvaluate::" . __FILE__ . "[".__LINE__."] Error adding file {$filenname} to zip");
    $zip->close();
    $attachmentname = pathinfo($filename) ['filename'];
    header("Content-Type: application/zip");
    header("Content-Disposition: attachment; filename=\"{$attachmentname}.zip\"");
    echo file_get_contents($dest);

    unlink($dest);

    exit();
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta name="viewport" content="width=device-width" />
    <meta name="viewport" content="initial-scale=1.0" />
    <title>RECENT BACKUPS</title>
    <style>
        body {font-family: Arial, Helvetica, sans-serif; font-size: 9pt; margin: 0; background-color: #f0f0f0;}
        #container {}
        #listbackups {margin: auto; background-color: white; width: 1000px; border: solid 1px #ccc;padding: 20px;}
        h1 {font-size: 14pt;color: #777;}
        th {color: #777;text-align: left;}
        th.th1 {color: #777;text-align: right;padding-right: 20px;}
        td {padding-right: 20px;}
        .r {text-align: right;}
    </style>
</head>
<body>
    <div id="container">
        <div id="listbackups">
            <h1>LIST OF RECENT BACKUPS</h1>
            <div id='listbackupsform1'>
                <table>
                    <tr>
                        <th>NAME</th>
                        <th class="th1">SIZE</th>
                    </tr>
                    <?php
                    $backupdir = $devt_environment->getkey("BACKUPDIR");
                    $files = scandir($backupdir);
                    $cnt = count($files);
                    foreach($files as $file)
                    {
                        if ($file != "." && $file != ".." && substr($file,0,6) == "Backup")
                        {
                            if ($cnt < 72)
                            {
                                $v = urlencode($FL->encryptParam("v={$backupdir}/{$file}"));
                                $sz = filesize("{$backupdir}/{$file}");
                                $sz = floatval($sz) / 1000000.0;
                                $strsz = sprintf("%4.1fM",$sz);
                                echo "<tr><td><a href='RecentBackups.php?v={$v}'>{$file}</a></td><td class='r'>{$strsz}</td></tr>";
                            }
                        }
                        $cnt--;
                    }
                    ?>
                </table>
            </div>
        </div>
    </div>
</body>
</html>
