<?php session_start(); ?>
<?php
//devt.Version = 1.0
require './includes/classEvalSecure.php';
require './includes/classFormList.php';
require './includes/classRolling.php';
require './includes/classSiem.php';

require './includes/classEvaluateDB.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
$FL = new FormList(null);
$SIEM = new devt\siem\siem($devt_environment->getkey("SIEMHOST"));

$selff = htmlspecialchars($_SERVER["PHP_SELF"]);
$_SESSION['returnto'] = $selff;

$global = $DB->getGlobal();
ESecure::CheckPage(SECURITY_DEFAULT);
$user = $DB->getUser($_SESSION['userid']);
ESecure::CheckUser($user);

function var_error_log( $object=null, $text='')
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( "{$text} {$contents}" );        // log contents of the result of var_dump( $object )
}

if (Rolling::checkRate($DB,"verifyuser"))
{
    $SIEM->createSecurityEntry("signin",SECURITY_RATE_SIGNIN,"severe",getenv("VAULT_SHELF"),"Excessive hits on Me for user verification");
    header("Location: SecurityError.php");
    $_SESSION['security_error'] = 'rolling';
    session_regenerate_id(true);
    exit();
}

if ($_SERVER["REQUEST_METHOD"] == "POST")
{
    if (!Secure::checkCSRF())
    {
        $SIEM->createSecurityEntry("csrf",SECUITY_INVALID_CSRF,"minor",getenv("VAULT_SHELF"),"Invalid CSRF in Me");
        $DB->createSecurityAudit($user,"Me.php [".__LINE__."] Failed CSRF check");
        header("Location: SecurityError.php");
        exit();
    }

    $email_not = false;
    $text_not = false;
    if (FormList::getField('emailnot') == 'on')
        $email_not = true;
    if (FormList::getField('smsnot') == 'on')
        $text_not = true;
    $DB->updateUserBasic($user['iduser'],FormList::getField('name'),FormList::getField('mphone'),FormList::getField('email'),$email_not,$text_not);
    $user = $DB->getUser($user['iduser']);
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta name="viewport" content="width=device-width" />
    <meta name="viewport" content="initial-scale=1.0" />
    <title><?php echo $DB->displayText($user['user_name'])?></title>
    <link href="css/Base.css" rel="stylesheet">
    <link href="css/Tasks.css" rel="stylesheet">
    <link href="css/Details.css" rel="stylesheet">
    <style>
    p {margin-bottom: 0;}
    input[type='text'] {font-size: 14pt;}
    input[type='email'] {font-size: 14pt;}
    #other {margin-top: 20px;border: solid 1px #555;padding: 10px;border-radius: 6px;}
    #other p.phd1 {font-size: 10pt;margin: 0;position: relative;top: -18px;font-weight: 400;background-color: #f8f8f8;display: inline-block;font-family: inherit;color: #000;}
    </style>
</head>
<body>
  <div class="container">
    <div id='heading'>
        <table>
            <tr><td></td><td class='ht'>nVALUATE</td><td></td></tr>
        </table>
    </div>
    <div id='menu'>
        <?php
        if (Secure::CheckSecurity(SECURITY_ADMIN))
                echo "<div class='d1'><a href='Admin.php'>ADMIN</a></div>";
        ?>
        <?php 
            if (Esecure::IS_MODULE_SCORE())
                echo "<div class='d1'><a href='Score'>SCORE</a></div>";
        ?>
        <?php 
            if (ESecure::IS_MODULE_ROOM())
                echo "<div class='d1'><a href='DataRoom.php'>DATAROOM</a></div>";
        ?>
        <div style='clear: left;'></div>
    </div>
    <div id='main'>
        <div id='form'>
            <h1><?php echo $DB->displayText($user['user_name']);?></h1>
            <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>">
                <p>Name</p>
                <input type='text' name='name' value='<?php echo $DB->displayText($user['user_name']);?>' size='30'/>
                <p>Username</p>
                <input type='text' name='uname' value='<?php echo $DB->displayText($user['user_username']);?>' size='30' readonly />
                <p>Mobile Phone</p>
                <input type='text' name='mphone' value='<?php echo $DB->displayText($user['user_mobilephone']);?>' size='30'/>
                <p>Email</p>
                <input type='email' name='email' value='<?php echo $DB->displayText($user['user_email']);?>' size='30'/>
                <p></p>
                <?php
                ?>
                <input type='checkbox' name='emailnot' <?php if ($user['user_allow_email_notification']) echo "checked ";?>/><span>ALLOW EMAIL NOTIFICATIONS</span>
                <p></p>
                <input type='checkbox' name='smsnot' <?php if ($user['user_allow_text_notification']) echo "checked ";?>/><span>ALLOW TEXT MESSAGE NOTIFICATIONS</span>
                <p></p>
                <?php echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}' />"; ?>
                <input type='submit' name='change' value='CHANGE' />
            </form>
        </div>
        <div id="other">
            <p class="phd1">OTHER ACTIONS</p>
            <p></p>
            <button onclick="window.location='ChangePW.php'">CHANGE PASSWORD</button>
            <button onclick="window.location='Signout.php'">SIGN OUT</button>
        </div>
    </div>
  </div>
</body>
</html>
