<?php session_start(); ?>
<?php
//devt.Version = 1.0
require './includes/classEvalSecure.php';
require './includes/classEvalHelpers.php';
require './includes/classMail.php';
require './includes/classFormList.php';
require './includes/classSiem.php';

require './includes/classEvaluateDB.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
$SIEM = new devt\siem\siem($devt_environment->getkey("SIEMHOST"));

$selff = htmlspecialchars($_SERVER["PHP_SELF"]);
$_SESSION['returnto'] = $selff;

$helpers = new helpers();
$SEC = new ESecure();
$FL = new FormList(null);

$global = $DB->getGlobal();
ESecure::CheckPage(SECURITY_ADMIN);
$user = $DB->getUser($_SESSION['userid']);
ESecure::CheckUser($user);

$instancename = $devt_environment->getkey("DATABASE_NAME");

function var_error_log( $object=null ,$text='')
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( "{$text} {$contents}" );        // log contents of the result of var_dump( $object )
}

function buildFolderTreeTable($selUser,$id,$level=0)
{
    global $DB;
    global $helpers;
    global $selff;

    $maxlevels = 20;
    $r = $DB->getAllChildren($id);
    while ($doc = $r->fetch_array(MYSQLI_ASSOC))
    {
        if ($doc['doclist_type'] == '0room' || $doc['doclist_type'] == '1folder')
        {
            echo "<tr>";
                for ($i = 0; $i < $level; $i++)
                    echo "<td></td>";
            $colspan = $maxlevels-$level;
            $hasaccess = false;
            $hasaccess = $DB->userhasdocaccess($selUser['iduser'],$doc['iddoclist']);
            if ($hasaccess)
            {
                $pr = $helpers->encryptQueryString("u={$selUser['iduser']}&d={$doc['iddoclist']}&c=0");
                echo "<td class='access' colspan='{$colspan}'><a class='access' href='{$selff}?j={$pr}'>{$DB->displayText($doc['doclist_title'])}</a></td>";
            }
            else
            {
                $pr = $helpers->encryptQueryString("u={$selUser['iduser']}&d={$doc['iddoclist']}&c=1");
                echo "<td class='noaccess' colspan='{$colspan}'><a class='noaccess' href='{$selff}?j={$pr}'>{$DB->displayText($doc['doclist_title'])}</a></td>";
            }
            echo "</tr>";
            buildFolderTreeTable($selUser,$doc['iddoclist'],$level+1);
        }
    }
}

function buildAudit($seluser)
{
    global $DB;
    global $devt_audittypes;

    $r = $DB->allAuditsDoclistForUser($seluser['iduser']);
    if ($r->num_rows > 0)
    {
        echo "<tr><th>TIMESTAMP</th><th>IP ADDRESS</th><th>TYPE</th><th>DOCUMENT</th></tr>";
        while ($audit = $r->fetch_array(MYSQLI_ASSOC))
        {
            $newuser = null;
            $dt = new DateTime($audit['audit_timestamp']);
            $dt->setTimezone(new DateTimeZone($seluser['user_timezone']));
            $strType = $devt_audittypes[$audit['audit_type']] ['desc'];
            if ($audit['audit_type'] == 'newuser' || $audit['audit_type'] == 'acctunlocked')
            {
                $newuser = $DB->getUser($audit['audit_newuserid']);
                if ($newuser)
                    echo "<tr class='tr1'><td>{$dt->format('D jS F Y H:i')}</td><td>{$audit['audit_ipaddress']}</td><td>{$strType}</td><td>{$DB->displayText($newuser['user_name'])} [{$DB->displayText($newuser['user_username'])}]</td></tr>";
                else
                    echo "<tr class='tr1'><td>{$dt->format('D jS F Y H:i')}</td><td>{$audit['audit_ipaddress']}</td><td>{$strType}</td><td></td></tr>";
            }
            else
            {
                echo "<tr class='tr1'><td>{$dt->format('D jS F Y H:i')}</td><td>{$audit['audit_ipaddress']}</td><td>{$strType}</td>";
                if ($audit['audit_doclist'])
                    echo "<td>{$DB->buildDocListFullNameStr($audit['audit_doclist'])}</td>";
                else
                    echo "<td></td>";
                echo "</tr>";
            }
        }
    }
    else
        echo "<tr><td>NO DOCUMENTS HAVE BEEN ACCESSED</td></tr>";
}

Secure::CheckPage(SECURITY_ADMIN);

$user = $DB->getUser($_SESSION['userid']);
if (!$user)
{
    header("Location: Signin.php");
    exit();
}

$site_title = ($DB->o_getGlobal())->global_title->toHTML();

$max_evaluators = intval($devt_environment->getkey("LIMIT1"));
$num_evaluators = $DB->countEvaluators();

$max_administrators = intval($devt_environment->getkey("LIMIT3"));
$num_administrators = $DB->countAdministrators();

$selUser = null;
$strtz = 'UTC';
$createnew = false;
$fields = array();
$fields['user_name'] = '';
$fields['user_username'] = '';
$fields['user_mobilephone'] = '';
$fields['user_email'] = '';
$fields['user_forcereset'] = false;
$fields['user_security'] = 0;
$fields['user_allow_email_notification'] = true;
$fields['user_allow_text_notification'] = true;



if (strlen($user['user_timezone']) > 0)
{
    $strtz = $user['user_timezone'];
}
else
    $strtz = 'UTC';
$tz = new DateTimeZone($strtz);

if (isset($_SESSION['lastquery']) )
{
    $query = $helpers->decryptQueryString($_SESSION['lastquery']);
    if (isset($query['u']))
    {
        $selUser = $DB->getUser(intval($query['u']));
        if (isset($query['d']) && isset($query['c']))
        {
            //Cange the permissions on a folder



            $docid = $query['d'];
            $permits = intval($query['c']);
            $DB->changeDoclistPermission($selUser['iduser'],$docid,$permits);
            $pr = $helpers->encryptQueryString("u={$selUser['iduser']}");
            unset($_SESSION['lastquery']);
            header("Location: {$selff}?j={$pr}}");
            exit();
        }
    }
    unset($_SESSION['lastquery']);
}
else
if (isset($_GET['j']))
{
    $query = $helpers->decryptQueryString($_GET['j']);
    if (isset($query['u']))
    {
        $_SESSION['lastquery'] = $_GET['j'];
        header ("Location: {$selff}");
        exit();
    }
}

if (isset($_GET['new']))
{
    $createnew = true;
}

function getFormTextData($name)
{
    global $DB;
    if (isset($_POST[$name]) && strlen($_POST[$name]) > 0)
    {
        $d = trim($_POST[$name]);
        $d = stripslashes($d);
        $d = strip_tags(htmlspecialchars_decode($d));
        return $DB->real_escape_string(str_replace("\x92", "'", $d));
    }
    return null;
}

if ($_SERVER["REQUEST_METHOD"] == "POST")
{
    if (!Secure::checkCSRF())
    {
        $SIEM->createSecurityEntry("csrf",SECUITY_INVALID_CSRF,"minor",getenv("VAULT_SHELF"),"Invalid CSRF in Manage Users");
        $DB->createSecurityAudit($user,"ManageUsers.php [".__LINE__."] Failed CSRF check");
        header("Location: SecurityError.php");
        exit();
    }

    $selUser = null;
    if (isset($_POST['k']))
    {
        $a = $FL->decryptParamRaw($_POST['k']);
        if ($a && isset($a['val']))
        {
            $selUser = $DB->getUser(intval($a['val']));
        }
    }

    if (isset($_POST['newuser']))
    {
        $rec = array();
        $rec['user_name'] = getFormTextData('rname');
        $rec['user_username'] = getFormTextData('uname');
        $rec['user_mobilephone'] = getFormTextData('mphone');
        $rec['user_email'] = getFormTextData('memail');
        $rec['user_forcereset'] = true;
        $rec['user_allow_email_notification'] = FormList::getCheckBoxField('emailnot');
        $rec['user_allow_text_notification'] = FormList::getCheckBoxField('textnot');
        $security = 3;
        if (FormList::getCheckBoxField('ev'))
            $security = $security | intval(SECURITY_EVALUATE);
        if (FormList::getCheckBoxField('dr'))
            $security = $security | intval(SECURITY_DATAROOM_VIEW);
        if (FormList::getCheckBoxField('ul'))
            $security = $security | intval(SECURITY_DATAROOM_LOAD);
        if (FormList::getCheckBoxField('drdel'))
            $security = $security | intval(SECURITY_DATAROOM_DELETE);
        if (FormList::getCheckBoxField('canrun'))
            $security = $security | intval(SECURITY_ADMIN);
        if (FormList::getCheckBoxField('canconfig'))
            $security = $security | intval(SECURITY_ADMIN_CONFIGURE);


        $rec['user_security'] = $security;
        $rec['user_timezone']  = $user['user_timezone'];
        $pw = Secure::createRandomPW();
        $salt = Secure::createSalt();
        $rec['user_salt'] = $salt;
        $rec['user_passwordhash'] = $SEC->passwordHash($pw,$salt);

        if (!$rec['user_username'] && $rec['user_email'])
            $rec['user_username'] = $rec['user_email'];
        if ($DB->p_create_from_array('user',$rec) )
        {
            $newuserid = $DB->insert_id;
            $SIEM->createSecurityEntry("user",SECURITY_NEW_USER,"information",getenv("VAULT_SHELF"),"New user created [{$newuserid}]");
            $DB->createNewUserAudit($user['iduser'],$newuserid);
            $_SESSION['oneoffpw'] = $pw;
            $_SESSION['oneoffusername'] = $rec['user_username'];
            $_SESSION['oneoffname'] = $rec['user_name'];
            //Do we have an email address
            if (isset($rec['user_email']) && strlen($rec['user_email']) > 0 && $rec['user_allow_email_notification'])
            {
                $mail = new classMail();


                $templatename = "{$devt_environment->getkey('TEMPLATES_DIR')}/Welcome-DR.htm";
                $mail->loadTemplateFromFile($templatename);
                $c = Secure::sec_encryptParam("userid={$newuserid}",$devt_environment->getkey("VERIFY_USER_KEY"));
                $mail->updateTemplateText("---TITLE---",$site_title);
                $mail->updateTemplateText("---NAME---",$user['user_name']);

                if (ESecure::IS_MODULE_SCORE() && ESecure::IS_MODULE_ROOM())
                {
                    $mail->updateTemplateText("---SERVICES---","nValuate-Score and nValuate-Dataroom");
                    $mail->updateTemplateText("---TOWHAT---","scoring and document access");
                }
                else
                {
                    if (ESecure::IS_MODULE_SCORE())
                    {
                        $mail->updateTemplateText("---SERVICES---","nValuate-Score");
                        $mail->updateTemplateText("---TOWHAT---","scoring");
                    }
                    if (ESecure::IS_MODULE_ROOM())
                    {
                        $mail->updateTemplateText("---SERVICES---","nValuate-Dataroom");
                        $mail->updateTemplateText("---TOWHAT---","document access");
                    }
                }

                $url = '';
                if (Secure::usingHTTPS())
                    $url = "https://";
                else
                    $url = "http://";
                $url .= "{$_SERVER['HTTP_HOST']}/Entry.php?v={$c}";
                $mail->updateTemplateText("---URL---",$url);
                $mail->updateTemplateText("---URL2---",$url);
                $to = new classEmailAddress($rec['user_email'],$rec['user_name']);
                $from = new classEmailAddress('notifications@nvaluate.com','nValuate Notifications');
                $subject = "Welcome to the nVALUATE Service";
                $rslt = $mail->SendMailFromTemplate($to,$from,$subject);
                $DB->createEmailSendAudit($user['iduser'],$DB->insert_id,$rec['user_email'],$rslt);
                $_SESSION['oneoffemail'] = $rec['user_email'];
                $_SESSION['oneoffurl'] = $url;
            }

            header("Location: {$selff}");
            exit();
        }
        else
        {
            $_SESSION['failedcreate'] = true;
            header("Location: {$selff}");
            exit();
        }
    }
    else
    {
        if (isset($_POST['resetpw']))
        {
            if ($selUser)
            {
                $pw = Secure::createRandomPW();
                $uid = $selUser['iduser'];
                $selUser['user_salt'] = Secure::createSalt();
                $selUser['user_passwordhash'] = $SEC->passwordHash($pw,$selUser['user_salt']);
                $selUser['user_forcereset'] = true;
                $selUser['user_failed_login_count'] = 0;
                unset($selUser['iduser']);
                if ($DB->p_update_from_array('user',$selUser,"where iduser={$uid}") )
                {
                    $SIEM->createSecurityEntry("user",SECURITY_ADMIN_PASSWORD_RESET,"information",getenv("VAULT_SHELF"),"Admin reset password");
                    $_SESSION['oneoffpwreset'] = true;
                    $_SESSION['oneoffpw'] = $pw;
                    $_SESSION['oneoffusername'] = $selUser['user_username'];
                    $_SESSION['oneoffname'] = $selUser['user_name'];
                    header("Location: {$selff}");
                    exit();
                }
            }
        }
        if (isset($_POST['unlockact']))
        {
            if($selUser)
            {
                $SIEM->createSecurityEntry("user",SECURITY_ADMIN_UNLOCK_USER,"information",getenv("VAULT_SHELF"),"Admin unlock user [{$selUser['iduser']}]");
                $DB->resetUserFailCounter($selUser['iduser']);
                $DB->createUserAccountUnLockedAudit($user['iduser'],$selUser['iduser']);
                header("Location: {$selff}");
                exit();
            }
        }
        if (isset($_POST['deluser']))
        {
            if ($selUser)
            {
                $SIEM->createSecurityEntry("user",SECURITY_ADMIN_DELETE_USER,"information",getenv("VAULT_SHELF"),"Admin deleted user [{$selUser['iduser']}]");
                $DB->deleteUser($selUser['iduser']);
                $DB->createDeleteUserAudit($user['iduser'],$selUser['iduser']);
                header("Location: {$selff}");
                exit();
            }
        }
        if (isset($_POST['undeluser']))
        {
            if ($selUser)
            {
                $SIEM->createSecurityEntry("user",SECURITY_ADMIN_UNDELETED_USER,"information",getenv("VAULT_SHELF"),"Admin undeleted user [{$selUser['iduser']}]");
                $DB->undeleteUser($selUser['iduser']);
                $DB->createUnDeleteUserAudit($user['iduser'],$selUser['iduser']);
                header("Location: {$selff}");
                exit();
            }
        }
        if (isset($_POST['chguser']))
        {

            if ($selUser)
            {
                $selUser['user_name'] = getFormTextData('rname');
                $selUser['user_username'] = getFormTextData('uname');
                $selUser['user_mobilephone'] = getFormTextData('mphone');
                $selUser['user_email'] = getFormTextData('memail');
                $selUser['user_allow_email_notification'] = FormList::getCheckBoxField('emailnot');
                $selUser['user_allow_text_notification'] = FormList::getCheckBoxField('textnot');
                if (FormList::getCheckBoxField('ev'))
                {
                    if ($max_evaluators == 0 || $num_evaluators < $max_evaluators)
                    {
                        $selUser['user_security'] = $selUser['user_security'] | intval(SECURITY_EVALUATE);
                    }
                }
                else
                    $selUser['user_security'] = $selUser['user_security'] & (~intval(SECURITY_EVALUATE));

                if (FormList::getCheckBoxField('dr'))
                    $selUser['user_security'] = $selUser['user_security'] | intval(SECURITY_DATAROOM_VIEW);
                else
                    $selUser['user_security'] = $selUser['user_security'] & (~intval(SECURITY_DATAROOM_VIEW));

                if (FormList::getCheckBoxField('ul'))
                    $selUser['user_security'] = $selUser['user_security'] | intval(SECURITY_DATAROOM_LOAD);
                else
                    $selUser['user_security'] = $selUser['user_security'] & (~intval(SECURITY_DATAROOM_LOAD));

                if (FormList::getCheckBoxField('drdel'))
                    $selUser['user_security'] = $selUser['user_security'] | intval(SECURITY_DATAROOM_DELETE);
                else
                    $selUser['user_security'] = $selUser['user_security'] & (~intval(SECURITY_DATAROOM_DELETE));

                if (FormList::getCheckBoxField('canrun'))
                    $selUser['user_security'] = $selUser['user_security'] | intval(SECURITY_ADMIN);
                else
                    $selUser['user_security'] = $selUser['user_security'] & (~intval(SECURITY_ADMIN));

                if (FormList::getCheckBoxField('canconfig'))
                    $selUser['user_security'] = $selUser['user_security'] | intval(SECURITY_ADMIN_CONFIGURE);
                else
                    $selUser['user_security'] = $selUser['user_security'] & (~intval(SECURITY_ADMIN_CONFIGURE));

                $selUser['user_forcereset'] = FormList::getCheckBoxField('fr');

                $idupduser = intval($selUser['iduser']);
                unset($selUser['iduser']);
                unset($selUser['user_lastlogin']);
                unset($selUser['user_pw_renew_date']);
                unset($selUser['user_current_phase']);
                unset($selUser['user_pw_change_date']);
                unset($selUser['user_pw_change_date']);
                unset($selUser['user_prev_salt']);
                unset($selUser['user_last_heartbeat_time']);
                unset($selUser['user_pw_renew_date']);
                unset($selUser['user_last_heartbeat_ipaddress']);

                $DB->p_update_from_array('user',$selUser,"where iduser = {$idupduser}");
                $selUser = $DB->getUser($idupduser);
                $SIEM->createSecurityEntry("user",SECURITY_ADMIN_UPDATED_USER,"information",getenv("VAULT_SHELF"),"Admin updated user [{$selUser['iduser']}]");

                $pr = $helpers->encryptQueryString("u={$selUser['iduser']}");
                header("Location: {$selff}?j={$pr}");
            }
        }
    }
}

?>
<!DOCTYPE HTML>
<html>
<head>
<meta name="viewport" content="width=device-width">
<meta name="viewport" content="initial-scale=1.0">
<title>nValuate Users</title>
<link href="css/Base.css" rel="stylesheet">
<link href="css/devtmenu.css" rel="stylesheet">
<style>
#main {display: flex;}
#left {width: 300px;padding: 10px;background-color: #eef;border: solid 2px #ddd;}
#left h1 {font-family: 'Roboto Slab';font-size: 12pt; color: #888;border-radius: 5px;}
#left p.p1 {font-family: 'Roboto Slab';font-size: 12pt;padding-left: 8px;color: #633;font-weight: bold;}
#right {width: 100%; background-color: #eee; margin-left: 10px;border: solid 2px #ddd;border-radius: 5px;padding: 10px;}
#right h1 {font-family: 'Roboto Slab';font-size: 12pt; color: #888;border-radius: 5px;}
#right h2 {font-family: 'Roboto Slab';font-size: 11pt; color: #888;border-radius: 5px;margin-left: 10px;}
#right p.pmsg {font-size: 11pt;}
#userdetails {border: solid 1px #bbb;padding: 10px; background-color: #ffe;border-radius: 4px;}
#userdetails input[type='text'] {padding: 2px;padding-left: 8px;}
#userdetails input[type='email'] {padding: 2px;padding-left: 8px;}
#userdetails input[type='submit'] {margin-top: 20px;}
#userdetails input[type='submit']:hover {background-color: lime;}
#userdetails td.tdh1 {height: 12px;}
#userdetails td.tdhd1 {color: #888;font-family: 'Roboto Slab';font-weight: bold;}
#userdetails input[type='submit'] {margin-right: 8px;}
#editactions {border: solid 1px #aaa;padding: 10px; padding-top: 0; margin-top: 18px; width: 300px;}
#editactions input[type='submit'] {display: block; width: 150px;margin-left: 20px;}
#editactions p {font-family: 'Roboto Slab';font-weight: bold;color: #888;}
#scoreperm {border: solid 1px #bbb;padding: 10px; background-color: #ffe;border-radius: 4px;margin-top: 10px;}
#scoreperm td {min-width: 20px;}
#scoreperm a {text-decoration: none;}
#evaltable {margin-left: 15px;}
#permissions {border: solid 1px #bbb;padding: 10px; background-color: #ffe;border-radius: 4px;margin-top: 10px;}
#permissions td {min-width: 20px;}
#permissions a {text-decoration: none;}
#audit {border: solid 1px #bbb;padding: 10px; background-color: #ffe;border-radius: 4px;}
#audit table {border-collapse: collapse; width: 100%;}
#audit th {font-family: 'Roboto Slab';color: #555;font-weight: bold;text-align: left;border-bottom: solid 1px #999;}
#audit tr.tr1 {height: 32px;}
#audit td {padding-right: 10px;border-bottom: solid 1px #aaa;}
.access {color: blue;}
.noaccess {color: red;}
.red {color: red;}
button.butcpy {font-size: 8pt;}
</style>
<script type="text/javascript" src="apievaljsonv1.php?r=/<?php echo $user['user_apikey'];?>/devtscript/<?php echo $instancename;?>/devtcore&formtoken=<?php echo urlencode($_SESSION['csrf_key']);?>"></script>
</head>
<body>
    <div id='container'>
        <div id='heading'>
            <table>
                <tr><td></td><td class='ht'>nVALUATE Users</td><td></td></tr>
            </table>
        </div>
        <div id='menu'>
            <div class='d1'><a href='Admin.php'>ADMIN</a></div>
            <div class='d1 sel'>USERS</div>
            <div class='d1'><a href='Audits.php'>AUDITS</a></div>
            <?php
            if (ESecure::IS_MODULE_SCORE())
                    echo "<div class='d1'><a href='Score'>SCORE</a></div>";
            ?>
            <?php
            if (ESecure::IS_MODULE_ROOM())
                    echo "<div class='d1'><a href='DataRoom.php'>DATAROOM</a></div>";
            ?>
            <div class='d2'><?php if ($user) echo $user['user_name'];?></div>
            <div style='clear: left;'></div>
        </div>
        <div id='main'>
            <div id='left'>
                <button onclick="window.location='<?php echo $selff;?>?new=1'">CREATE NEW</button>
                <h1>ALL ACTIVE USERS</h1>
                <?php
                    $r = $DB->allUsers('order by user_name');
                    while ($druser = $r->fetch_array(MYSQLI_ASSOC))
                    {
                        $pr = $helpers->encryptQueryString("u={$druser['iduser']}");
                        if ($selUser && $selUser['iduser'] == $druser['iduser'])
                        {
                            echo "<p class='p1'>&gt; {$DB->displayText($druser['user_name'])}</p>";
                        }
                        else
                            echo "<p><a href='{$selff}?j={$pr}'>{$DB->displayText($druser['user_name'])}</a></p>";
                    }
                ?>
                <h1>DELETED USERS</h1>
                <?php
                    $r = $DB->allDeletedUsers('order by user_name');
                    while ($druser = $r->fetch_array(MYSQLI_ASSOC))
                    {
                        $pr = $helpers->encryptQueryString("u={$druser['iduser']}");
                        if ($selUser && $selUser['iduser'] == $druser['iduser'])
                        {
                            echo "<p class='p1'>&gt; {$DB->displayText($druser['user_name'])}</p>";
                        }
                        else
                            echo "<p><a href='{$selff}?j={$pr}'>{$DB->displayText($druser['user_name'])}</a></p>";
                    }
                ?>
                
            </div>
            <div id='right'>
                <?php
                    if (isset($_SESSION['failedcreate']))
                    {
                        echo "<p>Failed to create new user</p>";
                        unset($_SESSION['failedcreate']);
                    }
                    else
                    if (isset($_SESSION['oneoffpw']))
                    {
                        if (isset($_SESSION['oneoffpwreset']))
                            echo "<p class='pmsg'>Password Reset for <strong>{$_SESSION['oneoffusername']} </strong> with new default password of <strong>{$_SESSION['oneoffpw']} </strong><button class='butcpy' onclick='devt.copyclip(\"{$_SESSION['oneoffpw']}\")'>COPY TO CLIPBOARD</button></p>";
                        else
                            echo "<p class='pmsg'>New User <strong>{$_SESSION['oneoffusername']} </strong>created with default password of <strong>{$_SESSION['oneoffpw']} </strong><button class='butcpy' onclick='devt.copyclip(\"{$_SESSION['oneoffpw']}\")'>COPY TO CLIPBOARD</button></p>";
                        if (isset($_SESSION['oneoffemail']))
                        {
                            echo "<p>An email has been sent to {$_SESSION['oneoffemail']} introducing them to nValuate</p>";
                            echo "<p>Sometimes this email may appear in SPAM, so either get them to check or send this link to then to finalise their registration:</p>";
                            echo "<p>{$_SESSION['oneoffurl']}</p>";
                        }

                        if (ESecure::IS_MODULE_ROOM() && !isset($_SESSION['oneoffpw']))
                            echo "<p>You will need to select <strong>{$_SESSION['oneoffname']}</strong> on the left and allocate folder permissions for the Data Room";

                        unset($_SESSION['oneoffpwreset']);
                        unset($_SESSION['oneoffpw']);
                        unset($_SESSION['oneoffusername']);
                        unset($_SESSION['oneoffemail']);
                        unset($_SESSION['oneoffname']);
                        unset($_SESSION['oneoffurl']);
                    }
                    else
                    if($selUser || $createnew)
                    {
                        if (!$createnew)
                        {
                            $fields['user_name'] = $selUser['user_name'];
                            $fields['user_username'] = $selUser['user_username'];
                            $fields['user_mobilephone'] = $selUser['user_mobilephone'];
                            $fields['user_email'] = $selUser['user_email'];
                            $fields['user_forcereset'] = $selUser['user_forcereset'];
                            $fields['user_security'] = $selUser['user_security'];
                            $fields['user_allow_email_notification'] = $selUser['user_allow_email_notification'];
                            $fields['user_allow_text_notification'] = $selUser['user_allow_text_notification'];
                            $strLastLogin = "Never signed in";
                            $strLastHB = "User never entered scoring module";

                            if ($selUser['user_lastlogin'])
                            {
                                $dtLastLogin = new DateTime($selUser['user_lastlogin']);
                                $dtLastLogin->setTimezone($tz);
                                $strLastLogin = $dtLastLogin->format('D jS F Y H:i');
                            }
                            if ($selUser['user_last_heartbeat_time'])
                            {
                                $cnt = intval($selUser['user_last_hearbeat_count']);
                                $dtLastHB = new DateTime($selUser['user_last_heartbeat_time']);
                                $dtLastHB->setTimezone($tz);
                                $strLastHB = "{$dtLastHB->format('D jS F Y H:i')} on for approximately {$cnt} minutes at IP Address {$selUser['user_last_heartbeat_ipaddress']}";
                            }


                            echo "<h1>{$DB->displayText($selUser['user_name'])}</h1>";
                        }
                        else
                            echo "<h1>NEW USER</h1>";
                        echo "<div id='userdetails'>";
                             echo "<form method='post' action='{$selff}'>";
                                echo "<table>";
                                    echo "<tr><td>NAME</td><td><input type='text' name='rname' size='30' value='{$DB->displayText($fields['user_name'])}' autocomplete='off'/></td></tr>";
                                    echo "<tr><td>USERNAME</td><td><input type='text' name='uname' size='50' value='{$DB->displayText($fields['user_username'])}' placeholder='Username or leave blank to use email' autocomplete='off'/></td></tr>";
                                    echo "<tr><td>MOBILE PHONE</td><td><input type='text' name='mphone' value='{$DB->displayText($fields['user_mobilephone'])}' autocomplete='off'/></td></tr>";
                                    echo "<tr><td>EMAIL</td><td><input type='email' size='50' name='memail' value='{$DB->displayText($fields['user_email'])}' autocomplete='off'/></td></tr>";
                                    $checked = '';
                                    if (!$createnew)
                                    {
                                        if ($fields['user_forcereset'])
                                            $checked = 'checked ';
                                        echo "<tr><td>FORCE PASSWORD RESET</td><td><input type='checkbox' name='fr' {$checked}/></td></tr>";
                                        if ($global['global_max_signin_attempts'] > 0 && $selUser['user_failed_login_count'] >= $global['global_max_signin_attempts'])
                                        {
                                            echo "<tr><td class='red' colspan='2'>USER ACCOUNT LOCKED - TOO MANY FAILED LOGIN ATTEMPTS</td></tr>";
                                        }
                                    }
                                    if (!$createnew)
                                    {
                                        echo "<tr><td>LAST SIGN-IN</td><td>{$strLastLogin}</td></tr>";
                                        echo "<tr><td>LAST SCORE HEARTBEAT</td><td>{$strLastHB}</td></tr>";
                                    }
                                    echo "<tr><td class='tdh1'></td></tr>";

                                    echo "<tr><td class='tdhd1' colspan='2'>USER NOTIFICATION OPTIONS</td></tr>";
                                    $checked = '';
                                    if ($fields['user_allow_email_notification'])
                                        $checked = 'checked ';
                                    echo "<tr><td>EMAIL NOTIFICATIONS</td><td><input type='checkbox' name='emailnot' {$checked}/></td></tr>";

                                    $checked = '';
                                    if ($fields['user_allow_text_notification'])
                                        $checked = 'checked ';
                                    echo "<tr><td>TEXT NOTIFICATIONS</td><td><input type='checkbox' name='textnot' {$checked}/></td></tr>";
                                    echo "<tr><td class='tdh1'></td></tr>";

                                    echo "<tr><td class='tdhd1' colspan='2'>USER CAPABILITIES</td></tr>";
                                    $checked = '';
                                    $enabled = false;

                                    if (Secure::CheckUserSecurity($fields,SECURITY_ADMIN))
                                    {
                                        $checked = 'checked ';
                                        $enabled = true;
                                    }
                                    else
                                    {
                                        if ($num_administrators < $max_administrators)
                                            $enabled = true;
                                    }
                                    echo "<tr><td>CAN RUN AND REPORT</td><td><input type='checkbox' name='canrun' {$checked} ";
                                    if (!$enabled)
                                        echo " title='Cannot set as the maximum number of administrators has been met' disabled";
                                    echo "/></td></tr>";
                                    $checked = '';

                                    if (Secure::CheckSecurity(SECURITY_ADMIN_CONFIGURE))
                                    {
                                        if (Secure::CheckUserSecurity($fields,SECURITY_ADMIN_CONFIGURE))
                                            $checked = 'checked ';
                                        echo "<tr><td>CAN CONFIGURE AND CREATE</td><td><input type='checkbox' name='canconfig' {$checked}";
                                        if (!$enabled)
                                            echo " title='Cannot set as the maximum number of administrators has been met' disabled";
                                        echo "/></td></tr>";
                                    }
                                    echo "<tr><td class='tdh1'></td></tr>";

                                    if (ESecure::IS_MODULE_SCORE())
                                    {
                                        echo "<tr><td class='tdhd1' colspan='2'>SCORE USER PROPERTIES</td></tr>";
                                        $checked = '';
                                        $enabled = false;
                                        if (Secure::CheckUserSecurity($fields,SECURITY_EVALUATE))
                                        {
                                            $enabled = true;
                                            $checked = 'checked ';
                                        }
                                        else
                                        {
                                            if ($max_evaluators == 0 || $num_evaluators < $max_evaluators)
                                                $enabled = true;
                                        }
                                        echo "<tr><td>IS EVALUATOR</td><td><input type='checkbox' name='ev' {$checked}";
                                        if (!$enabled)
                                            echo " title='Cannot set as the maximum number of evaluators has been met' disabled";
                                        echo " /></td></tr>";
                                    }
                                    if (ESecure::IS_MODULE_ROOM())
                                    {
                                        echo "<tr><td class='tdh1'></td></tr>";
                                        echo "<tr><td class='tdhd1' colspan='2'>DATA ROOM USER PROPERTIES</td></tr>";
                                        $checked = '';
                                        if (Secure::CheckUserSecurity($fields,SECURITY_DATAROOM_VIEW))
                                            $checked = 'checked ';
                                        echo "<tr><td>DATAROOM ACCESS</td><td><input type='checkbox' name='dr' {$checked}/></td></tr>";
                                        $checked = '';
                                        if (Secure::CheckUserSecurity($fields,SECURITY_DATAROOM_LOAD))
                                            $checked = 'checked ';
                                        echo "<tr><td>CAN UPLOAD CONTENT</td><td><input type='checkbox' name='ul' {$checked}/></td></tr>";
                                        $checked = '';
                                        if (Secure::CheckUserSecurity($fields,SECURITY_DATAROOM_DELETE))
                                            $checked = 'checked ';
                                        echo "<tr><td>CAN DELETE CONTENT</td><td><input type='checkbox' name='drdel' {$checked}/></td></tr>";
                                    }
                                echo "</table>";

                                if($selUser)
                                {
                                    echo "<input type='submit' name='chguser' value = 'UPDATE'/>";
                                    echo "<div id='editactions'>";
                                        echo "<p>OTHER ACTIONS</p>";
                                        if ($selUser['user_deleted'])
                                            echo "<input type='submit' name='undeluser' value = 'UNDELETE USER'/>";
                                        else
                                            echo "<input type='submit' name='deluser' value = 'DELETE USER'/>";
                                        echo "<input type='submit' name='resetpw' value = 'RESET PASSWORD'/>";
                                    echo "</div>";
                                    if ($global['global_max_signin_attempts'] > 0 && $selUser['user_failed_login_count'] >= $global['global_max_signin_attempts'])
                                        echo "<input type='submit' name='unlockact' value = 'UNLOCK ACCOUNT'/>";
                                    $v = $FL->encryptParam("val={$selUser['iduser']}");
                                    echo "<input type='hidden' name='k' value='{$v}'/>";
                                }
                                else
                                    echo "<input type='submit' name='newuser' value = 'CREATE'/>";
                            echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}' />";
                            echo "</form>";
                        echo "</div>";

                        if (!$createnew)
                        {
                            if (ESecure::IS_MODULE_SCORE())
                            {
                                echo "<div id='scoreperm'>";
                                echo "<h1>USER SCORE PERMISSIONS</h1>";
                                $r = $DB->allEvaluationsForUser($selUser['iduser']);
                                while ($team = $r->fetch_array(MYSQLI_ASSOC))
                                {
                                    $eval = $DB->getEvaluation($team['team_evaluation']);
                                    echo "<h2>Evaluation <q>{$DB->displayText($eval['evaluation_name'])}</q> User Phases</h2>";
                                    echo "<div id='evaltable'>";
                                        echo "<table>";
                                        echo "<tr>";
                                        $r = $DB->allPhasesForEval($eval['idevaluation'],'order by idphase');
                                        while ($phase = $r->fetch_array())
                                        {
                                            $phasename = $DB->displayText($phase['phase_name']);
                                            echo "<th>{$phasename}</th>";
                                        }
                                        echo "<th></th>";
                                        echo "</tr>";

                                        $r2 = $DB->allPhasesForEval($eval['idevaluation'],'order by idphase');
                                        while ($phase = $r2->fetch_array())
                                        {
                                            echo "<td>";
                                            if ($DB->userHasPhase($selUser['iduser'],$phase['idphase']) )
                                                echo "YES";
                                            echo "</td>";
                                        }
                                        echo "</table>";
                                    echo "</div>";
                                }
                                echo "</div>";
                            }

                            if (ESecure::IS_MODULE_ROOM())
                            {
                                echo "<div id='permissions'>";
                                echo "<h1>USER DATAROOM PERMISSIONS</h1>";
                                    echo "<table>";
                                        buildFolderTreeTable($selUser,null);
                                    echo "</table>";
                                echo "</div>";
                            }
                            echo "<h1>USER AUDIT</h1>";
                            echo "<div id='audit'>";
                                echo "<table>";
                                    buildAudit($selUser);
                                echo "</table>";
                            echo "</div>";
                        }
                    }
                ?>
            </div>
        </div>
    </div>
</body>
</html>