<?php session_start(); ?>
<?php
require './includes/classEvalSecure.php';
require './includes/classEvaluateDB.php';
require './includes/classFormList.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());

$selff = htmlspecialchars($_SERVER["PHP_SELF"]);
$instancename = $devt_environment->getkey("DATABASE_NAME");

$_SESSION['returnto'] = $selff;

$global = $DB->getGlobal();
ESecure::CheckPage(SECURITY_ADMIN);
$user = $DB->getUser($_SESSION['userid']);
ESecure::CheckUser($user);

$FL = new FormList(null);

function var_error_log( $object=null ,$text='')
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( "{$text} {$contents}" );        // log contents of the result of var_dump( $object )
}


$row = null;
$evaluation = null;
$strErrorBackupRestore = '';

if (isset($_GET['prog']))
{
    $_SESSION['progress'] = intval($_GET['prog']);
    $_SESSION['subprogress'] = 0;
    header("Location: {$selff}");
    exit();
}


//Final check that we have set progress and subprogress
if (!isset($_SESSION['progress']))
    $_SESSION['progress'] = 0;
if (!isset($_SESSION['subprogress']))
    $_SESSION['subprogress'] = 0;

$user = $DB->getUser($_SESSION['userid']);

function delete_directory($dirname) {
         if (is_dir($dirname))
           $dir_handle = opendir($dirname);
     if (!$dir_handle)
          return false;
     while($file = readdir($dir_handle)) {
           if ($file != "." && $file != "..") {
                if (!is_dir($dirname."/".$file))
                     unlink($dirname."/".$file);
                else
                     delete_directory($dirname.'/'.$file);
           }
     }
     closedir($dir_handle);
     rmdir($dirname);
     return true;
}

if ($_SERVER["REQUEST_METHOD"] == "GET"  && isset($_GET['v']))
{
    $val = $FL->decryptParamRaw($_GET['v']);
    $fullpathname = $val['v'];
    $filename = basename($fullpathname);

    $dt = new DateTime();
    $nm = md5($dt->getTimestamp());
    $dest = "/tmp/{$nm}.zip";

    $zip = new ZipArchive();
    $zip->open($dest, ZipArchive::CREATE | ZipArchive::OVERWRITE);
    if (!$zip->addFile($fullpathname,$filename) )
        error_log("nvaluate::" . __FILE__ . "[".__LINE__."] Error adding file {$filenname} to zip");
    $zip->close();

    header("Content-Type: application/zip");
    header("Content-Disposition: attachment; {$filename}");
    echo file_get_contents($dest);

    unlink($dest);

    exit();
}



if ($_SERVER["REQUEST_METHOD"] == "POST")
{

    if (!Secure::checkCSRF())
    {
        header("Location: SecurityError.php");
        exit();
    }


    if (isset($_POST['restore']))
    {
        //Create a backup of sql database file first
        $dir = $devt_environment->getkey('BACKUPDIR');
        $DB->Backup($user,$dir);

        unset($_SESSION['restoremsg']);

        $dirscratch = $dir . "/scratch2";
        //$dirsql = $dirscratch . "/sql";

        if (!is_dir($dirscratch))
            mkdir($dirscratch);

        //if (!is_dir($dirsql))
           // mkdir($dirsql);

        $key = $devt_environment->getkey("BACKUPKEY");
        $encryption_key = base64_decode($key);
        $strOutFilename = $dirscratch . "/Backup.zip";

        $fhandle = fopen($_FILES['restorefile'] ['tmp_name'],'r');

        if ($fhandle)
        {
            $fout = fopen($strOutFilename,'w');
            while (!feof($fhandle))
            {
                $l = intval(fread($fhandle,10));
                $iv = fread($fhandle,16);
                if ($l > 0)
                {
                    $buff = fread($fhandle,$l);
                    $result = openssl_decrypt($buff, 'aes-256-cbc', $encryption_key, 0, $iv);
                    fwrite($fout,$result,strlen($result));
                }
            }
            fclose($fhandle);
            fclose($fout);

            $zip = new ZipArchive;
            $res = $zip->open($strOutFilename);
            if ($res === TRUE)
            {
                $rslt = $zip->extractTo($dirscratch);
                $zip->close();
            }


            //Open the manifest
            $strManifestName = $dirscratch . "/manifest";
            $fman = fopen($strManifestName,"r");
            if ($fman)
            {
                $m = fread($fman,filesize($strManifestName));
                $manifest = json_decode($m,3);

                if (isset($manifest['database']))
                {
                    $files = $manifest['database'] ['files'];
                    if (count($files) == 1)
                    {
                        $srcsql = $dirscratch ."/sql/" .  basename($files[0]);
                        error_log("Restoring database from {$srcsql}");
                        $result = $DB->loadFromSQL($srcsql);
                        if (isset($result['rslt']) && strlen($result['rslt']) == 0)
                            $_SESSION['restoremsg'] = "Restore of database";
                        else
                            $_SESSION['restoremsg'] = "ERROR: Restoring data - seek support";

                    }
                }
                if (isset($manifest['dataroom']))
                {
                    $files = $manifest['dataroom'] ['files'];
                    foreach($files as $file)
                    {
                        $srcfile = $dirscratch . "/dataroom/" . basename($file);
                        copy($srcfile,$file);
                    }
                    if (strlen($_SESSION['restoremsg']) > 0)
                        $_SESSION['restoremsg'] .= " and dataroom files";
                    else
                        $_SESSION['restoremsg'] = "Restore of dataroom files";
                }

                if (strlen($_SESSION['restoremsg']) > 0)
                    $_SESSION['restoremsg'] .= " complete";
                $_SESSION['progress'] = 2;
                $_SESSION['subprogress'] = 0;
                delete_directory($dirscratch);
                header("Location: {$selff}");
                exit();
            }
            else
            {
                error_log("Restore: no manifest is restore file: {$_FILES['restorefile'] ['tmp_name']}");
                $_SESSION['restoremsg'] =  "Unable to open the restore file, missing manifest. Please check that it is a valid nvaluate backup file";
                $_SESSION['progress'] = 2;
                $_SESSION['subprogress'] = 0;
                delete_directory($dirscratch);
                header("Location: {$selff}");
                exit();
           }
        }
        else
        {
            error_log("Restore: unable to open restrore file {$_FILES['restorefile'] ['tmp_name']}");
            $_SESSION['restoremsg'] =  "Unable to open the restore file, please check that it is a valid nvaluate backup file";
            $_SESSION['progress'] = 2;
            $_SESSION['subprogress'] = 0;
            delete_directory($dirscratch);
            header("Location: {$selff}");
            exit();

        }


        $_SESSION['progress'] = 2;
        $_SESSION['subprogress'] = 0;
        delete_directory($dirscratch);
        header("Location: {$selff}");
        exit();
    }
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta name="viewport" content="width=device-width" />
    <meta name="viewport" content="initial-scale=1.0" />
    <title>MAINTENANCE</title>
    <link href="css/Base.css" rel="stylesheet">
    <link href="css/Tasks.css" rel="stylesheet">
    <link href="css/Details.css" rel="stylesheet">
    <style>
    #backupform {display: none;}
    #backupform p {font-family: 'Roboto';font-size: 11pt;color: #555;}
    #backupform p.phd1 {font-size: 10pt;margin: 0;position: relative;top: -16px;font-weight: 400;background-color: #f8f8f8;display: inline-block;font-family: inherit;color: #000;}
    #backupform p.msg {color: #b92e02;}
    #backupform button {margin-top: 10px;}
    #backupform input {font-size: 10pt;}
    #backupoptions input[type='checkbox'] {display: initial;width: 16px;height: 16px;}
    #backupoptions span{position: relative; top: -3px;}
    #backups {margin: 10px; border: solid 1px #555; padding: 10px; border-radius: 6px;}
    #backupprogress {margin: 10px; border: solid 1px #555; padding: 10px; border-radius: 6px;display: none;}
    #backupprogress h1 {text-align: center;}
    #backupprogress p {text-align: center;}
    #restore {margin: 10px; border: solid 1px #555; padding: 10px; border-radius: 6px;}
    #restore p.warning {color: red;}
    #auditreport {display: none;}
    #auditreport h2 {margin: 0;margin-left: 20px;font-family: 'Roboto';font-size: 10pt;font-weight: 400;color: #333;padding-bottom: 20px;}
    #purgeall {display: none;}
    #dumpallexcel {display: none;}
    #listbackups {display: none;border: solid 1px #888; padding: 10px; padding-left:16px; padding-right: 20px;}
    .loader {
          border: 8px solid #f3f3f3;
          border-radius: 50%;
          border-top: 8px solid #3498db;
          width: 30px;
          height: 30px;
          -webkit-animation: spin 2s linear infinite; /* Safari */
          animation: spin 2s linear infinite;
          margin: auto;
        }

        /* Safari */
        @-webkit-keyframes spin {
          0% { -webkit-transform: rotate(0deg); }
          100% { -webkit-transform: rotate(360deg); }
        }

        @keyframes spin {
          0% { transform: rotate(0deg); }
          100% { transform: rotate(360deg); }
        }
    </style>
    <script type="text/javascript" src="apievaljsonv1.php?r=/<?php echo $user['user_apikey'];?>/devtscript/<?php echo $instancename;?>/devtcore&formtoken=<?php echo urlencode($_SESSION['csrf_key']);?>"></script>
    <script type="text/javascript" src="apievaljsonv1.php?r=/<?php echo $user['user_apikey'];?>/devtscript/<?php echo $instancename;?>/eval&formtoken=<?php echo urlencode($_SESSION['csrf_key']);?>"></script>
    <script>
        eval.selfurl = '<?php echo $selff;?>';
        var g_formtoken = "<?php echo $_SESSION['csrf_key'];?>";
        var g_formtoken_encoded = "<?php echo urlencode($_SESSION['csrf_key']);?>";
        var thispage = 'maintenance';
        var progress = <?php echo $_SESSION['progress'];?>;
        var subprogress = <?php echo $_SESSION['subprogress'];?>;
        var evaluations = [<?php 
        $bone = false;
        $r = $DB->allEvaluations('order by evaluation_name');
        while ($evl = $r->fetch_array(MYSQLI_ASSOC))
        {
            if ($bone) echo ",";
            echo "{id:{$evl['idevaluation']},name:'{$evl['evaluation_name']}'}";
            $bone = true;
        }    
        ?>];
        var intervl = null;
        var https = <?php if (Secure::usingHTTPS()) echo 'true'; else echo 'false';?>;
        var userid = <?php echo $user['iduser']?>;
        var apireplies = {'checksignal': 'checksignal','deletesignal':'deletesignal'};
        eval.init('<?php echo $_SERVER['HTTP_HOST']?>','apievaljsonv1.php?r=','<?php echo $user['user_apikey']; ?>', https,apireplies);
        var haveDownloadSignal = false;
        function purgeit() {
            window.location = 'PurgeEverything.php';
        }
        function dumpallcsv() {
            window.location = 'EvalDump.csv';
        }
        function chooseEval(v) {
            window.location = '<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>?e=' + v;
        }
        function start() {
            eval.setCurrentAction();
            eval.signaldelete('DOWNLOAD');
        }
        function startdownload() {
            devt.ge('backups').style.display = 'none';
            devt.ge('restore').style.display = 'none';
            devt.ge('backupprogress').style.display = 'block';
            eval.signalcheck('DOWNLOAD');
            intervl = setInterval(checker,2000);
        }
        function checker() {
            if (!haveDownloadSignal)
                eval.signalcheck('DOWNLOAD');
            else
                eval.signaldelete('DOWNLOAD');
        }
        function checksignal(d) {
            if (devt.def(d['have']) ) {
                if (d['have']) {
                    devt.ge('backups').style.display = 'block';
                    devt.ge('restore').style.display = 'block';
                    devt.ge('backupprogress').style.display = 'none';
                    haveDownloadSignal = true;
                    eval.signaldelete('DOWNLOAD');
                }
            }
        }
        function deletesignal(d) {
            if (devt.def(d['deleted']) ) {
                if (d['deleted']) {
                    clearInterval(intervl);
                }
            }
        }

    </script>
</head>
<body onload='start()'>
  <div class="container">
    <div id='heading'>
        <table>
            <tr><td></td><td class='ht'>nVALUATE</td><td></td></tr>
        </table>
    </div>
    <div id='menu'>
        <div class='d1'><a href='Admin.php'>ADMIN</a></div>
        <div class='d1 sel'>MAINTENANCE</div>
        <div class='d1'><a href="Signout.php">SIGN OUT</a></div>
        <?php
        if (ESecure::IS_MODULE_SCORE() && Secure::CheckSecurity(SECURITY_EVALUATE))
            echo "<div class='d1'><a href='Score'>SCORE</a></div>";
        ?>
        <?php
        if (ESecure::IS_MODULE_ROOM())
                echo "<div class='d1'><a href='DataRoom.php'>DATAROOM</a></div>";
        ?>
        <div class='d2'><?php if ($user) echo $user['user_name'];?></div>
        <div class='clear'></div>
    </div>
    <div id='main'>
        <div id='tasks'>
            <h1>MAINTENACE TASKS</h1>
            <table>
                <?php
                echo "<tr><td></td><td class='progger' prog='2'></td><td colspan='2' onclick='eval.changeProgress(2)'><span class='anchor'>BACKUP AND RESTORE</span></td></tr>";
                echo "<tr><td></td><td class='progger' prog='6'></td><td colspan='2' onclick='eval.changeProgress(6)'><span class='anchor'>VIEW AVAILABLE BACKUPS</span></td></tr>";
                echo "<tr><td></td><td class='progger' prog='5'></td><td colspan='2' onclick='eval.changeProgress(5)'><span class='anchor'>DUMP ALL TO EXCEL</span></td></tr>";
                if ( Secure::CheckSecurity(SECURITY_COMMANDER) )
                {
                    echo "<tr><td></td><td class='progger' prog='3'></td><td colspan='2' onclick='eval.changeProgress(3)'><span class='anchor'>PURGE ALL</span></td></tr>";
                }
                ?>
            </table>
        </div>
        <div id='details'>
            <div id='backupform' class='righty'>
                <h1>BACKUP AND RESTORE</h1>
                <div id='backupform1' class='sub'>
                    <div id='backupprogress'>
                        <h1>DOWNLOADING BACKUP</h1>
                        <p>Please be patient, depending on how much data you have this could take some time.</p>
                        <p>Check your devices default download folder</p>
                        <div class='loader'></div>
                    </div>
                    <div id='backups'>
                        <p class='phd1'>BACKUPS</p>
                        <p>Create a secure backup of the data in the system.  This will download a file to your PC, you will need to copy the file and save it somewhere safe in case you need it to restore at a later time.</p>
                        <div id='backupoptions'>
                            <form method='post' action='Backup.bak'>
                                <p>BACKUP OPTIONS</p>
                                <input type='checkbox' name='db' checked /><span>DATABASE</span><br/>
                                <?php
                                if (Esecure::IS_MODULE_ROOM())
                                {
                                    echo "<input type='checkbox' name='files'/><span>DATAROOM FILES</span><br/>";
                                }
                                ?>
                                <input type='submit' name='backup' value='BACKUP' onclick='startdownload()'/>
                                <?php
                                echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}'>";
                                ?>
                            </form>
                        </div>
                    </div>
                    <div id='restore'>
                        <p class='phd1'>RESTORE</p>
                        <p>To securely restore from a backup, select the 'Choose File" button and open the file.  Once select select the 'RESTORE' but to restore from backup.</p>
                        <p class='warning'>WARNING: Doing this will erase any changes made to the system between when the backup was taken and now.</p>
                        <form method="post" enctype='multipart/form-data' action="<?php echo $selff;?>">
                            <input type='file' name='restorefile' accept=".nvl" onchange="eval.fileCheck(this,'submitrestore')" />
                            <input id='submitrestore' type='submit' value='RESTORE' name='restore' onclick='eval.cursorWait()' disabled/>
                            <?php
                            echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}'>";
                            ?>
                        </form>
                        <?php 
                            if (isset($_SESSION['restoremsg']) && strlen($_SESSION['restoremsg']) > 0)
                            {
                                echo "<p class='msg'>{$_SESSION['restoremsg']}</p>";
                                unset($_SESSION['restoremsg']);
                            }
                        ?>
                    </div>
                </div>
            </div>
            <div id='purgeall' class='righty'>
                <h1>PURGE ALL</h1>
                <div id='purgeallform1' class='sub'>
                    <p class='warning'>WARNING:  This will remove everything</p>
                    <button onclick='purgeit()'>PURGE ALL</button>
                </div>
            </div>
            <div id='dumpallexcel' class='righty'>
                <h1>DUMP ALL TO EXCEL CSV FILE</h1>
                <div id='dumpallexcelform1' class='sub'>
                    <button onclick='dumpallcsv()'>DUMP ALL</button>
                </div>
            </div>
            <div id="listbackups" class="righty">
                <h1>LIST OF RECENT BACKUPS</h1>
                <div id='listbackupsform1' class='sub'>
                    <table>
                        <tr><th>NAME</th><th>SIZE</th></tr>
                        <?php
                    $backupdir = $devt_environment->getkey("BACKUPDIR");
                    $files = scandir($backupdir);
                    $cnt = count($files);
                    foreach($files as $file)
                    {
                        if ($file != "." && $file != ".." && substr($file,0,6) == "Backup")
                        {
                            if ($cnt < 72)
                            {
                                $v = urlencode($FL->encryptParam("v={$backupdir}/{$file}"));
                                $sz = filesize("{$backupdir}/{$file}");
                                $sz = floatval($sz) / 1000000.0;
                                $strsz = sprintf("%4.1fM",$sz);
                                echo "<tr><td><a href='Maintenance.php?v={$v}'>{$file}</a></td><td>{$strsz}</td></tr>";
                            }
                        }
                        $cnt--;
                    }
                        ?>
                    </table>
               </div>

            </div>
        </div>
        <div id='clear1'>
        </div>
    </div>
  </div>
</body>
</html>
