<?php session_start(); ?>
<?php
//devt.Version = 1.0
require './includes/classEnvironment.php';
require './includes/Security.php';
require './includes/classSiem.php';
require_once "./includes/classRolling.php";
require './includes/classFormList.php';

$strErr='';

//Database
require './includes/classEvaluateDB.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
$SIEM = new devt\siem\siem($devt_environment->getkey("SIEMHOST"));

function var_error_log( $object=null )
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( $contents );        // log contents of the result of var_dump( $object )
}

function securityError($t = '')
{
    global $DB;
    $DB->createSecurityAudit(null,$t);
    header("Location: SecurityError.php");
    exit();
}


if (Rolling::checkRate($DB,"verifyuser"))
{
    $SIEM->createSecurityEntry("signin",SECURITY_RATE_SIGNIN,"severe",getenv("VAULT_SHELF"),"Excessive hits on Entry for user verification");
    header("Location: SecurityError.php");
    $_SESSION['security_error'] = 'rolling';
    session_regenerate_id(true);
    exit();
}

if (!isset($_SESSION['csrf_key_signin']))
{
    $_SESSION['csrf_key_signin']=base64_encode(openssl_random_pseudo_bytes(32));
    header("Location: Entry.php?v={$_GET['v']}");
    exit();
}

?>
<!DOCTYPE HTML>
<html>
<head>
<meta name="viewport" content="width=device-width">
<meta name="viewport" content="initial-scale=1.0">
<title>nValuate Verify</title>
    <link href="css/Base.css" rel="stylesheet">
<style>
#main {margin: auto; margin-top: 20px; width: 600px;}
#form {margin-top: 60px; margin-bottom: 20px; margin-left: auto; margin-right: auto; width: 500px; border: solid 1px #808080; padding: 8px; border-radius: 8px;}
#form h1 {text-align: center;color: #666;font-family: 'Roboto';}
input[type='text'] {height: 30px;padding-left: 10px;font-size: 14pt;}
input[type='password'] {height: 30px;padding-left: 10px;font-size: 14pt;}
input[type='checkbox'] {transform: scale(1.5);margin-right: 10px;}
td.td1 {font-size: 14pt;color: #a0a0a0;}
td.tdh1 {height: 20px;}
</style>
<script>
function checkInputs() {
    var pw1 = document.getElementById('pw1');
    var pw2 = document.getElementById('pw2');
    var iagree = document.getElementById('iagree');
    if (pw1.value.length > 0 && pw2.value.length > 0)
    {
        if (pw1.value == pw2.value && iagree.checked)
        {
            document.getElementById('submit').disabled = false;
            return;
        }
    }
    document.getElementById('submit').disabled = true;
}
</script>
</head>
<body>
<?php
$u = 0;
$err = true;
$user = null;
if (isset($_GET['v']))
{
    $v = $_GET['v'];
    $params=array();
    $query = sec_decryptParamPart($v,$devt_environment->getkey("VERIFY_USER_KEY"));

    foreach (explode('&', $query) as $chunk) 
    {
        $param = explode("=", $chunk);
        $params[$param[0]] = urldecode($param[1]);
    }
    if (isset($params['userid']))
    {
        if ($user = $DB->getUser($params['userid']) )
        {
            if (!$user['user_forcereset'] || $user['user_lastlogin'])
            {
                $_SESSION['userid'] = $user['iduser'];
                $_SESSION['csrf_key']=base64_encode(openssl_random_pseudo_bytes(32));
                header("Location: ChangePW.php");
                exit();
            }
            
            $_SESSION['entry_id'] = $user['iduser'];
            $err = false;
        }
    }
}
if ($err && $_SERVER["REQUEST_METHOD"] == "GET")    
{
    $_SESSION['security_error'] = 'breach';
    header("Location: SecurityError.php");
    exit();
}

if ($_SERVER["REQUEST_METHOD"] == "POST")
{
    $bValid = false;

    if (! isset($_SESSION['csrf_key_signin']) || ! isset($_POST['formtoken']) || $_SESSION['csrf_key_signin'] != $_POST['formtoken'])
    {
        $SIEM->createSecurityEntry("csrf",SECUITY_INVALID_CSRF,"minor",getenv("VAULT_SHELF"),"Invalid CSRF in Verifying user");
        securityError("SECURITY VerifyUser.php: Missing session variables signin, csrf and formtoken");
    }
    
    
    $npw = FormList::getField("newpw");
    $npw2 = FormList::getField("newpw2");
    
    if (isset($_SESSION['entry_id']) && $user = $DB->getUser($_SESSION['entry_id']) )
    {
        if ($npw == $npw2)
        {
            $api_key = '';
            //We have a password that matches
            $salt = createSalt();
            $hash = passwordHash($npw,$salt);
            $DB->updatePassword($user['iduser'],$hash,$salt);
            header('Location: Signin.php');
            exit();
            
                
            if (!$user['user_apikey'] || strlen($user['user_apikey'] < 16))
            {
                $bDoneKey = false;
                while (!$bDoneKey)
                {
                    $api_key = createKey(16);
                    if (!$bDoneKey = $DB->updateUserApiKey($user['iduser'],$api_key) )
                    {
                        $api_key = '';    
                        if ($DB->errno != 1062)
                                $bDoneKey = true;  // exit loop
                    }
                }
            }
            $DB->updateUserLastSiginIn($user['iduser']);
                
            //Setup and go
            unset($_SESSION['progress']);
            unset($_SESSION['subprogress']);
            unset($_SESSION['userid']);
            unset($_SESSION['entry_id']);
            
            $_SESSION['tz'] = ''; 
            $_SESSION['org']=0;
            $_SESSION['team']=0;
            $_SESSION['userid']=0;
            $_SESSION['username']='';
            $_SESSION['security']=0;
            $_SESSION['name']='';
            $_SESSION['application']='';
            if ($user['user_timezone'] != null)
                $_SESSION['tz'] = $user['user_timezone'];
            else
                $_SESSION['tz'] = 'UTC';
    
            $_SESSION['application']='Evaluate';
            $_SESSION['userid']=$user['iduser'];
            $_SESSION['username']=$user['user_username'];
            $_SESSION['security']=$user['user_security'];
            $_SESSION['name']= $user['user_name'];
            $_SESSION['api_key']=$api_key;
            $_SESSION['session_key']=base64_encode(openssl_random_pseudo_bytes(32));
            if (isset($_SESSION['nextStep']) ) unset($_SESSION['nextStep']);
            $_SESSION['current_evaluation'] = 0;
            $DB->createAudit('login',$user,'Password Change');
            
            if (CheckSecurity(SECURITY_ADMIN))
            {
                $SIEM->createSecurityEntry("signin",SECURITY_SIGNIN,"information",getenv("VAULT_SHELF"),"New user verified [{$user['iduser']}]");
                header('Location: Admin.php');
                exit();
            }
              
            if (IS_MODULE_SCORE())
            {
                if (CheckSecurity(SECURITY_EVALUATE))
                {
                    error_log("Entry: Sing-in complete now redirecting to Score");
                    header('Location: Score');
                    exit();
                }
            }
            if (IS_MODULE_ROOM())    
            {
                if (CheckSecurity(SECURITY_DATAROOM_VIEW))
                {
                    error_log("Entry: Sing-in complete now redirecting to Dataroom");
                    header('Location: DataRoom.php');
                    exit();
                }
            }
            $_SESSION['security_error'] = 'noservicesconfigured';
            header('Location: SecurityError.php');
            exit();
        }
        else
            $strErr = "New passwords not identicle.";
    }  
}
?>
<div id='container'>
    <div id='heading'>
        <table>
            <tr><td></td><td class='ht'>nVALUATE</td><td></td></tr>
        </table>
    </div>
    <div id='main'>
        <div id='form'>
            <h1>ACCOUNT SETUP</h1>
            <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>">
                <table>
                <tr><td class='td1'>USER NAME</td><td><input type='text' name = 'uname' value = '<?php echo $user['user_username'];?>'readonly /></td></tr>
                <tr><td class='td1'>NEW PASSWORD</td><td><input id='pw1' type='password' name = 'newpw' onchange='checkInputs()' autofocus/></td></tr>
                <tr><td class='td1'>REPEAT PASSWORD</td><td><input id='pw2' type='password' name = 'newpw2' onchange='checkInputs()' /></td></tr>
                <tr><td colspan='2'><input id='iagree' type='checkbox' name='agree' onchange='checkInputs()' /><span>I accept the service provider <a href='/documents/nValuate service provider agreement.pdf' target='_blank'>terms and conditions</a></span></td></tr>
                <tr><td class='tdh1'></td></tr>
                <tr><td><input id='submit' type='submit' value='CREATE' disabled /></td><td></td></tr>
                <?php
                if (strlen($strErr) > 0)
                {
                    echo "<tr><td colspan='2'>".$strErr."</td></tr>";
                }
                ?>
                </table>
                <?php echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key_signin']}'>"; ?>
            </form>
        </div>
    </div>
</div>
</body>
</html>