<?php
require dirname(__FILE__) . '/includes/classEnv.php';
require dirname(__FILE__) . '/includes/classEvaluateDB.php';

function usage()
{
    echo "CreateFirstUser Usage:\n";
    echo "  php CreateFirstUser.php -i <installation name>\n";
    echo "  For help:\n";
    echo "  php CreateFirstUser.php -h\n";
}

function createSalt()
{
    return bin2hex(openssl_random_pseudo_bytes(32));
}

function passwordHash($pw,$salt)
{
    global $pepper;
    return hash('sha256',$pw . hash('sha256', $salt . $pepper));
}


//Start
$options = getopt("hi:");
if (isset($options['h']))
{
    usage();
    exit;
}

if (!isset($options['i']))
{
    echo "No installation name specified pleasse run with: php CreateFirstUser.php -i <installation name>\n";
    exit(1);
}

$insallation_name = $options['i'];
echo "Creating first user for installation {$insallation_name}\n";

/*
 As we are not being run from the apache environment we need to get environment and vault variables by redfining
 based on the input parameter i
*/

$devt_environment = new Environment($insallation_name,220759);
$pepper = $devt_environment->getkey("PEPPER");

$DB = new EvaluateDB($devt_environment->getDatabaseParameters());

//Check if user already exists
$user = $DB->getUserByUserName('admin');
if (!$user)
{
    $pw = 'admin';
    $salt = createSalt();
    $hash = passwordHash($pw,$salt);
    if (!$DB->createUser('Administrator','admin',$hash,$salt,251,'Pacific/Auckland') )
    {
        echo "Failed to create first user\n";
    }
    else
        echo "First database user created\n";
}
?>