<?php
require dirname(__FILE__) . '/includes/classEnv.php';
require dirname(__FILE__) . '/includes/classEvaluateDB.php';

function usage()
{
    echo "CreateFirstRoom Usage:\n";
    echo "  php CreateFirstRoom.php -i <installation name>\n";
    echo "  For help:\n";
    echo "  php CreateFirstRoom.php -h\n";
}

//Start
$options = getopt("hi:");
if (isset($options['h']))
{
    usage();
    exit;
}

if (!isset($options['i']))
{
    echo "No installation name specified pleasse run with: php CreateFistRoom.php -i <installation name>\n";
    exit(1);
}

$insallation_name = $options['i'];
echo "Creating first User for installation {$insallation_name}\n";
/*
 As we are not being run from the apache environment we need to get environment and vault variables by redfining
 based on the input parameter i
*/

$devt_environment = new Environment($insallation_name,220759);
$pepper = $devt_environment->getKey($insallation_name,"PEPPER");

$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
$r = $DB->allUsers('order by iduser limit 1');
if($user = $r->fetch_array())
{
    $roomid = $DB->newRoom($user['iduser'],'DATAROOM');
    $DB->createUserHasDoc($user['iduser'],$roomid,true);
}
else
    echo "No users are defined in the system, cannot create data room";
?>