<?php session_start(); ?>
<?php
//devt.Version = 1.0
require './includes/classEvalSecure.php';
require './includes/classFormList.php';
require './includes/classRolling.php';
require './includes/classSiem.php';

if (!Secure::isHTTPS()) exit();
$SEC = new ESecure();
$strErr='';
$api_key = '';

//Database
require './includes/classEvaluateDB.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());

$SIEM = new devt\siem\siem($devt_environment->getkey("SIEMHOST"));

if (Rolling::checkRate($DB,"verifyuser"))
{
    $SIEM->createSecurityEntry("signin",SECURITY_RATE_SIGNIN,"severe",getenv("VAULT_SHELF"),"Excessive hits on Me for user verification");
    header("Location: SecurityError.php");
    $_SESSION['security_error'] = 'rolling';
    session_regenerate_id(true);
    exit();
}


if ($_SERVER["REQUEST_METHOD"] == "POST")
{
    $bValid = false;

    if (!Secure::checkCSRF())
    {
        $SIEM->createSecurityEntry("csrf",SECUITY_INVALID_CSRF,"minor",getenv("VAULT_SHELF"),"Invalid CSRF in Change Password");
        $DB->createSecurityAudit(null,"ChangePW.php [".__LINE__."] Failed CSRF check");
        header("Location: SecurityError.php");
        exit();
    }

    $opw = FormList::getField("oldpw");
    $npw = FormList::getField("newpw");
    $npw2 = FormList::getField("newpw2");

    $u = 0;
    if (isset($_SESSION['userid']))
        $u=$_SESSION['userid'];

    if ($user = $DB->getUser($u))
    {
        if ($SEC->checkPassword($opw,$user['user_passwordhash'],$user['user_salt']))
        {

            //Check the new password is not equal to old password
            if ($opw == $npw)
                $strErr = "New passwords cannot be same as old password.";
            else
            {
                //We have a valid old password
                $bValid = true;
                if ($npw == $npw2)
                {

                    if (strtoupper($npw) == strtoupper($user['user_username']))
                    {
                        $strErr = "New password cannot be same as username.";
                        $bValid = false;
                    }


                    $glb = $DB->getGlobal();
                    if ($bValid)
                    {
                        //Are we able to change if last change was less than n hours earlier.
                        if ($user['user_pw_change_date'] && $glb['global_min_time_from_last'] > 0)
                        {
                            $dtNow = new DateTime('now');
                            $minhours = intval($glb['global_min_time_from_last']);
                            $dtLastChange = new DateTime($user['user_pw_change_date']);
                            if ($dtNow->getTimestamp() < ($dtLastChange->getTimestamp() + ($minhours*3600)))
                            {
                                $SIEM->createSecurityEntry("signin",SECURITY_CHANGE_PW_TO_SOON,"minor",getenv("VAULT_SHELF"),"Attempt to change password too soon [{$user['iduser']}]");
                                $DB->createSecurityAudit($user,"ChangePassword attempt to change password again within {$minhours} hours User ID: {$user['iduser']}");
                                $strErr = "You cannot change a password within {$minhours} hours of your last change.";
                                $bValid = false;
                            }
                        }
                    }

                    if ($bValid)
                    {
                        //Check the strength of the password based on the organisational rules
                        $msg = Secure::strongPassword($npw,$glb['global_pw_min_length'],$glb['global_pw_num_upper'],$glb['global_pw_num_lower'],$glb['global_pw_num_numbers'],$glb['global_pw_num_nonalphanum']);
                        if (strlen($msg) == 0)
                        {
                            //Check if we need to check previous passwords

                            if ($glb['global_pw_previous'] > 0)
                            {
                                $back = min(intval($glb['global_pw_previous']),25);
                                //We have a password that matches now check that its not the same password used the last 10 times
                                $oldpasswords = $user['user_prev_hash'];
                                $oldsalts = $user['user_prev_salt'];


                                for ($oidx = 0; $oidx < $back; $oidx++)
                                {
                                    $oldhash = substr($oldpasswords,$oidx*64,64);
                                    $oldsalt = substr($oldsalts,$oidx*64,64);

                                    if (strlen($oldhash) == 64)
                                    {
                                        if ($SEC->checkPassword($npw,$oldhash,$oldsalt))
                                        {
                                            $bValid = false;
                                            $SIEM->createSecurityEntry("signin",SECURITY_CHANGE_PW_TO_PREVIOUS,"minor",getenv("VAULT_SHELF"),"Attempt to change password too previous [{$user['iduser']}]");
                                            $DB->createSecurityAudit($user,"ChangePassword attempted to change password to one used before userid {$u}");
                                            $strErr = "You cannot use a password that you have used before.";
                                        }
                                    }
                                }
                            }

                            if ($bValid)
                            {
                                //We have a password that matches
                                $salt = $SEC->createSalt();
                                $hash = $SEC->passwordHash($npw,$salt);
                                $DB->updatePassword($u,$hash,$salt,$glb['global_pw_renew_days']);

                                if (!$user['user_apikey'] || strlen($user['user_apikey'] < 16))
                                {
                                    $bDoneKey = false;
                                    while (!$bDoneKey)
                                    {
                                        $api_key = Secure::createKey(16);
                                        if (!$bDoneKey = $DB->updateUserApiKey($user['iduser'],$api_key) )
                                        {
                                            $api_key = '';
                                            if ($DB->errno != 1062)
                                                $bDoneKey = true;  // exit loop
                                        }
                                    }
                                }
                                else
                                {
                                    $api_key = $user['user_apikey'];
                                }

                                //Force them to Sign in again
                                $SIEM->createSecurityEntry("signin",SECURITY_PASSWORD_CHANGED,"information",getenv("VAULT_SHELF"),"Password changed [{$user['iduser']}]");
                                header("Location: Signin.php");
                                exit();

                            }
                        }
                        else
                        {
                            $strErr = $msg;
                        }
                    }
                }
                else
                    $strErr = "New passwords not identicle.";
            }
        }
    else
    {
        //Old password is not valid
        $strErr = "Old Password is not valid";
    }

    }
}
?>
<!DOCTYPE HTML>
<html>
<head>
    <title>CHANGE PASSWORD</title>
    <meta name="viewport" content="width=device-width" />
    <meta name="viewport" content="initial-scale=1.0" />
    <link href="css/Base.css" rel="stylesheet" />
    <style>
#main {margin: auto; margin-top: 20px; width: 600px;}
#form {margin-top: 60px; margin-bottom: 20px; margin-left: auto; margin-right: auto; width: 500px; border: solid 1px #808080; padding: 8px; border-radius: 8px;}
#form h1 {text-align: center;color: #666;font-family: 'Roboto';}
#msg {margin: auto;}
#msg p {color: #d93333; font-size: 14pt; text-align: center;}
input {height: 30px;padding-left: 10px;font-size: 14pt;}
td.td1 {font-size: 14pt;color: #a0a0a0;}
td.err {color: red; padding-top: 16px;}
    </style>
</head>
<body>
    <div id='container'>
        <div id='heading'>
            <table>
                <tr>
                    <td></td>
                    <td class='ht'>nVALUATE</td>
                    <td></td>
                </tr>
            </table>
        </div>
        <div id='main'>
            <div id='form'>
                <h1>CHANGE PASSWORD</h1>
                <div id="msg">
                    <?php
                    if (isset($_SESSION["pwchangereason1"]))
                    {
                        echo "<p>{$_SESSION["pwchangereason1"]}</p>";
                    }
                    if (isset($_SESSION["pwchangereason2"]))
                    {
                        echo "<p>{$_SESSION["pwchangereason2"]}</p>";
                    }
                    ?>
                </div>
                <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>">
                    <table>
                        <tr>
                            <td class='td1'>OLD PASSWORD</td>
                            <td>
                                <input type='password' name='oldpw' autocomplete="off" autofocus />
                            </td>
                        </tr>
                        <tr>
                            <td class='td1'>NEW PASSWORD</td>
                            <td>
                                <input type='password' name='newpw' autocomplete="off"/>
                            </td>
                        </tr>
                        <tr>
                            <td class='td1'>REPEAT PASSWORD</td>
                            <td>
                                <input type='password' name='newpw2' autocomplete="off"/>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <input type='submit' value='Change' />
                            </td>
                            <td></td>
                        </tr>
                        <?php
                        if (strlen($strErr) > 0)
                        {
                            echo "<tr><td class='err' colspan='2'>".$strErr."</td></tr>";
                        }
                        ?>
                    </table>
                    <?php echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}' />"; ?>
                </form>
            </div>
        </div>
    </div>
</body>
</html>