<?php session_start(); ?>
<?php
require './includes/classEvalSecure.php';
require './includes/classEvaluateDB.php';
require './includes/classSiem.php';

$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
$SIEM = new devt\siem\siem($devt_environment->getkey("SIEMHOST"));

$global = $DB->getGlobal();
ESecure::CheckPage(SECURITY_ADMIN);
$user = $DB->getUser($_SESSION['userid']);
ESecure::CheckUser($user);


define('CHUNK_SIZE', 1024*8192);  //Around 8Meg

function var_error_log( $object=null ,$text='')
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( "{$text} {$contents}" );        // log contents of the result of var_dump( $object )
}

function recurse_copy($src,$dst,&$manifest) {
    $dir = opendir($src);
    @mkdir($dst);
    while(false !== ( $file = readdir($dir)) ) {
        if (( $file != '.' ) && ( $file != '..' )) {
            if ( is_dir($src . '/' . $file) ) {
                recurse_copy($src . '/' . $file,$dst . '/' . $file,$manifest);
            }
            else {
                copy($src . '/' . $file,$dst . '/' . $file);
                array_push($manifest,$src . '/' . $file);
            }
        }
    }
    closedir($dir);
}

function filesInDir($dir)
{
    //Returns of all files in the directory including the directory
    $ret = array();
    $files = scandir($dir);
    foreach($files as $file)
    {
        if (is_dir("{$dir}/{$file}"))
        {
            if ($file != "." && $file != "..")
            {
                $list = filesInDir("{$dir}/{$file}");
                $ret = array_merge($ret,$list);
            }
        }
        else
        {
            array_push($ret,"{$dir}/{$file}");
        }
    }
    return $ret;
}

function delete_directory($dirname) {
         if (is_dir($dirname))
           $dir_handle = opendir($dirname);
     if (!$dir_handle)
          return false;
     while($file = readdir($dir_handle)) {
           if ($file != "." && $file != "..") {
                if (!is_dir($dirname."/".$file))
                     unlink($dirname."/".$file);
                else
                     delete_directory($dirname.'/'.$file);
           }
     }
     closedir($dir_handle);
     rmdir($dirname);
     return true;
}
//Start
$dir = $devt_environment->getkey('BACKUPDIR');
if (!$dir || strlen($dir) == 0)
{
    echo "FATAL ERROR in backup - Backup directory not set - contact support";
    error_log("nvaluate - ". __FILE__ . " FATAL ERROR in backup - Backupdir not set ");
    exit();
}

/*
   Create output directories Directories
*/


$dirscratch = $dir . "/scratch";
$dirsql = $dirscratch . "/sql";
$dirdataroom = $dirscratch . "/dataroom";

if (!is_dir($dirscratch))
   mkdir($dirscratch);

if (!is_dir($dirsql))
   mkdir($dirsql);

if (!is_dir($dirdataroom))
   mkdir($dirdataroom);

/*
   Src directories
*/

$dataroomdir = $devt_environment->getkey('DOC_STORE');

$manifest = array();

if ($_SERVER['REQUEST_METHOD'] == 'POST')
{
    if (!Secure::checkCSRF())
    {
        $SIEM->createSecurityEntry("csrf",SECUITY_INVALID_CSRF,"minor",getenv("VAULT_SHELF"),"Invalid CSRF in Backup Request");
        $DB->createSecurityAudit($user, __FILE__ ." [".__LINE__."] Failed CSRF check");
        header("Location: SecurityError.php");
        exit();
    }

    $user = $DB->getUser($_SESSION['userid']);
    if (isset($_POST['backup']))
    {
        $haveone = false;
        if (isset($_POST['db']) && $_POST['db'] == "on")
        {
            $result = $DB->Backup($user,$dirsql);
            var_error_log($result,"result");
            $manifest['database'] ['files'] = array();
            array_push($manifest['database'] ['files'],$result['file']);
            $haveone = true;
        }
        if (isset($_POST['files']) && $_POST['files'] == "on")
        {
            //Copy the dataroom files into scratch
            $manifest['dataroom'] ['files'] = array();
            recurse_copy($dataroomdir,$dirdataroom,$manifest['dataroom'] ['files']);
            $haveone = true;

        }

        if ($haveone)
        {
            $strmanifest = json_encode($manifest);
            $fman = fopen($dirscratch . '/manifest','w');
            fwrite($fman,$strmanifest,strlen($strmanifest));
            fclose($fman);

            //Create zip of all
            $dt = new DateTime();
            $dest = $dir .= "/UserBackup{$dt->format('YmdHis')}.zip";
            $zip = new ZipArchive();
            $zip->open($dest, ZipArchive::CREATE | ZipArchive::OVERWRITE);
            $files = filesInDir($dirscratch);
            foreach ($files as $file)
            {
                $name = substr($file, strlen($dirscratch) + 1);
                if (!$zip->addFile($file,$name) )
                    error_log("nvaluate::Backup.php Error adding file {$file}");
            }
            $zip->close();

            $dt = new DateTime();
            $strDownloadFileName = "Backup-{$dt->format('YmdHis')}.nvl";

            //Now we need to encrypt and send in 1024*8192 chunks
            $key = $devt_environment->getkey("BACKUPKEY");
            $encryption_key = base64_decode($key);
            $iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length('aes-256-cbc'));
            $buff = '';
            $handle = fopen($dest, "r");
            if (!$handle)
            {
                echo "FATAL ERROR in backup - Unable to create file - contact support";
                error_log("nvaluate - ". __FILE__ ." FATAL ERROR in backup - Cannot open zip");
                exit();
            }

            header('Content-type: application/nvaluate');
            header("Content-Disposition: attachment; filename={$strDownloadFileName}");

            while (!feof($handle) )
            {
                $buff = fread($handle,CHUNK_SIZE);
                $encrypted = openssl_encrypt($buff, 'aes-256-cbc', $encryption_key, 0, $iv);
                $l = intval(strlen($encrypted));
                echo sprintf("%10d",$l);
                echo $iv;
                echo $encrypted;
                ob_flush();
                flush();
            }

            //Cleanup
            delete_directory($dirscratch);

            $DB->flagUser($user['iduser'],"DOWNLOAD");
        }
        else
        {
            header('Location: Maintenance.php');
        }
    }
}
?>