<?php session_start(); ?>
<?php
require './includes/classEvalSecure.php';
require './includes/classEvaluateDB.php';
require './includes/classEvalHelpers.php';
require './includes/classFormList.php';
require './includes/classSiem.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
$SIEM = new devt\siem\siem($devt_environment->getkey("SIEMHOST"));

$selff = htmlspecialchars($_SERVER["PHP_SELF"]);
$_SESSION['returnto'] = $selff;

$helpers = new helpers();
$dbrslt = null;
$FL = new FormList(null);

$global = $DB->getGlobal();
ESecure::CheckPage(SECURITY_ADMIN);
$user = $DB->getUser($_SESSION['userid']);
ESecure::CheckUser($user);

function var_error_log( $object=null ,$text='')
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( "{$text} {$contents}" );        // log contents of the result of var_dump( $object )
}

if (isset($_GET['mode']))
{
    $_SESSION['AUDITMODE'] = intval($_GET['mode']);
    unset($_SESSION["auditevaluation"]);
    header("Location: {$selff}");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST')
{
    if (!Secure::checkCSRF())
    {
        $SIEM->createSecurityEntry("csrf",SECUITY_INVALID_CSRF,"minor",getenv("VAULT_SHELF"),"Invalid CSRF in Audit Request");
        $DB->createSecurityAudit($user,"Audits.php [".__LINE__."] Failed CSRF check");
        header("Location: SecurityError.php");
        exit();
    }

    if (isset($_POST['change']))
    {
        if (isset($_POST['selevaluation']))
        {
            $_SESSION["auditevaluation"] = intval($_POST['selevaluation']);
            header("Location: {$selff}");
            exit();
        }
    }

    if (isset($_POST['search']))
    {
        //First check that the eval is the same
        if (isset($_SESSION["auditevaluation"]))
        {
            //Process the post
            $q = 0;
            $p = 0;
            $r = 0;
            $e = 0;

            if (isset($_POST['question']))
            {
                $v = $FL->decryptParamRaw($_POST['question']);
                $q = intval($v['val']);
            }

            if (isset($_POST['phase']))
            {
                $v = $FL->decryptParamRaw($_POST['phase']);
                $p = intval($v['val']);
            }

            if (isset($_POST['respondent']))
            {
                $v = $FL->decryptParamRaw($_POST['respondent']);
                $r = intval($v['val']);
            }

            if (isset($_POST['evaluator']))
            {
                $v = $FL->decryptParamRaw($_POST['evaluator']);
                $e = intval($v['val']);
            }


            //Contruct the questy
            $qury = "select * from audit left join phase a on a.idphase = audit_phase left join respondent b on b.idrespondent = audit_respondent left join question c on c.idquestion = audit_question left join user d on d.iduser = audit_user left join subattribute e on e.idsubattribute = audit_sub where (audit_type = 'Comment' or audit_type = 'Score') and audit_evaluation = " . intval($_SESSION["auditevaluation"]);

            if ($e > 0)
                $qury .= " and audit_user = " . intval($e);

            if ($p > 0)
                $qury .= " and audit_phase = " . intval($p);

            if ($r > 0)
                $qury .= " and audit_respondent = " . intval($r);

            if ($q > 0)
                $qury .= " and audit_question = " . intval($q);

            $qury .= " order by audit_timestamp";
            $dbrslt = $DB->p_query($qury,null,null);
            if (!$dbrslt)
                error_log("Sql error: q = {$qury}");
        }
    }
}
?>
<!DOCTYPE HTML>
<html>
<head>
<meta name="viewport" content="width=device-width">
<meta name="viewport" content="initial-scale=1.0">
<title>nValuate Audit</title>
<link href="css/Base.css" rel="stylesheet">
<link href="css/devtmenu.css" rel="stylesheet">
<style>
#main {display: flex;}
#left {width: 300px;padding: 10px;background-color: #eef;border: solid 2px #ddd;}
#left h1 {font-family: 'Roboto Slab';font-size: 12pt; color: #888;border-radius: 5px;}
#drauditleft p {font-size: 10pt;padding-left: 8px;color: #633;margin-bottom: 0;}
#drauditleft p.p1 {font-size: 10pt;padding-left: 8px;color: #633;font-weight: bold;margin-bottom: 0;}
#drauditleft a {text-decoration: none;}
#drauditleft a:hover {color: #bd26b7; font-weight: bold;}
#right {width: 100%; background-color: #eee; margin-left: 10px;border: solid 2px #ddd;border-radius: 5px;padding: 10px;}
#right h1 {font-family: 'Roboto Slab';font-size: 12pt; color: #888;border-radius: 5px;}
#right h2 {font-family: 'Roboto Slab';font-size: 11pt; color: #888;border-radius: 5px;margin-left: 10px;}
#right p.pmsg {font-size: 11pt;}
#drauditleft {margin-bottom: 16px;}
#drauditright {}
#drauditright table {border-collapse: collapse;margin-left: 20px;}
#drauditright td.pad1 {height: 17px;}
#drauditright th {border-bottom: solid 1px #888;}
#drauditright th , td {padding-right: 32px;}
#drauditright td.tdhd {font-weight: bold;}
#auditscoreform {margin-left: 20px;}
#auditscoreform h3 {font-family: 'Roboto Slab';font-size: 10pt; color: #888; margin-bottom: 6px;}
#search {margin-left: 10px; padding: 10px; border: solid 1px #666;border-radius: 8px;}
#search input[type='submit'] {margin-top: 20px;}
#search p {margin-bottom: 0; font-size: 9pt;}
#auditrslts {margin-top: 16px; margin-left: 30px; padding: 10px; border: solid 1px #666;border-radius: 8px;}
#textmsgaudit td {font-size: 8pt;padding-right: 10px;}
#securityaudit td {font-size: 10pt;padding-right: 10px;}
.l {text-align: left;}
.c {text-align: center;}
.r {text-align: right;}

</style>
</head>
<body>
    <div id='container'>
        <div id='heading'>
            <table>
                <!-- <tr><td></td><td class='ht'>GWRC Files</td><td></td></tr> -->
                <tr><td></td><td class='ht'>nVALUATE Audit</td><td></td></tr>
            </table>
        </div>
        <div id='menu'>
            <div class='d1'><a href='Admin.php'>ADMIN</a></div>
            <div class='d1 sel'>AUDIT</div>
            <?php
            if (ESecure::IS_MODULE_SCORE())
                    echo "<div class='d1'><a href='Score'>SCORE</a></div>";
            ?>
            <?php
            if (ESecure::IS_MODULE_ROOM())
                echo "<div class='d1'><a href='DataRoom.php'>DATAROOM</a></div>";
            ?>
            <div class='d2'><?php if ($user) echo $user['user_name'];?></div>
            <div style='clear: left;'></div>
        </div>
        <div id='main'>
            <div id='left'>
                <?php
                echo "<div id='drauditleft'>";
                echo "<h1>USERS</h1>";
                if (isset($_SESSION['AUDITMODE']) && $_SESSION['AUDITMODE'] == 31)
                    echo "<p class='p1'>&gt; USER ACCESS</p>";
                else
                    echo "<p><a href='{$selff}?mode=31'>USER ACCESS</a></p>";
                if (ESecure::IS_MODULE_SCORE())
                {
                    echo "<h1>SCORE</h1>";
                    if (isset($_SESSION['AUDITMODE']) && $_SESSION['AUDITMODE'] == 10)
                        echo "<p class='p1'>&gt; SCORES GIVEN</p>";
                    else
                        echo "<p><a href='{$selff}?mode=10'>SCORES GIVEN</a></p>";
                }
                if (ESecure::IS_MODULE_ROOM())
                {
                    echo "<h1>DATAROOM</h1>";
                    if (isset($_SESSION['AUDITMODE']) && $_SESSION['AUDITMODE'] == 20)
                        echo "<p class='p1'>&gt; ACCESS BY DOCUMENT</p>";
                    else
                        echo "<p><a href='{$selff}?mode=20'>ACCESS BY DOCUMENT</a></p>";
                    if (isset($_SESSION['AUDITMODE']) && $_SESSION['AUDITMODE'] == 21)
                        echo "<p class='p1'>&gt; ACCESS BY USER</p>";
                    else
                        echo "<p><a href='{$selff}?mode=21'>ACCESS BY USER</a></p>";
                }
                echo "<h1>MESSAGING</h1>";
                if (isset($_SESSION['AUDITMODE']) && $_SESSION['AUDITMODE'] == 40)
                    echo "<p class='p1'>&gt; TEXT MESSAGES</p>";
                else
                    echo "<p><a href='{$selff}?mode=40'>TEXT MESSAGES</a></p>";
                echo "<h1>SECURITY</h1>";
                if (isset($_SESSION['AUDITMODE']) && $_SESSION['AUDITMODE'] == 50)
                    echo "<p class='p1'>&gt; SECURITY ISSUES</p>";
                else
                    echo "<p><a href='{$selff}?mode=50'>SECURITY ISSUES</a></p>";
                echo "</div>";
                ?>
                <button onclick="window.location='AllAudits.csv'">DOWNLOAD COMPLETE AUDIT</button>
            </div>
            <div id='right'>
                <?php
                echo "<div id='drauditright'>";
                $thismode = 0;
                if (isset($_SESSION['AUDITMODE']))
                    $thismode = $_SESSION['AUDITMODE'];
                switch ($thismode)
                {
                case 10:
                    echo "<h2>SCORE AUDIT</h2>";
                    echo "<div id='auditscoreform'>";
                        echo "<form method='post' action='{$selff}'>";
                            //Evaluation
                            $r = $DB->allEvaluations("order by evaluation_name");
                            if ($r->num_rows > 0)
                            {
                                if ($r->num_rows == 1 || isset($_SESSION["auditevaluation"]))
                                {
                                    $eval1 = null;
                                    if (isset($_SESSION["auditevaluation"]))
                                        $eval1 = $DB->getEvaluation($_SESSION["auditevaluation"]);
                                    else
                                        $eval1 = $r->fetch_array();
                                    echo "<p>EVALUATION: {$DB->displayText($eval1['evaluation_name'])}</p>";
                                    $_SESSION["auditevaluation"] = $eval1['idevaluation'];

                                    if (isset($_SESSION["auditevaluation"]))
                                    {
                                        echo "<h3>SEARCH CRITERIA</h3>";
                                        echo "<div id='search'>";
                                        echo "<p>CHOOSE A SPECIFIC EVALUATION QUESTION</p>";
                                        echo "<select name='question'>";
                                        $v = $FL->encryptParam("val=0");
                                        echo "<option value='{$v}'></option>";
                                        $r1 = $DB->allQuestionsForEval($_SESSION["auditevaluation"]);
                                        while ($q = $r1->fetch_array(MYSQLI_ASSOC))
                                        {
                                            $v = $FL->encryptParam("val={$q['idquestion']}");
                                            echo "<option value = '{$v}'>{$q['question_identifier']}</option>";
                                        }
                                        echo "</select>";

                                        echo "<p>CHOOSE A SPECIFIC PHASE</p>";
                                        echo "<select name='phase'>";
                                        $v = $FL->encryptParam("val=0");
                                        echo "<option value='{$v}'></option>";
                                        $r2 = $DB->allPhasesForEval($_SESSION["auditevaluation"]);
                                        while ($phase = $r2->fetch_array(MYSQLI_ASSOC))
                                        {
                                            $v = $FL->encryptParam("val={$phase['idphase']}");
                                            echo "<option value = '{$v}'>{$phase['phase_name']}</option>";
                                        }
                                        echo "</select>";

                                        echo "<p>CHOOSE A SPECIFIC RESPONDENT</p>";
                                        echo "<select name='respondent'>";
                                        $v = $FL->encryptParam("val=0");
                                        echo "<option value='{$v}'></option>";
                                        $r3 = $DB->allRespondentsForEval($_SESSION["auditevaluation"],"order by respondent_name_full");
                                        while ($resp = $r3->fetch_array(MYSQLI_ASSOC))
                                        {
                                            $v = $FL->encryptParam("val={$resp['idrespondent']}");
                                            echo "<option value = '{$v}'>{$resp['respondent_name_full']}</option>";
                                        }
                                        echo "</select>";

                                        echo "<p>CHOOSE A SPECIFIC EVALUATOR</p>";
                                        echo "<select name='evaluator'>";
                                        $v = $FL->encryptParam("val=0");
                                        echo "<option value='{$v}'></option>";
                                        $r4 = $DB->allUsersForEval($_SESSION["auditevaluation"]);
                                        while ($evaluator = $r4->fetch_array(MYSQLI_ASSOC))
                                        {
                                            $v = $FL->encryptParam("val={$evaluator['iduser']}");
                                            echo "<option value = '{$v}'>{$evaluator['user_name']}</option>";
                                        }
                                        echo "</select>";

                                        echo "<br/><input type='submit' name='search' value='SEARCH'/>";

                                        echo "</div>";
                                    }
                                }
                                else
                                {
                                    echo "<p>CHOOSE WHICH EVALUATION</p>";
                                    echo "<select name='selevaluation'>";
                                    while ($eval1 = $r->fetch_array(MYSQLI_ASSOC) )
                                    {
                                        echo "<option value='{$eval1['idevaluation']}'>{$DB->displayText($eval1['evaluation_name'])}</option>";
                                    }
                                    echo "</select>";
                                    echo "<br/><input type='submit' name='change' value='CHOOSE'/>";
                                }
                            }
                            else
                                echo "<p>There a no evaluations defined</p>";
                        echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}'>";
                        echo "</form>";
                    echo "</div>";
                    if ($dbrslt)
                    {
                        echo "<div id='auditrslts'>";
                        if ($dbrslt->num_rows > 0)
                        {
                            echo "<table>";
                            while ($arec = $dbrslt->fetch_array(MYSQLI_ASSOC))
                            {
                                if ($devt_audittypes[$arec['audit_type']] ['type'] == "eval")
                                {
                                    $dt = new DateTime($arec['audit_timestamp']);
                                    $dt->setTimezone(new DateTimezone($user['user_timezone']));
                                    echo "<tr>";
                                    echo "<td>{$dt->format('D jS F Y H:i')}</td>";
                                    $strTypeText = $devt_audittypes[$arec['audit_type']] ['desc'];
                                    echo "<td>{$strTypeText}</td>";
                                    //What phase
                                    echo "<td>{$DB->displayText($arec['phase_name'])}</td>";
                                    //What respondent
                                    echo "<td>{$DB->displayText($arec['respondent_name_full'])}</td>";
                                    //What question
                                    echo "<td>{$DB->displayText($arec['question_identifier'])}</td>";
                                    //Sub
                                    echo "<td>";
                                    if ($arec['audit_sub'])
                                        echo $arec['subattribute_number'];
                                    echo "<td>";

                                    //What user
                                    echo "<td>{$DB->displayText($arec['user_name'])}</td>";

                                    echo "<td>";
                                    if ($arec['audit_type'] == 'Score')
                                        echo $arec['audit_score'];
                                    echo "<td>";
                                    echo "</tr>";
                                }
                            }
                            echo "</table>";
                        }
                        else
                            echo "<p>NO RESULTS FOR SEARCH SPECIFIED</p>";
                        echo "</div>";
                    }
                    break;
                case 20:
                    echo "<h2>ACCESS BY DOCUMENT</h2>";
                    echo "<table>";
                    echo "<tr><th class='l'>DOCUMENT</th><th class='l'>TYPE</th><th class='r'>TIMESTAMP</th><th class='l'>USER</th><th>IP ADDRESS</th></tr>";
                    $current_title = '';
                    $r = $DB->allAuditByDocUser();
                    while ($audit = $r->fetch_array(MYSQLI_ASSOC))
                    {
                        if ($devt_audittypes[$audit['audit_type']] ['type'] == "dataroom")
                        {
                            $audittitle = $DB->buildDocListFullNameStr($audit['audit_doclist']);
                            $audittitle .= " [" . $audit['doclist_version'] ."]";
                            if ($current_title != $audittitle)
                            {
                                echo "<tr><td class='pad1'></td></tr>";
                                $current_title = $audittitle;
                                echo "<tr><td colspan='5' class='tdhd'>{$DB->displayText($current_title)}</td></tr>";
                            }
                            $dt = new DateTime($audit['audit_timestamp']);
                            $dt->setTimezone(new DateTimezone($user['user_timezone']));
                            $strType = $devt_audittypes[$audit['audit_type']] ['desc'];
                            echo "<tr><td></td><td>{$strType}</td><td class='r'>{$dt->format('D jS F Y H:i')}</td><td>{$DB->displayText($audit['user_name'])}</td><td>{$audit['audit_ipaddress']}</td></tr>";
                        }
                    }
                    echo "</table>";
                    break;
                case 21:
                    echo "<h2>ACCESS BY USER</h2>";
                    echo "<table>";
                    $current_user = '';
                    echo "<tr><th class='l'>USER</th><th class='l'>TYPE</th><th class='r'>TIMESTAMP</th><th class='l'>DOCUMENT</th><th>VERSION</th><th>IP ADDRESS</th></tr>";
                    $r = $DB->allUsers('order by user_name');
                    {
                        while ($seluser = $r->fetch_array(MYSQLI_ASSOC))
                        {
                            if ($current_user != $seluser['user_name'])
                            {
                                $current_user = $seluser['user_name'];
                                echo "<tr><td class='pad1'></td></tr>";
                                echo "<tr><td colspan='5' class='tdhd'>{$DB->displayText($current_user)}</td></tr>";
                            }
                            $r2 = $DB->allAuditsForUser($seluser['iduser']);
                            while ($audit = $r2->fetch_array(MYSQLI_ASSOC))
                            {
                                if ($devt_audittypes[$audit['audit_type']] ['type'] == "dataroom")
                                {
                                    $audittitle = '';
                                    $dt = new DateTime($audit['audit_timestamp']);
                                    $dt->setTimezone(new DateTimezone($user['user_timezone']));
                                    $strType = $devt_audittypes[$audit['audit_type']] ['desc'];
                                    if ($audit['audit_doclist'])
                                        $audittitle = $DB->buildDocListFullNameStr($audit['audit_doclist']);
                                    if (strlen($strType) > 0)
                                        echo "<tr><td></td><td>{$strType}</td><td class='r'>{$dt->format('D jS F Y H:i')}</td><td>{$DB->displayText($audittitle)}</td><td class='r'>{$audit['doclist_version']}</td><td>{$audit['audit_ipaddress']}</td></tr>";
                                }
                            }
                        }
                    }
                    echo "</table>";
                    break;
                case 31:
                    echo "<h2>USER ACCESS</h2>";
                    echo "<table>";
                    $current_user = '';
                    echo "<tr><th class='l'>USER</th><th class='l'>TYPE</th><th class='r'>TIMESTAMP</th><th>IP ADDRESS</th></tr>";
                    $r = $DB->allUsers('order by user_name');
                    {
                        while ($seluser = $r->fetch_array(MYSQLI_ASSOC))
                        {
                            if ($current_user != $seluser['user_name'])
                            {
                                $current_user = $seluser['user_name'];
                                echo "<tr><td class='pad1'></td></tr>";
                                echo "<tr><td colspan='5' class='tdhd'>{$DB->displayText($current_user)}</td></tr>";
                            }
                            $r2 = $DB->allAuditsForUser($seluser['iduser']);
                            while ($audit = $r2->fetch_array(MYSQLI_ASSOC))
                            {
                                if ($devt_audittypes[$audit['audit_type']] ['type'] == "user")
                                {
                                    $audittitle = '';
                                    $dt = new DateTime($audit['audit_timestamp']);
                                    $dt->setTimezone(new DateTimezone($user['user_timezone']));
                                    $strType = $devt_audittypes[$audit['audit_type']] ['desc'];
                                    if (strlen($strType) > 0)
                                        echo "<tr><td></td><td>{$strType}</td><td class='r'>{$dt->format('D jS F Y H:i')}</td><td>{$audit['audit_ipaddress']}</td></tr>";
                                }
                            }
                        }
                    }
                    echo "</table>";
                    break;
                case 40:
                    echo "<div id='textmsgaudit'>";
                    echo "<h2>TEXT MESSAGES</h2>";
                    echo "<table>";
                    echo "<tr><th class='l'>TIME SENT</th><th class='l'>USER</th><th class='l'>PHONE</th><th class='l'>STATUS</th><th class='l'>TIME RECVD</th><th class='l'>TEXT</th></tr>";
                    $r = $DB->allMessages();
                    while ($msg = $r->fetch_array(MYSQLI_ASSOC))
                    {
                        $dtsent = new DateTime($msg['message_timestamp_sent']);
                        $dtsent->setTimezone(new DateTimezone($user['user_timezone']));
                        $dtrecv = new DateTime($msg['messagec_timestamp_received']);
                        $dtrecv->setTimezone(new DateTimezone($user['user_timezone']));

                        echo "<tr>";
                            if ($msg['message_timestamp_sent'])
                                echo "<td>{$dtsent->format('D jS F Y H:i')}</td>";
                            else
                                echo "<td></td>";
                            echo "<td>{$DB->displayText($msg['user_name'])}</td>";
                            echo "<td>{$msg['message_to']}</td>";

                            echo "<td>";
                            switch ($msg['message_status'])
                            {
                            case "SENT":
                                echo "SENT";
                                break;
                            case "RECEIVED":
                                echo "SENT AND RECEIVED BY USER";
                                break;
                            default:
                                echo "{$msg['message_status']}";
                                break;
                            }
                            echo "</td>";

                            if ($msg['messagec_timestamp_received'])
                                echo "<td>{$dtrecv->format('D jS F Y H:i')}</td>";
                            else
                                echo "<td></td>";


                            echo "<td>{$DB->displayText($msg['message_text'])}</td>";
                        echo "</tr>";
                    }

                    echo "</table>";
                    echo "</div>";
                break;
                case 50:
                    echo "<div id='securityaudit'>";
                    echo "<h2>SECURITY ISSUES</h2>";
                    echo "<table>";
                    echo "<tr><th class='l'>TIMESTAMP</th><th class='l'>USER</th><th class='l'>DESCRIPTION</th><th class='l'>IPADDRESS</th></tr>";
                    $r = $DB->allSecurityAudits();
                    while ($audit = $r->fetch_array(MYSQLI_ASSOC))
                    {
                        $dtAuditTime = new DateTime($audit['audit_timestamp']);
                        $dtAuditTime->setTimezone(new DateTimezone($user['user_timezone']));
                        $strTime = $dtAuditTime->format('D jS F Y H:i');
                        $strUser = '';
                        if ($audit['iduser'] && $audit['iduser'] > 0)
                            $strUser = htmlspecialchars($audit['user_name']);
                        $d = htmlspecialchars($audit['audit_description']);
                        echo "<tr><td class='r'>{$strTime}</td><td>{$strUser}</td><td>{$d}</td><td class='r'>{$audit['audit_ipaddress']}</td></tr>";
                    }
                    echo "</table>";
                    echo "</div>";
                break;

                default:
                    break;
                }
                echo "</div>";
                ?>
            </div>
        </div>
    </div>
</body>
</html>