<?php session_start(); ?>
<?php
require './includes/classEvalSecure.php';
require './includes/classEvaluateDB.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());

function var_error_log( $object=null )
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( $contents );        // log contents of the result of var_dump( $object )
}

$selff = htmlspecialchars($_SERVER["PHP_SELF"]);
$_SESSION['returnto'] = $selff;

$global = $DB->getGlobal();
ESecure::CheckPage(SECURITY_ADMIN);
$user = $DB->getUser($_SESSION['userid']);
ESecure::CheckUser($user);

$evaluations = array();
$phases = array();
$questions = array();
$subattributes = array();
$respondents = array();

if ($user)
{
    //Header
    header('Content-type: text/csv');

    //We need to get evaluation names
    $r = $DB->allEvaluations();
    while ($eval = $r->fetch_array(MYSQLI_ASSOC))
    {
        $evaluations[$eval['idevaluation']] = $eval;
    }

    //We need to get evaluation names
    $r = $DB->allEvaluations();
    while ($eval = $r->fetch_array(MYSQLI_ASSOC))
    {
        $evaluations[$eval['idevaluation']] = $eval;
    }

    //We need to get phase names
    $r = $DB->allPhases();
    while ($phase = $r->fetch_array(MYSQLI_ASSOC))
    {
        $phases[$phase['idphase']] = $phase;
    }

    //We need to get question identifiers
    $r = $DB->allQuestions();
    while ($question = $r->fetch_array(MYSQLI_ASSOC))
    {
        $questions[$question['idquestion']] = $question;
    }

    //We need to get question identifiers
    $r = $DB->allSubAttributes();
    while ($sub = $r->fetch_array(MYSQLI_ASSOC))
    {
        $subattributes[$sub['idsubattribute']] = $sub;
    }

    //We need to get question identifiers
    $r = $DB->allRespondents();
    while ($respondent = $r->fetch_array(MYSQLI_ASSOC))
    {
        $respondents[$respondent['idrespondent']] = $respondent;
    }

    //Header row
    echo "TIMESTAMP,TYPE,DESCRIPTION,USER,EVALUATION,PHASE,RESPONDENT,QUESTION,SUB ATTRIBUTE,SCORE,COMMENT,DOCUMENT";
    echo "\r\n";

    $r = $DB->allAudits();
    while ($audit = $r->fetch_array(MYSQLI_ASSOC))
    {
        $dt = new DateTime($audit['audit_timestamp']);
        $dt->setTimezone(new DateTimeZone($_SESSION['tz']));
        $strEval = '';
        if ($audit['audit_evaluation'])
            $strEval = stripslashes($evaluations[$audit['audit_evaluation']] ['evaluation_name']);
        $strName = '';
        if ($audit['user_name'])
            $strName = stripslashes($audit['user_name']);
        $strPhaseName = '';
        if ($audit['audit_phase'])
            $strPhaseName = stripslashes($phases[$audit['audit_phase']] ['phase_name']);
        $strRepondent = '';
        if ($audit['audit_respondent'])
            $strRepondent = stripslashes($respondents[$audit['audit_respondent']] ['respondent_name_short']);
        $strQuest = '';
        if ($audit['audit_question'])
            $strQuest = stripslashes($questions[$audit['audit_question']] ['question_identifier']);
        $strSubNum = '';
        if ($audit['audit_sub'])
            $strSubNum = stripslashes($questions[$audit['audit_sub']] ['subattribute_number']);
        $strComment = '';
        if ($audit['audit_comment'] && strlen($audit['audit_comment']) > 0)
        {
            if (strlen($audit['audit_comment']) > 20)
                $strComment = stripslashes(substr($audit['audit_comment'],0,20)) . " ...";
            else
                $strComment = stripslashes($audit['audit_comment']);
        }
        $strDoc = "";
        if ($audit['audit_doclist'])
        {
            $doc = $DB->getDoc($audit['audit_doclist']);
            switch ($audit['doclist_type'])
            {
                case '0room':
                    $strDoc = "[Room] ";
                    break;
                case '1folder':
                    $strDoc = "[Folder] ";
                    break;
                case '2doc':
                    break;
                case '3link':
                    $strDoc = "[Link] ";
                    break;
                default:
                    break;
            }
            $strDoc .= stripslashes($doc['doclist_title']);
        }

        echo "{$dt->format('d/m/Y H:i:s')},\"{$audit['audit_type']}\",\"{$audit['audit_description']}\",\"{$strName}\",\"{$strEval}\",\"{$strPhaseName}\",\"{$strRepondent}\",\"{$strQuest}\",\"{$strSubNum}\",{$audit['audit_score']},\"{$strComment}\",\"{$strDoc}\"";
        echo "\r\n";
    }
    $r->close();
}
else
{
    //We should never get here there is a security error
    header("Location: SecurityError.php");
    exit();
}
?>    
