<?php session_start(); ?>
<?php
//devt.version 1.0
require './includes/classEvalSecure.php';
require './includes/classEvaluateDB.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());

function var_error_log( $object=null )
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( $contents );        // log contents of the result of var_dump( $object )
}

$selff = htmlspecialchars($_SERVER["PHP_SELF"]);
$_SESSION['returnto'] = $selff;

$global = $DB->getGlobal();
ESecure::CheckPage(SECURITY_ADMIN);
$user = $DB->getUser($_SESSION['userid']);
ESecure::CheckUser($user);

$row = null;
$evaluation = null;
$max_evaluations = intval($devt_environment->getkey("LIMIT2"));
$num_evaluations = $DB->numOfEvaluations();

if (isset($_SESSION['current_evaluation']) && $_SESSION['current_evaluation'] != 0)
{
    $evaluation = $DB->getEvaluation($_SESSION['current_evaluation']);
}
else
{
    //If we have only one evluation let set that one
    if (1 == $DB->numOfEvaluations())
    {
        $evaluation = $DB->getFirstEvaluation();
        $_SESSION['current_evaluation'] = $evaluation['idevaluation'];
    }
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta name="viewport" content="width=device-width" />
    <meta name="viewport" content="initial-scale=1.0" />
    <title>ADMINISTRATOR PAGE</title>
    <link id="myicon" rel="icon" type="image/png" href="images/Icon1.png" />
    <link href="css/Base.css" rel="stylesheet">
    <link href="css/Tasks.css" rel="stylesheet">
    <link href="css/Details.css" rel="stylesheet">
    <style>
    #mainconatiner {max-width: 1000px; margin: auto;}
    #welcome {font-family: 'Roboto'; font-size: 12pt;}
    #welcome span.spanhelp {color: #b32710;cursor: help;}
    #nvaluatesystem {border: solid 1px #888;padding: 10px;border-radius: 6px;margin-bottom: 10px;}
    #nvaluatescore {border: solid 1px #888;padding: 10px;border-radius: 6px;margin-bottom: 10px;}
    #nvaluateroom {border: solid 1px #888;padding: 10px;border-radius: 6px;margin-bottom: 10px;}
    p.boxtitle {display: inline-block;top: -20px;position: relative;background-color: #f8f8f8;width: auto;margin: 0;z-index: 10;}
    p.boxfirst {margin-top: 0;}
    </style>
</head>
<body>
  <div class="container">
    <div id='heading'>
        <table>
            <tr><td></td><td class='ht'>nVALUATE</td><td></td></tr>
        </table>
    </div>
    <div id='menu'>
        <div class='d1 sel'>ADMIN</div>
        <div class='d1'><a href="Signout.php">SIGN OUT</a></div>
        <?php
            if (ESecure::IS_MODULE_SCORE() && Secure::CheckSecurity(SECURITY_EVALUATE))
                echo "<div class='d1'><a href='Score'>SCORE</a></div>";
        ?>
        <?php 
            if (ESecure::IS_MODULE_ROOM())
                echo "<div class='d1'><a href='DataRoom.php'>DATAROOM</a></div>";
        ?>
        <div class='d2'>
            <a href='Me.php'>
                <?php if ($user) echo $user['user_name'];?>
            </a>
        </div>
        <div class='clear'></div>
    </div>
    <div id='mainconatiner'>
        <div id='main'>
            <div id='welcome'>
                <?php
                    $n = $DB->numOfEvaluations();
                    $strNumOFEvals = '';
                    $titletxt = '';
                    $r = $DB->allEvaluations('order by evaluation_name');
                    while ($eval = $r->fetch_array(MYSQLI_ASSOC))
                    {
                        if (strlen($titletxt) > 0)
                           $titletxt .= "\n"; 
                        $titletxt .= $DB->displayText($eval['evaluation_name']);
                    
                    }
                
                    if ($n > 0)
                    {
                        if ($n > 1)
                        {
                        
                            $strNumOFEvals = "<span class='spanhelp' title = '{$titletxt}'>{$n}</span> evaluations ";
                        }
                        else
                            $strNumOFEvals = "<span class='spanhelp' title = '{$titletxt}'>1</span>  evaluation ";
                    }
                    else
                        $strNumOFEvals = 'no evaluations ';
                
                ?>
                <p>Welcome as an <span class='spanhelp' title='An Administrator is a person with special privileges that can administer the evaluation process.'>administrator</span> to nValuate, the secure way to score subjective components respondents to your proposals. If you are not familiar with this tool, you can download the <a href='/documents/AdminGuide.pdf' target='_blank'>Administrators Guide</a>.</p>
                <p>You have the following modules loaded:</p>
                <ul>
                    <?php
                        if (ESecure::IS_MODULE_SCORE())
                            echo "<li>nValuate Score - A secure team based evalaution scroing system that allows you to control the evaluation process of your procurements.</li>";
                        if (ESecure::IS_MODULE_ROOM())
                            echo "<li>nValuate Room - A secure data room which give you control and auditability of access to secure documents</li>";
                    ?>
                </ul>
                <div id="nvaluatesystem">
                    <p class='boxtitle'>SYSTEM</p>
                    <p class='boxfirst'>Following is a set of functions you use to administer the system:</p>
                    <ul>
                        <?php
                        if (Secure::CheckSecurity(SECURITY_ADMIN_CONFIGURE))
                        {
                            echo "<li><a href='Settings.php'>Settings</a> to modify system settings</li>";
                        }
                        echo "<li><a href='ManageUsers.php'>Manage Users</a> to create and change settings for the people who use the system</li>";
                        ?>
                        <li>
                            <a href='Audits.php'>Audits</a> to view the system audits
                        </li>
                        <li>
                            <a href='Maintenance.php'>Maintenance</a> to perform maintenance tasks such as backup and restore
                        </li>
                    </ul>
                </div>
                <?php
                    if (ESecure::IS_MODULE_SCORE())
                    {
                        echo "<div id='nvaluatescore'>";
                            echo "<p class='boxtitle'>SCORE</p>";
                            echo "<p class='boxfirst'>Currently you have {$strNumOFEvals} configured.  From here you can:</p>";
                            echo "<ul>";
                            if (Secure::CheckSecurity(SECURITY_ADMIN_CONFIGURE))
                            {
                                if ($num_evaluations < $max_evaluations)
                                {
                                    echo "<li><a href='CreateEval.php'>Create</a> a new evaluation.</li>";
                                }
                                echo "<li><a href='Setup.php?prog=0'>Setup and change</a> the configuration of an existing evaluation.</li>";
                            }
                            echo "<li><a href='Run.php?prog=0'>Run</a> the evaluation, change status and administer a currently running evaluation.</li>";
                            echo "<li><a href='Progress.php'>Progress</a> view scoring progress.</li>";
                            echo "<li><a href='Utility.php'>Utilities</a> to migrate and manage scores between phases.</li>";
                            echo "<li><a href='ReportManager.php'>Report Manager</a> to run evaluation reports.</li>";
                            echo "<li><a href='Maintenance.php?prog=2'>Perform</a> maintenance such as backups and checks on existing evaluation.</li>";
                            echo "<li><a href='Documents1.php'>Documents</a> Administration and support documents</li>";
                            echo "</ul>";
                        echo "</div>";
                    }
                    if (ESecure::IS_MODULE_ROOM())
                    {
                        echo "<div id='nvaluateroom'>";
                            echo "<p class='boxtitle'>DATA ROOM</p>";
                            echo "<p class='boxfirst'>Options for configuration</p>";
                            echo "<ul>";
                            echo "<li><a href='RoomSettings.php'>Settings</a> Dataroom settings</li>";
                            echo "<li><a href='FileList.php'>Files</a> provides a full list of Dataroom files</li>";
                            echo "</ul>";
                        echo "</div>";
                    }
                ?>
            </div>
        </div>
    </div>
  </div>
</body>
</html>
