<?php
//devt.version 1.0
require 'classVault.php';
$global_conf = null;
$strglobalConf = "/etc/nvaluate/nvaluate.conf";
if (!$global_conf = parse_ini_file ($strglobalConf,true) )
{
    echo "Unable to process configuration from file {$strglobalConf}";
    exit(1);
}

//Get the vaultid
if (!isset($global_conf['VAULT']))
{
    echo "Missing section VAULT in file {$strglobalConf}";
    exit(1);
}

//check global parameters for hsm
if (!isset($global_conf['HSM1']))
{
    echo "Missing section HSM1 in file {$strglobalConf}";
    exit(1);
}
$vaultid = $global_conf['VAULT'] ['VAULTID'];
$keysdir = rtrim($global_conf['VAULT'] ['KEYSDIR'],"/");
$hsmparams = $global_conf['HSM1'];

$options = getopt("s:");

if (!isset($options['s']) )
{
    echo "ERROR: deleteVaultShelf must be run with -s <shelfname>";
    exit(1);
}

$strfilename = $keysdir. "/encrypted_keys";

$shelfname = $options['s'];
echo "Delete of vault shelf: {$shelfname}";

//Make backup of keys
if ($fhandel = fopen($strfilename,"r") )
{
    $dt = new DateTime();
    $strbackupname = $strfilename . "-backup-" . $dt->format('YmdHis');
    if ($fhande2 = fopen($strbackupname,"w") )
    {
        $oldkeys = fread($fhandel,filesize($strfilename));
        fwrite($fhande2,$oldkeys,strlen($oldkeys));
        fclose($fhandel);
        fclose($fhande2);
    }
    else
    {
        echo "Failed to backup old keys\n";
        exit(1);
    }
}

$vaulthsmpaarms = ["host"=>$hsmparams['HSM_HOST'],"apikey"=>$hsmparams['HSM_KEY'],"s"=>$hsmparams['HSM_SECRET']];
$vault = new devt\vault\vault($vaultid,json_encode($vaulthsmpaarms));
//$vault = new devt\vault\vault(220759,'{"host":"https://loc.nz/api/hsm/v1","apikey":"4756988295320720","s":"98ac5d60f339f3d1725d98bc5ab5782c27e286d752f08bf21d8ea522932cb49e"}');
if (!$encryptedkeys = $vault->deleteShelf($shelfname) )
{
    echo "Failed to delete shelf\n";
    exit(1);
}

if ($fhandel = fopen($strfilename,"w") )
{
    fwrite($fhandel,$encryptedkeys,strlen($encryptedkeys));
    fclose($fhandel);
}
else
{
    echo "Error could not create key file {$strfilename}\n";
    exit(1);
}
exit(0);
?>