<?php
//devt.version 1.0
require 'classVault.php';

function usage()
{
    echo "addKey Usage:\n";
    echo "  php addKey.php -i <installation name> -d <keys directory> -k <key> -v <value>\n";
    echo "  For help:\n";
    echo "  php addKey.php -h\n";
}

//Start
$options = getopt("hd:i:k:v:");
if (isset($options['h']))
{
    usage();
    exit;
}

$global_conf = null;
$strglobalConf = "/etc/nvaluate/nvaluate.conf";
if (!$global_conf = parse_ini_file ($strglobalConf,true) )
{
    echo "Unable to process configuration from file {$strglobalConf}";
    exit(1);
}

//Get the vaultid
if (!isset($global_conf['VAULT']))
{
    echo "Missing section VAULT in file {$strglobalConf}";
    exit(1);
}

//check global parameters for hsm
if (!isset($global_conf['HSM1']))
{
    echo "Missing section HSM1 in file {$strglobalConf}";
    exit(1);
}
$vaultid = $global_conf['VAULT'] ['VAULTID'];
$keysdir = rtrim($global_conf['VAULT'] ['KEYSDIR'],"/");
$hsmparams = $global_conf['HSM1'];


//Check mandatory options
if (!isset($options['i']))
{
    echo "Error: No installation name specified\n";
    echo "Run with php updateKey.php -i <installation name> -d <keys directory> -k <key> -v <value>\n"; 
    exit(1);
}

if (!isset($options['d']))
{
    echo "Error: director for keys location specified\n";
    echo "Run with php updateKey.php -i <installation name> -d <keys directory> -k <key> -v <value>\n"; 
    exit(1);
}

if (!isset($options['k']))
{
    echo "Error: no key given\n";
    echo "Run with php updateKey.php -i <installation name> -d <keys directory> -k <key> -v <value>\n"; 
    exit(1);
}

if (!isset($options['v']))
{
    echo "Error: dno value given\n";
    echo "Run with php updateKey.php -i <installation name> -d <keys directory> -k <key> -v <value>\n"; 
    exit(1);
}

//
$keysdir = $options['d'];
$keysdir = rtrim($keysdir,"/");
$strfilename = $keysdir. "/encrypted_keys";

//Make backup of keys
if ($fhandel = fopen($strfilename,"r") )
{
    $dt = new DateTime();
    $strbackupname = $strfilename . "-backup-" . $dt->format('YmdHis');
    if ($fhande2 = fopen($strbackupname,"w") )
    {
        $oldkeys = fread($fhandel,filesize($strfilename));
        fwrite($fhande2,$oldkeys,strlen($oldkeys));
        fclose($fhandel);
        fclose($fhande2);
    }
    else
    {
        echo "Failed to backup old keys\n";
        exit(1);
    }
}


$vaulthsmpaarms = ["host"=>$hsmparams['HSM_HOST'],"apikey"=>$hsmparams['HSM_KEY'],"s"=>$hsmparams['HSM_SECRET']];
$vault = new devt\vault\vault($vaultid,json_encode($vaulthsmpaarms));
$shelves = $vault->listShelves();
if ($shelves)
{
    echo "List of vault current shelves\n";
    foreach($shelves as $shelf)
    {
        echo " {$shelf}\n";
    }
}
else
    echo "No shelves in vault\n";

$installtion_name = $options['i'];
$key_name = $options['k'];
$value = $options['v'];

if (!$encryptedkeys = $vault->addKey($installtion_name,$key_name,$value) )
{
    echo "Failed to update key\n";
    exit(1);
}

echo("Added key for shelf {$installtion_name} key {$key_name} and value {$value}\n");

if ($fhandel = fopen($strfilename,"w") )
{
    fwrite($fhandel,$encryptedkeys,strlen($encryptedkeys));
    fclose($fhandel);
}
else
{
    echo "Error could not create key file {$strfilename}\n";
    exit(1);
}
 exit(0);
?>