#!/usr/bin/env php
<?php
require dirname(__FILE__) . '/classVault.php';
define('CHUNK_SIZE', 1024*8192);  //Around 8Meg

function usage()
{
	echo "RestoreBackup Usage:\n";
	echo "  php RestoreBackup.php -i <installation name> -f <inputfile> -o <output file>.tar [-k key]\n";
	echo "  For help:\n";
	echo "  php RestoreBackup.php -h\n";
}

//Start
$vault = new devt\vault\vault(220759);
$options = getopt("hi:k:f:o:");
if (isset($options['h']))
{
	usage();
	exit;
}

//Check mandatory options
if (!isset($options['i']))
{
	echo "Error: No installation name specified\n";
	echo "Run with php EncryptBackup.php -i <installation name> -f <inputfile> -o <output file>.tar\n";
	exit(1);
}

if (!isset($options['f']))
{
	echo "Error: No input file specified\n";
	echo "Run with php EncryptBackup.php -i <installation name> -f <inputfile> -o <output file>.tar\n";
	exit(1);
}

if (!isset($options['o']))
{
	echo "Error: No output file specified\n";
	echo "Run with php EncryptBackup.php -i <installation name> -f <inputfile> -o <output file>.tar \n";
	exit(1);
}

if (isset($options['k']))
	$key = $options['k'];
else
	$key = $vault->getKey($options['i'],"BACKUPKEY");
if (!$key)
{
	//We ask for the key
	echo "Key not found in vault: Please enter the backup key\n";
	$key = fgets(STDIN);
	$key = trim($key,"\n");
}
$encryption_key = base64_decode($key);

if ($fin = fopen($options['f'],"r"))
{
	$strOutName = $options['o'];

	if (strlen(pathinfo($strOutName, PATHINFO_EXTENSION)) == 0)
		$strOutName .= ".tar";

	if (!$fout = fopen($strOutName,"w"))
	{
		echo "Error: Cannot open output file\n";
		fclose($fin);
		exit(1);
	}

	while (!feof($fin) )
	{
		$buff = '';
		$l = intval(fread($fin,10));
		$iv = fread($fin,16);
		if ($l > 0)
		{
			$buff = fread($fin,$l);
			$result = openssl_decrypt($buff, 'aes-256-cbc', $encryption_key, 0, $iv);
			fwrite($fout,$result,strlen($result));
		}
	}
	fclose($fin);
	fclose($fout);
}
else
{
	echo "Error: Cannot open input file\n";
	exit(1);
}
exit(0);
?>