#!/bin/bash
#*****************************************************************************************
# Global defines
#*****************************************************************************************
RED='\033[0;31m'
GREEN='\033[0;32m'
BLUE='\033[0;34m'
CYAN='\033[0;36m'
YELLOW='\033[1;33m'
NC='\033[0m' 

INSTANCE=$1

#check run as root
if [ "$EUID" -ne 0 ]; then
  echo -e "${RED}ERROR: Please run as root with sudo${NC}" >&2
  exit 1
fi

if  [[ -z $INSTANCE ]] ; then
	echo -e "${RED}Error no instance name given${NC}"
	echo "Usage: sudo ResetAdminPassword.sh <instance name>"
	exit 1
fi

UNAME=$(mysql $INSTANCE -e "SELECT user_username a FROM user WHERE iduser=1")
UNAME=$(echo $UNAME | cut -c 3-)
PW="$(openssl rand -base64 6)"

echo -n "About to reset password for first user to ${UNAME}/${PW} for instance $INSTANCE , do you want to continue [Y/n] "
read YESNO
if [ "$YESNO" == "Y" ] ; then
	PEPPER=$(/etc/vault/getKey -s $INSTANCE -k PEPPER)
	#create the first user in the database
	SALT="$(openssl rand -hex 32)"
	H1="$(echo -n "${SALT}${PEPPER}" | openssl dgst -sha256)"
	HASH1=${H1:$((${#H1} - 64)):64}
	H1="$(echo -n "admin${HASH1}" | openssl dgst -sha256)"
	HASH=${H1:$((${#H1} - 64)):64}
	mysql $INSTANCE -e "update user set user_passwordhash = '${HASH}' , user_salt = '${SALT}', user_forcereset = 1 , user_failed_login_count = 0, user_prev_hash = '' , user_prev_salt='' where iduser=1"
	echo "Password reset for ${UNAME} to ${PW}"
fi
exit 0