<?php
/*
    This program is called once on machine startup.
    It reads the encrypted keys from the directory sepcified in the d option
    and calls the HSM to decrypt it.
    It then loads the decrypted keys into a volaitie memory onlu file.
*/
//devt.version 1.0
require "classVault.php";
$global_conf = null;
$strglobalConf = "/etc/nvaluate/nvaluate.conf";
if (!$global_conf = parse_ini_file ($strglobalConf,true) )
{
    echo "Unable to process configuration from file {$strglobalConf}";
    exit(1);
}

//Get the vaultid
if (!isset($global_conf['VAULT']))
{
    echo "Missing section VAULT in file {$strglobalConf}";
    exit(1);
}

//check global parameters for hsm
if (!isset($global_conf['HSM1']))
{
    echo "Missing section HSM1 in file {$strglobalConf}";
    exit(1);
}
$vaultid = $global_conf['VAULT'] ['VAULTID'];
$keysdir = rtrim($global_conf['VAULT'] ['KEYSDIR'],"/");
$hsmparams = $global_conf['HSM1'];

function usage()
{
    echo "LoadKeyVault Usage:\n";
    echo "  php LoadKeyVault.php";
    echo "  For help:\n";
    echo "  php LoadKeyVault.php -h\n";
}

//Start
$options = getopt("hd:");
if (isset($options['h']))
{
    usage();
    exit(0);
}

//Check mandatory options
$strfilename = $keysdir. "/encrypted_keys";

$encryptedkeys = null;
if ($fhandel = fopen($strfilename,"r") )
{
    $encryptedkeys = fread($fhandel,filesize($strfilename));
    fclose($fhandel);
}
else
{
    echo "Error could not read key file {$strfilename}\n";
    exit(1);
}


$vaulthsmpaarms = ["host"=>$hsmparams['HSM_HOST'],"apikey"=>$hsmparams['HSM_KEY'],"s"=>$hsmparams['HSM_SECRET']];
$vault = new devt\vault\vault($vaultid,json_encode($vaulthsmpaarms));
//$vault = new devt\vault\vault($vaultid,'{"host":"{$hsmparams]}","apikey":"4756988295320720","s":"98ac5d60f339f3d1725d98bc5ab5782c27e286d752f08bf21d8ea522932cb49e"}');
if (!$vault->load($encryptedkeys) )
{
    echo "Could not load vault\n";
    exit(2);
}
$shelves = $vault->listShelves();
if ($shelves)
{
    echo "List of vault current shelves\n";
    foreach($shelves as $shelf)
    {
        echo " {$shelf}\n";
    }
}
else
    echo "No shelves in vault\n";
exit(0);
?>