<?php
require dirname(__FILE__) . '/classVault.php';
define('CHUNK_SIZE', 1024*8192);  //Around 8Meg

function usage()
{
    echo "EncryptBackup Usage:\n";
    echo "  php EncryptBackup.php -i <installation name> -f <inputfile> -o <output file>\n";
    echo "  For help:\n";
    echo "  php EncryptBackup.php -h\n";
}

//Start
$vault = new devt\vault\vault(220759);
$options = getopt("hi:f:o:");
if (isset($options['h']))
{
    usage();
    exit;
}

//Check mandatory options
if (!isset($options['i']))
{
    echo "Error: No installation name specified\n";
    echo "Run with php EncryptBackup.php -i <installation name> -f <inputfile> -o <output file>\n"; 
    exit(1);
}

if (!isset($options['f']))
{
    echo "Error: No input file specified\n";
    echo "Run with php EncryptBackup.php -i <installation name> -f <inputfile> -o <output file>\n"; 
    exit(1);
}

if (!isset($options['o']))
{
    echo "Error: No output file specified\n";
    echo "Run with php EncryptBackup.php -i <installation name> -f <inputfile> -o <output file>\n"; 
    exit(1);
}

if ($fin = fopen($options['f'],"r"))
{
    if (!$fout = fopen($options['o'],"w"))
    {
        echo "Error: Cannot open output file\n";
        fclose($fin);
        exit(1);
    }
    $key = $vault->getKey($options['i'],"BACKUPKEY");
    $encryption_key = base64_decode($key);
    $iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length('aes-256-cbc'));
    
    while (!feof($fin) )
    {
        $buff = fread($fin,CHUNK_SIZE);
        $encrypted = openssl_encrypt($buff, 'aes-256-cbc', $encryption_key, 0, $iv);
        $l = intval(strlen($encrypted));
        fwrite($fout,sprintf("%10d",$l),10);
        fwrite($fout,$iv,16);
        fwrite($fout,$encrypted,$l);
    }
    fclose($fin);
    fclose($fout);
}
else
{
    echo "Error: Cannot open input file\n";
    exit(1);
}
exit(0);
?>