-- MySQL Script generated by MySQL Workbench
-- Sun May  5 16:57:38 2024
-- Model: New Model    Version: 1.0
-- MySQL Workbench Forward Engineering

SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION';

-- -----------------------------------------------------
-- Schema nVALUATE-Score
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Table `evaluation`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `evaluation` ;

CREATE TABLE IF NOT EXISTS `evaluation` (
  `idevaluation` INT NOT NULL AUTO_INCREMENT,
  `evaluation_name` VARCHAR(100) NULL,
  `evaluation_total_weightings` DOUBLE NOT NULL DEFAULT 1,
  PRIMARY KEY (`idevaluation`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `section`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `section` ;

CREATE TABLE IF NOT EXISTS `section` (
  `idsection` INT NOT NULL AUTO_INCREMENT,
  `section_evaluation` INT NULL,
  `section_order` INT NULL,
  `section_name` VARCHAR(100) NULL,
  PRIMARY KEY (`idsection`),
  INDEX `index_order` (`section_order` ASC),
  INDEX `fk_section_evaluation1_idx` (`section_evaluation` ASC),
  CONSTRAINT `fk_section_evaluation1`
    FOREIGN KEY (`section_evaluation`)
    REFERENCES `evaluation` (`idevaluation`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `question`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `question` ;

CREATE TABLE IF NOT EXISTS `question` (
  `idquestion` INT NOT NULL AUTO_INCREMENT,
  `question_evaluation` INT NULL,
  `question_order` INT NULL,
  `question_identifier` VARCHAR(10) NULL,
  `question_section` INT NULL,
  `question_type` ENUM('range', 'boolean') NULL DEFAULT 'range',
  `question_tag` VARCHAR(10) NULL,
  `question_text` VARCHAR(4000) NULL,
  `question_guide` VARCHAR(6000) NULL,
  `question_weighting` DOUBLE NOT NULL,
  PRIMARY KEY (`idquestion`),
  INDEX `fk_question_section1_idx` (`question_section` ASC),
  UNIQUE INDEX `question_number_UNIQUE` (`question_evaluation` ASC, `question_order` ASC, `question_identifier` ASC),
  CONSTRAINT `fk_question_section1`
    FOREIGN KEY (`question_section`)
    REFERENCES `section` (`idsection`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_question_evaluation1`
    FOREIGN KEY (`question_evaluation`)
    REFERENCES `evaluation` (`idevaluation`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `subattribute`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `subattribute` ;

CREATE TABLE IF NOT EXISTS `subattribute` (
  `idsubattribute` INT NOT NULL AUTO_INCREMENT,
  `subattribute_question` INT NULL,
  `subattribute_number` INT NULL,
  `subattribute_type` ENUM('range', 'boolean') NULL DEFAULT 'range',
  `subattribute_txt` VARCHAR(4000) NULL,
  `subattribute_guide` VARCHAR(4000) NULL,
  `subattribute_weighting` DOUBLE NOT NULL,
  `subattribute_rule` VARCHAR(100) NULL,
  PRIMARY KEY (`idsubattribute`),
  INDEX `fk_subattributes_question1_idx` (`subattribute_question` ASC),
  INDEX `index_question_sub` (`subattribute_question` ASC, `subattribute_number` ASC),
  CONSTRAINT `fk_subattributes_question1`
    FOREIGN KEY (`subattribute_question`)
    REFERENCES `question` (`idquestion`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `user`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `user` ;

CREATE TABLE IF NOT EXISTS `user` (
  `iduser` INT NOT NULL AUTO_INCREMENT,
  `user_deleted` TINYINT(1) NOT NULL DEFAULT 0,
  `user_name` VARCHAR(100) NOT NULL,
  `user_username` VARCHAR(128) NOT NULL,
  `user_mobilephone` VARCHAR(21) NULL,
  `user_email` VARCHAR(128) NULL,
  `user_passwordhash` VARCHAR(64) NULL,
  `user_second_factor_hash` VARCHAR(64) NULL,
  `user_second_factor_expire` DATETIME NULL,
  `user_failed_login_count` INT NULL DEFAULT 0,
  `user_salt` VARCHAR(64) NULL,
  `user_apikey` VARCHAR(64) NULL,
  `user_rand` INT NULL,
  `user_security` INT NULL,
  `user_forcereset` TINYINT(1) NULL,
  `user_timezone` VARCHAR(45) NULL,
  `user_lastlogin` DATETIME NULL,
  `user_pw_renew_date` DATETIME NULL,
  `user_pw_change_date` DATETIME NULL,
  `user_rule` VARCHAR(100) NULL,
  `user_current_phase` INT NULL,
  `user_allow_email_notification` TINYINT(1) NULL,
  `user_allow_text_notification` TINYINT(1) NULL,
  `user_prev_hash` VARCHAR(1600) NULL,
  `user_prev_salt` VARCHAR(1600) NULL,
  `user_last_heartbeat_time` DATETIME NULL,
  `user_last_hearbeat_count` INT NULL,
  `user_last_heartbeat_ipaddress` VARCHAR(45) NULL,
  `user_api_call_counter` INT NULL,
  PRIMARY KEY (`iduser`, `user_deleted`),
  UNIQUE INDEX `user_username_UNIQUE` (`user_username` ASC),
  UNIQUE INDEX `user_apikey_UNIQUE` (`user_apikey` ASC),
  UNIQUE INDEX `user_email_UNIQUE` (`user_email` ASC),
  UNIQUE INDEX `user_rand_UNIQUE` (`user_rand` ASC))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `team`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `team` ;

CREATE TABLE IF NOT EXISTS `team` (
  `idteam` INT NOT NULL AUTO_INCREMENT,
  `team_evaluation` INT NULL,
  `team_name` VARCHAR(60) NULL,
  `team_enabled` TINYINT(1) NULL DEFAULT 1,
  PRIMARY KEY (`idteam`),
  INDEX `fk_team_evaluation1_idx` (`team_evaluation` ASC),
  CONSTRAINT `fk_team_evaluation1`
    FOREIGN KEY (`team_evaluation`)
    REFERENCES `evaluation` (`idevaluation`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `team_has_user`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `team_has_user` ;

CREATE TABLE IF NOT EXISTS `team_has_user` (
  `team_idteam` INT NOT NULL,
  `user_iduser` INT NOT NULL,
  PRIMARY KEY (`team_idteam`, `user_iduser`),
  INDEX `fk_team_has_user_user1_idx` (`user_iduser` ASC),
  INDEX `fk_team_has_user_team1_idx` (`team_idteam` ASC),
  CONSTRAINT `fk_team_has_user_team1`
    FOREIGN KEY (`team_idteam`)
    REFERENCES `team` (`idteam`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_team_has_user_user1`
    FOREIGN KEY (`user_iduser`)
    REFERENCES `user` (`iduser`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `respondent`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `respondent` ;

CREATE TABLE IF NOT EXISTS `respondent` (
  `idrespondent` INT NOT NULL AUTO_INCREMENT,
  `respondent_evaluation` INT NULL,
  `respondent_name_full` VARCHAR(100) NULL,
  `respondent_name_short` VARCHAR(8) NULL,
  `respondent_colour` VARCHAR(45) NULL,
  PRIMARY KEY (`idrespondent`),
  INDEX `fk_respondent_evaluation1_idx` (`respondent_evaluation` ASC),
  CONSTRAINT `fk_respondent_evaluation1`
    FOREIGN KEY (`respondent_evaluation`)
    REFERENCES `evaluation` (`idevaluation`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `phase`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `phase` ;

CREATE TABLE IF NOT EXISTS `phase` (
  `idphase` INT NOT NULL AUTO_INCREMENT,
  `phase_evaluation` INT NULL,
  `phase_name` VARCHAR(45) NULL,
  `phase_order` INT NULL,
  `phase_single_score` TINYINT(1) NULL,
  `phase_show_weightings` TINYINT(1) NULL,
  `phase_mandatory_comments` TINYINT(1) NULL,
  `phase_rule` INT NULL,
  `phase_status` ENUM('defined','enabled','complete') NULL DEFAULT 'defined',
  `phase_is_partial` TINYINT(1) NULL DEFAULT 0,
  `phase_start_timestamp` DATETIME NULL,
  `phase_complete_timestamp` DATETIME NULL,
  `phase_populate_from_utility` TINYINT(1) NULL DEFAULT 0,
  `phase_last_populate` DATETIME NULL,
  `phase_populate_user` INT NULL,
  PRIMARY KEY (`idphase`),
  INDEX `fk_phase_evaluation1_idx` (`phase_evaluation` ASC),
  UNIQUE INDEX `unique_name` (`phase_evaluation` ASC, `phase_name` ASC),
  INDEX `index4` (`phase_evaluation` ASC, `phase_order` ASC),
  INDEX `fk_phase_user1_idx` (`phase_populate_user` ASC),
  CONSTRAINT `fk_phase_evaluation1`
    FOREIGN KEY (`phase_evaluation`)
    REFERENCES `evaluation` (`idevaluation`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_phase_user1`
    FOREIGN KEY (`phase_populate_user`)
    REFERENCES `user` (`iduser`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `score`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `score` ;

CREATE TABLE IF NOT EXISTS `score` (
  `idscore` INT NOT NULL AUTO_INCREMENT,
  `score_user` INT NOT NULL,
  `score_evaluation` INT NOT NULL,
  `score_phase` INT NOT NULL,
  `score_respondent` INT NOT NULL,
  `score_question` INT NOT NULL,
  `score_subattribute` INT NULL,
  `score_score` INT NULL,
  `score_comment` VARCHAR(16000) NULL,
  PRIMARY KEY (`idscore`, `score_user`, `score_evaluation`, `score_respondent`, `score_question`, `score_phase`),
  INDEX `fk_score_user1_idx` (`score_user` ASC),
  INDEX `fk_score_subattributes1_idx` (`score_subattribute` ASC),
  INDEX `fk_score_respondent1_idx` (`score_respondent` ASC),
  INDEX `index1` (`score_user` ASC, `score_evaluation` ASC, `score_respondent` ASC, `score_question` ASC, `score_subattribute` ASC),
  INDEX `fk_score_question1_idx` (`score_question` ASC),
  INDEX `fk_score_evaluation1_idx` (`score_evaluation` ASC),
  UNIQUE INDEX `index8` (`score_user` ASC, `score_evaluation` ASC, `score_phase` ASC, `score_respondent` ASC, `score_question` ASC, `score_subattribute` ASC),
  INDEX `fk_score_phase1_idx` (`score_phase` ASC),
  INDEX `index10` (`score_evaluation` ASC, `score_phase` ASC, `score_question` ASC, `score_subattribute` ASC),
  CONSTRAINT `fk_score_user1`
    FOREIGN KEY (`score_user`)
    REFERENCES `user` (`iduser`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_score_subattributes1`
    FOREIGN KEY (`score_subattribute`)
    REFERENCES `subattribute` (`idsubattribute`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_score_respondent1`
    FOREIGN KEY (`score_respondent`)
    REFERENCES `respondent` (`idrespondent`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_score_question1`
    FOREIGN KEY (`score_question`)
    REFERENCES `question` (`idquestion`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_score_evaluation1`
    FOREIGN KEY (`score_evaluation`)
    REFERENCES `evaluation` (`idevaluation`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_score_phase1`
    FOREIGN KEY (`score_phase`)
    REFERENCES `phase` (`idphase`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `doclist`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `doclist` ;

CREATE TABLE IF NOT EXISTS `doclist` (
  `iddoclist` INT NOT NULL AUTO_INCREMENT,
  `doclist_deleted` TINYINT(1) NULL DEFAULT 0,
  `doclist_type` ENUM('0room','1folder','2doc','3link') NULL,
  `doclist_parent` INT NULL,
  `doclist_title` VARCHAR(100) NULL,
  `doclist_version` INT NULL DEFAULT 1,
  `doclist_file` VARCHAR(256) NULL,
  `doclist_mime` VARCHAR(100) NULL,
  `doclist_description` VARCHAR(200) NULL,
  `doclist_size` INT NULL,
  `doclist_user` INT NULL,
  `doclist_timestamp` DATETIME NULL,
  `doclist_deleted_user` INT NULL,
  `doclist_deleted_timestamp` DATETIME NULL,
  `doclist_signature` VARCHAR(1024) NULL,
  PRIMARY KEY (`iddoclist`),
  INDEX `index2` (`doclist_parent` ASC, `doclist_type` ASC, `doclist_title` ASC, `doclist_version` ASC))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `audit`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `audit` ;

CREATE TABLE IF NOT EXISTS `audit` (
  `idaudit` INT NOT NULL AUTO_INCREMENT,
  `audit_type` VARCHAR(45) NULL,
  `audit_table` VARCHAR(45) NULL,
  `audit_tablekey` INT NULL,
  `audit_description` VARCHAR(256) NULL,
  `audit_user` INT NULL,
  `audit_ipaddress` VARCHAR(45) NULL,
  `audit_timestamp` DATETIME NULL,
  `audit_evaluation` INT NULL,
  `audit_phase` INT NULL,
  `audit_respondent` INT NULL,
  `audit_question` INT NULL,
  `audit_sub` INT NULL,
  `audit_score` INT NULL,
  `audit_comment` VARCHAR(16000) NULL,
  `audit_doclist` INT NULL,
  `audit_newuserid` INT NULL,
  `audit_email_status` TINYINT(1) NULL,
  `audit_email_address` VARCHAR(256) NULL,
  PRIMARY KEY (`idaudit`),
  INDEX `fk_audit_user1_idx` (`audit_user` ASC),
  INDEX `index3` (`audit_user` ASC, `audit_timestamp` ASC),
  INDEX `index4` (`audit_user` ASC, `audit_type` ASC, `audit_timestamp` ASC),
  INDEX `fk_audit_doclist1_idx` (`audit_doclist` ASC),
  CONSTRAINT `fk_audit_user1`
    FOREIGN KEY (`audit_user`)
    REFERENCES `user` (`iduser`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_audit_doclist1`
    FOREIGN KEY (`audit_doclist`)
    REFERENCES `doclist` (`iddoclist`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `team_has_question`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `team_has_question` ;

CREATE TABLE IF NOT EXISTS `team_has_question` (
  `team_idteam` INT NOT NULL,
  `question_idquestion` INT NOT NULL,
  PRIMARY KEY (`team_idteam`, `question_idquestion`),
  INDEX `fk_team_has_question_question1_idx` (`question_idquestion` ASC),
  INDEX `fk_team_has_question_team1_idx` (`team_idteam` ASC),
  CONSTRAINT `fk_team_has_question_team1`
    FOREIGN KEY (`team_idteam`)
    REFERENCES `team` (`idteam`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_team_has_question_question1`
    FOREIGN KEY (`question_idquestion`)
    REFERENCES `question` (`idquestion`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `user_has_phase`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `user_has_phase` ;

CREATE TABLE IF NOT EXISTS `user_has_phase` (
  `user_iduser` INT NOT NULL,
  `phase_idphase` INT NOT NULL,
  PRIMARY KEY (`user_iduser`, `phase_idphase`),
  INDEX `fk_user_has_phase_phase1_idx` (`phase_idphase` ASC),
  INDEX `fk_user_has_phase_user1_idx` (`user_iduser` ASC),
  CONSTRAINT `fk_user_has_phase_user1`
    FOREIGN KEY (`user_iduser`)
    REFERENCES `user` (`iduser`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_user_has_phase_phase1`
    FOREIGN KEY (`phase_idphase`)
    REFERENCES `phase` (`idphase`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `rule`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `rule` ;

CREATE TABLE IF NOT EXISTS `rule` (
  `idrule` INT NOT NULL AUTO_INCREMENT,
  `rule_evaluation` INT NOT NULL,
  `rule_name` VARCHAR(45) NULL,
  `rule_min` INT NULL,
  `rule_max` INT NULL,
  `rule_mod` INT NULL,
  `rule_code` VARCHAR(200) NULL,
  PRIMARY KEY (`idrule`, `rule_evaluation`),
  UNIQUE INDEX `rule_name_UNIQUE` (`rule_name` ASC),
  INDEX `fk_rule_evaluation1_idx` (`rule_evaluation` ASC),
  CONSTRAINT `fk_rule_evaluation1`
    FOREIGN KEY (`rule_evaluation`)
    REFERENCES `evaluation` (`idevaluation`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `user_has_doclist`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `user_has_doclist` ;

CREATE TABLE IF NOT EXISTS `user_has_doclist` (
  `user_iduser` INT NOT NULL,
  `doclist_iddoclist` INT NOT NULL,
  `doclist_permission` TINYINT(1) NULL DEFAULT 1,
  `dodclist_readonly` TINYINT(1) NULL DEFAULT 0,
  PRIMARY KEY (`user_iduser`, `doclist_iddoclist`),
  INDEX `fk_user_has_doclist_doclist1_idx` (`doclist_iddoclist` ASC),
  INDEX `fk_user_has_doclist_user1_idx` (`user_iduser` ASC),
  CONSTRAINT `fk_user_has_doclist_user1`
    FOREIGN KEY (`user_iduser`)
    REFERENCES `user` (`iduser`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_user_has_doclist_doclist1`
    FOREIGN KEY (`doclist_iddoclist`)
    REFERENCES `doclist` (`iddoclist`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `dataroom`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `dataroom` ;

CREATE TABLE IF NOT EXISTS `dataroom` (
  `dataroom_name` VARCHAR(100) NULL,
  `dataroom_two_factor` TINYINT(1) NULL DEFAULT 0,
  `dataroom_allow_all_file_types` TINYINT(1) NULL DEFAULT 0,
  `dataroom_strict_mime_check` TINYINT(1) NULL DEFAULT 1)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `global`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `global` ;

CREATE TABLE IF NOT EXISTS `global` (
  `global_title` VARCHAR(50) NULL,
  `global_app_instance` VARCHAR(32) NULL,
  `global_two_factor` TINYINT(1) NULL,
  `global_disallow_shared_comments` TINYINT(1) NULL DEFAULT 0,
  `global_max_signin_attempts` INT NULL DEFAULT 3,
  `global_mins_noactivity` INT NULL DEFAULT 30,
  `global_pw_min_length` INT NULL DEFAULT 8,
  `global_pw_num_upper` INT NULL DEFAULT 0,
  `global_pw_num_lower` INT NULL DEFAULT 0,
  `global_pw_num_numbers` INT NULL DEFAULT 0,
  `global_pw_num_nonalphanum` INT NULL DEFAULT 0,
  `global_pw_renew_days` INT NULL DEFAULT 0,
  `global_pw_previous` INT NULL DEFAULT 0,
  `global_min_time_from_last` INT NULL DEFAULT 0)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `message`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `message` ;

CREATE TABLE IF NOT EXISTS `message` (
  `idmessage` INT NOT NULL AUTO_INCREMENT,
  `message_type` VARCHAR(45) NULL,
  `message_user` INT NULL,
  `message_text` VARCHAR(1000) NULL,
  `message_sms_id` INT NULL,
  `message_status` VARCHAR(45) NULL,
  `message_timestamp_sent` DATETIME NULL,
  `messagec_timestamp_received` DATETIME NULL,
  `message_to` VARCHAR(256) NULL,
  `message_from` VARCHAR(256) NULL,
  PRIMARY KEY (`idmessage`),
  INDEX `fk_message_user1_idx` (`message_user` ASC),
  CONSTRAINT `fk_message_user1`
    FOREIGN KEY (`message_user`)
    REFERENCES `user` (`iduser`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `flag`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `flag` ;

CREATE TABLE IF NOT EXISTS `flag` (
  `idflag` INT NOT NULL AUTO_INCREMENT,
  `flag_user` INT NULL,
  `flag_timestamp` DATETIME NULL,
  `flag_type` VARCHAR(45) NULL,
  PRIMARY KEY (`idflag`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mime`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `mime` ;

CREATE TABLE IF NOT EXISTS `mime` (
  `idmime` INT NOT NULL AUTO_INCREMENT,
  `mime_name` VARCHAR(45) NULL,
  `mime_mime` VARCHAR(120) NULL,
  `mime_suffix` VARCHAR(6) NULL,
  `mime_enabled` TINYINT(1) NULL DEFAULT 0,
  PRIMARY KEY (`idmime`),
  UNIQUE INDEX `mime_mime_UNIQUE` (`mime_mime` ASC))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `rolling`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `rolling` ;

CREATE TABLE IF NOT EXISTS `rolling` (
  `idrolling` INT NOT NULL AUTO_INCREMENT,
  `rolling_entity` VARCHAR(45) NULL DEFAULT NULL,
  `rolling_entity_disabled` TINYINT NULL DEFAULT NULL,
  `rolling_modulus` INT NULL DEFAULT NULL,
  `rolling_counters` VARCHAR(500) NULL DEFAULT NULL,
  `rolling_idx` INT NULL DEFAULT NULL,
  `rolling_target` DOUBLE NULL DEFAULT NULL,
  `rolling_disable_seconds` INT NULL DEFAULT NULL,
  `rolling_disable_timestamp` DATETIME NULL DEFAULT NULL,
  PRIMARY KEY (`idrolling`),
  UNIQUE INDEX `rolling_entity_UNIQUE` (`rolling_entity` ASC))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `control`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `control` ;

CREATE TABLE IF NOT EXISTS `control` (
  `control_enabled` TINYINT(1) NULL DEFAULT 1,
  `control_purchaser_name` VARCHAR(100) NULL,
  `control_purchaser_email` VARCHAR(256) NULL,
  `control_purchaser_company` VARCHAR(100) NULL,
  `control_status` ENUM('active', 'deleted', 'suspended', 'expired', 'cancelled') NULL,
  `control_prior_status` ENUM('active', 'deleted', 'suspended', 'expired', 'cancelled') NULL,
  `control_change_timestamp` DATETIME NULL)
ENGINE = InnoDB;


SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;
