// JavaScript source code
var nreports = {
    moderationBar: function (d, container) {
        /*
         * Parameters: d is the data set for the bar
         *             container is the div elemnt on the scren space for the bar
         * Returns an object bar 
         * 
         * Object bar
         *      bar {mime: <mime>,
         *           encoding: <encoding>,
         *           data: <svl data>,
         *           title: <bar title>
         *      }
         * 
        */
        var key = Object.keys(d)[0];
        var min = d[key].min / 100.0;
        var max = d[key].max / 100.0;
        var current = d[key].u / 100.0;


        var barOptions = {
            width: 200,
            height: 50,
            backgroundColor: '#808080',
            borderColor: '#000000',
            rangeColorOrange: '#ff8000',
            rangeColorGreen: '#00c000',
            rangeColorRed: '#c00000',
            scoreBandColor: '#ffff00'
        };

        //Create a div
        var charts = devt.ge('charts');
        var c = devt.cea("canvas", charts);

        //Scale correctly
        var scale = window.devicePixelRatio;
        c.style.width = Math.floor(barOptions.width / scale) + "px";
        c.style.height = Math.floor(barOptions.height / scale) + "px";
        c.width = barOptions.width;
        c.height = barOptions.height;

        //var c = document.getElementById(divid);
        var ctx = c.getContext("2d");
        ctx.fillStyle = barOptions.backgroundColor;
        ctx.fillRect(0, 0, barOptions.width, barOptions.height);

        var range = max - min;
        var rangeColor = barOptions.rangeColorGreen;
        if (range >= g_barOrangeOffset) {
            if (range >= g_barRedOffset)
                rangeColor = barOptions.rangeColorRed;
            else
                rangeColor = barOptions.rangeColorOrange;
        }

        ctx.fillStyle = rangeColor;
        var x1 = (barOptions.width * min);
        var xw = (barOptions.width * max) - x1;
        ctx.fillRect(x1, 1, xw, barOptions.height - 2);

        ctx.fillStyle = barOptions.scoreBandColor;
        x1 = (barOptions.width * current) - 2;
        xw = 5;
        ctx.fillRect(x1, 1, xw, barOptions.height - 2);

        var bar = {};
        var str = c.toDataURL();
        bar.mime = str.substr(0, str.search(";"));
        str = str.substr(str.search(";") + 1);
        bar.encoding = str.substr(0, str.search(","));
        str = str.substr(str.search(",") + 1);
        bar.data = str;
        bar.title = key;
        
        g_allBars.bars.push(bar);
        devt.removeAllChildren(charts);
        return bar;

    },
    generatebars: function (data,divid) {
        g_allBars = {};
        g_allBars.chartname = 'userbar';
        g_allBars.formtoken = g_formtoken;
        g_allBars.chartid = 0;
        g_allBars.bars = [];

        for (var k = 0; k < data.length; k++) {
            var b = nreports.moderationBar(data[k], divid);
            g_allBars.bars.push(b);
        }
        //Now submit the lot
        eval.submitchart(g_allBars);
    },
    callreport: function (report) {
        window.location = report.graphs.goto;
    }
}