// JScript source code
var eval = {
    version: 1.0,
    api: null,
    selfurl: null,
    lineCnt: 0,
    init: function (host, api, key, isHttps) {
        this.api = new devt.apiJSON(host, api, key, isHttps, apireplies);
        this.api.apireplies = apireplies;
        this.api.parseReply = function (d) {
            if (d['meta']['status']) {
                if (this.apireplies[d['meta']['req']]) {
                    fnname = this.apireplies[d['meta']['req']];
                    window[fnname](d['data']);
                }
            }
            else {
                console.log('API Returned Error: ' + d['meta']['errorcode']);
                if (devt.def(d['meta']['action'])) {
                    switch (d.meta.action) {
                        case "apisecurity":
                            window.location = encodeURI('SecurityError.php');
                            break;
                        case "breach":
                            window.location = encodeURI('SecurityError.php');
                            break;
                        case "rolling":
                            window.location = encodeURI('SecurityError.php');
                            break;
                        case "privileges":
                            window.location = encodeURI('SecurityError.php');
                            break;
                        case "dataerror":
                            window.location = encodeURI('DataError.php');
                            break;
                        case "sessionend":
                            window.location = 'Signout.php';
                            break;
                    }
                }
                if (d['meta']['errorcode'] == 2001) {
                    window.location = 'Signout.php';
                }
            }
        }
    },
    getScores: function (evalid, phase) {
        this.api.queueReq('GET', 'getscores/' + evalid + '/' + phase + "&formtoken=" + g_formtoken_encoded, null);
    },
    heartbeat: function (n) {
        var params = {};
        params.cnt = parseInt(n);
        params.me = g_me;
        params.formtoken = g_formtoken;
        this.api.queueReq('POST', 'heartbeat', params);
    },
    updScores: function (evalid, phaseid, scores) {
        if (scores) {
            var params = scores;
            params.formtoken = g_formtoken;
            this.api.queueReq('POST', 'updscores/' + evalid + '/' + phaseid, params);
        }
    },
    updSingleScore: function (evalid, phaseid, e, r, q, s, score) {
        if (scores) {
            var c = {};
            c.evaluator = parseInt(e);
            c.respondent = parseInt(r);
            c.question = parseInt(q);
            c.sub = parseInt(s);
            c.formtoken = g_formtoken;
            if (score === undefined || score === null)
                c.score = null;
            else
                c.score = score;
            this.api.queueReq('POST', 'updsinglescore/' + evalid + '/' + phaseid, c);
        }
    },
    updSingleComment: function (evalid, phaseid, e, r, q, s, txt) {
        if (scores) {
            var c = {};
            c.evaluator = parseInt(e);
            c.respondent = parseInt(r);
            c.question = parseInt(q);
            c.sub = parseInt(s);
            c.comment = txt;
            c.formtoken = g_formtoken;
            this.api.queueReq('POST', 'updsinglecomment/' + evalid + '/' + phaseid, c);
        }
    },
    updSheet: function (d) {
        scores = d;
        var all = scores['allscores']
        var cells = document.getElementsByClassName('i1');
        for (var i = 0; i < cells.length; i++) {
            var n = cells[i];
            var r = n.getAttribute('r');
            var q = n.getAttribute('q');
            var s = n.getAttribute('s');
            if (s) {
                if (parseInt(s) != 0) {
                    if (devt.def(all['respondent'][r]['questions'][q]['subs'][s])) {
                        var sub = all['respondent'][r]['questions'][q]['subs'][s];
                        if (devt.def(sub['score']) && sub['score'] !== null)
                            cells[i].value = String(sub['score']);
                        if (devt.def(sub['rule']) && sub['rule'] && sub['rule'].length > 0)
                            sub.verify = eval.parseFunction(sub['rule']);
                    }
                }
                else {
                    if (devt.def(all['respondent'][r]['questions'][q])) {
                        var sub = all['respondent'][r]['questions'][q];
                        if (devt.def(sub['score']) && sub['score'] !== null)
                            cells[i].value = String(sub['score']);
                        if (devt.def(sub['rule']) && sub['rule'] && sub['rule'].length > 0)
                            sub.verify = eval.parseFunction(sub['rule']);
                    }
                }
            }
        }
        cells = document.getElementsByClassName('ta1');
        for (var i = 0; i < cells.length; i++) {
            var n = cells[i];
            var r = n.getAttribute('r');
            var q = n.getAttribute('q');
            var s = n.getAttribute('s');
            var p = cells[i].parentElement;
            var img = p.getElementsByTagName('img')[0];
            if (s) {
                if (parseInt(s) != 0) {
                    if (devt.def(all['respondent'][r]['questions'][q]['subs'][s])) {
                        var sub = all['respondent'][r]['questions'][q]['subs'][s];
                        if (devt.def(sub['comment']) && sub['comment'] && sub['comment'].length > 0) {
                            cells[i].innerHTML = sub['comment'];
                            img.src = "/images/Right2.png";
                        }
                    }
                }
                else {
                    if (devt.def(all['respondent'][r]['questions'][q])) {
                        var sub = all['respondent'][r]['questions'][q];
                        if (devt.def(sub['comment']) && sub['comment'] && sub['comment'].length > 0) {
                            cells[i].innerHTML = sub['comment'];
                            img.src = "/images/Right2.png";
                        }
                    }
                }
            }
        }
        eval.updateProgress();
        eval.setSyncStatus(1);
        localstore[evalid][phase][frednum1] = scores;
        localStorage.setItem("evaluatelocal", JSON.stringify(localstore));
    },
    singlescoreRslt: function (p) {
        if (scores) {
            var cells = document.getElementsByClassName('i1');
            for (var i = 0; i < cells.length; i++) {
                var n = cells[i];
                var r = n.getAttribute('r');
                var q = n.getAttribute('q');
                var s = n.getAttribute('s');
                var sub = 0;
                if (p['sub'])
                    sub = parseInt(p['sub']);
                if (parseInt(r) == p['respondent'] && parseInt(q) == p['question'] && parseInt(s) == sub) {
                    devt.sa(n, 'pending', 0);
                    if (!devt.def(n.verror) || !n.verror)
                        n.style.backgroundColor = "";
                }
            }
            var alls = scores.allscores;
            var res = alls.respondent[parseInt(p['respondent'])];
            if (p['sub'])
                item = res.questions[parseInt(p['question'])]['subs'][parseInt(p['sub'])];
            else
                item = res.questions[parseInt(p['question'])];
            item['pending'] = 0;
            eval.setSyncStatus(1);
        }
    },
    singlecommentRslt: function (p) {
        if (scores) {
            var cells = document.getElementsByClassName('ta1');
            for (var i = 0; i < cells.length; i++) {
                var n = cells[i];
                var r = n.getAttribute('r');
                var q = n.getAttribute('q');
                var s = n.getAttribute('s');
                var sub = 0;
                if (p['sub'])
                    sub = parseInt(p['sub']);
                if (parseInt(r) == p['respondent'] && parseInt(q) == p['question'] && parseInt(s) == sub) {
                    devt.sa(n, 'pending', 0);
                    if (!devt.def(n.verror) || !n.verror)
                        n.style.backgroundColor = "";
                }
            }
            eval.setSyncStatus(1);
        }
    },
    newData: function (n) {
        if (scores) {
            var alls = scores.allscores;
            var s = n.data;
            var r = parseInt(n.getAttribute('r'));
            var q = parseInt(n.getAttribute('q'));
            var s = parseInt(n.getAttribute('s'));
            var ctype = n.getAttribute('t');
            var res = alls.respondent[r];
            var item;
            if (s != 0)
                item = res.questions[q]['subs'][s];
            else
                item = res.questions[q];


            if (n.value.length == 0) {
                item['score'] = null;
                item['pending'] = 1;
                n.verror = false;
                n.style.backgroundColor = "";
                devt.sa(n, 'pending', 1);
                n.style.backgroundColor = "#fff092";
                eval.setSyncStatus(0);
                g_pulse = 0;
                eval.updSingleScore(evalid, phase, scores['evaluator'], r, q, s, null);
                eval.updateProgress();
                return;
            }

            var bvalid = true;
            var v;
            if (ctype == 'r') {
                v = parseInt(n.value);
                if (isNaN(n.value))
                    bvalid = false;
                else {
                    //Priority of checking the validity
                    //1. User setting
                    //2. Sub Attribute setting
                    //3. Global setting

                    if (devt.def(item['verify']))
                        bvalid = item.verify(v);
                    else
                        if (devt.verify)
                            bvalid = devt.verify(v);
                }
            }
            if (ctype == 'b') {
                v = n.value;
                v = v.trim();
                v = v.toUpperCase();
                //Check that it is either YES or NO
                if (v != "YES" && v != "NO")
                    bvalid = false;
            }
            
            if (!bvalid) {
                n.select();
                n.style.backgroundColor = "red";
                n.title = 'Invalid Value';
                n.verror = true;
                item['score'] = null;
                item['pending'] = 1;
                eval.setSyncStatus(0);
                g_pulse = 0;
                eval.updSingleScore(evalid, phase, scores['evaluator'], r, q, s, null);
                eval.updateProgress();
            }
            else {
                n.style.backgroundColor = "";
                n.title = '';
                n.verror = false;
                item['score'] = v;
                item['pending'] = 1;
                n.value = v;
                devt.sa(n, 'pending', 1);
                n.style.backgroundColor = "#fff092";
                eval.setSyncStatus(0);
                g_pulse = 0;
                eval.updSingleScore(evalid, phase, scores['evaluator'], r, q, s, v);
                eval.updateProgress();
            }

            if (devt.def(n.textchange) && n.textchange != 0)
                n.textchange = 0;

            localstore[evalid][phase][frednum1] = scores;
            localStorage.setItem("evaluatelocal", JSON.stringify(localstore));
        }
    },
    newComment: function (n) {
        if (scores) {
            var alls = scores.allscores;
            var r = parseInt(n.getAttribute('r'));
            var q = parseInt(n.getAttribute('q'));
            var s = parseInt(n.getAttribute('s'));
            var p = n.parentElement;
            var img = p.getElementsByTagName('img')[0];

            var txt = n.value;
            var res = alls.respondent[r];
            var item;
            if (s != 0)
                item = res.questions[q]['subs'][s];
            else
                item = res.questions[q];

            item['comment'] = txt;
            if (txt.length > 0)
                img.src = "images/Left2.png";
            else
                img.src = "images/Left.png";

            devt.sa(n, 'pending', 1);
            n.style.backgroundColor = "#fff092";
            eval.setSyncStatus(0);

            g_pulse = 0;
            eval.updSingleComment(evalid, phase, scores['evaluator'], r, q, s, txt);

            if (devt.def(n.textchange) && n.textchange != 0)
                n.textchange = 0;

            localstore[evalid][phase][frednum1] = scores;
            localStorage.setItem("evaluatelocal", JSON.stringify(localstore));

        }
    },
    textChange: function (n) {
        if (scores) {
            if (!devt.def(n.textchange)) {
                n.textchange = 1;
            }
            else {
                if (n.textchange == 0) {
                    n.textchange = 1;
                }
            }
        }
    },
    checkScores: function () {
        var cells = document.getElementsByClassName('i1');
        for (var i = 0; i < cells.length; i++) {
            if (devt.def(cells[i].textchange) && cells[i].textchange != 0) {
                if (scores) {
                    var alls = scores.allscores;
                    var n = cells[i];
                    var r = parseInt(n.getAttribute('r'));
                    var q = parseInt(n.getAttribute('q'));
                    var s = parseInt(n.getAttribute('s'));
                    var txt = n.value;
                    var res = alls.respondent[r];
                    var item;
                    if (s != 0)
                        item = res.questions[q]['subs'][s];
                    else
                        item = res.questions[q];

                    if (n.value.length == 0) {
                        item['score'] = null;
                        n.verror = false;
                        g_pulse = 0;
                        eval.updSingleScore(evalid, phase, scores['evaluator'], r, q, s, null);
                        cells[i].textchange = 0;
                        return;
                    }
                    var v = parseInt(n.value);

                    var bvalid = true;
                    if (isNaN(n.value))
                        bvalid = false;
                    else {
                        if (devt.def(item['verify']))
                            bvalid = item.verify(v);
                        else
                            if (devt.verify)
                                bvalid = devt.verify(v);
                    }
                    if (bvalid) {
                        n.verror = false;
                        item['score'] = v;
                        g_pulse = 0;
                        eval.updSingleScore(evalid, phase, scores['evaluator'], r, q, s, v);
                    }
                    cells[i].textchange = 0;
                }
            }
        }
    },
    checkComments: function () {
        var cells = document.getElementsByClassName('ta1');
        for (var i = 0; i < cells.length; i++) {
            if (devt.def(cells[i].textchange) && cells[i].textchange != 0) {
                if (scores) {
                    var alls = scores.allscores;
                    var n = cells[i];
                    var r = parseInt(n.getAttribute('r'));
                    var q = parseInt(n.getAttribute('q'));
                    var s = parseInt(n.getAttribute('s'));
                    var txt = n.value;
                    var res = alls.respondent[r];
                    var item;
                    if (s != 0)
                        item = res.questions[q]['subs'][s];
                    else
                        item = res.questions[q];
                    item['comment'] = txt;
                    g_pulse = 0;
                    eval.updSingleComment(evalid, phase, scores['evaluator'], r, q, s, txt);
                    cells[i].textchange = 0;
                }
            }
        }
    },
    recoverNonSync: function () {
        //Returns 1 if all cells are synced.
        var cells = document.getElementsByClassName('i1');
        for (var i = 0; i < cells.length; i++) {
            var v = cells[i].getAttribute('pending');
            if (parseInt(v) == 1) {
                eval.newData(cells[i]);
            }
        }
    },
    initLocalStore: function () {
        var s = localStorage.getItem("evaluatelocal");
        if (s) {
            localstore = JSON.parse(s);
            if (localstore[evalid]) {
                if (localstore[evalid][phase]) {
                    if (!localstore[evalid][phase][frednum1])
                        localstore[evalid][phase][frednum1] = {};
                }
                else {
                    localstore[evalid][phase] = [];
                    localstore[evalid][phase][frednum1] = {};
                }

            }
            else {
                localstore[evalid] = [];
                localstore[evalid][phase] = [];
                localstore[evalid][phase][frednum1] = {};
            }
        }
        else {
            localstore = [];
            localstore[evalid] = [];
            localstore[evalid][phase] = [];
            localstore[evalid][phase][frednum1] = {};
        }
    },
    setSessionVariable: function (n, v) {
        var c = {};
        c['name'] = n;
        c['value'] = v;
        c.formtoken = g_formtoken;
        this.api.queueReq('POST', 'setvariable', c);
    },
    getProgress: function (evalid, phaseid) {
        if (phaseid > 0)
            this.api.queueReq('GET', 'getprogress/' + evalid + '/' + phaseid + "&formtoken=" + g_formtoken_encoded, null);
    },
    getAllDocs: function (evalid, phase) {
        this.api.queueReq('GET', 'alldocs' + "&formtoken=" + g_formtoken_encoded, null);
    },
    renameDoc: function (docid, newname) {
        var c = {};
        c['docid'] = docid;
        c['newname'] = newname;
        c.formtoken = g_formtoken;
        this.api.queueReq('POST', 'changefilename', c);
    },
    deletedoc: function (docid) {
        var c = {};
        c['docid'] = docid;
        c.formtoken = g_formtoken;
        this.api.queueReq('POST', 'deletefile', c);
    },
    undeletedoc: function (docid) {
        var c = {};
        c['docid'] = docid;
        c.formtoken = g_formtoken;
        this.api.queueReq('POST', 'undeletefile', c);
    },
    signalcheck: function (sigtype) {
        this.api.queueReq('GET', 'checksignal/' + sigtype + "&formtoken=" + g_formtoken_encoded, null);
    },
    signaldelete: function (sigtype) {
        this.api.queueReq('GET', 'deletesignal/' + sigtype + "&formtoken=" + g_formtoken_encoded, null);
    },
    submitchart: function (params) {
        this.api.queueReq('POST', 'submitchart', params);
    },
    gosomewhere: function (querystring) {
        window.location = this.selfurl + '?v=' + querystring;
    },
    createEvaluator: function () {
        window.location = this.selfurl + '?en=3';
    },
    changeProgress: function (v) {
        window.location = this.selfurl + '?prog=' + v;
    },
    changePhase: function (n) {
        window.location.href = 'SetPhase.php?p=' + n.value;
    },
    fileCheck: function (n, what) {
        var s = n.value;
        if (s.length > 0 && devt.def(what) && what.length > 0)
            devt.ge(what).disabled = false;
    },
    parseFunction: function (f) {
        var str = 'function fx(v) = {return (' + f + ');}';
        var fn_body_idx = str.indexOf('{'),
            fn_body = str.substring(fn_body_idx + 1, str.lastIndexOf('}')),
            fn_declare = str.substring(0, fn_body_idx),
            fn_params = fn_declare.substring(fn_declare.indexOf('(') + 1, fn_declare.lastIndexOf(')')),
            args = fn_params.split(',');
        args.push(fn_body);
        function Fn() {
            return Function.apply(this, args);
        }
        Fn.prototype = Function.prototype;
        return new Fn();
    },
    cursorWait: function (n) {
        document.getElementsByTagName('BODY')[0].style.cursor = 'wait';
        if (devt.def(n))
            n.style.cursor = 'wait';
    },
    drop: function (n, v) {
        var c = n.children;
        for (var i = 0; i < c.length; i++) {
            if (c[i].getAttribute('drop') == '1') {
                c[i].style.display = (v == 0 ? 'none' : 'block');
            }
        }
    },
    dropmenu: function (n, x) {
        var d = n.childNodes;
        if (x) {
            for (var i = 0; i < d.length; i++) {
                d[i].style.display = 'block';
            }
        }
        else {
            for (var i = 0; i < d.length; i++) {
                if (i != 0)
                    d[i].style.display = 'none';
            }
        }
    },
    addEvaluatorLine: function () {
        if (this.maxevaluators == 0 || (this.numevaluators + this.lineCnt) < this.maxevaluators) {
            var tbl = document.getElementById('tblnames');
            var tr = document.createElement('TR');

            var td = document.createElement('TD');
            var ip = document.createElement('INPUT');
            ip.setAttribute('name', 'fullname[]');
            ip.setAttribute('type', 'text');
            ip.setAttribute('size', '30');
            ip.setAttribute('line', this.lineCnt);
            td.appendChild(ip);
            tr.appendChild(td);

            td = document.createElement('TD');
            ip = document.createElement('INPUT');
            ip.setAttribute('name', 'username[]');
            ip.setAttribute('type', 'text');
            ip.setAttribute('size', '35');
            ip.setAttribute('line', this.lineCnt);
            ip.setAttribute('onchange', 'eval.checkEvaluatorsLine(this)');
            td.appendChild(ip);
            tr.appendChild(td);

            for (var i = 0; i < phases.length; i++) {
                td = document.createElement('TD');
                td.className = 'c';
                ip = document.createElement('INPUT');
                ip.setAttribute('name', 'phase[]');
                ip.setAttribute('value', devt.pad(this.lineCnt, 3) + phases[i]['id']);
                ip.setAttribute('type', 'checkbox');
                td.appendChild(ip);
                tr.appendChild(td);
            }


            tbl.appendChild(tr);
            this.lineCnt++;
        }
    },
    checkEvaluatorsLine: function (n) {
        var l = parseInt(n.getAttribute('line'));
        if ((l + 2) >= this.lineCnt)
            this.addEvaluatorLine();
    },
    setCurrentAction: function () {
        //Set what is displayed
        var d = this.dispfromprog[thispage][progress]['parent'];
        var d2 = this.dispfromprog[thispage][progress][subprogress];
        var lst = document.getElementsByClassName('righty');
        var b = false;
        for (var i = 0; i < lst.length; i++) {
            lst[i].style.display = 'none';
            if (lst[i].id == d) {
                lst[i].style.display = 'block';
                b = true;
            }
        }
        //Subs
        lst = document.getElementsByClassName('sub');
        for (var i = 0; i < lst.length; i++) {
            lst[i].style.display = 'none';
            if (lst[i].id == d2) {
                lst[i].style.display = 'block';
            }
        }

        if (b)
            devt.ge('details').style.display = 'flex';
        else
            devt.ge('details').style.display = 'none';

        lst = document.getElementsByClassName('progger');
        for (var i = 0; i < lst.length; i++) {
            devt.removeAllChildren(lst[i]);
            if (parseInt(lst[i].getAttribute('prog')) == progress) {
                var im = devt.cea('IMG', lst[i]);
                im.src = 'images/MarkRt.png';
            }
        }
        lst = document.getElementsByClassName('anchor');
        for (var i = 0; i < lst.length; i++) {
            if (parseInt(lst[i].getAttribute('prog')) == progress) {
                lst[i].style.fontWeight = 'bold';
            }
            else
                lst[i].style.fontWeight = 'normal';
        }
    },
    questionexpand: function (n) {
        var p = n.parentElement;
        //Remove any divs
        var l = p.getElementsByTagName("div");
        for (var i = 0; i < l.length; i++)
            p.removeChild(l[i]);
        if (n.devt_expanded) {
            n.src = "/images/Expand3.png";
            n.devt_expanded = false;
        }
        else {
            var d = devt.cea("div", p);
            d.className = "qdiv1";
            var qtext = devt.ga(n, "qtext");
            var guidetxt = devt.ga(n, "qguide");
            var ctxt = '';
            if (qtext.length > 0 && qtext.substr(0, 1) != "<")
                qtext = "<p>" + qtext + "</p>";
            if (guidetxt.length > 0 && guidetxt.substr(0, 1) != "<")
                guidetxt = "<p>" + guidetxt + "</p>";
            if (qtext.length > 0) {
                ctxt = "<p class='pcrhd'>QUESTION</p>";
                ctxt += qtext;
            }
            if (guidetxt.length > 0) {
                ctxt += "<p class='pgdhd'>GUIDANCE</p>";
                ctxt += guidetxt;
            }
            d.innerHTML = ctxt;
            n.src = "/images/Collapse3.png";
            n.devt_expanded = true;
        }
    },
    subexpand: function (n) {
        var p = n.parentElement;
        var l = p.getElementsByTagName("div");
        for (var i = 0; i < l.length; i++)
            p.removeChild(l[i]);
        if (n.devt_expanded) {
            n.src = "/images/Expand3.png";
            n.devt_expanded = false;
        }
        else {
            var d = devt.cea("div", p);
            d.className = "qdiv1";
            var qtext = devt.ga(n, "qtext");
            var guidetxt = devt.ga(n, "qguide");
            var ctxt = '';
            if (qtext.length > 0 && qtext.substr(0, 1) != "<")
                qtext = "<p>" + qtext + "</p>";
            if (guidetxt.length > 0 && guidetxt.substr(0, 1) != "<")
                guidetxt = "<p>" + guidetxt + "</p>";
            if (qtext.length > 0) {
                ctxt = "<p class='pcrhd'>CRITERIA</p>";
                ctxt += qtext;
            }
            if (guidetxt.length > 0) {
                ctxt += "<p class='pgdhd'>GUIDANCE</p>";
                ctxt += guidetxt;
            }
            d.innerHTML = ctxt;
            n.src = "/images/Collapse3.png";
            n.devt_expanded = true;
        }
    },
    expandAll: function () {
        let l = document.getElementsByClassName('qe');
        for (var i = 0; i < l.length; i++) {
            if (!devt.def(l[i].devt_expanded) || !l[i].devt_expanded)
                eval.questionexpand(l[i]);
        }
        l = document.getElementsByClassName('se');
        for (var i = 0; i < l.length; i++) {
            if (!devt.def(l[i].devt_expanded) || !l[i].devt_expanded)
                eval.subexpand(l[i]);
        }
        l = document.getElementsByClassName('ce');
        for (var i = 0; i < l.length; i++) {
            if (!devt.def(l[i].devt_expanded) || !l[i].devt_expanded)
                eval.expand(l[i]);
        }
        l = document.getElementsByClassName('me');
        for (var i = 0; i < l.length; i++) {
            if (!devt.def(l[i].devt_expanded) || !l[i].devt_expanded)
                eval.moderationexpand(l[i]);
        }
    },
    collapseAll: function () {
        let l = document.getElementsByClassName('qe');
        for (var i = 0; i < l.length; i++) {
            if (devt.def(l[i].devt_expanded) && l[i].devt_expanded)
                eval.questionexpand(l[i]);
        }
        l = document.getElementsByClassName('se');
        for (var i = 0; i < l.length; i++) {
            if (devt.def(l[i].devt_expanded) && l[i].devt_expanded)
                eval.subexpand(l[i]);
        }
        l = document.getElementsByClassName('ce');
        for (var i = 0; i < l.length; i++) {
            if (devt.def(l[i].devt_expanded) && l[i].devt_expanded)
                eval.expand(l[i]);
        }
        l = document.getElementsByClassName('me');
        for (var i = 0; i < l.length; i++) {
            if (devt.def(l[i].devt_expanded) && l[i].devt_expanded)
                eval.moderationexpand(l[i]);
        }
    },
    expandCollapse: function(n) {
        if (devt.def(n.expanded) && n.expanded) {
            eval.collapseAll();
            n.src = "/images/Expand4.png";
            n.setAttribute('title', "EXPAND ALL");
            n.expanded = false;
        }
        else {
            eval.expandAll();
            n.src = "/images/Collapse4.png";
            n.setAttribute('title', "COLLAPSE ALL");
            n.expanded = true;
        }
    },
    toggle: function (v) {
        var n = devt.ge('box' + v);
        if (n.style.display == 'block')
            n.style.display = 'none';
        else
            n.style.display = 'block';
    },
    moderationaid: function (phase, team) {
        window.location = 'ModerationAid.csv?phase=' + phase + '&team=' + team;
    },
    getBackup: function () {
        window.location = 'Backup.bak';
    },
    checkCellSync: function () {
        //Returns 1 if all cells are synced.
        var cells = document.getElementsByClassName('i1');
        for (var i = 0; i < cells.length; i++) {
            var v = cells[i].getAttribute('pending');
            if (parseInt(v) == 1)
                return 0;
        }
        return 1;
    },
    setSyncStatus: function (s) {
        var ss = s;

        if (ss == 1) {
            ss = eval.checkCellSync();
        }
        n = devt.ge('sync');
        if (ss == 0) {
            n.innerHTML = 'Not In Sync';
            n.style.color = 'red';
        }
        if (ss == 1) {
            n.innerHTML = 'In Sync';
            n.style.color = '#1bdc1b';
        }
    },
    updateProgress: function () {
        if (scores) {
            var cnt = 0;
            var all = scores['allscores'];
            var cells = document.getElementsByClassName('i1');
            var haveerror = false;
            for (var i = 0; i < cells.length; i++) {
                //Is cell in error
                var c = cells[i];
                var err = false;
                if (devt.def(c.verror) && c.verror) {
                    err = true;
                    haveerror = true;
                }
                if (c.value.length > 0 && !err) {
                    cnt++;
                }
            }
            if (cells.length > 0) {
                var prog = devt.ge('progress');
                var strtext = parseInt((cnt / cells.length) * 100.0) + "%";
                if (haveerror)
                    strtext += " ERRORS";
                prog.innerHTML = strtext;
                if (haveerror)
                    prog.style.color = "red";
                else
                    prog.style.color = "";
            }
        }
    },
    expand: function (n) {
        var state = parseInt(n.getAttribute('expand'));
        var p = n.parentElement;
        var ta = p.firstChild;
        var havedata = false;
        if (ta.value.length > 0)
            havedata = true;
        if (state == 0) {
            ta.style.display = 'inline-block';
            ta.focus();
            if (havedata)
                n.src = 'images/Left2.png';
            else
                n.src = 'images/Left.png';
            n.setAttribute('expand', '1');
            n.devt_expanded = true;
        }
        else {
            ta.style.display = 'none';
            if (havedata)
                n.src = 'images/Right2.png';
            else
                n.src = 'images/Right.png';
            n.setAttribute('expand', '0');
            n.devt_expanded = false;
        }
    },
    moderationexpand: function(n) {
        var state = parseInt(n.getAttribute('expand'));
        var key = parseInt(n.getAttribute('_key'));
        var p = n.parentElement;   //TD
        var pp = p.parentElement;  //tr
        var tr1 = pp.nextElementSibling;
        var tr2 = tr1.nextElementSibling;

        if (state == 0) {
            n.setAttribute('expand', '1');
            n.devt_expanded = true;
            n.src = "/images/Collapse3.png";
            var l = tr1.getElementsByTagName("P");
            for (var i = 0; i < l.length; i++) {
                if (parseInt(l[i].getAttribute('_key')) == key)
                    l[i].style.display = 'block';
            }
            var l = tr2.getElementsByTagName("TEXTAREA");
            for (var i = 0; i < l.length; i++) {
                if (parseInt(l[i].getAttribute('_key')) == key)
                    l[i].style.display = 'block';
            }
            //Now find all the elements of type img with the same key
            var l = document.getElementsByTagName("IMG");
            for (var i = 0; i < l.length; i++) {
                if (parseInt(l[i].getAttribute('_key')) == key) {
                    var s = parseInt(l[i].getAttribute('expand'));
                    if (s == 0)
                        eval.expand(l[i]);
                }
            }
        }
        else {
            n.setAttribute('expand', '0');
            n.devt_expanded = false;
            n.src = "/images/Expand3.png";
            var l = tr1.getElementsByTagName("P");
            for (var i = 0; i < l.length; i++) {
                if (parseInt(l[i].getAttribute('_key')) == key)
                    l[i].style.display = 'none';
            }
            var l = tr2.getElementsByTagName("TEXTAREA");
            for (var i = 0; i < l.length; i++) {
                if (parseInt(l[i].getAttribute('_key')) == key)
                    l[i].style.display = 'none';
            }
        }
    },
    midtextresize: function(n) {
        console.log(n.style.width);
        n.style.margin = 0;
        var key = parseInt(n.getAttribute('_key'));
        var l = document.getElementsByTagName("TEXTAREA");
        for (var i = 0; i < l.length; i++) {
            if (parseInt(l[i].getAttribute('_key')) == key) {
                l[i].style.width = n.style.width;
                l[i].style.margin = 0;
            }
        }
    },
    //*********************************************************************************************************
    //Charts
    //*********************************************************************************************************
    drawTeam: function (team, phase) {
        if (google) {
            //Check that we have the div for the phase and team
            var graphdiv = document.getElementById("P" + phase + "T" + team['id']);
            if (graphdiv) {

                var d = [];
                var totalscores = parseFloat(team['totals']['totscoresperevaluator']);
                var percentComplete = 0.0;
                if (parseInt(team['totals']['totscores']) > 0)
                    percentComplete = parseInt(team['totals']['totanswered'] / team['totals']['totscores'] * 1000.0);
                percentComplete = parseFloat(percentComplete) / 10.0;

                var users = team['users'];
                d[0] = ['Evaluator', 'Percentage Scored'];
                if (users.length > 0) {
                    for (var u = 0; u < users.length; u++) {
                        var user = users[u];
                        d[u + 1] = [user['name'], parseFloat(user['scored']) / totalscores];
                    }
                }
                else {
                    d[1] = ['NO EVALUATORS SET', 0.0];
                }
                var data = new google.visualization.arrayToDataTable(d);
                var options = {
                    backgroundColor: '#f8f8f8',
                    title: 'Progress for ' + team['name'] + ' [' + percentComplete + '%]',
                    titleTextStyle: { color: '#9e1780' },
                    width: 700,
                    chartArea: { left: 150 },
                    legend: { position: 'none' },
                    hAxis: { title: 'Percent Complete', titleTextStyle: { color: '#000080' }, minValue: 0, maxValue: 1, format: 'percent', viewWindow: { min: 0, max: 1 }, baselineColor: '#808080' },
                    vAxis: { textStyle: { color: '#9e3d17' }, baselineColor: '#808080', gridlines: { color: '#c0c0c0' } },
                    bars: 'horizontal', // Required for Material Bar Charts.
                };
                var chart = new google.visualization.BarChart(graphdiv);
                chart.draw(data, options);
            }
        }
    },
    drawUsers: function (users, phase) {
        if (google) {
            var graphdiv = document.getElementById('EP' + phase);
            if (graphdiv) {
                var d = [];
                d[0] = ['Evaluator', 'Percentage Scored'];
                if (users.length > 0) {
                    for (var u = 0; u < users.length; u++) {
                        var user = users[u];
                        d[u + 1] = [user['name'], parseFloat(user['scored']) / parseFloat(user['totalscores'])];
                    }
                }
                else {
                    d[1] = ['NO EVALUATORS SET', 0.0];
                }
                var data = new google.visualization.arrayToDataTable(d);
                var options = {
                    backgroundColor: '#f8f8f8',
                    title: 'Progress for evaluators',
                    titleTextStyle: { color: '#9e1780' },
                    chartArea: { left: 150 },
                    width: 700,
                    legend: { position: 'none' },
                    hAxis: { title: 'Percent Complete', titleTextStyle: { color: '#000080' }, minValue: 0, maxValue: 1, format: 'percent', viewWindow: { min: 0, max: 1 }, baselineColor: '#808080' },
                    vAxis: { textStyle: { color: '#9e3d17' }, baselineColor: '#808080', gridlines: { color: '#c0c0c0' } },
                    bars: 'horizontal', // Required for Material Bar Charts.
                };
                var chart = new google.visualization.BarChart(graphdiv);
                chart.draw(data, options);
            }
        }
    },
    runUpdProgress: function (d) {
        var phase = null;
        var teams = null;
        var users = null;
        if (devt.def(d['phase'])) phase = d['phase'];
        if (devt.def(d['teams'])) teams = d['teams'];
        if (teams && phase) {
            for (var t = 0; t < teams.length; t++) {
                var team = teams[t];
                var teamid = parseInt(team['id']);
                eval.drawTeam(team, phase);
            }
        }
        if (devt.def(d['users'])) users = d['users'];
        if (users)
            eval.drawUsers(users, phase);
    },
    //Display
    dispfromprog:
    {
        setup:
        {
            0: {
                parent: '',
                0: '',
                1: ''
            },
            1: {
                parent: 'evaluationform',
                0: 'evaluationlist',
                1: 'evaluationform1'
            },
            2: {
                parent: 'ruleform',
                0: 'rulelist',
                1: 'ruleform1'
            },
            3: {
                parent: 'phaseform',
                0: 'phaselist',
                1: 'phaseform1'
            },
            4: {
                parent: 'batchload',
                0: '',
                1: ''
            },
            5: {
                parent: 'vieweval',
                0: '',
                1: ''
            },
            6: {
                parent: 'evaluators',
                0: 'evallist',
                1: 'evalform3',
                2: 'evalform2',
                3: 'evalform1'
            },
            7: {
                parent: 'teamform',
                0: 'teamlist',
                1: 'teamform1'
            },
            8: {
                parent: 'qtoteams',
                0: 'qtoteams1',
                1: ''
            },
            9: {
                parent: 'etoteams',
                0: 'etoteams1',
                1: ''
            },
            10: {
                parent: 'respondentform',
                0: 'respondentlist',
                1: 'respondentform1'
            },
            11: {
                parent: 'validate',
                0: '',
                1: ''
            },
            12: {
                parent: 'sectionform',
                0: 'sectionlist',
                1: 'sectionform1'
            },
            13: {
                parent: 'questionform',
                0: 'questionlist',
                1: 'questionform1'
            },
            14: {
                parent: 'subattributeform',
                0: 'subattributelist',
                1: 'subattributeform1'
            }
        },
        run:
        {
            0: {
                parent: '',
                0: '',
                1: ''
            },
            1: {
                parent: 'evalform',
                0: 'evlist1',
                1: 'evform1'
            },
            2: {
                parent: 'enablephase',
                0: '',
                1: ''
            },
            3: {
                parent: 'vprogress',
                0: '',
                1: ''
            },
            4: {
                parent: '',
                0: '',
                1: ''
            },
            5: {
                parent: 'teamreports',
                0: '',
                1: ''
            },
            6: {
                parent: 'results',
                0: '',
                1: ''
            },
            7: {
                parent: 'report',
                0: '',
                1: ''
            },
            8: {
                parent: 'enableteam',
                0: '',
                1: ''
            },
        },
        maintenance:
        {
            0: {
                parent: '',
                0: '',
                1: ''
            },
            1: {
                parent: '',
                0: '',
                1: ''
            },
            2: {
                parent: 'backupform',
                0: 'backupform1',
                1: ''
            },
            3: {
                parent: 'purgeall',
                0: 'purgeallform1',
                1: ''
            },
            4: {
                parent: 'auditreport',
                0: '',
                1: ''
            },
            5: {
                parent: 'dumpallexcel',
                0: 'dumpallexcelform1',
                1: ''
            },
            6: {
                parent: 'listbackups',
                0: 'listbackupsform1',
                1: ''
            },
        }
    }
};