<?php
$desc = "<p><b>DESCRIPTION</b></p><p>This is where you enter scoring rule sets.  Rule sets define the limits and incremental value of scores, for example the minimum and maximum value a score can be given, and the increment used.</p>" .
    "<p>Note: Each phase as a rule set associated to it allowing different ruls to be applied for each phase.</p>" .
    "<p>The following fields are used to define a rule:</p>" .
    "<p class='indent1'><b>MINIMUM</b> - This is the minimum value that can be given to a score.</p><p class='indent1'><b>MAXIMUM</b> - This is the maximum value that can be given to a score.</p><p class='indent1'><b>INCREMENT</b> - This is the increment or modulus of a given score.</p>";
    $fields = [
        "1rn" => [
            "type" => "text",
            "dbfield" => "rule_name",
             "form" => [
                "formlabel" => "RULE NAME",
                "size" => "20",
                "maxlength" => "45"
             ],
             "list" => [
                "heading" => "NAME",
                "anchor" => "idrule"
             ]
        ],
        "1min" => [
            "type" => "integer",
            "dbfield" => "rule_min",
             "form" => [
                "formlabel" => "MINIMUM",
                "size" => "4",
             ],
              "list" => [
                "heading" => "MIN",
                "class" => "right"
             ]
       ],
        "1max" => [
            "type" => "integer",
            "dbfield" => "rule_max",
             "form" => [
                "formlabel" => "MAXIMUM",
                "size" => "4",
             ],
              "list" => [
                "heading" => "MAX",
                "class" => "right"
             ]
       ],
        "1inc" => [
            "type" => "integer",
            "dbfield" => "rule_mod",
             "form" => [
                "formlabel" => "INCREMENT",
                "size" => "4",
             ],
              "list" => [
                "heading" => "INCREMENT",
                "class" => "right"
             ]
       ]
    ];

    $sec = ESecure::sec_encryptParam("stage={$g_stage}",$_SESSION['session_key']);


    $WIZ->startPage("STEP 2 - Rules");
    $WIZ->helpDescription($desc);

    $have_list = false;
    if (isset($allRules) && ! $g_action)
        $have_list = $WIZ->buildList($g_stage,"LIST FO RULES",$fields,$allRules,["ADD" => "CREATE NEW RULE","DELETEITEM" => true]);

    $WIZ->startForm($selff,$sec);
    if (! $have_list)
    {
        if (! $WIZ->recreate($g_stage) )
            $WIZ->buildPage($g_stage,$fields,$rule,$g_action);
    }
    $WIZ->endForm($g_stage,WIZARD_PAGE_NEXT | WIZARD_PAGE_BACK);
    $WIZ->endPage();
?>