<?php
return [
     'formglobals' => [
        'title' => 'Questions'
        ],
     'database' => [
        'tablename' => 'question',
        'id' => 'idquestion',
        'evalid' => 'question_evaluation',
        'allrecs' => 'allQuestionsForEval',
        'order' => 'question_order'
       ],
    'fields' => [
        'question_order' => [
                'type'=>'text',
                'size'=>'3',
                'heading'=>'ORDER',
                'list_display'=> true,
                'list_heading'=>'ORDER',
                'group'=>'',
                'title'=>'Enter the order to appear.',
                'req'=>true
                       ],
        'question_identifier' => [
                'type'=>'text',
                'size'=>'5',
                'heading'=>'INDENTIFIER',
                'list_display'=> true,
                'list_heading'=>'NUMBER',
                'group'=>'',
                'title'=>'Enter the question number.',
                'req'=>true
                       ],
        'question_section' => [
                'type'=>'fk',
                'fktable' => 'section',
                'fkkey' => 'idsection',
                'fkdisp' => 'section_name',
                'heading'=>'SECTION',
                'list_display'=> true,
                'list_heading'=>'SECTION',
                'group'=>'',
                'title'=>'Enter the porposal section number.',
                'req'=>true
                       ],
        'question_type' => [
                'type'=>'ENUM',
                'rows'=>'10',
                'cols'=>'70',
                'spellcheck'=>true,
                'heading'=>'SCORING TYPE',
                'list_display'=> false,
                'list_heading'=>'',
                'group'=>'',
                'title'=>'Score type',
                'req'=>true,
                'values' => ["range","boolean"],
                'valuesDisp' => ["RANGE","YES NO"]
                       ],
        'question_text' => [
                'type'=>'textarea',
                'rows'=>'10',
                'cols'=>'70',
                'spellcheck'=>true,
                'heading'=>'QUESTION',
                'list_display'=> false,
                'list_heading'=>'SECTION ORDER',
                'group'=>'',
                'title'=>'Enter question text.',
                'req'=>true
                       ],
        'question_guide' => [
                'type'=>'textarea',
                'rows'=>'10',
                'cols'=>'70',
                'spellcheck'=>true,
                'heading'=>'EVAL GUIDE',
                'list_display'=> false,
                'list_heading'=>'GUIDE',
                'group'=>'',
                'title'=>'Enter question text.',
                'req'=>false
                       ],
        'question_weighting' => [
                'type'=>'PERCENTAGE',
                'size'=>'5',
                'heading'=>'WEIGHTING',
                'list_display'=> true,
                'list_heading'=>'WEIGHTING',
                'group'=>'',
                'title'=>'Enter question weighting as a %.',
                'req'=>true
                       ]
        ],
    'groups' => [
        'SectionDetails'=>
            [
            'grpname'=>'SECTION DETAILS',
            'colour'=>'#daeaea;'
            ]
        ],
    'menus' => [
        'admin' => [
            'title' => 'ADMIN',
            'link' => 'admin.php'
            ],
        ]
  ];
?>