<?php
return [
     'formglobals' => [
        'title' => 'Phases',
        'createbutton' => 'CREATE NEW PHASE',
        'changebutton' => 'CONFIRM PHASE CHANGE'
        ],
     'database' => [
        'tablename' => 'phase',
        'id' => 'idphase',
        'evalid' => 'phase_evaluation',
        'allrecs' => 'allPhasesForEval',
        'order' => 'phase_order'
       ],
    'fields' => [
        'phase_name' => [
                'type'=>'text',
                'size'=>'20',
                'heading'=>'PHASE NAME',
                'list_display'=> true,
                'list_heading'=>'PHASE NAME',
                'list_class'=>'',
                'group'=>'',
                'title'=>'Enter the name of the phase.',
                'req'=>true
                       ],
        'phase_order' => [
                'type'=>'number',
                'size'=>'3',
                'heading'=>'ORDER',
                'list_display'=> true,
                'list_heading'=>'ORDER',
                'list_class'=>'',
                'group'=>'',
                'title'=>'Enter a number to specify the order of the phases.',
                'req'=>true
                       ],
        'phase_single_score' => [
                'type'=>'checkbox',
                'size'=>'3',
                'heading'=>'SINGLE SCORE',
                'list_display'=> true,
                'list_heading'=>'SINGLE SCORE',
                'list_class'=>'',
                'group'=>'',
                'title'=>'Check for a phase that can only have one evaluator.',
                'req'=>false
                       ],
        'phase_rule' => [
                'type'=>'fk',
                'fktable' => 'rule',
                'fkkey' => 'idrule',
                'fkdisp' => 'rule_name',
                'fkcond' => "where rule_evaluation = {$_SESSION['current_evaluation']}",
                'size'=>'3',
                'heading'=>'RULE',
                'list_display'=> true,
                'list_heading'=>'RULE',
                'list_class'=>'',
                'group'=>'',
                'title'=>'Enter vaidation rule for this phase.',
                'req'=>false
                       ],
         'phase_is_partial' => [
                'type'=>'checkbox',
                'size'=>'3',
                'heading'=>'PARTIAL PHASE, NOT ALL QUESTIONS ARE SCORED',
                'list_display'=> false,
                'list_heading'=>'',
                'list_class'=>'',
                'group'=>'',
                'title'=>'Check if this is a partila phase where not all questions are scored.',
                'req'=>false
                       ]
        ],
    'groups' => [
        'SectionDetails'=>
            [
            'grpname'=>'SECTION DETAILS',
            'colour'=>'#daeaea;'
            ]
        ],
    'menus' => [
        'admin' => [
            'title' => 'ADMIN',
            'link' => 'admin.php'
            ],
        ],
    'data' => [
         'values' => ['defined','enabled','complete'],
         'valuesDisp' => ['Defined (Not Started)','Enabled','Completed']
        ]
  ];
?>