<?php
session_start();
require './includes/classEvalSecure.php';
require './includes/classEvalHelpers.php';
require './includes/classEvaluateDB.php';
require './includes/classSiem.php';


$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
$SIEM = new devt\siem\siem($devt_environment->getkey("SIEMHOST"));

$SEC = new ESecure();

$selff = htmlspecialchars($_SERVER["PHP_SELF"]);
$_SESSION['returnto'] = $selff;
$global = $DB->o_getGlobal();
ESecure::CheckPage(SECURITY_ADMIN);
$user = $DB->getUser($_SESSION['userid']);
ESecure::CheckUser($user);



function var_error_log( $object=null ,$text='')
{
    ob_start();
    var_dump( $object );
    $contents = ob_get_contents();
    ob_end_clean();
    error_log( "{$text} {$contents}" );
}



$g_stage = 0;
$g_action = null;
$evaluation = null;
$max_evaluations = max(intval($devt_environment->getkey("LIMIT2")),1);
$num_evaluations = $DB->numOfEvaluations();
$title = $global->global_title->toHTML();
$instancename = $devt_environment->getkey("DATABASE_NAME");

if (isset($_SESSION['current_evaluation']) && $_SESSION['current_evaluation'] != 0)
{
    $evaluation = $DB->getEvaluation($_SESSION['current_evaluation']);
    if (!$evaluation)
        $_SESSION['current_evaluation'] = 0;

}
else
{
    if ($num_evaluations > 0)
    {
        $evaluation = $DB->getFirstEvaluation();
        if ($evaluation)
        {
            $_SESSION['current_evaluation'] = $evaluation['idevaluation'];
        }
    }
}

$allRules = $DB->every("rule","where rule_evaluation = {$evaluation['idevaluation']}","order by idrule");
$rule = null;

if ($_SERVER['REQUEST_METHOD'] == 'POST')
{
    if (!Secure::checkCSRF())
    {
        $SIEM->createSecurityEntry("csrf",SECUITY_INVALID_CSRF,"minor",getenv("VAULT_SHELF"),"Invalid CSRF in Audit Request");
        $DB->createSecurityAudit($user,"Wizard.php [".__LINE__."] Failed CSRF check");
        header("Location: SecurityError.php");
        exit();
    }
}

?>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta name="viewport" content="width=device-width" />
    <meta name="viewport" content="initial-scale=1.0" />
    <title>SETUP WIZARD</title>
    <link id="myicon" rel="icon" type="image/png" href="images/Icon1.png" />
    <link rel="stylesheet" href="css/Base.css" />
    <link rel="stylesheet" href="css/Wizard.css" />
</head>
<body>
    <div id="container">
        <div id='heading'>
            <table>
                <tr>
                    <td></td>
                    <td class='ht'>nVALUATE</td>
                    <td></td>
                </tr>
            </table>
        </div>
        <div id='menu'>
            <div class='d1'>
                <a href='Admin.php'>ADMIN</a>
            </div>
            <div class='d1 sel'>SETUP</div>
            <div class='d1'>
                <a href='Run.php?prog=0'>RUN</a>
            </div>
            <div class='d1'>
                <a href='Maintenance.php?prog=2'>MAINTENANCE</a>
            </div>
            <div class='d1'>
                <a href="Signout.php">SIGN OUT</a>
            </div>
            <?php
            if (ESecure::IS_MODULE_SCORE() && Secure::CheckSecurity(SECURITY_EVALUATE) )
                echo "<div class='d1'><a href='Score'>SCORE</a></div>";
            ?>
            <?php
            if (ESecure::IS_MODULE_ROOM())
                echo "<div class='d1'><a href='DataRoom.php'>DATAROOM</a></div>";
            ?>
            <div class='d2'>
                <a href='Me.php'>
                    <?php if ($user) echo $user['user_name'];?>
                </a>
            </div>
            <div class='clear'></div>
        </div>
        <div id='main'>
            <div id="sctions">
                <form>
                    <div id="evaluation1" class="section1">

                    </div>
                    <div id="rules" class="section1">
                        <table>
                            <tr><td><input type="checkbox" name="rule[]" value="0" /><span>RULE INITIAL 100 (0 - 100 INCREMENT 5)</span></td></tr>
                            <tr><td><input type="checkbox" name="rule[]" value="1" /><span>RULE FINAL 100 (0 - 100 INCREMENT 1)</span></td></tr>
                            <tr><td><input type="checkbox" name="rule[]" value="2" /><span>RULE 5 (0 - 5 INCREMENT 1)</span></td></tr>
                            <tr><td><input type="checkbox" name="rule[]" value="3" /><span>RULE 10 (0 - 10 INCREMENT 1)</span></td></tr>
                        </table>
                    </div>
                    <div id="phases" class="section1">

                    </div>
                </form>
           </div>
        </div>
    </div>
</body>
</html>