<?php session_start(); ?>
<?php
//devt.Version = 1.0
require './includes/classEvalSecure.php';
require './includes/classFormList.php';
require './includes/classSiem.php';
if (!ESecure::IS_MODULE_SCORE())
{
    http_response_code(404);
    exit();
}
require './includes/classEvaluateDB.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
$SIEM = new devt\siem\siem($devt_environment->getkey("SIEMHOST"));

$global = $DB->getGlobal();
ESecure::CheckPage(SECURITY_ADMIN);
$user = $DB->getUser($_SESSION['userid']);
ESecure::CheckUser($user);

$FL = new FormList(null);


$selff = htmlspecialchars($_SERVER["PHP_SELF"]);
$instancename = $devt_environment->getkey("DATABASE_NAME");
$strErr = "";
$strMsg = "";

$evalid = 0;
if (isset($_SESSION['current_evaluation']) && $_SESSION['current_evaluation'] != 0)
{
    $evaluation = $DB->getEvaluation($_SESSION['current_evaluation']);
    if ($evaluation)
        $evalid = $evaluation['idevaluation'];
}
if ($evalid == 0)
{
    if ($DB->numOfEvaluations() == 1)
    {
        $evaluation = $DB->getFirstEvaluation();
        if ($evaluation)
        {
            $_SESSION['current_evaluation'] = $evaluation['idevaluation'];
            $evalid = $evaluation['idevaluation'];
        }
    }
}
if ($evalid == 0)
{
    header("Location: ChooseEval.php");
    exit();
}

function var_error_log( $object=null ,$text='')
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( "{$text} {$contents}" );        // log contents of the result of var_dump( $object )
}



function handleTransfer()
{
    global $strErr;
    global $strMsg;
    global $DB;
    global $evalid;
    global $user;

    $srcEval = 0;
    $dstEval = 0;
    $srcPhase = 0;
    $dstPhase = 0;
    $avergescores = false;
    $copy_comments = false;

    $srcPhase = intval($_POST['srcphases']);
    $dstPhase = intval($_POST['dstphases']);

    if (isset($_POST['srcEvaluator']))
        $srcEval = intval($_POST['srcEvaluator']);
    if (isset($_POST['dstEvaluator']))
        $dstEval = intval($_POST['dstEvaluator']);
    if (isset($_POST['averagescores']))
        $avergescores = true;
    $override = FormList::getCheckBoxField('override');
    $copy_comments = FormList::getCheckBoxField('cpycomments');


    $maxcomment_length = intval($DB->fieldLength("score","score_comment"));

    //Validity checks
    if ($srcPhase == 0 || $dstPhase == 0)
    {
        $strErr = "ERROR Both a source and destination phases must be specified";
        return;
    }

    $phase_src = $DB->getPhase($srcPhase);
    $phase_dst = $DB->getPhase($dstPhase);
    if (!$phase_src  || !$phase_dst )
    {
        $strErr = "ERROR Invalid phase specified";
        return;
    }

    if ($dstEval == 0 && !$avergescores)
    {
        $strErr = "ERROR Destination evaluator must be specified";
        return;
    }

    if (!$avergescores)
    {
        $evaluatorDest = $DB->getUser($dstEval);
        if (!$evaluatorDest)
        {
            $strErr = "ERROR Invalid destination evaluator specified";
            return;
        }
    }

    //Now check that if the src phase is not single score then we have an evaluator specified
    if ($phase_src['phase_single_score'] == 0 && $srcEval == 0 && !$avergescores )
    {
        $strErr = "ERROR EVALUATOR must be specified for the source phase or COPY ALL AVERAGE SCORES as this phase has multiple evaluators per score";
        return;
    }

    $evaluatorSrc = null;
    if ($srcEval > 0)
    {
        $evaluatorSrc = $DB->getUser($srcEval);
        if (!$evaluatorSrc)
        {
            $strErr = "ERROR Invalid source evaluator specified";
            return;
        }
    }

    //Check that source and dest phases are different
    if ($srcPhase == $dstPhase)
    {
        $strErr = "ERROR Source and destinations phases cannot be the same";
        return;
    }

    /*
        Version 2.0 Special version to allow mon complete phases
        To return back to normal uncomment the line  != "complete" following
    */


    //Now check phases are in correct state
    //if ($phase_src['phase_status'] != "complete")
    //{
        //$strErr = "ERROR Source phase must be completed to copy scores";
        //return;
    //}

    if ($phase_dst['phase_status'] != "enabled")
    {
        $strErr = "ERROR Destination phase must be enabled and not completed to copy scores";
        return;
    }

    //
    if ($avergescores)
    {
        $matrix = array();
        $question_types = array();
        $sub_types = array();

        $DB->BeginTransaction();


        $r1 = $DB->allQuestionsForEval($evalid);
        while ($question = $r1->fetch_assoc())
        {
            $question_types[$question['idquestion']] = $question['question_type'];

            $r2 = $DB->allTeamsForQuestion($question['idquestion']);
            while ($team = $r2->fetch_assoc())
            {
                $r3 = $DB->allUsersForTeam($team['idteam']);
                while ($evaluator = $r3->fetch_assoc() )
                {
                    $r4 = $DB->allScoresForQuestion($evalid,$srcPhase,$evaluator['iduser'],$question['idquestion']);
                    while ($score = $r4->fetch_array(MYSQLI_ASSOC))
                    {
                        //Sum for each respondent
                        if (! isset($matrix[$question['idquestion']]))
                        {
                            $matrix[$question['idquestion']] = array();
                        }
                        $subid = 0;

                        if ($score['score_subattribute'])
                            $subid = $score['score_subattribute'];

                        if ($subid != 0)
                        {
                            $sub_types[$subid] = $DB->getSubAttributeType($subid);
                        }

                        if (! isset($matrix[$question['idquestion']] [$subid] ))
                        {
                            $matrix[$question['idquestion']] [$subid] = array();
                        }
                        if (! isset($matrix[$question['idquestion']] [$subid] [$score['score_respondent']] ) )
                            $matrix[$question['idquestion']] [$subid] [$score['score_respondent']] = array();

                        if ( ! isset($matrix[$question['idquestion']] [$subid] [$score['score_respondent']] ['score']) )
                        {
                            $matrix[$question['idquestion']] [$subid] [$score['score_respondent']] ['score'] = $score['score_score'];
                            $matrix[$question['idquestion']] [$subid] [$score['score_respondent']] ['cnt'] = 1;
                            $matrix[$question['idquestion']] [$subid] [$score['score_respondent']] ['comment'] = $score['score_comment'];
                        }
                        else
                        {
                            $matrix[$question['idquestion']] [$subid] [$score['score_respondent']] ['score'] += $score['score_score'];
                            $matrix[$question['idquestion']] [$subid] [$score['score_respondent']] ['cnt'] += 1;
                            if (strlen($score['score_comment']) > 0)
                            {
                                $matrix[$question['idquestion']] [$subid] [$score['score_respondent']] ['comment'] .= "\n" . $score['score_comment'];
                                if (strlen($matrix[$question['idquestion']] [$subid] [$score['score_respondent']] ['comment']) > $maxcomment_length)
                                    $matrix[$question['idquestion']] [$subid] [$score['score_respondent']] ['comment'] = substr($matrix[$question['idquestion']] [$subid] [$score['score_respondent']] ['comment'],0,$maxcomment_length-1);
                            }
                        }
                    }
                }
            }
        }
        foreach ($matrix as $qid => $q)
        {
            //Check the score type
            $score_type = $question_types[$qid];

            foreach ($q as $subid => $s)
            {
                if ($subid > 0)
                {
                    $score_type = $sub_types[$subid];
                }

                foreach ($s as $respid => $r)
                {
                    if ($r['cnt'] > 0 && $score_type == 'range')
                        $val = intval(round($r['score'] / $r['cnt']));
                    else
                        $val = 0;

                    //We need to get the evaluator for this question and sub in this phase.
                    if (! $auser1 = $DB->getSingleEvaluatorForPhaseQuestion($dstPhase,$qid) )
                    {
                        $DB->TransactionError();
                        $strErr = "ERROR: Cannot find a single user for destination phase and question";
                        error_log("Utility error cannot find a singl user for destination phase and question {$dstPhase} {$qid}");
                    }
                    var_error_log($auser1, "Score for error 1");

                    $score = array();
                    $score['score_user'] = $auser1['iduser'];
                    $score['score_evaluation'] = $evalid;
                    $score['score_phase'] = $dstPhase;
                    $score['score_respondent'] = $respid;
                    $score['score_question'] = $qid;
                    if ($subid > 0)
                        $score['score_subattribute'] = $subid;
                    $score['score_score'] = $val;
                    $score['score_comment'] = null;
                    if ($copy_comments)
                        $score['score_comment'] = $r['comment'];


                    $oldscore = $DB->getScoreDetail($auser1['iduser'],$evalid,$dstPhase,$respid,$qid,$subid);

                    if ($oldscore && !$override)
                    {
                        $DB->TransactionError();
                        $strErr = "ERROR: Attempt to copy score to new phase, but score already exists";
                    }
                    if ($oldscore && $override)
                    {

                        if (!$DB->p_update_from_array('score',$score,"where idscore = {$oldscore['idscore']}") )
                        {
                            $DB->TransactionError();
                            var_error_log($score, "Score for error 1");
                            $strErr = "ERROR: Database transaction errors while copying scores, could be score already existed. No scores copied";
                        }
                        if (isset($score['score_subattribute']))
                            $DB->createScoreAudit($user,$evalid,$dstPhase,$score['score_respondent'],$score['score_question'],$score['score_subattribute'],$score['score_score']);
                        else
                            $DB->createScoreAudit($user,$evalid,$dstPhase,$score['score_respondent'],$score['score_question'],null,$score['score_score']);

                    }
                    else
                    {
                        if (!$DB->p_create_from_array('score',$score) )
                        {
                            $DB->TransactionError();
                            var_error_log($score, "Score for error 2");
                            $strErr = "ERROR: Database transaction errors while copying scores, could be score already existed. No scores copied";
                        }
                        if (isset($score['score_subattribute']))
                            $DB->createScoreAudit($user,$evalid,$dstPhase,$score['score_respondent'],$score['score_question'],$score['score_subattribute'],$score['score_score']);
                        else
                            $DB->createScoreAudit($user,$evalid,$dstPhase,$score['score_respondent'],$score['score_question'],null,$score['score_score']);

                    }
                    if ($score['score_comment'] && strlen($score['score_comment']) > 0)
                    {
                        if (isset($score['score_subattribute']))
                            $DB->createCommentAudit($user,$evalid,$dstPhase,$score['score_respondent'],$score['score_question'],$score['score_subattribute'],$score['score_comment']);
                        else
                            $DB->createCommentAudit($user,$evalid,$dstPhase,$score['score_respondent'],$score['score_question'],null,$score['score_comment']);

                    }
                }
            }
        }

        //Update phase
        $DB->updatePhasePopulate($dstPhase,$user['iduser']);
        if ($DB->isTransactionError())
        {
            error_log("Utility.php [".__LINE__."] Database transaction error");
            if (strlen($strErr) == 0)
                $strErr = "ERROR: Database transaction errors while copying scores; No scores copied";
        }
        else
        {
            $strMsg = "Scores copied";
        }

        $DB->EndTransaction();
    }
    else
    {
        //Now we are ady to copy the scores
        $cnt = 0;
        $DB->BeginTransaction();
        $r = $DB->allTeamsForUser($dstEval);
        if ($r->num_rows == 0)
        {
            $dest_user = htmlspecialchars(($DB->getUser($dstEval)) ['user_name']);
            $strErr = "ERROR: The specified destaintion evaluator, {$dest_user}, does not belong to any teams";
        }

        while ($team = $r->fetch_array(MYSQLI_ASSOC))
        {
            $r2 = $DB->allQuestionsForTeam($team['idteam']);
            while ($qu = $r2->fetch_array(MYSQLI_ASSOC))
            {
                //Get all source scores for question
                $r3 = $DB->allScoresForQuestion($evalid,$srcPhase,$srcEval,$qu['idquestion']);
                while ($score = $r3->fetch_array(MYSQLI_ASSOC))
                {
                    if (! $copy_comments)
                        $score['score_comment'] = null;

                    //Check to see if score already exists
                    $oldscore = $DB->getScoreDetail($dstEval,$evalid,$dstPhase,$score['score_respondent'],$score['score_question'],$score['score_subattribute']);
                    if ($oldscore && !$override)
                    {
                        $DB->TransactionError();
                        $strErr = "ERROR: Attempt to copy score to new phase and evaluator, but score already exists";
                    }

                    if ($oldscore && $override)
                    {
                        unset($score['idscore']);
                        $score['score_user'] = $dstEval;
                        $score['score_phase'] = $dstPhase;
                        if (!$DB->p_update_from_array('score',$score,"where idscore = {$oldscore['idscore']}") )
                        {
                            $DB->TransactionError();
                            $strErr = "ERROR: Database transaction errors while copying scores, could be score already existed. No scores copied";
                        }
                        else
                            $cnt++;
                    }
                    else
                    {

                        unset($score['idscore']);
                        $score['score_user'] = $dstEval;
                        $score['score_phase'] = $dstPhase;
                        if (!$DB->p_create_from_array('score',$score) )
                        {
                            $DB->TransactionError();
                            $strErr = "ERROR: Database transaction errors while copying scores, could be score already existed. No scores copied";
                        }
                        else
                            $cnt++;
                        $sc_user = $DB->getUser($dstEval);
                        $DB->createScoreAudit($user,$evalid,$dstPhase,$score['score_respondent'],$score['score_question'],$score['score_subattribute'],$score['score_score']);
                    }
                    $sc_user = $DB->getUser($dstEval);
                    $DB->createScoreAudit($user,$evalid,$dstPhase,$score['score_respondent'],$score['score_question'],$score['score_subattribute'],$score['score_score']);

                    if ($score['score_comment'] && strlen($score['score_comment']) > 0)
                    {
                        $DB->createCommentAudit($sc_user,$evalid,$dstPhase,$score['score_respondent'],$score['score_question'],$score['score_subattribute'],$score['score_comment']);
                    }
                }
            }
        }
        //Update phase
        $DB->updatePhasePopulate($dstPhase,$user['iduser']);
        if ($DB->isTransactionError())
        {
            error_log("Utility.php [".__LINE__."] Database transaction error");
            if (strlen($strErr) == 0)
                $strErr = "ERROR: Database transaction errors while copying scores; No scores copied";
        }
        else
        {
            $strMsg = "{$cnt} Scores copied";
        }
        $DB->EndTransaction();
    }
}


if ($_SERVER["REQUEST_METHOD"] == "POST")
{
    if (!Secure::checkCSRF())
    {
        $SIEM->createSecurityEntry("csrf",SECUITY_INVALID_CSRF,"minor",getenv("VAULT_SHELF"),"Invalid CSRF in Utility");
        $DB->createSecurityAudit($user,__FILE__ . " [".__LINE__."] Failed CSRF check");
        header("Location: SecurityError.php");
        exit();
    }

    if (isset($_POST['transfer']))
    {
        handleTransfer();
    }
}



?>
<!DOCTYPE HTML>
<html>
<head>
<meta name="viewport" content="width=device-width" />
<meta name="viewport" content="initial-scale=1.0" />
<title>UTILITIES</title>
<link id="myicon" rel="icon" type="image/png" href="images/Icon1.png" />
<link href="css/Base.css" rel="stylesheet">
<style>
@import "../fonts/Roboto.css"; 
@import "../fonts/Roboto-Slab.css"; 
body {font-family: Arial, Helvetica, sans-serif;font-size: 10pt; margin: 0;padding:0;height:100%;background-color: #f8f8f8;}
#main h1 {color: #55a;font-family: roboto slab;}
#copy {display: flex;}
#copy h1{font-family: Roboto Slab;margin-top: 0;color: #448;font-size: 12pt;}
#copy div.d1 {margin: 10px; padding: 14px;border: solid 1px #888;border-radius: 6px;}
#copy div.d2 {margin: 10px;}
#copy div.d3 {margin: 10px; padding-top: 90px;}
#copy div.d4 {display: none;}
#copy div.d5 {display: none;}
#dstMessages {display: none;}
#dstInputs {display: none;}
#copy input[type='submit'] {font-size: 14pt;}
#copy input[type='checkbox'] {width: 16px; height: 16px;margin-left: 0;}
#copy p.p1 {margin-bottom: 0; font-size: 9pt;}
#copy p.p2 {margin-left: 16px; font-size: 9pt;}
#copy p.p3 {margin: 0;}
#copy p.dis {color: #888;}
#copy span {font-size: 9pt;}
#copy span.dis {color: #888;}
#messages p.msgerr {color: red; font-size: 12pt;}
#messages p.msgmsg {font-size: 12pt;}
#override {padding: 8px;border: solid 1px #888;margin-top: 8px;border-radius: 6px;background-color: white;}
#override p {margin-top: 0;color: #a40a0a;font-weight: bold;}
</style>
<script type="text/javascript" src="apievaljsonv1.php?r=/<?php echo $user['user_apikey'];?>/devtscript/<?php echo $instancename;?>/eval&formtoken=<?php echo urlencode($_SESSION['csrf_key']);?>"></script>
<script type="text/javascript" src="apievaljsonv1.php?r=/<?php echo $user['user_apikey'];?>/devtscript/<?php echo $instancename;?>/devtcore&formtoken=<?php echo urlencode($_SESSION['csrf_key']);?>"></script>
<script>
                                        <?php
    $b1 = false;
    echo "var src_phases = [";

/*
    Version 2.0 Special version to allow mon complete phases
    To return back to normal uncomment the line  $r = $DB->allPhasesForEvalCompleted($evalid); and remove line $r = $DB->allPhasesForEval($evalid);
*/

    $r = $DB->allPhasesForEval($evalid,"order by phase_order");
    //$r = $DB->allPhasesForEvalCompleted($evalid);
    while ($phase = $r->fetch_array(MYSQLI_ASSOC))
    {
        if ($b1) echo ",";
        $b1 = true;
        echo "{";
        $n = htmlspecialchars(stripslashes($phase['phase_name']));
        $t = intval($phase['phase_single_score']);
        echo "id: {$phase['idphase']}, name: '{$n}', type: {$t}, evaluators: [";

        $b2 = false;
        $r2 = $DB->allEvaluatorsForPhase($phase['idphase'],"order by user_username");
        while ($u = $r2->fetch_array(MYSQLI_ASSOC))
        {
            if (Secure::CheckUserSecurity($u,SECURITY_EVALUATE))
            {
                if ($b2) echo ",";
                $b2 = true;
                echo "{";
                echo "id: {$u['iduser']}, name: '{$u['user_name']}'";
                echo "}";
            }
        }
        echo "]";
        echo "}";
    }
    echo "]\n";

    $b1 = false;
    echo "var dst_phases = [";
    $r = $DB->allPhasesForEvalEnabled($evalid);
    while ($phase = $r->fetch_array(MYSQLI_ASSOC))
    {
        if ($b1) echo ",";
        $b1 = true;
        echo "{";
        $n = htmlspecialchars(stripslashes($phase['phase_name']));
        $t = intval($phase['phase_single_score']);
        echo "id: {$phase['idphase']}, name: '{$n}', type: {$t}, evaluators: [";

        $b2 = false;
        $r2 = $DB->allEvaluatorsForPhase($phase['idphase'],"order by user_username");
        while ($u = $r2->fetch_array(MYSQLI_ASSOC))
        {
            if (Secure::CheckUserSecurity($u,SECURITY_EVALUATE))
            {
                if ($b2) echo ",";
                $b2 = true;
                echo "{";
                echo "id: {$u['iduser']}, name: '{$u['user_name']}'";
                echo "}";
            }
        }
        echo "]";
        echo "}";
    }
    echo "]\n";

                                    ?>

    function buildCompletePhaseList() {
        var p = devt.ge('srcphases');
        devt.cea("OPTION", p);
        for (var i = 0; i < src_phases.length; i++) {
            var o = devt.cea("OPTION", p);
            o.value = src_phases[i].id;
            o.innerHTML = src_phases[i].name;
        }
    }

    function getPhase(phses,v) {
        for (var i = 0; i < phses.length; i++) {
            if (phses[i].id == v)
                return phses[i];
        }
        return null;
    }

    function buildDestPhaseList(notphaseid) {
        var p = devt.ge('dstphases');
        var cnt = 0;
        devt.cea("OPTION", p);
        for (var i = 0; i < dst_phases.length; i++) {
            if (dst_phases[i].id != notphaseid) {
                var o = devt.cea("OPTION", p);
                o.value = dst_phases[i].id;
                o.innerHTML = dst_phases[i].name;
                cnt++;
            }
        }
        if (cnt == 0) {
            devt.ge('dstMessages').style.display = 'block';
            devt.ge('dstInputs').style.display = 'none';
        }
        else {
            devt.ge('dstMessages').style.display = 'none';
            devt.ge('dstInputs').style.display = 'block';
            if (!devt.ge('averagescores').checked)
                devt.ge('subset2').style.display = 'block';
        }
    }


    function changeSrcPhase(n) {
        var p = devt.ge('srcEvaluator');
        var t = devt.ge('evaltxt');
        var av = devt.ge('averagescores');
        var avtxt = devt.ge('averagescorestxt');
        var dst = devt.ge('dstphases');
        var srcSubset = devt.ge('subset');
        devt.removeAllChildren(p);
        devt.removeAllChildren(dst);
        var phase = getPhase(src_phases,n.value);
        if (phase) {
            buildDestPhaseList(phase.id);
            if (phase.type == 0) { //Multi evaluator
                var evals = phase.evaluators;
                for (var j = 0; j < evals.length; j++) {
                    var o = devt.cea("OPTION", p);
                    o.value = evals[j].id;
                    o.innerHTML = evals[j].name;
                }
                srcSubset.style.display = 'block';
                p.disabled = false;
                av.disabled = false;
                t.className = "p1";
                avtxt.className = "";
            }
            else {
                srcSubset.style.display = 'none';
                p.disabled = true;
                av.disabled = true;
                av.checked = false;
                t.className = "p1 dis";
                avtxt.className = "dis";
            }
        }
        else {
            devt.ge('dstMessages').style.display = 'none';
            devt.ge('dstInputs').style.display = 'none';
            srcSubset.style.display = 'none';
        }
    }

    function selectAvgScores(n) {
        var p = devt.ge('srcEvaluator');
        var de = devt.ge('dstEvaluator');
        var t = devt.ge('evaltxt3');
        var dstSubset2 = devt.ge('subset2');
        if (n.checked) {
            dstSubset2.style.display = 'none';
            p.disabled = true;
            de.disabled = true;
            t.className = "p1 dis";
        }
        else {
            dstSubset2.style.display = 'block';
            p.disabled = false;
            de.disabled = false;
            t.className = "p1";
        }
    }


    function changeDstPhase(n) {
        var p = devt.ge('dstEvaluator');
        devt.removeAllChildren(p);
        var phase = getPhase(dst_phases,n.value);
        if (phase) {
            var evals = phase.evaluators;
            for (var j = 0; j < evals.length; j++) {
                var o = devt.cea("OPTION", p);
                o.value = evals[j].id;
                o.innerHTML = evals[j].name;
            }
        }
    }

    function start() {
        buildCompletePhaseList();
    }
</script>
</head>
<body onload='start()'>
    <div id='container'>
    <div id='heading'>
        <table>
            <tr>
                <td></td>
                <td class='ht'>nVALUATE</td>
                <td></td>
            </tr>
        </table>
    </div>
        <div id='menu'>
            <?php
                if (Secure::CheckSecurity(SECURITY_ADMIN))
                    echo "<div class='d1'><a href='Admin.php'>ADMIN</a></div>";
                if (ESecure::IS_MODULE_SCORE() && Secure::CheckSecurity(SECURITY_EVALUATE))
                    echo "<div class='d1'><a href='Score'>SCORE</a></div>";
                if ((intval($devt_environment->getkey('MODULES')) & intval(MODULE_ROOM)) && (Secure::CheckSecurity(SECURITY_DATAROOM_VIEW)) )
                    echo "<div class='d1'><a href='DataRoom.php'>DATAROOM</a></div>";
            ?>
            <div class='d2'><a href='Me.php'><?php if ($user) echo $user['user_name'];?></a></div>
            <div style='clear: left;'></div>
        </div>
        <div id="main">
            <h1>SCORE MIGRATION</h1>
            <form method="post" action='<?php echo $selff;?>'>
                <div id="copy">
                    <div id="src" class="d1">
                        <h1>SCORE SOURCE</h1>
                        <p class="p1">SELECT THE SOURCE PHASE</p>
                        <select id="srcphases" name="srcphases" onchange="changeSrcPhase(this)"></select>
                        <div id="subset" class="d4">
                            <p id="evaltxt" class="p1 dis">EVALUATOR</p>
                            <select id="srcEvaluator" name="srcEvaluator" disabled></select>
                            <p id="evaltxt2" class="p2 dis">OR</p>
                            <input id="averagescores" type="checkbox" name="averagescores" onchange="selectAvgScores(this)" disabled /><span id="averagescorestxt" class="dis">COPY ALL AVERAGE SCORES</span>
                        </div>
                    </div>
                    <div id='opption' class='d1'>
                        <h1>OPTIONS</h1>
                        <input id="cpycomments" type="checkbox" name="cpycomments" checked />
                        <span id="cpycommentstxt" >COPY COMMENTS</span>
                    </div>
                    <div id="arr" class="d2">
                        <img src="images/LargeArrow.png" />
                    </div>
                    <div id="dest" class="d1">
                        <h1>SCORE DESTINATION</h1>
                        <div id="dstMessages">
                            <p class="p3">There a no enabled destination phases</p>
                            <p class="p3">A destination phase cannot be disabled or completed</p>
                        </div>
                        <div id="dstInputs">
                            <p class="p1">SELECT DESTINATION PHASE</p>
                            <select id="dstphases" name="dstphases" onchange="changeDstPhase(this)"></select>
                            <div id="subset2" class="d5">
                            <p id="evaltxt3" class="p1">EVALUATOR</p>
                            <select id="dstEvaluator" name="dstEvaluator"></select>
                            </div>
                            <div id="override">
                                <p class="cuation">USE FOLLOWING WITH CAUTION</p>
                                <input type="checkbox" name="override" /><span>OVERRIGHT ANY EXISTING SCORES</span>
                            </div>
                        </div>
                    </div>
                    <div class="d3">
                        <input type="submit" name="transfer" value="COPY SCORES" />
                        <?php echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}' />";?>
                    </div>
                </div>
            </form>
            <div id="messages">
                <?php
                if (strlen($strErr) > 0)
                    echo "<p class='msgerr'>{$strErr}</p>";
                if (strlen($strMsg) > 0)
                    echo "<p class='msgmsg'>{$strMsg}</p>";
                ?>
            </div>
        </div>
    </div>
</body>
</html>