<?php session_start(); ?>
<?php
require './includes/classEvalSecure.php';
require './includes/classEvalHelpers.php';
require './includes/classEvaluateDB.php';
require './includes/classFormList.php';
require './includes/classSiem.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
$SIEM = new devt\siem\siem($devt_environment->getkey("SIEMHOST"));

$SEC = new ESecure();
//Helpers
$helpers = new helpers();

$selff = htmlspecialchars($_SERVER["PHP_SELF"]);
$instancename = $devt_environment->getkey("DATABASE_NAME");

$_SESSION['returnto'] = $selff;

$_DEBUG = false;

$global = $DB->getGlobal();
ESecure::CheckPage(SECURITY_ADMIN);
$user = $DB->getUser($_SESSION['userid']);
ESecure::CheckUser($user);

$max_current_evaluation_score = null;


function var_error_log( $object=null ,$text='')
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( "{$text} {$contents}" );        // log contents of the result of var_dump( $object )
}

function debugState()
{
    global $_DEBUG;

    if ($_DEBUG)
    {
        $bt = debug_backtrace();
        $caller = array_shift($bt);
        $p = "NULL";
        $s = "NULL";

        if (isset($_SESSION['progress']))
            $p = $_SESSION['progress'];
        if (isset($_SESSION['subprogress']))
            $s = $_SESSION['subprogress'];
        error_log("Progress/SubProgress State [{$caller['line']}] {$p}/{$s}");
    }
}

function buildForm($config,$row)
{
    global $DB;
    global $evaluation;
    global $helpers;

    $FL = $config ['FL'];
    $config = $config ['config'];

    $grp = '';
    $keys = array_keys($config['fields']);
    for ($idx = 0; $idx < count($keys); $idx++)
    {
        $item = $config['fields'] [$keys[$idx]];

        //Check item security
        $security = SECURITY_MAX;
        if (isset($item['security']) )
            $security = $item['security'];

        if (Secure::CheckSecurity($security))
        {
            //Is this a new group
            if (isset($item['group']) )
            {
                if ($grp != $item['group'])
                {
                    if (strlen($grp) > 0)
                    {
                        //Do we need to end previous group
                        echo "</div>";
                    }
                    $grp = $item['group'];
                    echo "<div class='indent1'>";
                    if (isset($config['groups'] [$grp]))
                    {
                        $g = $config['groups'] [$grp];
                        if (isset($g['grpname']))
                        {
                            echo "<p class='p3'>".$g['grpname']."</p>";
                        }
                    }
                }
            }
            else
                if (strlen($grp) > 0)
                {
                    echo "</div>";
                    $grp = '';
                }

            if (isset($item['heading']) )
            {
                echo "<p class='p2'>";
                if (isset($item['req']) && $item['req'])
                    echo "* ";
                echo $item['heading'];
                echo "</p>";


            }
            $FL->dispFormField($keys[$idx],$row,$DB);
        }
    }

    if ($config['database'] ['tablename'] == 'user')
    {
        //We need to add some more items
        echo "<div id='phases'>";
        echo "<p>PHASES</p>";
        if ($evaluation)
            $r9 = $DB->allPhasesForEval($evaluation['idevaluation'],'order by phase_order');
        else
            $r9 = $DB->allPhases('order by idphase');

        while ($phase = $r9->fetch_array())
        {
            echo "<p class='p2'>{$phase['phase_name']}</p>";
            echo "<input type='checkbox' name='phase[]' value='{$phase['idphase']}' ";
            if ($row && $DB->userHasPhase($row['iduser'],$phase['idphase']) )
                echo "checked";
            echo " />";
        }
        echo "</div>";
    }

    if ($row)
    {
        if (isset($config['formglobals'] ['changebutton']))
            $changename = $config['formglobals'] ['changebutton'];
        else
            $changename = "CHANGE";

        echo "<input type='submit' name='change' value='{$changename}'/>";
        $val = $FL->encryptParam("val={$row[$config['database'] ['id']]}");
        echo "<input type='hidden' name='newid' value='{$val}'/>";
    }
    else
    {
        if (isset($config['formglobals'] ['createbutton']))
            $createname = $config['formglobals'] ['createbutton'];
        else
            $createname = "CREATE";
        echo "<input type='submit' name='create' value='{$createname}'/>";
    }
    echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}'>";
    echo "<input type='hidden' name='__tablename__', value='{$config['database'] ['tablename']}'>";

    if ($config['database'] ['tablename'] == 'user')
    {
        //We do not allow create from here.
        $_SESSION['progress'] = 6;
        $_SESSION['subprogress'] = 0;
    }
}


function addConfig($configdata)
{
    global $configuration;
    $name = $configdata ['database'] ['tablename'];
    $configuration[$name] = array();
    $configuration[$name] ['config'] = $configdata;
    $configuration[$name] ['FL'] = new FormList($configdata);
}

//Globals
$newusers = array();
$configuration = array();
$row = null;
$evaluation = null;
$max_evaluations = max(intval($devt_environment->getkey("LIMIT2")),1);
$num_evaluations = $DB->numOfEvaluations();

addConfig(require('./config/evaluation-config.php'));
addConfig(require('./config/rule-config.php'));
addConfig(require('./config/phase-config.php'));
addConfig(require('./config/user2-config.php'));
addConfig(require('./config/team-config.php'));
addConfig(require('./config/respondent-config.php'));
addConfig(require('./config/section-config.php'));
addConfig(require('./config/question-config.php'));
addConfig(require('./config/subattribute-config.php'));

debugState();

if (isset($_GET['e']))
{
    $whichev = intval($_GET['e']);
    if ($whichev > 0)
    {
        $_SESSION['current_evaluation'] = $_GET['e'];
        $_SESSION['progress'] = 2;
        $_SESSION['subprogress'] = 0;
    }
    else
    {
        $_SESSION['current_evaluation'] = 0;
        $_SESSION['progress'] = 1;
        $_SESSION['subprogress'] = 0;
    }
    header("Location: {$selff}");
    exit();
}

if (isset($_SESSION['current_evaluation']) && $_SESSION['current_evaluation'] != 0)
{
    $evaluation = $DB->getEvaluation($_SESSION['current_evaluation']);

    if (!$evaluation)
        $_SESSION['current_evaluation'] = 0;
    else
    {
        debugState();

        if (isset($_SESSION['progress']) &&  $_SESSION['progress'] < 1)
        {
            $_SESSION['progress'] = 2;
            $_SESSION['subprogress'] = 0;
        }

        if (isset($_GET['prog']))
        {
            $_SESSION['progress'] = intval($_GET['prog']);
            $_SESSION['subprogress'] = 0;
            debugState();
            header("Location: {$selff}");
            exit();
        }

        if (isset($_GET['v']))
        {
            $query = $helpers->decryptQueryString($_GET['v']);

            if (isset($query['p'])) $_SESSION['progress'] = intval($query['p']);
            if (isset($query['s'])) $_SESSION['subprogress'] = intval($query['s']);
            if (isset($query['t']) && isset($query['k']) && isset($query['r']) )
                $row = $DB->getFromTable($query['t'],$query['k'],$query['r']);
            else
                $row = null;
        }
        if (isset($_GET['us']))
        {
            $_SESSION['progress'] = 6;
            $_SESSION['subprogress'] = 1;
            $row = $DB->getUser($_GET['us']);
        }
    }
}
else
{
    debugState();
    if (isset($_GET['v']))
    {
        $query = $helpers->decryptQueryString($_GET['v']);

        if (isset($query['p'])) $_SESSION['progress'] = intval($query['p']);
        if (isset($query['s'])) $_SESSION['subprogress'] = intval($query['s']);
        if (isset($query['t']) && isset($query['k']) && isset($query['r']) )
            $row = $DB->getFromTable($query['t'],$query['k'],$query['r']);
        else
            $row = null;
    }

    if  ($num_evaluations == 0)
    {

        if (isset($_SESSION['progress']))
        {
            if ($_SESSION['progress'] != 1 )
            {
                $_SESSION['progress'] = 1;
                $_SESSION['subprogress'] = 0;
                header("Location: {$selff}");
                exit();
            }
        }
        else
        {
            $_SESSION['progress'] = 1;
            $_SESSION['subprogress'] = 0;
            header("Location: {$selff}");
            exit();
        }
    }
    if (isset($_GET['prog']))
    {
        $_SESSION['progress'] = intval($_GET['prog']);
        $_SESSION['subprogress'] = 0;
        debugState();
        header("Location: {$selff}");
        exit();
    }

    if ($num_evaluations == 1)
    {
        $evaluation = $DB->getFirstEvaluation();
        if ($evaluation)
        {
            $_SESSION['current_evaluation'] = $evaluation['idevaluation'];
            $_SESSION['progress'] = 0;
            $_SESSION['subprogress'] = 0;
            header("Location: {$selff}");
            exit();
        }
    }
    elseif ($num_evaluations != 0)
    {
        $_SESSION['returnto'] = $selff;
        header("Location: ChooseEval.php");
        exit();
    }

}

if ($evaluation)
    $max_current_evaluation_score = $DB->maxScoreForEvaluation($evaluation['idevaluation']);

debugState();
//Final check that we have set progress and subprogress
if (!isset($_SESSION['progress']))
    $_SESSION['progress'] = 0;
if (!isset($_SESSION['subprogress']))
    $_SESSION['subprogress'] = 0;

$user = $DB->getUser($_SESSION['userid']);

//Debug on progress and subprogress
//error_log("Following is where we are with progress and subprogress status");
//var_error_log($_SESSION);


if ($_SERVER["REQUEST_METHOD"] == "POST")
{
    if (!Secure::checkCSRF())
    {
        $SIEM->createSecurityEntry("csrf",SECUITY_INVALID_CSRF,"minor",getenv("VAULT_SHELF"),"Invalid CSRF in Setup");
        $DB->createSecurityAudit($user,"Run.php [".__LINE__."] Failed CSRF check");
        header("Location: SecurityError.php");
        exit();
    }

    if (isset($_POST['__tablename__']))
    {
        if (isset($configuration[$_POST['__tablename__']]))
        {
            $selection = $configuration[$_POST['__tablename__']];


            $post_result = $helpers->handleFormPost($evaluation['idevaluation'],$selection ['config'],$selection ['FL']);
            if ($post_result['success'])
                exit();
        }
    }

    if (isset($_POST['assignquestions']))
    {
        $DB->deleteQuestionFromTeamsForAllEval($evaluation['idevaluation']);
        if (isset($_POST['qtoteam']) )
        {
            $qs = $_POST['qtoteam'];
            for ($i=0;$i<count($qs);$i++)
            {
                $q=$qs[$i];
                list($team,$question) = explode('Q',$q,2);
                $team = intval(substr($team,1,strlen($team)-1));
                $question = intval($question);
                $DB->createQuestionForTeam($team,$question);
            }
        }
        $_SESSION['progress'] = 9;
        $_SESSION['subprogress'] = 0;
    }

    if (isset($_POST['assignevaluators']))
    {
        $DB->deleteTeamHasUserForAllEvalTeam($evaluation['idevaluation']);
        if (isset($_POST['qtouser']) )
        {
            $tu = $_POST['qtouser'];
            for ($i=0;$i<count($tu);$i++)
            {
                $t=$tu[$i];
                list($teamid,$userid) = explode('U',$t,2);
                $teamid = intval(substr($teamid,1,strlen($teamid)-1));
                $userid = intval($userid);
                $DB->createUserForTeam($teamid,$userid);
            }
        }
        $_SESSION['progress'] = 10;
        $_SESSION['subprogress'] = 0;
    }

    if (isset($_POST['createEvaluators']))
    {
        $passwords = array();
        $fullnames = array();
        $usernames = array();
        $phases = array();

        if (isset($_POST['fullname']) ) $fullnames = $_POST['fullname'];
        if (isset($_POST['username']) ) $usernames = $_POST['username'];
        $cnt = 0;


        $phaseInput = $_POST['phase'];
        for ($i = 0; $i < count($phaseInput);$i++)
        {
            $line = intval(substr($phaseInput[$i],0,3)) ;
            $ph = intval(substr($phaseInput[$i],3,strlen($phaseInput[$i])-3));
            $phases[$line] [$ph] = true;
        }

        $num1 = count($fullnames);
        $num2 = count($usernames);
        if ($num1 == $num2)
        {
            for ($i = 0; $i < $num1; $i++)
            {
                if (strlen($fullnames[$i]) > 0 && strlen($usernames[$i]) > 0)
                {
                    $passwords[$i] = Secure::createRandomPW();

                    $newuser =  array();
                    $newuser['name'] = $fullnames[$i];
                    $newuser['username'] = $usernames[$i];
                    $newuser['password'] = $passwords[$i];
                    $newuser['error'] = false;

                    $salt = Secure::createSalt();
                    $hash = $SEC->passwordHash($passwords[$i],$salt);
                    $errors[$i] = false;
                    if ($DB->createUser($fullnames[$i],$usernames[$i],$hash,$salt,7,'Pacific/Auckland') )
                    {
                        $nuser = $DB->getUserByUserName($usernames[$i]);

                        $r = $DB->allPhasesForEval($evaluation['idevaluation'],'order by phase_order');
                        while ($phase = $r->fetch_array())
                        {
                            if (isset($phases[$i]) && isset($phases[$i] [$phase['idphase']]))
                                $DB->createPhaseForUser($nuser['iduser'],$phase['idphase']);
                        }
                    }
                    else
                    {
                        $newuser['error'] = true;
                    }
                    array_push($newusers,$newuser);
                }
            }
        }
        $_SESSION['progress'] = 6;
        $_SESSION['subprogress'] = 2;
    }
}
$_SESSION['returnto'] = $selff;
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta name="viewport" content="width=device-width" />
    <meta name="viewport" content="initial-scale=1.0" />
    <title>ADMIN</title>
    <link id="myicon" rel="icon" type="image/png" href="images/Icon1.png" />
    <link href="css/Base.css" rel="stylesheet">
    <link href="css/Tasks.css" rel="stylesheet">
    <link href="css/Details.css" rel="stylesheet">
    <style>
        #main {display: flex;}
        #evaluationform {display: none;}
        #ruleform {display: none;}
        #phaseform {display: none;}
        #sectionform {display: none;}
        #questionform {display: none;}
        #subattributeform {display: none;}
        #teamform {display: none;}
        #respondentform {display: none;}
        #batchload {display: none; margin-left: 20px;}
        #batchload input {font-size: 10pt;}
        #loaderr {margin-left: 20px; padding: 10px; border: solid 1px #777; border-radius: 5px;}
        #validate {display: none;}
        #preval {margin: 20px;margin-top: 0;} 
        #preval h2 {margin: 0;font-family: 'Roboto';font-size: 12pt;font-weight: 400;color: #333;padding-bottom: 20px;} 
        #preval h3 {margin: 0; margin-left: 10px; font-family: 'Roboto';font-size: 12pt;font-weight: 400;color: #333;} 
        #preval h4 {margin: 0; margin-left: 20px; font-family: 'Roboto'; font-size: 10pt; font-weight: 400; color: #333;}
        #preval p.plvl3 {margin-left: 20px; margin-top: 0px; margin-bottom: 0;}
        #preval p.plvl4 {margin-left: 30px; margin-top: 0px; margin-bottom: 0;}
        #vieweval {display: none;}
        #vieweval h2.noq {margin-left: 20px;margin-right: 20px; font-family: 'Roboto'; color: #555}
        #vieweval tr:nth-child(even) {background-color: inherit;}
        #vieweval tr:hover {background-color: inherit;}
        #vieweval td.tdhd1 {font-family: 'Roboto';font-size: 11pt;text-transform: uppercase;font-weight: bold;color: #666;}
        #vieweval td.td1 {min-width: 50px;vertical-align: top;font-family: 'Roboto';font-size: 10pt;font-weight: bold;color: #555;}
        #vieweval td.td3 {vertical-align: top;font-size: 10pt;}
        #vieweval td.td4 {vertical-align: top;font-size: 10pt;}
        #vieweval td.td4 p {margin-top: 0;}
        #evaluators {display: none;}
        #evallist {display: none;}
        #evalform1 {display: none;}
        #evalform2 {display: none;}
        #evalform3 {display: none;}
        #evalform1 input {font-size: 12pt; margin-bottom: 6px;}
        #evalform1 tr.tr1 {height: 12px;}
        #evalform1 tr:nth-child(even) {background-color: inherit;}
        #qtoteams {display: none;}
        #etoteams {display: none;}
        #qtoteams td.td1 {font-family: 'Roboto';font-size: 10pt;font-weight: bold;color: #555;text-transform: uppercase;}
        #qtoteams input[type='checkbox'] {display: inherit; margin-bottom: 0;font-size: inherit;}
        #qtoteams tr:nth-child(even) {background-color: inherit;}
        #qtoteams h2.noq {margin-left: 20px;margin-right: 20px; font-family: 'Roboto'; color: #555}
        #etoteams1 {margin-left: 30px;margin-right: 30px;}
        #etoteams1 td.td1 {font-family: 'Roboto';font-size: 10pt;font-weight: bold;color: #555;text-transform: uppercase;}
        #etoteams1 input[type='checkbox'] {display: inherit; margin-bottom: 0;font-size: inherit;}
        #etoteams1 tr:nth-child(even) {background-color: inherit;}
        #etoteams h2.noq {margin-left: 20px;margin-right: 20px; font-family: 'Roboto'; color: #555}
        tr.qclass {display: none;}
        .r {text-align: right;}
        .formError {color: red;}
        @media print {
            body {background-color: #ffffff;}
            #heading {display: none;}
            #tasks {display: none;}
            #menu {display: none;}
            #main {margin: 30px;border: none;border-radius: 0px;background-color: #ffffff;padding: 10px;box-shadow: 0px 0px 0px #ffffff;}
            #evalform2 tr:nth-child(even) {background-color: inherit;}
            button {display: none;}
        }

    </style>
    <script type="text/javascript" src="apievaljsonv1.php?r=/<?php echo $user['user_apikey'];?>/devtscript/<?php echo $instancename;?>/devtcore&formtoken=<?php echo urlencode($_SESSION['csrf_key']);?>"></script>
    <script type="text/javascript" src="apievaljsonv1.php?r=/<?php echo $user['user_apikey'];?>/devtscript/<?php echo $instancename;?>/eval&formtoken=<?php echo urlencode($_SESSION['csrf_key']);?>"></script>
    <script>
        var apireplies = { 'setvariable': 'nullFunction' };
        var g_maxCurrentEvalScore = <?php if ($max_current_evaluation_score !== null) echo $max_current_evaluation_score; else echo 'null';?>;
        eval.init('<?php echo $_SERVER['HTTP_HOST']?>','apievaljsonv1.php?r=','<?php echo $user['user_apikey']; ?>', false,apireplies);
        eval.selfurl = '<?php echo $selff;?>';
        eval.maxevaluators = <?php echo intval($devt_environment->getkey("LIMIT1"));?>;
        eval.numevaluators = <?php echo $DB->countEvaluators(); ?>;
        function nullFunction(d) { }
        var thispage = 'setup';
        <?php   debugState(); ?>
        var progress = <?php echo $_SESSION['progress'];?>;
        var subprogress = <?php echo $_SESSION['subprogress'];?>;
        var evaluations = [<?php 
        $bone = false;
        $r = $DB->allEvaluations('order by evaluation_name');
        while ($evl = $r->fetch_array())
        {
            if ($bone) echo ",";
            echo "{id:{$evl['idevaluation']},name:'{$evl['evaluation_name']}'}";
            $bone = true;
        }    
        ?>];
        <?php
        echo "var phases = [";
        $bone = false;
        $r = $DB->allPhasesForEval($evaluation['idevaluation'],'order by phase_order');
        while ($phase = $r->fetch_array())
        {
            if ($bone)
                echo ",";
            echo "{id:" . $phase['idphase'] . ",name:'" . $phase['phase_name'] . "'}";
            $bone = true;
        }
        echo "];\n";
        ?>
        <?php 
        echo "var newu = [";
        $bb = false;
        for ($i=0;$i < count($newusers);$i++)
        { 
            if (!$newusers[$i] ['error']) 
            { 
                if ($bb) 
                    echo ",";
                echo "{name: '" . $newusers[$i] ['name'] . "', username: '" . $newusers[$i] ['username'] . "', password: '" . $newusers[$i] ['password'] . "'}";
                $bb = true;
            }
        }
        echo "];";
        ?>
        function chooseEval(v) {
            window.location = '<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>?e=' + v;
        }
        
        function printit() {
            window.print();
        }
        
        function copytoclip(n) {
            var txt = '';
            for(var i =0; i < newu.length;i++) {
                txt += (newu[i].name + ' ');    
                txt += (newu[i].username + ' ');    
                txt += (newu[i].password + '\n');     
            }
            devt.copyclip(txt);
        }

        function f_createnew() {
            window.location = "CreateEval.php";
        }

        function sectionsel(n) {
            var team = parseInt(devt.ga(n, "team"));
            var section = parseInt(devt.ga(n, "section"));
            var trs = document.getElementsByClassName('qclass');
            //We need to find all section questions
            var inps = document.getElementsByClassName('qcheck');
            for (var i = 0; i < inps.length; i++) {
                if (parseInt(devt.ga(inps[i], "section")) == section && parseInt(devt.ga(inps[i], "team")) == team) {
                    if (n.checked)
                        inps[i].checked = true;    
                    else
                        inps[i].checked = false;
                }
            }
        }

        function qselect(n) {
            var team = parseInt(devt.ga(n, "team"));
            var section = parseInt(devt.ga(n, "section"));
            var inps = document.getElementsByClassName('qcheck');
            var allChecked = true;
            for (var i = 0; i < inps.length; i++) {
                if (parseInt(devt.ga(inps[i], "section")) == section && parseInt(devt.ga(inps[i], "team")) == team) {
                    if (!inps[i].checked)
                        allChecked = false;
                }
            }
            //Now find the section marker
            var secs = document.getElementsByClassName('sectcheck');
            for (var i = 0; i < secs.length; i++) {
                if (parseInt(devt.ga(secs[i], "section")) == section && parseInt(devt.ga(secs[i], "team")) == team) {
                    if (allChecked)
                        secs[i].checked = true;
                    else
                        secs[i].checked = false;
                }
            }
        }

        function qdropper(n) {
            if (!devt.def(n.devtstate))
                n.devtstate = 0;
            var team = parseInt(devt.ga(n, "team"));
            var section = parseInt(devt.ga(n, "section"));
            var trs = document.getElementsByClassName('qclass');
            if (n.devtstate == 0) {
                n.devtstate = 1;
                n.src = "/images/Selected.png";
            }
            else {
                n.devtstate = 0;
                n.src = "/images/Unselected.png";
            }
            for (var i = 0; i < trs.length; i++) {
                if (parseInt(devt.ga(trs[i], "section")) == section && parseInt(devt.ga(trs[i], "team")) == team) {
                    if (n.devtstate == 1)
                        trs[i].style.display = 'table-row';
                    else
                        trs[i].style.display = 'none';
                }
            }
        }

        function checkRuleMax(n) {
            if (g_maxCurrentEvalScore !== null) {
                if (parseInt(n.value) < g_maxCurrentEvalScore )  {
                    if (!confirm("***WARNING*** The maximum value currently scored, is above what you are attempting to set for this rule.  Press OK to accept your new value or CANCEL to set to the current maximum") )
                        n.value = g_maxCurrentEvalScore;
                }
            }
        }

        function start() {
            eval.setCurrentAction();
            if (progress == 6 && subprogress == 3)
            {
                eval.lineCnt = 0;
                eval.addEvaluatorLine();
                eval.addEvaluatorLine();
            }
        }
    </script>
</head>
<body onload='start()'>
  <div class="container">
    <div id='heading'>
        <table>
            <tr><td></td><td class='ht'>nVALUATE</td><td></td></tr>
        </table>
    </div>
    <div id='menu'>
        <div class='d1'><a href='Admin.php'>ADMIN</a></div>
        <div class='d1 sel'>SETUP</div>
        <div class='d1'><a href='Run.php?prog=0'>RUN</a></div>
        <div class='d1'><a href='Maintenance.php?prog=2'>MAINTENANCE</a></div>
        <div class='d1'><a href="Signout.php">SIGN OUT</a></div>
       <?php
        if (ESecure::IS_MODULE_SCORE() && Secure::CheckSecurity(SECURITY_EVALUATE) )
            echo "<div class='d1'><a href='Score'>SCORE</a></div>";
        ?>
        <?php 
            if (ESecure::IS_MODULE_ROOM())
                echo "<div class='d1'><a href='DataRoom.php'>DATAROOM</a></div>";
        ?>
        <div class='d2'>
            <a href='Me.php'><?php if ($user) echo $user['user_name'];?></a>
        </div>
        <div class='clear'></div>
    </div>
    <div id='main'>
        <div id='tasks'>
            <h1>SETUP TASKS</h1>
            <div id="whateval">
                <?php
                if ($evaluation)
                {
                    echo "<h2>{$DB->displayText($evaluation['evaluation_name'],'UPPER')}</h2>";
                }
                if($num_evaluations > 1)
                {
                    echo "<button onclick='window.location=\"ChooseEval.php\"'>SELECT ANOTHER</button>";
                }
                if ($num_evaluations < $max_evaluations)
                {
                    echo "<button onclick='f_createnew()'>CREATE NEW</button>";
                }
                ?>
            </div>
            <table>
                <?php
                if ($evaluation)
                {
                    //echo "<tr><td class='progger' prog='0'></td><td colspan='3'><span class='anchor' onclick='devt.tselect(this,evaluations,chooseEval,\"EDIT AND CREATE\")'>{$DB->displayText($evaluation['evaluation_name'],'UPPER')}</span></td></tr>";
                    $qs = $helpers->encryptQueryString("p=1&s=1&t=evaluation&k=idevaluation&r={$evaluation['idevaluation']}");


                    echo "<tr><td></td><td class='progger' prog='1'></td><td colspan='2' onclick='window.location=\"Setup.php?v={$qs}\"'><span class='anchor' prog='1'>EDIT EVALUATION</span></td></tr>";
                    //echo "<tr><td></td><td class='progger' prog='1'></td><td colspan='2' onclick='eval.changeProgress(1)'><span class='anchor'>EDIT EVALUATION</span></td></tr>";
                    echo "<tr><td></td><td class='progger' prog='2'></td><td colspan='2' onclick='eval.changeProgress(2)'><span class='anchor' prog='2'>RULES</span></td></tr>";
                    echo "<tr><td></td><td class='progger' prog='3'></td><td colspan='2' onclick='eval.changeProgress(3)'><span class='anchor' prog='3'>PHASES</span></td></tr>";
                    echo "<tr><td></td><td class='progger' prog='4'></td><td colspan='2' onclick='eval.changeProgress(4)'><span class='anchor' prog='4'>BATCH LOAD</span></td></tr>";
                    echo "<tr><td></td><td></td><td class='progger tdindent1' prog='12'></td><td onclick='eval.changeProgress(12)'><span class='anchor' prog='12'>SECTIONS</span></td></tr>";
                    echo "<tr><td></td><td></td><td class='progger tdindent1' prog='13'></td><td onclick='eval.changeProgress(13)'><span class='anchor' prog='13'>QUESTIONS</span></td></tr>";
                    echo "<tr><td></td><td></td><td class='progger tdindent1' prog='14'></td><td onclick='eval.changeProgress(14)'><span class='anchor' prog='14'>SUB ATTRIBUTES</span></td></tr>";
                    echo "<tr><td></td><td class='progger' prog='5'></td><td colspan='2' onclick='eval.changeProgress(5)'><span class='anchor' prog='5'>VIEW EVALUATION</span></td></tr>";
                    echo "<tr><td></td><td class='progger' prog='6'></td><td colspan='2' onclick='eval.changeProgress(6)'><span class='anchor' prog='6'>EVALUATORS</span></td></tr>";
                    echo "<tr><td></td><td class='progger' prog='7'></td><td colspan='2' onclick='eval.changeProgress(7)'><span class='anchor' prog='7'>TEAMS</span></td></tr>";
                    echo "<tr><td></td><td class='progger' prog='8'></td><td colspan='2' onclick='eval.changeProgress(8)'><span class='anchor' prog='8'>ASSIGN QUESTIONS TO TEAMS</span></td></tr>";
                    echo "<tr><td></td><td class='progger' prog='9'></td><td colspan='2' onclick='eval.changeProgress(9)'><span class='anchor' prog='9'>ASSIGN EVALUATORS TO TEAMS</span></td></tr>";
                    echo "<tr><td></td><td class='progger' prog='10'></td><td colspan='2' onclick='eval.changeProgress(10)'><span class='anchor' prog='10'>RESPONDENTS</span></td></tr>";
                    echo "<tr><td></td><td class='progger' prog='11'></td><td colspan='2' onclick='eval.changeProgress(11)'><span class='anchor' prog='11'>VALIDATE</span></td></tr>";
                }
                else
                {
                    if ($num_evaluations > 0)
                    {
                        echo "<tr><td class='progger' prog='0'></td><td colspan='3'><span class='anchor' onclick='devt.tselect(this,evaluations,chooseEval,\"EDIT AND CREATE\")'>CHOOSE EVALUATION</span></td></tr>";
                    }
                    else
                    {
                        echo "<tr><td  class='progger' prog='1'></td><td colspan='1'><span class='anchor'>CREATE EVALUATION</span></td></tr>";
                    }
                }
                ?>
            </table>
        </div>
        <div id='details'>
            <?php
            $helpers->buildDefaultForm($configuration,'evaluation',1,$row);
            $helpers->buildDefaultForm($configuration,'rule',2,$row);
            $helpers->buildDefaultForm($configuration,'phase',3,$row);
            $helpers->buildDefaultForm($configuration,'section',12,$row);
            $helpers->buildDefaultForm($configuration,'question',13,$row);
            $helpers->buildDefaultForm($configuration,'subattribute',14,$row);
            $helpers->buildDefaultForm($configuration,'team',7,$row);
            $helpers->buildDefaultForm($configuration,'respondent',10,$row);
            ?>
           <div id='batchload' class='righty'>
                <h1>BATCH LOAD</h1>
                    <form method="post" enctype='multipart/form-data' action="Load.php">
                        <input type='file' name='files' id='files' accept=".csv" onchange="eval.fileCheck(this,'submitload')" /><br/>
                        <input style="display: inline-block" type="checkbox" name="textonly" /><span>TEXT ONLY - LOAD QUESTION AND GUIDANCE TEXT ONLY</span><br/> 
                        <p>WARNING: A load will remove all questions from teams and all existing scores are removed if TEXT ONLY is not checked.</p>
                        <input id='submitload' type='submit' name='submit' value='LOAD' onclick="eval.cursorWait(this)" disabled/>
                    </form>
                    <?php
                        if (isset($_SESSION['loaderror']) )
                        {
                            echo "<div id='loaderr'>";
                                echo "<h1>LOAD ERRORS</h1>";
                                echo $_SESSION['loaderror'];
                            echo "</div>";
                            unset($_SESSION['loaderror']);
                        }
                    ?>
           </div>
           <div id='vieweval' class='righty'>
               <?php
                if ($_SESSION['progress'] == 5)
                {
                    //Is there any questions and or sections for the evaluation
                    if ($DB->numOfSectionsForEval($evaluation['idevaluation']) > 0 || $DB->numOfQuestionsForEval($evaluation['idevaluation']) )
                    {
                        echo "<table>";
                        $r = $DB->allSectionsForEval($evaluation['idevaluation'],'order by section_order');
                        while ($section = $r->fetch_array(MYSQLI_ASSOC))
                        {
                            echo "<tr><td class='tdhd1' colspan='5'>{$section['section_name']}</td></tr>";
                            echo "<tr><td class='tdw1'></td><td colspan='2'>QUESTIONS</td></tr>";
                            $r1 = $DB->allQuestionsForSection($section['idsection'],'order by question_order');
                            while ($question = $r1->fetch_array(MYSQLI_ASSOC))
                            {
                                if ($question["idquestion"] == 1)
                                {
                                    $hex = bin2hex($question['question_text']);
                                    error_log("Hex: {$hex}");
                                }



                                $strWeighting = number_format($question['question_weighting'] * 100.0,2) . "%";
                                echo "<tr><td class='tdw1'></td><td class='td1'>{$question['question_identifier']}</td><td class='td3'>{$strWeighting}</td><td class='td4' colspan='2'>{$question['question_text']}</td></tr>";
                                $r2 = $DB->allSubForQuestion($question['idquestion'],'order by subattribute_number');
                                while ($sub = $r2->fetch_array(MYSQLI_ASSOC))
                                {
                                    echo "<tr><td class='tdw1'></td><td class='tdw1'></td><td class='tdw1'></td><td class='td3'>{$sub['subattribute_number']}</td><td class='td3'>{$sub['subattribute_txt']}</td></tr>";
                                }
                            }
                        }
                        echo "</table>";
                    }
                    else
                    {
                        echo "<h2 class='noq'>Evaluation has no Questions</h2>";
                    }
                }
               ?>
           </div>
           <div id='evaluators' class='righty'>
                <h1>EVALUATORS</h1>
                <div id='evallist' class='sub listwin'>
                    <table>
                        <?php
                        if ($_SESSION['progress'] == 6)
                        {
                            echo "<tr><th>NAME</th><th>USERNAME</th>";
                            $r = $DB->allPhasesForEval($evaluation['idevaluation'],'order by phase_order');
                            while ($phase = $r->fetch_array())
                            {
                                $phasename = $DB->displayText($phase['phase_name']);
                                echo "<th>{$phasename}</th>";
                            }
                            echo "<th></th>";
                            echo "</tr>";
                            $r = $DB->allEvaluators('order by user_name');
                            //$r = $DB->allUsers('order by user_name');
                            while ($evaluator = $r->fetch_array(MYSQLI_ASSOC))
                            {
                                $name = $DB->displayText($evaluator['user_name']);
                                $username = $DB->displayText($evaluator['user_username']);
                                echo "<tr><td><a href='".$selff."?us=".$evaluator['iduser']."'>{$name}</a></td><td>{$username}</td>";
                                $r2 = $DB->allPhasesForEval($evaluation['idevaluation'],'order by phase_order');
                                while ($phase = $r2->fetch_array())
                                {
                                    echo "<td>";
                                    if ($DB->userHasPhase($evaluator['iduser'],$phase['idphase']) )
                                        echo "YES";
                                    echo "</td>";
                                }

                                $j = $helpers->encryptQueryString("t=user&k=iduser&i={$evaluator['iduser']}");
                                echo "<td class='tddel'><a href='Delete.php?j={$j}'><img src='images/Delete.png' title='Delete Evaluator'/></a></td>";
                                echo "</tr>";
                            }
                        }
                        ?>
                    </table>
                    <?php
                        $pr = $helpers->encryptQueryString("p=6&s=3");
                        echo "<button onclick='eval.gosomewhere(\"{$pr}\")'>CREATE</button>";
                    ?>
                </div>
                <div id='evalform1' class='sub'>
                    <?php
                    if ($_SESSION['progress'] == 6)
                    {
                        $r = $DB->allPhasesForEval($evaluation['idevaluation'],'order by phase_order');
                        if ($r->num_rows == 0)
                        {
                            echo "<p>Unable to create evaluators as there are no evalauation <span class= 'anchor' onclick='eval.changeProgress(3)'>phases</span> defined.</p>";
                        }
                        else
                        {
                            echo "<form method='post' action='{$selff}'>";
                                echo "<table id='tblnames'>";
                                    echo "<tr><th>NAME</th><th>USERNAME</th>";
                                    while ($phase = $r->fetch_array(MYSQLI_ASSOC))
                                    {
                                        echo "<th>{$DB->displayText($phase['phase_name'])}</th>";
                                    }
                                    echo "</tr>";
                                    echo "<tr class='tr1'></tr>";
                                    echo "</table>";
                                    echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}'>";
                                    echo "<input type='submit' name='createEvaluators' value='CREATE EVALUATORS'/>";
                            echo "</form>";
                        }
                    }
                    ?>
                </div>
                <div id='evalform2' class='sub'>
                    <table>
                        <tr><th>STATUS</th><th>NAME</th><th>USERNAME</th><th>PASSWORD</th></tr>
                        <?php
                            $cntok = 0;
                            for ($i = 0; $i < count($newusers); $i++)
                            {
                                echo "<tr>";
                                if (!$newusers[$i] ['error'])
                                {
                                    echo "<td>OK</td>";
                                    $cntok++;
                                }
                                else
                                    echo "<td>ERROR</td>";
                                echo "<td>{$DB->displayText($newusers[$i] ['name'])}</td>";
                                echo "<td>{$DB->displayText($newusers[$i] ['username'])}</td>";
                                if (!$newusers[$i] ['error'])
                                    echo "<td>{$DB->displayText($newusers[$i] ['password'])}</td>";
                                else
                                    echo "<td></td>";   
                                echo "</tr>";
                            }
                        ?>
                    </table>
                    <?php
                    if ($cntok > 0)
                        echo "<button onclick='printit()'>PRINT</button><button onclick='copytoclip(this)'>COPY</button>";
                    ?>
                </div>
                <div id='evalform3' class='sub'>
                    <?php
                    if ($_SESSION['progress'] == 6)
                    {
                        echo "<form method='post' action='{$selff}'>";
                        buildForm($configuration['user'],$row);
                        echo "</form>";
                    }
                    ?>
                </div>
           </div>
           <div id='qtoteams' class='righty'>
                <h1>ASSIGN QUESTIONS TO TEAMS</h1>
                <div id='qtoteams1' class='sub'>
                    <?php
                        if ($_SESSION['progress']  == 8)
                        {
                            //First check that we have some questions
                            if ($DB->numOfQuestionsForEval($evaluation['idevaluation']) > 0)
                            {
                                echo "<form method='post' action='{$selff}'>";
                                echo "<table>";
                                $r = $DB->allTeamsForEval($evaluation['idevaluation']);
                                while ($team = $r->fetch_array(MYSQLI_ASSOC))
                                {
                                    echo "<tr><td colspan='5' class='td1'>{$DB->displayText($team['team_name'])}</td></tr>";
                                    $r1 = $DB->allSectionsForEval($evaluation['idevaluation'],'order by section_order');
                                    while ($section = $r1->fetch_array(MYSQLI_ASSOC))
                                    {
                                        $section_checked = "";
                                        if ($DB->hasTeamAllQuestionsForSection($section['idsection'],$team['idteam']) )
                                            $section_checked = "checked ";


                                        echo "<tr><td></td><td><img team='{$team['idteam']}' section='{$section['idsection']}' src='images/Unselected.png'/ onclick='qdropper(this)'></td><td colspan='3'><input type='checkbox' class='sectcheck' team='{$team['idteam']}' section='{$section['idsection']}' onchange='sectionsel(this)'{$section_checked}/><span>SECTION {$DB->displayText($section['section_name'])}</span></td></tr>";
                                        $r2 = $DB->allQuestionsForSection($section['idsection'],'order by question_order');
                                        while ($question = $r2->fetch_array(MYSQLI_ASSOC))
                                        {
                                            $qtext = "";
                                            if (substr($question['question_text'],0,1) == "<")
                                            {
                                                $t = $question['question_text'];
                                                $dom = new DOMDocument();
                                                $dom->loadHTML("<html><body>{$t}</body></html>");
                                                $body = $dom->getElementsByTagName("body");
                                                if ($body->count() > 0)
                                                {
                                                    $ps = $body->item(0)->getElementsByTagName("p");
                                                    if ($ps->count() > 0)
                                                    {
                                                        $p = $ps->item(0);
                                                        $txt = trim($p->nodeValue);
                                                        $qtext = htmlspecialchars(substr($txt,0,100) . " ...");
                                                    }
                                                }
                                            }
                                            else
                                                $qtext = htmlspecialchars(substr($question['question_text'],0,100) . " ...");
                                            echo "<tr class='qclass' team='{$team['idteam']}' section='{$section['idsection']}'><td></td><td></td><td></td><td><input type='checkbox' class='qcheck' team='{$team['idteam']}' section='{$section['idsection']}' onchange='qselect(this)' name='qtoteam[]' value='T{$team['idteam']}Q{$question['idquestion']}'";
                                            if ($DB->hasTeamQuestion($team['idteam'],$question['idquestion']))
                                                echo " checked ";
                                            echo "/><span>{$question['question_identifier']}</span></td><td>{$qtext}</td></tr>";
                                        }
                                    }
                                }
                                echo "</table>";
                                echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}'>";
                                echo "<input type='submit' name='assignquestions' value='ASSIGN'\>";
                                echo "</form>";
                            }
                            else
                                echo "<h2 class='noq'>There are no questions to be assigned</h2>";
                        }
                    ?>
                </div>
           </div>
           <div id='etoteams' class='righty'>
                <h1>ASSIGN EVALUATORS TO TEAMS</h1>
                <div id='etoteams1' class='sub'>
                    <?php
                        if ($_SESSION['progress']  == 9)
                        {
                            //First check that we have some questions
                            if ($DB->numOfTeamsForEval($evaluation['idevaluation']) > 0)
                            {
                                echo "<form method='post' action='{$selff}'>";
                                echo "<table>";
                                $r = $DB->allTeamsForEval($evaluation['idevaluation'],"order by team_name");
                                while ($team = $r->fetch_array(MYSQLI_ASSOC))
                                {
                                    echo "<tr><td colspan='2' class='td1'>{$DB->displayText($team['team_name'])}</td></tr>";
                                    $r1 = $DB->allEvaluators('order by user_name');
                                    while ($evaluator = $r1->fetch_array(MYSQLI_ASSOC))
                                    {
                                        echo "<tr><td></td><td><input type='checkbox' name='qtouser[]' value='T{$team['idteam']}U{$evaluator['iduser']}'";
                                        if ($DB->hasTeamUser($team['idteam'],$evaluator['iduser']))
                                            echo " checked ";
                                        echo "/><span>{$evaluator['user_name']}</span></td></tr>";
                                    }
                               }
                                echo "</table>";
                                echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}'>";
                                echo "<input type='submit' name='assignevaluators' value='ASSIGN'\>";
                               echo "</form>";
                           }
                           else
                                echo "<h2 class='noq'>No teams have been configured.</h2>";

                        }
                    ?>
                </div>
           </div>
           <div id='validate' class='righty'>
                 <h1>VALIDATION</h1>
               <?php
                    if ($_SESSION['progress'] == 11)
                    {
                        //Perform prevalidation checks;
                        $res = $DB->preValidation($evaluation['idevaluation']);
                        if (!$res['status'])
                        {
                            echo "<div id='preval'>";
                                echo "<h2>Pre Validation failure</h2>";

                                if (!$res['weightings'] ['status'] )
                                {
                                    if (!$res['weightings'] ['questions']['status'] )
                                    {
                                        echo "<h3>Question Weightings</h3>";
                                        echo "<p class='plvl3'>{$res['weightings'] ['questions'] ['error']}</p>";
                                    }
                                    if (!$res['weightings'] ['subattributes']['status'] )
                                    {
                                        echo "<h3>Sub Attribute Weightings</h3>";
                                        for ($k = 0; $k < count($res['weightings'] ['subattributes']['errors']);$k++)
                                            echo "<p class='plvl3'>{$res['weightings'] ['subattributes']['errors'] [$k] }</p>";
                                    }
                                }

                                if (!$res['assigned_questions'] ['status'])
                                {
                                    echo "<h3>Question assignement</h3>";
                                    foreach($res['assigned_questions'] ['error'] as $err)
                                    {
                                        echo "<p class='plvl3'>{$err}</p>";
                                    }
                                }


                                if (!$res['respondents'] ['status'] )
                                {
                                    echo "<h3>Respondents</h3>";
                                    echo "<p class='plvl3'>{$res['respondents'] ['error']}</p>";
                                }


                                if (!$res['phases'] ['status'] )
                                {
                                    echo "<h3>Phases</h3>";
                                    echo "<div id='valphases'>";
                                    $phases = $res['phases'] ['phaseerrors'];

                                    for($p = 0; $p < count($phases);$p++)
                                    {
                                        echo "<h4>{$phases[$p] ['name']}</h4>";
                                        $errors = $phases[$p] ['errors'];
                                        if (count($errors) == 0)
                                            echo "<p class='plvl4'>NO ERRORS</p>";
                                        for ($i = 0; $i < count($errors);$i++)
                                        {
                                            echo "<p class='plvl4'>{$errors[$i]}</p>";
                                        }
                                    }
                                    echo "</div>";
                                }
                            echo "</div>";
                        }
                        else
                            echo "<h2>The evaluation validates - you are good to go.</h2>";
                    }
               ?>
           </div>
        </div>
        <div id='clear1'>
        </div>
        <?php unset($_SESSION['form_error'])?>
    </div>
  </div>
</body>
</html>
