<?php session_start(); ?>
<?php
require './includes/classSecure.php';
require './includes/classEvaluateDB.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
Secure::CheckPage(SECURITY_EVALUATE);

$user = $DB->getUser($_SESSION['userid']);
if (isset($_GET['p']))
{
    $a = Secure::decrypttoarray($_GET['p'],$_SESSION['session_key']);
    if ($a)
    {
        $DB->seUserPhase($user['iduser'],intval($a['phase']));
        header('Location: Score'); 
        exit();
    }
}

$evaluation = null;
if (isset($_SESSION['current_evaluation']) && $_SESSION['current_evaluation'] != 0)
{
    $evaluation = $DB->getEvaluation($_SESSION['current_evaluation']);
}

if (!$evaluation)
{
    header('Location: SetEval.php');
    exit();
}

?>
<!DOCTYPE HTML>
<html>
<head>
<meta name="viewport" content="width=device-width">
<meta name="viewport" content="initial-scale=1.0">
<link href="css/Base.css" rel="stylesheet">
<style>
body {font-family: Arial, Helvetica, sans-serif;font-size: 10pt;margin: 0;}
#container {margin: auto;}
#main {max-width: 1000px; margin: auto;padding-left: 50px; padding-bottom: 100px; margin-top: 20px;}
#main p {font-family: 'Roboto'; font-size: 12pt;}
</style>
<script>
function change(n){
    window.location.href = 'SetPhase.php?p=' + n.value;
}
</script>
</head>
<body>
<div id='container'>
    <div id='heading'>
        <table>
            <tr><td></td><td class='ht'>nVALUATE</td><td></td></tr>
        </table>
    </div>
    <div id='main'>
        <p>SELECT WHICH PHASE YOU WANT TO SCORE</p>
        <select onchange='change(this)'>
            <option></option>
            <?php 
                $r = $DB->phasesForUserForEvalEnabled($evaluation['idevaluation'],$user['iduser']);
                while ($phase = $r->fetch_array())
                {
                    $lk = Secure::encryptarray(["phase" => $phase['idphase']],$_SESSION['session_key']);
                    echo "<option value='{$lk}'>{$phase['phase_name']}</option>";
                }
            ?>
        </select>
    </div>
</div>
</body>
</html>