<?php session_start(); ?>
<?php
require './includes/classEnvironment.php';
require './includes/Security.php';

require './includes/classEvaluateDB.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());

if (!isSignedIn())
{
    //Check cookie
    $UserOK = false;
    if (isset($_COOKIE['SITEINFO']))
    {
        $user = $DB->getUserByCookie($_COOKIE['SITEINFO']);
        if ($user)
        {
            SetSessionData($user);
            $UserOK = true;
        }
    }
    if (!$UserOK)
        SigninAndRedirect();
}

if (!CheckSecurity(SECURITY_ADMIN) )
{
    header("Location: SecurityError.php");
    exit();
}

if (isset($_GET['n']))
{
    $_SESSION['current_evaluation'] = intval($_GET['n']);
    header('Location: Admin.php'); 
}

$user = $DB->getUser($_SESSION['userid']);

?>
<!DOCTYPE HTML>
<html>
<meta name="viewport" content="width=device-width">
<meta name="viewport" content="initial-scale=1.0">
<head>
<link href="css/Base.css" rel="stylesheet">
<style>
#maincontainer {max-width: 800px;margin: auto;}
#main p {margin-bottom: 0;font-size: 9pt;}
</style>
<script>
function change(n){
    window.location.href = 'SetEval.php?n=' + n.value;
}
</script>
</head>
<body>
<div id='container'>
    <div id='heading'>
        <table>
            <tr><td></td><td class='ht'>nVALUATE</td><td></td></tr>
        </table>
    </div>
    <div id='menu'>
        <div class='d1'><a href='Admin.php'>ADMIN</a></div>
        <div class='d1'><a href='Setup.php?prog=0'>SETUP</a></div>
        <div class='d1'><a href='Run.php?prog=0'>RUN</a></div>
        <div class='d1'><a href='Maintenance.php'>MAINTENANCE</a></div>
        <div class='d2'><?php if ($user) echo $user['user_name'];?></div>
        <div class='clear'></div>
    </div>
    <div id='maincontainer'>
        <div id='main'>
            <p>SELECT EVALUATION</p>
            <select onchange='change(this)'>
                <option></option>
                <?php 
                    $r = $DB->allEvaluations();
                    while ($evaluation = $r->fetch_array())
                    {
                        echo "<option value='{$evaluation['idevaluation']}'>{$evaluation['evaluation_name']}</option>";
                    }
                ?>
            </select>
        </div>
    </div>
</div>
</body>