<?php session_start(); ?>
<?php
require './includes/classEvalSecure.php';
require './includes/classEvalHelpers.php';
require './includes/classFormList.php';
require './includes/classSiem.php';
$phase_config = require('./config/phase-config.php');
$global_params = require('./config/parameters.php');
require './includes/classEvaluateDB.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
$SIEM = new devt\siem\siem($devt_environment->getkey("SIEMHOST"));

$helpers = new helpers();
$FL = new FormList(null);

$global = $DB->getGlobal();
ESecure::CheckPage(SECURITY_ADMIN);
$user = $DB->getUser($_SESSION['userid']);
ESecure::CheckUser($user);

$instancename = $devt_environment->getkey("DATABASE_NAME");

function var_error_log( $object=null ,$text='')
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( "{$text} {$contents}" );        // log contents of the result of var_dump( $object )
}

function responderheading()
{
    global $DB;
    global $evaluation;

    echo "<tr class='trheight3'></tr>";
    echo "<tr><td></td><td></td><td></td>";
    $r5 = $DB->allRespondentsForEval($evaluation['idevaluation'],'order by respondent_name_short');
    while ($resp = $r5->fetch_array(MYSQLI_ASSOC))
    {
        $str = $DB->displayText($resp['respondent_name_short']);
        echo "<td class='r'>{$str}</td>";
    }
    echo "</tr>";
}

function sectionTotal($n,$totl_section,$max_section,$weighted)
{
    echo "<tr><td></td><td></td><td class='tdtot' rowspan='2'>SECTION TOTAL</td>";
    for ($i = 0; $i < $n;$i++)
    {
        $str = $weighted ? number_format($totl_section[$i],3) : number_format($totl_section[$i],0);
        echo "<td class='tdtot1 r'>{$str}</td>";
    }
    echo "</tr>";

    echo "<tr><td></td><td></td>";
    for ($i = 0; $i < $n;$i++)
    {
        if ($max_section[$i] > 0)
        {
            $str = number_format(($totl_section[$i] / $max_section[$i])*100.0,3) . "%";
        }
        else
            $str = "0.000%";
        echo "<td class='tdtot2 r'>{$str}</td>";
        $totl_section[$i] = 0.0;
        $max_section[$i] = 0.0;
    }
    echo "</tr>";
}

function resultsTable($weighted=true)
{
    global $DB;
    global $evaluation;
    global $box;

    $n = $DB->numOfRespondents($evaluation['idevaluation']);
    $totcols3 = $n + 3;
    $totcols2 = $n + 2;
    $totcols1 = $n + 1;
    $totl_section = array();
    $max_section = array();
    $totl = array();
    $maxl = array();

    //All phases
    $r = $DB->allPhasesForEvalWithRule($evaluation['idevaluation'],'order by phase_order');
    if ($r->num_rows > 0)
    {
        echo "<table>";
        while ($phase = $r->fetch_array(MYSQLI_ASSOC))
        {
            //Reset the totals
            for ($i = 0; $i < $n;$i++)
            {
                $totl_section[$i] = 0.0;
                $max_section[$i] = 0.0;
                $totl[$i] = 0.0;
                $maxl[$i] = 0.0;
            }

            //Find the rule and max value for this phase
            $maxraw = $phase['rule_max'];

            $str = $DB->displayText($phase['phase_name']);
            if ($phase['phase_status'] == 'defined')
                $str .= " [Not Started]";
            echo "<tr><td colspan='{$totcols3}' class='td1'>{$str}</td></tr>";
            if ($phase['phase_status'] != 'defined')
            {
                $result = $DB->anyPhaseErrors($evaluation['idevaluation'],$phase['idphase']);
                if (!$result['status'])
                {
                    echo "<tr><td></td><td colspan='{$totcols2}' class='tdr1'>INCOMPLETE PHASE <span class='anchor1' onclick='eval.toggle(\"{$box}\")'>CLICK</span> FOR DETAILS</td></tr>";
                    echo "<tr><td></td><td></td><td><div id='box{$box}' class='errbox'>";
                    $box++;
                    $errors = $result['errors'];
                    for ($i = 0; $i < count($errors); $i++)
                    {
                        echo "<p class='perr'>";
                        echo $DB->displayText($errors[$i]);
                        echo "</p>";
                    }
                    echo "</div></td></tr>";
                }
                else
                {
                    echo "<tr><td></td><td colspan='{$totcols2}' class='tdr1'>NO EVALUATION ERRORS DETECTED</td></tr>";
                    if (!$phase['phase_single_score'])
                    {
                        echo "<tr><td></td><td colspan='{$totcols2}' class='tdr1'>SCORES ARE AVERAGED ACROSS MULTIPLE EVALUATORS</td></tr>";

                        //Now the headings
                        responderheading();
                        $lastsection = '';

                        $r2 = $DB->allQuestionsForEvalWithSection($evaluation['idevaluation'],'order by question_order');
                        while ($question = $r2->fetch_array(MYSQLI_ASSOC))
                        {
                            if ($question['section_name'] != $lastsection)
                            {
                                if (strlen($lastsection) != 0)
                                {
                                    sectionTotal($n,$totl_section,$max_section,$weighted);
                                    for ($i = 0; $i < $n;$i++)
                                    {
                                        $totl_section[$i] = 0.0;
                                        $max_section[$i] = 0.0;
                                    }

                                    responderheading();
                                }
                                $str = $DB->displayText($question['section_name']);
                                echo "<tr><td></td><td></td><td colspan='{$totcols1}'class='td2'>{$str}</td></tr>";
                                $lastsection = $question['section_name'];
                            }

                            $r3 = $DB->allSubForQuestion($question['idquestion']);
                            if ($r3->num_rows == 0)
                            {
                                echo "<tr><td></td><td></td><td>{$question['question_identifier']}</td>";
                                $r4 = $DB->allRespondentsForEval($evaluation['idevaluation'],'order by respondent_name_short');
                                $resp_idx = 0;
                                while ($resp = $r4->fetch_array(MYSQLI_ASSOC))
                                {
                                    $score = $DB->sumScores($evaluation['idevaluation'],$phase['idphase'],$resp['idrespondent'],$question['idquestion']);
                                    if ($score['COUNT'] > 0)
                                    {
                                        $w = intval(round(floatVal($score['SUM']) / floatVal($score['COUNT'])));
                                        $m = $maxraw;
                                        if ($weighted)
                                        {
                                            $w = $question['question_weighting'] * $w;
                                            $m = $question['question_weighting'] * $m;
                                        }
                                    }
                                    else
                                    {
                                        $w = 0.0;
                                        $m = 0.0;
                                    }
                                    $totl_section[$resp_idx] += $w;
                                    $max_section[$resp_idx] += $m;

                                    $totl[$resp_idx] += $w;
                                    $maxl[$resp_idx] += $m;
                                    $str = $weighted ? number_format($w,3) : number_format($w,0);
                                    echo "<td class='r'>{$str}</td>";
                                    $resp_idx++;
                                }
                                echo "</tr>";
                            }
                            else
                            {
                                while ($sub = $r3->fetch_array(MYSQLI_ASSOC))
                                {
                                    echo "<tr><td></td><td></td><td>{$question['question_identifier']}-{$sub['subattribute_number']}</td>";
                                    $resp_idx = 0;
                                    $r4 = $DB->allRespondentsForEval($evaluation['idevaluation'],'order by respondent_name_short');
                                    while ($resp = $r4->fetch_array(MYSQLI_ASSOC))
                                    {
                                        $score = $DB->sumScores($evaluation['idevaluation'],$phase['idphase'],$resp['idrespondent'],$question['idquestion'],$sub['idsubattribute']);
                                        if ($score['COUNT'] > 0)
                                        {
                                            $w = intval(round(floatVal($score['SUM']) / floatVal($score['COUNT'])));
                                            $m = $maxraw;
                                            if ($weighted)
                                            {
                                                $w = $question['question_weighting'] * $sub['subattribute_weighting'] * $w;
                                                $m = $question['question_weighting'] * $sub['subattribute_weighting'] * $m;
                                            }
                                        }
                                        else
                                        {
                                            $w = 0.0;
                                            $m = 0.0;
                                        }
                                        $totl_section[$resp_idx] += $w;
                                        $max_section[$resp_idx] += $m;

                                        $totl[$resp_idx] += $w;
                                        $maxl[$resp_idx] += $m;
                                        $str = $weighted ? number_format($w,3) : number_format($w,0);
                                        echo "<td class='r'>{$str}</td>";
                                        $resp_idx++;
                                    }
                                    echo "</tr>";
                                }
                            }
                        }
                        sectionTotal($n,$totl_section,$max_section,$weighted);
                        for ($i = 0; $i < $n;$i++)
                            $totl_section[$i] = 0.0;

                   }
                    else
                    {
                        //Now the headings
                        responderheading();
                        $lastsection = '';

                        $r2 = $DB->allQuestionsForEvalWithSection($evaluation['idevaluation'],'order by question_order');
                        while ($question = $r2->fetch_array(MYSQLI_ASSOC))
                        {
                            if ($question['section_name'] != $lastsection)
                            {
                                if (strlen($lastsection) != 0)
                                {
                                    sectionTotal($n,$totl_section,$max_section,$weighted);
                                    for ($i = 0; $i < $n;$i++)
                                    {
                                        $totl_section[$i] = 0.0;
                                        $max_section[$i] = 0.0;
                                    }

                                    responderheading();
                                }
                                $str = $DB->displayText($question['section_name']);
                                echo "<tr><td></td><td></td><td colspan='{$totcols1}' class='td2'>{$str}</td></tr>";
                                $lastsection = $question['section_name'];
                            }

                            $r3 = $DB->allSubForQuestion($question['idquestion']);
                            if ($r3->num_rows == 0)
                            {
                                echo "<tr><td></td><td></td><td>{$question['question_identifier']}</td>";
                                $r4 = $DB->allRespondentsForEval($evaluation['idevaluation'],'order by respondent_name_short');
                                $resp_idx = 0;
                                while ($resp = $r4->fetch_array(MYSQLI_ASSOC))
                                {
                                    $score = $DB->sumScores($evaluation['idevaluation'],$phase['idphase'],$resp['idrespondent'],$question['idquestion']);
                                    if ($score['COUNT'] > 0)
                                    {
                                        $w = intval(round(floatVal($score['SUM']) / floatVal($score['COUNT'])));
                                        $m = $maxraw;
                                        //$m = $score['COUNT'] * $maxraw;
                                        if ($weighted)
                                        {
                                            $w = $question['question_weighting'] * $w;
                                            $m = $question['question_weighting'] * $m;
                                        }
                                    }
                                    else
                                    {
                                        $w = 0.0;
                                        $m = 0.0;
                                    }
                                    $totl_section[$resp_idx] += $w;
                                    $max_section[$resp_idx] += $m;

                                    $totl[$resp_idx] += $w;
                                    $maxl[$resp_idx] += $m;
                                    $str = $weighted ? number_format($w,3) : number_format($w,0);
                                    echo "<td class='r'>{$str}</td>";
                                    $resp_idx++;
                                }
                                echo "</tr>";
                            }
                            else
                            {
                                while ($sub = $r3->fetch_array(MYSQLI_ASSOC))
                                {
                                    echo "<tr><td></td><td></td><td>{$question['question_identifier']}-{$sub['subattribute_number']}</td>";
                                    $resp_idx = 0;
                                    $r4 = $DB->allRespondentsForEval($evaluation['idevaluation'],'order by respondent_name_short');
                                    while ($resp = $r4->fetch_array(MYSQLI_ASSOC))
                                    {
                                        $score = $DB->sumScores($evaluation['idevaluation'],$phase['idphase'],$resp['idrespondent'],$question['idquestion'],$sub['idsubattribute']);
                                        if ($score['COUNT'] > 0)
                                        {
                                            $w = intval(round(floatVal($score['SUM']) / floatVal($score['COUNT'])));
                                            $m = $maxraw;
                                            //$m = $score['COUNT'] * $maxraw;
                                            if ($weighted)
                                            {
                                                $w = $question['question_weighting'] * $sub['subattribute_weighting'] * $w;
                                                $m = $question['question_weighting'] * $sub['subattribute_weighting'] * $m;
                                            }
                                        }
                                        else
                                        {
                                            $w = 0.0;
                                            $m = 0.0;
                                        }
                                        $totl_section[$resp_idx] += $w;
                                        $max_section[$resp_idx] += $m;

                                        $totl[$resp_idx] += $w;
                                        $maxl[$resp_idx] += $m;
                                        $str = $weighted ? number_format($w,3) : number_format($w,0);
                                        echo "<td class='r'>{$str}</td>";
                                        $resp_idx++;
                                    }
                                    echo "</tr>";
                                }
                            }
                        }
                       sectionTotal($n,$totl_section,$max_section,$weighted);
                       for ($i = 0; $i < $n;$i++)
                           $totl_section[$i] = 0.0;

                    }
                }
                //Totals for phase
                echo "<tr class='trheight1'></tr>";
                echo "<tr class='grandtotal'><td></td><td></td><td class='tdtot' rowspan='2'>TOTAL SCORE</td>";
                for ($i = 0; $i < $n;$i++)
                {
                    $str = $weighted ? number_format($totl[$i],3) : number_format($totl[$i],0);
                    echo "<td class='tdtot1 r'>{$str}</td>";
                }
                echo "</tr>";

                echo "<tr class='grandtotal'><td></td><td></td>";
                for ($i = 0; $i < $n;$i++)
                {
                    if ($maxl[$i] > 0)
                        $v = ($totl[$i] / $maxl[$i]) * 100;
                    else
                        $v = 00;
                    $str = number_format($v,3) . "%";
                    echo "<td class='tdtot2 r'>{$str}</td>";
                    $totl[$i] = 0.0;
                    $maxl[$i] = 0.0;
                }
                echo "</tr>";
                echo "<tr class='trheight2'></tr>";
            }
        }
        echo "</table>";
    }
    else
        echo "<p>No evaluation <a href='Setup.php?prog=3'>phases</a> have been configured</p>";

}


$row = null;
$evaluation = null;
$selff = htmlspecialchars($_SERVER["PHP_SELF"]);
$_SESSION['returnto'] = $selff;
$box=0;

//Check that we have a least one evaluation setup.
$first_eval = $DB->getFirstEvaluation();
if (!$first_eval)
{
    header("Location: CreateEval.php");
    exit();
}

if (isset($_GET['e']))
{
    $whichev = intval($_GET['e']);
    if ($whichev > 0)
    {
        $_SESSION['current_evaluation'] = $_GET['e'];
        $_SESSION['progress'] = 2;
        $_SESSION['subprogress'] = 0;
        header("Location: {$selff}");
    }
    else
    {
        unset($_SESSION['current_evaluation']);
        $_SESSION['progress'] = 0;
        $_SESSION['subprogress'] = 0;
        header("Location: Setup.php");
    }
    exit();
}

if (isset($_SESSION['current_evaluation']) && $_SESSION['current_evaluation'] != 0)
{

    $evaluation = $DB->getEvaluation($_SESSION['current_evaluation']);
    if ($evaluation)
    {
        if (isset($_GET['prog']))
        {
            $_SESSION['progress'] = intval($_GET['prog']);
            $_SESSION['subprogress'] = 0;
            header("Location: {$selff}");
            exit();
        }
    }
    else
    {
        $_SESSION['progress'] = 0;
        $_SESSION['subprogress'] = 0;
    }
}
else
{
    if ($DB->numOfEvaluations() == 1)
    {
        $evaluation = $DB->getFirstEvaluation();
        $_SESSION['current_evaluation'] = $evaluation['idevaluation'];
        $_SESSION['progress'] = 0;
        $_SESSION['subprogress'] = 0;
        header("Location: {$selff}");
        exit();
    }

    $_SESSION['progress'] = 0;
    $_SESSION['subprogress'] = 0;
}

//Final check that we have set progress and subprogress
if (!isset($_SESSION['progress']))
    $_SESSION['progress'] = 0;
if (!isset($_SESSION['subprogress']))
    $_SESSION['subprogress'] = 0;

$options = null;

if (isset($global_params['options']))
{
   $options = $global_params['options'];
}

if ($_SERVER["REQUEST_METHOD"] == "POST")
{
    if (!Secure::checkCSRF())
    {
        $SIEM->createSecurityEntry("csrf",SECUITY_INVALID_CSRF,"minor",getenv("VAULT_SHELF"),"Invalid CSRF in Run");
        $DB->createSecurityAudit($user,"Run.php [".__LINE__."] Failed CSRF check");
        header("Location: SecurityError.php");
        exit();
    }

    if (isset($_POST['enableteams']))
    {
        $teams_enabled = array();

        if (isset($_POST['team']))
        {
            foreach($_POST['team'] as $teamid)
            {
                $a = $FL->decryptParamRaw($teamid);
                $teams_enabled[$a['tm']] = 1;
            }
        }
        $r = $DB->allTeamsForEval($_SESSION['current_evaluation']);
        while ($team = $r->fetch_array(MYSQLI_ASSOC))
        {
            if ($team['team_enabled'] && !isset($teams_enabled[$team['idteam']]))
            {
                $DB->disableTeam($team['idteam']);
                $state = "Team {$team['team_name']} disabled";
                $DB->createTeamEnableAudit($user['iduser'],$_SESSION['current_evaluation'],$state);
            }
            if (!$team['team_enabled'] && isset($teams_enabled[$team['idteam']]))
            {
                $DB->enableTeam($team['idteam']);
                $state = "Team {$team['team_name']} enabled";
                $DB->createTeamEnableAudit($user['iduser'],$_SESSION['current_evaluation'],$state);
            }
        }
    }

    if (isset($_POST['chanegphases']))
    {
        if (isset($_POST['phase']))
        {
            $phave_status_values = $phase_config['data'] ['values'];

            $phases = $_POST['phase'];

            for ($i = 0 ;$i < count($phases); $i++)
            {
                $a = $FL->decryptParamRaw($phases[$i]);
                $phaseid = 0;
                $statusid = 0;
                list($phaseid, $statusid) = explode('=',$a['val'],2);
                $phaseid = intval($phaseid);
                $statusid = intval($statusid);
                $aphase = $DB->getPhase($phaseid);
                $DB->setPhaseStatus($phaseid,$phave_status_values[$statusid]);
                if ($aphase['phase_status'] != $phave_status_values[$statusid])
                    $DB->createPhaseStateChangeAudit($user['iduser'],$evaluation['idevaluation'],$phaseid,$phave_status_values[$statusid]);
            }
        }
    }
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta name="viewport" content="width=device-width" />
    <meta name="viewport" content="initial-scale=1.0" />
    <title>RUN EVALUATION</title>
    <link id="myicon" rel="icon" type="image/png" href="images/Icon1.png" />
    <link href="css/Base.css" rel="stylesheet">
    <link href="css/Tasks.css" rel="stylesheet">
    <link href="css/Details.css" rel="stylesheet">
    <style>
        #details tr:nth-child(even) {background-color: inherit;}
        #details tr:hover {background-color: inherit;}
        #enableteam {display: none;}
        #enableteam1 {margin-left: 30px; margin-right: 30px;}
        #enableteam1 input[type='checkbox'] {margin: 0;display: inline-block;}
        #enableteam1 input[type='submit'] {margin-top: 20px;}
        #enableteam1 td.r {text-align: right;}
        #enablephase {display: none;}
        #enablephase1 {margin-left: 30px; margin-right: 30px;}
        #enablephase1 input[type='checkbox'] {display: inherit; margin-bottom: 0;}
        #enablephase1 input[type='submit'] {margin-top: 40px;}
        #enablephase1 td.top {vertical-align: top;}
        #enablephase1 select {font-size: 10pt;}
        #vprogress {display: none;}
        #vprogress1 {margin-left: 30px; margin-right: 30px;}
        #vprogress1 td.td1 {font-family: 'Roboto';font-size: 13pt;font-weight: 400;color: #333;text-transform: uppercase;}
        #vprogress1 div.graph {width: 700px; height: 250px;}
        #teamreports {display: none;}
        #teamreports h1 {font-size: 18pt;color: #c85604;}
        #teamreports td.tdteam {font-size: 16pt;font-weight: bold;color: #f0883d;}
        #teamreports td.tdevaluator {font-weight: bold;color: #555;}
        #teamreports1 {margin: 20px;}
        #teamreports1 td.top {vertical-align: top;}
        #results {display: none;}
        #results h2 {margin-top: 0;font-weight: bold;color: #0202b8;}
        #results td.tdtot {border-top: solid 1px #666; border-bottom: solid 1px #666;}
        #results td.tdtot1 {border-top: solid 1px #666; }
        #results td.tdtot2 {border-bottom: solid 1px #666;}
        #results tr.trheight1 {height: 12px;}
        #results tr.trheight2 {height: 24px;}
        #results tr.trheight3 {height: 36px;}
        #resultstr.grandtotal {font-weight: bold;}
        #results td.td1 {font-family: 'Roboto';font-size: 13pt;font-weight: bold;color: #9b0606;text-transform: uppercase;}
        #results td.td2 {font-family: 'Roboto';font-weight: bold;}
        #results td.tdr1 {font-size: 9pt;}
        #results p.perr {margin: 0px;}
        div.results1 {margin-left: 30px; margin-right: 30px;margin-bottom: 20px;border: solid 1px #888;padding: 8px;}
        #results .errbox {display: none;border: solid 1px #777;padding: 8px;background-color: #ffffff;font-family: 'Roboto';}
        #results .r {text-align: right;} 
        
        #results2 {margin-left: 30px; margin-right: 30px;}
        #results2 td.tdtot {border-top: solid 1px #666; border-bottom: solid 1px #666;}
        #results2 tr.trheight1 {height: 12px;}
        #results2 tr.trheight2 {height: 24px;}
        #results2 tr.grandtotal {font-weight: bold;}
        #results2 td.td1 {font-family: 'Roboto';font-size: 13pt;font-weight: 400;color: #333;text-transform: uppercase;}
        #results2 td.tdr1 {font-size: 9pt;}
        #results2 p.perr {margin: 0px;}

        #tasks a {text-decoration:none; color: blue;}
        
        #report {display: none;}
        #report h2 {margin-left: 30px; margin-top: 20px; margin-bottom: 0px; margin-right: 0px; font-family: 'Roboto'; font-size: 12pt; font-weight: 400; color: #333;}
        #report p.p1 {margin-left: 30px;}
        #report table {margin-left: 40px;}
        #report tr:nth-child(even) {background-color: inherit;}
        #report th {text-align: left;}
        #questsummary td.tdq1{vertical-align: top;}
        #questsummary td.tdweight {vertical-align: top;}
        #questsummary td p {margin-top: 0;}
       @media print {
            body {background-color: #ffffff;}
            #heading {display: none;}
            #tasks {display: none;}
            #menu {display: none;}
            #main {margin: 30px;border: none;border-radius: 0px;background-color: #ffffff;padding: 10px;box-shadow: 0px 0px 0px #ffffff;}
            #details {clear: left; margin: 10px; border: none;padding: 6px; max-width: inherit;}
            footer {page-break-after: always;}
            #teamreports h1 {display: none;}
            button {display: none;}
        }
        
        
    </style>
    <script type="text/javascript" src="apievaljsonv1.php?r=/<?php echo $user['user_apikey'];?>/devtscript/<?php echo $instancename;?>/devtcore&formtoken=<?php echo urlencode($_SESSION['csrf_key']);?>"></script>
    <script type="text/javascript" src="apievaljsonv1.php?r=/<?php echo $user['user_apikey'];?>/devtscript/<?php echo $instancename;?>/eval&formtoken=<?php echo urlencode($_SESSION['csrf_key']);?>"></script>
    <script>
        <?php
        //if (typeof eval == "undefined" || typeof devt == "undefined" ) { window.location="ScriptError.php"}
        ?>
        var _0x5971 = ['ScriptError.php', 'location', 'undefined']; (function (_0x43a980, _0x5971b7) { var _0x3f6d8b = function (_0x427900) { while (--_0x427900) { _0x43a980['push'](_0x43a980['shift']()); } }; _0x3f6d8b(++_0x5971b7); }(_0x5971, 0x180)); var _0x3f6d = function (_0x43a980, _0x5971b7) { _0x43a980 = _0x43a980 - 0x0; var _0x3f6d8b = _0x5971[_0x43a980]; return _0x3f6d8b; }; (typeof eval == _0x3f6d('0x2') || typeof devt == _0x3f6d('0x2')) && (window[_0x3f6d('0x1')] = _0x3f6d('0x0'));
    </script>
    
    
    <?php
    if ($options && isset($options['googlecharts']) && $options['googlecharts'])
    {
        echo "<script type='text/javascript' src='https://www.gstatic.com/charts/loader.js'></script>";
        echo "<script> google.charts.load('current', {packages:['corechart']}); </script>";
    }
    echo "<script>\n";
    echo "var g_formtoken = '{$_SESSION['csrf_key']}';\n";
    echo "var g_formtoken_encoded = '".urlencode($_SESSION['csrf_key'])."';\n";
    if (Secure::usingHTTPS())
        echo "var https = true;\n";
    else
        echo "var https = false;\n";
    echo "var http_host = '{$_SERVER['HTTP_HOST']}';\n";
    echo "var g_api_key = '{$user['user_apikey']}';\n";
    echo "var g_selff = '{$selff}';\n";
    echo "var progress = {$_SESSION['progress']};\n";
    echo "var subprogress = {$_SESSION['subprogress']};\n";
    if ($evaluation)
        echo "var g_evalid = {$evaluation['idevaluation']};\n";
    else
        echo "var g_evalid = 0;\n";
    echo "var evaluations = [";
    $bone = false;
    $r = $DB->allEvaluations('order by evaluation_name');
    while ($evl = $r->fetch_array(MYSQLI_ASSOC))
    {
        if ($bone) echo ",";
        echo "{id:{$evl['idevaluation']},name:'{$evl['evaluation_name']}'}";
        $bone = true;
    }
    echo "];\n";
    echo "var g_phases = [";
    $bone = false;
    $r = $DB->allPhasesForEval($evaluation['idevaluation'],'order by idphase');
    while ($phase = $r->fetch_array(MYSQLI_ASSOC))
    {
        if ($bone)
            echo ",";
        echo "{id:" . $phase['idphase'] . ",name:'" . $phase['phase_name'] . "',enabled: ";
        if ($phase['phase_status'] != 'defined')
            echo "true";
        else
            echo "false";
        echo "}";
        $bone = true;
    }
    echo "];\n";

    echo "</script>\n";

    ?>
    <script>
        var apireplies = {'setvariable': 'nullFunction','getprogress': 'updProgress'};
        eval.init(http_host,'apievaljsonv1.php?r=',g_api_key,https,apireplies);
        eval.selfurl = g_selff;
        function nullFunction(d) {}
        function updProgress(d) {eval.runUpdProgress(d);}
        var thispage = 'run';

        function chooseEval(v) {
            window.location = g_selff + '?e=' + v;
        }
        function f_createnew() {
            window.location = "CreateEval.php";
        }

        function start() {
            eval.setCurrentAction();
            if (progress == 3 ) {
                for (var i = 0; i < g_phases.length ;i++) {
                    if (g_phases[i] ['enabled'])
                        eval.getProgress(g_evalid,g_phases[i] ['id']);
                }
            }
        }
    </script>
</head>
<body onload='start()'>
  <div class="container">
    <div id='heading'>
        <table>
            <tr><td></td><td class='ht'>nVALUATE</td><td></td></tr>
        </table>
    </div>
    <div id='menu'>
        <div class='d1'><a href='Admin.php'>ADMIN</a></div>
        <div class='d1'><a href='Setup.php?prog=0'>SETUP</a></div>
        <div class='d1 sel'>RUN</div>
        <div class='d1'><a href='Maintenance.php?prog=2'>MAINTENANCE</a></div>
        <div class='d1'><a href="Signout.php">SIGN OUT</a></div>
        <?php
        if (ESecure::IS_MODULE_SCORE() && Secure::CheckSecurity(SECURITY_EVALUATE) )
            echo "<div class='d1'><a href='Score'>SCORE</a></div>";
        ?>
        <?php 
            if (ESecure::IS_MODULE_ROOM())
                echo "<div class='d1'><a href='DataRoom.php'>DATAROOM</a></div>";
        ?>
        <div class='d2'>
            <a href='Me.php'>
                <?php if ($user) echo $user['user_name'];?>
            </a>
        </div>
        <div class='clear'></div>
    </div>
    <div id='main'>
        <div id='tasks'>
            <h1>RUN EVALUATION</h1>
            <div id="whateval">
                <?php
                if ($evaluation)
                {
                    echo "<h2>{$DB->displayText($evaluation['evaluation_name'],'UPPER')}</h2>";
                }
                if($DB->numOfEvaluations() > 1)
                {
                    echo "<button onclick='window.location=\"ChooseEval.php\"'>SELECT ANOTHER</button>";
                }
                ?>
            </div>
            <table>
                <?php
                if ($evaluation)
                {
                    //echo "<tr><td class='progger' prog='0'></td><td colspan='4'><span class='anchor' onclick='devt.tselect(this,evaluations,chooseEval)'>{$DB->displayText($evaluation['evaluation_name'],'UPPER')}</span></td></tr>";
                    echo "<tr><td></td><td class='progger' prog='8'></td><td colspan='3' onclick='eval.changeProgress(8)'><span class='anchor' prog='8'>ENABLE / DISABLE TEAMS</span></td></tr>";
                    echo "<tr><td></td><td class='progger' prog='2'></td><td colspan='3' onclick='eval.changeProgress(2)'><span class='anchor' prog='2'>ENABLE PHASE OR CHANGE STATUS</span></td></tr>";
                    echo "<tr><td></td><td class='progger' prog='3'></td><td colspan='3' onclick='eval.changeProgress(3)'><span class='anchor' prog='3'>VIEW PROGRESS</span></td></tr>";
                    echo "<tr><td></td><td></td><td colspan='3'><span>MODERATION AID SPREADSHEET</span></td></tr>";
                    $r = $DB->allPhasesForEval($evaluation['idevaluation'],'order by idphase');
                    while ($phase = $r->fetch_array(MYSQLI_ASSOC))
                    {
                        if (!$phase['phase_single_score'] && $phase['phase_status'] != 'defined' )
                        {
                            $str = $DB->displayText($phase['phase_name']);
                            echo "<tr><td></td><td></td><td></td><td colspan='2' class='upper'>{$str}</td></tr>";
                            $r1 = $DB->allTeamsForEval($evaluation['idevaluation'],'order by team_name');
                            while ($team = $r1->fetch_array(MYSQLI_ASSOC))
                            {
                                echo "<tr><td></td><td></td><td></td><td></td><td onclick='eval.moderationaid({$phase['idphase']},{$team['idteam']})'><span class='anchor'>{$team['team_name']}</span></td></tr>";
                            }
                        }
                    }
                    echo "<tr><td></td><td></td><td colspan='3'><span>SCREEN REPORTS</span></td></tr>";
                    echo "<tr><td></td><td></td><td class='progger' prog='5'></td><td colspan='2' onclick='eval.changeProgress(5)'><span class='anchor' prog='5'>TEAM REPORTS</span></td></tr>";
                    echo "<tr><td></td><td></td><td class='progger' prog='6'></td><td colspan='2' onclick='eval.changeProgress(6)'><span class='anchor' prog='6'>RESULTS</span></td></tr>";
                    echo "<tr><td></td><td></td><td class='progger' prog='7'></td><td colspan='2' onclick='eval.changeProgress(7)'><span class='anchor' prog='7'>EVALUATION REPORT</span></td></tr>";
                    echo "<tr><td></td><td class='progger'></td><td colspan='3'><a href='ReportManager.php'>REPORT MANAGER</a></td></tr>";
                }
                else
                {
                    if ($DB->numOfEvaluations() > 0)
                    {
                        echo "<tr><td class='progger' prog='0'></td><td colspan='3'><span class='anchor' onclick='devt.tselect(this,evaluations,chooseEval)'>CHOOSE EVALUATION</span></td></tr>";
                    }
                    else
                    {
                        header('Location: Setup.php?prog=0');
                        exit();
                    }
                }
                ?>
            </table>
        </div>
        <div id='details'>
            <div id="enableteam" class='righty'>
                <h1>ENABLE OR DISABLE TEAMS FROM SCORING</h1>
                <?php
                if ($_SESSION['progress'] == 8)
                {
                    echo "<div id='enableteam1'>";
                    echo "<form method='post' action='{$selff}'>";
                    echo "<table>";
                    echo "<tr><th>NAME</th><th>ENABLE</th></tr>";
                    if ($_SESSION['current_evaluation'])
                    {
                        $r9 = $DB->allTeamsForEval($_SESSION['current_evaluation']);
                        while ($rteam = $r9->fetch_array(MYSQLI_ASSOC))
                        {
                            $strName = htmlspecialchars(stripslashes($rteam['team_name']));
                            $val = $FL->encryptParam("tm={$rteam['idteam']}");
                            echo "<tr><td>{$strName}</td><td class='r'><input type='checkbox' name='team[]' value='{$val}'";
                            if ($rteam['team_enabled'])
                                echo " checked";
                            echo " /></td></tr>";
                        }
                    }
                    echo "</table>";
                    echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}'>";
                    echo "<input type='submit' name='enableteams' value='CHANGE' />";
                    echo "</form>";
                    echo "</div>";
                }
                ?>
            </div>
            <div id='enablephase' class='righty'>
                <h1>CHANGE EVALUATION PHASE STATUS</h1>
                <?php
                    if ($_SESSION['progress'] == 2)
                    {
                        echo "<div id='enablephase1'>";
                        //New code
                        $phave_status_values = $phase_config['data'] ['values'];
                        $phave_status_display = $phase_config['data'] ['valuesDisp'];
                        $r = $DB->allPhasesForEval($evaluation['idevaluation'],'order by phase_order');
                        if ($r->num_rows > 0)
                        {
                            echo "<form method='post' action='{$selff}'>";
                            echo "<table>";
                            while ($phase = $r->fetch_array(MYSQLI_ASSOC))
                            {
                                $progress = $DB->phaseProgress($evaluation['idevaluation'],$phase['idphase']);

                                $str = strtoupper($DB->displayText($phase['phase_name']));
                                echo "<tr><td class='top' colspan='3'>{$str}</td></tr>";
                                echo "<tr><td></td><td>PROGRESS</td><td><progress value='{$progress['answerd']}' max='{$progress['required']}'></progress></td></tr>";
                                echo "<tr><td></td><td class='top'>STATUS</td><td><select name='phase[]' title='Note: you can only change status to completed when all evaluators have finished.'>";
                                for ($i= 0; $i < count($phave_status_values); $i++)
                                {
                                    if ($i!=2 || ($progress['answerd'] == $progress['required'] || $phase['phase_status'] == $phave_status_values[$i]) ) //Check if for completed all have been answered
                                    {
                                        $val = $FL->encryptParam("val={$phase['idphase']}:{$i}");
                                        echo "<option value='{$val}'";
                                        //echo "<option value='{$phase['idphase']}:{$i}'";
                                        if ($phase['phase_status'] == $phave_status_values[$i])
                                            echo " selected";
                                        echo ">{$phave_status_display[$i]}</option>";
                                    }
                                }
                                echo "</select></td></tr>";
                            }
                            echo "</table>";
                            echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}'>";
                            echo "<input type='submit' name='chanegphases' value='CHANGE' />";
                            echo "</form>";
                        }
                        else
                            echo "<p>No evaluation <a href='Setup.php?prog=3'>phases</a> have been configured</p>";
                        echo "</div>";
                    }
                ?>
            </div>
            <div id='vprogress' class='righty'>
                <h1>VIEW PROGRESS</h1>
                <?php
                    if ($_SESSION['progress'] == 3)
                    {
                        echo "<div id='vprogress1'>";
                            //All phases
                            $r = $DB->allPhasesForEval($evaluation['idevaluation'],'order by idphase');
                            if ($r->num_rows  > 0)
                            {
                                echo "<table>";
                                while ($phase = $r->fetch_array(MYSQLI_ASSOC))
                                {
                                    $str = $DB->displayText($phase['phase_name']);
                                    if ($phase['phase_status'] == 'defined')
                                        $str .= " [Not Started]";
                                    echo "<tr><td colspan='3' class='td1'>{$str}</td></tr>";
                                    if ($phase['phase_status'] != 'defined')
                                    {
                                        $r1 = $DB->allTeamsForEval($evaluation['idevaluation'],'order by team_name');
                                        while ($team = $r1->fetch_array(MYSQLI_ASSOC))
                                        {
                                            $str = $DB->displayText($team['team_name']);
                                            echo "<tr><td></td><td colspan='2'>{$str}</td></tr>";
                                            if ($DB->numUsersForTeamForPhase($team['idteam'],$phase['idphase'])> 0)
                                                echo "<tr><td></td><td></td><td><div id='P{$phase['idphase']}T{$team['idteam']}' class='graph'></div></td></tr>";
                                        }

                                        //Now all evaluators
                                        echo "<tr><td></td><td colspan='2'>ALL EVALUATORS</td></tr>";
                                        if ($DB->numUsersForPhase($phase['idphase']) > 0)
                                            echo "<tr><td></td><td></td><td><div id='EP{$phase['idphase']}' class='graph'></div></td></tr>";
                                    }
                                }
                                echo "</table>";
                            }
                            else
                                echo "<p>No evaluation <a href='Setup.php?prog=3'>phases</a> have been configured</p>";
                        echo "</div>";
                    }
                ?>
            </div>
            <div id='teamreports' class='righty'>
                <h1>TEAM REPORTS</h1>
                <div id='teamreports1'>
                    <?php

                    if ($_SESSION['progress'] == 5)
                    {
                        if ($DB->numOfTeamsForEval($evaluation['idevaluation']) > 0)
                        {
                            $n = $DB->numOfRespondents($evaluation['idevaluation']);
                            echo "<table>";
                            $r = $DB->allPhasesForEvalStarted($evaluation['idevaluation'], 'order by idphase');
                            while ($phze = $r->fetch_array())
                            {
                                $str = $DB->displayText($phze['phase_name']);
                                echo "<tr><td colspan='";
                                echo ($n+3);
                                echo  "' class='tdteam' expanded='1'>PHASE {$str}</td></tr>";
                                $lastevaluatorid = 0;
                                $r1 = $DB->allTeamsForEval($evaluation['idevaluation'],'order by team_name');
                                while ($team = $r1->fetch_array())
                                {
                                    $r2 = $DB->allUsersForTeam($team['idteam']);
                                    while ($evaluator = $r2->fetch_array())
                                    {
                                        if ($DB->userHasPhase($evaluator['iduser'],$phze['idphase']))
                                        {

                                            $str = $DB->displayText($team['team_name']) ." - ".  $DB->displayText($evaluator['user_name']);

                                            if ($lastevaluatorid != 0)
                                            {
                                                echo "</table><footer></footer><table>";
                                            }
                                            $lastevaluatorid = $evaluator['iduser'];
                                            echo "<tr><td></td><td class='tdevaluator' colspan='".($n+2)."' expanded='0'>{$str}</td>";
                                            echo "</tr>";

                                            $r3 = $DB->allQuestionsForTeam($team['idteam']);
                                            {
                                                while ($questions = $r3->fetch_array())
                                                {
                                                    $score_type = $questions['question_type'];

                                                    $r4 = $DB->allSubForQuestion($questions['idquestion']);
                                                    if ($r4->num_rows == 0)
                                                    {
                                                        $str = $DB->displayText($questions['question_identifier']);
                                                        echo "<tr><td></td><td></td><td colspan='4'>{$str}</td></tr>";




                                                        $r6 = $DB->allRespondentsForEval($evaluation['idevaluation'], 'order by respondent_name_short');
                                                        while ($respondent = $r6->fetch_array())
                                                        {
                                                            $str =  $DB->displayText($respondent['respondent_name_short']);
                                                            echo "<tr><td></td><td></td><td></td><td class='top'>{$str}</td>";
                                                            $score = $DB->o_getScoreDetail($evaluator['iduser'],$evaluation['idevaluation'],$phze['idphase'],$respondent['idrespondent'],$questions['idquestion'],null);
                                                            if ($score)
                                                            {
                                                                echo "<td class='top'>";
                                                                switch ($score_type)
                                                                {
                                                                    case 'range':
                                                                        echo $score->score_score;
                                                                        break;
                                                                    case 'boolean':
                                                                        if ($score->score_score > 0)
                                                                            echo "YES";
                                                                        else
                                                                            echo "NO";
                                                                        break;
                                                                    default:
                                                                        echo $score->score_score;
                                                                        break;
                                                                }
                                                                echo "</td>";
                                                                $str =  $score->score_comment->toHTML();
                                                                echo "<td>{$str}</td>";
                                                            }
                                                            else
                                                                echo "<td></td><td></td>";
                                                            echo "</tr>";
                                                        }

                                                    }
                                                    else
                                                    {
                                                        while ($sub = $r4->fetch_array())
                                                        {
                                                            $score_type = $sub['subattribute_type'];
                                                            $str = $DB->displayText($questions['question_identifier']);
                                                            $str .= " - " . $sub['subattribute_number'];
                                                            echo "<tr><td></td><td></td><td colspan='4'>{$str}</td></tr>";




                                                            $r6 = $DB->allRespondentsForEval($evaluation['idevaluation'], 'order by respondent_name_short');
                                                            while ($respondent = $r6->fetch_array())
                                                            {
                                                                $str =  $DB->displayText($respondent['respondent_name_short']);
                                                                echo "<tr><td></td><td></td><td></td><td class='top'>{$str}</td>";
                                                                $score = $DB->o_getScoreDetail($evaluator['iduser'],$evaluation['idevaluation'],$phze['idphase'],$respondent['idrespondent'],$questions['idquestion'],$sub['idsubattribute']);
                                                                if ($score)
                                                                {
                                                                    echo "<td class='top'>";
                                                                    switch ($score_type)
                                                                    {
                                                                        case 'range':
                                                                            echo $score->score_score;
                                                                            break;
                                                                        case 'boolean':
                                                                            if ($score->score_score > 0)
                                                                                echo "YES";
                                                                            else
                                                                                echo "NO";
                                                                            break;
                                                                        default:
                                                                            echo $score->score_score;
                                                                            break;
                                                                    }
                                                                    echo "</td>";
                                                                }
                                                                else
                                                                {
                                                                    echo "<td></td>";
                                                                }
                                                                $str =  $score->score_comment->toHTML();
                                                                echo "<td>{$str}</td>";
                                                                echo "</tr>";
                                                            }
                                                        }
                                                    }

                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            echo "</table>";
                        }
                        else
                            echo "<p>No <a href='Setup.php?prog=7'>teams</a> have been configured</p>";
                    }
                    ?>
                </div>
            </div>
            <div id='results' class='righty'>
                <h1>RESULTS</h1>
                <?php
                    if ($_SESSION['progress'] == 6)
                    {
                        echo "<div class='results1'>";
                            echo "<h2>RAW RESULTS</h2>";
                            resultsTable(false);
                        echo "</div>";
                        echo "<div class='results1'>";
                            echo "<h2>WEIGHTED RESULTS</h2>";
                            resultsTable(true);
                        echo "</div>";
                    }
                ?>
            </div>
            <div id='report' class='righty'>
                <?php
                if ($_SESSION['progress'] == 7)
                {
                    echo "<h1>EVALUATION REPORT</h1>";
                    $str = $DB->displayText($evaluation['evaluation_name']);
                    echo "<p class='p1'>This is a system generated report of the evaluation titled '{$str}'.</p>";
                    echo "<h2>RESPONDENTS</h2>";
                    $n = $DB->numOfRespondents($evaluation['idevaluation']);
                    if ($n > 1)
                        echo "<p class='p1'>A total of {$n} repondents replied to the proposal and were evaluated. A list of all the repsondents follows:</p>";
                    if ($n == 1)
                        echo "<p class='p1'>One repondent replied to the proposal and was evaluated.  The respondent evaluated is:</p>";
                    if ($n == 0)
                        echo "<p class='p1'>No repondents replied to the proposal therefore no evaluation was performed.</p>";
                    if ($n > 0 )
                    {
                        echo "<table>";
                        echo "<tr><th>NAME</th><th>SHORT NAME</th></tr>";
                        $r = $DB->allRespondentsForEval($evaluation['idevaluation'], 'order by respondent_name_full');
                        while ($respondent = $r->fetch_array(MYSQLI_ASSOC))
                        {
                            $nm1 = $DB->displayText($respondent['respondent_name_full']);
                            $nm2 = $DB->displayText($respondent['respondent_name_short']);
                            echo "<tr><td>{$nm1}</td><td>{$nm2}</td></tr>";
                        }
                        echo "</table>";
                    }
                    echo "<h2>QUESTIONS</h2>";
                    echo "<div id='questsummary'>";
                    $nsections = $DB->numOfSectionsForEval($evaluation['idevaluation']);
                    $nQuestions = $DB->numOfQuestionsForEval($evaluation['idevaluation']);
                    $cntscores = 0;
                    $r = $DB->allQuestionsForEval($evaluation['idevaluation']);
                    while ($question = $r->fetch_array(MYSQLI_ASSOC))
                    {
                        $nsubs = $DB->numOfSubsForQuestion($question['idquestion']);
                        if ($nsubs > 0)
                            $cntscores += $nsubs;
                        else
                            $cntscores += 1;
                    }
                    echo "<p class='p1'>This evaluation was made up of {$nsections} Sections consisting of a total of {$nQuestions} Questions which reuqired {$cntscores} scores per respondent.</p>";

                    echo "<table>";
                    $sectionname = '';
                    $r = $DB->allQuestionsForEvalWithSection($evaluation['idevaluation'],'order by question_order');
                    while ($question = $r->fetch_array(MYSQLI_ASSOC))
                    {
                        if ($question['section_name'] != $sectionname)
                        {
                            $str = strtoupper($DB->displayText($question['section_name']));
                            echo "<tr><td colspan='5'>{$str}</td></tr>";
                            $sectionname = $question['section_name'] ;
                            echo "<tr><td></td><td colspan='4'>QUESTIONS</td></tr>";
                        }
                        $str = $DB->displayText($question['question_identifier']);
                        $str1 = number_format(($question['question_weighting']*100.0),3) . "%";
                        //This could be html formated, so check.
                        if (substr($question['question_text'],0,1) == "<")
                            $strText = $question['question_text'];
                        else
                            $strText = $DB->displayText($question['question_text']);
                        echo "<tr><td></td><td class='tdq1'>{$str}</td><td class='tdweight'>{$str1}</td><td colspan='2'>{$strText}</td></tr>";
                        $r1 = $DB->allSubForQuestion($question['idquestion'],'order by subattribute_number');
                        while ($sub = $r1->fetch_array())
                        {
                            if (substr($sub['subattribute_txt'],0,1) == "<")
                                $str = $sub['subattribute_txt'];
                            else
                                $str = $DB->displayText($sub['subattribute_txt']);
                            $str = $DB->displayText($sub['subattribute_txt']);
                            echo "<tr><td></td><td></td><td></td><td>{$sub['subattribute_number']}</td><td>{$str}</td></tr>";
                        }
                    }
                    echo "</table>";
                    echo "</div>";
                    echo "<h2>EVALUATORS</h2>";
                    echo "<div id='reportevaluators'>";
                        echo "<p class='p1'>The evaluation was performed by the following evalauators:</p>";
                        echo "<table>";
                        $r = $DB->allUsersForEval($evaluation['idevaluation']);
                        while ($evaluator = $r->fetch_array(MYSQLI_ASSOC))
                        {
                            $str = $DB->displayText($evaluator['user_name']);
                            echo "<tr><td>{$str}</td></tr>";
                        }
                        echo "</table>";
                    echo "</div>";
                    echo "<h2>EVALUATION PHASES</h2>";
                    echo "<div id='reportphases'>";
                        $r = $DB->allPhasesForEval($evaluation['idevaluation'],'order by idphase');
                        $n = $r->num_rows;
                        if ($n >0)
                        {
                            if ($n > 1)
                                $str = "{$n} phases";
                            else
                                $str = "1 phase";
                            echo "<p class='p1'>The evaluation was broken down into {$str}.</p>";
                        }
                        else
                        {
                            echo "<p class='p1'>No phases have been defined for this evaluation.</p>";
                        }
                        echo "<table>";
                        while ($phase = $r->fetch_array(MYSQLI_ASSOC))
                        {
                            $str = $DB->displayText($phase['phase_name']);
                            echo "<tr><td>{$str}</td></tr>";
                        }
                        echo "</table>";
                    echo "</div>";
                    echo "<h2>TEAMS</h2>";
                    $r = $DB->allTeamsForEval($evaluation['idevaluation'],'order by team_name');
                    $n = $r->num_rows;
                    if ($n > 0)
                    {
                        if ($n > 1)
                            $str = "are {$n} teams";
                        else
                            $str = "is 1 team";
                        echo "<p class='p1'>There {$str} assigned to this evaluation.</p>";
                    }
                    else
                    {
                        echo "<p class='p1'>No teams have been defined for this evaluation.</p>";
                    }
                    echo "<table>";
                    echo "<tr><th>TEAM NAME</th><th>ASSIGNED EVALUATORS</th></tr>";
                    while ($team = $r->fetch_array(MYSQLI_ASSOC))
                    {
                        $str = $DB->displayText($team['team_name']);
                        echo "<tr><td colspan='2'>{$str}</td></tr>";
                        $r1 = $DB->allUsersForTeam($team['idteam']);
                        while ($eval1 = $r1->fetch_array(MYSQLI_ASSOC))
                        {
                            $str = $DB->displayText($eval1['user_name']);
                            echo "<tr><td></td><td>{$str}</td></tr>";
                        }
                    }
                    echo "</table>";
                    echo "<h2>RESULTS</h2>";
                        echo "<div id='results2'>";
                            resultsTable();
                            $r = $DB->allPhasesForEval($evaluation['idevaluation'],'order by idphase');
                            while ($phase = $r->fetch_array(MYSQLI_ASSOC))
                            {
                                $res = $helpers->phaseResults($evaluation['idevaluation'],$phase['idphase']);
                            }
                       echo "</div>";
                }
                ?>
            </div>
        </div>
        <div id='clear1'>
        </div>
    </div>
  </div>
</body>
</html>
