<?php
session_start();
require './includes/classEvalSecure.php';
require './includes/classEvaluateDB.php';
require './includes/classFormList.php';
require './includes/classWordDoc.php';
require './includes/classEvalHelpers.php';
require './includes/classTime.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
Secure::CheckPage(SECURITY_VIEW);
$FL = new FormList(null);
$helpers = new helpers();

function var_error_log( $object=null ,$text='')
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( "{$text} {$contents}" );        // log contents of the result of var_dump( $object )
}


function replaceMarkerWith($marker,$with,$completepara=false)
{
    global $wdoc;
    if ($completepara)
    {
        $p1 = $wdoc->findParagraphWhichIncludesText($marker);
        if (!$p1)
        {
            error_log("Reporter [".__LINE__."] Unable to find marker {$marker}");
            return false;
        }
        if ($wdoc->newText($p1,$with) )
            return true;
        else
        {
            error_log("Reporter1 [".__LINE__."] replaceMarkerWith {$marker} failed.");
            return false;
        }
    }
    else
    {
        if ($wdoc->replaceText($marker,$with) )
            return true;
        else
        {
            error_log("Reporter1 [".__LINE__."] replaceMarkerWith {$marker} failed.");
            return false;
        }
    }
}

function htmlToWord($doc,$html,$parent,$template)
{
    $htmlDoc = new DOMDocument();
    $htmlDoc->loadHTML("<html><body>{$html}</body></html>");

    $body = $htmlDoc->getElementsByTagName("body");
    $children = $body->item(0)->childNodes;
    foreach ($children as $child)
    {
        if (strtoupper($child->nodeName) == "P")
        {
            $v = $template['p']->cloneNode(true);
            $doc->newText($v,$child->nodeValue);
            $parent->appendChild($v);
        }
        if (strtoupper($child->nodeName) == "UL")
        {
            $list = $child->childNodes;
            foreach ($list as $li)
            {
                if (strtoupper($li->nodeName) == "LI")
                {
                    $v = $template['li']->cloneNode(true);
                    $doc->newText($v,$li->nodeValue);
                    $parent->appendChild($v);
                }
            }
        }
    }
}


function htmlToWordInsertBefore($doc,$html,$before,$template)
{
    $htmlDoc = new DOMDocument();
    $htmlDoc->loadHTML("<html><body>{$html}</body></html>");

    $body = $htmlDoc->getElementsByTagName("body");
    $children = $body->item(0)->childNodes;
    foreach ($children as $child)
    {
        if (strtoupper($child->nodeName) == "P")
        {
            $v = $template['p']->cloneNode(true);
            $doc->newText($v,$child->nodeValue);
            $doc->insertParagraphBefore($v,$before);
        }
        if (strtoupper($child->nodeName) == "UL")
        {
            $list = $child->childNodes;
            foreach ($list as $li)
            {
                if (strtoupper($li->nodeName) == "LI")
                {
                    $v = $template['li']->cloneNode(true);
                    $doc->newText($v,$li->nodeValue);
                    $doc->insertParagraphBefore($v,$before);
                }
            }
        }
    }
}

$reportsDir = $devt_environment->getkey("REPORTS_DIR");
$templatedir = $devt_environment->getkey("TEMPLATES_DIR");
$graphsdir = $devt_environment->getkey("GRAPHS_DIR");


$templatename = $templatedir . "/TemplateScore8.docx";
$reportTitle = $reportsDir . "/EvaluatorReport.docx";

$evalid = 0;
$phaseid = 0;
$dtNow = new DateTime('now');
$tableidx= 0;
$g_anon = 0;

$user = $DB->getUser($_SESSION['userid']);
if (!$user)
{
    header("Location: SecurityError.php");
    exit();
}
$dtNow->setTimezone(new DateTimeZone($user['user_timezone']));
$evaluation = null;
$phase = null;
$evaluator = null;


if (isset($_GET['v']))
{
    $a = $FL->decryptParamRaw($_GET['v']);
    $evalid = $a['eval'];
    $phaseid = $a['phase'];
    $evaluatorid = $a['user'];

    $evaluation = $DB->getEvaluation($evalid);
    $phase = $DB->getPhase($phaseid);
    $evaluator = $DB->getUser($evaluatorid);
}

if (!$evaluation || !$phase || !$evaluator)
{
    echo "Invalid parameter passed";
    exit();
}


//Create report run audit
$DB->createAudit("report",$evaluator,"Report8 - Individual Score Report");

//Get some evaluation details

$wdoc = new WordDoc("/tmp/Report{$dtNow->format('YmdHis')}");
if (!$wdoc->open("{$templatename}") )
{
    echo "Unable to open template document {$templatename}";
    exit();
}


//********************************************************************
//Heading page
//********************************************************************
replaceMarkerWith('8237469438',$evaluation['evaluation_name'],true);

//Page 1 Date
replaceMarkerWith('4892372387',$dtNow->format('j F Y'),true);

//Phase name
replaceMarkerWith('3745655858',"Phase {$phase['phase_name']}",true);

//Evaluator name
replaceMarkerWith('3845487567',$evaluator["user_name"],true);

$endy = $wdoc->findParagraphWhichIncludesText('END');
$heading2 = $wdoc->findParagraphWhichIncludesText('2874637545');
$heading3 = $wdoc->findParagraphWhichIncludesText('4658667575');
$para3 = $wdoc->findParagraphWhichIncludesText('1275483537');
$bullettext = $wdoc->findParagraphWhichIncludesText('7674563456');
$questionheading = $wdoc->findParagraphWhichIncludesText('7856865457');
$subattribueheading = $wdoc->findParagraphWhichIncludesText('7437453678');
$respondentheading =   $wdoc->findParagraphWhichIncludesText('2537598346');
$scoreheading = $wdoc->findParagraphWhichIncludesText('SCORE');
$commentheading = $wdoc->findParagraphWhichIncludesText('5673456787');
$subtext = $wdoc->findParagraphWhichIncludesText('4365376544');
$questiontemplates = ["p" => $para3,"li" => $bullettext];
$subtemplates = ["p" => $subtext,"li" => $bullettext];

$lastsection = '';


$r = $DB->allTeamsForUserandEval($evaluator["iduser"],$evaluation['idevaluation']);
while ($team = $r->fetch_array(MYSQLI_ASSOC))
{

    $h2 = $heading2->cloneNode(true);
    $wdoc->newText($h2,"TEAM " . stripslashes($team['team_name']));
    $wdoc->insertParagraphBefore($h2,$endy);

    $r1 = $DB->allQuestionsForTeam($team['idteam']);
    while ($question = $r1->fetch_array(MYSQLI_ASSOC))
    {
        if ($question['section_name'] != $lastsection)
        {
            $wdoc->insertParaClonedFromBefore($heading3,$endy,"Section " . stripslashes($question['section_name']));
            $wdoc->insertParaClonedFromBefore($para3,$endy," ");
            $lastsection = $question['section_name'];
        }
        $wdoc->insertParaClonedFromBefore($questionheading,$endy,"QUESTION " . stripslashes($question['question_identifier']));

        //Question text
        if (substr($question['question_text'],0,1) == "<")
        {
            htmlToWordInsertBefore($wdoc,$question['question_text'],$endy,$questiontemplates);
        }
        else
        {
            $qt = $para3->cloneNode(true);
            $strText = trim(stripslashes($question['question_text']));
            $wdoc->insertParagraphBefore($qt,$endy);
        }


        $r2 = $DB->allSubForQuestion($question['idquestion'],'order by subattribute_number');
        if ($r2->num_rows > 0)
        {
            while ($sub = $r2->fetch_array(MYSQLI_ASSOC))
            {
                $wdoc->insertParaClonedFromBefore($subattribueheading,$endy,"SUB-ATTRIBUTE {$sub['subattribute_number']}");
                //Subattribute text
                if (substr($sub['subattribute_txt'],0,1) == "<")
                {
                    htmlToWordInsertBefore($wdoc,$sub['subattribute_txt'],$endy,$subtemplates);
                }
                else
                {
                    $strText = trim(stripslashes($sub['subattribute_txt']));
                    $wdoc->insertParaClonedFromBefore($subtext,$endy,$strText);
                    $wdoc->insertParaClonedFromBefore($subtext,$endy," ");
                }







                $r3 = $DB->allRespondentsForEval($evaluation['idevaluation']);
                while ($respondent = $r3->fetch_array(MYSQLI_ASSOC))
                {
                    $wdoc->insertParaClonedFromBefore($subattribueheading,$endy,stripslashes($respondent['respondent_name_full']));
                    $score = $DB->o_getScoreDetail($evaluator['iduser'],$evaluation['idevaluation'],$phase['idphase'],$respondent['idrespondent'],$question['idquestion'],$sub['idsubattribute']);
                    if ($score && $score->score_score !== null)
                    {
                        switch ($sub['subattribute_type'])
                        {
                            case 'range':
                                $wdoc->insertParaClonedFromBefore($scoreheading,$endy,$score->score_score);
                                break;
                            case 'boolean':
                                if ($score->score_score > 0)
                                    $wdoc->insertParaClonedFromBefore($scoreheading,$endy,"YES");
                                else
                                    $wdoc->insertParaClonedFromBefore($scoreheading,$endy,"NO");
                                break;
                            default:
                                $wdoc->insertParaClonedFromBefore($scoreheading,$endy,$score->score_score);
                                break;
                        }

                    }
                    else
                        $wdoc->insertParaClonedFromBefore($scoreheading,$endy,"NO SCORE");
                    if ($score && $score->score_comment->length() > 0)
                    {
                        $comment = str_replace("\\n","\n",$score->score_comment->toWord());

                        $lines = explode("\n",$comment);
                        foreach($lines as $line)
                        {
                            $text = stripslashes($line);
                            if (strlen($text) > 0)
                                $wdoc->insertParaClonedFromBefore($commentheading,$endy,$text);
                            else
                                $wdoc->insertParaClonedFromBefore($commentheading,$endy," ");
                        }
                        $wdoc->insertParaClonedFromBefore($commentheading,$endy," ");
                    }
                    else
                        $wdoc->insertParaClonedFromBefore($commentheading,$endy," ");
                }
            }
        }
        else
        {
            $r3 = $DB->allRespondentsForEval($evaluation['idevaluation']);
            while ($respondent = $r3->fetch_array(MYSQLI_ASSOC))
            {
                $wdoc->insertParaClonedFromBefore($subattribueheading,$endy,stripslashes($respondent['respondent_name_full']));
                $score = $DB->o_getScoreDetail($evaluator['iduser'],$evaluation['idevaluation'],$phase['idphase'],$respondent['idrespondent'],$question['idquestion'],0);
                if ($score && $score->score_score !== null)
                {
                        switch ($question['question_type'])
                        {
                            case 'range':
                                $wdoc->insertParaClonedFromBefore($scoreheading,$endy,$score->score_score);
                                break;
                            case 'boolean':
                                if ($score->score_score > 0)
                                    $wdoc->insertParaClonedFromBefore($scoreheading,$endy,"YES");
                                else
                                    $wdoc->insertParaClonedFromBefore($scoreheading,$endy,"NO");
                                break;
                            default:
                                $wdoc->insertParaClonedFromBefore($scoreheading,$endy,$score->score_score);
                                break;
                        }
                }
                else
                    $wdoc->insertParaClonedFromBefore($scoreheading,$endy,"NO SCORE");
                if ($score && $score->score_comment->length() > 0)
                {
                    $comment = str_replace("\\n","\n",$score->score_comment->toWord());

                    $lines = explode("\n",$comment);
                    foreach($lines as $line)
                    {
                        $text = stripslashes($line);
                        if (strlen($text) > 0 )
                            $wdoc->insertParaClonedFromBefore($commentheading,$endy,$text);
                        else
                            $wdoc->insertParaClonedFromBefore($commentheading,$endy," ");
                    }
                    $wdoc->insertParaClonedFromBefore($commentheading,$endy," ");
                }
                else
                    $wdoc->insertParaClonedFromBefore($commentheading,$endy," ");
            }
        }

    }
}



$wdoc->deleteParagraphWithText('2874637545');
$wdoc->deleteParagraphWithText('4658667575');
$wdoc->deleteParagraphWithText('1275483537');
$wdoc->deleteParagraphWithText('7674563456');
$wdoc->deleteParagraphWithText('7856865457');
$wdoc->deleteParagraphWithText('7437453678');
$wdoc->deleteParagraphWithText('2537598346');
$wdoc->deleteParagraphWithText('SCORE');
$wdoc->deleteParagraphWithText('5673456787');
$wdoc->deleteParagraphWithText('4365376544');
$wdoc->deleteParagraphWithText('END');

$wdoc->SaveAs($reportTitle);
$myfile = fopen($reportTitle, "r");

$reportname = str_replace(" ","",$evaluator['user_name']);
$reportname = preg_replace( '/[\W]/', '', $reportname);

header("Content-Type: application/vnd.openxmlformats-officedocument.wordprocessingml.document");
header("Content-Disposition: attachment; filename=\"{$reportname}.docx\"");
echo fread($myfile,filesize($reportTitle));
fclose($myfile);
unset($_SESSION['ReportProgess']);
?>