<?php
use Swoole\Buffer;
session_start();
require './includes/classEvalSecure.php';
require './includes/classEvaluateDB.php';
require './includes/classFormList.php';
require './includes/classWordDoc.php';
require './includes/classEvalHelpers.php';
require './includes/classTime.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
Secure::CheckPage(SECURITY_VIEW);
$FL = new FormList(null);
$helpers = new helpers();

function var_error_log( $object=null ,$text='')
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( "{$text} {$contents}" );        // log contents of the result of var_dump( $object )
}


function replaceMarkerWith($marker,$with,$completepara=false)
{
    global $wdoc;
    if ($completepara)
    {
        $p1 = $wdoc->findParagraphWhichIncludesText($marker);
        if (!$p1)
        {
            error_log("Reporter [".__LINE__."] Unable to find marker {$marker}");
            return false;
        }
        if ($wdoc->newText($p1,$with) )
            return true;
        else
        {
            error_log("Reporter1 [".__LINE__."] replaceMarkerWith {$marker} failed.");
            return false;
        }
    }
    else
    {
        if ($wdoc->replaceText($marker,$with) )
            return true;
        else
        {
            error_log("Reporter1 [".__LINE__."] replaceMarkerWith {$marker} failed.");
            return false;
        }
    }
}

function htmlToWord($doc,$html,$parent,$template)
{
    $htmlDoc = new DOMDocument();
    $htmlDoc->loadHTML("<html><body>{$html}</body></html>");

    $body = $htmlDoc->getElementsByTagName("body");
    $children = $body->item(0)->childNodes;
    foreach ($children as $child)
    {
        if (strtoupper($child->nodeName) == "P")
        {
            $v = $template['p']->cloneNode(true);
            $doc->newText($v,$child->nodeValue);
            $parent->appendChild($v);
        }
        if (strtoupper($child->nodeName) == "UL")
        {
            $list = $child->childNodes;
            foreach ($list as $li)
            {
                if (strtoupper($li->nodeName) == "LI")
                {
                    $v = $template['li']->cloneNode(true);
                    $doc->newText($v,$li->nodeValue);
                    $parent->appendChild($v);
                }
            }
        }
    }
}

$reportsDir = $devt_environment->getkey("REPORTS_DIR");
$templatedir = $devt_environment->getkey("TEMPLATES_DIR");
$graphsdir = $devt_environment->getkey("GRAPHS_DIR");


$templatename = $templatedir . "/TemplateScore7.docx";
$reportTitle = $reportsDir . "/ProgressReport.docx";

$evalid = 0;
$phaseid = 0;
$dtNow = new DateTime('now');
$tableidx= 0;
$g_anon = 0;

$user = $DB->getUser($_SESSION['userid']);
if (!$user)
{
    header("Location: SecurityError.php");
    exit();
}
$dtNow->setTimezone(new DateTimeZone($user['user_timezone']));
$evaluation = null;

if (isset($_GET['v']))
{
    $a = $FL->decryptParamRaw($_GET['v']);
    $evalid = $a['eval'];
    $evaluation = $DB->getEvaluation($evalid);
}

if (!$evaluation)
{
    echo "Invalid evaluation parameter passed";
    exit();
}

//Get some evaluation details
$phase = $DB->getPhase($phaseid);

$wdoc = new WordDoc("/tmp/Report{$dtNow->format('YmdHis')}");
if (!$wdoc->open("{$templatename}") )
{
    echo "Unable to open template document {$templatename}";
    exit();
}

$results = array();
$r = $DB->allPhasesForEval($evaluation['idevaluation'],"order by phase_order");
while ($phase = $r->fetch_array(MYSQLI_ASSOC))
{
    $results[$phase['idphase']] = $DB->getProgress($evaluation['idevaluation'],$phase['idphase']);
    $results[$phase['idphase']] ['phase_name'] = $phase['phase_name'];
    $results[$phase['idphase']] ['status'] = $phase['phase_status'];
}


//********************************************************************
//Heading page
//********************************************************************
replaceMarkerWith('8237469438',$evaluation['evaluation_name'],true);

//Page 1 Date
replaceMarkerWith('4892372387',$dtNow->format('j F Y'),true);

$tableidx = $tableidx + 1;
$tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);


$row3 = $wdoc->findNthElement("w:tr",3,$tbl);
$row4 = $wdoc->findNthElement("w:tr",4,$tbl);
$row5 = $wdoc->findNthElement("w:tr",5,$tbl);
$cnt = 0;
foreach($results as $phaseid => $result)
{
    $strName = stripslashes($result['phase_name']);
    $strStatus = "";
    switch($result['status'])
    {
        case "defined":
            $strStatus = "Not Started";
            break;
        case "enabled":
            $strStatus = "In Progress";
            break;
        case "complete":
            $strStatus = "Completed";
            break;
    }

    $teams = $result['teams'];
    $sumAnswered = 0;
    $sumScores = 0;
    foreach ($teams as $team)
    {
        $totals = $team['totals'];
        $sumAnswered += $totals['totanswered'];
        $sumScores += $totals['totscores'];
    }
    if (floatval($sumScores) > 0.0)
        $perc = (floatval($sumAnswered) * 100.0) / floatval($sumScores);
    else
        $perc = 0.0;
    $strperc = sprintf("%4.1f%%",$perc);

    $nr = $row3->cloneNode(true);
    $wdoc->updateRowColumnText($nr,1,$strName);
    $wdoc->updateRowColumnText($nr,2,$strStatus);
    $wdoc->updateRowColumnText($nr,3,$strperc);

    $auditFirst = $DB->FirstScoreAuditForForPhase($evalid,$phaseid);
    if ($auditFirst)
    {
        $strTimeFirst = classTimeHelpers::timeFormat24Hr($auditFirst['audit_timestamp'],$user['user_timezone']);
        $wdoc->updateRowColumnText($nr,4,$strTimeFirst);

        $auditLast = $DB->LastScoreAuditForForPhase($evalid,$phaseid);
        if ($auditLast)
        {
            $strTimeLast = classTimeHelpers::timeFormat24Hr($auditLast['audit_timestamp'],$user['user_timezone']);
            $wdoc->updateRowColumnText($nr,5,$strTimeLast);

            if ($sumAnswered == $sumScores)
                $elapsed = (new DateTime($auditLast['audit_timestamp']))->getTimestamp() - (new DateTime($auditFirst['audit_timestamp']))->getTimestamp();
            else
                $elapsed = (new DateTime('now'))->getTimestamp() - (new DateTime($auditFirst['audit_timestamp']))->getTimestamp();
            $rate = $sumAnswered/$elapsed;  //rate per second
            $rateperDay = $rate * 3600 * 24;
            $strRatePerday = sprintf("%3.1f",$rateperDay);
            $wdoc->updateRowColumnText($nr,6,$strRatePerday);
            if ($sumAnswered != $sumScores)
            {
                $dtFinish = (new DateTime())->setTimestamp((new DateTime('now'))->getTimestamp() + ($sumScores-$sumAnswered)/$rate);
                $etc = classTimeHelpers::timeFormat24Hr($dtFinish,$user['user_timezone']);
                //$etcel = classTimeHelpers::smartTimeDiff($dtFinish);
                $wdoc->updateRowColumnText($nr,7,$etc);
            }
            else
                $wdoc->updateRowColumnText($nr,7,"");

        }
        else
        {
            $wdoc->updateRowColumnText($nr,5,"");
            $wdoc->updateRowColumnText($nr,6,"");
            $wdoc->updateRowColumnText($nr,7,"");
        }
    }
    else
    {
        $wdoc->updateRowColumnText($nr,4,"");
        $wdoc->updateRowColumnText($nr,5,"");
        $wdoc->updateRowColumnText($nr,6,"");
        $wdoc->updateRowColumnText($nr,7,"");
    }


    $wdoc->tableNewRow($tbl,$nr);
    $nr = $row4->cloneNode(true);
    $wdoc->tableNewRow($tbl,$nr);
    $cnt++;
}

//$wdoc->tableNewRow($tbl,$row4->cloneNode(true));
$wdoc->tableNewRow($tbl,$row5->cloneNode(true));

$wdoc->tableDeleteRow($tbl,2);
$wdoc->tableDeleteRow($tbl,2);
$wdoc->tableDeleteRow($tbl,2);


$heading2 = $wdoc->findParagraphWhichIncludesText('2874637545');
$body2 = $wdoc->findParagraphWhichIncludesText('5766767876');

$endy = $wdoc->findParagraphWhichIncludesText('ENDD');
$tableidx = $tableidx + 1;
$tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);
$tableidx = $tableidx + 1;
$tbl2 = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);


foreach($results as $phaseid => $result)
{
    $strName = stripslashes($result['phase_name']);
    $h2 = $heading2->cloneNode(true);
    $wdoc->newText($h2,"Phase " . stripslashes($result['phase_name']));
    $wdoc->insertParagraphBefore($h2,$endy);

    $b2 = $body2->cloneNode(true);
    $wdoc->newText($b2,"");
    $wdoc->insertParagraphBefore($b2,$endy);

    $nt = $tbl->cloneNode(true);
    $row3 = $wdoc->findNthElement("w:tr",3,$nt);
    $row4 = $wdoc->findNthElement("w:tr",4,$nt);
    $row5 = $wdoc->findNthElement("w:tr",5,$nt);

    $teams = $result['teams'];
    foreach($teams as $team)
    {
        $e = intval($team['evaluators']);
        if ($e > 0)
        {
            $strName = htmlspecialchars(stripslashes($team['name']));

            $totals = $team['totals'];
            $t = intval($totals['totscores']);
            $c = intval($totals['totanswered']);
            $e = intval($team['evaluators']);
            $strPerc = "0.0%";
            if ($t > 0)
                $strPerc = sprintf("%3.1f%%", 100.0 * $c/$t);

            $nr = $row3->cloneNode(true);
            $wdoc->updateRowColumnText($nr,1,$strName);
            $wdoc->updateRowColumnText($nr,2,$e);
            $wdoc->updateRowColumnText($nr,3,$strPerc);

            $firstAudit = $DB->FirstScoreAuditForForPhaseTeam($evalid,$phaseid,$team['id']);
            $lastAudit = $DB->LastScoreAuditForForPhaseTeam($evalid,$phaseid,$team['id']);

            if ($firstAudit)
            {
                $strTimeFirst = classTimeHelpers::timeFormat24Hr($firstAudit['audit_timestamp'],$user['user_timezone']);
                $wdoc->updateRowColumnText($nr,4,$strTimeFirst);
                if ($lastAudit)
                {
                    $strTimeFirst = classTimeHelpers::timeFormat24Hr($lastAudit['audit_timestamp'],$user['user_timezone']);
                    $wdoc->updateRowColumnText($nr,5,$strTimeFirst);

                    if ($c == $t)
                        $elapsed = (new DateTime($auditLast['audit_timestamp']))->getTimestamp() - (new DateTime($firstAudit['audit_timestamp']))->getTimestamp();
                    else
                        $elapsed = (new DateTime('now'))->getTimestamp() - (new DateTime($firstAudit['audit_timestamp']))->getTimestamp();
                    $rate = $c/$elapsed;  //rate per second
                    $rateperDay = $rate * 3600 * 24;
                    $strRatePerday = sprintf("%3.1f",$rateperDay);
                    $wdoc->updateRowColumnText($nr,6,$strRatePerday);
                    if ($c != $t)
                    {
                        $dtFinish = (new DateTime())->setTimestamp((new DateTime('now'))->getTimestamp() + ($t-$c)/$rate);
                        $etc = classTimeHelpers::timeFormat24Hr($dtFinish,$user['user_timezone']);
                        //$etcel = classTimeHelpers::smartTimeDiff($dtFinish);
                        $wdoc->updateRowColumnText($nr,7,$etc);
                    }
                    else
                        $wdoc->updateRowColumnText($nr,7,"");

                }
            }
            else
            {
                $wdoc->updateRowColumnText($nr,4,"");
                $wdoc->updateRowColumnText($nr,5,"");
                $wdoc->updateRowColumnText($nr,6,"");
                $wdoc->updateRowColumnText($nr,7,"");
            }
            $wdoc->tableNewRow($nt,$nr);

            $wdoc->tableNewRow($nt,$row4->cloneNode(true));
        }
    }

    $wdoc->tableNewRow($nt,$row5->cloneNode(true));

    $wdoc->tableDeleteRow($nt,2);
    $wdoc->tableDeleteRow($nt,2);
    $wdoc->tableDeleteRow($nt,2);

    $wdoc->insertParagraphBefore($nt,$endy);

}

$wdoc->deleteParagraphWithText('2874637545');
$wdoc->deleteParagraphWithText('5766767876');
$wdoc->tableDeleteTable($tbl);

$tbl = $tbl2;
$heading2 = $wdoc->findParagraphWhichIncludesText('2856485645');
$body2 = $wdoc->findParagraphWhichIncludesText('2384564585');
$heading3 = $wdoc->findParagraphWhichIncludesText('3646586787');
$body3 = $wdoc->findParagraphWhichIncludesText('4758679775');

$endy = $wdoc->findParagraphWhichIncludesText('ENDE');

foreach($results as $phaseid => $result)
{
    $strName = stripslashes($result['phase_name']);
    $h2 = $heading2->cloneNode(true);
    $wdoc->newText($h2,"Phase " . stripslashes($result['phase_name']));
    $wdoc->insertParagraphBefore($h2,$endy);

    $b2 = $body2->cloneNode(true);
    $wdoc->newText($b2,"");
    $wdoc->insertParagraphBefore($b2,$endy);

    $teams = $result['teams'];
    foreach($teams as $team)
    {
        if (count($team['users']) > 0)
        {
            $strTeam = htmlspecialchars(stripslashes($team['name']));
            $h3 = $heading3->cloneNode(true);
            $wdoc->newText($h3,$strTeam);
            $wdoc->insertParagraphBefore($h3,$endy);

            $b3 = $body3->cloneNode(true);
            $wdoc->newText($b3,"");
            $wdoc->insertParagraphBefore($b3,$endy);

            $nt = $tbl->cloneNode(true);
            $row3 = $wdoc->findNthElement("w:tr",3,$nt);
            $row4 = $wdoc->findNthElement("w:tr",4,$nt);
            $row5 = $wdoc->findNthElement("w:tr",5,$nt);


            $t = intval($team['totals']['totscoresperevaluator']);
            $usrs = $team['users'];
            foreach ($usrs as $us)
            {
                $strName = stripslashes($us['name']);
                $c = intval($us['scored']);
                $strPerc = "0.0%";
                if ($t > 0)
                    $strPerc = sprintf("%3.1f%%", 100.0 * $c/$t);

                $nr = $row3->cloneNode(true);
                $wdoc->updateRowColumnText($nr,1,$strName);
                $wdoc->updateRowColumnText($nr,2,$strPerc);

                $firstAudit = $DB->FirstScoreAuditForUserForPhaseForTeam($evalid,$us['id'],$phaseid,$team['id']);
                $lastAudit = $DB->LastScoreAuditForUserForPhaseForTeam($evalid,$us['id'],$phaseid,$team['id']);

                if ($firstAudit)
                {
                    $strTimeFirst = classTimeHelpers::timeFormat24Hr($firstAudit['audit_timestamp'],$user['user_timezone']);
                    $wdoc->updateRowColumnText($nr,3,$strTimeFirst);
                    if ($lastAudit)
                    {
                        $strTimeFirst = classTimeHelpers::timeFormat24Hr($lastAudit['audit_timestamp'],$user['user_timezone']);
                        $wdoc->updateRowColumnText($nr,4,$strTimeFirst);

                        if ($c == $t)
                            $elapsed = (new DateTime($auditLast['audit_timestamp']))->getTimestamp() - (new DateTime($firstAudit['audit_timestamp']))->getTimestamp();
                        else
                            $elapsed = (new DateTime('now'))->getTimestamp() - (new DateTime($firstAudit['audit_timestamp']))->getTimestamp();
                        $rate = $c/$elapsed;  //rate per second
                        $rateperDay = $rate * 3600 * 24;
                        $strRatePerday = sprintf("%3.1f",$rateperDay);
                        $wdoc->updateRowColumnText($nr,5,$strRatePerday);
                        if ($c != $t)
                        {
                            $dtFinish = (new DateTime())->setTimestamp((new DateTime('now'))->getTimestamp() + ($t-$c)/$rate);
                            $etc = classTimeHelpers::timeFormat24Hr($dtFinish,$user['user_timezone']);
                            //$etcel = classTimeHelpers::smartTimeDiff($dtFinish);
                            $wdoc->updateRowColumnText($nr,6,$etc);
                        }
                        else
                            $wdoc->updateRowColumnText($nr,6,"");

                    }
                }
                else
                {
                    $wdoc->updateRowColumnText($nr,3,"");
                    $wdoc->updateRowColumnText($nr,4,"");
                    $wdoc->updateRowColumnText($nr,5,"");
                    $wdoc->updateRowColumnText($nr,6,"");
                }

                $wdoc->tableNewRow($nt,$nr);
                $wdoc->tableNewRow($nt,$row4->cloneNode(true));
            }

            $wdoc->tableNewRow($nt,$row5->cloneNode(true));

            $wdoc->tableDeleteRow($nt,2);
            $wdoc->tableDeleteRow($nt,2);
            $wdoc->tableDeleteRow($nt,2);

            $wdoc->insertParagraphBefore($nt,$endy);


        }
    }
}

$wdoc->deleteParagraphWithText('2856485645');
$wdoc->deleteParagraphWithText('2384564585');
$wdoc->deleteParagraphWithText('3646586787');
$wdoc->deleteParagraphWithText('4758679775');
$wdoc->deleteParagraphWithText('ENDE');
$wdoc->deleteParagraphWithText('ENDD');
$wdoc->tableDeleteTable($tbl);

$wdoc->SaveAs($reportTitle);
$myfile = fopen($reportTitle, "r");
header("Content-Type: application/vnd.openxmlformats-officedocument.wordprocessingml.document");
echo fread($myfile,filesize($reportTitle));
fclose($myfile);
unset($_SESSION['ReportProgess']);
?>