<?php
session_start();
require './includes/classEvalSecure.php';
require './includes/classEvaluateDB.php';
require './includes/classFormList.php';
require './includes/classWordDoc.php';
require './includes/classEvalHelpers.php';
require './includes/classTime.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
Secure::CheckPage(SECURITY_ADMIN);
$FL = new FormList(null);
$helpers = new helpers();

function var_error_log( $object=null ,$text='')
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( "{$text} {$contents}" );        // log contents of the result of var_dump( $object )
}


function replaceMarkerWith($marker,$with,$completepara=false)
{
    global $wdoc;
    if ($completepara)
    {
        $p1 = $wdoc->findParagraphWhichIncludesText($marker);
        if (!$p1)
        {
            error_log("Reporter [".__LINE__."] Unable to find marker {$marker}");
            return false;
        }
        if ($wdoc->newText($p1,$with) )
            return true;
        else
        {
            error_log("Reporter1 [".__LINE__."] replaceMarkerWith {$marker} failed.");
            return false;
        }
    }
    else
    {
        if ($wdoc->replaceText($marker,$with) )
            return true;
        else
        {
            error_log("Reporter1 [".__LINE__."] replaceMarkerWith {$marker} failed.");
            return false;
        }
    }
}

function htmlToWord($doc,$html,$parent,$template)
{
    $htmlDoc = new DOMDocument();
    $htmlDoc->loadHTML("<html><body>{$html}</body></html>");

    $body = $htmlDoc->getElementsByTagName("body");
    $children = $body->item(0)->childNodes;
    foreach ($children as $child)
    {
        if (strtoupper($child->nodeName) == "P")
        {
            $v = $template['p']->cloneNode(true);
            $doc->newText($v,$child->nodeValue);
            $parent->appendChild($v);
        }
        if (strtoupper($child->nodeName) == "UL")
        {
            $list = $child->childNodes;
            foreach ($list as $li)
            {
                if (strtoupper($li->nodeName) == "LI")
                {
                    $v = $template['li']->cloneNode(true);
                    $doc->newText($v,$li->nodeValue);
                    $parent->appendChild($v);
                }
            }
        }
    }
}

$reportsDir = $devt_environment->getkey("REPORTS_DIR");
$templatedir = $devt_environment->getkey("TEMPLATES_DIR");
$graphsdir = $devt_environment->getkey("GRAPHS_DIR");


$templatename = $templatedir . "/TemplateScore6.docx";
$reportTitle = $reportsDir . "/BiasReport.docx";

$evalid = 0;
$phaseid = 0;
$dtNow = new DateTime('now');
$tableidx= 0;
$g_anon = 0;

$user = $DB->getUser($_SESSION['userid']);
if (!$user)
{
    header("Location: SecurityError.php");
    exit();
}
$dtNow->setTimezone(new DateTimeZone($user['user_timezone']));

if (isset($_GET['v']))
{
    $a = $FL->decryptParamRaw($_GET['v']);
    $evalid = $a['eval'];
    $phaseid = $a['phase'];
    $evaluation = $DB->getEvaluation($evalid);
}

if (!$evaluation)
{
    echo "Invalid evaluation parameter passed";
    exit();
}

//Get some evaluation details
$phase = $DB->getPhase($phaseid);

$wdoc = new WordDoc("/tmp/Report{$dtNow->format('YmdHis')}");
if (!$wdoc->open("{$templatename}") )
{
    echo "Unable to open template document {$templatename}";
    exit();
}

//********************************************************************
//Heading page
//********************************************************************
replaceMarkerWith('8237469438',$evaluation['evaluation_name'],true);

//Page 1 Date
replaceMarkerWith('4892372387',$dtNow->format('j F Y'),true);
replaceMarkerWith('3464578865',"Phase " . stripslashes($phase['phase_name']));


$heading2 = $wdoc->findParagraphWhichIncludesText('4856478586');
$heading3 = $wdoc->findParagraphWhichIncludesText('2475463854');
$body1 = $wdoc->findParagraphWhichIncludesText('1735478355');
$body3 = $wdoc->findParagraphWhichIncludesText('7645658765');
$body3bold = $wdoc->findParagraphWhichIncludesText('7657754533');

$tableidx = $tableidx + 1;
$tblPos = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);

$tableidx = $tableidx + 1;
$tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);


if (!$img1 = $wdoc->findImagePara(3) )
    error_log("Unable to find image 3");

$endy = $wdoc->findParagraphWhichIncludesText('END');

//********************************************************************
// Individual Evaluators
//********************************************************************
$teambias = array();
$r = $DB->allTeamsForEval($evalid);
while ($team = $r->fetch_array(MYSQLI_ASSOC))
{
    if ($DB->numUsersForTeamForPhase($team['idteam'],$phase['idphase']) > 0)
    {
        $rslt = $DB->evaluatorBias($evalid,$phase['idphase'],$team['idteam']);
        if ($rslt['status'])
        {
            $teambias[$team['idteam']] = array();
            $teambias[$team['idteam']] ['name'] = $team['team_name'];
            $teambias[$team['idteam']] ['data'] = $rslt['data'];
        }
        else
        {
            error_log("Bad result from form evaluator bias");
            var_error_log($rslt,"rslt");
        }
    }
}

$lastTeam = "rubishteamnameshjdgjhg";
foreach($teambias as $tid => $t)
{
    if ($lastTeam != $t['name'])
    {
        $lastTeam = $t['name'];
        $h2 = $heading2->cloneNode(true);
        $wdoc->newText($h2,stripslashes($t['name']));
        $wdoc->insertParagraphBefore($h2,$endy);
    }

    foreach($t['data'] as $e)
    {
        $wdoc->insertParaClonedFromBefore($heading3,$endy,stripslashes($e['name']));
        $wdoc->insertParaClonedFromBefore($body3,$endy," ");
        $wdoc->insertParaClonedFromBefore($body3bold,$endy,"RESPONDENT PLACINGS");
        $wdoc->insertParaClonedFromBefore($body3,$endy,"This following table shows the relative placings of each respondent for the evaluator and compares to the average for the rest of the team.");

        $nt = $tblPos->cloneNode(true);
        $row3 = $wdoc->findNthElement("w:tr",3,$nt);
        $row4 = $wdoc->findNthElement("w:tr",4,$nt);
        $row5 = $wdoc->findNthElement("w:tr",5,$nt);
        $row6 = $wdoc->findNthElement("w:tr",6,$nt);

        $mine = $e['placing'] ['own'];
        $others = $e['placing'] ['others'];

        $place1 = array();
        $place2 = array();
        foreach($mine as $rid => $place)
        {
            array_push($place1,$rid);
        }

        foreach($others as $rid => $place)
        {
            array_push($place2,$rid);
        }

        for ($cnt = 0;$cnt < count($mine);$cnt++)
        {
            if ($place1[$cnt] == $place2[$cnt])
            {
                $nr = $row3->cloneNode(true);
            }
            else
            {
                $nr = $row4->cloneNode(true);
            }
            $wdoc->updateRowColumnText($nr,1,$cnt+1);
            $resp = $DB->getRespondent($place1[$cnt]);
            if ($resp)
                $wdoc->updateRowColumnText($nr,2,stripslashes($resp['respondent_name_short']));
            $resp = $DB->getRespondent($place2[$cnt]);
            if ($resp)
                $wdoc->updateRowColumnText($nr,3,stripslashes($resp['respondent_name_short']));
            $wdoc->tableNewRow($nt,$nr);
        }

        $nr = $row5->cloneNode(true);
        $wdoc->tableNewRow($nt,$nr);
        $nr = $row6->cloneNode(true);
        $wdoc->tableNewRow($nt,$nr);


        $wdoc->tableDeleteRow($nt,2);
        $wdoc->tableDeleteRow($nt,2);
        $wdoc->tableDeleteRow($nt,2);
        $wdoc->tableDeleteRow($nt,2);

        $wdoc->insertParagraphBefore($nt,$endy);
        $wdoc->insertParaClonedFromBefore($body3,$endy," ");

        //Delete the template rows

        $nt = $tbl->cloneNode(true);
        $row3 = $wdoc->findNthElement("w:tr",3,$nt);
        $row4 = $wdoc->findNthElement("w:tr",4,$nt);
        $row5 = $wdoc->findNthElement("w:tr",5,$nt);

        foreach($e['respondents'] as $resp)
        {
            $nr = $row3->cloneNode(true);
            $wdoc->updateRowColumnText($nr,1,stripslashes($resp['name']));
            $strBias = sprintf("%3.1f%%",$resp['bias']*100.0);
            $wdoc->updateRowColumnText($nr,2,$strBias);
            $wdoc->tableNewRow($nt,$nr);
        }
        $wdoc->tableNewRow($nt,$row4->cloneNode(true));
        $wdoc->tableNewRow($nt,$row5->cloneNode(true));

        $wdoc->tableDeleteRow($nt,2);
        $wdoc->tableDeleteRow($nt,2);
        $wdoc->tableDeleteRow($nt,2);
        $wdoc->insertParagraphBefore($nt,$endy);


        $wdoc->insertParaClonedFromBefore($body3,$endy," ");



        if ($img1)
        {

            $strname = "/imgbias" . sprintf("%05d",intval($tid)) .  sprintf("%05d",intval($e['id']))   .  ".png";
            if ($graphdata = file_get_contents($graphsdir . $strname))
            {
                //Duplicate Image
                $newimg = $wdoc->duplicateImage(3);
                $wdoc->insertParagraphBefore($newimg,$endy);
                $maximage = $wdoc->findMaxImageNumber();
                $imgname = $wdoc->getImageParaFileName($maximage);
                $stripname = basename($imgname);
                $wdoc->replaceImage(basename($imgname),$graphdata);
            }
        }

    }
}


$wdoc->deleteParagraphWithText("4856478586");
$wdoc->deleteParagraphWithText("2475463854");
$wdoc->deleteParagraphWithText("7645658765");
$wdoc->deleteParagraphWithText("7657754533");
$wdoc->deleteParagraphWithText("1735478355");
$wdoc->deleteParagraph($tblPos);
$wdoc->deleteParagraph($tbl);
$wdoc->deleteParagraph($img1);


$wdoc->SaveAs($reportTitle);
$myfile = fopen($reportTitle, "r");
header("Content-Type: application/vnd.openxmlformats-officedocument.wordprocessingml.document");
echo fread($myfile,filesize($reportTitle));
fclose($myfile);
unset($_SESSION['ReportProgess']);
?>