<?php
session_start();
require './includes/classEvalSecure.php';
require './includes/classEvaluateDB.php';
require './includes/classFormList.php';
require './includes/classWordDoc.php';
require './includes/classEvalHelpers.php';
require './includes/classTime.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
Secure::CheckPage(SECURITY_ADMIN);
$FL = new FormList(null);
$helpers = new helpers();

function var_error_log( $object=null ,$text='')
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( "{$text} {$contents}" );        // log contents of the result of var_dump( $object )
}


function replaceMarkerWith($marker,$with,$completepara=false)
{
    global $wdoc;
    if ($completepara)
    {
        $p1 = $wdoc->findParagraphWhichIncludesText($marker);
        if (!$p1)
        {
            error_log("Reporter [".__LINE__."] Unable to find marker {$marker}");
            return false;
        }
        if ($wdoc->newText($p1,$with) )
            return true;
        else
        {
            error_log("Reporter1 [".__LINE__."] replaceMarkerWith {$marker} failed.");
            return false;
        }
    }
    else
    {
        if ($wdoc->replaceText($marker,$with) )
            return true;
        else
        {
            error_log("Reporter1 [".__LINE__."] replaceMarkerWith {$marker} failed.");
            return false;
        }
    }
}

function htmlToWord($doc,$html,$parent,$template)
{
    $htmlDoc = new DOMDocument();
    $htmlDoc->loadHTML("<html><body>{$html}</body></html>");

    $body = $htmlDoc->getElementsByTagName("body");
    $children = $body->item(0)->childNodes;
    foreach ($children as $child)
    {
        if (strtoupper($child->nodeName) == "P")
        {
            $v = $template['p']->cloneNode(true);
            $doc->newText($v,$child->nodeValue);
            $parent->appendChild($v);
        }
        if (strtoupper($child->nodeName) == "UL")
        {
            $list = $child->childNodes;
            foreach ($list as $li)
            {
                if (strtoupper($li->nodeName) == "LI")
                {
                    $v = $template['li']->cloneNode(true);
                    $doc->newText($v,$li->nodeValue);
                    $parent->appendChild($v);
                }
            }
        }
    }
}

function htmlToWordInsertBefore($doc,$html,$before,$template)
{
    $htmlDoc = new DOMDocument();
    $htmlDoc->loadHTML("<html><body>{$html}</body></html>");

    $body = $htmlDoc->getElementsByTagName("body");
    $children = $body->item(0)->childNodes;
    foreach ($children as $child)
    {
        if (strtoupper($child->nodeName) == "P")
        {
            $v = $template['p']->cloneNode(true);
            $doc->newText($v,$child->nodeValue);
            $doc->insertParagraphBefore($v,$before);
        }
        if (strtoupper($child->nodeName) == "UL")
        {
            $list = $child->childNodes;
            foreach ($list as $li)
            {
                if (strtoupper($li->nodeName) == "LI")
                {
                    $v = $template['li']->cloneNode(true);
                    $doc->newText($v,$li->nodeValue);
                    $doc->insertParagraphBefore($v,$before);
                }
            }
        }
    }
}


function getFirstHTML($html,$l)
{
    $htmlDoc = new DOMDocument();
    $htmlDoc->loadHTML("<html><body>{$html}</body></html>");

    $body = $htmlDoc->getElementsByTagName("body");
    $children = $body->item(0)->childNodes;
    foreach ($children as $child)
    {
        if (strtoupper($child->nodeName) == "P")
        {
            $text = trim(stripslashes($child->nodeValue));
            if (strlen($text) > $l)
                return substr($text,0,$l);
            else
                return $text;
        }
        if (strtoupper($child->nodeName) == "UL")
        {
            $list = $child->childNodes;
            foreach ($list as $li)
            {
                if (strtoupper($li->nodeName) == "LI")
                {
                    $text = "- " . trim(stripslashes($li->nodeValue));
                    if (strlen($text) > $l)
                        return substr($text,0,$l);
                    else
                        return $text;
                }
            }
        }
    }
    return "";
}

$reportsDir = $devt_environment->getkey("REPORTS_DIR");
$templatedir = $devt_environment->getkey("TEMPLATES_DIR");
$graphsdir = $devt_environment->getkey("GRAPHS_DIR");


$templatename = $templatedir . "/TemplateScore5.docx";
$reportTitle = $reportsDir . "/TeamReport.docx";

$evalid = 0;
$teamid = 0;
$phaseid = 0;
$evaluation = null;
$team = null;
$phase = null;

$dtNow = new DateTime('now');
$tableidx= 0;
$g_anon = 0;

$user = $DB->getUser($_SESSION['userid']);
if (!$user)
{
    header("Location: SecurityError.php");
    exit();
}
$dtNow->setTimezone(new DateTimeZone($user['user_timezone']));

if (isset($_GET['v']))
{
    $a = $FL->decryptParamRaw($_GET['v']);
    $evalid = $a['eval'];
    $teamid = $a['team'];
    $phaseid = $a['phase'];

    $evaluation = $DB->getEvaluation($evalid);
    $team = $DB->getTeam($teamid);
    $phase = $DB->getPhaseWithRule($phaseid);
}

if (!$evaluation)
{
    echo "Invalid evaluation parameter passed";
    exit();
}

if (!$team)
{
    echo "Invalid evaluation parameter passed";
    exit();
}

if (!$phase)
{
    echo "Invalid evaluation parameter passed";
    exit();
}

//Get some evaluation details
$numEvaluators =
$numResponders = $DB->numOfRespondents($evalid);
$numQuestions = $DB->numOfQuestionsForEval($evalid);
$numSections = $DB-> numOfSectionsForEval($evalid);
$numPhases = $DB->numPhasesForEval($evalid);
$strtotalweightings = sprintf("%3.1f%%",$evaluation['evaluation_total_weightings']*100.0);
$finalphase = $DB->getFinalPhase($evalid);

//Start and end phases
$startPhase = null;
$lastPhase = null;


$wdoc = new WordDoc("/tmp/Report{$dtNow->format('YmdHis')}");
if (!$wdoc->open("{$templatename}") )
{
    echo "Unable to open template document {$templatename}";
    exit();
}

//********************************************************************
//Heading page
//********************************************************************
replaceMarkerWith('8237469438',$evaluation['evaluation_name'],true);

//Page 1 Date
replaceMarkerWith('4892372387',$dtNow->format('j F Y'),true);

$strText = "TEAM " . trim(stripslashes($team['team_name']));
replaceMarkerWith('4875657568',$strText);

$strText = "PHASE " . trim(stripslashes($phase['phase_name']));
replaceMarkerWith('4657890856',$strText);

//********************************************************************
// TEAM SUMMARY
//********************************************************************

$strText = trim(stripslashes($team['team_name']));
replaceMarkerWith("3479857788",$strText);

$tableidx = $tableidx + 1;
$tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);

$wdoc->updateTableRowCol($tbl,2,2,$strText);
$strText = trim(stripslashes($phase['phase_name']));
$wdoc->updateTableRowCol($tbl,1,2,$strText);

switch ($phase['phase_status'])
{
    case 'defined';
        $strText = "Not Started";
        break;
    case 'enabled':
        $strText = "In Progress";
        break;
    case 'complete':
        $strText = "Complete";
        break;
}

$wdoc->updateTableRowCol($tbl,4,2,$strText);

if ($phase['phase_single_score'])
    $strText = "Single Score per Question";
else
    $strText = "Group Scoring";

$wdoc->updateTableRowCol($tbl,5,2,$strText);

if ($phase['phase_status'] != 'defined')
    $wdoc->updateTableRowCol($tbl,7,2,classTimeHelpers::timeFormat($phase['phase_start_timestamp'],"d/m/Y H:i",$user['user_timezone']));
else
    $wdoc->updateTableRowCol($tbl,7,2,"");

if ($phase['phase_status'] == 'complete')
    $wdoc->updateTableRowCol($tbl,8,2,classTimeHelpers::timeFormat($phase['phase_complete_timestamp'],"d/m/Y H:i",$user['user_timezone']));
else
    $wdoc->updateTableRowCol($tbl,8,2,"");

$audit = $DB->FirstScoreAuditForForPhase($evalid,$phase['idphase']);
$wdoc->updateTableRowCol($tbl,10,2,classTimeHelpers::timeFormat($audit['audit_timestamp'],"d/m/Y H:i",$user['user_timezone']));
$audit = $DB->LastScoreAuditForForPhase($evalid,$phase['idphase']);
$wdoc->updateTableRowCol($tbl,11,2,classTimeHelpers::timeFormat($audit['audit_timestamp'],"d/m/Y H:i",$user['user_timezone']));


$row14 = $wdoc->findNthElement("w:tr",14,$tbl);
$r = $DB->allUsersForTeam($team['idteam']);
while ($evaluator = $r->fetch_array(MYSQLI_ASSOC))
{
    $row = $row14->cloneNode(true);
    $strText = trim(stripslashes($evaluator['user_name']));
    $wdoc->updateRowColumnText($row,2,$strText);
    if ($DB->userHasPhase($evaluator['iduser'],$phase['idphase']))
        $wdoc->updateRowColumnText($row,3,"YES");
    else
        $wdoc->updateRowColumnText($row,3,"");
    $wdoc->tableNewRow($tbl,$row);
}
$wdoc->tableDeleteRow($tbl,13);


//********************************************************************
// Overeview
//********************************************************************
//Determine actual start which is the lesser of first score and first phase enabled.

//********************************************************************
// QUESTIONS
//********************************************************************

$heading2 = $wdoc->findParagraphWhichIncludesText("5647890456");
$questiontext = $wdoc->findParagraphWhichIncludesText("3469238565");
$bullettext = $wdoc->findParagraphWhichIncludesText("3456933425");
$endy = $wdoc->findParagraphWhichIncludesText("END");
$heading3 = $wdoc->findParagraphWhichIncludesText("2999786457");
$para3 = $wdoc->findParagraphWhichIncludesText("8465768344");
$heading4 = $wdoc->findParagraphWhichIncludesText("4735475967");
$para4 = $wdoc->findParagraphWhichIncludesText("3674545756");
$h4li = $wdoc->findParagraphWhichIncludesText("3475869755");


$questiontemplates = ["p" => $questiontext,"li" => $bullettext];
$subtemplates = ["p" => $para4,"li" => $h4li];

$tableidx = $tableidx + 1;
$tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);


$r = $DB->allQuestionsForTeam($team['idteam']);
while ($question = $r->fetch_array(MYSQLI_ASSOC))
{
    $score_type = $question['question_type'];

    $hasSubs = false;
    $h2 = $heading2->cloneNode(true);
    $strText = "Question " . trim(stripslashes($question['question_identifier']));
    $wdoc->newText($h2,$strText);
    $wdoc->insertParagraphBefore($h2,$endy);

    //Question text
    if (substr($question['question_text'],0,1) == "<")
    {
        htmlToWordInsertBefore($wdoc,$question['question_text'],$endy,$questiontemplates);
    }
    else
    {
        $qt = $questiontext->cloneNode(true);
        $strText = trim(stripslashes($question['question_text']));
        $wdoc->newText($qt,$strText);
        $wdoc->insertParagraphBefore($qt,$endy);
    }

    //Does this question have sub attribute
    $r3 = $DB->allSubForQuestion($question['idquestion']);
    if ($r3->num_rows > 0)
    {
        $hasSubs = true;
        $h3 = $heading3->cloneNode(true);
        $wdoc->newText($h3,"Question Sub-Attributes");
        $wdoc->insertParagraphBefore($h3,$endy);

        while ($sub = $r3->fetch_array(MYSQLI_ASSOC))
        {
            $h4 = $heading4->cloneNode(true);
            $strText = "Sub attribute " . trim(stripslashes($sub['subattribute_number']));
            $wdoc->newText($h4,$strText);
            $wdoc->insertParagraphBefore($h4,$endy);

            //Sub-attribute text
            if (substr($sub['subattribute_txt'],0,1) == "<")
            {
                htmlToWordInsertBefore($wdoc,$sub['subattribute_txt'],$endy,$subtemplates);
            }
            else
            {
                $p2 = $para4->cloneNode(true);
                $strText = trim(stripslashes($sub['subattribute_txt']));
                $wdoc->newText($p2,$strText);
                $wdoc->insertParagraphBefore($p2,$endy);
            }
        }
    }


    //Blank line
    $p1 = $questiontext->cloneNode(true);
    $wdoc->newText($p1,"");
    $wdoc->insertParagraphBefore($p1,$endy);






    $h3 = $heading3->cloneNode(true);
    $wdoc->newText($h3,"Raw Scores");
    $wdoc->insertParagraphBefore($h3,$endy);

    if ($phase['phase_single_score'])
    {
        //Blank line
        $p1 = $questiontext->cloneNode(true);
        $wdoc->newText($p1,"");
        $wdoc->insertParagraphBefore($p1,$endy);

        //Table

        $nt = $tbl->cloneNode(true);
        $row3 = $wdoc->findNthElement("w:tr",3,$nt);
        $row4 = $wdoc->findNthElement("w:tr",4,$nt);
        $row5 = $wdoc->findNthElement("w:tr",5,$nt);

        $row1 = $wdoc->findNthElement("w:tr",1,$nt);
        if ($hasSubs)
            $wdoc->updateRowColumnText($row1,2,"SUB ATTRIBUTE");
        else
            $wdoc->updateRowColumnText($row1,2,"");

        //Do we have sub attributes for the question
        $r3 = $DB->allSubForQuestion($question['idquestion']);
        if ($r3->num_rows > 0)
        {
            while ($sub = $r3->fetch_array(MYSQLI_ASSOC))
            {
                $score_type = $sub['subattribute_type'];

                //Each respondent
                $r2 = $DB->allRespondentsForEval($evalid, "order by respondent_name_full");
                while ($respondent = $r2->fetch_array(MYSQLI_ASSOC))
                {
                    $score = $DB->o_getScoreForQuestionSinglePhase($evalid,$phase['idphase'],$question['idquestion'],$sub['idsubattribute'],$respondent['idrespondent']);
                    $row = $row3->cloneNode(true);
                    $strText = trim(stripslashes($respondent['respondent_name_full']));
                    $wdoc->updateRowColumnText($row,1,$strText);
                    $wdoc->updateRowColumnText($row,2,$sub['subattribute_number']);
                    if ($score && $score->score_score !== null)
                    {
                        $display_score = "";
                        switch ($score_type)
                        {
                            case 'range':
                                $display_score = $score->score_score;
                                break;
                            case 'boolean':
                                if ($score->score_score > 0)
                                    $display_score = "YES";
                                else
                                    $display_score = "NO";
                                break;
                            default:
                                $display_score = $score->score_score;
                                break;
                        }
                        $wdoc->updateRowColumnText($row,3,$display_score);
                    }
                    else
                        $wdoc->updateRowColumnText($row,3,"");
                    $wdoc->tableNewRow($nt,$row);
                }
                $wdoc->tableNewRow($nt,$row4->cloneNode(true));
            }
        }
        else
        {
            //Each respondent
            $r2 = $DB->allRespondentsForEval($evalid, "order by respondent_name_full");
            while ($respondent = $r2->fetch_array(MYSQLI_ASSOC))
            {
                $score = $DB->o_getScoreForQuestionSinglePhase($evalid,$phase['idphase'],$question['idquestion'],0,$respondent['idrespondent']);
                $row = $row3->cloneNode(true);
                $strText = trim(stripslashes($respondent['respondent_name_full']));
                $wdoc->updateRowColumnText($row,1,$strText);
                $wdoc->updateRowColumnText($row,2,"");
                if ($score && $score->score_score !== null)
                {
                    $display_score = "";
                    switch ($score_type)
                    {
                        case 'range':
                            $display_score = $score->score_score;
                            break;
                        case 'boolean':
                            if ($score->score_score > 0)
                                $display_score = "YES";
                            else
                                $display_score = "NO";
                            break;
                        default:
                            $display_score = $score->score_score;
                            break;
                    }
                    $wdoc->updateRowColumnText($row,3,$display_score);
                }
                else
                    $wdoc->updateRowColumnText($row,3,"");
                $wdoc->tableNewRow($nt,$row);
            }
        }

        $wdoc->tableNewRow($nt,$row5->cloneNode(true));

        $wdoc->tableDeleteRow($nt,2);
        $wdoc->tableDeleteRow($nt,2);
        $wdoc->tableDeleteRow($nt,2);


        $wdoc->insertParagraphBefore($nt,$endy);


        //Blank line
        $p1 = $questiontext->cloneNode(true);
        $wdoc->newText($p1,"");
        $wdoc->insertParagraphBefore($p1,$endy);

        //Now the comments
        $h3 = $heading3->cloneNode(true);
        $wdoc->newText($h3,"Comments");
        $wdoc->insertParagraphBefore($h3,$endy);

        $p3 = $para3->cloneNode(true);
        $wdoc->newText($p3,"The following team comments were made for each respondent.");
        $wdoc->insertParagraphBefore($p3,$endy);


        //Do we have sub attributes for the question
        $r3 = $DB->allSubForQuestion($question['idquestion']);
        if ($r3->num_rows > 0)
        {
            while ($sub = $r3->fetch_array(MYSQLI_ASSOC))
            {
                //Each respondent
                $r2 = $DB->allRespondentsForEval($evalid, "order by respondent_name_full");
                while ($respondent = $r2->fetch_array(MYSQLI_ASSOC))
                {
                    $score = $DB->o_getScoreForQuestionSinglePhase($evalid,$phase['idphase'],$question['idquestion'],$sub['idsubattribute'],$respondent['idrespondent']);
                    $h4 = $heading4->cloneNode(true);
                    $strText = trim(stripslashes($respondent['respondent_name_full']));
                    $strText .= " Sub-attribute {$sub['subattribute_number']}";
                    $wdoc->newText($h4,$strText);
                    $wdoc->insertParagraphBefore($h4,$endy);

                    if ($score && $score->score_comment->length() > 0)
                    {
                        $comnt = str_replace("\\n","\n",$score->score_comment->toWord());
                        $lines = explode("\n",$comnt);
                        $cnt = 0;
                        foreach($lines as $line)
                        {
                            $p4 = $para4->cloneNode(true);
                            $wdoc->newText($p4,trim(stripslashes($line)));
                            $wdoc->insertParagraphBefore($p4,$endy);
                        }
                    }
                    else
                    {
                        $p4 = $para4->cloneNode(true);
                        $wdoc->newText($p4," ");
                        $wdoc->insertParagraphBefore($p4,$endy);
                    }
                }
            }
        }
        else
        {
            $r2 = $DB->allRespondentsForEval($evalid, "order by respondent_name_full");
            while ($respondent = $r2->fetch_array(MYSQLI_ASSOC))
            {
                $score = $DB->o_getScoreForQuestionSinglePhase($evalid,$phase['idphase'],$question['idquestion'],0,$respondent['idrespondent']);

                $h4 = $heading4->cloneNode(true);
                $strText = trim(stripslashes($respondent['respondent_name_full']));
                $wdoc->newText($h4,$strText);
                $wdoc->insertParagraphBefore($h4,$endy);

                if ($score && $score->score_comment->length() > 0)
                {
                    $comnt = str_replace("\\n","\n",$score->score_comment->toWord());
                    $lines = explode("\n",$comnt);
                    $cnt = 0;
                    foreach($lines as $line)
                    {
                        $p4 = $para4->cloneNode(true);
                        $wdoc->newText($p4,trim(stripslashes($line)));
                        $wdoc->insertParagraphBefore($p4,$endy);
                    }
                }
                else
                {
                    $p4 = $para4->cloneNode(true);
                    $wdoc->newText($p4," ");
                    $wdoc->insertParagraphBefore($p4,$endy);
                }
            }
        }
    }
    else
    {
        //Comment that scores are not being documented
        $p1 = $questiontext->cloneNode(true);
        $wdoc->newText($p1,"Scores not listed in this report as multiple evaluators have scored each question.  Use the moderation reports for score assistance.");
        $wdoc->insertParagraphBefore($p1,$endy);
    }
}


//Delete the template
$wdoc->deleteParagraphWithText('5647890456');
$wdoc->deleteParagraphWithText('3469238565');
$wdoc->deleteParagraphWithText('3456933425');
$wdoc->deleteParagraphWithText('2999786457');
$wdoc->deleteParagraphWithText('8465768344');
$wdoc->deleteParagraphWithText('4735475967');
$wdoc->deleteParagraphWithText('3674545756');
$wdoc->deleteParagraphWithText('3475869755');
$wdoc->tableDeleteTable($tbl);


$wdoc->SaveAs($reportTitle);
$myfile = fopen($reportTitle, "r");
header("Content-Type: application/vnd.openxmlformats-officedocument.wordprocessingml.document");
header('Content-Disposition: attachment; filename="TeamReport.docx"');
echo fread($myfile,filesize($reportTitle));
fclose($myfile);
unset($_SESSION['ReportProgess']);
?>