<?php
session_start();
require './includes/classEvalSecure.php';
require './includes/classEvaluateDB.php';
require './includes/classFormList.php';
require './includes/classWordDoc.php';
require './includes/classEvalHelpers.php';
require './includes/classTime.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
Secure::CheckPage(SECURITY_ADMIN);
$FL = new FormList(null);
$helpers = new helpers();

function var_error_log( $object=null ,$text='')
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( "{$text} {$contents}" );        // log contents of the result of var_dump( $object )
}


function replaceMarkerWith($marker,$with,$completepara=false)
{
    global $wdoc;
    if ($completepara)
    {
        $p1 = $wdoc->findParagraphWhichIncludesText($marker);
        if (!$p1)
        {
            error_log("Reporter [".__LINE__."] Unable to find marker {$marker}");
            return false;
        }
        if ($wdoc->newText($p1,$with) )
            return true;
        else
        {
            error_log("Reporter1 [".__LINE__."] replaceMarkerWith {$marker} failed.");
            return false;
        }
    }
    else
    {
        if ($wdoc->replaceText($marker,$with) )
            return true;
        else
        {
            error_log("Reporter1 [".__LINE__."] replaceMarkerWith {$marker} failed.");
            return false;
        }
    }
}

function htmlToWord($doc,$html,$parent,$template)
{
    $htmlDoc = new DOMDocument();
    $htmlDoc->loadHTML("<html><body>{$html}</body></html>");

    $body = $htmlDoc->getElementsByTagName("body");
    $children = $body->item(0)->childNodes;
    foreach ($children as $child)
    {
        if (strtoupper($child->nodeName) == "P")
        {
            $v = $template['p']->cloneNode(true);
            $doc->newText($v,$child->nodeValue);
            $parent->appendChild($v);
        }
        if (strtoupper($child->nodeName) == "UL")
        {
            $list = $child->childNodes;
            foreach ($list as $li)
            {
                if (strtoupper($li->nodeName) == "LI")
                {
                    $v = $template['li']->cloneNode(true);
                    $doc->newText($v,$li->nodeValue);
                    $parent->appendChild($v);
                }
            }
        }
    }
}


function getFirstHTML($html,$l)
{
    $htmlDoc = new DOMDocument();
    $htmlDoc->loadHTML("<html><body>{$html}</body></html>");

    $body = $htmlDoc->getElementsByTagName("body");
    $children = $body->item(0)->childNodes;
    foreach ($children as $child)
    {
        if (strtoupper($child->nodeName) == "P")
        {
            $text = trim(stripslashes($child->nodeValue));
            if (strlen($text) > $l)
                return substr($text,0,$l);
            else
                return $text;
        }
        if (strtoupper($child->nodeName) == "UL")
        {
            $list = $child->childNodes;
            foreach ($list as $li)
            {
                if (strtoupper($li->nodeName) == "LI")
                {
                    $text = "- " . trim(stripslashes($li->nodeValue));
                    if (strlen($text) > $l)
                        return substr($text,0,$l);
                    else
                        return $text;
                }
            }
        }
    }
    return "";
}

$reportsDir = $devt_environment->getkey("REPORTS_DIR");
$templatedir = $devt_environment->getkey("TEMPLATES_DIR");
$graphsdir = $devt_environment->getkey("GRAPHS_DIR");


$templatename = $templatedir . "/TemplateEvaluationReport.docx";
$reportTitle = $reportsDir . "/ConfigurationReport.docx";

$evalid = 0;
$dtNow = new DateTime('now');
$tableidx= 0;
$g_anon = 0;

$user = $DB->getUser($_SESSION['userid']);
if (!$user)
{
    header("Location: SecurityError.php");
    exit();
}
$dtNow->setTimezone(new DateTimeZone($user['user_timezone']));

if (isset($_GET['v']))
{
    $a = $FL->decryptParamRaw($_GET['v']);
    $evalid = $a['eval'];
    //$g_anon = intval($a['anon']);
    $evaluation = $DB->getEvaluation($evalid);
}

if (!$evaluation)
{
    echo "Invalid evaluation parameter passed";
    exit();
}

//Get some evaluation details
$numEvaluators =
$numResponders = $DB->numOfRespondents($evalid);
$numQuestions = $DB->numOfQuestionsForEval($evalid);
$numSections = $DB-> numOfSectionsForEval($evalid);
$numPhases = $DB->numPhasesForEval($evalid);
$strtotalweightings = sprintf("%3.1f%%",$evaluation['evaluation_total_weightings']*100.0);
$finalphase = $DB->getFinalPhase($evalid);

//Start and end phases
$startPhase = null;
$lastPhase = null;

$bf = false;
$r = $DB->allPhasesForEval($evalid,"order by phase_order");
while ($phase = $r->fetch_array(MYSQLI_ASSOC))
{
    if (!$bf)
    {
        $startPhase = $phase;
        $bf = true;
    }
    $lastPhase = $phase;
}



$wdoc = new WordDoc("/tmp/Report{$dtNow->format('YmdHis')}");
if (!$wdoc->open("{$templatename}") )
{
    echo "Unable to open template document {$templatename}";
    exit();
}

//********************************************************************
//Heading page
//********************************************************************
replaceMarkerWith('8237469438',$evaluation['evaluation_name'],true);

//Page 1 Date
replaceMarkerWith('4892372387',$dtNow->format('j F Y'),true);


//********************************************************************
// EVALUATION SUMMARY
//********************************************************************

//********************************************************************
// Overeview
//********************************************************************
//Determine actual start which is the lesser of first score and first phase enabled.



//********************************************************************
// heading quetsions
//********************************************************************
//number of questions and sections
replaceMarkerWith('2094638937',$numQuestions);
replaceMarkerWith('5459673456',$numSections);
replaceMarkerWith('3856624596',$strtotalweightings);

//List the questions
$tableidx = $tableidx + 1;
$tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);
$secitionrow = $wdoc->findNthElement("w:tr",3,$tbl);
$questionrow = $wdoc->findNthElement("w:tr",4,$tbl);

$bulletrow = $wdoc->findNthElement("w:tr",5,$tbl);
$tc = $wdoc->findNthElement(WORDDOC_TABLE_CELL,4,$bulletrow);
//Find normal and bullet paras
$questionpara = $wdoc->findNthElement("w:p",1,$tc);
$bulletpara = $wdoc->findNthElement("w:p",2,$tc);

$questiontemplates = ["p" => $questionpara,"li" => $bulletpara];

$subattributerow = $wdoc->findNthElement("w:tr",6,$tbl);
$lastrow = $wdoc->findNthElement("w:tr",7,$tbl);

$sectionName = '';

$r = $DB->allQuestionsForEvalWithSection($evalid, "order by section_order,question_order");
while ($quest = $r->fetch_array(MYSQLI_ASSOC))
{
    if ($sectionName != $quest['section_name'])
    {
        $sectionName = $quest['section_name'];
        $newsection = $secitionrow->cloneNode(true);
        $col1 = $wdoc->findNthElement("w:tc",1,$newsection);
        $wdoc->replaceText('5498733492',$sectionName,$col1);
        $nr = $tbl->appendChild($newsection);
    }
    $strweight = sprintf("%3.2f%%",$quest['question_weighting'] * 100);

    $newq = $questionrow->cloneNode(true);
    $col2 = $wdoc->findNthElement("w:tc",2,$newq);
    $col3 = $wdoc->findNthElement("w:tc",3,$newq);
    $col4 = $wdoc->findNthElement("w:tc",4,$newq);
    $wdoc->replaceText('2982',$quest['question_identifier'],$col2);
    $wdoc->replaceText('2983',$strweight,$col3);
    if (substr($quest['question_text'],0,1) == "<")
    {
        $p = $wdoc->findParagraphWhichIncludesText("3984395464",$col4);
        $wdoc->deleteParagraph($p);
        htmlToWord($wdoc,$quest['question_text'],$col4,$questiontemplates);
    }
    else
    {
        $wdoc->replaceText('3984395464',$quest['question_text'],$col4);
    }
    $nr = $tbl->appendChild($newq);

    //Sub-attributes
    if ($DB->numOfSubsForQuestion($quest['idquestion']) > 0)
    {
        $r1 = $DB->allSubForQuestion($quest['idquestion'],"order by subattribute_number");
        while ($sub = $r1->fetch_assoc())
        {
            $newsub = $subattributerow->cloneNode(true);

            $col4 = $wdoc->findNthElement("w:tc",4,$newsub);
            $wdoc->replaceText('2987',$sub['subattribute_number'],$col4);

            $col5 = $wdoc->findNthElement("w:tc",5,$newsub);
            $strweight = sprintf("%3.2f%%",$sub['subattribute_weighting'] * 100.0);
            $wdoc->replaceText('2988',$strweight,$col5);

            $col6 = $wdoc->findNthElement("w:tc",6,$newsub);
            if (substr($sub['subattribute_txt'],0,1) == "<")
            {
                $p = $wdoc->findParagraphWhichIncludesText("3985456",$col6);
                $wdoc->deleteParagraph($p);
                htmlToWord($wdoc,$sub['subattribute_txt'],$col6,$questiontemplates);
            }
            else
            {
                $wdoc->replaceText('3985456',$sub['subattribute_txt'],$col6);
            }

            $nr = $tbl->appendChild($newsub);
        }
    }

}
$newq = $lastrow->cloneNode(true);
$nr = $tbl->appendChild($newq);

$wdoc->tableDeleteRow($tbl,1);
$wdoc->tableDeleteRow($tbl,1);
$wdoc->tableDeleteRow($tbl,1);
$wdoc->tableDeleteRow($tbl,1);
$wdoc->tableDeleteRow($tbl,1);
$wdoc->tableDeleteRow($tbl,1);

//********************************************************************
// Evaluation teams
//********************************************************************
$r = $DB->allTeamsForEval($evalid,'order by team_name');
replaceMarkerWith('8548769463',$r->num_rows);


$tableidx = $tableidx + 1;
$tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);

$teamnamerow = $wdoc->findNthElement("w:tr",3,$tbl);
$namerow = $wdoc->findNthElement("w:tr",4,$tbl);
$blankrow = $wdoc->findNthElement("w:tr",5,$tbl);
$totlarow = $wdoc->findNthElement("w:tr",7,$tbl);

$tbl->appendChild($blankrow->cloneNode(true));
$qcount = 0;
while ($team = $r->fetch_array(MYSQLI_ASSOC))
{

    $t1 = $teamnamerow->cloneNode(true);
    $col1 = $wdoc->findNthElement("w:tc",1,$t1);
    $col2 = $wdoc->findNthElement("w:tc",2,$t1);
    $col3 = $wdoc->findNthElement("w:tc",3,$t1);
    $wdoc->replaceText('4756485869',$team['team_name'],$col1);
    $r2 = $DB->allQuestionsForTeam($team['idteam']);
    $qcount += $r2->num_rows;
    $wdoc->replaceText('2984',$r2->num_rows,$col2);
    $r3 = $DB->allUsersForTeam($team['idteam']);
    $bf = false;
    while ($teamuser = $r3->fetch_array(MYSQLI_ASSOC))
    {
        $name = stripslashes($teamuser['user_name']);
        if ($g_anon != 0)
            $name = "Evaluator {$teamuser['iduser']}";
        if (!$bf)
        {

            $wdoc->replaceText('3567856768',$name,$col3);
            $bf = true;
            $nr = $tbl->appendChild($t1);
            $t1 = null;
        }
        else
        {
            $t2 = $namerow->cloneNode(true);
            $col3 = $wdoc->findNthElement("w:tc",3,$t2);
            $wdoc->replaceText('4255495663',$name,$col3);
            $nr = $tbl->appendChild($t2);

        }
    }
    if ($t1)
        $nr = $tbl->appendChild($t1);
    $tbl->appendChild($blankrow->cloneNode(true));
}
$tbl->appendChild($blankrow->cloneNode(true));
$t3 = $totlarow->cloneNode(true);
$col2 = $wdoc->findNthElement("w:tc",2,$t3);
$wdoc->replaceText('2985',$qcount,$col2);
$nr = $tbl->appendChild($t3);

$wdoc->tableDeleteRow($tbl,2);
$wdoc->tableDeleteRow($tbl,2);
$wdoc->tableDeleteRow($tbl,2);
$wdoc->tableDeleteRow($tbl,2);
$wdoc->tableDeleteRow($tbl,2);
$wdoc->tableDeleteRow($tbl,2);

if ($qcount > $numQuestions)
{
    replaceMarkerWith('8735474352',$qcount);
    replaceMarkerWith('2348552845',$numQuestions);
}
else
    $wdoc->deleteParagraphWithText('8735474352');


//********************************************************************
// Team Questions
//********************************************************************
$tableidx = $tableidx + 1;
$tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);

$row3 = $wdoc->findNthElement("w:tr",3,$tbl);
$row4 = $wdoc->findNthElement("w:tr",4,$tbl);
$row5 = $wdoc->findNthElement("w:tr",5,$tbl);
$row6 = $wdoc->findNthElement("w:tr",6,$tbl);

$r = $DB->allTeamsForEval($evalid,'order by team_name');
while ($team = $r->fetch_array(MYSQLI_ASSOC))
{
    $nr = $row3->cloneNode(true);
    $teamname = stripslashes($team['team_name']);
    $wdoc->updateRowColumnText($nr,1,$teamname);
    $tbl->appendChild($nr);

    $r2 = $DB->allQuestionsForTeam($team['idteam']);
    while ($quest =  $r2->fetch_array(MYSQLI_ASSOC))
    {
        $nr = $row4->cloneNode(true);
        $qident = stripslashes($quest['question_identifier']);
        $wdoc->updateRowColumnText($nr,2,$qident);
        //Create first few characters of text
        $text = trim(stripslashes($quest['question_text']));
        $l = 60;
        if (substr($text,0,1) == "<")
            $text = getFirstHTML($text,$l);
        else
        {
            if (strlen($text) > $l)
                $text = substr($text,0,$l);
        }
        if (strlen($text) == $l)
            $text .= "...";
        $wdoc->updateRowColumnText($nr,3,$text);
        $tbl->appendChild($nr);
    }
    $tbl->appendChild($row5->cloneNode(true));
}

$tbl->appendChild($row6->cloneNode(true));
$wdoc->tableDeleteRow($tbl,2);
$wdoc->tableDeleteRow($tbl,2);
$wdoc->tableDeleteRow($tbl,2);
$wdoc->tableDeleteRow($tbl,2);



//********************************************************************
// Rules
//********************************************************************
$tableidx = $tableidx + 1;
$tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);
$row3 = $wdoc->findNthElement("w:tr",3,$tbl);
$row5 = $wdoc->findNthElement("w:tr",5,$tbl);

$r = $DB->allRulesForEval($evalid);
while ($rule = $r->fetch_array(MYSQLI_ASSOC))
{
    $nr = $row3->cloneNode(true);
    $str = stripslashes($rule['rule_name']);
    $wdoc->updateRowColumnText($nr,1,$str);
    $wdoc->updateRowColumnText($nr,2,$rule['rule_min']);
    $wdoc->updateRowColumnText($nr,3,$rule['rule_max']);
    $wdoc->updateRowColumnText($nr,4,$rule['rule_mod']);
    $wdoc->tableNewRow($tbl,$nr);
}
$wdoc->tableNewRow($tbl,$row5->cloneNode(true));

$wdoc->tableDeleteRow($tbl,1);
$wdoc->tableDeleteRow($tbl,1);
$wdoc->tableDeleteRow($tbl,1);
$wdoc->tableDeleteRow($tbl,1);

//********************************************************************
// Phases
//********************************************************************
$tableidx = $tableidx + 1;
if ($numPhases > 1)
{
    replaceMarkerWith('2348512047',$numPhases);
    $wdoc->deleteParagraphWithText('2348512049');
}
else
{
    replaceMarkerWith('2348512049',"");
    $wdoc->deleteParagraphWithText('2348512047');
}

$tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);
$row3 = $wdoc->findNthElement("w:tr",3,$tbl);
$row5 = $wdoc->findNthElement("w:tr",5,$tbl);

$r = $DB->allPhasesForEvalWithRule($evalid,"order by phase_order");
while ($phase = $r->fetch_array(MYSQLI_ASSOC))
{
    $nr = $row3->cloneNode(true);
    $wdoc->updateRowColumnText($nr,1,$phase['phase_name']);
    if ($phase['phase_single_score'])
        $wdoc->updateRowColumnText($nr,2,"Single");
    else
        $wdoc->updateRowColumnText($nr,2,"Group");
    $strRule = stripslashes($phase['rule_name']);
    $wdoc->updateRowColumnText($nr,3,$strRule);
    $wdoc->tableNewRow($tbl,$nr);
}

$wdoc->tableNewRow($tbl,$row5->cloneNode(true));

$wdoc->tableDeleteRow($tbl,1);
$wdoc->tableDeleteRow($tbl,1);
$wdoc->tableDeleteRow($tbl,1);
$wdoc->tableDeleteRow($tbl,1);



//********************************************************************
// Respondents
//********************************************************************
if ($numResponders > 1)
    replaceMarkerWith('2372423535',"{$numResponders} respondents:");
else
if ($numResponders== 1)
    replaceMarkerWith('2372423535',"{$numResponders} respondent:");
else
    replaceMarkerWith('2372423535',"no respondents:");

$h3 = $wdoc->findParagraphWhichIncludesText("2956635458");
$b3 = $wdoc->findParagraphWhichIncludesText("3487563865");
$endy = $wdoc->findParagraphWhichIncludesText("8273463894");

$r = $DB->allRespondentsForEval($evalid,"order by respondent_name_full");
while ($respondent = $r->fetch_array(MYSQLI_ASSOC))
{
    $h3n = $h3->cloneNode(true);
    $wdoc->newText($h3n,stripslashes($respondent['respondent_name_full']));
    $wdoc->insertParagraphBefore($h3n,$endy);

    $b3n = $b3->cloneNode(true);
    $wdoc->replaceText('3487563865',"",$b3n);
    $wdoc->insertParagraphBefore($b3n,$endy);

}

$wdoc->deleteParagraphWithText("2956635458");
$wdoc->deleteParagraphWithText("3487563865");
$wdoc->deleteParagraphWithText("8273463894");

//********************************************************************
// Questions scored by evaluators
//********************************************************************
$tableidx = $tableidx + 1;
$tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);

$row3 = $wdoc->findNthElement("w:tr",3,$tbl);
$row4 = $wdoc->findNthElement("w:tr",4,$tbl);
$row5 = $wdoc->findNthElement("w:tr",5,$tbl);

$r = $DB->allQuestionsForEval($evalid);
while ($question = $r->fetch_array(MYSQLI_ASSOC))
{
    $nr = $row3->cloneNode(true);
    $t = trim(stripslashes($question['question_identifier']));
    $wdoc->updateRowColumnText($nr,1,$t);
    $bone = false;
    $text = '';

    $u = array();
    $r2 = $DB->allTeamsForQuestion($question['idquestion']);
    while ($team = $r2->fetch_array(MYSQLI_ASSOC))
    {
        $r3 = $DB->allUsersForTeam($team['idteam']);
        while ($us = $r3->fetch_array(MYSQLI_ASSOC))
        {
            $u[$us['iduser']] = trim(stripslashes($us['user_name']));
        }
    }

    foreach($u as $usr)
    {
        if ($bone)
            $text .= ", ";
        $text .= trim(stripslashes($usr));
        $bone = true;
    }

    $wdoc->updateRowColumnText($nr,2,$text);

    $tbl->appendChild($nr);
}

$tbl->appendChild($row4->cloneNode(true));
$tbl->appendChild($row5->cloneNode(true));

$wdoc->tableDeleteRow($tbl,2);
$wdoc->tableDeleteRow($tbl,2);
$wdoc->tableDeleteRow($tbl,2);

//********************************************************************
// Evaluators
//********************************************************************
//Find ending marker
$tableidx = $tableidx + 1;
$tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);



$paraafter = $wdoc->findParagraphWhichIncludesText('1735478355');

$r = $DB->allUsersForEval($evalid);
while ($evaluator = $r->fetch_array(MYSQLI_ASSOC))
{
    $para = $wdoc->findParagraphWhichIncludesText('4856478586');
    $np = $para->cloneNode(true);
    $name = stripslashes($evaluator['user_name']);
    if ($g_anon != 0)
        $name = "Evaluator {$evaluator['iduser']}";

    $wdoc->newText($np,$name);
    $wdoc->insertParagraphBefore($np,$paraafter);

    //$np = $paraafter->cloneNode(true);
    //$wdoc->newText($np,"The following information are the configutaion for evaluator:");
    //$wdoc->insertParagraphBefore($np,$paraafter);

    $np = $paraafter->cloneNode(true);
    $wdoc->newText($np,"");
    $wdoc->insertParagraphBefore($np,$paraafter);




    //Duplicate table
    $newtbl = $tbl->cloneNode(true);

    $firstr = true;
    $r2 = $DB->allTeamsForUserForEval($evalid,$evaluator['iduser']);
    $numteams = $r2->num_rows;

    $row1 = $wdoc->findNthElement("w:tr",1,$newtbl);
    $row2 = $wdoc->findNthElement("w:tr",2,$newtbl);
    $row3 = $wdoc->findNthElement("w:tr",3,$newtbl);
    $row5 = $wdoc->findNthElement("w:tr",5,$newtbl);
    $insertedrows = 0;

    while ($team = $r2->fetch_array())
    {
        if ($firstr)
        {
            $wdoc->updateRowColumnText($row1,2,$team['team_name']);
            $firstr = false;
        }
        else
        {
            $row2 = $wdoc->findNthElement("w:tr",2,$newtbl);
            $nr = $row2->cloneNode(true);
            $wdoc->updateRowColumnText($nr,2,$team['team_name']);
            $newtbl->insertBefore($nr,$row3);
            $insertedrows++;
        }

    }

    $i1 = $insertedrows;
    $firstr = true;
    $r2 = $DB->phasesForUser($evaluator['iduser']);
    while ($uhp = $r2->fetch_array(MYSQLI_ASSOC))
    {
        if ($firstr)
        {
            $wdoc->updateRowColumnText($row3,2,$uhp['phase_name']);
            $firstr = false;
        }
        else
        {
            $row4 = $wdoc->findNthElement("w:tr",4+$insertedrows,$newtbl);
            $nr = $row4->cloneNode(true);
            $wdoc->updateRowColumnText($nr,2,$uhp['phase_name']);
            $newtbl->insertBefore($nr,$row5);
            $insertedrows++;
        }

    }



    //Total scores to evaluate
    //How many teams is the evaluator on
    $scorecnt = 0;
    $r10 = $DB->allTeamsForUserForEval($evalid,$evaluator['iduser']);
    while ($team = $r10->fetch_array(MYSQLI_ASSOC))
    {
        $scorecnt += $DB->numQuestionSubsForTeam($team['idteam']);
    }
    $scorecnt = $numResponders * $scorecnt;

    //$row5 = $wdoc->findNthElement("w:tr",5+$insertedrows,$newtbl);
    $wdoc->updateRowColumnText($row5,2,$scorecnt);


    $wdoc->tableDeleteRow($newtbl,1);
    $wdoc->tableDeleteRow($newtbl,2+$i1);
    $wdoc->insertParagraphBefore($newtbl,$paraafter);
    $tableidx = $tableidx + 1;


    $np = $paraafter->cloneNode(true);
    $wdoc->newText($np,"");
    $wdoc->insertParagraphBefore($np,$paraafter);

}

$wdoc->deleteParagraphWithText('4856478586');
$wdoc->tableDeleteTable($tbl);
$wdoc->deleteParagraphWithText('2475463854');
$wdoc->deleteParagraphWithText('7645658765');

$wdoc->deleteParagraphWithText('1735478355');




$wdoc->SaveAs($reportTitle);
$myfile = fopen($reportTitle, "r");
header("Content-Type: application/vnd.openxmlformats-officedocument.wordprocessingml.document");
header('Content-Disposition: attachment; filename="ConfigurationReport.docx"');
echo fread($myfile,filesize($reportTitle));
fclose($myfile);
unset($_SESSION['ReportProgess']);
?>