<?php
session_start();
require './includes/classEvalSecure.php';
require './includes/classEvaluateDB.php';
require './includes/classFormList.php';
require './includes/classWordDoc.php';
require './includes/classEvalHelpers.php';
require './includes/classTime.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
Secure::CheckPage(SECURITY_ADMIN);
$FL = new FormList(null);
$helpers = new helpers();

function var_error_log( $object=null ,$text='')
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( "{$text} {$contents}" );        // log contents of the result of var_dump( $object )
}

function parseText($t)
{
    $v = $t;
    while (strpos($v,"\\\\") !== false)
        $v = str_replace("\\\\","\\",$v);
    $v = str_replace("\\n","\n",$v);
    $v = str_replace("\\'","'",$v);
    $v = str_replace('\\"','"',$v);
    return $v;
}

function replaceMarkerWith($marker,$with,$completepara=false)
{
    global $wdoc;
    $text = stripslashes($with);
    if ($completepara)
    {
        $p1 = $wdoc->findParagraphWhichIncludesText($marker);
        if (!$p1)
        {
            error_log("Reporter3 [".__LINE__."] Unable to find marker {$marker}");
            return false;
        }
        if ($wdoc->newText($p1,$text) )
            return true;
        else
        {
            error_log("Reporter3 [".__LINE__."] replaceMarkerWith {$marker} failed.");
            return false;
        }
    }
    else
    {
        if ($wdoc->replaceText($marker,$text) )
            return true;
        else
        {
            error_log("Reporter3 [".__LINE__."] replaceMarkerWith {$marker} failed.");
            return false;
        }
    }
}

function htmlToWord($doc,$html,$parent,$template)
{
    $htmlDoc = new DOMDocument();
    $htmlDoc->loadHTML("<html><body>{$html}</body></html>");

    $body = $htmlDoc->getElementsByTagName("body");
    $children = $body->item(0)->childNodes;
    foreach ($children as $child)
    {
        if (strtoupper($child->nodeName) == "P")
        {
            $v = $template['p']->cloneNode(true);
            $doc->newText($v,$child->nodeValue);
            $parent->appendChild($v);
        }
        if (strtoupper($child->nodeName) == "UL")
        {
            $list = $child->childNodes;
            foreach ($list as $li)
            {
                if (strtoupper($li->nodeName) == "LI")
                {
                    $v = $template['li']->cloneNode(true);
                    $doc->newText($v,$li->nodeValue);
                    $parent->appendChild($v);
                }
            }
        }
    }
}


function sectiontotal1($tbl,$row4,$blnk,$totals,$weighted=false,$maxtotals=null,$row7=null)
{
    global $DB;
    global $wdoc;
    global $evalid;

    //Create a section total
    //Add a blank row
    $tbl->appendChild($blnk->cloneNode(true));


    $colcnt = 0;
    $ro = $row4->cloneNode(true);
    $co3 = $wdoc->findNthElement("w:tc",3,$ro);
    $r4 = $DB->allRespondentsForEval($evalid,"order by respondent_name_short");
    while ($resp = $r4->fetch_array(MYSQLI_ASSOC))
    {
        if ($weighted)
            $strtot = sprintf("%7.3f",floatval($totals[$resp['idrespondent']]));
        else
            $strtot = sprintf("%d",intval($totals[$resp['idrespondent']]));
        if ($colcnt == 0)
            $wdoc->updateRowColumnText($ro,$colcnt+3,$strtot);
        else
        {
            $ro->appendChild($co3->cloneNode(true));
            $wdoc->updateRowColumnText($ro,$colcnt+3,$strtot);
        }
        $colcnt++;
    }
    $tbl->appendChild($ro);

    if ($maxtotals && $row7)
    {
        $colcnt = 0;
        $ro = $row7->cloneNode(true);
        $co3 = $wdoc->findNthElement("w:tc",3,$ro);
        $r4 = $DB->allRespondentsForEval($evalid,"order by respondent_name_short");
        while ($resp = $r4->fetch_array(MYSQLI_ASSOC))
        {
            if ($maxtotals[$resp['idrespondent']] > 0)
                $perc = ($totals[$resp['idrespondent']] / $maxtotals[$resp['idrespondent']]) * 100.0;
            else
                $perc = 0.0;
            $strtot = sprintf("%5.1f%%",$perc);

            if ($colcnt == 0)
                $wdoc->updateRowColumnText($ro,$colcnt+3,$strtot);
            else
            {
                $ro->appendChild($co3->cloneNode(true));
                $wdoc->updateRowColumnText($ro,$colcnt+3,$strtot);
            }
            $colcnt++;
        }
        $tbl->appendChild($ro);
    }

    //Calculate rank
    $r4 = $DB->allRespondentsForEval($evalid,"order by respondent_name_short");
    while ($resp = $r4->fetch_array(MYSQLI_ASSOC))
    {
        $a1[$resp['idrespondent']] = $totals[$resp['idrespondent']];
    }

    arsort($a1);
    $cnt = 1;
    foreach($a1 as $key => $a)
    {
        $a1[$key] = $cnt;
        $cnt++;
    }

    $colcnt = 0;
    $ro = $row7->cloneNode(true);
    $co3 = $wdoc->findNthElement("w:tc",3,$ro);
    $r4 = $DB->allRespondentsForEval($evalid,"order by respondent_name_short");
    while ($resp = $r4->fetch_array(MYSQLI_ASSOC))
    {
        $strtot = $a1[$resp['idrespondent']];

        if ($colcnt == 0)
            $wdoc->updateRowColumnText($ro,$colcnt+3,$strtot);
        else
        {
            $ro->appendChild($co3->cloneNode(true));
            $wdoc->updateRowColumnText($ro,$colcnt+3,$strtot);
        }
        $colcnt++;
    }
    $tbl->appendChild($ro);


    //Add a blank row
    $tbl->appendChild($blnk->cloneNode(true));

}

$reportsDir = $devt_environment->getkey("REPORTS_DIR");
$templatedir = $devt_environment->getkey("TEMPLATES_DIR");
$graphsdir = $devt_environment->getkey("GRAPHS_DIR");

$templatename = $templatedir . "/TemplatePhaseReport.docx";
$reportTitle = $reportsDir . "/PhaseReport.docx";

$evalid = 0;
$phase = null;
$dtNow = new DateTime('now');
$tableidx= 0;
$g_anon = 0;

$user = $DB->getUser($_SESSION['userid']);
if (!$user)
{
    header("Location: SecurityError.php");
    exit();
}
$tz = $user['user_timezone'];
$dtNow->setTimezone(new DateTimeZone($tz));

if (isset($_GET['v']))
{
    $a = $FL->decryptParamRaw($_GET['v']);
    $evalid = intval($a['eval']);
    $phaseid = intval($a['phase']);
    $evaluation = $DB->getEvaluation($evalid);
    $phase = $DB->getPhaseWithRule($phaseid);
}

if (!$evaluation)
{
    echo "Invalid evaluation parameter passed";
    exit();
}

if (!$phase)
{
    echo "Invalid phase parameter passed";
    exit();
}

//Get some evaluation details

$numResponders = $DB->numOfRespondents($evalid);
$numQuestions = $DB->numOfQuestionsForEval($evalid);
$numSections = $DB-> numOfSectionsForEval($evalid);
$numPhases = $DB->numPhasesForEval($evalid);
$strtotalweightings = sprintf("%3.1f%%",$evaluation['evaluation_total_weightings']*100.0);
$finalphase = $DB->getFinalPhase($evalid);
$results = $helpers->phaseResults2($evalid,$phaseid);

//var_error_log($results,"results");


$completeresults = $DB->completeResults($evalid);


//var_error_log($completeresults,"completeresults");

//Evaluation Name
$evaL_name = stripslashes($evaluation['evaluation_name']);
//Phase name
$phase_name = stripslashes($phase['phase_name']);
$num_teams = 0;
$numEvaluators = 0;

$teams = array();
$qmatrix = array();
$r = $DB->allTeamsForEval($evalid,'order by team_name');
while ($team = $r->fetch_array())
{
    $num_evalsforteam = $DB->numUsersForTeamForPhase($team['idteam'],$phaseid);
    if ($num_evalsforteam > 0)
    {
        $t = array();
        $t['id'] = $team['idteam'];
        $t['name'] = $team['team_name'];
        $t['phaseid'] = $phaseid;
        $t['evaluators'] = $num_evalsforteam;
        $num_teams++;
        //Find out how many subattributes or questions there are for this team
        $tot = 0;
        $r2 = $DB->allQuestionsForTeam($team['idteam']);
        while ($question = $r2->fetch_array())
        {
            $qmatrix[$question['idquestion']] = 1;
            $nSubs = $DB->numOfSubsForQuestion($question['idquestion']);
            if ($nSubs == 0)
                $nSubs = 1;
            $tot += $nSubs;
        }
        $totals = array();

        $totals['totscoresperevaluator'] = $tot * $numResponders;
        $totals['totscores'] = $tot * $numResponders * $num_evalsforteam;

        $users2 = array();
        $tot_answered = 0;

        $r1 = $DB->allUsersForTeam($team['idteam']);
        while ($user = $r1->fetch_array())
        {
            //Check that this user is assigned to evalutae this phase
            if ($DB->userHasPhase($user['iduser'],$phaseid) )
            {
                $u = array();
                $u['id'] = $user['iduser'];
                $u['name'] = $user['user_name'];

                //Nowfind out how many score for the question in this team.
                $answered = 0;
                $r3 = $DB->allQuestionsForTeam($team['idteam']);
                while ($qeest = $r3->fetch_array())
                {
                    $answered += $DB->numScoresFor($evalid,$phaseid,$user['iduser'],$qeest['idquestion']);
                }
                $u['scored'] = $answered;
                $tot_answered += $answered;

                array_push($users2,$u);
            }
        }

        $totals['totanswered'] = $tot_answered;

        $t['totals'] = $totals;

        $t['users'] = $users2;




        array_push($teams,$t);
    }

}
$phase_questions = count($qmatrix);

//Determine number of evaluators used for this phase, we cannot use teams as an evaluator may be on more than one team
$r = $DB->allEvaluators();
while ($e = $r->fetch_array(MYSQLI_ASSOC))
{
    if ($DB->userHasPhase($e['iduser'],$phaseid) )
    {
        $numEvaluators++;
    }
}


//What is the total percentage complete
$sumScores  = 0;
$sumAnswered = 0 ;
foreach($teams as $team)
{
    $totals = $team['totals'];
    $sumScores  += $totals['totscores'];
    $sumAnswered  += $totals['totanswered'];
}

$percentcomplete = 0;
if ($sumScores > 0)
    $percentcomplete = floatval($sumAnswered) * 100.0 / floatval($sumScores);
$strpercentcomplete = sprintf("%3.0f%%",$percentcomplete);

$wdoc = new WordDoc("/tmp/Report{$dtNow->format('YmdHis')}");
if (!$wdoc->open("{$templatename}") )
{
    echo "Unable to open template document {$templatename}";
    exit();
}




//********************************************************************
//Heading page
//********************************************************************
replaceMarkerWith('8237469438',$evaluation['evaluation_name'],true);

//Page 1 Date
replaceMarkerWith('4892372387',$dtNow->format('j F Y'),true);

//Phase name
$phase_name = stripslashes($phase['phase_name']);

replaceMarkerWith('3846385657',$phase_name);
replaceMarkerWith('3955234343',$phase_name);

//*******************************************************************************************
// PHASE PROGRESS
//*******************************************************************************************

$tableidx = $tableidx + 1;
$tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);
$wdoc->updateTableRowCol($tbl,1,2,$evaL_name);
$wdoc->updateTableRowCol($tbl,2,2,$phase_name);
$typetext = '';
if ($phase['phase_single_score'])
    $typetext = "One score per question";
else
    $typetext = "Multiple scores per question";
$wdoc->updateTableRowCol($tbl,4,2,$typetext);
$wdoc->updateTableRowCol($tbl,5,2,$num_teams);
$wdoc->updateTableRowCol($tbl,6,2,$numEvaluators);
$wdoc->updateTableRowCol($tbl,7,2,$phase_questions);

//Phase status
switch ($phase['phase_status'])
{
    case 'defined':
        $wdoc->updateTableRowCol($tbl,3,2,"Not started");
        replaceMarkerWith('3567897211',"This phase has been defined and has not yet started.");
        $wdoc->deleteParagraphWithText('9455866454');
        break;
    case 'enabled':
        $wdoc->updateTableRowCol($tbl,3,2,"In Progress");
        replaceMarkerWith('3567897211',"This phase is still marked as in progress.");
        replaceMarkerWith('9455866454',$strpercentcomplete);
        break;
    case 'complete':
        $wdoc->updateTableRowCol($tbl,3,2,"Completed");
        replaceMarkerWith('3567897211',"This phase has been marked as completed, all questions have been scored.");
        replaceMarkerWith('9455866454',$strpercentcomplete);
        break;
    default:
        $wdoc->updateTableRowCol($tbl,3,2,"Bad Status");
        replaceMarkerWith('3567897211',"This phase is in an odd state.");
        $wdoc->deleteParagraphWithText('9455866454');
        break;
}
//******************************************************************************************
// TEAMS
//******************************************************************************************
$tableidx = $tableidx + 1;
$tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);
$row3 = $wdoc->findNthElement("w:tr",3,$tbl);
$row4 = $wdoc->findNthElement("w:tr",4,$tbl);
$lastrow = $wdoc->findNthElement("w:tr",5,$tbl);

foreach($teams as $team)
{
    //var_error_log($team,"TEAM");
    $ro = $row3->cloneNode(true);
    $n = stripslashes($team['name']);
    $wdoc->updateRowColumnText($ro,1,$n);
    $n = $team['evaluators'];
    $wdoc->updateRowColumnText($ro,2,$n);
    $an = intval($team['totals'] ['totanswered']);
    $tot = intval($team['totals'] ['totscores']);
    if ($tot > 0)
    {
        $str = sprintf("%3.0f%%",(floatval($an)/floatval($tot)) * 100.0);
    }
    else
        $str = "0%";
    $wdoc->updateRowColumnText($ro,3,$str);
    $tbl->appendChild($ro);

    //Now all the evaluators for the team
    $users = $team['users'];
    $totperuser = $team['totals'] ['totscoresperevaluator'];
    foreach($users as $auser)
    {
        $ro = $row4->cloneNode(true);
        if ($totperuser > 0)
        {
            $str = sprintf("%3.0f%%",(floatval($auser['scored'])/floatval($totperuser)) * 100.0);
        }
        else
            $str = "0%";
        $n = stripslashes($auser['name']);
        $wdoc->updateRowColumnText($ro,2,$n);
        $wdoc->updateRowColumnText($ro,3,$str);
        $tbl->appendChild($ro);
    }

}

$tbl->appendChild($lastrow->cloneNode(true));
$wdoc->tableDeleteRow($tbl,2);
$wdoc->tableDeleteRow($tbl,2);
$wdoc->tableDeleteRow($tbl,2);
$wdoc->tableDeleteRow($tbl,2);

//*******************************************************************************************
// PHASE TIMINGS
//*******************************************************************************************
$tableidx = $tableidx + 1;
$tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);
$row3 = $wdoc->findNthElement("w:tr",3,$tbl);
$row4 = $wdoc->findNthElement("w:tr",4,$tbl);

$r = $DB->allAuditPhaseStatesForPhase($phaseid);
while ($audit = $r->fetch_array(MYSQLI_ASSOC))
{
    $nr = $row3->cloneNode(true);
    $dt = new DateTime($audit['audit_timestamp']);
    $dt->setTimezone(new DateTimeZone($tz));
    $wdoc->updateRowColumnText($nr,1,$dt->format('j M Y H:i'));
    $strStatus = "Not Started";
    switch (trim($audit['audit_comment']))
    {
        case "enabled":
            $strStatus = "Enabled";
            break;
        case "complete":
            $strStatus = "Completed";
            break;
        default:
            break;
    }
    $wdoc->updateRowColumnText($nr,2,$strStatus);
    $strName = stripslashes($audit['user_name']);
    $wdoc->updateRowColumnText($nr,3,$strName);
    $tbl->appendChild($nr);
}
$tbl->appendChild($row4->cloneNode(true));
$wdoc->tableDeleteRow($tbl,2);
$wdoc->tableDeleteRow($tbl,2);

//*******************************************************************************************
// EVALUATOR PHASE TIMINGS
//*******************************************************************************************
$tableidx = $tableidx + 1;
$tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);
$row3 = $wdoc->findNthElement("w:tr",3,$tbl);
$row4 = $wdoc->findNthElement("w:tr",4,$tbl);
$row5 = $wdoc->findNthElement("w:tr",5,$tbl);
$lastteamid = 0;

$r = $DB->allTeamsForEval($evalid,'order by team_name');
while ($team = $r->fetch_array())
{

    if ($DB->numUsersForTeamForPhase($team['idteam'],$phaseid) > 0)
    {

        if ($lastteamid != $team['idteam'])
        {
            $nr = $row3->cloneNode(true);
            $strName = stripslashes($team['team_name']);
            $wdoc->updateRowColumnText($nr,1,$strName);
            $tbl->appendChild($nr);
            $lastteamid = $team['idteam'];
        }


        $r1 = $DB->allUsersForTeam($team['idteam']);
        while ($user = $r1->fetch_array())
        {
            //$a1 = $DB->FirstScoreAuditForUserForPhase($evalid,$user['iduser'],$phaseid);
            //$a2 = $DB->LastScoreAuditForUserForPhase($evalid,$user['iduser'],$phaseid);

            $a1 = $DB->FirstScoreAuditForUserForPhaseForTeam($evalid,$user['iduser'],$phaseid,$team['idteam']);
            $a2 = $DB->LastScoreAuditForUserForPhaseForTeam($evalid,$user['iduser'],$phaseid,$team['idteam']);

            $nr = $row4->cloneNode(true);
            $strName = stripslashes($user['user_name']);
            $wdoc->updateRowColumnText($nr,2,$strName);

            if ($a1)
            {
                $dt = new DateTime($a1['audit_timestamp']);
                $dt->setTimezone(new DateTimeZone($tz));
                $wdoc->updateRowColumnText($nr,3,$dt->format('j/n H:i'));
            }
            else
                $wdoc->updateRowColumnText($nr,3,"");

            if ($a2)
            {
                $dt = new DateTime($a2['audit_timestamp']);
                $dt->setTimezone(new DateTimeZone($tz));
                $wdoc->updateRowColumnText($nr,4,$dt->format('j/n H:i'));
            }
            else
                $wdoc->updateRowColumnText($nr,4,"");

            if ($a1 && $a2)
            {
                $dt1 = new DateTime($a1['audit_timestamp']);
                $dt2 = new DateTime($a2['audit_timestamp']);
                $elapsed = $dt2->getTimestamp() - $dt1->getTimestamp();
                if ($elapsed > (3600 * 24))
                {
                    $elapsed2 = floatval($elapsed / (3600.0 * 24.0));
                    $wdoc->updateRowColumnText($nr,5,sprintf("%4.1f Days",$elapsed2));
                }
                else
                {
                    $elapsed2 = floatval($elapsed / 3600.0);
                    $wdoc->updateRowColumnText($nr,5,sprintf("%4.1f Hours",$elapsed2));
                }

                $v = $DB->numScoresForUser($evalid,$phaseid,$user['iduser']);
                $rate = floatval($v) / (floatval($elapsed)/(3600.0*24.0));
                $wdoc->updateRowColumnText($nr,6,sprintf("%4.1f",$rate));
            }
            else
            {
                $wdoc->updateRowColumnText($nr,5,"");
                $wdoc->updateRowColumnText($nr,6,"");
            }



            $tbl->appendChild($nr);
        }
    }
}

$tbl->appendChild($row5->cloneNode(true));
$wdoc->tableDeleteRow($tbl,2);
$wdoc->tableDeleteRow($tbl,2);
$wdoc->tableDeleteRow($tbl,2);

//*******************************************************************************************
// RESULTS
//*******************************************************************************************



if (!$results['status'])
{
    replaceMarkerWith('3486574565',"No results are available as not all questions have been answered by all evaluators.",true);

    $wdoc->deleteParagraphWithText("4856437585");
    $wdoc->deleteParagraphWithText("9845756782");
    $wdoc->deleteParagraphWithText("9845756783");

    $wdoc->deleteParagraphWithText("9845756785");
    $wdoc->deleteParagraphWithText("9845756786");
    $wdoc->deleteParagraphWithText("9845756787",true);
    $wdoc->deleteParagraphWithText("9845756788",true);
    $wdoc->deleteParagraphWithText("4856437586");



    $tableidx = $tableidx + 1;
    $tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);
    $wdoc->tableDeleteTable($tbl);


    $wdoc->deleteParagraphWithText("7652975678");
    $wdoc->deleteParagraphWithText("7652975679");

    $tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);
    $wdoc->tableDeleteTable($tbl);

    $wdoc->deleteParagraphWithText("4835475537");
    $wdoc->deleteParagraphWithText("1754753745");

    $wdoc->deleteParagraphWithText("2435465789");


}
else
{
    replaceMarkerWith('3486574565',"This section tables the complete score details for this phase of the evaluation for each respondent.",true);

    //Raw scores
    replaceMarkerWith('4856437585',"Raw score summary by question",true);
    replaceMarkerWith('9845756782',"Following are the results for each respondent for each section and question:");
    if (!$phase['phase_single_score'])
        replaceMarkerWith('9845756783',"Note: This phase has multiple evaluators scoring each question, the following results are averaged across all evaluators.",true);
    else
        $wdoc->deleteParagraphWithText("9845756783");
    replaceMarkerWith('9845756784',"",true);
    replaceMarkerWith('9845756789',"",true);


    $tableidx = $tableidx + 1;
    $tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);
    $row1 = $wdoc->findNthElement("w:tr",1,$tbl);
    $row2 = $wdoc->findNthElement("w:tr",3,$tbl);
    $row3 = $wdoc->findNthElement("w:tr",4,$tbl);
    $row5 = $wdoc->findNthElement("w:tr",5,$tbl);
    $row6 = $wdoc->findNthElement("w:tr",6,$tbl);
    $row7 = $wdoc->findNthElement("w:tr",7,$tbl);
    $blankrow = $wdoc->findNthElement("w:tr",8,$tbl);
    $lastrow = $wdoc->findNthElement("w:tr",9,$tbl);

    $col3 =$wdoc->findNthElement("w:tc",3,$row1);


    //Clone a blank row and set extrac columns
    $blnk = $blankrow->cloneNode(true);
    $blnkcol3 = $wdoc->findNthElement("w:tc",3,$blankrow);

    //Repondent headings
    $colcnt = 0;
    $r = $DB->allRespondentsForEval($evalid,"order by respondent_name_short");
    while ($resp = $r->fetch_array(MYSQLI_ASSOC))
    {
        $nm = stripslashes($resp['respondent_name_short']);
        if ($colcnt == 0)
        {
            $wdoc->updateTableRowCol($tbl,1,$colcnt+3,$nm);
        }
        else
        {
            $co = $col3->cloneNode(true);
            $row1->appendChild($co);

            $co2 = $blnkcol3->cloneNode(true);
            $blnk->appendChild($co2);

            $wdoc->updateTableRowCol($tbl,1,$colcnt+3,$nm);
        }
        $colcnt++;
    }

    $questions = $results['questions'];
    $sectionid = 0;
    $sec_totals = array();
    $all_totals = array();
    $sec_maxtotals = array();
    $all_maxtotals = array();

    foreach($questions as $question)
    {
        if ($question['section'] != $sectionid )
        {
            if ($sectionid != 0)
            {
                sectiontotal1($tbl,$row5,$blnk,$sec_totals,false,$sec_maxtotals,$row7);
                $sec_totals = array();
                $sec_maxtotals = array();
            }

            $s = $DB->getSection($question['section']);
            $n = stripslashes($s['section_name']);
            $n = trim($n);
            if ( strtoupper(strtok($n," ")) != "SECTION")
                $n = "SECTION " . $n;

            $ro = $row2->cloneNode(true);
            $wdoc->updateRowColumnText($ro,1,$n);
            $co2 = $wdoc->findNthElement("w:tc",2,$ro);
            for ($idx = 1; $idx < $numResponders;$idx++)
            {
                $ro->appendChild($co2->cloneNode(true));
            }
            $tbl->appendChild($ro);
            $sectionid = $question['section'];
        }

        $colcnt = 0;
        $ro = $row3->cloneNode(true);
        $n = stripslashes($question['name']);
        $n = trim($n);
        $wdoc->updateRowColumnText($ro,2,$n);
        $co3 = $wdoc->findNthElement("w:tc",3,$ro);

        $repondents = $question['respondent'];
        foreach($repondents as $repondent)
        {
            if (isset($sec_totals[$repondent['id']]))
                $sec_totals[$repondent['id']] = $sec_totals[$repondent['id']] + $repondent['raw'];
            else
                $sec_totals[$repondent['id']] = $repondent['raw'];

            if (isset($sec_maxtotals[$repondent['id']]))
                $sec_maxtotals[$repondent['id']] = $sec_maxtotals[$repondent['id']] + $repondent['maxraw'];
            else
                $sec_maxtotals[$repondent['id']] = $repondent['maxraw'];

            if (isset($all_totals[$repondent['id']]))
                $all_totals[$repondent['id']] = $all_totals[$repondent['id']] + $repondent['raw'];
            else
                $all_totals[$repondent['id']] = $repondent['raw'];

            if (isset($all_maxtotals[$repondent['id']]))
                $all_maxtotals[$repondent['id']] = $all_maxtotals[$repondent['id']] + $repondent['maxraw'];
            else
                $all_maxtotals[$repondent['id']] = $repondent['maxraw'];



            $score = sprintf("%d",$repondent['raw']);



            if ($colcnt == 0)
                $wdoc->updateRowColumnText($ro,$colcnt+3,$score);
            else
            {
                $ro->appendChild($co3->cloneNode(true));
                $wdoc->updateRowColumnText($ro,$colcnt+3,$score);
            }
            $colcnt++;
        }
        $tbl->appendChild($ro);
    }

    if ($sectionid != 0)
    {
        sectiontotal1($tbl,$row5,$blnk,$sec_totals,false,$sec_maxtotals,$row7);
        $sec_totals = array();
        $sec_maxtotals = array();
        sectiontotal1($tbl,$row6,$blnk,$all_totals,false,$all_maxtotals,$row7);
    }


    $wdoc->tableDeleteRow($tbl,2);
    $wdoc->tableDeleteRow($tbl,2);
    $wdoc->tableDeleteRow($tbl,2);
    $wdoc->tableDeleteRow($tbl,2);
    $wdoc->tableDeleteRow($tbl,2);
    $wdoc->tableDeleteRow($tbl,2);
    $wdoc->tableDeleteRow($tbl,2);

    //Weighted scores
    replaceMarkerWith('4856437586',"Weighted score summary by question",true);

    replaceMarkerWith('9845756785',"Following are the results for each respondent for each section and question:");
    if (!$phase['phase_single_score'])
        replaceMarkerWith('9845756786',"Note: This phase has multiple evaluators scoring each question, the following results are averaged across all evaluators.",true);
    else
        $wdoc->deleteParagraphWithText("9845756786");
    replaceMarkerWith('9845756787',"",true);
    replaceMarkerWith('9845756788',"",true);



    $tableidx = $tableidx + 1;
    $tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);
    $row1 = $wdoc->findNthElement("w:tr",1,$tbl);
    $row2 = $wdoc->findNthElement("w:tr",3,$tbl);
    $row3 = $wdoc->findNthElement("w:tr",4,$tbl);
    $row5 = $wdoc->findNthElement("w:tr",5,$tbl);
    $row6 = $wdoc->findNthElement("w:tr",6,$tbl);
    $row7 = $wdoc->findNthElement("w:tr",7,$tbl);
    $blankrow = $wdoc->findNthElement("w:tr",8,$tbl);
    $lastrow = $wdoc->findNthElement("w:tr",9,$tbl);


    $col3 =$wdoc->findNthElement("w:tc",3,$row1);


    //Clone a blank row and set extrac columns
    $blnk = $blankrow->cloneNode(true);
    $blnkcol3 = $wdoc->findNthElement("w:tc",3,$blankrow);

    //Repondent headings
    $colcnt = 0;
    $r = $DB->allRespondentsForEval($evalid,"order by respondent_name_short");
    while ($resp = $r->fetch_array(MYSQLI_ASSOC))
    {
        $nm = stripslashes($resp['respondent_name_short']);
        if ($colcnt == 0)
        {
            $wdoc->updateTableRowCol($tbl,1,$colcnt+3,$nm);
        }
        else
        {
            $co = $col3->cloneNode(true);
            $row1->appendChild($co);

            $co2 = $blnkcol3->cloneNode(true);
            $blnk->appendChild($co2);

            $wdoc->updateTableRowCol($tbl,1,$colcnt+3,$nm);
        }
        $colcnt++;
    }



    $questions = $results['questions'];
    $sectionid = 0;
    $sec_totals = array();
    $all_totals = array();
    $sec_maxtotals = array();
    $all_maxtotals = array();

    foreach($questions as $question)
    {
        if ($question['section'] != $sectionid )
        {
            if ($sectionid != 0)
            {
                sectiontotal1($tbl,$row5,$blnk,$sec_totals,true,$sec_maxtotals,$row7);
                $sec_totals = array();
                $sec_maxtotals = array();
            }

            $s = $DB->getSection($question['section']);
            $n = stripslashes($s['section_name']);
            $n = trim($n);
            if ( strtoupper(strtok($n," ")) != "SECTION")
                $n = "SECTION " . $n;

            $ro = $row2->cloneNode(true);
            $wdoc->updateRowColumnText($ro,1,$n);
            $co2 = $wdoc->findNthElement("w:tc",2,$ro);
            for ($idx = 1; $idx < $numResponders;$idx++)
            {
                $ro->appendChild($co2->cloneNode(true));
            }
            $tbl->appendChild($ro);
            $sectionid = $question['section'];
        }

        $colcnt = 0;
        $ro = $row3->cloneNode(true);
        $n = stripslashes($question['name']);
        $n = trim($n);
        $wdoc->updateRowColumnText($ro,2,$n);
        $co3 = $wdoc->findNthElement("w:tc",3,$ro);

        $repondents = $question['respondent'];
        foreach($repondents as $repondent)
        {
            //New rounding
            $rndscore = round(floatval($repondent['score']),3);


            if (isset($sec_totals[$repondent['id']]))
                $sec_totals[$repondent['id']] = $sec_totals[$repondent['id']] + $rndscore;
            else
                $sec_totals[$repondent['id']] = $rndscore;

            if (isset($sec_maxtotals[$repondent['id']]))
                $sec_maxtotals[$repondent['id']] = $sec_maxtotals[$repondent['id']] + $repondent['maxweighted'];
            else
                $sec_maxtotals[$repondent['id']] = $repondent['maxweighted'];

            if (isset($all_totals[$repondent['id']]))
                $all_totals[$repondent['id']] = $all_totals[$repondent['id']] + $rndscore;
            else
                $all_totals[$repondent['id']] = $rndscore;

            if (isset($all_maxtotals[$repondent['id']]))
                $all_maxtotals[$repondent['id']] = $all_maxtotals[$repondent['id']] + $repondent['maxweighted'];
            else
                $all_maxtotals[$repondent['id']] = $repondent['maxweighted'];



            $score = sprintf("%7.3f",$rndscore);



            if ($colcnt == 0)
                $wdoc->updateRowColumnText($ro,$colcnt+3,$score);
            else
            {
                $ro->appendChild($co3->cloneNode(true));
                $wdoc->updateRowColumnText($ro,$colcnt+3,$score);
            }
            $colcnt++;
        }
        $tbl->appendChild($ro);
    }
    if ($sectionid != 0)
    {
        sectiontotal1($tbl,$row5,$blnk,$sec_totals,true,$sec_maxtotals,$row7);
        $sec_totals = array();
        $sec_maxtotals = array();
        sectiontotal1($tbl,$row6,$blnk,$all_totals,true,$all_maxtotals,$row7);
    }

    $wdoc->tableDeleteRow($tbl,2);
    $wdoc->tableDeleteRow($tbl,2);
    $wdoc->tableDeleteRow($tbl,2);
    $wdoc->tableDeleteRow($tbl,2);
    $wdoc->tableDeleteRow($tbl,2);
    $wdoc->tableDeleteRow($tbl,2);
    $wdoc->tableDeleteRow($tbl,2);



    //**********************************************************************************
    // Summary for each respondent
    //
    //**********************************************************************************

    $body_text = $wdoc->findParagraphWhichIncludesText("7652975679");
    $body_text = $body_text->cloneNode(true);
    $wdoc->newText($body_text,"");

    replaceMarkerWith('7652975678',"Summary by Respondent",true);
    if ($phase['phase_single_score'])
        $strText = "This section summarises each respondent, their scores and associated comments for each question.";
    else
        $strText = "This section summarises each respondent and weighted average scores for each question.  Comments have been omitted as this phase has multiple evaluators per phase.";

    replaceMarkerWith('7652975679',$strText,true);

    if (!$phase['phase_single_score'])
        replaceMarkerWith('2435465789',"Note: This phase has multiple evaluators scoring each question, the following results are averaged across all evaluators.  Individual evaluators comments have been omitted.",true);
    else
        $wdoc->deleteParagraphWithText("2435465789");

    $h3 = $wdoc->findParagraphWhichIncludesText("4835475537");
    $para1 = $wdoc->findParagraphWhichIncludesText("1754753745");
    $end = $wdoc->findParagraphWhichIncludesText("END");
    $tableidx = $tableidx + 1;
    $tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);

    if (!$h3)
        error_log("Cannot find heading3 para 4835475537");
    if (!$end)
        error_log("Cannot find END");


    $respidx = 0;
    $r = $DB->allRespondentsForEval($evalid,"order by respondent_name_short");
    while ($resp = $r->fetch_array(MYSQLI_ASSOC))
    {
        $section_total = 0;
        $all_total = 0;

        if ($h3 && $end)
        {
            //Build new heading
            $h = $h3->cloneNode(true);
            $n = stripslashes($resp['respondent_name_full']);
            $wdoc->newText($h,$n);
            $wdoc->insertParagraphBefore($h,$end);

            $p1 = $para1->cloneNode(true);
            $wdoc->newText($p1,"");
            $wdoc->insertParagraphBefore($p1,$end);

            $newtable = $tbl->cloneNode(true);
            $secline = $wdoc->findNthElement("w:tr",3,$newtable);
            $qline = $wdoc->findNthElement("w:tr",4,$newtable);
            $stline = $wdoc->findNthElement("w:tr",5,$newtable);
            $totline = $wdoc->findNthElement("w:tr",6,$newtable);
            $blank = $wdoc->findNthElement("w:tr",7,$newtable);
            $blankend = $wdoc->findNthElement("w:tr",8,$newtable);

            $sectionid = 0;
            $r2 = $DB->allQuestionsForEvalWithSection($evalid, "order by question_order");
            while ($qu = $r2->fetch_array(MYSQLI_ASSOC))
            {
                if ($sectionid != $qu['idsection'])
                {

                    if ($sectionid != 0)
                    {
                        $newtable->appendChild($blank->cloneNode(true));

                        $st = $stline->cloneNode(true);
                        $n = sprintf("%3.3f",$section_total);
                        $section_total = 0;
                        $wdoc->updateRowColumnText($st,2,$n);
                        $newtable->appendChild($st);

                        $newtable->appendChild($blank->cloneNode(true));
                    }

                    $sl = $secline->cloneNode(true);
                    $n = stripslashes($qu['section_name']);
                    $n = trim($n);
                    if ( strtoupper(strtok($n," ")) != "SECTION")
                        $n = "SECTION " . $n;
                    $wdoc->updateRowColumnText($sl,1,$n);
                    $newtable->appendChild($sl);
                    $sectionid = $qu['idsection'];
                }

                $ql = $qline->cloneNode(true);
                $colpara = $wdoc->getTableColumnParagraph($ql,4);
                $n = stripslashes($qu['question_identifier']);
                $wdoc->updateRowColumnText($ql,1,$n);

                $score = $results['questions'] [$qu['idquestion']] ['respondent'] [$respidx] ['score'];
                $section_total += floatval($score);
                $all_total += floatval($score);

                $respid = intval($results['questions'] [$qu['idquestion']] ['respondent'] [$respidx] ['id']);
                $strscore = sprintf("%7.3f",floatval($score));
                $wdoc->updateRowColumnText($ql,3,$strscore);


                //Look for any comments
                if ($phase['phase_single_score'])
                {
                    //Do we have sub attributes
                    $r3 = $DB->allSubForQuestion($qu['idquestion'],"order by subattribute_number");
                    if ($r3->num_rows > 0)
                    {
                        $first = false;
                        while ($sub = $r3->fetch_array(MYSQLI_ASSOC))
                        {
                            if ($first)
                            {
                                $newtable->appendChild($ql);
                                $ql = $qline->cloneNode(true);
                                $colpara = $wdoc->getTableColumnParagraph($ql,4);
                                $wdoc->updateRowColumnText($ql,1,"");
                                $wdoc->updateRowColumnText($ql,3,"");
                            }
                            $comment = $DB->getScoreComment($evalid,$phaseid,$respid,$qu['idquestion'],$sub['idsubattribute']);
                            //$comment = stripslashes($comment);
                            $wdoc->updateRowColumnText($ql,2,$sub['subattribute_number']);

                            if (strlen($comment)  > 0)
                            {
                                $comnt = parseText($comment);
                                $lines = explode("\n",$comnt);
                                $cnt = 0;
                                foreach($lines as $line)
                                {
                                    if ($cnt == 0)
                                        $wdoc->updateRowColumnText($ql,4,stripslashes($line));
                                    else
                                    {
                                        $np = $colpara->cloneNode(true);
                                        $wdoc->newText($np,stripslashes($line));
                                        $wdoc->insertTableColumnParagraph($ql,4,$np);
                                    }
                                    $cnt++;
                                }
                            }
                            else
                                $wdoc->updateRowColumnText($ql,4,"None");

                            $first = true;
                        }
                    }
                    else
                    {
                        $comment = $DB->getScoreComment($evalid,$phaseid,$respid,$qu['idquestion']);
                        //$comment = stripslashes($comment);
                        if (strlen($comment)  > 0)
                        {
                            $comnt = parseText($comment);
                            $lines = explode("\n",$comnt);
                            $cnt = 0;
                            foreach($lines as $line)
                            {
                                if ($cnt == 0)
                                    $wdoc->updateRowColumnText($ql,4,stripslashes($line));
                                else
                                {
                                    $np = $colpara->cloneNode(true);
                                    $wdoc->newText($np,stripslashes($line));
                                    $wdoc->insertTableColumnParagraph($ql,4,$np);
                                }
                                $cnt++;
                            }
                        }
                        else
                            $wdoc->updateRowColumnText($ql,4,"None");
                        $wdoc->updateRowColumnText($ql,2,"");
                    }
                }
                else
                {
                    $wdoc->updateRowColumnText($ql,4,"");
                    $wdoc->updateRowColumnText($ql,2,"");
                }
                $newtable->appendChild($ql);

            }

            if ($sectionid != 0)
            {

                $newtable->appendChild($blank->cloneNode(true));

                $st = $stline->cloneNode(true);
                $n = sprintf("%3.3f",$section_total);
                $section_total = 0;
                $wdoc->updateRowColumnText($st,2,$n);
                $newtable->appendChild($st);

                $newtable->appendChild($blank->cloneNode(true));

                //Total row
                $totl = $totline->cloneNode(true);
                $n = sprintf("%3.3f",$all_total);
                $wdoc->updateRowColumnText($totl,2,$n);
                $newtable->appendChild($totl);

            }



            //Insert blank end
            $newtable->appendChild($blankend->cloneNode(true));




            //Delete upper rows
            $wdoc->tableDeleteRow($newtable,2);
            $wdoc->tableDeleteRow($newtable,2);
            $wdoc->tableDeleteRow($newtable,2);
            $wdoc->tableDeleteRow($newtable,2);
            $wdoc->tableDeleteRow($newtable,2);
            $wdoc->tableDeleteRow($newtable,2);


            $wdoc->insertParagraphBefore($newtable,$end);

            $blankline = $body_text->cloneNode();
            $wdoc->insertParagraphBefore($blankline,$end);



        }




        $respidx++;
    }

    if (!$wdoc->deleteParagraphWithText("4835475537") )
        error_log("Could not delete para 4835475537");
    if (!$wdoc->deleteParagraphWithText("1754753745") )
        error_log("Could not delete para 1754753745");


    $tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);
    $wdoc->tableDeleteTable($tbl);


}


//Completeion status


$wdoc->SaveAs($reportTitle);
$myfile = fopen($reportTitle, "r");
header("Content-Type: application/vnd.openxmlformats-officedocument.wordprocessingml.document");
header('Content-Disposition: attachment; filename="PhaseReport.docx"');
echo fread($myfile,filesize($reportTitle));
fclose($myfile);
unset($_SESSION['ReportProgess']);
?>