<?php
session_start();
set_time_limit (3600);
require './includes/classEvalSecure.php';
require './includes/classEvaluateDB.php';
require './includes/classFormList.php';
require './includes/classWordDoc.php';
require './includes/classEvalHelpers.php';
require './includes/classTime.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
Secure::CheckPage(SECURITY_ADMIN);
$FL = new FormList(null);
$helpers = new helpers();

function var_error_log( $object=null ,$text='')
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( "{$text} {$contents}" );        // log contents of the result of var_dump( $object )
}

function filesInDir($dir)
{
    //Returns of all files in the directory including the directory
    $ret = array();
    $files = scandir($dir);
    foreach($files as $file)
    {
        if (is_dir("{$dir}/{$file}"))
        {
            if ($file != "." && $file != "..")
            {
                $list = filesInDir("{$dir}/{$file}");
                $ret = array_merge($ret,$list);
            }
        }
        else
        {
            array_push($ret,"{$dir}/{$file}");
        }
    }
    return $ret;
}

function replaceMarkerWith($marker,$with,$completepara=false)
{
    global $wdoc;
    if ($completepara)
    {
        $p1 = $wdoc->findParagraphWhichIncludesText($marker);
        if (!$p1)
        {
            error_log("Reporter [".__LINE__."] Unable to find marker {$marker}");
            return false;
        }
        if ($wdoc->newText($p1,$with) )
            return true;
        else
        {
            error_log("Reporter1 [".__LINE__."] replaceMarkerWith {$marker} failed.");
            return false;
        }
    }
    else
    {
        if ($wdoc->replaceText($marker,$with) )
            return true;
        else
        {
            error_log("Reporter1 [".__LINE__."] replaceMarkerWith {$marker} failed.");
            return false;
        }
    }
}

function htmlToWord($doc,$html,$parent,$template)
{
    $htmlDoc = new DOMDocument();
    $htmlDoc->loadHTML("<html><body>{$html}</body></html>");

    $body = $htmlDoc->getElementsByTagName("body");
    $children = $body->item(0)->childNodes;
    foreach ($children as $child)
    {
        if (strtoupper($child->nodeName) == "P")
        {
            $v = $template['p']->cloneNode(true);
            $doc->newText($v,$child->nodeValue);
            $parent->appendChild($v);
        }
        if (strtoupper($child->nodeName) == "UL")
        {
            $list = $child->childNodes;
            foreach ($list as $li)
            {
                if (strtoupper($li->nodeName) == "LI")
                {
                    $v = $template['li']->cloneNode(true);
                    $doc->newText($v,$li->nodeValue);
                    $parent->appendChild($v);
                }
            }
        }
    }
}

function htmlToWordBefore($doc,$html,$before,$template)
{
    $htmlDoc = new DOMDocument();
    @$htmlDoc->loadHTML("<html><body>{$html}</body></html>");

    $body = $htmlDoc->getElementsByTagName("body");
    $children = $body->item(0)->childNodes;
    foreach ($children as $child)
    {
        if (strtoupper($child->nodeName) == "P")
        {
            $v = $template['p']->cloneNode(true);
            $doc->newText($v,$child->nodeValue);
            $doc->insertParagraphBefore($v,$before);
        }
        if (strtoupper($child->nodeName) == "UL")
        {
            $list = $child->childNodes;
            foreach ($list as $li)
            {
                if (strtoupper($li->nodeName) == "LI")
                {
                    $v = $template['li']->cloneNode(true);
                    $doc->newText($v,$li->nodeValue);
                    $doc->insertParagraphBefore($v,$before);
                }
            }
        }
    }
}

$dtNow = new DateTime('now');
$reportsDir = $devt_environment->getkey("REPORTS_DIR");

//Create a new directory
$dirscratch = $reportsDir . "/{$dtNow->format('YmdHis')}";
mkdir($dirscratch);


$templatedir = $devt_environment->getkey("TEMPLATES_DIR");
$graphsdir = $devt_environment->getkey("GRAPHS_DIR");


$templatename = $templatedir . "/TemplateModerationReport.docx";

$evalid = 0;
$phaseid = 0;
$teamid=0;
$allcomments=0;
$dtNow = new DateTime('now');
$tableidx= 0;

$user = $DB->getUser($_SESSION['userid']);
if (!$user)
{
    header("Location: SecurityError.php");
    exit();
}
$dtNow->setTimezone(new DateTimeZone($user['user_timezone']));

if (isset($_GET['v']))
{
    $a = $FL->decryptParamRaw($_GET['v']);
    $evalid = $a['eval'];
    $phaseid = $a['phaseid'];
    $teamid = $a['teamid'];
    $allcomments = intval($a['allcomments']);
    $evaluation = $DB->getEvaluation($evalid);
}

if (!$evaluation)
{
    echo "Invalid evaluation parameter passed";
    exit();
}

//Get some evaluation details
$numEvaluators =
$numResponders = $DB->numOfRespondents($evalid);
$numQuestions = $DB->numOfQuestionsForEval($evalid);
$numSections = $DB-> numOfSectionsForEval($evalid);
$numPhases = $DB->numPhasesForEval($evalid);
$strtotalweightings = sprintf("%3.1f%%",$evaluation['evaluation_total_weightings']*100.0);
$finalphase = $DB->getFinalPhase($evalid);

//Start and end phases
$startPhase = null;
$lastPhase = null;

$bf = false;
$r = $DB->allPhasesForEval($evalid,"order by phase_order");
while ($phase = $r->fetch_array(MYSQLI_ASSOC))
{
    if (!$bf)
    {
        $startPhase = $phase;
        $bf = true;
    }
    $lastPhase = $phase;
}



//Loop here for each evaluator
$cntEvaluator = 0;
$r = $DB->allUsersForEval($evalid);
while ($evaluator = $r->fetch_array(MYSQLI_ASSOC))
{

    if (($teamid == 0 || $DB->hasTeamUser($teamid,$evaluator['iduser']) ) && $DB->userHasPhase($evaluator['iduser'],$phaseid))
    {
        $name = stripslashes($evaluator['user_name']);
        $name = preg_replace("/[^A-Za-z0-9 ]/", '', $name);
        $name = str_replace(" ","_",$name);

        $reportTitle = $dirscratch . "/ModerationReport{$name}.docx";
        //$reportTitle = $dirscratch . "/ModerationReport" . sprintf("%04d",$cntEvaluator) .  ".docx";

        $wdoc = new WordDoc("/tmp/Report{$dtNow->format('YmdHis')}");
        if (!$wdoc->open("{$templatename}") )
        {
            echo "Unable to open template document {$templatename}";
            exit();
        }

        //Get tenplate paragraphs
        $heading2 = $wdoc->findParagraphWhichIncludesText("8465856358");
        $start = $wdoc->findParagraphWhichIncludesText("START");
        $qheading1 = $wdoc->findParagraphWhichIncludesText("6248456889");
        $qheading2 = $wdoc->findParagraphWhichIncludesText("3745483396");
        $bodyttext = $wdoc->findParagraphWhichIncludesText("1745653956");
        $bodyttext3 = $wdoc->findParagraphWhichIncludesText("1845678904");
        $bodyttextbul = $wdoc->findParagraphWhichIncludesText("1845678905");
        $maximgnumber = $wdoc->findMaxImageNumber();
        $questiontemplates = ["p" => $bodyttext3,"li" => $bodyttextbul];



        $tbl1 = $wdoc->findDocElement(WORDDOC_TABLE,1);
        $tbl2 = $wdoc->findDocElement(WORDDOC_TABLE,2);

        /***********************************************************************
        FIRST PAGE
         */
        replaceMarkerWith('8237469438',$evaluation['evaluation_name'],true);
        //Page 1 Date
        replaceMarkerWith('4892372387',$dtNow->format('j F Y'),true);
        replaceMarkerWith('3846385657',stripslashes($evaluator['user_name']),true);

        $r2 = $DB->allTeamsForUserForEval($evalid,$evaluator['iduser']);
        while ($team = $r2->fetch_array(MYSQLI_ASSOC))
        {
            if ($teamid == 0 || $team['idteam'] == $teamid)
            {



                $wdoc->insertParaClonedFromBefore($heading2,$start,"TEAM {$team['team_name']}","8465856358");

                $r3 = $DB->allQuestionsForTeam($team['idteam']);
                while ($question = $r3->fetch_array(MYSQLI_ASSOC))
                {
                    $score_type = $question['question_type'];

                    //Check if we have sub-attributes
                    $numsubs = $DB->numOfSubsForQuestion($question['idquestion']);
                    if ($numsubs > 0)
                    {
                        $r5 = $DB->allSubForQuestion($question['idquestion'],"order by subattribute_number");
                        $sub = $r5->fetch_array();
                        $score_type = $sub['subattribute_type'];
                    }
                    else
                    {
                        $sub = array();
                        $sub['subattribute_number'] = 0;
                    }

                    while ($sub)
                    {
                        $questionheading = "QUESTION {$question['question_identifier']}";
                        if ($numsubs > 0)
                            $questionheading .= " - {$sub['subattribute_number']}";

                        $wdoc->insertParaClonedFromBefore($qheading1,$start,$questionheading,"6248456889");
                        $wdoc->insertParaClonedFromBefore($qheading2,$start,"SUMMARY","3745483396");

                        $newtbl = $tbl1->cloneNode(true);
                        $wdoc->insertParagraphBefore($newtbl,$start);
                        $row2 = $wdoc->findNthElement("w:tr",2,$newtbl);
                        $evalcomments = array();
                        $r4 = $DB->allRespondentsForEval($evalid,"order by respondent_name_full");
                        while ($respondent = $r4->fetch_array())
                        {
                            $newrow = $row2->cloneNode(true);
                            $wdoc->updateRowColumnText($newrow,1,stripslashes($respondent['respondent_name_full']));
                            $wdoc->tableNewRow($newtbl,$newrow);

                            if ($sub['subattribute_number'] == 0)
                                $matrix = $DB->getScoreAndRange($evalid,$evaluator['iduser'],$phaseid,$respondent['idrespondent'],$question['idquestion'],null);
                            else
                                $matrix = $DB->getScoreAndRange($evalid,$evaluator['iduser'],$phaseid,$respondent['idrespondent'],$question['idquestion'],$sub['idsubattribute']);

                            //Update the image



                            $strname = "/userbar" . sprintf("%04d%04d%04d%04d",$evaluator['iduser'],$respondent['idrespondent'],$question['idquestion'],$sub['subattribute_number']) . ".png";
                            if ($graphdata = file_get_contents($graphsdir . $strname))
                            {
                                //Duplicate Image
                                $newimg = $wdoc->duplicateImage(6);
                                if ($newimg)
                                {
                                    $wdoc->replaceRowColumnParagraph($newrow,2,$newimg);
                                    $maximage = $wdoc->findMaxImageNumber();
                                    $imgname = $wdoc->getImageParaFileName($maximage);
                                    $stripname = basename($imgname);
                                    $wdoc->replaceImage(basename($imgname),$graphdata);
                                }
                                else
                                {
                                    error_log("Reporter2.php Unable to duplicate image");
                                    exit();
                                }
                            }

                            $score = "";
                            switch ($score_type)
                            {
                                case 'range':
                                    $score = $matrix['userscore'];
                                    break;
                                case 'boolean':
                                    if (intval($matrix['userscore']) > 0)
                                        $score = "YES";
                                    else
                                        $score = "NO";
                                    break;
                                default:
                                    $score = $matrix['userscore'];
                                    break;
                            }

                            $wdoc->updateRowColumnText($newrow,3,$score);

                            $avg = 0.0;
                            if ($matrix['cnt'] > 0)
                                $avg = sprintf("%3.1f",floatval($matrix['sum'])/floatval($matrix['cnt']));
                            $wdoc->updateRowColumnText($newrow,4,$avg);
                            $strRange = "{$matrix['min']} - {$matrix['max']}";




                            $wdoc->updateRowColumnText($newrow,5,$strRange);

                            $comment = array();
                            $comment['name']  = $respondent['respondent_name_full'];
                            $comment['respondentid'] = $respondent['idrespondent'];
                            $comment['comment']  = $matrix['usertext'];
                            array_push($evalcomments,$comment);
                        }

                        $wdoc->tableDeleteRow($newtbl,1);
                        $wdoc->insertParaClonedFromBefore($bodyttext,$start,"","1745653956");

                        //Question text
                        $wdoc->insertParaClonedFromBefore($qheading2,$start,"QUESTION","3745483396");
                        if (substr($question['question_text'],0,1) == "<")
                            htmlToWordBefore($wdoc,$question['question_text'],$start,$questiontemplates);
                        else
                        {
                            $p = $bodyttext3->cloneNode(true);
                            $wdoc->insertParaClonedFromBefore($bodyttext3,$start,stripslashes($question['question_text']),"1845678904");
                        }

                        //Sub Attribute text
                        if ($numsubs > 0)
                        {
                            $wdoc->insertParaClonedFromBefore($qheading2,$start,"SUB ATTRIBUTE","3745483396");
                            if (substr($sub['subattribute_txt'],0,1) == "<")
                                htmlToWordBefore($wdoc,$sub['subattribute_txt'],$start,$questiontemplates);
                            else
                            {
                                $p = $bodyttext3->cloneNode(true);
                                $wdoc->insertParaClonedFromBefore($bodyttext3,$start,stripslashes($sub['subattribute_txt']),"1845678904");
                            }

                            //Guidance
                            $wdoc->insertParaClonedFromBefore($qheading2,$start,"GUIDANCE","3745483396");
                            if (substr($sub['subattribute_guide'],0,1) == "<")
                                htmlToWordBefore($wdoc,$sub['subattribute_guide'],$start,$questiontemplates);
                            else
                            {
                                $p = $bodyttext3->cloneNode(true);
                                $wdoc->insertParaClonedFromBefore($bodyttext3,$start,stripslashes($sub['subattribute_guide']),"1845678904");
                            }

                        }
                        else
                        {
                            //Guidance
                            $wdoc->insertParaClonedFromBefore($qheading2,$start,"GUIDANCE","3745483396");
                            if (substr($question['question_guide'],0,1) == "<")
                                htmlToWordBefore($wdoc,$question['question_guide'],$start,$questiontemplates);
                            else
                            {
                                $p = $bodyttext3->cloneNode(true);
                                $wdoc->insertParaClonedFromBefore($bodyttext3,$start,stripslashes($question['question_guide']),"1845678904");
                            }
                        }

                        if ($allcomments > 0)
                            $strHeading = "ALL COMMENTS";
                        else
                            $strHeading = "YOUR COMMENTS";

                        $wdoc->insertParaClonedFromBefore($qheading2,$start,$strHeading,"3745483396");
                        $newtbl = $tbl2->cloneNode(true);
                        $row1 = $wdoc->findNthElement("w:tr",1,$newtbl);
                        $row2 = $wdoc->findNthElement("w:tr",2,$newtbl);
                        $row3 = $wdoc->findNthElement("w:tr",3,$newtbl);
                        $row4 = $wdoc->findNthElement("w:tr",4,$newtbl);

                        foreach($evalcomments as $comment)
                        {
                            $newrow = $row1->cloneNode(true);
                            $wdoc->updateRowColumnText($newrow,1,stripslashes($comment['name']));
                            $wdoc->tableNewRow($newtbl,$newrow);

                            if ($allcomments > 0)
                            {
                                $newrow = $row3->cloneNode(true);
                                $wdoc->updateRowColumnText($newrow,2,"YOUR COMMENT");
                                $wdoc->tableNewRow($newtbl,$newrow);
                            }


                            $newrow = $row2->cloneNode(true);
                            $colpara = $wdoc->getTableColumnParagraph($newrow,2);


                            if (strlen($comment['comment']) > 0)
                            {
                                $comnt = str_replace("\\n","\n",$comment['comment']);
                                $lines = explode("\n",$comnt);
                                $cnt = 0;
                                foreach($lines as $line)
                                {
                                    if ($cnt == 0)
                                        $wdoc->updateRowColumnText($newrow,2,stripslashes($line));
                                    else
                                    {
                                        $np = $colpara->cloneNode(true);
                                        $wdoc->newText($np,stripslashes($line));
                                        $wdoc->insertTableColumnParagraph($newrow,2,$np);
                                    }
                                    $cnt++;
                                }
                            }
                            else
                                $wdoc->updateRowColumnText($newrow,2,"None");
                            $wdoc->tableNewRow($newtbl,$newrow);

                            $newrow = $row4->cloneNode(true);
                            $wdoc->tableNewRow($newtbl,$newrow);

                            //Loop here for other evauators comments
                            if ($allcomments > 0)
                            {
                                if ($sub['subattribute_number'] == 0)
                                {
                                    $r7 = $DB->allotherComments($evalid,$evaluator['iduser'],$phaseid,$comment['respondentid'],$question['idquestion'],null);
                                }
                                else
                                {
                                    $r7 = $DB->allotherComments($evalid,$evaluator['iduser'],$phaseid,$comment['respondentid'],$question['idquestion'],$sub['idsubattribute']);
                                }

                                while ($more = $r7->fetch_object("score"))
                                {

                                    $newrow = $row3->cloneNode(true);
                                    $wdoc->updateRowColumnText($newrow,2,$more->user_name->toWord());
                                    $wdoc->tableNewRow($newtbl,$newrow);

                                    $newrow = $row2->cloneNode(true);
                                    $colpara = $wdoc->getTableColumnParagraph($newrow,2);
                                    if ($more->score_comment->length() > 0)
                                    {
                                        $comnt = str_replace("\\n","\n",$more->score_comment->toWord());
                                        $lines = explode("\n",$comnt);
                                        $cnt = 0;
                                        foreach($lines as $line)
                                        {
                                            if ($cnt == 0)
                                                $wdoc->updateRowColumnText($newrow,2,stripslashes($line));
                                            else
                                            {
                                                $np = $colpara->cloneNode(true);
                                                $wdoc->newText($np,stripslashes($line));
                                                $wdoc->insertTableColumnParagraph($newrow,2,$np);
                                            }
                                            $cnt++;
                                        }
                                    }
                                    else
                                        $wdoc->updateRowColumnText($newrow,2,"None");
                                    $wdoc->tableNewRow($newtbl,$newrow);
                                    $newrow = $row4->cloneNode(true);
                                    $wdoc->tableNewRow($newtbl,$newrow);
                                }
                            }

                        }

                        $wdoc->tableDeleteRow($newtbl,0);
                        $wdoc->tableDeleteRow($newtbl,0);
                        $wdoc->tableDeleteRow($newtbl,0);
                        $wdoc->tableDeleteRow($newtbl,0);

                        $wdoc->insertParagraphBefore($newtbl,$start);

                        if ($numsubs > 0)
                            $sub = $r5->fetch_array();
                        else
                            $sub = null;

                    }
                }
            }
        }

        //Cleanup
        $wdoc->deleteParagraphWithText("8465856358");
        $wdoc->deleteParagraphWithText("6248456889");
        $wdoc->deleteParagraphWithText("1745653956");
        $wdoc->deleteParagraphWithText("1845678904");
        $wdoc->deleteParagraphWithText("1845678905");
        $wdoc->deleteParagraphWithText("3745483396");
        $wdoc->deleteParagraphWithText("START");

        $wdoc->tableDeleteTable($tbl1);
        $wdoc->tableDeleteTable($tbl2);

        $wdoc->SaveAs($reportTitle);
        $cntEvaluator++;
    }
}

header("Content-Type: application/zip");
header('Content-Disposition: attachment; filename="ModerationReports.zip"');

$dest = $reportsDir . "/ModerationReports.zip";
$zip = new ZipArchive();
$zip->open($dest, ZipArchive::CREATE | ZipArchive::OVERWRITE);
$files = filesInDir($dirscratch);
foreach ($files as $file)
{
    $name = substr($file, strlen($dirscratch) + 1);
    if (!$zip->addFile($file,$name) )
        error_log("nvaluate::Reporter2.php Error adding file {$file}");
}
$zip->close();
echo file_get_contents($dest);

?>