<?php
session_start();
require './includes/classEvalSecure.php';
require './includes/classEvaluateDB.php';
require './includes/classFormList.php';
require './includes/classWordDoc.php';
require './includes/classEvalHelpers.php';
require './includes/classTime.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
Secure::CheckPage(SECURITY_ADMIN);
$FL = new FormList(null);
$helpers = new helpers();

function var_error_log( $object=null ,$text='')
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( "{$text} {$contents}" );        // log contents of the result of var_dump( $object )
}


function replaceMarkerWith($marker,$with,$completepara=false)
{
    global $wdoc;
    if ($completepara)
    {
        $p1 = $wdoc->findParagraphWhichIncludesText($marker);
        if (!$p1)
        {
            error_log("Reporter [".__LINE__."] Unable to find marker {$marker}");
            return false;
        }
        if ($wdoc->newText($p1,$with) )
            return true;
        else
        {
            error_log("Reporter1 [".__LINE__."] replaceMarkerWith {$marker} failed.");
            return false;
        }
    }
    else
    {
        if ($wdoc->replaceText($marker,$with) )
            return true;
        else
        {
            error_log("Reporter1 [".__LINE__."] replaceMarkerWith {$marker} failed.");
            return false;
        }
    }
}

function htmlToWord($doc,$html,$parent,$template)
{
    $htmlDoc = new DOMDocument();
    $htmlDoc->loadHTML("<html><body>{$html}</body></html>");

    $body = $htmlDoc->getElementsByTagName("body");
    $children = $body->item(0)->childNodes;
    foreach ($children as $child)
    {
        if (strtoupper($child->nodeName) == "P")
        {
            $v = $template['p']->cloneNode(true);
            $doc->newText($v,$child->nodeValue);
            $parent->appendChild($v);
        }
        if (strtoupper($child->nodeName) == "UL")
        {
            $list = $child->childNodes;
            foreach ($list as $li)
            {
                if (strtoupper($li->nodeName) == "LI")
                {
                    $v = $template['li']->cloneNode(true);
                    $doc->newText($v,$li->nodeValue);
                    $parent->appendChild($v);
                }
            }
        }
    }
}

$reportsDir = $devt_environment->getkey("REPORTS_DIR");
$templatedir = $devt_environment->getkey("TEMPLATES_DIR");
$graphsdir = $devt_environment->getkey("GRAPHS_DIR");


$templatename = $templatedir . "/TemplateFinal.docx";
$reportTitle = $reportsDir . "/ScoreReport.docx";

$evalid = 0;
$dtNow = new DateTime('now');
$tableidx= 0;
$g_anon = 0;

$user = $DB->getUser($_SESSION['userid']);
if (!$user)
{
    header("Location: SecurityError.php");
    exit();
}
$dtNow->setTimezone(new DateTimeZone($user['user_timezone']));

if (isset($_GET['v']))
{
    $a = $FL->decryptParamRaw($_GET['v']);
    $evalid = $a['eval'];
    $g_anon = intval($a['anon']);
    $evaluation = $DB->getEvaluation($evalid);
}

if (!$evaluation)
{
    echo "Invalid evaluation parameter passed";
    exit();
}

//Get some evaluation details
$numEvaluators =
$numResponders = $DB->numOfRespondents($evalid);
$numQuestions = $DB->numOfQuestionsForEval($evalid);
$numSections = $DB-> numOfSectionsForEval($evalid);
$numPhases = $DB->numPhasesForEval($evalid);
$strtotalweightings = sprintf("%3.1f%%",$evaluation['evaluation_total_weightings']*100.0);
$finalphase = $DB->getFinalPhase($evalid);
$results = $helpers->phaseResults($evalid,$finalphase['idphase']);
$completeresults = $DB->completeResults($evalid);

//Start and end phases
$startPhase = null;
$lastPhase = null;

$bf = false;
$r = $DB->allPhasesForEval($evalid,"order by phase_order");
while ($phase = $r->fetch_array(MYSQLI_ASSOC))
{
    if (!$bf)
    {
        $startPhase = $phase;
        $bf = true;
    }
    $lastPhase = $phase;
}


//Get the totals for each respondent and sort by
$resultmatrix = array();
$questions = $results['questions'];
foreach($questions as $qu)
{
    foreach ($qu['respondent'] as $resp)
    {
        $respid = intval($resp['id']);
        if (!isset($resultmatrix[$resp['name']]))
        {
            $resultmatrix[$resp['name']] = floatval($resp['score']);
        }
        else
            $resultmatrix[$resp['name']] = $resultmatrix[$resp['name']]  + floatval($resp['score']);
    }
}
arsort($resultmatrix);

$wdoc = new WordDoc("/tmp/Report{$dtNow->format('YmdHis')}");
if (!$wdoc->open("{$templatename}") )
{
    echo "Unable to open template document {$templatename}";
    exit();
}

//********************************************************************
//Heading page
//********************************************************************
replaceMarkerWith('8237469438',$evaluation['evaluation_name'],true);

//Page 1 Date
replaceMarkerWith('4892372387',$dtNow->format('j F Y'),true);


//********************************************************************
// Executive summary
//********************************************************************
replaceMarkerWith('6783465897',$evaluation['evaluation_name']);
replaceMarkerWith('8712462138',$numResponders);
replaceMarkerWith('9813274230',$numQuestions);

//Execsum responders
$p1 = $wdoc->findParagraphWhichIncludesText('2938423984');
$r = $DB->allRespondentsForEval($evalid,"order by respondent_name_full");
while ($resp = $r->fetch_array(MYSQLI_ASSOC))
{
    $a1 = $p1->cloneNode(true);
    $wdoc->newText($a1,stripslashes($resp['respondent_name_full']));
    $wdoc->insertParagraphBefore($a1,$p1);
}
$wdoc->deleteParagraphWithText('2938423984');

replaceMarkerWith('2987234851',$numPhases);
//Start and end of scoring


//Number of days from first to last score.
$auditFirstScore = $DB->firstScoreForEval($evalid);
$auditLastScore = $DB->lastScoreForEval($evalid);

//Number of evaluators
$r = $DB->allUsersForEval($evalid);
replaceMarkerWith('92382934',$r->num_rows);


//Now works out if there is a clear leader or two on cant tell.
$last = -1;
$resultplace = array();
$cnt = 0;
$highest = 0;
foreach($resultmatrix as $r1 => $s1)
{
    $resultplace[$cnt] = array();
    $resultplace[$cnt] ['name'] = $r1;
    $resultplace[$cnt] ['score'] = floatval($s1);

    if ($last != -1)
    {
        $resultplace[$cnt] ['difffromlast'] = (floatval($s1) / $last) - 1;
        $resultplace[$cnt] ['difftolast'] = ($last / floatval($s1)) - 1;
        $resultplace[$cnt] ['difffromhighest'] = (floatval($s1) / $highest) - 1;
        $resultplace[$cnt] ['difftohighest'] = ($highest / floatval($s1)) - 1;
    }
    else
        $highest = floatval($s1);
    $last = floatval($s1);
    $cnt++;
}

//What is between first and second if its greater than -20%
if (abs($resultplace[1] ['difffromlast']) > 0.2)
{
    $strVal = sprintf("%2.0f%%",($resultplace[1] ['difftolast'] * 100.0));
    replaceMarkerWith('8485958488',$strVal);
    $wdoc->deleteParagraphWithText('1847236873');
    $wdoc->deleteParagraphWithText('2948723947');
}
else
{
    //Find the top x that are within 15%
    $topx = 0;
    for($idx = $numResponders-1; $idx > 0;$idx--)
    {
        if ($resultplace[$idx] ['difftohighest'] < 0.15)
        {
            $topx = $idx +1;
            break;
        }
    }

    if ($topx < $numResponders && $topx > 1)
    {
        replaceMarkerWith('1847236873',$topx);
        $strVal = sprintf("%2.0f%%",($resultplace[$topx-1] ['difftohighest'] * 100.0));
        replaceMarkerWith('3178631287',$strVal);
        $wdoc->deleteParagraphWithText('8485958488');
        $wdoc->deleteParagraphWithText('2948723947');
    }
    else
    {
        $strVal = sprintf("%2.0f%%",($resultplace[$numResponders-1] ['difftohighest'] * 100.0));
        replaceMarkerWith('2948723947',$strVal);
        $wdoc->deleteParagraphWithText('8485958488');
        $wdoc->deleteParagraphWithText('1847236873');
    }
}



//Final Scores
$tableidx = $tableidx + 1;
$tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);

$resultrow = $wdoc->findNthElement("w:tr",3,$tbl);
$blankrow = $wdoc->findNthElement("w:tr",4,$tbl);
$bottomrow = $wdoc->findNthElement("w:tr",5,$tbl);

$tr = $blankrow->cloneNode(true);
$nr = $tbl->appendChild($tr);
$mindiff = 1.0;
$lastres = null;
$mindiffa = null;
$mindiffb = null;

foreach($resultplace as $res)
{

    $tr = $resultrow->cloneNode(true);
    $col1 = $wdoc->findNthElement("w:tc",1,$tr);

    $col2 = $wdoc->findNthElement("w:tc",2,$tr);
    $col3 = $wdoc->findNthElement("w:tc",3,$tr);
    $wdoc->replaceText('7485636242',$res['name'],$col1);

    $txt = sprintf("%3.1f",floatval($res['score']));
    $wdoc->replaceText('2980',$txt,$col2);
    if (isset($res['difffromhighest']))
    {
        $txt = sprintf("%3.0f%%",(floatval($res['difffromhighest']) * 100.0));
        $wdoc->replaceText('2981',$txt,$col3);
    }
    else
        $wdoc->replaceText('2981','',$col3);
    $nr = $tbl->appendChild($tr);
    if (isset($res['difftolast']))
    {
        if ($res['difftolast'] < $mindiff)
        {
            $mindiff = $res['difftolast'];
            $mindiffb = $res;
            $mindiffa = $lastres;
        }
    }
    $lastres = $res;
}

$tr = $bottomrow->cloneNode(true);
$nr = $tbl->appendChild($tr);

$wdoc->tableDeleteRow($tbl,2);
$wdoc->tableDeleteRow($tbl,2);
$wdoc->tableDeleteRow($tbl,2);

//3% is deamed close
if ($mindiff < 0.03 && $mindiffa && $mindiffb)
{
    $min1 = intval($mindiff * 100.0);

    $str1 = sprintf("%f1.0%%",$min1);
    replaceMarkerWith('3592111987',$str1);
    replaceMarkerWith('4823547585',$mindiffa['name']);
    replaceMarkerWith('3845654723',$mindiffb['name']);
}
else
    $wdoc->deleteParagraphWithText('3592111987');


//Graph
if ($graphdata = file_get_contents($graphsdir . '/img0.png'))
    $wdoc->replaceImage("image1.png",$graphdata);

//********************************************************************
// EVALUATION SUMMARY
//********************************************************************

//********************************************************************
// Overeview
//********************************************************************
//Determine actual start which is the lesser of first score and first phase enabled.

$dtearlieststart = null;
$dtlatestfinish = null;

$strTimePhaseStarted='';
if ($startPhase['phase_start_timestamp'])
{
    $strTimePhaseStarted = classTimeHelpers::timeFormat($startPhase['phase_start_timestamp'],"D jS M Y",$user['user_timezone']);
    $dtS1 = new DateTime($startPhase['phase_start_timestamp']);
    $dtearlieststart = $dtS1;
    if ($auditFirstScore)
    {
        $dtS2 = new DateTime($auditFirstScore['audit_timestamp']);
        if ($dtS2->getTimestamp() < $dtS1->getTimestamp())
        {
            $strT = classTimeHelpers::timeFormat($auditFirstScore['audit_timestamp'],"D jS M Y",$user['user_timezone']);
            $dtearlieststart = $dtS2;
        }
    }
}
else
{
    if ($auditFirstScore)
    {
        $strT = classTimeHelpers::timeFormat($auditFirstScore['audit_timestamp'],"D jS M Y",$user['user_timezone']);
        $dtearlieststart = new DateTime($auditFirstScore['audit_timestamp']);
    }
    else
        $strT = '';
}
replaceMarkerWith('6783648739',$strTimePhaseStarted);

$strTimePhaseCompleted='';
if ($lastPhase['phase_complete_timestamp'])
{
    $strTimePhaseCompleted = classTimeHelpers::timeFormat($lastPhase['phase_complete_timestamp'],"D jS M Y",$user['user_timezone']);
    $dtS1 = new DateTime($lastPhase['phase_complete_timestamp']);
    $dtlatestfinish = $dtS1;
    if ($auditLastScore)
    {
        $dtS2 = new DateTime($auditLastScore['audit_timestamp']);
        if ($dtS2->getTimestamp() > $dtS1->getTimestamp())
        {
            $strT = classTimeHelpers::timeFormat($auditLastScore['audit_timestamp'],"D jS M Y",$user['user_timezone']);
            $dtlatestfinish = $dtS2;
        }
    }
}
else
{
    if ($auditLastScore)
    {
        $strT = classTimeHelpers::timeFormat($auditLastScore['audit_timestamp'],"D jS M Y",$user['user_timezone']);
        $dtlatestfinish = new DateTime($auditLastScore['audit_timestamp']);
    }
    else
        $strT = '';
}
replaceMarkerWith('3945844956',$strTimePhaseCompleted);


if ($auditFirstScore)
    $strT = classTimeHelpers::timeFormat($auditFirstScore['audit_timestamp'],"D jS M Y",$user['user_timezone']);
else
    $strT = '';
replaceMarkerWith('6395652548',$strT);

if ($auditLastScore)
    $strT = classTimeHelpers::timeFormat($auditLastScore['audit_timestamp'],"D jS M Y",$user['user_timezone']);
else
    $strT = '';
replaceMarkerWith('0563265495',$strT);

if ($dtearlieststart && $dtlatestfinish)
{
    $tseconds = classTimeHelpers::timeDiff($dtearlieststart,$dtlatestfinish);
    $days = intval($tseconds / (3600*24)) + 1;
    replaceMarkerWith('8356846578',$days);
    replaceMarkerWith('4867249347',$days);
}
else
{
    $wdoc->deleteParagraphWithText('8356846578');
    replaceMarkerWith('4867249347',"[xx]");
}

//********************************************************************
// heading quetsions
//********************************************************************
//number of questions and sections
replaceMarkerWith('2094638937',$numQuestions);
replaceMarkerWith('5459673456',$numSections);
replaceMarkerWith('3856624596',$strtotalweightings);

//List the questions
$tableidx = $tableidx + 1;
$tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);
$secitionrow = $wdoc->findNthElement("w:tr",3,$tbl);
$questionrow = $wdoc->findNthElement("w:tr",4,$tbl);

$bulletrow = $wdoc->findNthElement("w:tr",5,$tbl);
$tc = $wdoc->findNthElement(WORDDOC_TABLE_CELL,4,$bulletrow);
//Find normal and bullet paras
$questionpara = $wdoc->findNthElement("w:p",1,$tc);
$bulletpara = $wdoc->findNthElement("w:p",2,$tc);

$questiontemplates = ["p" => $questionpara,"li" => $bulletpara];

$lastrow = $wdoc->findNthElement("w:tr",6,$tbl);

$sectionName = '';
$r = $DB->allQuestionsForEvalWithSection($evalid, "order by section_order,question_order");
while ($quest = $r->fetch_array(MYSQLI_ASSOC))
{
    if ($sectionName != $quest['section_name'])
    {
        $sectionName = $quest['section_name'];
        $newsection = $secitionrow->cloneNode(true);
        $col1 = $wdoc->findNthElement("w:tc",1,$newsection);
        $wdoc->replaceText('5498733492',$sectionName,$col1);
        $nr = $tbl->appendChild($newsection);
    }
    $strweight = sprintf("%3.1f%%",$quest['question_weighting'] * 100);

    $newq = $questionrow->cloneNode(true);
    $col2 = $wdoc->findNthElement("w:tc",2,$newq);
    $col3 = $wdoc->findNthElement("w:tc",3,$newq);
    $col4 = $wdoc->findNthElement("w:tc",4,$newq);
    $wdoc->replaceText('2982',$quest['question_identifier'],$col2);
    $wdoc->replaceText('2983',$strweight,$col3);
    if (substr($quest['question_text'],0,1) == "<")
    {
        $p = $wdoc->findParagraphWhichIncludesText("3984395464",$col4);
        $wdoc->deleteParagraph($p);
        htmlToWord($wdoc,$quest['question_text'],$col4,$questiontemplates);
    }
    else
        $wdoc->replaceText('3984395464',$quest['question_text'],$col4);
    $nr = $tbl->appendChild($newq);
}
$newq = $lastrow->cloneNode(true);
$nr = $tbl->appendChild($newq);

$wdoc->tableDeleteRow($tbl,1);
$wdoc->tableDeleteRow($tbl,1);
$wdoc->tableDeleteRow($tbl,1);
$wdoc->tableDeleteRow($tbl,1);
$wdoc->tableDeleteRow($tbl,1);

//********************************************************************
// Evaluation teams
//********************************************************************
$r = $DB->allTeamsForEval($evalid,'order by team_name');
replaceMarkerWith('8548769463',$r->num_rows);


$tableidx = $tableidx + 1;
$tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);

$teamnamerow = $wdoc->findNthElement("w:tr",3,$tbl);
$namerow = $wdoc->findNthElement("w:tr",4,$tbl);
$blankrow = $wdoc->findNthElement("w:tr",5,$tbl);
$totlarow = $wdoc->findNthElement("w:tr",7,$tbl);

$tbl->appendChild($blankrow->cloneNode(true));
$qcount = 0;
while ($team = $r->fetch_array(MYSQLI_ASSOC))
{

    $t1 = $teamnamerow->cloneNode(true);
    $col1 = $wdoc->findNthElement("w:tc",1,$t1);
    $col2 = $wdoc->findNthElement("w:tc",2,$t1);
    $col3 = $wdoc->findNthElement("w:tc",3,$t1);
    $wdoc->replaceText('4756485869',$team['team_name'],$col1);
    $r2 = $DB->allQuestionsForTeam($team['idteam']);
    $qcount += $r2->num_rows;
    $wdoc->replaceText('2984',$r2->num_rows,$col2);
    $r3 = $DB->allUsersForTeam($team['idteam']);
    $bf = false;
    while ($teamuser = $r3->fetch_array(MYSQLI_ASSOC))
    {
        $name = stripslashes($teamuser['user_name']);
        if ($g_anon != 0)
            $name = "Evaluator {$teamuser['iduser']}";
        if (!$bf)
        {

            $wdoc->replaceText('3567856768',$name,$col3);
            $bf = true;
            $nr = $tbl->appendChild($t1);
            $t1 = null;
        }
        else
        {
            $t2 = $namerow->cloneNode(true);
            $col3 = $wdoc->findNthElement("w:tc",3,$t2);
            $wdoc->replaceText('4255495663',$name,$col3);
            $nr = $tbl->appendChild($t2);

        }
    }
    if ($t1)
        $nr = $tbl->appendChild($t1);
}
$tbl->appendChild($blankrow->cloneNode(true));
$t3 = $totlarow->cloneNode(true);
$col2 = $wdoc->findNthElement("w:tc",2,$t3);
$wdoc->replaceText('2985',$qcount,$col2);
$nr = $tbl->appendChild($t3);

$wdoc->tableDeleteRow($tbl,2);
$wdoc->tableDeleteRow($tbl,2);
$wdoc->tableDeleteRow($tbl,2);
$wdoc->tableDeleteRow($tbl,2);
$wdoc->tableDeleteRow($tbl,2);
$wdoc->tableDeleteRow($tbl,2);

if ($qcount > $numQuestions)
{
    replaceMarkerWith('8735474352',$qcount);
    replaceMarkerWith('2348552845',$numQuestions);
}
else
    $wdoc->deleteParagraphWithText('8735474352');

//********************************************************************
// Phases
//********************************************************************
$tableidx = $tableidx + 1;
if ($numPhases > 1)
{
    replaceMarkerWith('2348512047',$numPhases);
    $wdoc->deleteParagraphWithText('2348512049');
}
else
{
    replaceMarkerWith('2348512049',"");
    $wdoc->deleteParagraphWithText('2348512047');
}

$tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);
$row2 = $wdoc->findNthElement("w:tr",2,$tbl);
$row3 = $wdoc->findNthElement("w:tr",3,$tbl);

$r = $DB->allPhasesForEval($evalid,"order by phase_order");
while ($phase = $r->fetch_array(MYSQLI_ASSOC))
{
    $nr = $row2->cloneNode(true);
    $wdoc->updateRowColumnText($nr,1,$phase['phase_name']);
    if ($phase['phase_single_score'])
        $wdoc->updateRowColumnText($nr,2,"Single");
    else
        $wdoc->updateRowColumnText($nr,2,"Group");
    $wdoc->updateRowColumnText($nr,3,classTimeHelpers::timeFormat($phase['phase_start_timestamp'],"D jS M Y",$user['user_timezone']));
    $wdoc->updateRowColumnText($nr,4,classTimeHelpers::timeFormat($phase['phase_complete_timestamp'],"D jS M Y",$user['user_timezone']));
    $wdoc->tableNewRow($tbl,$nr);
}

$wdoc->tableDeleteRow($tbl,1);

//********************************************************************
// Respondents
//********************************************************************
if ($numResponders > 1)
    replaceMarkerWith('2372423535',"{$numResponders} respondents:");
else
if ($numResponders== 1)
    replaceMarkerWith('2372423535',"{$numResponders} respondent:");
else
    replaceMarkerWith('2372423535',"no respondents:");

$h3 = $wdoc->findParagraphWhichIncludesText("2956635458");
$b3 = $wdoc->findParagraphWhichIncludesText("3487563865");
$endy = $wdoc->findParagraphWhichIncludesText("8273463894");

$r = $DB->allRespondentsForEval($evalid,"order by respondent_name_full");
while ($respondent = $r->fetch_array(MYSQLI_ASSOC))
{
    $h3n = $h3->cloneNode(true);
    $wdoc->newText($h3n,stripslashes($respondent['respondent_name_full']));
    $wdoc->insertParagraphBefore($h3n,$endy);

    $b3n = $b3->cloneNode(true);
    $wdoc->replaceText('3487563865',"",$b3n);
    $wdoc->insertParagraphBefore($b3n,$endy);

}

$wdoc->deleteParagraphWithText("2956635458");
$wdoc->deleteParagraphWithText("3487563865");
$wdoc->deleteParagraphWithText("8273463894");


//********************************************************************
// Evaluators
//********************************************************************
//Find ending marker
$tableidx = $tableidx + 1;
$tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);



$paraafter = $wdoc->findParagraphWhichIncludesText('1735478355');

$r = $DB->allUsersForEval($evalid);
while ($evaluator = $r->fetch_array(MYSQLI_ASSOC))
{
    $para = $wdoc->findParagraphWhichIncludesText('4856478586');
    $np = $para->cloneNode(true);
    $name = stripslashes($evaluator['user_name']);
    if ($g_anon != 0)
        $name = "Evaluator {$evaluator['iduser']}";

    $wdoc->newText($np,$name);
    $wdoc->insertParagraphBefore($np,$paraafter);

    $np = $paraafter->cloneNode(true);
    $wdoc->newText($np,"The following information are statistics and details about the evaluator:");
    $wdoc->insertParagraphBefore($np,$paraafter);

    $np = $paraafter->cloneNode(true);
    $wdoc->newText($np,"");
    $wdoc->insertParagraphBefore($np,$paraafter);




    //Duplicate table
    $newtbl = $tbl->cloneNode(true);

    $firstr = true;
    $r2 = $DB->allTeamsForUserForEval($evalid,$evaluator['iduser']);
    $numteams = $r2->num_rows;

    $row1 = $wdoc->findNthElement("w:tr",1,$newtbl);
    $row2 = $wdoc->findNthElement("w:tr",2,$newtbl);
    $row3 = $wdoc->findNthElement("w:tr",3,$newtbl);
    $insertedrows = 0;

    while ($team = $r2->fetch_array())
    {
        if ($firstr)
        {
            $wdoc->updateRowColumnText($row1,2,$team['team_name']);
            $firstr = false;
        }
        else
        {
            $row2 = $wdoc->findNthElement("w:tr",2,$newtbl);
            $nr = $row2->cloneNode(true);
            $wdoc->updateRowColumnText($nr,2,$team['team_name']);
            $newtbl->insertBefore($nr,$row3);
            $insertedrows++;
        }

    }

    //First score
    $af = $DB->getFirstScoreAuditForUser($evalid,$evaluator['iduser']);
    $row3 = $wdoc->findNthElement("w:tr",3+$insertedrows,$newtbl);
    if ($af)
        $wdoc->updateRowColumnText($row3,2,classTimeHelpers::timeFormat($af['audit_timestamp'],"D jS M Y",$user['user_timezone']));
    else
        $wdoc->updateRowColumnText($row3,2,"");


    //Last score
    $al = $DB->getLastScoreAuditForUser($evalid,$evaluator['iduser']);
    $row4 = $wdoc->findNthElement("w:tr",4+$insertedrows,$newtbl);
    if ($al)
        $wdoc->updateRowColumnText($row4,2,classTimeHelpers::timeFormat($al['audit_timestamp'],"D jS M Y",$user['user_timezone']));
    else
        $wdoc->updateRowColumnText($row4,2,"");

    //Num of phases
    $r1 = $DB->phasesForUserForEval($evalid,$evaluator['iduser']);
    $row5 = $wdoc->findNthElement("w:tr",5+$insertedrows,$newtbl);
    $wdoc->updateRowColumnText($row5,2,$r1->num_rows);

    //Total scores to evaluate
    //How many teams is the evaluator on
    $scorecnt = 0;
    $r10 = $DB->allTeamsForUserForEval($evalid,$evaluator['iduser']);
    while ($team = $r10->fetch_array(MYSQLI_ASSOC))
    {
        $scorecnt += $DB->numQuestionSubsForTeam($team['idteam']);
    }
    $scorecnt = $numResponders * $scorecnt;

    $row6 = $wdoc->findNthElement("w:tr",6+$insertedrows,$newtbl);
    $wdoc->updateRowColumnText($row6,2,$scorecnt);


    //Average scores per day
    $diff = 0;
    $num = 0;
    $r12 = $DB->phasesForUserForEval($evalid,$evaluator['iduser']);
    while ($phase = $r12->fetch_array(MYSQLI_ASSOC))
    {
        $a1 = $DB->FirstScoreAuditForUserForPhase($evalid,$evaluator['iduser'],$phase['idphase']);
        $a2 = $DB->LastScoreAuditForUserForPhase($evalid,$evaluator['iduser'],$phase['idphase']);
        if ($a1 && $a2)
        {
            //Determine time diff between first and last entry
            $diff+=  classTimeHelpers::timeDiff(new DateTime($a1['audit_timestamp']),new DateTime($a2['audit_timestamp']));
            $num+=  $DB->numScoreAuditsForUserForPhase($evalid,$evaluator['iduser'],$phase['idphase']);
        }
    }

    $row7 = $wdoc->findNthElement("w:tr",7+$insertedrows,$newtbl);
    $strnum = "";
    if ($diff > 0)
    {
        $nperday = ($num/$diff) * 3600*24;
        $strnum = sprintf("%4.1f",$nperday);
    }
    $wdoc->updateRowColumnText($row7,2,$strnum);


    $wdoc->tableDeleteRow($newtbl,1);
    $wdoc->insertParagraphBefore($newtbl,$paraafter);
    $tableidx = $tableidx + 1;


    $np = $paraafter->cloneNode(true);
    $wdoc->newText($np,"");
    $wdoc->insertParagraphBefore($np,$paraafter);

    //PHASE HEADINGS LEVEL 3



    $img1 = $wdoc->findImagePara(2);
    $img2 = $wdoc->findImagePara(4);
    $img3 = $wdoc->findImagePara(5);
    $hd3 = $wdoc->findParagraphWhichIncludesText('2475463854');
    $hd3p = $wdoc->findParagraphWhichIncludesText('7645658765');
    $hd3pitalic = $wdoc->findParagraphWhichIncludesText('7645658766');

    if (!$img1)
    {
        error_log(__FILE__ . "[".__LINE__."] image # 2 not found");
    }

    $r2 = $DB->phasesForUserForEval($evalid,$evaluator['iduser'],'order by phase_order');
    while ($phase = $r2->fetch_array(MYSQLI_ASSOC))
    {
        $np = $hd3->cloneNode(true);
        $wdoc->newText($np,"Phase {$phase['phase_name']}");
        $wdoc->insertParagraphBefore($np,$paraafter);


        $np = $hd3p->cloneNode(true);
        $npi = $hd3pitalic->cloneNode(true);

        $formated_name = stripslashes($evaluator['user_name']);
        if ($g_anon != 0)
            $formated_name = "Evaluator {$evaluator['iduser']}";

        if($phase['phase_status'] != 'complete')
        {
            $wdoc->newText($np,"This phase has either not started or is still in progress so no progress information for {$formated_name} has been presented.");
        }
        else
        {
            $wdoc->newText($np,"The following graph depicts when {$formated_name} scored each new question or sub-attribute.  The vertical axis represents the percentage of questions for this phase completed with the horizontal axis representing date/time.");

        }
        $wdoc->insertParagraphBefore($np,$paraafter);

        if ($phase['phase_populate_from_utility'] && $phase['phase_status'] == 'complete')
        {
            $wdoc->newText($npi,"Note: Scores for this phase were initially copied from another phase.  The following graph only depicts when {$formated_name} changed a score and therefore as not all scores may have been changed, the graph may not reach 100% even though the phase is complete.");
            $wdoc->insertParagraphBefore($npi,$paraafter);
        }

        if($phase['phase_status'] == 'complete')
        {
            if ($img1)
            {
                $strname = "/imgeval" . sprintf("%05d%05d",intval($evaluator['iduser']),intval($phase['idphase'])) . ".png";
                if ($graphdata = file_get_contents($graphsdir . $strname))
                {
                    //Duplicate Image
                    $newimg = $wdoc->duplicateImage(2);
                    $wdoc->insertParagraphBefore($newimg,$paraafter);
                    $maximage = $wdoc->findMaxImageNumber();
                    $imgname = $wdoc->getImageParaFileName($maximage);
                    $stripname = basename($imgname);
                    $wdoc->replaceImage(basename($imgname),$graphdata);
                }
            }
        }

        $np = $hd3p->cloneNode(true);
        $wdoc->newText($np,"");
        $wdoc->insertParagraphBefore($np,$paraafter);

    }
}

$wdoc->deleteParagraphWithText('4856478586');
$wdoc->tableDeleteTable($tbl);
$wdoc->deleteParagraphWithText('2475463854');
$wdoc->deleteParagraphWithText('7645658765');
$wdoc->deleteParagraphWithText('7645658766');
$wdoc->deleteParagraph($img1);

$wdoc->deleteParagraphWithText('1735478355');

//********************************************************************
// Results
//********************************************************************
$phaseheading = $wdoc->findParagraphWhichIncludesText("2385673785");

$singlescorephasepara = $wdoc->findParagraphWhichIncludesText("1238295689");
$multiplescorephasepara = $wdoc->findParagraphWhichIncludesText("4867349756");

$teamheading = $wdoc->findParagraphWhichIncludesText("8274623876");
$phasepara = $wdoc->findParagraphWhichIncludesText("5678543");
$phasersltheading = $wdoc->findParagraphWhichIncludesText("5294572945");
$summarytbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);
$tableidx = $tableidx + 1;
$resulttbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);
$resultphasegrapheading = $wdoc->findParagraphWhichIncludesText("7395636586");
$phasegraphfigure1 = $wdoc->findParagraphWhichIncludesText("6927345634");
$tableidx = $tableidx + 1;
$phasedifftbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);
$tableidx = $tableidx + 1;

$endy = $wdoc->findParagraphWhichIncludesText("6987587635");


$r = $DB->allPhasesForEval($evalid,"order by phase_order");
while ($phase = $r->fetch_array(MYSQLI_ASSOC))
{

    $results = $helpers->phaseResults($evalid,$phase['idphase']);
    //h3 heading
    $wdoc->insertParaClonedFromBefore($phaseheading,$endy,$phase['phase_name']);
    if ($phase['phase_single_score'])
    {
        $p = $singlescorephasepara->cloneNode(true);
        $wdoc->replaceText("1238295689","",$p);
        $wdoc->insertParagraphBefore($p,$endy);
    }
    else
    {
        $p = $multiplescorephasepara->cloneNode(true);
        $wdoc->replaceText("4867349756","",$p);
        $wdoc->insertParagraphBefore($p,$endy);
    }




    $numTeamsFoPhase = $DB->numOfTeamsForEvalForPhase($evalid,$phase['idphase']);
    $p = $phasepara->cloneNode(true);
    $wdoc->replaceText("5678543",$numTeamsFoPhase,$p);
    $wdoc->insertParagraphBefore($p,$endy);

    //Teams for phase
    $r2 = $DB->allTeamsForEval($evalid,"order by team_name");
    while ($team = $r2->fetch_array(MYSQLI_ASSOC))
    {
        if ( $DB->isTeamUsedOnPhase($team['idteam'],$phase['idphase']) )
        {
            $wdoc->insertParaClonedFromBefore($teamheading,$endy,$team['team_name']);
            $wdoc->insertParaClonedFromBefore($endy,$endy," ");

            //New summary table
            $ns = $summarytbl->cloneNode(true);

            //How many evaluators in team
            $numEvalsOnTeam = $DB->numUsersForTeam($team['idteam']);
            $wdoc->updateTableRowCol($ns,2,2,$numEvalsOnTeam);
            $wdoc->updateTableRowCol($ns,3,2,$DB->numQuestionSubsForTeam($team['idteam']));

            //Calculate average/min/max score for team
            if ($results['status'])
            {
                $res = $DB->minMaxAveTeam($evalid,$phase['idphase'],$team['idteam']);
                $wdoc->updateTableRowCol($ns,4,2,sprintf("%3.1f",$res['avg']));
                $wdoc->updateTableRowCol($ns,5,2,sprintf("%3.0f",$res['max']));
                $wdoc->updateTableRowCol($ns,6,2,sprintf("%3.0f",$res['min']));
            }
            else
            {
                $wdoc->updateTableRowCol($ns,4,2,"Not completed");
                $wdoc->updateTableRowCol($ns,5,2,"Not completed");
                $wdoc->updateTableRowCol($ns,6,2,"Not completed");
            }

            if ($phase['phase_single_score'] || $numEvalsOnTeam < 2)
            {
                $wdoc->tableDeleteRow($ns,6);
                $wdoc->tableDeleteRow($ns,6);
                $wdoc->tableDeleteRow($ns,6);
            }
            else
            {
                //Now for each member of the team compare score averages and maximum differences.
                $res = $DB->minMaxAveByUserInTeam($evalid,$phase['idphase'],$team['idteam']);
                $wdoc->updateTableRowCol($ns,8,3,sprintf("%3.1f",$res['avgdiff']));
                $wdoc->updateTableRowCol($ns,9,3,sprintf("%3.0f",$res['max']));
            }

            $wdoc->insertParagraphBefore($ns,$endy);
            $wdoc->insertParaClonedFromBefore($endy,$endy," ");
        }

    }

    //Phase results
    $wdoc->insertParaClonedFromBefore($phasersltheading,$endy,"Phase Results");
    $wdoc->insertParaClonedFromBefore($endy,$endy," ");
    $ns = $resulttbl->cloneNode(true);

    //Build phase team results table

    for ($ri = 0;$ri < 7;$ri++)
    {
        $row = $wdoc->findNthElement("w:tr",$ri + 1,$ns);
        if ($ri == 2 || $ri == 3 || $ri == 6)
            $tc = $wdoc->findNthElement(WORDDOC_TABLE_CELL,2,$row);
        else
            $tc = $wdoc->findNthElement(WORDDOC_TABLE_CELL,3,$row);
        for ($j = 0; $j < ($numResponders-1);$j++)
        {
            $rep = $tc->cloneNode(true);
            $row->appendChild($rep);
        }
    }

    $idx = 0;
    $r2 = $DB->allRespondentsForEval($evalid,"order by respondent_name_short");
    while ($respondent = $r2->fetch_array(MYSQLI_ASSOC))
    {
        $wdoc->updateTableRowCol($ns,1,$idx+3,stripslashes($respondent['respondent_name_short']));
        $idx++;
    }

    //Each question and section
    $sectionwrow = $wdoc->findNthElement("w:tr",3,$ns);
    $resultrow = $wdoc->findNthElement("w:tr",5,$ns);
    $beforetotalrow = $wdoc->findNthElement("w:tr",6,$ns);
    $sectiontotal = $wdoc->findNthElement("w:tr",4,$ns);
    $totalrow = $wdoc->findNthElement("w:tr",7,$ns);

    $startedsection = false;
    $sectionname='';
    $responderTotal = array();
    $responderSectionTotal = array();
    $r5 = $DB->allQuestionsForEvalWithSection($evalid,"order by question_order");
    while ($qu = $r5->fetch_array(MYSQLI_ASSOC))
    {
        if ($qu['section_name'] != $sectionname)
        {
            //Do we need to add a section total row total
            if ($startedsection)
            {
                $newrow = $sectiontotal->cloneNode(true);
                for ($idx = 0;$idx < $numResponders;$idx++)
                {
                    $wdoc->updateRowColumnText($newrow,$idx+2,sprintf("%3.3f",$responderSectionTotal[$idx]));
                    $responderSectionTotal[$idx] = 0.0;
                }
                $ns->appendChild($newrow);
            }


            //Add new section row
            $sectionname = $qu['section_name'];
            $newrow = $sectionwrow->cloneNode(true);
            $wdoc->updateRowColumnText($newrow,1,$sectionname);
            $ns->appendChild($newrow);
        }

        $startedsection = true;

        $r6 = $DB->allSubForQuestion($qu['idquestion']);
        if ($r6->num_rows > 0)
        {
            while ($sub = $r6->fetch_array(MYSQLI_ASSOC))
            {
                $newrow = $resultrow->cloneNode(true);
                $wdoc->updateRowColumnText($newrow,2,"{$qu['question_identifier']}-{$sub['subattribute_number']}");
                $idx = 0;
                $r7 = $DB->allRespondentsForEval($evalid,"order by respondent_name_short");
                while ($respondent = $r7->fetch_array(MYSQLI_ASSOC))
                {
                    if (!isset($responderTotal[$idx]))
                        $responderTotal[$idx] = 0.0;
                    if (!isset($responderSectionTotal[$idx]))
                        $responderSectionTotal[$idx] = 0.0;
                    $scors = $DB->sumScores($evalid,$phase['idphase'],$respondent['idrespondent'],$qu['idquestion'],$sub['idsubattribute']);
                    $arawscore = 0.0;
                    if ($scors['COUNT'] > 0)
                    {
                        $arawscore = $scors['SUM'] / $scors['COUNT'];
                    }
                    //Add weightings
                    $arawscore = $arawscore * $sub['subattribute_weighting'] * $qu['question_weighting'];
                    $responderTotal[$idx] = $responderTotal[$idx] + $arawscore;
                    $responderSectionTotal[$idx] = $responderSectionTotal[$idx] + $arawscore;
                    $wdoc->updateRowColumnText($newrow,3+$idx,sprintf("%3.3f",$arawscore));
                    $idx++;
                }



                $ns->appendChild($newrow);

            }
        }
        else
        {
            $newrow = $resultrow->cloneNode(true);
            $wdoc->updateRowColumnText($newrow,2,$qu['question_identifier']);
            $idx = 0;
            $r7 = $DB->allRespondentsForEval($evalid,"order by respondent_name_short");
            while ($respondent = $r7->fetch_array(MYSQLI_ASSOC))
            {
                if (!isset($responderTotal[$idx]))
                    $responderTotal[$idx] = 0.0;
                if (!isset($responderSectionTotal[$idx]))
                    $responderSectionTotal[$idx] = 0.0;
                $scors = $DB->sumScores($evalid,$phase['idphase'],$respondent['idrespondent'],$qu['idquestion']);
                $arawscore = 0.0;
                if ($scors['COUNT'] > 0)
                {
                    $arawscore = $scors['SUM'] / $scors['COUNT'];
                }
                //Add weightings
                $arawscore = $arawscore * $qu['question_weighting'];
                $responderTotal[$idx] = $responderTotal[$idx] + $arawscore;
                $responderSectionTotal[$idx] = $responderSectionTotal[$idx] + $arawscore;
                $wdoc->updateRowColumnText($newrow,3+$idx,sprintf("%3.3f",$arawscore));
                $idx++;
            }





            $ns->appendChild($newrow);

        }


    }

    //Last section
    if ($startedsection)
    {
        $newrow = $sectiontotal->cloneNode(true);
        for ($idx = 0;$idx < $numResponders;$idx++)
        {
            $wdoc->updateRowColumnText($newrow,$idx+2,sprintf("%3.3f",$responderSectionTotal[$idx]));
            $responderSectionTotal[$idx] = 0.0;
        }
        $ns->appendChild($newrow);
    }

    //Insert totals row
    $newrow = $beforetotalrow->cloneNode(true);
    $ns->appendChild($newrow);

    $newrow = $totalrow->cloneNode(true);
    for ($idx = 0;$idx < $numResponders;$idx++)
    {
        $wdoc->updateRowColumnText($newrow,2+$idx,sprintf("%3.3f",$responderTotal[$idx]));
    }

    //Now remove the top lines
    $wdoc->tableDeleteRow($ns,1);
    $wdoc->tableDeleteRow($ns,1);
    $wdoc->tableDeleteRow($ns,1);
    $wdoc->tableDeleteRow($ns,1);
    $wdoc->tableDeleteRow($ns,1);
    $wdoc->tableDeleteRow($ns,1);

    $ns->appendChild($newrow);
    $wdoc->insertParagraphBefore($ns,$endy);
    $wdoc->insertParaClonedFromBefore($endy,$endy," ");

    //Phase graph
    $p = $resultphasegrapheading->cloneNode(true);
    $wdoc->replaceText("7395636586",$phase['phase_name'],$p);
    $wdoc->insertParagraphBefore($p,$endy);


    if ($img2)
    {
        $strname = "/imgphase" . sprintf("%05d",intval($phase['idphase'])) . ".png";
        if ($graphdata = file_get_contents($graphsdir . $strname))
        {
            //Duplicate Image
            $newimg = $wdoc->duplicateImage(4);
            $wdoc->insertParagraphBefore($newimg,$endy);
            $maximage = $wdoc->findMaxImageNumber();
            $imgname = $wdoc->getImageParaFileName($maximage);
            $stripname = basename($imgname);
            $wdoc->replaceImage(basename($imgname),$graphdata);
        }
        //$wdoc->insertParaClonedFromBefore($endy,$endy," ");
        $p = $phasegraphfigure1->cloneNode(true);
        $wdoc->replaceText("6927345634","",$p);
        $wdoc->insertParagraphBefore($p,$endy);
    }
}

//Delete the templates for this section.
$wdoc->deleteParagraphWithText("2385673785");
$wdoc->deleteParagraphWithText("4867349756");
$wdoc->deleteParagraphWithText("1238295689");
$wdoc->deleteParagraphWithText("5678543");
$wdoc->deleteParagraphWithText("8274623876");
$wdoc->deleteParagraphWithText("5294572945");
$wdoc->deleteParagraphWithText("7395636586");
$wdoc->deleteParagraphWithText("6927345634");
$wdoc->deleteParagraphWithText("6987587635");
$wdoc->tableDeleteTable($summarytbl);
$wdoc->tableDeleteTable($resulttbl);
$wdoc->deleteParagraph($img1);
$wdoc->deleteParagraph($img2);

//Phase Differences
$levelthreepara = $wdoc->findParagraphWhichIncludesText("2845638546");
$respondentrow = $wdoc->findNthElement("w:tr",3,$phasedifftbl);
$blankrow = $wdoc->findNthElement("w:tr",4,$phasedifftbl);
$lastrow = $wdoc->findNthElement("w:tr",5,$phasedifftbl);
$heading3 = $wdoc->findParagraphWhichIncludesText("2984723945");
$graphtext = $wdoc->findParagraphWhichIncludesText("8384238742");
$figurepara = $wdoc->findParagraphWhichIncludesText("3487563856");

//Blank row before table
$wdoc->insertParaClonedFromBefore($levelthreepara,$phasedifftbl,'','2845638546');




$resps = array();
$phases = $completeresults['phases'];
foreach($phases as $phase)
{
    $respondents = $phase['respondents'];
    foreach ($respondents as $respondent)
    {
        if (!isset($resps[$respondent['id']]))
        {
            $repdetails = array();
            $repdetails['short_name'] = $respondent['short_name'];
            $repdetails['long_name'] = $respondent['long_name'];
            $repdetails['phases'] = array();
            $resps[$respondent['id']] = $repdetails;
        }
        $sections = $respondent['sections'];
        foreach ($sections as $section)
        {
            if (!isset($resps[$respondent['id']] ['phases'] [$phase['id']]))
            {
                $resps[$respondent['id']] ['phases'] [$phase['id']] = array();
                $resps[$respondent['id']] ['phases'] [$phase['id']] ['order'] = $phase['order'];
                $resps[$respondent['id']] ['phases'] [$phase['id']] ['total'] = $section['total'];
            }
            else
            {
                $resps[$respondent['id']] ['phases'] [$phase['id']] ['total']  = $resps[$respondent['id']] ['phases'] [$phase['id']] ['total']  + $section['total'];
            }
        }
    }
}
$newrow = $blankrow->cloneNode(true);
$phasedifftbl->appendChild($newrow);

foreach($resps as $rep)
{
    $newrow = $respondentrow->cloneNode(true);
    $wdoc->updateRowColumnText($newrow,1,stripslashes($rep['long_name']));

    $phases = $rep['phases'];

    $b1 = false;
    $min = 0.0;
    $max = 0.0;
    $minorder = 0;
    $first = 0.0;
    $last = 0.0;
    $maxorder = 0;
    foreach($phases as $phase)
    {
        if (!$b1)
        {
            $min = $phase['total'];
            $max = $phase['total'];
            $first = $phase['total'];
            $last = $phase['total'];
            $minorder = $phase['order'];
            $maxorder = $phase['order'];
            $b1 = true;
        }
        else
        {
            if ($phase['total'] < $min)
                $min = $phase['total'];
            if ($phase['total'] > $max)
                $max = $phase['total'];
            if ($phase['order'] < $minorder)
            {
                $minorder = $phase['order'];
                $first = $phase['total'];
            }
            if ($phase['order'] > $maxorder)
            {
                $maxorder = $phase['order'];
                $last = $phase['total'];
            }
        }
    }


    $strnum = sprintf("%3.1f%%",(($last / $first) - 1.0) * 100.0);
    $wdoc->updateRowColumnText($newrow,2,$strnum);
    $strnum = sprintf("%3.1f%%",(($max / $min) - 1.0) * 100.0);
    $wdoc->updateRowColumnText($newrow,3,$strnum);

    $phasedifftbl->appendChild($newrow);
}

$newrow = $lastrow->cloneNode(true);
$phasedifftbl->appendChild($newrow);

$wdoc->tableDeleteRow($phasedifftbl,2);
$wdoc->tableDeleteRow($phasedifftbl,2);
$wdoc->tableDeleteRow($phasedifftbl,2);
$wdoc->tableDeleteRow($phasedifftbl,2);


$wdoc->insertParaClonedFromBefore($levelthreepara,$levelthreepara,'','2845638546');

//Build section for each responsdent
foreach($resps as $rid => $rep)
{
    $wdoc->insertParaClonedFromBefore($heading3,$heading3,stripslashes($rep['long_name']),'2984723945');
    //Blank row
    $wdoc->insertParaClonedFromBefore($graphtext,$heading3,stripslashes($rep['long_name']),'8384238742');

    //Insert a new image
    if ($img3)
    {
        $strname = "/imgresp" . sprintf("%05d",intval($rid)) . ".png";
        if ($graphdata = file_get_contents($graphsdir . $strname))
        {
            //Duplicate Image
            $newimg = $wdoc->duplicateImage(5);
            $wdoc->insertParagraphBefore($newimg,$heading3);
            $maximage = $wdoc->findMaxImageNumber();
            $imgname = $wdoc->getImageParaFileName($maximage);
            $stripname = basename($imgname);
            $wdoc->replaceImage(basename($imgname),$graphdata);
        }
        else
            error_log(__FILE__ . "[".__LINE__."] No image found {$strname}");
        $wdoc->insertParaClonedFromBefore($figurepara,$heading3," ",'3487563856');
    }
}

$wdoc->deleteParagraphWithText("2845638546");
$wdoc->deleteParagraphWithText("8384238742");
$wdoc->deleteParagraphWithText("3487563856");
$wdoc->deleteParagraphWithText("2984723945");
$wdoc->deleteParagraph($img3);


$wdoc->SaveAs($reportTitle);
$myfile = fopen($reportTitle, "r");
header("Content-Type: application/vnd.openxmlformats-officedocument.wordprocessingml.document");
echo fread($myfile,filesize($reportTitle));
fclose($myfile);
unset($_SESSION['ReportProgess']);
?>