<?php
session_start();
require './includes/classEvalSecure.php';
require './includes/classEvaluateDB.php';
require './includes/classFormList.php';
require './includes/classEvalHelpers.php';
require './includes/classSiem.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
$SIEM = new devt\siem\siem($devt_environment->getkey("SIEMHOST"));

$FL = new FormList(null);
$helpers = new helpers();

$selff = htmlspecialchars($_SERVER["PHP_SELF"]);
$instancename = $devt_environment->getkey("DATABASE_NAME");

$_SESSION['returnto'] = $selff;

$global = $DB->getGlobal();
ESecure::CheckPage(SECURITY_ADMIN);
$user = $DB->getUser($_SESSION['userid']);
ESecure::CheckUser($user);

/*
    Parameters:

*/

$report_parameters = [
    'configuration' =>
        [
            'select' => 'configreport',
            'reporter' => "Reporter4.docx",
            'parameters' => [
                'eval' => null
            ]
        ],
    'phase' =>
        [
            'select' => 'phasereport',
            'reporter' => "Reporter3.docx",
            'parameters' => [
                'eval' => null,
                'phase' => null
            ]
        ],
    'team' =>
        [
            'select' => 'teamreport',
            'reporter' => "Reporter5.docx",
            'parameters' => [
                'eval' => null,
                'phase' => null,
                'team' => null
            ]
        ],
    'moderation' =>
        [
            'select' => 'modreport',
            'reporter' => "Reporter5.docx",
            'javaexport' => 'modreportjavaexport',
            'parameters' => [
                'eval' => null,
                'phase' => null,
                'team' => null
            ],
            'graphs' => [
                'data' => null,
                'divid' => 'charts',
                'goto' => '',
                'scripts' => [
                    'start' => 'generatebars',  //graphs.scripts.start
                    'post' => 'callreport'
                ],
                'postdataaction' => 'callreport',
            ]
        ]

];

function getReportByPostInput($t)
{
    global $report_parameters;
    foreach($report_parameters as $name => $v )
    {
        if ($v['select'] == $t)
            return $report_parameters[$name];
    }
}

function updateReportParameter(&$report,$key,$v)
{
    if ($report && isset($report['parameters']) )
        $report['parameters'] [$key] = $v;
}

$totNumEvals = $DB->numOfEvaluations();
if ((isset($_SESSION['current_evaluation']) && $_SESSION['current_evaluation'] != 0) || $totNumEvals == 1)
{
    $eval = null;
    if (isset($_SESSION['current_evaluation']) && $_SESSION['current_evaluation'] != 0)
        $eval = $DB->getEvaluation($_SESSION['current_evaluation']);
    else
        $eval = $DB->getFirstEvaluation();
    if ($eval)
    {
        $_SESSION['current_evaluation'] = $eval['idevaluation'];
    }
}


function var_error_log( $object=null ,$text='')
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( "{$text} {$contents}" );        // log contents of the result of var_dump( $object )
}

function deleteFilesFromDirectory($dir)
{
    $files = glob("{$dir}/*"); // get all file names
    foreach($files as $file)
    {
        if(is_file($file))
            unlink($file);
    }
}


function localgraphdate($strdate)
{
    global $user;

    $dt = new DateTime($strdate);
    $dt->setTimezone(new DateTimeZone($user['user_timezone']));
    return $dt->format('Y,m,d');
}

function checkEvaluation($evalid)
{
    global $DB;
    global $strErr;
    global $finalphase;

    if (!$finalphase = $DB->getFinalPhase($evalid) )
    {
        $strErr = "Unable to generate report - cannot find a final phase for this evaluation";
        return false;
    }

    if ($finalphase['phase_status'] != "complete")
    {
        $strErr = "Unable to generate report - cannot complete report, final phase hasn't be marked as completed";
        return false;
    }
    return true;
}

function allPhasesComplete($evalid)
{
    global $DB;
    global $strErr;
    $allComplete = true;
    $r = $DB->allPhasesForEval($evalid);
    while ($phase = $r->fetch_array(MYSQLI_ASSOC))
    {
        if ($phase['phase_status'] != "complete")
        {
            $strErr = "Unable to generate report - all phases must be completed before a final report can be generated.";
            return false;
        }
    }
    return true;
}

$evalid = 0;
$report = null;
$finalphase = null;
$doFinal = false;
$doModeration = false;
$doPhaseReport = false;
$doBiasReport = false;
$doConfigReport = false;
$doDebrief = false;
$report_phaseid = 0;
$reportparam = '';
$strErr = '';
$numCharts = 0;
$numPhases = 0;
$completeresults = null;
$barcolourrange = array();
$barcolourrange['orange'] = 0.2;
$barcolourrange['red'] = 0.4;
$graphsdir = $devt_environment->getkey("GRAPHS_DIR");

function modreportjavaexport($report)
{
    global $DB;
    global $evalid;
    global $reportparam;

    $phaseid = intval($report['parameters'] ['phase']);

    echo "<script>\n";

    $grpahObject = array();
    $r = $DB->allUsersForEval($evalid);
    while ($evaluator = $r->fetch_array(MYSQLI_ASSOC))
    {
        //Check if evaluator is assigned to this the report phase
        if ( $DB->userHasPhase($evaluator['iduser'],$phaseid) )
        {
            $r2 = $DB->allTeamsForUserForEval($evalid,$evaluator['iduser']);
            while ($team = $r2->fetch_array(MYSQLI_ASSOC))
            {
                $r3 = $DB->allQuestionsForTeam($team['idteam']);
                while ($question = $r3->fetch_array(MYSQLI_ASSOC))
                {
                    $numsubs = $DB->numOfSubsForQuestion($question['idquestion']);
                    if ($numsubs > 0)
                    {
                        $r5 = $DB->allSubForQuestion($question['idquestion'],"order by subattribute_number");
                        $sub = $r5->fetch_array();
                    }
                    else
                    {
                        $sub = array();
                        $sub['subattribute_number'] = 0;
                    }

                    while ($sub)
                    {
                        $r4 = $DB->allRespondentsForEval($evalid,"order by respondent_name_full");
                        while ($respondent = $r4->fetch_array())
                        {
                            $matrix = array();
                            $asubid = 0;
                            if ($sub['subattribute_number'] == 0)
                            {
                                $matrix = $DB->getScoreAndRange($evalid,$evaluator['iduser'],$phaseid,$respondent['idrespondent'],$question['idquestion'],null);
                            }
                            else
                            {
                                $matrix = $DB->getScoreAndRange($evalid,$evaluator['iduser'],$phaseid,$respondent['idrespondent'],$question['idquestion'],$sub['idsubattribute']);
                                $asubid = $sub['subattribute_number'];
                            }

                            $index = sprintf("%04d%04d%04d%04d",$evaluator['iduser'],$respondent['idrespondent'],$question['idquestion'],$asubid);
                            $grpahObject[$index] = $matrix;
                        }


                        if ($numsubs > 0)
                            $sub = $r5->fetch_array();
                        else
                            $sub = null;
                    }
                }
            }
        }
    }

    $b1 = false;
    $cntBars = 0;
    echo "var g_ModData = [";
    foreach($grpahObject as $idx => $m)
    {
        $min = 0;
        $max = 0;
        $userscore = 0;
        if (isset($m['min']) )
        {
            $min = intval($m['min']);
        }

        if (isset($m['max']) )
        {
            $max = intval($m['max']);
        }

        if (isset($m['userscore']) )
        {
            $userscore = intval($m['userscore']);
        }

        if ($b1)
            echo ",";
        echo "{'{$idx}': {min: {$min},max: {$max},u: {$userscore}}}";
        $b1 = true;
        $cntBars++;
    }
    echo "];\n";

    echo "var g_numCharts = {$cntBars};\n";
    echo "if (g_report) g_report.graphs.goto = 'Reporter2.docx?v={$reportparam}';\n";

    echo "</script>\n";
}


if ($_SERVER['REQUEST_METHOD'] == 'POST')
{
    if (!Secure::checkCSRF())
    {
        $SIEM->createSecurityEntry("csrf",SECUITY_INVALID_CSRF,"minor",getenv("VAULT_SHELF"),"Invalid CSRF in Report Manager");
        $DB->createSecurityAudit($user,"ReportManager.php [".__LINE__."] Failed CSRF check");
        header("Location: SecurityError.php");
        exit();
    }



    if (isset($_POST['ChangeEval']))
    {
        $_SESSION['current_evaluation'] = 0;
        header("Location: {$selff}");
        exit();
    }

    if (isset($_POST['ChooseEval']))
    {
        $a = $FL->decryptParamRaw($_POST['evalid']);
        if (isset($a['eval']))
            $evalid = intval($a['eval']);
        $_SESSION['current_evaluation'] = $evalid;
        header("Location: {$selff}");
        exit();
    }

    //Remove all the graph files
    deleteFilesFromDirectory($graphsdir);


    $evaluation = $DB->getEvaluation($_SESSION['current_evaluation']);
    $evalid = $evaluation['idevaluation'];
    if ($evaluation)
    {
        $report = null;
        if (isset($_POST['reportname']))
        {
            $report = getReportByPostInput($_POST['reportname']);
            updateReportParameter($report,"eval",$evalid);
            if (isset($_POST['whatphase']))
            {
                $a = $FL->decryptParamRaw($_POST['whatphase']);
                if (isset($a['phase']))
                {
                    $phaseid = $a['phase'];
                    updateReportParameter($report,"phase",$phaseid);
                }
                if (isset($a['eval']))
                {
                    $evalid = $a['eval'];
                    updateReportParameter($report,"eval",$evalid);
                }
            }

            if (isset($_POST['whatteam']))
            {
                $a = $FL->decryptParamRaw($_POST['whatteam']);
                if (isset($a['eval']))
                {
                    $evalid = $a['eval'];
                    updateReportParameter($report,"eval",$evalid);
                }
                if(isset($a['team']))
                {
                    $teamid = $a['team'];
                    updateReportParameter($report,"team",$teamid);
                }
            }

            if ($report)
            {
                if (isset($report['graphs']) && $report['graphs'])
                {

                }
                else
                {
                    //We can go direct to the reporter
                    $strParam = '';
                    foreach ($report['parameters'] as $key => $value)
                    {
                        if (strlen($strParam) > 0)
                            $strParam .= ",";
                        $strParam .= "{$key}={$value}" ;
                    }
                    error_log("strparam = {$strParam}");
                    var_error_log($report,"report");

                    $reportparam = urlencode($FL->encryptParam($strParam));
                    header("Location: {$report['reporter']}?v={$reportparam}");
                    exit();
                }

            }
        }




        if (isset($_POST['progressreport']))
        {
            $v = urlencode($FL->encryptParam("eval={$evaluation['idevaluation']}"));
            header("Location: Reporter7.docx?v={$v}");
            exit();
        }

        if (isset($_POST['debrief']))
        {
            //Is the last phase comoplete
            $lastphase = $DB->getLastPhaseForEval($evalid);
            if ($lastphase['phase_status'] == 'complete' && $lastphase['phase_single_score'])
            {
                $v = urlencode($FL->encryptParam("eval={$evaluation['idevaluation']},phaseid={$lastphase['idphase']}"));
                $reportparam = urlencode($FL->encryptParam("eval={$evaluation['idevaluation']},phaseid={$lastphase['idphase']}"));
                $report_phaseid = $lastphase['idphase'];
                $doDebrief = true;
            }
            else
            {
                if ($lastphase['phase_status'] != 'complete')
                    $strErr = "Unable to generate report - the evaluation does not appear to be complete, last phase has not yet completed.";
                else
                if (!$lastphase['phase_single_score'])
                    $strErr = "Unable to generate report - the last phase of the evaluation is not marked as a single score phase.";
            }
        }

        if (isset($_POST['final']))
        {

            $anon = 0;
            if(FormList::getCheckBoxField($_POST['anaoymise']) )
               $anon=1;
            //Perform checks
            if (checkEvaluation($evalid))
            {
                if (allPhasesComplete($evalid))
                {
                    $completeresults = $DB->completeResults($evalid);
                    $resultmatrix = array();

                    $results = $helpers->phaseResults($evalid,$finalphase['idphase']);
                    if ($results['status'])
                    {
                        $questions = $results['questions'];
                        foreach($questions as $qu)
                        {
                            foreach ($qu['respondent'] as $resp)
                            {
                                $respid = intval($resp['id']);
                                if (!isset($resultmatrix[$resp['name']]))
                                {
                                    $resultmatrix[$resp['name']] = floatval($resp['score']);
                                }
                                else
                                    $resultmatrix[$resp['name']] = $resultmatrix[$resp['name']]  + floatval($resp['score']);
                            }
                        }
                        arsort($resultmatrix);
                        $doFinal = true;
                    }
                    else
                        $strErr = "Unable to generate report - the evaluation does not appear to be complete, there are missing scores.";
                }
            }
            $reportparam = urlencode($FL->encryptParam("eval={$evaluation['idevaluation']},anon={$anon}"));
        }

        if (isset($_POST['modreport']))
        {

            if (isset($_POST['whatphase']))
            {
                $teamid = 0;
                $a = $FL->decryptParamRaw($_POST['whatphase']);
                $phaseid = $a['phase'];
                if (isset($_POST['whatteam']))
                {
                    $a = $FL->decryptParamRaw($_POST['whatteam']);
                    $teamid = $a['team'];
                }
                $allComments = 0;
                if (isset($_POST['includeallevals']))
                    $allComments = 1;

                $reportparam = urlencode($FL->encryptParam("eval={$evaluation['idevaluation']},phaseid={$phaseid},teamid={$teamid},allcomments={$allComments}"));
                //Get the colours
                if (isset($_POST['orange']))
                    $barcolourrange['orange'] = FormList::getPercentageField("orange");
                if (isset($_POST['red']))
                    $barcolourrange['red'] = FormList::getPercentageField("red");
                $doModeration = true;
            }
        }

        if (isset($_POST['biasreport']))
        {
            $doBiasReport = true;
            $a = $FL->decryptParamRaw($_POST['whatphase']);
            $report_phaseid = intval($a['phase']);
            $reportparam=urlencode($FL->encryptParam("eval={$evaluation['idevaluation']},phase={$report_phaseid}"));
        }

    }
    else

        $strErr = "Invalid Evaluation set";
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta name="viewport" content="width=device-width" />
<meta name="viewport" content="initial-scale=1.0" />
<title>REPORT MANAGER</title>
<link id="myicon" rel="icon" type="image/png" href="images/Icon1.png" />
<link href="css/Base.css" rel="stylesheet" />
<style>
#container {margin: auto; max-width: 1300px;}
#main h1 {font-family: 'Roboto Slab'; color: #666; font-size: 14pt;}
#form div.reportbox {margin:16px; padding: 8px; border: solid 1px #888;}
#form h2.rptbox {font-family: 'Roboto Slab';color: #5e629d; font-size: 12pt;}
#messagearea {border: solid 1px #888;margin: 16px;padding: 8px;background-color: #f7f7d7;}
#teamreport p {margin-bottom: 0;}
#FinReport1 h3 {font-family: 'Roboto Slab';color: #666;font-size: 10pt;}
#finoptions1 {margin:16px; padding: 8px; border: solid 1px #888;}
#ModReport1 h3 {font-family: 'Roboto Slab';color: #666;font-size: 10pt;}
#modoptions1 {margin:16px; padding: 8px; border: solid 1px #888;}

p.fmhd {margin-bottom: 0;font-size: 9pt; color: #444;}
p.cmsoon {color: #70a5ec; font-size: 14pt;}
p.inpt {margin-bottom: 0;}
input[type='checkbox'] {width: 18px; height: 18px;}
input[type='submit'] {margin-top: 18px;}
#inprogress {margin: 30px;border: solid 1px #888;border-radius: 8px;background-color: #f8f8f8;padding: 10px;box-shadow: 8px 8px 8px #888;display: none;}
#rangebands {border: solid 1px #888;margin: 10px;padding: 10px;}
#ModReport1 option:disabled {color: #e78181}
.err {color: red;}
</style>
    <script type="text/javascript" src="apievaljsonv1.php?r=/<?php echo $user['user_apikey'];?>/devtscript/<?php echo $instancename;?>/devtcore&formtoken=<?php echo urlencode($_SESSION['csrf_key']);?>"></script>
    <script type="text/javascript" src="apievaljsonv1.php?r=/<?php echo $user['user_apikey'];?>/devtscript/<?php echo $instancename;?>/eval&formtoken=<?php echo urlencode($_SESSION['csrf_key']);?>"></script>
    <script type="text/javascript" src="apievaljsonv1.php?r=/<?php echo $user['user_apikey'];?>/devtscript/<?php echo $instancename;?>/reports&formtoken=<?php echo urlencode($_SESSION['csrf_key']);?>"></script>
    <script type='text/javascript' src='https://www.gstatic.com/charts/loader.js'></script>
    <script>
                                                                    <?php
    if (isset($_SESSION['current_evaluation']) && $_SESSION['current_evaluation'] != 0)
        echo "var g_currentEval = {$_SESSION['current_evaluation']};\n";
    else
        echo "var g_currentEval = 0;\n";
    echo "var g_formtoken = '{$_SESSION['csrf_key']}';\n";
    echo "var g_formtoken_encoded = '".urlencode($_SESSION['csrf_key'])."';\n";
    if (isset($_SESSION['ReportProgess']) && $_SESSION['ReportProgess'] == "set")
    {
        echo "var g_inProgress =  false;\n";
    }
    else
        echo "var g_inProgress =  false;\n";

    echo "var g_Host = '{$_SERVER['HTTP_HOST']}';\n";
    echo "var g_Api = '{$user['user_apikey']}';\n";
    echo "var g_barOrangeOffset = {$barcolourrange['orange']};";
    echo "var g_barRedOffset = {$barcolourrange['red']};";

    if ($report)
    {
        $strReport = json_encode($report);
        echo "var g_report = JSON.parse('{$strReport}');\n";
    }
    else
        echo "var g_report = null;\n";

                                                                    ?>
    var doGraphs1 = false;
    var doGraphs3 = false;
    var doGraphs6 = false;
    var doGraphs7 = false;
    var g_charts = [];
    var g_nextId = 0;
    var apireplies = { 'submitchart': 'chartsubmitted' };

    eval.init(g_Host,'apievaljsonv1.php?r=' + g_Api,true,apireplies);

    function chartsubmitted(d) {
        console.log("return from chart submitted id " + d.id);

        if (g_report) {
            if (devt.def(g_report.graphs) ) {
                if (devt.def(g_report.graphs.scripts.post) ) {
                    nreports[g_report.graphs.scripts.post] (g_report);
                }
            }
        }
        if (doGraphs1 || doGraphs7) {
            g_charts[d.id].returned = true;
            //Remove from
            var n = devt.ge("_chart" + d.id);
            if (n)
                n.parentElement.removeChild(n);
            //Check all have been returned
            var allComplete = true;
            for (var j = 0; j < g_charts.length; j++) {
                if (!g_charts[j].returned)
                    allComplete = false;
            }
            if (allComplete) {
                console.log("All complete");
                window.location = g_goto;
            }
        }
        if (doGraphs3) {
            console.log("All complete");
            window.location = g_goto;
        }
        if (doGraphs6) {
            g_charts[d.id].returned = true;
                    var allComplete = true;
            for (var j = 0; j < g_charts.length; j++) {
                if (!g_charts[j].returned)
                    allComplete = false;
            }
            if (allComplete) {
                devt.removeAllChildren(devt.ge("allcharts"));
                console.log("All complete");
                window.location = g_goto;
            }
        }
    }
    </script>

    <?php
    /*
     * Build the specific javascript data and variables for the specific report
     *
    */
    echo "<!-- Start of dynamic script for report -->\n";
    if ($report && isset($report['javaexport']) )
        $report['javaexport']($report);
    echo "<!-- End of dynamic script for report -->\n";
    ?>



    <script>
        <?php
        $b1 = false;
        echo "\nvar g_phaseTeamComplete = {";
        $r = $DB->allPhasesForEval($_SESSION['current_evaluation']);
        while ($phase = $r->fetch_array(MYSQLI_ASSOC))
        {
            $data = $DB->getProgress($_SESSION['current_evaluation'],$phase['idphase']);
            if ($b1)
                echo ",";
            $b1 = true;
            echo "{$phase['idphase']}:{";
            $b2 = false;
            $r2 = $DB->allTeamsForEval($_SESSION['current_evaluation']);
            while ($team = $r2->fetch_array(MYSQLI_ASSOC))
            {
                $valid = 0;
                if ($b2)
                    echo ",";
                $b2 = true;
                $teams = $data['teams'];
                foreach($teams as $tm)
                {
                    if (intval($tm['id']) == $team['idteam'])
                    {
                        if (intval($tm['evaluators']) > 0)
                        {
                            if ($tm['totals'] ['totscores'] > 0)
                            {
                                if ($tm['totals'] ['totanswered'] == $tm['totals'] ['totscores'])
                                    $valid = 1;
                            }
                        }

                    }
                }

                echo "{$team['idteam']}:{$valid}";
            }
            echo "}";
        }
        echo "};\n";
        ?>
    </script>
    <script>
        <?php
    if ($doFinal)
    {
        echo "var g_finalScore = [['RESPONDENT','SCORE',{ role: 'style' }, { role: 'annotation' }]";
        $cnt = 0;
        foreach($resultmatrix as $key => $val)
        {
            $anotation = sprintf("%3.1f",$val);
            $c = '#e5e4e2';
            switch ($cnt)
            {
                case 0:
                    $c = 'gold';
                    break;
                case 1:
                    $c = 'silver';
                    break;
                case 2:
                    $c = '#b87333';
                    break;
                default:
                    $c = '#c8bfe7';
                    break;
            }
            echo ",['{$key}',{$val},'{$c}','{$anotation}']";
            $cnt++;
        }
        echo "];\n";

        echo "var g_timeline = [";

        $bdone1 = false;
        $r = $DB->allPhasesForEval($evalid,'order by phase_order');
        while ($phase = $r->fetch_array(MYSQLI_ASSOC))
        {
            if ($phase['phase_status'] == 'enabled' || $phase['phase_status'] == 'complete')
            {
                $dtnow = new DateTime('now');
                if ($phase['phase_start_timestamp'])
                    $d1 = localgraphdate($phase['phase_start_timestamp']);
                if ($phase['phase_complete_timestamp'])
                    $d2 = localgraphdate($phase['phase_complete_timestamp']);
                else
                {
                    $d2 = localgraphdate($dtnow->format('Y-m-d H:i:s'));
                }
                if ($bdone1)
                    echo ",";
                echo "['{$phase['phase_name']}',new Date({$d1}),new Date({$d2})]";
                $bdone1 = true;
            }
        }
        echo "];\n";


        //For each evaluator look at the timeline for answering question
        //evaluator['ideval'] ['phase'] ['question'] ['sub'] ['respondent'] ['firstaudit time']
        $evaluatormatrix = array();
        $r = $DB->allTeamsForEval($evalid);
        while ($team = $r->fetch_array(MYSQLI_ASSOC))
        {
            $r2 = $DB->allUsersForTeam($team['idteam']);
            while ($evaluser = $r2->fetch_array(MYSQLI_ASSOC))
            {
                if (!isset($evaluatormatrix[$evaluser['iduser']]))
                {
                    $eval1 = array();
                    $r3 = $DB->phasesForUserForEval($evalid,$evaluser['iduser']);
                    while ($phase = $r3->fetch_array(MYSQLI_ASSOC))
                    {
                        $phasecnt = 0;
                        $p1 = array();
                        $r4 = $DB->allQuestionsForTeam($team['idteam']);
                        while ($quest = $r4->fetch_array(MYSQLI_ASSOC))
                        {
                            $q1 = array();
                            $r5 = $DB->allSubForQuestion($quest['idquestion']);
                            if ($r5->num_rows > 0)
                            {
                                $s1 = array();
                                while ($sub = $r5->fetch_array())
                                {
                                    $respdnt = array();
                                    $r6 = $DB->allRespondentsForEval($evalid);
                                    while ($rdnt = $r6->fetch_array())
                                    {
                                        $audit = $DB->getFirstScoreAudit($evalid,$evaluser['iduser'],$phase['idphase'],$quest['idquestion'],$sub['idsubattribute'],$rdnt['idrespondent']);
                                        if ($audit)
                                            $respdnt['timestamp'] = $audit['audit_timestamp'];
                                        else
                                            $respdnt['timestamp'] = 0;
                                        $phasecnt++;
                                        $s1[$rdnt['idrespondent']] = $respdnt;
                                    }
                                    $q1[$sub['idsubattribute']] = $s1;
                                }
                            }
                            else
                            {
                                $s1 = array();
                                $respdnt = array();
                                $r6 = $DB->allRespondentsForEval($evalid);
                                while ($rdnt = $r6->fetch_array())
                                {
                                    $audit = $DB->getFirstScoreAudit($evalid,$evaluser['iduser'],$phase['idphase'],$quest['idquestion'],0,$rdnt['idrespondent']);
                                    if ($audit)
                                        $respdnt['timestamp'] = $audit['audit_timestamp'];
                                    else
                                        $respdnt['timestamp'] = 0;
                                    $phasecnt++;
                                    $s1[$rdnt['idrespondent']] = $respdnt;
                                }
                                $q1[0] = $s1;
                            }

                            $p1[$quest['idquestion']] = $q1;
                        }
                        $eval1[$phase['idphase']] ['times']= $p1;
                        $eval1[$phase['idphase']] ['count']= $phasecnt;
                    }
                    $evaluatormatrix[$evaluser['iduser']] = $eval1;
                }
            }
        }

        //Exatct all the time stamps for each user and each phase
        $alltimes = array();
        foreach ($evaluatormatrix as $uid => $v)
        {
            $usera = array();
            foreach($v as $phaseid => $v1)
            {
                $atimes = array();
                foreach($v1['times'] as $qid => $v2)
                {
                    foreach ($v2 as $subid => $v3)
                    {
                        foreach ($v3 as $respid => $v4)
                        {
                            foreach($v4 as $tm)
                            {
                                array_push($atimes,$tm);
                            }
                        }
                    }
                }
                asort($atimes);
                $usera[$phaseid] = $atimes;
            }
            $alltimes[$uid] = $usera;
        }

        //[$user] [$phase] [x_values] [%percentas]

        //var g_ScoreTimes {uid: {phaseid: [[time,%],[time,%]],phaseid: [[time,%],[time,%]] },   uid: {phaseid: [[time,%],[time,%]],phaseid: [[time,%],[time,%]] }   }
        $bU1 = false;
        $bP1 = false;

        echo "var g_ScoreTimes = {";
        foreach($alltimes as $uid => $ph)
        {
            if ($bU1)
                echo ",";
            $bU1 = true;
            $bP1 = false;
            echo "{$uid}:{";
            foreach($ph as $phid => $tmsd)
            {
                if ($bP1)
                    echo ",";
                $bP1 = true;
                $bt1 = false;
                $cnt = $evaluatormatrix[$uid] [$phid] ['count'];
                if ($cnt > 0)
                {
                    $tcnt = 0;
                    echo "{$phid}:[";
                    foreach($tmsd as $tm)
                    {
                        if ($tm != 0)
                        {
                            if($bt1)
                                echo ",";
                            $bt1 = true;
                            $tcnt++;
                            $v = floatval($tcnt)/floatval($cnt);
                            echo "[";
                            $nt = new DateTime($tm);
                            $nt->setTimezone(new DateTimeZone($user['user_timezone']));
                            $dete = $nt->format('Y') . "," . strval(intval($nt->format('m')) -1) . "," . $nt->format('d') . "," . $nt->format('H') ."," . $nt->format('i') . "," . $nt->format('s');
                            $strt = "new Date({$dete})";
                            echo "{$strt},{$v}";
                            echo "]";
                        }
                    }
                    echo "]";
                }
            }
            echo "}";
        }
        echo "};\n";

        $bP1 = false;
        $graphcnt = 0;
        echo "var g_graphs = [";
        foreach($alltimes as $uid => $ph)
        {
            foreach($ph as $phid => $fred)
            {
                $uname = '';
                $pname = '';
                if ($bP1)
                    echo ",";
                $guser = $DB->getUser($uid);
                if ($guser)
                    $uname = $guser['user_name'];
                $phase = $DB->getPhase($phid);
                if ($phase)
                    $pname = $phase['phase_name'];

                echo "{username: '{$uname}',uid: {$uid}, phaseid: {$phid}, phasename: '{$pname}'}";
                $bP1 = true;
                $graphcnt++;
            }
        }
        echo "];\n";

        //All the phases
        $numPhases = 0;
        $phases = $completeresults['phases'];
        echo "var g_Phases = [";
        $b1 = false;
        foreach ($phases as $phase)
        {
            if ($b1)
                echo ",";
            echo "{id:{$phase['id']},name: '{$phase['name']}'}";
            $b1 = true;
            $numPhases++;
        }
        echo "];\n";

        $bp1 = false;
        echo "var g_phaseresults = [";
        foreach ($phases as $phase)
        {
            $respondents = $phase['respondents'];

            if ($bp1)
                echo ",";
            $bp1 = true;
            echo "[";
                //headings
                echo "['RESPONDENT',";
                $bs1 = false;
                $sections = $respondents [0] ['sections'];
                foreach ($sections as $sect)
                {
                    if ($bs1)
                        echo ",";
                    $bs1 = true;
                    echo "'{$sect['name']}'";
                }
                echo "],";


                //heading section scores
                $br1 = false;
                foreach($respondents as $resp)
                {
                    $sections = $resp['sections'];
                    if ($br1)
                        echo ",";
                    $br1 = true;
                    echo "['{$resp['short_name']}',";
                    $bs1 = false;
                    foreach($sections as $sect)
                    {
                        if ($bs1)
                            echo ",";
                        $bs1 = true;
                        echo $sect['total'];
                    }
                    echo "]";
                }
            echo "]";
        }
        echo "];\n";

        $phases = $completeresults['phases'];
        $respondentPhase = array();

        foreach ($phases as $phase)
        {
            $respondents = $phase['respondents'];
            foreach($respondents as $resp)
            {
                if(!isset($respondentPhase[$resp['id']]))
                {
                    $respdata = array();
                    $respdata['id'] = $resp['id'];
                    $respdata['short_name'] = $resp['short_name'];
                    $respdata['long_name'] = $resp['long_name'];
                    $respdata['phases'] = array();
                    $respondentPhase[$resp['id']] = $respdata;
                }
                $sections = $resp['sections'];
                $tot = 0.0;
                foreach($sections as $sect)
                {
                    $tot += $sect['total'];
                }
                $aphase = array();
                $aphase['name'] = $phase['name'];
                $aphase['total'] = $tot;
                array_push($respondentPhase[$resp['id']] ['phases'],$aphase);
            }
        }

        $numRespondents = $DB->numOfRespondents($evalid);
        $br1 = false;
        echo "var g_repsonphase = [";
        foreach ($respondentPhase as $rp)
        {
            if ($br1)
                echo ",";
            echo "{";
            echo "id: {$rp['id']},short_name:'{$rp['short_name']}',long_name: '{$rp['long_name']}',";
            echo "data:[";
            echo "['PHASE','SCORE',{ role: 'style' },{ role: 'annotation' }],";
            $br1 = true;
            $bp1 = false;
            foreach($rp['phases'] as $ph)
            {
                if($bp1)
                    echo ",";
                $bp1 = true;
                $anotation = sprintf("%3.1f",$ph['total']);
                echo "['{$ph['name']}',{$ph['total']},'color: gold;opacity: 0.4','{$anotation}']";
            }
            echo "]";
            echo "}";
        }
        echo "];\n";

        $numCharts = 1 + $graphcnt + $numPhases  + $numRespondents;
        echo "doGraphs1 = true;";
        echo "var g_numCharts = {$numCharts};";
        echo "var g_goto = 'Reporter1.docx?v={$reportparam}';";
    }

    if ($doBiasReport)
    {
        $teambias = array();
        $r = $DB->allTeamsForEval($evalid);
        while ($team = $r->fetch_array(MYSQLI_ASSOC))
        {
            if ($DB->numUsersForTeamForPhase($team['idteam'],$report_phaseid) > 0)
            {
                $rslt = $DB->evaluatorBias($evalid,$report_phaseid,$team['idteam']);
                if ($rslt['status'])
                {
                    $teambias[$team['idteam']] = array();
                    $teambias[$team['idteam']] ['name'] = $team['team_name'];
                    $teambias[$team['idteam']] ['data'] = $rslt['data'];
                }
            }
        }
        $cntGraphs = 0;
        echo "\nvar g_biasData =[";
        foreach($teambias as $tid => $bias)
        {
            foreach ($bias['data'] as $e)
            {
                $cntGraphs++;
                echo "{";
                echo "teamid: {$tid},";
                echo "evalid: {$e['id']},";
                echo "evalname: '{$e['name']}',";
                echo "data: [";
                echo "['Respondent', 'Bias', { role: 'style' } ],";
                $b=false;
                foreach ($e['respondents'] as $resp )
                {
                    $strName = htmlspecialchars(stripslashes($resp['name']));
                    $strColor = "color: green";
                    if (abs($resp['bias']) > 0.2)
                        $strColor = "color: red";
                    elseif (abs($resp['bias']) > 0.1)
                        $strColor = "color: orange";
                    if ($b) echo ",";
                    echo "['{$strName}',{$resp['bias']},'{$strColor}']";
                    $b = true;
                }
                echo "]},";
            }
        }
        echo "];";
        echo "doGraphs6 = true;";
        echo "var g_numCharts = {$cntGraphs};";
        echo "var g_goto = 'Reporter6.docx?v={$reportparam}';";
    }

    if ($doPhaseReport)
    {
        echo "var g_goto = 'Reporter3.docx?v={$reportparam}';";
    }

    if ($doConfigReport)
    {
        echo "var g_goto = 'Reporter4.docx?v={$reportparam}';";
    }

    if ($doDebrief)
    {
        $numCharts = $DB->numOfRespondents($evalid);
        echo "var g_respondents = [";
        $doneone = false;
        $r = $DB->allRespondentsForEval($evalid,"order by idrespondent");
        while ($re = $r->fetch_assoc())
        {
            if ($doneone) echo ",";
            $doneone = true;
            echo $re['idrespondent'];
        }
        echo "];\n";

        $data = $DB->weightedSectionScoresForAll($evalid,$report_phaseid);
        $doneone = false;
        echo "var g_debirefdata = [";
        $r = $DB->allRespondentsForEval($evalid,"order by idrespondent");
        while ($re = $r->fetch_assoc())
        {
            if ($doneone) echo ",";
            echo "[";
                $strname = htmlspecialchars(stripslashes($re['respondent_name_full']));
                echo "['RESPONDENT','SCORE',{ role: 'style' }],";
                $strscore = sprintf("%3.1f",$data[$re['idrespondent']] ['total']);
                echo "['{$strname}',{$strscore},'#ff9700'],";

            $cnt = 1;
            foreach ($data as $respid => $respd)
            {
                if ($respid != $re['idrespondent'])
                {
                    $strscore = sprintf("%3.1f",$data[$respid] ['total']);
                    echo "['RESPONDENT {$cnt}',{$strscore},'#5e629d'],";
                    $cnt++;
                }
            }
            echo "]";
            $doneone = true;
        }
        echo "];";

        echo "doGraphs7 = true;\n";
        echo "var g_numCharts = {$numCharts};\n";
        echo "var g_goto = 'DebriefReport9.docx?v={$reportparam}';\n";
    }
        ?>
    </script>
    <script>
        function drawFinalResults(chartid) {
            var chart = {};
            chart.id = chartid;
            chart.returned = false;
            var data = google.visualization.arrayToDataTable(g_finalScore);
            var view = new google.visualization.DataView(data);
            var options = {
                title: "Final Scores",
                width: 1000,
                height: 800,
                bar: { groupWidth: "85%" },
                legend: { position: "none" },
                vAxis: { minValue: 0.0, maxValue: 100.0 },
                chartArea: { left: 100,top: 80, width: 800, height: 640},
            };

            
            chart.chart = new google.visualization.ColumnChart(document.getElementById("_chart" + chartid ));

            google.visualization.events.addListener(chart.chart, 'ready', function () {
                var imagedata = chart.chart.getImageURI();
                var p = {};
                var str = imagedata;
                p.mime = str.substr(0, str.search(";"));
                str = str.substr(str.search(";") + 1);
                p.encoding = str.substr(0, str.search(","));
                str = str.substr(str.search(",") + 1);
                p.data = str;
                p.chartid = chartid;
                p.chartname = 'finalresults';
                p.formtoken = g_formtoken;
                eval.submitchart(p);
            });

            chart.chart.draw(view, options);
            g_charts[chartid] = chart;
        }

        function drawPhaseTimeline(chartid) {
            var chart = {};
            chart.id = chartid;
            chart.returned = false;

            chart.chart = new google.visualization.Timeline(document.getElementById("_chart" + chartid));
            var dataTable = new google.visualization.DataTable();
            var options = {
                title: "Phase timeline",
                width: 750,
                height: 400
            };

            dataTable.addColumn({ type: 'string', id: 'Phase' });
            dataTable.addColumn({ type: 'date', id: 'Start' });
            dataTable.addColumn({ type: 'date', id: 'End' });

            dataTable.addRows(g_timeline);

            google.visualization.events.addListener(chart.chart, 'ready', function () {
                var imagedata = chart.chart.getImageURI();
                var p = {};
                var str = imagedata;
                p.mime = str.substr(0, str.search(";"));
                str = str.substr(str.search(";") + 1);
                p.encoding = str.substr(0, str.search(","));
                str = str.substr(str.search(",") + 1);
                p.data = str;
                p.chartid = 1;
                p.chartname = 'timeline';
                p.formtoken = g_formtoken;
                eval.submitchart(p);
            });

            chart.chart.draw(dataTable, options);
            g_charts[chartid] = chart;
        }

        function drawEvaluatorChart(chartid,what) {
            var chart = {};
            chart.id = chartid;
            chart.returned = false;

            var data = new google.visualization.DataTable();
            data.addColumn('date', 'Time');
            data.addColumn('number', 'Progress');

            data.addRows(g_ScoreTimes[parseInt(what.uid)][parseInt(what.phaseid)]);

            var options = {
                title: "Scoring Progess Timeline for " + what.username + " [Phase " + what.phasename + "]",
                width: 800,
                height: 600,
                pointSize: 4,
                legend: { position: 'none'}, 
                vAxis: { format: 'percent', minValue: 0, maxValue: 1},
                chartArea: { left: 100, top: 70, width: 600, height: 460 },
            };

            chart.chart = new google.visualization.LineChart(document.getElementById("_chart" + chartid));

            google.visualization.events.addListener(chart.chart, 'ready', function () {
                var imagedata = chart.chart.getImageURI();
                var p = {};
                var str = imagedata;
                p.mime = str.substr(0, str.search(";"));
                str = str.substr(str.search(";") + 1);
                p.encoding = str.substr(0, str.search(","));
                str = str.substr(str.search(",") + 1);
                p.data = str;
                p.chartid = chartid;
                p.chartname = 'userprogress';
                p.userid = what.uid;
                p.phaseid = what.phaseid;
                p.formtoken = g_formtoken;
                eval.submitchart(p);
            });


            chart.chart.draw(data, options);
            g_charts[chartid] = chart;

        }

        function drawPhaseChart(chartid,phasedata) {
            var chart = {};
            chart.id = chartid;
            chart.returned = false;

            var data = google.visualization.arrayToDataTable(phasedata['data']);

            var options = {
                title: "Phase " + phasedata['phasename'] + " Weighted Scores",
                width: 1000,
                height: 800,
                bar: { groupWidth: "85%" },
                legend: { position: "right" },
                vAxis: { minValue: 0.0 },
                chartArea: { left: 100, top: 80, width: 700, height: 640 },
            };


            chart.chart = new google.visualization.ColumnChart(document.getElementById("_chart" + chartid));

            google.visualization.events.addListener(chart.chart, 'ready', function () {
                var imagedata = chart.chart.getImageURI();
                var p = {};
                var str = imagedata;
                p.mime = str.substr(0, str.search(";"));
                str = str.substr(str.search(";") + 1);
                p.encoding = str.substr(0, str.search(","));
                str = str.substr(str.search(",") + 1);
                p.data = str;
                p.chartid = chartid;
                p.chartname = 'phaserslt';
                p.phaseid = phasedata['phaseid'];
                p.formtoken = g_formtoken;
                eval.submitchart(p);
            });

            chart.chart.draw(data, options);
            g_charts[chartid] = chart;

        }

        function drawReponderPhaseScores(chartid,respdata) {
            var chart = {};
            chart.id = chartid;
            chart.returned = false;

            var data = google.visualization.arrayToDataTable(respdata['data']);
            var options = {
                title: "Total phase scores for " + respdata['long_name'],
                width: 800,
                height: 600,
                bar: { groupWidth: "80%" },
                legend: { position: "none" },
                vAxis: { minValue: 0.0 },
                chartArea: { left: 100, top: 80, width: 600, height: 440 },
            };


            chart.chart = new google.visualization.ColumnChart(document.getElementById("_chart" + chartid));

            google.visualization.events.addListener(chart.chart, 'ready', function () {
                var imagedata = chart.chart.getImageURI();
                var p = {};
                var str = imagedata;
                p.mime = str.substr(0, str.search(";"));
                str = str.substr(str.search(";") + 1);
                p.encoding = str.substr(0, str.search(","));
                str = str.substr(str.search(",") + 1);
                p.data = str;
                p.chartid = chartid;
                p.chartname = 'respphase';
                p.respid = respdata['id'];
                p.formtoken = g_formtoken;
                eval.submitchart(p);
            });

            chart.chart.draw(data, options);
            g_charts[chartid] = chart;

        }

        function drawBiasCharts() {
            var cnt = 0;
            for (c = 0; c < g_biasData.length; c++) {
                 var chart = {};
                 chart.id = cnt;
                 chart.returned = false;

                var d = g_biasData[c].data;
                var name = g_biasData[c].evalname;
                var teamid = parseInt(g_biasData[c].teamid);
                var userid = parseInt(g_biasData[c].evalid);

                var p = document.getElementById("allcharts");
                var div = document.createElement('DIV');
                p.appendChild(div);

                var data = new google.visualization.arrayToDataTable(d);
                var options = {
                    backgroundColor: '#f8f8f8',
                    title: name,
                    titleTextStyle: { color: '#9e1780' },
                    chartArea: { left: 150 },
                    width: 700,
                    legend: { position: 'none' },
                    hAxis: { title: 'Bias', titleTextStyle: { color: '#000080' }, minValue: -0.5, maxValue: 0.5, format: 'percent', viewWindow: { min: -0.5, max: 0.5 }, baselineColor: '#808080' },
                    vAxis: { textStyle: { color: '#9e3d17' }, baselineColor: '#808080', gridlines: { color: '#c0c0c0' } },
                    bars: 'horizontal' // Required for Material Bar Charts.
                }

                chart.chart = new google.visualization.BarChart(div);

                google.visualization.events.addListener(chart.chart, 'ready', function () {
                    var imagedata = chart.chart.getImageURI();
                    var p = {};
                    var str = imagedata;
                    p.mime = str.substr(0, str.search(";"));
                    str = str.substr(str.search(";") + 1);
                    p.encoding = str.substr(0, str.search(","));
                    str = str.substr(str.search(",") + 1);
                    p.data = str;
                    p.chartid = cnt;
                    p.chartname = 'bias';
                    p.teamid = teamid;
                    p.userid = userid;
                    p.formtoken = g_formtoken;
                    eval.submitchart(p);
                });

                chart.chart.draw(data, options);
                g_charts[cnt] = chart;
                cnt++;
            }
        }

        function drawDebriefCharts() {
            var cnt = 0;
            for (c = 0; c < g_debirefdata.length; c++) {
                var chart = {};
                chart.id = cnt;
                chart.returned = false;

                var data = google.visualization.arrayToDataTable(g_debirefdata[cnt]);
                var view = new google.visualization.DataView(data);
                var options = {
                    title: "Final Scores Comparison",
                    width: 1000,
                    height: 800,
                    bar: { groupWidth: "65%" },
                    legend: { position: "none" },
                    vAxis: { minValue: 0.0, maxValue: 100.0 },
                    chartArea: { left: 100, top: 80, width: 800, height: 640 },
                };


                chart.chart = new google.visualization.ColumnChart(document.getElementById("_chart" + cnt));

                google.visualization.events.addListener(chart.chart, 'ready', function () {
                    var imagedata = chart.chart.getImageURI();
                    var p = {};
                    var str = imagedata;
                    p.mime = str.substr(0, str.search(";"));
                    str = str.substr(str.search(";") + 1);
                    p.encoding = str.substr(0, str.search(","));
                    str = str.substr(str.search(",") + 1);
                    p.data = str;
                    p.chartid = cnt;               
                    p.chartname = 'debriefchart';  
                    p.respondentid = g_respondents[cnt];
                    p.formtoken = g_formtoken;
                    eval.submitchart(p);
                });

                chart.chart.draw(view, options);
                g_charts[cnt] = chart;
                cnt++;
            }
        }

        function drawAll() {
            var chtcnt = 0;
            drawFinalResults(chtcnt);
            chtcnt++;

            for (var j = 0; j < g_graphs.length; j++) {
                drawEvaluatorChart(chtcnt, g_graphs[j]);
                chtcnt++;
            }

            for (var j = 0; j < g_phaseresults.length; j++) {
                var graphparams = {};
                graphparams['phaseid'] = g_Phases[j].id;
                graphparams['phasename'] = g_Phases[j].name;
                graphparams['data'] = g_phaseresults[j];
                drawPhaseChart(chtcnt, graphparams);
                chtcnt++;
            }

            for (var j = 0; j < g_repsonphase.length; j++) {
                drawReponderPhaseScores(chtcnt, g_repsonphase[j]);
                chtcnt++;
            }
        }

        function markInProgress() {
            devt.ge('main').style.display = 'none';
            devt.ge('inprogress').style.display = 'block';
        }

        function inProgress(n) {
            markInProgress();
        }


        function validTeams() {
            var p = devt.ge('dwhatphase');
            var o = devt.ge('dwhatteam');
            var phaseid = null;
            var teamid = null;
            var cval = 0;
            //Find selected
            var l = p.childNodes;
            for (var i = 0; i < l.length; i++) {
                if (l[i].nodeName == "OPTION" && l[i].selected) {
                    phaseid = parseInt(devt.ga(l[i], 'devtval'));
                    cval = parseInt(devt.ga(l[i], 'cval'));
                }
            }

            if (phaseid) {
                var l = o.childNodes;
                for (var i = l.length -1; i >= 0; i--) {
                    if (l[i].nodeName == "OPTION") {
                        teamid = parseInt(devt.ga(l[i], 'devtval'));
                        if (teamid == 0) {
                            if (cval == 0) {
                                l[i].disabled = true;
                                l[i].selected = false;
                            }
                            else {
                                l[i].disabled = false;
                                l[i].selected = true;
                            }
                        }
                        if (teamid > 0) {
                            if (g_phaseTeamComplete[phaseid][teamid] == 0) {
                                l[i].disabled = true;
                                l[i].selected = false;
                            }
                            else {
                                l[i].disabled = false;
                                l[i].selected = true;
                            }
                        }
                    }
                }
            }
        }


        function start() {
            if (g_currentEval == 0) {
                devt.ge('configreport').style.display = 'none';
                devt.ge('PhaseReport1').style.display = 'none';
                devt.ge('ModReport1').style.display = 'none';
                devt.ge('FinReport1').style.display = 'none';
                devt.ge('BiasReport').style.display = 'none';
            }
            else
                validTeams();

            if (g_inProgress)
                markInProgress();

            if (g_report) {
                if (devt.def(g_report.graphs) ) {
                    nreports[g_report.graphs.scripts.start] (g_ModData,'charts');
                }          
            }


            if (doGraphs1) {
                google.charts.load("current", { packages: ['corechart','timeline'] });
                google.charts.setOnLoadCallback(drawAll);
            }

            if (doGraphs6) {
                google.charts.load("current", { packages: ['corechart','timeline'] });
                google.charts.setOnLoadCallback(drawBiasCharts);
            }
            if (doGraphs7) {
                google.charts.load("current", { packages: ['corechart','timeline'] });
                google.charts.setOnLoadCallback(drawDebriefCharts);
            }
        }

    </script>
</head>
<body onload="start()">
    <div id="container">
        <div id='heading'>
            <table>
                <tr>
                    <td></td>
                    <td class='ht'>nVALUATE</td>
                    <td></td>
                </tr>
            </table>
        </div>
        <div id='menu'>
            <div class='d1 sel'>
                <a href='Admin.php'>ADMIN</a>
            </div>
            <div class='d1'>
                <a href='Setup.php?prog=0'>SETUP</a>
            </div>
            <div class='d1'>
                <a href='Run.php?prog=0'>RUN</a>
            </div>
            <div class='d1'>
                <a href='Maintenance.php?prog=0'>MAINTENANCE</a>
            </div>
            <div class='d2'>
                <?php if ($user) echo "<a href='Me.php'>".htmlspecialchars($user['user_name'])."</a>"; else echo "NO NAME";?>
            </div>
            <div class='clear'></div>
        </div>
        <div id='main'>
            <div id="form">
                <h1>REPORT MANAGER</h1>
                <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>">
                    <?php
                    $totNumEvals = $DB->numOfEvaluations();
                    if ((isset($_SESSION['current_evaluation']) && $_SESSION['current_evaluation'] != 0)|| $totNumEvals == 1)
                    {
                        $eval = null;
                        if (isset($_SESSION['current_evaluation']) && $_SESSION['current_evaluation'] != 0)
                            $eval = $DB->getEvaluation($_SESSION['current_evaluation']);
                        else
                            $eval = $DB->getFirstEvaluation();
                        if ($eval)
                        {
                            $evalid=$eval['idevaluation'];
                            $evalname = htmlspecialchars($eval['evaluation_name']);
                            echo "<p>EVALUATION {$evalname}</p>";
                        }
                        else
                            echo "<p>NO AVAILABLE EVALUATIONS</p>";
                        if ($totNumEvals > 1)
                            echo "<input type='submit' name='ChangeEval' value='CHANGE' />";
                    }
                    else
                    if (!isset($_SESSION['current_evaluation']) || $_SESSION['current_evaluation'] == 0)
                    {
                        echo "<p>CHOOSE EVALUATION</p>";
                        echo "<select name='evalid'>";
                        $r = $DB->allEvaluations("order by evaluation_name");
                        while ($eval = $r->fetch_array(MYSQLI_ASSOC))
                        {
                            $v = $FL->encryptParam("eval={$eval['idevaluation']}");
                            $evalname = htmlspecialchars($eval['evaluation_name']);
                            echo "<option value='{$v}'>{$evalname}</option>";
                        }
                        echo "</select>";
                        echo "<input type='submit' name='ChooseEval' value='CHOOSE' />";
                    }
                    ?>
                    <?php echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}' />";?>
                    </form>
                <?php if (strlen($strErr) > 0)
                    {
                      echo "<div id='messagearea'>";
                          echo "<p class='err'>{$strErr}</p>";
                      echo "</div>";
                    }
                ?>
                    <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>">
                        <div id="configreport" class="reportbox">
                            <h2 class="rptbox">CONFIGURATION REPORT</h2>
                            <input type="hidden" name="reportname" value="configreport" />
                            <input type="submit" name="configreport" value="CREATE CONFIGURATION REPORT" />
                        </div>
                     <?php echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}' />";?>
                    </form>
                    <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>">
                    <div id="progressreport" class="reportbox">
                        <h2 class="rptbox">PROGRESS REPORT</h2>
                        <p>Provides a report on scoring progress for all phases, teams and evaluators.</p>
                        <input type="submit" name="progressreport" value="CREATE PROGRESS REPORT" />
                    </div>    
                    <?php echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}' />";?>
                    </form>
                    <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>">
                        <div id="teamreport" class="reportbox">
                            <h2 class="rptbox">TEAM REPORT</h2>
                            <p>SELECT TEAM</p>
                            <select name="whatteam">
                                <?php
                            $r = $DB->allTeamsForEval($evalid);
                            while ($team = $r->fetch_array(MYSQLI_ASSOC))
                            {
                                $v = $FL->encryptParam("team={$team['idteam']},eval={$evalid}");
                                $teamname = htmlspecialchars($team['team_name']);
                                echo "<option value='{$v}'>{$teamname}</option>";
                            }
                                ?>
                            </select>
                            <p>SELECT PHASE</p>
                            <select name="whatphase">
                                <?php
                            $r = $DB->allPhasesForEval($evalid,"order by phase_order");
                            while ($phse = $r->fetch_array(MYSQLI_ASSOC))
                            {
                                $v = $FL->encryptParam("phase={$phse['idphase']},eval={$evalid}");
                                $phasename = htmlspecialchars($phse['phase_name']);
                                echo "<option value='{$v}'>{$phasename}</option>";
                            }

                                ?>
                            </select>
                            <?php echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}' />";?>
                            <br />
                            <input type="hidden" name="reportname" value="teamreport" />
                            <input type="submit" name="teamreport" value="TEAM REPORT" />
                        </div>
                        <?php echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}' />";?>
                    </form>
                    <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>">
                        <div id="PhaseReport1" class="reportbox">
                            <h2 class="rptbox">PHASE REPORTS</h2>
                            <select name="whatphase">
                                <?php
                                $r = $DB->allPhasesForEval($evalid,"order by phase_order");
                                while ($phse = $r->fetch_array(MYSQLI_ASSOC))
                                {
                                    $v = $FL->encryptParam("phase={$phse['idphase']},eval={$evalid}");
                                    $phasename = htmlspecialchars($phse['phase_name']);
                                    echo "<option value='{$v}'>{$phasename}</option>";
                                }
                                ?>
                            </select>
                            <?php echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}' />";?>
                            <br />
                            <input type="hidden" name="reportname" value="phasereport" />
                            <input type="submit" name="phasereport" value="CREATE PHASE REPORT" />
                        </div>
                    </form>
                    <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>">
                        <div class="reportbox" id="BiasReport">
                            <h2 class="rptbox">EVALUATOR BIAS REPORT</h2>
                            <p>This is used only for and after a group phase has been completed.  It attempts to mathmateically look for respondent bias for any evaluator by comparing their scores to others. Bias towards a respondent can be either positive or negative.  The report graphs any bias detected in different bands depicted by colour.</p>
                            <p class="inpt">CHOOSE PHASE</p>
                            <select name="whatphase">
                                <?php
                                $r = $DB->allPhasesForEvalCompleted($evalid,"order by phase_order");
                                while ($phase = $r->fetch_array(MYSQLI_ASSOC))
                                {
                                    if (!$phase['phase_single_score'])
                                    {
                                        $strName = htmlspecialchars(stripslashes($phase['phase_name']));
                                        $v = $FL->encryptParam("phase={$phase['idphase']}");
                                        echo "<option value='{$v}'>{$strName}</option>";
                                    }
                                }
                                ?>
                            </select>
                            <br />
                            <input type="submit" name="biasreport" value="CREATE BIAS REPORT" />
                        </div>
                        <?php echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}' />";?>
                    </form>
                    <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>">
                        <div id="ModReport1" class="reportbox">
                            <h2 class="rptbox">MODERATION REPORTS</h2>
                            <p>This is used after a group phase and creates a report for each evaluator of their scores comapring them to how others also scored.  The report is designed as input for each responder for a moderation workshop.  </p>
                            <?php
                                if (isset($_SESSION['current_evaluation']) && $_SESSION['current_evaluation'] != 0)
                                {
                                    $r10 = $DB->allMultiScorePhasesForEval($_SESSION['current_evaluation']);
                                    $numPhases = $r10->num_rows;
                                    echo "<p class='inpt'>CHOOSE PHASE</p>";
                                    echo "<select id='dwhatphase' name='whatphase' onchange='validTeams(this)'>";
                                    while ($phse = $r10->fetch_array(MYSQLI_ASSOC))
                                    {
                                        $cval = 0;
                                        if ($phse['phase_status'] == 'complete')
                                            $cval = 1;
                                        $v = $FL->encryptParam("phase={$phse['idphase']}");
                                        $phasename = htmlspecialchars($phse['phase_name']);
                                        echo "<option devtval='{$phse['idphase']}' cval='{$cval}' value='{$v}'>{$phasename}</option>";
                                    }
                                    echo "</select>";
                                }
                            ?>
                            <br />
                            <p class="inpt">CHOOSE TEAM</p>
                            <select id="dwhatteam" name="whatteam">
                                <?php
                                if (isset($_SESSION['current_evaluation']) && $_SESSION['current_evaluation'] != 0)
                                {
                                    $v = $FL->encryptParam("team=0");
                                    echo "<option devtval='0' value='{$v}'>ALL TEAMS</option>";
                                    $r11 = $DB->allTeamsForEval($_SESSION['current_evaluation']);
                                    while ($team = $r11->fetch_array(MYSQLI_ASSOC))
                                    {
                                        $v = $FL->encryptParam("team={$team['idteam']}");
                                        $teamname = htmlspecialchars($team['team_name']);
                                        echo "<option devtval='{$team['idteam']}' value='{$v}'>{$teamname}</option>";
                                    }
                                }
                                ?>
                            </select>
                            <br />
                            <?php
                            if (! $global['global_disallow_shared_comments'])
                                {
                                    echo "<div id='modoptions1'>";
                                    echo "<h3>OPTIONS</h3>";
                                    echo "<p class='fmhd'>INCLUDE ALL EVALUATORS' COMMENTS</p>";
                                    echo "<input type='checkbox' name='includeallevals' />";
                                    echo "</div>";
                                }
                            ?>
                            <div id="rangebands">
                                <h2 class="rptbox">SCORE DIFFERENCE COLOUR BANDS</h2>
                                <table>
                                    <tr>
                                        <td colspan="2">BAR IS GREEN AT NO DIFFERENCE THEN</td>
                                    </tr>
                                    <tr>
                                        <td>TURN BAR ORANGE AT</td>
                                        <td>
                                            <input type="text" name="orange" value='20%' size="3" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>TURN BAR RED AT</td>
                                        <td>
                                            <input type="text" name="red" value='40%' size="3" />
                                        </td>
                                    </tr>
                                </table>
                            </div>
                            <input type="hidden" name="reportname" value="modreport" />
                            <input type="submit" name="modreport" value="CREATE MODERATION REPORTS" />
                        </div>
                        <?php echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}' />";?>
                    </form>
                    <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>" onsubmit='inProgress(this)'>
                        <div id="FinReport1" class="reportbox">
                            <h2 class="rptbox">FINAL REPORT</h2>
                            <p>This will create a word document with a complete summary of the evaluation including all phases.</p>
                            <div id="finreport2">
                                <div id="finoptions1">
                                    <h3>OPTIONS</h3>
                                    <p class="fmhd">ANONYMISE EVALUATORS</p>
                                    <input type="checkbox" name="anaoymise" />
                                </div>
                            </div>
                            <input type="submit" name="final" value="GENERATE FINAL REPORT" />
                        </div>
                        <?php echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}' />";?>
                    </form>
                    <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>" onsubmit='inProgress(this)'>
                        <div id="Debrief" class="reportbox">
                            <h2 class="rptbox">RESPONDENT DEBRIEF REPORT</h2>
                            <p>This will create a word document for each respondent outlining a summary of the evaluation and their results.</p>
                            <input type="submit" name="debrief" value="GENERATE DEBRIEF REPORT" />
                        </div>
                        <?php echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}' />";?>
                    </form>
            </div>
            <?php if (strlen($strErr) > 0)
                  {
                      echo "<p class='err'>{$strErr}</p>";
                  }
             ?>
        </div>
        <div id="inprogress">
            <p>REPORT BEING GENERATED</p>
            <p>Once the report(s) have been generated they should appear as a downloded file in you browser.</p>
        </div>
        <div id="charts">
            <?php
            for ($idx = 0; $idx < $numCharts;$idx++)
                echo "<div id='_chart{$idx}'></div>";
            ?>
        </div>
        <div id="allcharts"></div>
    </div>
</body>
</html>